/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.BalanceDataCheck;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.constant.DataCheckConstant;

public class StockTransceiverGatherCheckPlugin
extends BalanceDataCheck {
    private static final String[] balFs = new String[]{"costaccountnumber", "costaccountname", "period", "materialname", "materialnumber", "costaccount", "material", "perioddecimal", "periodinqty", "periodinactualcost", "periodissueqty", "periodissueactualcost", "periodinstandardcost", "periodissuestandardcost"};
    private static final String[] detailFs = new String[]{"costaccountnumber as detailcostaccountnumber", "costaccountname as detailcostaccountname", "period as detailperiod", "materialname as detailmaterialname", "materialnumber as detailmaterialnumber", "costaccount as detailcostaccount", "material as detailmaterial", "detailperiodinqty", "detailperiodinactualamount", "detailperiodinstandardamount", "detailperiodoutqty", "detailperiodoutactualamount", "detailperiodoutstandardamount"};

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        DataSet detailDataSet = this.getCostRecordDataSet(param);
        detailDataSet = detailDataSet.union(this.getCostAdjustDataSet(param));
        detailDataSet = detailDataSet.union(this.getStdCostAdjustDataSet(param));
        HashSet<String> dimFields = new HashSet<String>();
        dimFields.add("costaccount");
        dimFields.add("material");
        dimFields.add("perioddecimal");
        HashSet<String> detailFields = new HashSet<String>();
        detailFields.add("costaccount");
        detailFields.add("costaccountnumber");
        detailFields.add("costaccountname");
        detailFields.add("material");
        detailFields.add("materialname");
        detailFields.add("materialnumber");
        detailFields.add("period");
        detailFields.add("perioddecimal");
        detailDataSet = detailDataSet.updateField("perioddecimal", "INT(perioddecimal)");
        dataSet = dataSet.updateField("perioddecimal", "INT(perioddecimal)");
        detailDataSet = detailDataSet.groupBy(detailFields.toArray(new String[0])).sum("detailperiodinqty").sum("detailperiodinactualamount").sum("detailperiodinstandardamount").sum("detailperiodoutqty").sum("detailperiodoutactualamount").sum("detailperiodoutstandardamount").finish();
        dataSet = dataSet.groupBy(new String[]{"costaccount", "material", "perioddecimal", "costaccountnumber", "costaccountname", "period", "materialname", "materialnumber"}).sum("periodinqty").sum("periodinactualcost").sum("periodissueqty").sum("periodissueactualcost").sum("periodinstandardcost").sum("periodissuestandardcost").finish();
        JoinDataSet verifyDataSet = dataSet.fullJoin(detailDataSet);
        for (String calDimension : dimFields) {
            verifyDataSet = verifyDataSet.on(calDimension, calDimension);
        }
        dataSet = verifyDataSet.select(balFs, detailFs).finish().select(this.selectFileds());
        dataSet = dataSet.filter("NullToZero(periodinqty) <> NullToZero(detailperiodinqty) or NullToZero(periodinactualcost) <> NullToZero(detailperiodinactualamount) or NullToZero(periodissueqty) <> NullToZero(detailperiodoutqty) or NullToZero(periodissueactualcost) <> NullToZero(detailperiodoutactualamount) or NullToZero(periodinstandardcost) <> NullToZero(detailperiodinstandardamount) or NullToZero(periodissuestandardcost) <> NullToZero(detailperiodoutstandardamount)");
        LinkedList<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        for (Row row : dataSet) {
            ExceptionObj exceptionObj = new ExceptionObj(0L, this.getDataEntityType(), this.getExceptionDesc(row, this.getExceptionItem(row), true).toString());
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    private StringBuilder getExceptionItem(Row row) {
        BigDecimal detailData;
        StringBuilder sb = new StringBuilder();
        BigDecimal stockData = row.getBigDecimal("periodinqty") == null ? BigDecimal.ZERO : row.getBigDecimal("periodinqty");
        BigDecimal bigDecimal = detailData = row.getBigDecimal("detailperiodinqty") == null ? BigDecimal.ZERO : row.getBigDecimal("detailperiodinqty");
        if (stockData.compareTo(detailData) != 0) {
            sb.append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u6c47\u603b\u8868\u7684\u6536\u5165\u6570\u91cf\uff1a", (String)"StockTransceiverGatherCheckPlugin_0", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(stockData)).append(DataCheckConstant.SEPERATOR).append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u660e\u7ec6\u8868\u7684\u6536\u5165\u6570\u91cf\uff1a", (String)"StockTransceiverGatherCheckPlugin_1", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(detailData)).append(DataCheckConstant.SEPERATOR);
        }
        stockData = row.getBigDecimal("periodinactualcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodinactualcost");
        BigDecimal bigDecimal2 = detailData = row.getBigDecimal("detailperiodinactualamount") == null ? BigDecimal.ZERO : row.getBigDecimal("detailperiodinactualamount");
        if (stockData.compareTo(detailData) != 0) {
            sb.append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u6c47\u603b\u8868\u7684\u6536\u5165\u5b9e\u9645\u6210\u672c\uff1a", (String)"StockTransceiverGatherCheckPlugin_2", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(stockData)).append(DataCheckConstant.SEPERATOR).append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u660e\u7ec6\u8868\u7684\u6536\u5165\u5b9e\u9645\u6210\u672c\uff1a", (String)"StockTransceiverGatherCheckPlugin_3", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(detailData)).append(DataCheckConstant.SEPERATOR);
        }
        stockData = row.getBigDecimal("periodinstandardcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodinstandardcost");
        BigDecimal bigDecimal3 = detailData = row.getBigDecimal("detailperiodinstandardamount") == null ? BigDecimal.ZERO : row.getBigDecimal("detailperiodinstandardamount");
        if (stockData.compareTo(detailData) != 0) {
            sb.append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u6c47\u603b\u8868\u7684\u6536\u5165\u6807\u51c6\u6210\u672c\uff1a", (String)"StockTransceiverGatherCheckPlugin_8", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(stockData)).append(DataCheckConstant.SEPERATOR).append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u660e\u7ec6\u8868\u7684\u6536\u5165\u6807\u51c6\u6210\u672c\uff1a", (String)"StockTransceiverGatherCheckPlugin_9", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(detailData)).append(DataCheckConstant.SEPERATOR);
        }
        stockData = row.getBigDecimal("periodissueqty") == null ? BigDecimal.ZERO : row.getBigDecimal("periodissueqty");
        BigDecimal bigDecimal4 = detailData = row.getBigDecimal("detailperiodoutqty") == null ? BigDecimal.ZERO : row.getBigDecimal("detailperiodoutqty");
        if (stockData.compareTo(detailData) != 0) {
            sb.append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u6c47\u603b\u8868\u7684\u53d1\u51fa\u6570\u91cf\uff1a", (String)"StockTransceiverGatherCheckPlugin_4", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(stockData)).append(DataCheckConstant.SEPERATOR).append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u660e\u7ec6\u8868\u7684\u53d1\u51fa\u6570\u91cf\uff1a", (String)"StockTransceiverGatherCheckPlugin_5", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(detailData)).append(DataCheckConstant.SEPERATOR);
        }
        stockData = row.getBigDecimal("periodissueactualcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodissueactualcost");
        BigDecimal bigDecimal5 = detailData = row.getBigDecimal("detailperiodoutactualamount") == null ? BigDecimal.ZERO : row.getBigDecimal("detailperiodoutactualamount");
        if (stockData.compareTo(detailData) != 0) {
            sb.append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u6c47\u603b\u8868\u7684\u53d1\u51fa\u5b9e\u9645\u6210\u672c\uff1a", (String)"StockTransceiverGatherCheckPlugin_6", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(stockData)).append(DataCheckConstant.SEPERATOR).append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u660e\u7ec6\u8868\u7684\u53d1\u51fa\u5b9e\u9645\u6210\u672c\uff1a", (String)"StockTransceiverGatherCheckPlugin_7", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(detailData)).append(DataCheckConstant.SEPERATOR);
        }
        stockData = row.getBigDecimal("periodissuestandardcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodissuestandardcost");
        BigDecimal bigDecimal6 = detailData = row.getBigDecimal("detailperiodoutstandardamount") == null ? BigDecimal.ZERO : row.getBigDecimal("detailperiodoutstandardamount");
        if (stockData.compareTo(detailData) != 0) {
            sb.append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u6c47\u603b\u8868\u7684\u53d1\u51fa\u6807\u51c6\u6210\u672c\uff1a", (String)"StockTransceiverGatherCheckPlugin_10", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(stockData)).append(DataCheckConstant.SEPERATOR).append(ResManager.loadKDString((String)"\u5b58\u8d27\u6536\u53d1\u660e\u7ec6\u8868\u7684\u53d1\u51fa\u6807\u51c6\u6210\u672c\uff1a", (String)"StockTransceiverGatherCheckPlugin_11", (String)"fi-cal-business", (Object[])new Object[0])).append(this.bigDecimalToDisplayStr(detailData)).append(DataCheckConstant.SEPERATOR);
        }
        return sb;
    }

    @Override
    protected void addSelectedFields(Set<String> fields) {
        if (this.isNewBalance) {
            String addFieldsStr = "periodinqty,periodinactualcost,periodinstandardcost,periodissueqty,periodissueactualcost,periodissuestandardcost,INT(period * 1) as perioddecimal";
            fields.addAll(Arrays.asList(addFieldsStr.split(",")));
        } else {
            String addFieldsStr = "periodinqty,periodinactualcost,periodinstandardcost,periodissueqty,periodissueactualcost,periodissuestandardcost,TO_INT(period * 1) as perioddecimal";
            fields.addAll(Arrays.asList(addFieldsStr.split(",")));
        }
    }

    private String[] getBalanceFileds() {
        Set<String> dimWithNameFields = this.parser.getBalanceAlias(true, true);
        dimWithNameFields.add("id");
        dimWithNameFields.add("periodinqty");
        dimWithNameFields.add("periodinactualcost");
        dimWithNameFields.add("periodissueqty");
        dimWithNameFields.add("periodissueactualcost");
        dimWithNameFields.add("periodinstandardcost");
        dimWithNameFields.add("periodissuestandardcost");
        return dimWithNameFields.toArray(new String[0]);
    }

    private String detailFileds() {
        StringBuilder fileds = new StringBuilder();
        Set<String> detailFields = this.parser.getDetailAlias(true, true);
        for (String field : detailFields) {
            fileds.append(field).append(" as detail").append(field).append(",");
        }
        return fileds.append("detailperiodinqty,detailperiodinactualamount,detailperiodinstandardamount,detailperiodoutqty,detailperiodoutactualamount,detailperiodoutstandardamount").toString();
    }

    private String selectFileds() {
        StringBuilder fileds = new StringBuilder();
        fileds.append("case when periodinqty is null then detailcostaccount else costaccount end as costaccount,");
        fileds.append("case when periodinqty is null then detailcostaccountnumber else costaccountnumber end as costaccountnumber,");
        fileds.append("case when periodinqty is null then detailcostaccountname else costaccountname end as costaccountname,");
        fileds.append("case when periodinqty is null then detailmaterialname else materialname end as materialname,");
        fileds.append("case when periodinqty is null then detailmaterialnumber else materialnumber end as materialnumber,");
        fileds.append("case when periodinqty is null then detailperiod else period end as period,");
        fileds.append("case when periodinqty is null then detailmaterial else material end as material,");
        fileds.append("periodinqty,");
        fileds.append("periodinactualcost,");
        fileds.append("periodissueqty,");
        fileds.append("periodissueactualcost,");
        fileds.append("periodinstandardcost,");
        fileds.append("periodissuestandardcost,");
        return fileds.append("detailperiodinqty,detailperiodinactualamount,detailperiodinstandardamount,detailperiodoutqty,detailperiodoutactualamount,detailperiodoutstandardamount").toString();
    }

    private DataSet getCostRecordDataSet(DataCheckParam param) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_subentity", (String)this.getCostRecordSelects(), (QFilter[])this.getCostRecordFilter(param), null);
    }

    private QFilter[] getCostRecordFilter(DataCheckParam param) {
        DataEntityDataCheck recordCheck = new DataEntityDataCheck(){

            @Override
            protected String getDataEntityType() {
                return "cal_costrecord_subentity";
            }

            @Override
            protected Set<String> getSelectedFields() {
                return null;
            }

            @Override
            public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
                return null;
            }
        };
        List<QFilter> qFilters = recordCheck.analyseBizRangeFilter(param);
        QFilter q = new QFilter("issplitcreate", "=", (Object)false);
        q.and("isinitbill", "=", (Object)false);
        qFilters.add(q);
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        qFilters.add(billStatusf);
        return qFilters.toArray(new QFilter[0]);
    }

    private DataSet getCostAdjustDataSet(DataCheckParam param) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)this.getCostAdjustSelects(), (QFilter[])this.getCostAdjustFilter(param), null);
    }

    private DataSet getStdCostAdjustDataSet(DataCheckParam param) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stdcostdiffbill", (String)this.getStdAdjustSelects(), (QFilter[])this.getStdAdjustFilter(param), null);
    }

    private QFilter[] getCostAdjustFilter(DataCheckParam param) {
        DataEntityDataCheck recordCheck = new DataEntityDataCheck(){

            @Override
            protected String getDataEntityType() {
                return "cal_costadjust_subentity";
            }

            @Override
            protected Set<String> getSelectedFields() {
                return null;
            }

            @Override
            public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
                return null;
            }
        };
        List<QFilter> qFilterList = recordCheck.analyseBizRangeFilter(param);
        QFilter q = new QFilter("billstatus", "=", (Object)"C");
        q.and("isupdatecost", "=", (Object)"1");
        q.and("difftype", "=", (Object)"B");
        qFilterList.add(q);
        return qFilterList.toArray(new QFilter[0]);
    }

    private String getCostRecordSelects() {
        return this.parser.getDetailDimFieldsAndBaseNumberName("cal_costrecord_subentity", "entry") + "case when calbilltype = 'IN' then entry.baseqty else 0 end as detailperiodinqty,case when (calbilltype = 'IN' and entry.accounttype <> 'D') then entry.actualcost when (calbilltype = 'IN' and entry.accounttype = 'D') then entry.standardcost else 0 end as detailperiodinactualamount,case when calbilltype = 'IN' then entry.standardcost else 0 end as detailperiodinstandardamount,case when calbilltype = 'OUT' then entry.baseqty else 0 end as detailperiodoutqty,case when (calbilltype = 'OUT' and entry.accounttype <> 'D') then entry.actualcost when (calbilltype = 'OUT' and entry.accounttype = 'D') then entry.standardcost else 0 end as detailperiodoutactualamount,case when calbilltype = 'OUT' then entry.standardcost else 0 end as detailperiodoutstandardamount,id as billid,TO_INT(period.periodyear*100+period.periodnumber) as perioddecimal,period,calorg,calorg.number as calorgnumber,calorg.name as calorgname";
    }

    private String getCostAdjustSelects() {
        return this.parser.getDetailDimFieldsAndBaseNumberName("cal_costadjust_subentity", "entryentity") + "0 as detailperiodinqty,case when biztype = 'A' and ((entryentity.accounttype <> 'D' and difftype = 'B') or (entryentity.accounttype = 'D' and difftype <> 'B' and createtype <> 'C1')) then entryentity.adjustamt else 0 end as detailperiodinactualamount,case when createtype ='C1' and biztype = 'A' and difftype='M' then 0-entryentity.adjustamt else 0 end as detailperiodinstandardamount,0 as detailperiodoutqty,case when biztype = 'B' and ((entryentity.accounttype <> 'D' and difftype = 'B') or (entryentity.accounttype = 'D' and difftype <> 'B' and createtype <> 'C1')) then entryentity.adjustamt else 0 end as detailperiodoutactualamount,case when createtype ='C1' and biztype = 'B' and difftype='M' then 0-entryentity.adjustamt else 0 end as detailperiodoutstandardamount,id as billid,TO_INT(period.periodyear*100+period.periodnumber) as perioddecimal,period,calorg,calorg.number as calorgnumber,calorg.name as calorgname";
    }

    private QFilter[] getStdAdjustFilter(DataCheckParam param) {
        DataEntityDataCheck recordCheck = new DataEntityDataCheck(){

            @Override
            protected String getDataEntityType() {
                return "cal_stdcostdiffbill";
            }

            @Override
            protected Set<String> getSelectedFields() {
                return null;
            }

            @Override
            public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
                return null;
            }
        };
        List<QFilter> qFilterList = recordCheck.analyseBizRangeFilter(param);
        QFilter q = new QFilter("billstatus", "=", (Object)"C");
        q.and("isupdatecost", "=", (Object)"1");
        qFilterList.add(q);
        return qFilterList.toArray(new QFilter[0]);
    }

    private String getStdAdjustSelects() {
        return this.parser.getDetailDimFieldsAndBaseNumberName("cal_stdcostdiffbill", "entryentity") + "0 as detailperiodinqty,case when biztype = 'A' and createtype <> 'C1' then entryentity.adjustamt else 0 end as detailperiodinactualamount,case when createtype ='C1' and biztype = 'A'  then 0-entryentity.diff_m else 0 end as detailperiodinstandardamount,0 as detailperiodoutqty,case when biztype = 'B' and entryentity.accounttype = 'D' and createtype <> 'C1' then entryentity.adjustamt else 0 end as detailperiodoutactualamount,case when createtype ='C1' and biztype = 'B' then 0-entryentity.diff_m when createtype = 'G' then entryentity.adjustamt else 0 end as detailperiodoutstandardamount,id as billid,TO_INT(period.periodyear*100+period.periodnumber) as perioddecimal,period,calorg,calorg.number as calorgnumber,calorg.name as calorgname";
    }

    private String bigDecimalToDisplayStr(BigDecimal decimal) {
        return decimal.stripTrailingZeros().toPlainString();
    }
}

