/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.VoucherBaseDataCheck;

public class Voucher4ProvBillDataCheck
extends VoucherBaseDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        LinkedList<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        Map<Long, DynamicObject> accountPeriodMap = this.getAccountPeriodMapByParam(param);
        if (accountPeriodMap == null || accountPeriodMap.isEmpty()) {
            return exceptionObjs;
        }
        ArrayList<OrmInput> allAccountIOs = new ArrayList<OrmInput>(accountPeriodMap.size());
        for (Map.Entry<Long, DynamicObject> accountEntry : accountPeriodMap.entrySet()) {
            Long costAccountId = accountEntry.getKey();
            DynamicObject period = accountEntry.getValue();
            QFilter fallPriceQ = this.getCommonDateFilter(costAccountId, period, "bookdate");
            fallPriceQ.and("billstatus", "=", (Object)"C");
            OrmInput accountIO = new OrmInput(this.getClass().getName(), "cal_price_provbill", "id,billno,costaccount.number as accountnum,org.number as orgnum", new QFilter[]{fallPriceQ});
            allAccountIOs.add(accountIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet dataSet = algo.createDataSet((Input[])allAccountIOs.toArray(new OrmInput[allAccountIOs.size()]));
        dataSet = dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
        HashSet<Long> provBillSet = new HashSet<Long>(16);
        for (Object row : dataSet.copy()) {
            Long billid = row.getLong("id");
            provBillSet.add(billid);
        }
        if (provBillSet.isEmpty()) {
            return exceptionObjs;
        }
        DynamicObjectCollection daps = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter("sourcebillid", "in", provBillSet).toArray());
        for (DynamicObject dap : daps) {
            provBillSet.remove(dap.getLong("sourcebillid"));
        }
        String errorMessage = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7 \uff1a%1$s\uff1b\u6210\u672c\u8d26\u7c3f\uff1a%2$s\uff1b\u5355\u636e\u7f16\u53f7\uff1a%3$s", (String)"VoucherBaseDataCheck_1", (String)"fi-cal-business", (Object[])new Object[0]);
        for (Row row : dataSet) {
            Long billId = row.getLong("id");
            if (!provBillSet.contains(billId)) continue;
            ExceptionObj exceptionObj = new ExceptionObj(billId, "cal_price_provbill");
            exceptionObj.setDescription(String.format(errorMessage, row.getString("orgnum"), row.getString("accountnum"), row.getString("billno")));
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }
}

