/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.VoucherBaseDataCheck;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;

public class Voucher4PurBeginBackDataCheck
extends VoucherBaseDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        LinkedList<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        Map<Long, DynamicObject> accountPeriodMap = this.getAccountPeriodMapByParam(param);
        if (accountPeriodMap == null || accountPeriodMap.isEmpty()) {
            return exceptionObjs;
        }
        Set purBills = CommonSettingHelper.getBizEntityNumbers((String)"purbiztype");
        purBills.addAll(CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype"));
        QFilter purQFilter = new QFilter("bizentityobject", "in", (Object)purBills);
        ArrayList<OrmInput> allAccountIOs = new ArrayList<OrmInput>(accountPeriodMap.size());
        for (Map.Entry<Long, DynamicObject> accountEntry : accountPeriodMap.entrySet()) {
            Long costAccountId = accountEntry.getKey();
            DynamicObject period = accountEntry.getValue();
            QFilter bizQFilter = new QFilter("dischargetype", "in", (Object)new String[]{DischargeTypeEnum.BEGINPERIODCLEAR.getValue()});
            bizQFilter.and("isinitbill", "=", (Object)Boolean.TRUE);
            bizQFilter.and("billstatus", "=", (Object)"C");
            bizQFilter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            bizQFilter.and("costaccount", "=", (Object)costAccountId);
            bizQFilter.and("period", "=", (Object)period.getLong("id"));
            bizQFilter.and("entry.actualcost", "!=", (Object)BigDecimal.ZERO);
            OrmInput accountIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", "id,billno,costaccount.number as accountnum,calorg.number as orgnum", new QFilter[]{purQFilter, bizQFilter});
            allAccountIOs.add(accountIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet recordDataSet = algo.createDataSet((Input[])allAccountIOs.toArray(new OrmInput[allAccountIOs.size()]));
        Set<Long> noVoucherIdSet = this.filterNoVoucherRecord((recordDataSet = recordDataSet.groupBy(recordDataSet.getRowMeta().getFieldNames()).finish()).copy(), "C");
        if (noVoucherIdSet.isEmpty()) {
            return exceptionObjs;
        }
        String errorMessage = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7 \uff1a%1$s\uff1b\u6210\u672c\u8d26\u7c3f\uff1a%2$s\uff1b\u5355\u636e\u7f16\u53f7\uff1a%3$s", (String)"VoucherBaseDataCheck_1", (String)"fi-cal-business", (Object[])new Object[0]);
        for (Row row : recordDataSet) {
            Long recordId = row.getLong("id");
            if (!noVoucherIdSet.contains(recordId)) continue;
            ExceptionObj exceptionObj = new ExceptionObj(recordId, "cal_costrecord_subentity");
            exceptionObj.setDescription(String.format(errorMessage, row.getString("orgnum"), row.getString("accountnum"), row.getString("billno")));
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    @Override
    protected QFilter getBizQFilter() {
        return null;
    }

    @Override
    protected String getCheckVoucherType() {
        return "C";
    }
}

