/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.datacheck.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.ExceptionObj;
import kd.fi.cal.business.datacheck.item.DataEntityDataCheck;
import kd.fi.cal.common.helper.PeriodHelper;

public class VoucherBaseDataCheck
extends DataEntityDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(DataCheckParam param) {
        LinkedList<ExceptionObj> exceptionObjs = new LinkedList<ExceptionObj>();
        Map<Long, DynamicObject> accountPeriodMap = this.getAccountPeriodMapByParam(param);
        if (accountPeriodMap == null || accountPeriodMap.isEmpty()) {
            return exceptionObjs;
        }
        QFilter bizQFilter = this.getBizQFilter();
        ArrayList<OrmInput> allAccountIOs = new ArrayList<OrmInput>(accountPeriodMap.size());
        for (Map.Entry<Long, DynamicObject> accountEntry : accountPeriodMap.entrySet()) {
            Long costAccountId = accountEntry.getKey();
            DynamicObject period = accountEntry.getValue();
            QFilter dateAndAccountQ = this.getCommonDateFilter(costAccountId, period, this.getDateName());
            OrmInput accountIO = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", "id,billno,costaccount.number as accountnum,calorg.number as orgnum", new QFilter[]{dateAndAccountQ, bizQFilter});
            allAccountIOs.add(accountIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet recordDataSet = algo.createDataSet((Input[])allAccountIOs.toArray(new OrmInput[allAccountIOs.size()]));
        Set<Long> noVoucherIdSet = this.filterNoVoucherRecord((recordDataSet = recordDataSet.groupBy(recordDataSet.getRowMeta().getFieldNames()).finish()).copy(), this.getCheckVoucherType());
        if (noVoucherIdSet.isEmpty()) {
            return exceptionObjs;
        }
        String errorMessage = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7 \uff1a%1$s\uff1b\u6210\u672c\u8d26\u7c3f\uff1a%2$s\uff1b\u5355\u636e\u7f16\u53f7\uff1a%3$s", (String)"VoucherBaseDataCheck_1", (String)"fi-cal-business", (Object[])new Object[0]);
        for (Row row : recordDataSet) {
            Long recordId = row.getLong("id");
            if (!noVoucherIdSet.contains(recordId)) continue;
            ExceptionObj exceptionObj = new ExceptionObj(recordId, "cal_costrecord_subentity");
            exceptionObj.setDescription(String.format(errorMessage, row.getString("orgnum"), row.getString("accountnum"), row.getString("billno")));
            exceptionObjs.add(exceptionObj);
        }
        return exceptionObjs;
    }

    protected QFilter getCommonDateFilter(Long costAccountId, DynamicObject currentPeriod, String dateName) {
        Date beginDate = currentPeriod.getDate("begindate");
        Date endDate = currentPeriod.getDate("enddate");
        QFilter q = new QFilter(dateName, ">=", (Object)beginDate);
        q.and(dateName, "<=", (Object)endDate);
        q.and("costaccount", "=", (Object)costAccountId);
        return q;
    }

    protected Set<Long> filterNoVoucherRecord(DataSet dataSet, String voucherType) {
        HashSet<Long> costRecordIdSet = new HashSet<Long>();
        for (Row row : dataSet) {
            costRecordIdSet.add(row.getLong("id"));
        }
        if (costRecordIdSet.isEmpty()) {
            return costRecordIdSet;
        }
        if (voucherType != null) {
            QFilter q = new QFilter("vouchertype", "=", (Object)voucherType);
            q.and("costrecordid", "in", costRecordIdSet);
            DynamicObjectCollection voucherColl = QueryServiceHelper.query((String)"cal_voucher", (String)"id,costrecordid,voucherid", (QFilter[])new QFilter[]{q});
            for (DynamicObject info : voucherColl) {
                costRecordIdSet.remove(info.getLong("costrecordid"));
            }
        }
        return costRecordIdSet;
    }

    protected Map<Long, DynamicObject> getAccountPeriodMapByParam(DataCheckParam param) {
        Set<Long> accountIdSet = this.getCostAccountIdSet(param);
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            return null;
        }
        return PeriodHelper.getCurrentPeriods(accountIdSet);
    }

    private Set<Long> getCostAccountIdSet(DataCheckParam param) {
        Set<Long> accountIdSet = param.getCostAccount();
        Set<Long> orgIdSet = param.getCalorg();
        if (accountIdSet == null || accountIdSet.isEmpty()) {
            QFilter accountQ = new QFilter("enable", "=", (Object)"1");
            if (orgIdSet != null && !orgIdSet.isEmpty()) {
                accountQ.and("calorg", "in", orgIdSet);
            }
            DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])accountQ.toArray());
            accountIdSet = new HashSet<Long>(16);
            for (DynamicObject costAccount : costAccounts) {
                accountIdSet.add(costAccount.getLong("id"));
            }
        }
        return accountIdSet;
    }

    protected String getDateName() {
        return null;
    }

    protected QFilter getBizQFilter() {
        return null;
    }

    protected String getCheckVoucherType() {
        return null;
    }

    @Override
    protected String getDataEntityType() {
        return "cal_costrecord_subentity";
    }

    @Override
    protected Set<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<ExceptionObj> collectExceptionObj(DataSet dataSet, DataCheckParam param) {
        return null;
    }
}

