/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.executeitems;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskExecutor;
import kd.fi.cal.business.datacheck.DataCheckTaskFactory;
import kd.fi.cal.business.executeitems.itask.ICalcSettleRefTask;
import kd.fi.cal.business.executeitems.model.CalcSettleContext;
import kd.fi.cal.business.executeitems.model.CalcSettleEnum;
import kd.fi.cal.business.executeitems.model.CalcSettleResult;
import kd.fi.cal.business.executeitems.model.SettleJumpPage;
import kd.fi.cal.common.util.CommonUtils;

public class BoundCalcDataCheckTask
implements ICalcSettleRefTask {
    @Override
    public String doExecute(String context) {
        Long planId = ID.genLongId();
        CalcSettleContext settleContext = (CalcSettleContext)JSON.parseObject((String)context, CalcSettleContext.class);
        CalcSettleResult result = new CalcSettleResult();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int permission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)settleContext.getOrgId(), (String)"/KIUHEXROK3D", (String)"cal_out_calculate", (String)"4730fc9f000025ae");
        if (permission <= 0) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
            result.setRemark(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u51fa\u5e93\u6838\u7b97\u8ba1\u7b97\u6743\u9650", (String)"BoundCalcDataCheckTask_4", (String)"fi-cal-business", (Object[])new Object[0]));
            return JSON.toJSONString((Object)result);
        }
        DataSet calOrgSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)settleContext.getOrgId()).toArray(), null);
        DataSet costAccountSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)settleContext.getCostaccountId()).toArray(), null);
        DataCheckTaskExecutor executor = new DataCheckTaskExecutor();
        DataCheckParam param = new DataCheckParam();
        param.setCalorg(Sets.newHashSet((Object[])new Long[]{settleContext.getOrgId()}));
        param.setCostAccount(Sets.newHashSet((Object[])new Long[]{settleContext.getCostaccountId()}));
        DataCheckTask task = DataCheckTaskFactory.createDataCheckTask(1228995490352290816L);
        task.setPlanId(planId);
        task.setPlanType("cal_datacheck_task");
        task.setCalorg(this.getNamesString(calOrgSet));
        task.setCostaccount(this.getNamesString(costAccountSet));
        task.setPurpose("D");
        executor.commitSync(task, param);
        String flag = this.getCheckStatus(planId);
        if ("true".equals(flag)) {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_SUCC.getValue());
            result.setRemark(ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7\u3002", (String)"BoundCalcDataCheckTask_1", (String)"fi-cal-business", (Object[])new Object[0]));
        } else {
            result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
            result.setRemark(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u524d\u68c0\u67e5\u9879\u4e0d\u901a\u8fc7\uff0c\u8bf7\u8054\u67e5\u62a5\u544a\u67e5\u770b\u7ed3\u679c\u3002", (String)"BoundCalcDataCheckTask_2", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("checkplan", "=", (Object)planId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_datacheck_result", (String)"id", (QFilter[])new QFilter[]{qFilter});
        ArrayList<SettleJumpPage> jumpPages = new ArrayList<SettleJumpPage>(10);
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c\u8be6\u60c5", (String)"BoundCalcDataCheckTask_3", (String)"fi-cal-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_BILL.getValue());
        page.setSourcepage("cal_datacheck_result");
        HashMap<String, Object> customParam = new HashMap<String, Object>(10);
        if (dynamicObject != null) {
            customParam.put("id", dynamicObject.getLong("id"));
        }
        page.setParam(customParam);
        jumpPages.add(page);
        result.setJumpPages(jumpPages);
        return JSON.toJSONString((Object)result);
    }

    @Override
    public String getSourcePageParam(String context) {
        return null;
    }

    private String getNamesString(DataSet dataSet) {
        StringBuilder names = new StringBuilder();
        for (Row row : dataSet) {
            names.append(row.getString("name"));
            names.append(',');
        }
        String nameString = CommonUtils.trimComma((String)names.toString());
        if (nameString.length() > 254) {
            nameString = nameString.substring(0, 254);
            return CommonUtils.trimComma((String)nameString);
        }
        return nameString;
    }

    private String getCheckStatus(Long reportId) {
        String flag = "true";
        QFilter q = new QFilter("checkplan", "=", (Object)reportId);
        DataSet checkResultDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_datacheck_result", (String)"id,entryentity.entrystatus", (QFilter[])q.toArray(), null);
        for (Row row : checkResultDataSet) {
            String status = row.getString("entryentity.entrystatus");
            if (!"B".equals(status)) continue;
            flag = "false";
            break;
        }
        return flag;
    }
}

