/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.executeitems;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.business.account.CloseAccountFacade;
import kd.fi.cal.business.account.CloseAccountParamBuilder;
import kd.fi.cal.business.executeitems.itask.ICalcSettleRefTask;
import kd.fi.cal.business.executeitems.model.CalcSettleContext;
import kd.fi.cal.business.executeitems.model.CalcSettleEnum;
import kd.fi.cal.business.executeitems.model.CalcSettleResult;
import kd.fi.cal.business.executeitems.model.SettleJumpPage;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CloseAccountParam;
import kd.fi.cal.common.util.DateUtils;

public class CloseAccountTask
implements ICalcSettleRefTask {
    private static final Log logger = LogFactory.getLog(CloseAccountTask.class);

    @Override
    public String doExecute(String context) {
        CalcSettleContext settleContext = (CalcSettleContext)JSON.parseObject((String)context, CalcSettleContext.class);
        CloseAccountParam[] params = this.buildCloseParam(settleContext);
        CalcSettleResult result = new CalcSettleResult();
        result.setConfirm(false);
        if (params.length > 0) {
            List<SettleJumpPage> jumpPages = this.getPages(params);
            result.setJumpPages(jumpPages);
            long userId = Long.parseLong(RequestContext.get().getUserId());
            int permission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)settleContext.getOrgId(), (String)"/KIUHEXROK3D", (String)"cal_closeaccount", (String)"/O6GR+6VXPQ2");
            if (permission <= 0) {
                result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                result.setRemark(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u5173\u8d26\u6743\u9650", (String)"CloseAccountAndDataCheckTask_7", (String)"fi-cal-business", (Object[])new Object[0]));
                return JSON.toJSONString((Object)result);
            }
            for (CloseAccountParam param : params) {
                if (param.getLastCloseDate() == null || param.getLastCloseDate().before(param.getCloseDate())) continue;
                result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                result.setRemark(String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u3010%1$s\u3011\u5df2\u5173\u8d26", (String)"CloseAccountAndDataCheckTask_1", (String)"fi-cal-business", (Object[])new Object[0]), param.getOwner().getString("name")));
                return JSON.toJSONString((Object)result);
            }
            Date now = new Date();
            Map<Long, String> failMap = new CloseAccountFacade().doCloseAccount(params);
            if (!failMap.isEmpty()) {
                result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                StringJoiner stringJoiner = new StringJoiner(";");
                for (Map.Entry entry : failMap.entrySet()) {
                    String value = (String)entry.getValue();
                    stringJoiner.add(value);
                }
                result.setRemark(stringJoiner.toString());
                return JSON.toJSONString((Object)result);
            }
            boolean flag = true;
            block4: while (flag) {
                HashSet<Long> ownerIds = new HashSet<Long>(16);
                HashSet<Date> hashSet = new HashSet<Date>(16);
                for (CloseAccountParam param : params) {
                    ownerIds.add(param.getOwnerid());
                    hashSet.add(param.getCloseDate());
                }
                QFilter qFilter = new QFilter("owner", "in", ownerIds);
                qFilter.and("expectdate", "in", hashSet);
                qFilter.and("closetype", "=", (Object)"A");
                qFilter.and("operationtime", ">", (Object)now);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_closeaccountlog", (String)"checkresult,success", (QFilter[])new QFilter[]{qFilter});
                if (dynamicObjects == null) {
                    result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                    result.setRemark(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5173\u8d26\u65e5\u5fd7\u3002", (String)"CloseAccountAndDataCheckTask_2", (String)"fi-cal-business", (Object[])new Object[0]));
                    break;
                }
                String checkResult = ResManager.loadKDString((String)"\u8be6\u60c5", (String)"CloseAccountAndDataCheckTask_3", (String)"fi-cal-business", (Object[])new Object[0]);
                int size = 0;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (dynamicObject.getString("checkresult").contains(checkResult)) {
                        ++size;
                        if (dynamicObject.getBoolean("success")) {
                            if (size != dynamicObjects.size()) continue block4;
                            result.setStatus(CalcSettleEnum.SETTLESTATUS_SUCC.getValue());
                            result.setRemark(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"CloseAccountAndDataCheckTask_4", (String)"fi-cal-business", (Object[])new Object[0]));
                            flag = false;
                            continue block4;
                        }
                        result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                        result.setRemark(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8054\u67e5\u5173\u8d26\u65e5\u5fd7\u3002", (String)"CloseAccountAndDataCheckTask_5", (String)"fi-cal-business", (Object[])new Object[0]));
                        flag = false;
                        continue block4;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        WriteLogHelper.writeErrorLog((Log)logger, (String)"CloseAccountTask-doExecute", (Throwable)e);
                    }
                }
            }
        }
        return JSON.toJSONString((Object)result);
    }

    private List<SettleJumpPage> getPages(CloseAccountParam[] param) {
        HashSet<Long> ids = new HashSet<Long>(16);
        HashMap<String, String> calOrgIdNameMap = new HashMap<String, String>(16);
        for (CloseAccountParam closeAccountParam : param) {
            ids.add(closeAccountParam.getOwner().getLong("id"));
            calOrgIdNameMap.put(closeAccountParam.getOwner().getString("id"), closeAccountParam.getOwner().getString("name"));
        }
        ArrayList<SettleJumpPage> jumpPages = new ArrayList<SettleJumpPage>(10);
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u5173\u8d26\u65e5\u5fd7\u5217\u8868", (String)"CloseAccountAndDataCheckTask_6", (String)"fi-cal-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        page.setSourcepage("cal_closeaccountlog");
        HashMap<String, Object> customParam = new HashMap<String, Object>(10);
        QFilter q = new QFilter("owner", "in", ids);
        customParam.put("filter", q.toString());
        customParam.put("calorg", calOrgIdNameMap);
        page.setParam(customParam);
        jumpPages.add(page);
        return jumpPages;
    }

    @Override
    public String getSourcePageParam(String context) {
        CalcSettleContext settleContext = (CalcSettleContext)JSON.parseObject((String)context, CalcSettleContext.class);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_accountingsys", (String)"bizorgentry.bizorg as ownerid,bizorgentry.bizorg.name name", (QFilter[])new QFilter[]{new QFilter("bizorgentry.bizacctorg", "=", (Object)settleContext.getOrgId())});
        HashMap<String, String> calOrgIdNameMap = new HashMap<String, String>(16);
        calOrgIdNameMap.put(dynamicObject.getString("ownerid"), dynamicObject.getString("name"));
        ArrayList<SettleJumpPage> jumpPages = new ArrayList<SettleJumpPage>(10);
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u5173\u8d26\u65e5\u5fd7\u5217\u8868", (String)"CloseAccountAndDataCheckTask_6", (String)"fi-cal-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        page.setSourcepage("cal_closeaccountlog");
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        QFilter q = new QFilter("owner", "=", (Object)dynamicObject.getLong("ownerid"));
        param.put("filter", q.toString());
        param.put("calorg", calOrgIdNameMap);
        page.setParam(param);
        jumpPages.add(page);
        return JSON.toJSONString(jumpPages);
    }

    private CloseAccountParam[] buildCloseParam(CalcSettleContext settleContext) {
        ArrayList<CloseAccountParam> list = new ArrayList<CloseAccountParam>(16);
        QFilter filter = new QFilter("purpose", "=", (Object)"C");
        filter.and("entryentity.entryenable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_datacheck_task", (String)"purpose,entryentity.checkitem id,entryentity.level level", (QFilter[])new QFilter[]{filter});
        HashMap<String, HashMap<Object, String>> allCheckItemMap = new HashMap<String, HashMap<Object, String>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long itemId = dynamicObject.getLong("id");
            String level = dynamicObject.getString("level");
            String purpose = dynamicObject.getString("purpose");
            HashMap<Object, String> checkItemMap = (HashMap<Object, String>)allCheckItemMap.get(purpose);
            if (checkItemMap == null) {
                checkItemMap = new HashMap<Object, String>(16);
            }
            checkItemMap.put(itemId, level);
            allCheckItemMap.put(purpose, checkItemMap);
        }
        QFilter ownerFilter = new QFilter("bizorgentry.bizacctorg", "=", (Object)settleContext.getOrgId());
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_accountingsys", (String)"bizorgentry.bizorg as ownerid", (QFilter[])new QFilter[]{ownerFilter});
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            CloseAccountParam param = new CloseAccountParam();
            DynamicObject ownerDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)dynamicObject.getLong("ownerid"), (String)"bos_org");
            Map<Long, Date> calOrgIdCurPeriodMaxEndDateMap = CloseAccountParamBuilder.getCalOrgCurPeriodMaxEndDateMap(Sets.newHashSet((Object[])new Long[]{settleContext.getOrgId()}));
            Map<Long, DynamicObject> lastCloseAcctDycMap = CloseAccountParamBuilder.getOwnerIdLastCloseAcctDycMap(Sets.newHashSet((Object[])new Long[]{ownerDyo.getLong("id")}));
            DynamicObject info = lastCloseAcctDycMap.get(ownerDyo.getLong("id"));
            Date maxEndDate = calOrgIdCurPeriodMaxEndDateMap.get(settleContext.getOrgId());
            param.setCheckItems(allCheckItemMap);
            param.setOwner(ownerDyo);
            param.setCloseDate(DateUtils.getDayStartTime((Date)maxEndDate));
            param.setLastCloseDate(info == null ? null : info.getDate("closedate"));
            param.setOwnerId(ownerDyo.getLong("id"));
            list.add(param);
        }
        CloseAccountParam[] array = list.toArray(new CloseAccountParam[list.size()]);
        return array;
    }
}

