/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.executeitems;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.business.executeitems.itask.ICalcSettleRefTask;
import kd.fi.cal.business.executeitems.model.CalcSettleContext;
import kd.fi.cal.business.executeitems.model.CalcSettleEnum;
import kd.fi.cal.business.executeitems.model.CalcSettleResult;
import kd.fi.cal.business.executeitems.model.SettleJumpPage;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.SimpleSettleAccountParam;

public class SettleAccountsTask
implements ICalcSettleRefTask {
    private static final Log logger = LogFactory.getLog(SettleAccountsTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doExecute(String context) {
        CalcSettleResult result;
        block16: {
            result = new CalcSettleResult();
            CalcSettleContext settleContext = (CalcSettleContext)JSON.parseObject((String)context, CalcSettleContext.class);
            List<SettleJumpPage> jumpPages = this.getPages(settleContext);
            result.setJumpPages(jumpPages);
            ArrayList<DLock> lockList = new ArrayList<DLock>(16);
            try {
                DynamicObject dynamicObject;
                long userId = Long.parseLong(RequestContext.get().getUserId());
                int permission = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)settleContext.getOrgId(), (String)"/KIUHEXROK3D", (String)"cal_settleaccount", (String)"4730fc9f000001ae");
                if (permission <= 0) {
                    result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                    result.setRemark(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ed3\u8d26\u6743\u9650", (String)"SettleAccountsTask_8", (String)"fi-cal-business", (Object[])new Object[0]));
                    String string = JSON.toJSONString((Object)result);
                    return string;
                }
                String lockId = "doBizService_SettleAccount" + settleContext.getCostaccountId();
                DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u7ed3\u8d26\u9501", (String)"SettleAccountsTask_1", (String)"fi-cal-business", (Object[])new Object[0]));
                if (!lock.tryLock()) {
                    DynamicObject dynamicObject2 = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)settleContext.getCostaccountId())});
                    String msgStr = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c\u7ed3\u8d26\uff0c\u8bf7\u7a0d\u540e", (String)"SettleAccountsTask_2", (String)"fi-cal-business", (Object[])new Object[0]), dynamicObject2.getString("name"));
                    result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                    result.setRemark(msgStr);
                    String string = JSON.toJSONString((Object)result);
                    return string;
                }
                lockList.add(lock);
                SimpleSettleAccountParam param = this.buildSettleParam(settleContext);
                Date now = new Date();
                this.executeSettle(param);
                int i = 0;
                while (true) {
                    String log;
                    QFilter filter = new QFilter("costaccount", "=", (Object)settleContext.getCostaccountId());
                    filter.and("operationtime", ">", (Object)now);
                    dynamicObject = QueryServiceHelper.queryOne((String)"cal_settleaccountlog", (String)"log,success", (QFilter[])new QFilter[]{filter});
                    if (dynamicObject == null) {
                        ++i;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            WriteLogHelper.writeErrorLog((Log)logger, (String)"SettleAccountsTask-doExecute1", (Throwable)e);
                        }
                        if (i <= 10) continue;
                        result.setStatus(CalcSettleEnum.SETTLESTATUS_CONFIRM.getValue());
                        result.setRemark(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7ed3\u8d26\u65e5\u5fd7\uff0c\u8bf7\u624b\u5de5\u786e\u8ba4\u3002", (String)"SettleAccountsTask_3", (String)"fi-cal-business", (Object[])new Object[0]));
                        break block16;
                    }
                    String checkResult = ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"SettleAccountsTask_4", (String)"fi-cal-business", (Object[])new Object[0]);
                    if (!checkResult.contains(log = dynamicObject.getString("log")) || "".equals(log)) break;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        WriteLogHelper.writeErrorLog((Log)logger, (String)"SettleAccountsTask-doExecute2", (Throwable)e);
                    }
                }
                String calStatus = dynamicObject.getBoolean("success") ? CalcSettleEnum.SETTLESTATUS_SUCC.getValue() : CalcSettleEnum.SETTLESTATUS_FAIL.getValue();
                result.setStatus(calStatus);
            }
            catch (Exception e) {
                logger.info("SettleAccountsTask Exception ==>{}", (Object)e);
                result.setStatus(CalcSettleEnum.SETTLESTATUS_FAIL.getValue());
                result.setRemark(ResManager.loadKDString((String)"\u7ed3\u8d26\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002", (String)"SettleAccountsTask_5", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            finally {
                for (DLock lock : lockList) {
                    if (lock == null) continue;
                    lock.close();
                }
            }
        }
        return JSON.toJSONString((Object)result);
    }

    private void executeSettle(SimpleSettleAccountParam param) {
        HashMap<String, Object> jobParams = new HashMap<String, Object>(16);
        try {
            jobParams.put("param", JSONUtils.toString((Object)param));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        jobParams.put("isSettle", true);
        jobParams.put("backgroundInvoke", false);
        JobInfo job = new JobInfo();
        String OpName = String.format(ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97\u7ed3\u8d26-\u6210\u672c\u8d26\u7c3f\u7f16\u7801:%1$s,\u6210\u672c\u8d26\u7c3f\u540d\u79f0:%2$s,\u671f\u95f4%3$s\u7ed3\u8d26\u5230%4$s", (String)"SettleAccountsTask_6", (String)"fi-cal-business", (Object[])new Object[0]), param.getCostAccountNum(), param.getCostAccountName(), param.getCurrentPeriodNum(), param.getNextPeriodNum());
        job.setName(OpName);
        job.setTaskDefineId("2TEDX/U6F3VT");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setTaskClassname("kd.fi.cal.formplugin.account.SettleAccountTask");
        job.setRunByLang(Lang.get());
        JobClient.dispatch((JobInfo)job);
    }

    private SimpleSettleAccountParam buildSettleParam(CalcSettleContext settleContext) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)settleContext.getCostaccountId())});
        QFilter filter = new QFilter("purpose", "=", (Object)"B");
        filter.and("entryentity.entryenable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_datacheck_task", (String)"purpose,entryentity.checkitem id,entryentity.level level", (QFilter[])new QFilter[]{filter});
        HashMap<String, HashMap<Long, String>> allCheckItemMap = new HashMap<String, HashMap<Long, String>>(16);
        for (DynamicObject dyo : dynamicObjects) {
            Long itemId = dyo.getLong("id");
            String level = dyo.getString("level");
            String purpose = dyo.getString("purpose");
            HashMap<Long, String> checkItemMap = (HashMap<Long, String>)allCheckItemMap.get(purpose);
            if (checkItemMap == null) {
                checkItemMap = new HashMap<Long, String>(16);
            }
            checkItemMap.put(itemId, level);
            allCheckItemMap.put(purpose, checkItemMap);
        }
        SimpleSettleAccountParam param = new SimpleSettleAccountParam();
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)settleContext.getCostaccountId());
        DynamicObject nexPeriod = PeriodHelper.getNextPeriod((Object)period.getPkValue());
        DynamicObject previousPeriod = PeriodHelper.getPreviousPeriod((Object)period.getPkValue());
        param.setCostAccountId(settleContext.getCostaccountId().longValue());
        param.setCostAccountName(dynamicObject.getString("name"));
        param.setCostAccountNum(dynamicObject.getString("number"));
        param.setCurrentPeriodId(period.getLong("id"));
        param.setCurrentPeriodNum(period.getString("number"));
        if (nexPeriod != null) {
            param.setNextPeriodId(nexPeriod.getLong("id"));
            param.setNextPeriodNum(nexPeriod.getString("number"));
        }
        if (previousPeriod != null) {
            param.setPreviousPeriodId(previousPeriod.getLong("id"));
            param.setPreviousPeriodNum(previousPeriod.getString("number"));
        }
        param.setCheckItems(allCheckItemMap);
        return param;
    }

    @Override
    public String getSourcePageParam(String context) {
        CalcSettleContext settleContext = (CalcSettleContext)JSON.parseObject((String)context, CalcSettleContext.class);
        List<SettleJumpPage> pages = this.getPages(settleContext);
        return JSON.toJSONString(pages);
    }

    private List<SettleJumpPage> getPages(CalcSettleContext settleContext) {
        ArrayList<SettleJumpPage> jumpPages = new ArrayList<SettleJumpPage>(10);
        SettleJumpPage page = new SettleJumpPage();
        page.setName(ResManager.loadKDString((String)"\u7ed3\u8d26\u65e5\u5fd7\u5217\u8868", (String)"SettleAccountsTask_7", (String)"fi-cal-business", (Object[])new Object[0]));
        page.setOpenType(CalcSettleEnum.OPTYPE_LIST.getValue());
        page.setSourcepage("cal_settleaccountlog");
        HashMap<String, Object> customParam = new HashMap<String, Object>(10);
        QFilter q = new QFilter("costaccount", "=", (Object)settleContext.getCostaccountId());
        customParam.put("filter", q.toString());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)settleContext.getOrgId())});
        if (dynamicObject != null) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put(dynamicObject.getString("id"), dynamicObject.getString("name"));
            customParam.put("calorg", map);
        }
        page.setParam(customParam);
        jumpPages.add(page);
        return jumpPages;
    }
}

