/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.extsysupgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.InitBillOldBalanceCalculator;
import kd.fi.cal.business.process.inner.CalBillInfo;
import kd.fi.cal.business.process.inner.Field;
import kd.fi.cal.business.process.inner.FieldMappingResult;
import kd.fi.cal.common.constant.BillTypeConstants;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.DynamicObjectUtils;

public class PrePeriodImInitBillSyncSubTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PrePeriodImInitBillSyncSubTask.class);
    private IAppCache CACHE = AppCache.get((String)"cal");
    private static final String CALRULEFIELDS = "id,number,calbill.id,calbill.number,fieldmap.calfield,fieldmap.sourcefield,fieldmap.isorgfield,fieldmap.orgtype,filter,filter_tag,fieldmap.isextendfield,errortip";
    private Map<Long, List<QFilter>> ruleFilterMap = new HashMap<Long, List<QFilter>>(4);
    private MainEntityType bizbillentitytype = MetadataServiceHelper.getDataEntityType((String)"im_initbill");
    private String bizbillentrykey = "billentry";
    private static final String COSTACCOUNTFIELDS = "id,name,number,calpolicy,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.currency.priceprecision,dividebasis,calpolicy.currency.number,calpolicy.currency.name,calpolicy.convertmode,calpolicy.exratetable,calpolicy.calbycostelement,calpolicy.supporttaxamt,calorg,calorg.name,calorg.number";
    private Map<Long, DynamicObjectCollection> costAccountMap = new HashMap<Long, DynamicObjectCollection>(32);
    private Map<Long, Set<String>> exFieldMap = new HashMap<Long, Set<String>>(32);
    private Map<Long, Long> costAcc2StartPeriod = new HashMap<Long, Long>(4);
    private Map<Long, SynBillErrInfo> errMap = new HashMap<Long, SynBillErrInfo>(32);
    private IDGenerator initEIdGenerator = new IDGenerator("t_cal_initbillentry");
    private IDGenerator initIdGenerator = new IDGenerator("t_cal_initbill");
    private boolean isNewBal = CalBalanceModelHelper.isNewBalance();
    private Set<DynamicObject> rules = new HashSet<DynamicObject>(4);
    private boolean eas_sync_handle_catrange = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.EAS_SYNC_HANDLE_CATRANGE);

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        String BATCHSTR = (String)paramMap.get("BATCHSTR");
        int batch_size = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.EAS_SYNC_BATCH_SIZE);
        String msg = "success";
        try {
            this.init();
            if (this.rules != null && !this.rules.isEmpty()) {
                DataSet initImBillDS;
                DataSet initCalBillDS = this.getInitCalBillDS();
                Set<Long> needSyncInitImBillIds = this.getNeedSyncInitImBillIds(initCalBillDS, initImBillDS = this.getInitImBillDS());
                if (needSyncInitImBillIds == null || needSyncInitImBillIds.isEmpty()) {
                    return;
                }
                CalBillInfo calBillInfo = new CalBillInfo("cal_initbill");
                for (DynamicObject rule : this.rules) {
                    FieldMappingResult mappingResult = this.getFieldMapping(rule, "cal_initbill", calBillInfo);
                    String ownerkey = mappingResult.getOwnerField().getTotalkey();
                    StringBuilder bizEntryKey = new StringBuilder();
                    String[] entryOwners = ownerkey.split("\\.");
                    entryOwners[entryOwners.length - 1] = "id";
                    for (String name : entryOwners) {
                        bizEntryKey.append(name).append('.');
                    }
                    String bizEntryKeyStr = bizEntryKey.toString().substring(0, bizEntryKey.length() - 1);
                    String bizSelector = this.getBizBillSelector(mappingResult.getBizFieldSet());
                    if (!bizSelector.contains(bizEntryKeyStr)) {
                        bizSelector = bizSelector + "," + bizEntryKeyStr;
                    }
                    if (!bizSelector.contains("auditor")) {
                        bizSelector = bizSelector + ",auditor";
                    }
                    if (!bizSelector.contains("auditdate")) {
                        bizSelector = bizSelector + ",auditdate";
                    }
                    String finalBizSelector = bizSelector;
                    List<QFilter> filters = this.ruleFilterMap.get(rule.getLong("id"));
                    Set<String> exFieldSet = this.dealExFieldSet(rule);
                    Map<Field, Field> headMapping = mappingResult.getHeadmap();
                    Map<Field, Field> entryMapping = mappingResult.getEntrymap();
                    Lists.partition(Arrays.asList(needSyncInitImBillIds.toArray(new Long[0])), (int)batch_size).forEach(list -> {
                        HashMap<String, DynamicObject> ownerMapCalBill = new HashMap<String, DynamicObject>(batch_size);
                        Map<Long, DynamicObjectCollection> validEntryMaps = this.getValidEntrys(rule, list, finalBizSelector, bizEntryKeyStr, filters);
                        Map<Long, Set<Long>> billOwnerMap = this.getbillOwnerMap(ownerkey, validEntryMaps);
                        for (Map.Entry<Long, DynamicObjectCollection> entry : validEntryMaps.entrySet()) {
                            long l = entry.getKey();
                            DynamicObjectCollection bizBillColl = entry.getValue();
                            if (bizBillColl.isEmpty()) continue;
                            for (DynamicObject billentry : bizBillColl) {
                                long ownerId = billentry.getLong(ownerkey);
                                DynamicObjectCollection costAccColl = this.getAllCostAccount(ownerId);
                                DynamicObject calBill = (DynamicObject)ownerMapCalBill.get(l + "," + ownerId);
                                if (calBill == null) {
                                    calBill = this.setCalBillHead(ownerMapCalBill, l, headMapping, billentry, ownerId);
                                }
                                this.setEntry(bizEntryKeyStr, exFieldSet, entryMapping, billentry, calBill);
                            }
                        }
                        ArrayList<DynamicObject> initCalBills = new ArrayList<DynamicObject>(4);
                        for (Map.Entry entry : ownerMapCalBill.entrySet()) {
                            DynamicObject[] idKey = (DynamicObject[])entry.getKey();
                            long billId = Long.parseLong(idKey.split(",")[0]);
                            long ownerId = Long.parseLong(idKey.split(",")[1]);
                            DynamicObjectCollection costAccounts = this.costAccountMap.get(ownerId);
                            for (DynamicObject costAcc : costAccounts) {
                                initCalBills.add(this.newInitCalBill((DynamicObject)entry.getValue(), costAcc));
                            }
                        }
                        if (!initCalBills.isEmpty()) {
                            DynamicObject[] dynamicObjectArray = initCalBills.toArray(new DynamicObject[0]);
                            if (this.eas_sync_handle_catrange) {
                                new AccountType4CostAdjustHelper(dynamicObjectArray).handleCalRangeAccType4InitBill(this.errMap);
                                MaterialCategoryHandle.handle4Bill((DynamicObject[])dynamicObjectArray);
                            }
                            SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
                            if (this.isNewBal) {
                                HashSet<Long> hashSet = new HashSet<Long>(4);
                                for (DynamicObject info : dynamicObjectArray) {
                                    hashSet.add(info.getLong("id"));
                                }
                                BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
                                balanceOpInvoker.setEntity("cal_initbill");
                                balanceOpInvoker.invokeBalOp(hashSet, null);
                            } else {
                                new InitBillOldBalanceCalculator().updateAudit(dynamicObjectArray);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            msg = "error-traceid:" + RequestContext.get().getTraceId();
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            this.CACHE.put(BATCHSTR, (Object)msg);
        }
    }

    private void init() {
        this.initCalBillRules();
        this.initCostAccountStartPeriodMap();
    }

    private void initCostAccountStartPeriodMap() {
        QFilter filter = new QFilter("entry.costaccount.enable", "=", (Object)true);
        String fields = "org,entry.costaccount,entry.startperiod";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_sysctrlentity", (String)fields, (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                this.costAcc2StartPeriod.put(row.getLong("entry.costaccount"), row.getLong("entry.startperiod"));
            }
        }
    }

    private DynamicObject newInitCalBill(DynamicObject calInitBill, DynamicObject costAccount) {
        Long costAccountId = costAccount.getLong("id");
        DynamicObject newInitBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_initbill");
        DynamicObjectUtils.copy((DynamicObject)calInitBill, (DynamicObject)newInitBill);
        Long id = this.initIdGenerator.getId();
        newInitBill.set("id", (Object)id);
        newInitBill.set("costaccount_id", (Object)costAccountId);
        newInitBill.set("calorg", (Object)costAccount.getLong("calorg"));
        newInitBill.set("calorg_id", (Object)costAccount.getLong("calorg"));
        newInitBill.set("period", (Object)this.costAcc2StartPeriod.get(costAccountId));
        newInitBill.set("localcurrency", costAccount.get("calpolicy.currency"));
        newInitBill.set("billstatus", (Object)"C");
        newInitBill.set("calstatus", (Object)"A");
        DynamicObjectCollection entrys = newInitBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            entry.set("id", (Object)this.initEIdGenerator.getId());
            entry.set("ecalstatus", (Object)"A");
            entry.set("entrystatus", (Object)"C");
        }
        for (DynamicObject entry : entrys) {
            DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
            DynamicObject subEntryRow = subEntrys.addNew();
            subEntryRow.set("costelement", (Object)773126985240072192L);
            subEntryRow.set("costsubelement", (Object)773175233367685120L);
            subEntryRow.set("sub_material", entry.get("material_id"));
            subEntryRow.set("sub_baseunit", entry.get("baseunit_id"));
            subEntryRow.set("sub_baseqty", entry.get("baseqty"));
            subEntryRow.set("sub_price", entry.get("price"));
            subEntryRow.set("sub_amount", entry.get("amount"));
            subEntryRow.set("sub_baseqty", entry.get("baseqty"));
            subEntryRow.set("sub_yearinqty", entry.get("yearinqty"));
            subEntryRow.set("sub_yearincost", entry.get("yearincost"));
            subEntryRow.set("sub_yearissueqty", entry.get("yearissueqty"));
            subEntryRow.set("sub_yearissuecost", entry.get("yearissuecost"));
        }
        return newInitBill;
    }

    private DynamicObject setCalBillHead(Map<String, DynamicObject> ownerMapCalBill, long billId, Map<Field, Field> headMapping, DynamicObject billentry, long ownerId) {
        DynamicObject calBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_initbill");
        for (Map.Entry<Field, Field> mapEntry : headMapping.entrySet()) {
            calBill.set(mapEntry.getKey().getTotalkey(), billentry.get(mapEntry.getValue().getTotalkey()));
        }
        calBill.set("bizbillid", billentry.get("id"));
        calBill.set("bizentityobject", (Object)"im_initbill");
        calBill.set("billtype", (Object)BillTypeConstants.INITCAL_BILL);
        calBill.set("billstatus", (Object)"A");
        calBill.set("auditor", billentry.get("auditor"));
        calBill.set("auditdate", billentry.get("auditdate"));
        calBill.set("billno", billentry.get("billno"));
        ownerMapCalBill.put(billId + "," + ownerId, calBill);
        return calBill;
    }

    private void setEntry(String bizEntryKeyStr, Set<String> exFieldSet, Map<Field, Field> entryMapping, DynamicObject billentry, DynamicObject calBill) {
        DynamicObjectCollection entryCol = calBill.getDynamicObjectCollection("entryentity");
        DynamicObject calBillEntry = entryCol.addNew();
        calBillEntry.set("seq", (Object)entryCol.size());
        for (Map.Entry<Field, Field> entryMap : entryMapping.entrySet()) {
            calBillEntry.set(entryMap.getKey().getProperty(), billentry.get(entryMap.getValue().getTotalkey()));
        }
        if (StringUtils.isEmpty((String)bizEntryKeyStr)) {
            calBillEntry.set("bizbillentryid", billentry.get(this.bizbillentrykey + ".id"));
        } else {
            calBillEntry.set("bizbillentryid", billentry.get(bizEntryKeyStr));
        }
        calBillEntry.set("srcbizentityobject", (Object)"im_initbill");
        this.exFieldMap.put(calBill.getLong("id"), exFieldSet);
    }

    private DynamicObjectCollection getAllCostAccount(long ownerId) {
        DynamicObjectCollection accountcoll = this.costAccountMap.get(ownerId);
        if (accountcoll == null) {
            DynamicObjectCollection coll = AccountingSysHelper.getAccountingSysCollsByOwner((Long)ownerId, null);
            QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            for (DynamicObject info : coll) {
                long calSystemId = info.getLong("id");
                long calOrgId = info.getLong("calorgid");
                QFilter q1 = new QFilter("calsystem", "=", (Object)calSystemId);
                q1.and("calorg", "=", (Object)calOrgId);
                q.or(q1);
            }
            q.and("status", "=", (Object)"C");
            q.and("enable", "=", (Object)"1");
            new CalGroupAccountHelper().addNotGroupAcctFilterSelf(q);
            accountcoll = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)COSTACCOUNTFIELDS, (QFilter[])q.toArray());
            this.costAccountMap.put(ownerId, accountcoll);
        }
        return accountcoll;
    }

    private Set<String> dealExFieldSet(DynamicObject rule) {
        HashSet<String> exFieldSet = new HashSet<String>(8);
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            boolean isExtendField = ruleEntry.getBoolean("isextendfield");
            if (!isExtendField) continue;
            String calFieldName = ruleEntry.getString("calfield");
            exFieldSet.add(calFieldName);
        }
        return exFieldSet;
    }

    private Map<Long, Set<Long>> getbillOwnerMap(String ownerkey, Map<Long, DynamicObjectCollection> validEntryMaps) {
        HashMap<Long, Set<Long>> billOwnerMap = new HashMap<Long, Set<Long>>(4);
        for (Map.Entry<Long, DynamicObjectCollection> entry : validEntryMaps.entrySet()) {
            long billId = entry.getKey();
            Set ownerSet = billOwnerMap.computeIfAbsent(billId, k -> new HashSet(8));
            DynamicObjectCollection bizBillColl = entry.getValue();
            if (bizBillColl.isEmpty()) continue;
            for (DynamicObject billentry : bizBillColl) {
                ownerSet.add(billentry.getLong(ownerkey));
            }
        }
        return billOwnerMap;
    }

    protected Map<Long, DynamicObjectCollection> getValidEntrys(DynamicObject rule, Object bizBillID, String selectors, String bizEntryKey, List<QFilter> filters) {
        ArrayList<QFilter> allFitlers = new ArrayList<QFilter>(4);
        allFitlers.addAll(filters);
        allFitlers.add(new QFilter("id", "in", bizBillID));
        DynamicObjectCollection bizBillColl = QueryServiceHelper.query((String)"im_initbill", (String)selectors, (QFilter[])allFitlers.toArray(new QFilter[0]));
        HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
        HashSet<Long> hasEntryIds = new HashSet<Long>(16);
        for (DynamicObject info : bizBillColl) {
            long id = info.getLong("id");
            DynamicObjectCollection coll = (DynamicObjectCollection)map.get(id);
            if (coll != null) {
                boolean isExist = false;
                if (!hasEntryIds.add(info.getLong(bizEntryKey))) {
                    isExist = true;
                }
                if (isExist) continue;
                coll.add((Object)info);
                continue;
            }
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            map.put(id, coll);
            hasEntryIds.add(info.getLong(bizEntryKey));
        }
        logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u8fc7\u6ee4\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\uff1a" + System.currentTimeMillis());
        return map;
    }

    private String getBizBillSelector(Collection<Field> bizFields) {
        StringBuilder bizSelectorsSb = new StringBuilder();
        for (Field bizField : bizFields) {
            bizSelectorsSb.append(bizField.getTotalkey()).append(',');
        }
        bizSelectorsSb.setLength(bizSelectorsSb.length() - 1);
        String fields = bizSelectorsSb.toString();
        if (!fields.contains(this.bizbillentrykey + ".id")) {
            fields = this.bizbillentrykey + ".id," + fields;
        }
        return fields;
    }

    private FieldMappingResult getFieldMapping(DynamicObject rule, String calBillNumber, CalBillInfo calBillInfo) {
        FieldMappingResult result = new FieldMappingResult();
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            String bizFieldName = ruleEntry.getString("sourcefield");
            if (StringUtils.isEmpty((String)bizFieldName)) continue;
            String calFieldName = ruleEntry.getString("calfield");
            IDataEntityProperty calEntity = calBillInfo.getType().findProperty(calFieldName);
            IDataEntityProperty bizEntity = this.bizbillentitytype.findProperty(bizFieldName.split("\\.")[0]);
            if (calEntity == null || bizEntity == null) continue;
            IDataEntityType parentyCalEntity = calEntity.getParent();
            IDataEntityType parentBizEntity = bizEntity.getParent();
            if (parentyCalEntity instanceof LinkEntryType || parentBizEntity instanceof LinkEntryType) continue;
            Field bizField = null;
            Field calField = parentyCalEntity instanceof EntryType ? new Field(calFieldName, true, calBillInfo.getEntrykey(), calEntity) : new Field(calFieldName, false, null, calEntity);
            bizField = parentBizEntity instanceof SubEntryType ? new Field(bizFieldName, true, this.bizbillentrykey + "." + parentBizEntity.getName(), bizEntity) : (parentBizEntity instanceof EntryType ? new Field(bizFieldName, true, this.bizbillentrykey, bizEntity) : new Field(bizFieldName, false, null, bizEntity));
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".owner")) {
                result.setOwnerField(bizField);
            }
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".companyorg")) {
                result.setCalOrgField(bizField);
            }
            result.addMapping(calField, bizField);
        }
        if (!result.hasOwnerField()) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u6620\u5c04\u89c4\u5219\u6ca1\u6709\u914d\u7f6e\u8d27\u4e3b\u5b57\u6bb5\u3002", (String)"SyncBizBill4AuditServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0]), calBillNumber);
            throw new KDBizException(msg);
        }
        return result;
    }

    private Set<Long> getNeedSyncInitImBillIds(DataSet initCalBillDS, DataSet initImBillDS) {
        DataSet dataSet = initImBillDS.join(initCalBillDS, JoinType.LEFT).on("id", "bizbillid").select(new String[]{"id"}, new String[]{"bizbillid"}).finish();
        dataSet = dataSet.where("bizbillid = null");
        HashSet<Long> needSyncInitImBillIds = new HashSet<Long>(4);
        for (Row row : dataSet) {
            needSyncInitImBillIds.add(row.getLong("id"));
        }
        return needSyncInitImBillIds;
    }

    private DataSet getInitImBillDS() {
        ArrayList<OrmInput> initImInputs = new ArrayList<OrmInput>(4);
        for (List<QFilter> value : this.ruleFilterMap.values()) {
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), "im_initbill", "id", value.toArray(new QFilter[0]));
            initImInputs.add(input);
        }
        DataSet initCalBillDS = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(initImInputs.toArray(new Input[0]));
        return initCalBillDS;
    }

    private DataSet getInitCalBillDS() {
        DataSet initCalBillDS = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_initbill", (String)"bizbillid", null, null);
        return initCalBillDS;
    }

    private void initCalBillRules() {
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)"im_initbill");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)CALRULEFIELDS, (QFilter[])filter.toArray());
        for (DynamicObject rull : billRules) {
            if (rull == null) continue;
            this.rules.add(rull);
        }
        for (DynamicObject rule : this.rules) {
            String ruleFilter = rule.getString("filter_tag");
            ArrayList<QFilter> list = new ArrayList<QFilter>(4);
            if (StringUtils.isNotEmpty((String)ruleFilter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleFilter, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"im_initbill"), filterCondition);
                filterBuilder.buildFilter();
                list.add(filterBuilder.getQFilter());
            }
            this.ruleFilterMap.put(rule.getLong("id"), list);
        }
    }
}

