/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.fallprice.FallPriceExtractParam;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.business.fallprice.FallPriceSettingParam;
import kd.fi.cal.business.fallprice.IFallPriceProvCal;
import kd.fi.cal.business.formula.StandGroupBaseDataConverter;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.MaterialCategoryHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.StandardCostHelper;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.DateUtils;

public abstract class AbstractFallPriceProvCal
implements IFallPriceProvCal {
    protected final FallPriceExtractParam fallPriceExtractParam;
    protected FallPriceSettingParam fallPriceParam;
    protected boolean isContainDiffer = false;
    protected boolean isAddStorOrg = false;
    protected Set<Long> userSelMatIdsCache = null;
    private Set<Long> curSettingUserSelMatIdsCache;
    protected Set<Long> curSettingProvMatIdsCache;
    protected Set<Long> curProvInvOrgIds;
    private static final String[] calNoWareGroups = new String[]{"balmatgroup", "baseunit", "balgrouplnum", "balmaterial", "balbaseunit"};
    private static final String[] calHasWareGroups = new String[]{"balmatgroup", "balwaregroup", "baseunit", "balgrouplnum", "balwaregrouplnum", "balmaterial", "balbaseunit"};
    private int batchSize = 100000;
    protected Date curPeriodLastDay;
    protected static final int MAX_AGETO = 999999;
    protected static final String MATERIAL = "material";
    protected static final String MATERIALGROUP = "materialgroup";
    protected static final String WAREHOUSEGROUP = "warehousegroup";

    public AbstractFallPriceProvCal(FallPriceSettingParam fallPriceParam, FallPriceExtractParam fallPriceExtractParam) {
        this.fallPriceParam = fallPriceParam;
        this.fallPriceExtractParam = fallPriceExtractParam;
        this.init();
    }

    protected void init() {
        this.isContainDiffer = (Boolean)ParamsHelper.getAppParam((long)((Long)this.fallPriceExtractParam.getCalOrgId()), (String)"iscontaindiffer");
        String[] curProvDims = this.fallPriceParam.getProvDims();
        HashSet<String> curProvDimSets = new HashSet<String>(Arrays.asList(curProvDims));
        curProvDimSets.addAll(Arrays.asList(this.fallPriceParam.getCurDims()));
        if (curProvDimSets.add("storageorgunit")) {
            this.fallPriceParam.setProvDims((String[])ArrayUtils.concatAll((Object[])this.fallPriceParam.getProvDims(), (Object[][])new String[][]{{"storageorgunit"}}));
            this.isAddStorOrg = true;
        }
        this.curPeriodLastDay = DateUtils.getDayEndTime((Date)this.fallPriceExtractParam.getCurPeriodLastDay());
    }

    @Override
    public DataSet getExtractDataSet() {
        return null;
    }

    protected void setFixEntryInfo(int seq, Row row, DynamicObject entryDyc) {
        String materialGroupf = MATERIALGROUP;
        String warehouseGroupf = WAREHOUSEGROUP;
        if (MATERIALGROUP.equals(this.fallPriceParam.getExtractWay())) {
            materialGroupf = "detailmatgroup";
        }
        entryDyc.set(MATERIALGROUP, row.get(materialGroupf));
        entryDyc.set(WAREHOUSEGROUP, row.get(warehouseGroupf));
        entryDyc.set(MATERIAL, row.get("balmaterial"));
        entryDyc.set("baseunit", row.get("balbaseunit"));
        Integer expiryDateFrom = row.getInteger("expirydatefrom");
        Integer expiryDateTo = row.getInteger("expirydateto");
        entryDyc.set("expirydatefrom", (Object)expiryDateFrom);
        entryDyc.set("expirydateto", (Object)expiryDateTo);
        Integer invAgeFrom = row.getInteger("invagefrom");
        Integer invAgeTo = row.getInteger("invageto");
        entryDyc.set("invagefrom", (Object)invAgeFrom);
        entryDyc.set("invageto", (Object)invAgeTo);
        entryDyc.set("endperiod", (Object)999999);
        entryDyc.set("ownertype", (Object)"bos_org");
        for (String dim : this.fallPriceParam.getCurDims()) {
            if ("".equals(dim)) continue;
            entryDyc.set(dim, row.get(dim));
        }
        for (String dim : this.fallPriceParam.getProvDims()) {
            if ("".equals(dim)) continue;
            entryDyc.set(dim, row.get(dim));
        }
        entryDyc.set("seq", (Object)seq);
    }

    protected void calRealAmt(Row row, DynamicObject entryDyc) {
        boolean exitPreEntry;
        boolean qtyLessEqualZero;
        int amtPrecision = this.fallPriceParam.getCurrencyAmtPrecision();
        BigDecimal unitRealPrice = row.getBigDecimal("unitrealizableamount");
        BigDecimal fallPriceScale = row.getBigDecimal("fallpricescale").divide(new BigDecimal(100), 4, 4);
        BigDecimal baseQty = entryDyc.getBigDecimal("baseQty");
        BigDecimal amount = entryDyc.getBigDecimal("amount");
        boolean bl = qtyLessEqualZero = baseQty.compareTo(BigDecimal.ZERO) <= 0;
        if (fallPriceScale.compareTo(BigDecimal.ZERO) > 0) {
            entryDyc.set("fallpricescale", (Object)row.getBigDecimal("fallpricescale"));
            entryDyc.set("realizableamount", (Object)amount.multiply(BigDecimal.ONE.subtract(fallPriceScale)).setScale(amtPrecision, 4));
            if (qtyLessEqualZero) {
                entryDyc.set("unitrealizableamount", (Object)BigDecimal.ZERO);
            } else {
                entryDyc.set("unitrealizableamount", (Object)entryDyc.getBigDecimal("realizableamount").divide(baseQty, 10, 4));
            }
        } else {
            BigDecimal basePrice = entryDyc.getBigDecimal("baseprice");
            if (basePrice.compareTo(BigDecimal.ZERO) == 0) {
                entryDyc.set("fallpricescale", (Object)BigDecimal.ZERO);
            } else {
                entryDyc.set("fallpricescale", (Object)basePrice.subtract(unitRealPrice).divide(basePrice, 4, 4).multiply(new BigDecimal(100)));
            }
            entryDyc.set("unitrealizableamount", (Object)unitRealPrice);
            entryDyc.set("realizableamount", (Object)baseQty.multiply(unitRealPrice).setScale(amtPrecision, 4));
        }
        BigDecimal reqAmount = amount.subtract(entryDyc.getBigDecimal("realizableamount"));
        BigDecimal hasAmount = BigDecimal.ZERO;
        entryDyc.set("requireamount", (Object)reqAmount);
        Long preEntryId = row.getLong("entryid");
        boolean bl2 = exitPreEntry = preEntryId != null && !preEntryId.equals(0L);
        if (exitPreEntry) {
            entryDyc.set("preentryid", (Object)preEntryId);
            hasAmount = row.getBigDecimal("requireamount").subtract(row.getBigDecimal("rushamount"));
            entryDyc.set("hasamount", (Object)hasAmount);
        }
        BigDecimal repAmount = reqAmount.subtract(hasAmount);
        entryDyc.set("replenishamount", (Object)repAmount);
    }

    protected void setBillHeadInfo(DynamicObject provDyc, String number) {
        int curPeriodNum = this.fallPriceExtractParam.getCurrentPeriodNum();
        provDyc.set("costaccount", this.fallPriceExtractParam.getCostAccountId());
        provDyc.set("org", this.fallPriceExtractParam.getCalOrgId());
        provDyc.set("billno", (Object)number);
        provDyc.set("periodid", (Object)this.fallPriceExtractParam.getCurrentPeriodId());
        provDyc.set("period", (Object)curPeriodNum);
        provDyc.set("bizdate", (Object)DateUtils.getDayStartTime((Date)this.fallPriceExtractParam.getCurPeriodLastDay()));
        provDyc.set("bookdate", (Object)DateUtils.getDayStartTime((Date)this.fallPriceExtractParam.getCurPeriodLastDay()));
        provDyc.set("accsetting", this.fallPriceParam.getSettingId());
        provDyc.set("currency", (Object)this.fallPriceExtractParam.getCurrencyId());
        provDyc.set("billstatus", (Object)"A");
        provDyc.set("isinitbill", (Object)Boolean.FALSE);
        provDyc.set("creator", (Object)RequestContext.get().getUserId());
        provDyc.set("createtime", (Object)new Date());
        provDyc.set("modifier", (Object)RequestContext.get().getUserId());
        provDyc.set("modifytime", (Object)new Date());
    }

    protected void updateLastProvEndPeriod(List<Object[]> entryIds) {
        String updateLastProvSQL = "update t_cal_price_proventry set fendperiod = ? where fentryid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)updateLastProvSQL, entryIds);
    }

    protected DataSet matBalAccJoinProvBillDs(DataSet matBalAccDs) {
        DataSet proBillDs = this.getProvBillDs();
        JoinDataSet matBalAccProBillDs = matBalAccDs.leftJoin(proBillDs);
        matBalAccProBillDs.on("balmaterial", MATERIAL);
        if (WAREHOUSEGROUP.equals(this.fallPriceParam.getExtractWay())) {
            matBalAccProBillDs.on(WAREHOUSEGROUP, WAREHOUSEGROUP);
        }
        String[] joinDims = this.getSetAndProvDims();
        this.joinOnDims(joinDims, matBalAccProBillDs);
        matBalAccProBillDs.on("invagefrom", "invagefrom");
        matBalAccProBillDs.on("invageto", "invageto");
        matBalAccProBillDs.on("expirydatefrom", "expirydatefrom");
        matBalAccProBillDs.on("expirydateto", "expirydateto");
        matBalAccDs = matBalAccProBillDs.select(matBalAccDs.getRowMeta().getFieldNames(), new String[]{"entryid", "requireamount", "rushamount"}).finish();
        return matBalAccDs;
    }

    protected DataSet setBalJoinCurProvRevDs(DataSet matBalDs, DataSet curProvRevDs) {
        JoinDataSet mstJoinCurProvRevDs = matBalDs.leftJoin(curProvRevDs);
        Boolean isSplitInvOrg = CalDbParamServiceHelper.getBoolean((String)"fallprice_split_invorg");
        if (isSplitInvOrg.booleanValue()) {
            mstJoinCurProvRevDs = mstJoinCurProvRevDs.on("storageorgunit", "storageorgunit");
        }
        matBalDs = mstJoinCurProvRevDs.on("balmaterial", "billmaterial").select(matBalDs.getRowMeta().getFieldNames(), new String[]{"billmaterial"}).finish().filter("billmaterial is null");
        return matBalDs;
    }

    protected Set<String> getSetAndBalGroupDims(String[] settingDsFields) {
        String[] calGroups = calNoWareGroups;
        if (WAREHOUSEGROUP.equals(this.fallPriceParam.getExtractWay())) {
            calGroups = calHasWareGroups;
        }
        String[] groupFields = (String[])ArrayUtils.concatAll((Object[])this.fallPriceParam.getProvDims(), (Object[][])new String[][]{(String[])ArrayUtils.concatAll((Object[])settingDsFields, (Object[][])new String[][]{calGroups})});
        return new HashSet<String>(Arrays.asList(groupFields));
    }

    protected String[] getSetAndProvDims() {
        String[] joinDims = (String[])ArrayUtils.concatAll((Object[])this.fallPriceParam.getCurDims(), (Object[][])new String[][]{this.fallPriceParam.getProvDims()});
        return joinDims;
    }

    private void removeStorgOrgDimIfAdd(Set<String> groupFieldDists) {
        if (this.isAddStorOrg) {
            ArrayList<String> newProDims = new ArrayList<String>(Arrays.asList(this.fallPriceParam.getProvDims()));
            newProDims.remove("storageorgunit");
            this.fallPriceParam.setProvDims(newProDims.toArray(new String[0]));
            groupFieldDists.remove("storageorgunit");
        }
    }

    protected DataSet settingJoinBalDs(DataSet settingDs, Set<String> groupFieldDists, DataSet balDs) {
        String[] settingDsFields = settingDs.getRowMeta().getFieldNames();
        JoinDataSet settingJoinBalDs = settingDs.join(balDs);
        if (WAREHOUSEGROUP.equals(this.fallPriceParam.getExtractWay())) {
            settingJoinBalDs.on(WAREHOUSEGROUP, "balwaregroup");
        } else {
            settingJoinBalDs.on(MATERIAL, "balmaterial");
        }
        this.joinOnDims(this.fallPriceParam.getCurDims(), settingJoinBalDs);
        String[] provDims = this.fallPriceParam.getProvDims();
        HashSet<String> provDimDists = new HashSet<String>(Arrays.asList(provDims));
        provDimDists.removeAll(Arrays.asList(this.fallPriceParam.getCurDims()));
        String periodEndActCost = "case when invagefrom = 0 and invageto = 999999 then periodendactualcostbak else periodendactualcost end as periodendactualcost";
        DataSet matBalDs = settingJoinBalDs.select(settingDsFields, (String[])ArrayUtils.concatAll((Object[])provDimDists.toArray(new String[0]), (Object[][])new String[][]{{periodEndActCost, "periodendstandardcost", "periodendqty", "balmatgroup", "balwaregroup", "baseunit", "balgrouplnum", "balwaregrouplnum", "balmaterial", "balbaseunit", "accounttype"}})).finish();
        matBalDs = matBalDs.groupBy((String[])ArrayUtils.concatAll((Object[])groupFieldDists.toArray(new String[0]), (Object[][])new String[][]{{"accounttype"}})).sum("periodendactualcost").sum("periodendstandardcost").sum("periodendqty").finish();
        return matBalDs;
    }

    protected DataSet getPeriodBalDs() {
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DataSet balDs = isNewBalance ? this.getNewBalDs(this.isContainDiffer) : this.getBalDs(this.isContainDiffer);
        return balDs;
    }

    private String getEntrySetDimSelectsStr(FallPriceSettingParam fallPriceParam) {
        String[] curDims = fallPriceParam.getCurDims();
        StringBuilder select = new StringBuilder();
        for (String curDim : curDims) {
            if ("x".equals(curDim)) continue;
            select.append(",entry.").append(curDim).append(" as ").append(curDim);
        }
        return select.toString();
    }

    protected DataSet getSettingDs() {
        this.cacheCurSettingUserSelMatIds();
        String matGroupDLM = FallPriceHelper.getMatGroupDLM();
        String entryDimSelects = this.getEntrySetDimSelectsStr(this.fallPriceParam);
        QFilter settingIdf = new QFilter("id", "=", this.fallPriceParam.getSettingId());
        String mgsSel = String.format("case when (materialgroupstandard is null or materialgroupstandard = 0) then %s else materialgroupstandard end as materialgroupstandard", 730148448254487552L);
        String selectFields = "id settingid,provisionway,calorg,costaccount,costaccount.costtype setcosttype,currency,entry.materialgroup materialgroup, entry.materialgroup.longnumber grouplnum,entry.warehousegroup warehousegroup, entry.warehousegroup.longnumber warehousegrouplnum,entry.material material,entry.invagefrom invagefrom,entry.invageto invageto,entry.expirydatefrom expirydatefrom,entry.expirydateto expirydateto,entry.fallpricescale fallpricescale,entry.unitrealizableamount unitrealizableamount" + entryDimSelects + "," + mgsSel;
        if (MATERIAL.equals(this.fallPriceParam.getExtractWay()) && this.curSettingUserSelMatIdsCache != null) {
            settingIdf.and("entry.material", "in", this.curSettingUserSelMatIdsCache);
        }
        DataSet settingDs = QueryServiceHelper.queryDataSet((String)"FallPriceExtractor.getSettingDscal_fallprice_setting", (String)"cal_fallprice_setting", (String)selectFields, (QFilter[])new QFilter[]{settingIdf}, null);
        if (MATERIALGROUP.equals(this.fallPriceParam.getExtractWay())) {
            ArrayList<Long> matGroupIds = new ArrayList<Long>(16);
            for (Row row : settingDs.copy()) {
                matGroupIds.add(row.getLong(MATERIALGROUP));
            }
            DataSet materialDataSet = this.getMatIdsByStandGroup(matGroupIds, this.curSettingUserSelMatIdsCache);
            if (materialDataSet != null) {
                String format = "matgrouplnum = grouplnum or StartsWith(matgrouplnum,grouplnum + '%s')";
                format = String.format(format, matGroupDLM);
                ArrayList<String> settingFields = new ArrayList<String>(Arrays.asList(settingDs.getRowMeta().getFieldNames()));
                settingFields.remove(MATERIAL);
                settingDs = settingDs.join(materialDataSet).on("materialgroupstandard", "standard").select(settingFields.toArray(new String[0]), new String[]{MATERIAL, "matgrouplnum", "detailmatgroup"}).finish().filter(format);
            }
        }
        this.cacheCurSettingMatIds(settingDs);
        return settingDs;
    }

    private void cacheCurSettingMatIds(DataSet settingDs) {
        this.curSettingProvMatIdsCache = new HashSet<Long>(16);
        this.curProvInvOrgIds = new HashSet<Long>(16);
        if (this.fallPriceParam.getExtractWay().equals(WAREHOUSEGROUP)) {
            this.curSettingProvMatIdsCache = this.curSettingUserSelMatIdsCache != null ? this.curSettingUserSelMatIdsCache : null;
        } else {
            boolean isConInvOrg = Arrays.asList(settingDs.getRowMeta().getFieldNames()).contains("storageorgunit");
            for (Row row : settingDs.copy()) {
                Long storageorgunit;
                Long materialId = row.getLong(MATERIAL);
                if (materialId == null || materialId.equals(0L)) continue;
                this.curSettingProvMatIdsCache.add(materialId);
                if (!isConInvOrg || (storageorgunit = row.getLong("storageorgunit")) == null || storageorgunit.equals(0L)) continue;
                this.curProvInvOrgIds.add(storageorgunit);
            }
        }
    }

    private void cacheCurSettingUserSelMatIds() {
        DataSet matDs;
        this.curSettingUserSelMatIdsCache = null;
        if (this.userSelMatIdsCache != null) {
            this.curSettingUserSelMatIdsCache = new HashSet<Long>(16);
            this.curSettingUserSelMatIdsCache.addAll(this.userSelMatIdsCache);
        }
        if ((matDs = this.getMatIdsByStandGroup(this.fallPriceExtractParam.getMatGroupIds(), this.userSelMatIdsCache)) != null) {
            HashSet<Long> matGroupMatIds = new HashSet<Long>(16);
            for (Row row : matDs) {
                matGroupMatIds.add(row.getLong(MATERIAL));
            }
            if (this.curSettingUserSelMatIdsCache == null) {
                this.curSettingUserSelMatIdsCache = matGroupMatIds;
            } else {
                this.curSettingUserSelMatIdsCache.retainAll(matGroupMatIds);
            }
        }
        this.filterMatCat();
    }

    private DataSet getNewBalDs(Boolean isContainDiffer) {
        StringBuilder balSelects = new StringBuilder();
        balSelects.append("accounttype,material balmaterial,material.baseunit balbaseunit, material.group balmatgroup, material.group.longnumber balgrouplnum,");
        balSelects.append("warehouse.group balwaregroup, warehouse.group.longnumber balwaregrouplnum,baseunit,calrange,caldimension.caldimension as caldimensionstr,baseqty_bal as periodendqty,");
        String periodEndActCostSel = "case when accounttype <> 'D' then actualcost_bal else 0 end as ";
        balSelects.append(periodEndActCostSel).append("periodendactualcost,");
        balSelects.append(periodEndActCostSel).append("periodendactualcostbak,");
        if (isContainDiffer.booleanValue()) {
            balSelects.append("case when accounttype = 'D' then standardcost_bal + costdiff_bal else 0 end as periodendstandardcost,");
        } else {
            balSelects.append("case when accounttype = 'D' then standardcost_bal else 0 end as periodendstandardcost,");
        }
        String dimStr = CalBalanceModelHelper.getDimFields((boolean)false);
        if (!dimStr.contains("calorg")) {
            balSelects.append("calorg,");
        }
        balSelects.append(dimStr);
        ArrayList<QFilter> balFilter = new ArrayList<QFilter>(16);
        QFilter periodf = new QFilter("period", "<=", (Object)this.fallPriceExtractParam.getCurrentPeriodNum());
        periodf.and(new QFilter("endperiod", ">", (Object)this.fallPriceExtractParam.getCurrentPeriodNum()));
        QFilter acctf = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
        balFilter.add(periodf);
        balFilter.add(acctf);
        QFilter ownerTypef = new QFilter("ownertype", "=", (Object)"bos_org");
        balFilter.add(ownerTypef);
        RowMeta rowMeta = ORM.create().createRowMeta("cal_bal", balSelects.toString());
        rowMeta.getField("periodendactualcost").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("periodendactualcostbak").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("periodendstandardcost").setDataType((DataType)DataType.BigDecimalType);
        DataSet balDs = this.queryDataSetSplitMatConc("cal_bal", balSelects.toString(), balFilter, MATERIAL, rowMeta, "storageorgunit");
        ArrayList<String> groupDims = new ArrayList<String>(Arrays.asList(dimStr.split(",")));
        groupDims.add("baseunit");
        groupDims.add("balmaterial");
        groupDims.add("balbaseunit");
        groupDims.add("balmatgroup");
        groupDims.add("balgrouplnum");
        groupDims.add("balwaregroup");
        groupDims.add("balwaregrouplnum");
        groupDims.add("calrange");
        groupDims.add("caldimensionstr");
        groupDims.add("calorg");
        groupDims.add("accounttype");
        balDs = balDs.groupBy(groupDims.toArray(new String[0])).max("periodendqty").sum("periodendactualcost").sum("periodendactualcostbak").sum("periodendstandardcost").finish();
        return balDs;
    }

    protected DataSet queryDataSetSplitMatConc(String entity, String selects, List<QFilter> otherFilters, String matField, RowMeta rowMeta, String invOrgField) {
        if (this.curSettingProvMatIdsCache != null && this.curSettingProvMatIdsCache.isEmpty()) {
            DataSet emptyDs = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
            return emptyDs;
        }
        Boolean isSplitInvOrg = CalDbParamServiceHelper.getBoolean((String)"fallprice_split_invorg");
        if (isSplitInvOrg.booleanValue() && StringUtils.isNotEmpty((CharSequence)invOrgField)) {
            otherFilters.add(new QFilter(invOrgField, "=", (Object)this.fallPriceExtractParam.getInvOrgId()));
        }
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        if (this.curSettingProvMatIdsCache == null) {
            OrmInput billOI = new OrmInput(this.getClass().getName(), entity, selects, otherFilters.toArray(new QFilter[0]), rowMeta);
            billOIs.add(billOI);
        } else {
            Lists.partition(new ArrayList<Long>(this.curSettingProvMatIdsCache), (int)this.batchSize).forEach(list -> {
                ArrayList<QFilter> curFilters = new ArrayList<QFilter>(16);
                curFilters.add(new QFilter(matField, "in", list));
                curFilters.addAll(otherFilters);
                OrmInput billOI = new OrmInput(this.getClass().getName(), entity, selects, curFilters.toArray(new QFilter[0]), rowMeta);
                billOIs.add(billOI);
            });
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet dataSet = algo.createDataSet((Input[])billOIs.toArray(new OrmInput[billOIs.size()]));
        return dataSet;
    }

    private DataSet getBalDs(Boolean isContainDiffer) {
        StringBuilder balSelects = new StringBuilder();
        balSelects.append("accounttype,calorg,costaccount,material,material balmaterial,material.baseunit balbaseunit, material.group balmatgroup, material.group.longnumber balgrouplnum,");
        balSelects.append("warehouse.group balwaregroup, warehouse.group.longnumber balwaregrouplnum, baseunit,calrange,caldimension.caldimension as caldimensionstr,periodendqty,");
        String periodEndActCostSel = "case when accounttype <> 'D' then periodendactualcost else 0 end as ";
        balSelects.append(periodEndActCostSel).append("periodendactualcost,");
        balSelects.append(periodEndActCostSel).append("periodendactualcostbak,");
        if (isContainDiffer.booleanValue()) {
            balSelects.append("case when accounttype = 'D' then periodendstandardcost + periodendcostdiff else 0 end as periodendstandardcost,");
        } else {
            balSelects.append("case when accounttype = 'D' then periodendstandardcost else 0 end as periodendstandardcost,");
        }
        balSelects.append(StringUtils.join((Object[])this.fallPriceExtractParam.getAllDims().toArray(new String[0]), (String)","));
        this.getCostCalDimensionStr(balSelects, StandardCostHelper.getCalDimensionSet((String)CommonSettingHelper.getCalDimensionStr()));
        ArrayList<QFilter> balFilter = new ArrayList<QFilter>(16);
        QFilter periodf = new QFilter("period", "<=", (Object)this.fallPriceExtractParam.getCurrentPeriodNum());
        periodf.and(new QFilter("endperiod", ">", (Object)this.fallPriceExtractParam.getCurrentPeriodNum()));
        QFilter acctf = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
        balFilter.add(periodf);
        balFilter.add(acctf);
        QFilter ownerTypef = new QFilter("ownertype", "=", (Object)"bos_org");
        balFilter.add(ownerTypef);
        RowMeta rowMeta = ORM.create().createRowMeta("cal_balance", balSelects.toString());
        rowMeta.getField("periodendactualcost").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("periodendactualcostbak").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("periodendstandardcost").setDataType((DataType)DataType.BigDecimalType);
        return this.queryDataSetSplitMatConc("cal_balance", balSelects.toString(), balFilter, MATERIAL, rowMeta, "storageorgunit");
    }

    private void getCostCalDimensionStr(StringBuilder select, Set<String> calDimensionSet) {
        if (calDimensionSet != null && calDimensionSet.size() > 0) {
            String tempStr = select.toString();
            for (String calDimension : calDimensionSet) {
                if (tempStr.contains(calDimension)) continue;
                select.append(",");
                select.append(calDimension);
            }
        }
    }

    protected void joinOnDims(String[] curDims, JoinDataSet settingJoinBalDs) {
        for (String dimStr : curDims) {
            if ("".equals(dimStr)) continue;
            settingJoinBalDs.on(dimStr, dimStr);
        }
    }

    protected DataSet getCurPeriodProvRecMatDs() {
        ArrayList<QFilter> accRecordFilter = new ArrayList<QFilter>(16);
        QFilter periodNumf = new QFilter("period", "=", (Object)this.fallPriceExtractParam.getCurrentPeriodNum());
        QFilter acctf = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
        accRecordFilter.add(periodNumf);
        accRecordFilter.add(acctf);
        String selectFields = "entry.material billmaterial,entry.storageorgunit storageorgunit";
        RowMeta rowMeta = ORM.create().createRowMeta("cal_price_provbill", selectFields);
        DataSet provDs = this.queryDataSetSplitMatConc("cal_price_provbill", selectFields, accRecordFilter, "entry.material", rowMeta, "entry.storageorgunit");
        Boolean isRevAndProv = (Boolean)ParamsHelper.getAppParam((long)((Long)this.fallPriceExtractParam.getCalOrgId()), (String)"revandprov");
        if (!isRevAndProv.booleanValue()) {
            RowMeta revRowMeta = ORM.create().createRowMeta("cal_price_revbill", selectFields);
            DataSet recDs = this.queryDataSetSplitMatConc("cal_price_revbill", selectFields, accRecordFilter, "entry.material", revRowMeta, "entry.storageorgunit");
            provDs = provDs.union(recDs);
        }
        provDs = provDs.groupBy(new String[]{"billmaterial", "storageorgunit"}).finish();
        return provDs;
    }

    private DataSet getProvBillDs() {
        String entryDimSelects = StringUtils.join((Object[])this.fallPriceExtractParam.getEntryDims().toArray(new String[0]), (String)",");
        ArrayList<QFilter> accRecordFilter = new ArrayList<QFilter>(16);
        QFilter periodNumf = new QFilter("entry.endperiod", "=", (Object)999999);
        QFilter acctf = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
        accRecordFilter.add(periodNumf);
        accRecordFilter.add(acctf);
        String proBillSelects = "entry.id as entryid, entry.material material,entry.warehousegroup as warehousegroup,case when isinitbill = '1' then entry.hasamount else entry.requireamount end as requireamount,entry.rushamount rushamount,entry.invagefrom invagefrom,entry.invageto invageto,entry.expirydatefrom expirydatefrom,entry.expirydateto expirydateto," + entryDimSelects;
        RowMeta rowMeta = ORM.create().createRowMeta("cal_price_provbill", proBillSelects);
        rowMeta.getField("requireamount").setDataType((DataType)DataType.BigDecimalType);
        return this.queryDataSetSplitMatConc("cal_price_provbill", proBillSelects, accRecordFilter, "entry.material", rowMeta, "entry.storageorgunit");
    }

    protected DataSet getStdMatCost(DataSet matBalAccDs, Set<String> settingBalGroupDims, Map<String, List<Map<String, Object>>> paramsMap) {
        this.removeStorgOrgDimIfAdd(settingBalGroupDims);
        if (this.isContainDiffer) {
            matBalAccDs = matBalAccDs.groupBy(settingBalGroupDims.toArray(new String[0])).sum("periodendactualcost").sum("periodendstandardcost").sum("periodendqty").sum("baseqty").sum("actualamount").sum("standardamount").finish();
            return matBalAccDs;
        }
        Date currPeriodLastDay = this.fallPriceExtractParam.getCurPeriodLastDay();
        boolean multifactoryaccountFlag = ParamsHelper.getMultifactoryaccountByCalOrg((Long)((Long)this.fallPriceExtractParam.getCalOrgId()));
        HashSet<Long> storageIds = new HashSet<Long>(16);
        if (multifactoryaccountFlag) {
            for (Row row : matBalAccDs.copy()) {
                storageIds.add(row.getLong("storageorgunit"));
            }
        }
        QFilter costtypeFilter = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
        costtypeFilter.and("effectdate", "<=", (Object)currPeriodLastDay);
        costtypeFilter.and("invaliddate", ">", (Object)currPeriodLastDay);
        if (multifactoryaccountFlag) {
            costtypeFilter.and("storageorgunit", "in", storageIds);
        }
        DataSet costTypeData = QueryServiceHelper.queryDataSet((String)"", (String)"cal_bd_costtypeorg", (String)"costaccount.id as costaccountId,storageorgunit.id as storageorgunitId,costtype.id as costtypeId", (QFilter[])costtypeFilter.toArray(), null);
        DataSet costInfoSet = new StandardCostHelper().getStandardCost(paramsMap, false);
        costInfoSet = costInfoSet.groupBy(new String[]{"costtype", MATERIAL, "effectdate", "expdate", "id", "standardprice"}).finish();
        GroupbyDataSet costInfoSetGroupDatatSet = costInfoSet.groupBy(new String[]{"costtype", MATERIAL});
        costInfoSetGroupDatatSet.sum("standardprice");
        costInfoSet = costInfoSetGroupDatatSet.finish();
        JoinDataSet joinDataSet = costTypeData.leftJoin(costInfoSet).on("costtypeId", "costtype");
        DataSet matCostDataSet = joinDataSet.select(new String[]{"costaccountId", "storageorgunitId"}, new String[]{MATERIAL, "standardprice"}).finish();
        joinDataSet = matBalAccDs.leftJoin(matCostDataSet).on("balmaterial", MATERIAL);
        if (multifactoryaccountFlag) {
            joinDataSet = joinDataSet.on("storageorgunit", "storageorgunitId");
        }
        matCostDataSet = joinDataSet.select(matBalAccDs.getRowMeta().getFieldNames(), new String[]{"standardprice"}).finish();
        String[] fieldNames = matBalAccDs.getRowMeta().getFieldNames();
        String[] newFieldNames = new String[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String item = fieldNames[i];
            if ("standardamount".equals(item)) {
                item = "case when accounttype = 'D' then standardprice*baseqty else 0.0 end as standardamount";
            }
            newFieldNames[i] = item;
        }
        matCostDataSet = matCostDataSet.select(newFieldNames);
        matCostDataSet = matCostDataSet.groupBy(settingBalGroupDims.toArray(new String[0])).sum("periodendactualcost").sum("periodendstandardcost").sum("periodendqty").sum("baseqty").sum("actualamount").sum("standardamount").finish();
        return matCostDataSet;
    }

    private DataSet getMatIdsByStandGroup(List<Long> matGroupIds, Set<Long> matIds) {
        DataSet materialDataSet = null;
        if (matGroupIds.isEmpty()) {
            return null;
        }
        StandGroupBaseDataConverter baseDataParser = new StandGroupBaseDataConverter("bd_materialgroupdetail", MATERIAL);
        baseDataParser.setBaseIds(matIds);
        String matSelField = "standard,material,group.longnumber as matgrouplnum,group detailmatgroup";
        materialDataSet = baseDataParser.getBaseDataDs(this.fallPriceParam.getMGS(), matGroupIds, matSelField);
        return materialDataSet;
    }

    @Override
    public void setUserSelMatIdsCache(Set<Long> userSelMatIdsCache) {
        this.userSelMatIdsCache = userSelMatIdsCache;
    }

    protected void setZeroValue(Boolean provAll, DynamicObject entryDyc, BigDecimal baseQty, BigDecimal endAmount, BigDecimal reqAmount) {
        boolean qtyZeroAmtLessZero;
        if (!provAll.booleanValue()) {
            return;
        }
        boolean endAmtLessEqualZero = reqAmount.compareTo(BigDecimal.ZERO) <= 0;
        boolean qtyNotZeroAmtLessZero = baseQty.compareTo(BigDecimal.ZERO) != 0 && endAmount.compareTo(BigDecimal.ZERO) <= 0;
        boolean bl = qtyZeroAmtLessZero = baseQty.compareTo(BigDecimal.ZERO) == 0 && endAmount.compareTo(BigDecimal.ZERO) != 0;
        if (provAll.booleanValue() && (endAmtLessEqualZero || qtyNotZeroAmtLessZero || qtyZeroAmtLessZero)) {
            Boolean onlyClearScale = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.FALLPRICE_ONLY_CLEAR_SCALE);
            entryDyc.set("fallpricescale", (Object)BigDecimal.ZERO);
            if (onlyClearScale.booleanValue()) {
                boolean baseQtyNotZero;
                BigDecimal price = BigDecimal.ZERO;
                boolean bl2 = baseQtyNotZero = baseQty.compareTo(BigDecimal.ZERO) != 0;
                if (baseQtyNotZero) {
                    price = endAmount.divide(baseQty, 10, 4);
                }
                entryDyc.set("baseprice", (Object)price);
            } else {
                entryDyc.set("realizableamount", (Object)BigDecimal.ZERO);
                entryDyc.set("unitrealizableamount", (Object)BigDecimal.ZERO);
                entryDyc.set("replenishamount", (Object)BigDecimal.ZERO);
            }
        }
        entryDyc.set("amount", (Object)endAmount);
        entryDyc.set("baseQty", (Object)baseQty);
    }

    private void filterMatCat() {
        List<Long> matCategoryIds = this.fallPriceExtractParam.getMatCategoryIds();
        if (matCategoryIds == null || matCategoryIds.isEmpty()) {
            return;
        }
        HashSet<Long> acctIds = new HashSet<Long>(1);
        acctIds.add((Long)this.fallPriceExtractParam.getCostAccountId());
        if (this.curSettingUserSelMatIdsCache == null) {
            Set catMaterialIds;
            MaterialCategoryHelper matCatHelper = MaterialCategoryHelper.getMaterialCategoryHelperByMatCat(acctIds, null, new HashSet<Long>(matCategoryIds));
            this.curSettingUserSelMatIdsCache = catMaterialIds = matCatHelper.getMaterialIds();
        } else {
            MaterialCategoryHelper matCatHelper = MaterialCategoryHelper.getMaterialCategoryHelperByMat(acctIds, null, this.curSettingUserSelMatIdsCache);
            Map org2Material2CategoryMap = matCatHelper.getOrg2Material2Category();
            HashMap matIdCatIdMap = new HashMap(16);
            for (Map map : org2Material2CategoryMap.values()) {
                matIdCatIdMap.putAll(map);
            }
            for (Map.Entry entry : matIdCatIdMap.entrySet()) {
                Long matId = (Long)entry.getKey();
                Long matCatId = (Long)entry.getValue();
                if (matCategoryIds.contains(matCatId)) continue;
                this.curSettingUserSelMatIdsCache.remove(matId);
            }
        }
    }

    protected Map<String, List<Map<String, Object>>> buildGetStdParams(DataSet balDs) {
        HashMap<String, List<Map<String, Object>>> paramsMap = new HashMap<String, List<Map<String, Object>>>(16);
        if (this.isContainDiffer) {
            return paramsMap;
        }
        Object costAcctId = this.fallPriceExtractParam.getCostAccountId();
        boolean isHasStdAcct = AccountingSysHelper.isHasAcctType(Collections.singleton((Long)costAcctId), Collections.singleton(AccountTypeEnum.STANDARDCOST.getValue()));
        if (!isHasStdAcct) {
            return paramsMap;
        }
        Set calDimensionSet = StandardCostHelper.getCalDimensionSet((String)CommonSettingHelper.getCalDimensionStr());
        HashMap acctInvOrgMatDimParamMap = new HashMap(16);
        IDGenerator idGenerator = new IDGenerator("");
        for (Row row : balDs.copy()) {
            String key;
            StringBuilder invOrgMatDimKeySb = new StringBuilder();
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            Long costAccountId = row.getLong("costaccount");
            Long storageorgId = row.getLong("storageorgunit");
            param.put("invorg", storageorgId);
            param.put("date", this.fallPriceExtractParam.getCurPeriodLastDay());
            param.put(MATERIAL, row.getLong(MATERIAL));
            invOrgMatDimKeySb.append(costAccountId).append("_").append(storageorgId).append("_").append(row.getLong(MATERIAL)).append("_");
            if (calDimensionSet != null && calDimensionSet.size() > 0) {
                for (String calDimension : calDimensionSet) {
                    Object value = row.get(calDimension);
                    if (value != null) {
                        if (value instanceof DynamicObject) {
                            param.put(calDimension, ((DynamicObject)value).getPkValue());
                        } else {
                            param.put(calDimension, value);
                        }
                    } else {
                        param.put(calDimension, 0L);
                    }
                    invOrgMatDimKeySb.append(param.get(calDimension)).append("_");
                }
            }
            if (acctInvOrgMatDimParamMap.containsKey(key = invOrgMatDimKeySb.toString())) continue;
            param.put("uniqueID", idGenerator.getId());
            acctInvOrgMatDimParamMap.put(key, param);
        }
        for (Map.Entry entry : acctInvOrgMatDimParamMap.entrySet()) {
            String paramKey = this.fallPriceExtractParam.getCalOrgId() + "_" + this.fallPriceExtractParam.getCostAccountId();
            List params = paramsMap.computeIfAbsent(paramKey, k -> new ArrayList(16));
            Map param = (Map)entry.getValue();
            params.add(param);
        }
        return paramsMap;
    }
}

