/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.fallprice.IFallPriceRevCal;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.FallPriceRevBill;
import kd.fi.cal.common.util.DateUtils;

public abstract class AbstractFallPriceRevCal
implements IFallPriceRevCal {
    protected static final String cur_period_out_qty = "curperiodoutqty";
    protected static final String cur_period_rush_qty = "curperiodrushqty";
    protected static final String cur_period_rush_amount = "curperiodrushamount";
    protected static final String base_qty = "baseqty";
    protected static final String period_id = "periodid";
    protected static final String entry = "entry";
    private static final String cost_account = "costaccount";
    protected List<ExtendedDataEntity> curEntities = new ArrayList<ExtendedDataEntity>(16);
    protected List<ExtendedDataEntity> otherEntities = new ArrayList<ExtendedDataEntity>(16);
    protected Map<Long, DynamicObject> provIdEntityMap = new HashMap<Long, DynamicObject>(16);
    protected Map<Long, Integer> provIdMaxRevPeriodMap = new HashMap<Long, Integer>(16);
    protected Map<Long, DynamicObject> costAcctIdCurPeriodDycMap = new HashMap<Long, DynamicObject>(16);

    public AbstractFallPriceRevCal(ExtendedDataEntity[] revEentities) {
        this.cacheProvBillDyc(revEentities);
        this.collect(revEentities);
    }

    private void collect(ExtendedDataEntity[] revEntitys) {
        for (ExtendedDataEntity entity : revEntitys) {
            if (this.isCurCal(entity)) {
                this.curEntities.add(entity);
                continue;
            }
            this.otherEntities.add(entity);
        }
    }

    protected String getDimensionValKey(DynamicObject provBill, DynamicObject entryInfo) {
        String[] setDimensionArray;
        StringBuilder sb = new StringBuilder();
        String setDimension = provBill.getString("accsetting.setdimension");
        String proDimension = provBill.getString("accsetting.provdimension");
        setDimension = setDimension + proDimension;
        MainEntityType balanceEntity = MetadataServiceHelper.getDataEntityType((String)"cal_balance");
        for (String dimStr : setDimensionArray = setDimension.split(",")) {
            String dimVal;
            IDataEntityProperty fieldProperty;
            if ("x".equals(dimStr) || StringUtils.isEmpty((CharSequence)dimStr) || (fieldProperty = balanceEntity.findProperty(dimStr)) == null) continue;
            if (fieldProperty instanceof BasedataProp) {
                dimVal = entryInfo.getString(dimStr + ".id");
                sb.append(dimVal).append(":");
                continue;
            }
            dimVal = entryInfo.getString(dimStr);
            sb.append(dimVal).append(":");
        }
        String warehousegroupid = entryInfo.getString("warehousegroup.id");
        sb.append(warehousegroupid).append(":");
        String materialid = entryInfo.getString("material.id");
        sb.append(materialid);
        return sb.toString();
    }

    protected Map<Long, FallPriceRevBill> getCurPeriodOutQtyMap(DynamicObject revBillDyc) {
        DataSet matBalDs = this.getRevDs(revBillDyc);
        HashMap<Long, FallPriceRevBill> fallPriceRevBillMap = new HashMap<Long, FallPriceRevBill>(16);
        for (Row row : matBalDs) {
            long sourceEntryId = row.getLong("entryid");
            BigDecimal periodIssueQty = row.getBigDecimal("periodissueqty");
            BigDecimal requireAmount = row.getBigDecimal("requireamount");
            FallPriceRevBill fallPriceRevBill = new FallPriceRevBill(requireAmount, periodIssueQty);
            fallPriceRevBillMap.put(sourceEntryId, fallPriceRevBill);
        }
        return fallPriceRevBillMap;
    }

    protected DataSet getNewBalanceDs(DynamicObject revBill, Set<Long> matIds) {
        long costAcctId = revBill.getLong("costaccount.id");
        Set<Integer> periodNums = this.getOutPeriodNums(revBill);
        QFilter balQf = new QFilter("period", "in", periodNums);
        balQf.and(cost_account, "=", (Object)costAcctId);
        QFilter matFilter = new QFilter("material", "in", matIds);
        balQf.and(matFilter);
        this.addSplitOrgFilter(revBill, balQf);
        String dimStr = CalBalanceModelHelper.getDimFields((boolean)false);
        String balSelects = "material balmaterial, material.group balmatgroup, material.group.longnumber balgrouplnum,warehouse.group balwaregroup, baseqty_out periodissueqty, baseqty_bal periodendqty,actualcost_bal periodendactualcost," + dimStr;
        DataSet balDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bal", (String)balSelects, (QFilter[])balQf.toArray(), null);
        ArrayList<String> groupDims = new ArrayList<String>(Arrays.asList(dimStr.split(",")));
        groupDims.add("balmaterial");
        groupDims.add("balmatgroup");
        groupDims.add("balgrouplnum");
        groupDims.add("balwaregroup");
        balDs = balDs.groupBy(groupDims.toArray(new String[0])).max("periodissueqty").max("periodendqty").sum("periodendactualcost").finish();
        return balDs;
    }

    protected Set<Integer> getOutPeriodNums(DynamicObject revBillDyc) {
        int periodNumber = revBillDyc.getInt("period");
        String provStrategy = revBillDyc.getString("accsetting.provstrategy");
        if (StringUtils.isEmpty((CharSequence)provStrategy)) {
            provStrategy = "A";
        }
        long sourceId = revBillDyc.getLong("sourcebillid");
        DynamicObject provBillDyc = this.provIdEntityMap.get(sourceId);
        Integer maxRevPeriod = this.provIdMaxRevPeriodMap.get(sourceId);
        maxRevPeriod = maxRevPeriod == null ? Integer.valueOf(0) : maxRevPeriod;
        int provPeriodNum = provBillDyc.getInt("period");
        provPeriodNum = Math.max(provPeriodNum, maxRevPeriod);
        HashSet<Integer> periodNums = new HashSet<Integer>(16);
        int maxPeriod = provPeriodNum;
        if ("A".equals(provStrategy)) {
            maxPeriod = periodNumber - 1;
        }
        for (int i = maxPeriod + 1; i <= periodNumber; ++i) {
            periodNums.add(i);
        }
        return periodNums;
    }

    protected DataSet getBalanceDs(DynamicObject revBillDyc, Set<String> dims, Set<Long> matIds) {
        long costAcctId = revBillDyc.getLong("costaccount.id");
        Set<Integer> periodNums = this.getOutPeriodNums(revBillDyc);
        QFilter balQf = new QFilter("period", "in", periodNums);
        balQf.and(cost_account, "=", (Object)costAcctId);
        this.addSplitOrgFilter(revBillDyc, balQf);
        QFilter matFilter = new QFilter("material", "in", matIds);
        balQf.and(matFilter);
        String balSelects = "calorg,costaccount,material balmaterial, material.group balmatgroup, material.group.longnumber balgrouplnum,warehouse.group balwaregroup, periodissueqty, periodendqty,periodendactualcost";
        if (dims.size() > 0) {
            balSelects = balSelects + "," + StringUtils.join((Object[])dims.toArray(new String[dims.size()]), (String)",");
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)balSelects, (QFilter[])balQf.toArray(), null);
    }

    private void addSplitOrgFilter(DynamicObject revBillDyc, QFilter balQf) {
        Boolean isSplitInvOrg = CalDbParamServiceHelper.getBoolean((String)"fallprice_split_invorg");
        if (isSplitInvOrg.booleanValue()) {
            HashSet<Long> invOrgIds = new HashSet<Long>(16);
            for (DynamicObject entryDyc : revBillDyc.getDynamicObjectCollection(entry)) {
                DynamicObject invOrgDyc = entryDyc.getDynamicObject("storageorgunit");
                if (invOrgDyc == null) continue;
                invOrgIds.add((Long)invOrgDyc.getPkValue());
            }
            if (!invOrgIds.isEmpty()) {
                balQf.and(new QFilter("storageorgunit", "in", invOrgIds));
            }
        }
    }

    protected DataSet getProvBillDs(Long sourceId, Set<String> setAndProvDims) {
        HashSet<String> entryDims = new HashSet<String>(setAndProvDims.size());
        for (String dim : setAndProvDims) {
            entryDims.add("entry." + dim + " as " + dim);
        }
        QFilter settingIdf = new QFilter("id", "=", (Object)sourceId);
        String entryDimSelects = StringUtils.join((Object[])entryDims.toArray(new String[0]), (String)",");
        String selectFields = "id provid,org,accsetting.setdimension as setdimension,accsetting.provdimension as provdimension,costaccount,entry.id entryid,entry.materialgroup materialgroup, entry.warehousegroup warehousegroup,entry.materialgroup.longnumber grouplnum,entry.material material,entry.requireamount as requireamount,entry.expirydatefrom expirydatefrom,entry.expirydateto expirydateto";
        if (!entryDimSelects.isEmpty()) {
            selectFields = selectFields + ", " + entryDimSelects;
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_price_provbill", (String)selectFields, (QFilter[])new QFilter[]{settingIdf}, null);
    }

    protected Set<Long> getMatIds(DynamicObject rushBillDyc) {
        HashSet<Long> matIds = new HashSet<Long>(16);
        for (DynamicObject entryDyc : rushBillDyc.getDynamicObjectCollection(entry)) {
            DynamicObject materialDyc = entryDyc.getDynamicObject("material");
            if (materialDyc == null) continue;
            matIds.add((Long)materialDyc.getPkValue());
        }
        return matIds;
    }

    protected void setBillHeadInfo(DynamicObject revBillDyc) {
        long costAccountId = revBillDyc.getLong("costaccount.id");
        DynamicObject curPeriod = this.getCurPeriodDyc(costAccountId);
        revBillDyc.set(period_id, (Object)curPeriod);
        int periodNum = curPeriod.getInt("periodyear") * 100 + curPeriod.getInt("periodnumber");
        revBillDyc.set("period", (Object)periodNum);
        revBillDyc.set("bizdate", (Object)DateUtils.getDayStartTime((Date)curPeriod.getDate("enddate")));
        revBillDyc.set("bookdate", (Object)DateUtils.getDayStartTime((Date)curPeriod.getDate("enddate")));
    }

    private void cacheProvBillDyc(ExtendedDataEntity[] revEentities) {
        ArrayList<Long> provBillIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity revEentity : revEentities) {
            DynamicObject revBillDyc = revEentity.getDataEntity();
            long provBillId = revBillDyc.getLong("sourcebillid");
            provBillIds.add(provBillId);
        }
        QFilter provBillIdFilter = new QFilter("id", "in", provBillIds);
        DynamicObjectCollection proBillDycs = QueryServiceHelper.query((String)"cal_price_provbill", (String)"id,bookdate,period", (QFilter[])provBillIdFilter.toArray());
        for (DynamicObject proBillDyc : proBillDycs) {
            this.provIdEntityMap.put(proBillDyc.getLong("id"), proBillDyc);
        }
        QFilter revBillIdFilter = new QFilter("sourcebillid", "in", provBillIds);
        DynamicObjectCollection revBillDycs = QueryServiceHelper.query((String)"cal_price_revbill", (String)"sourcebillid,period", (QFilter[])revBillIdFilter.toArray());
        for (DynamicObject revBillDyc : revBillDycs) {
            int period = revBillDyc.getInt("period");
            long srcBillId = revBillDyc.getLong("sourcebillid");
            Integer lastRevPeriod = this.provIdMaxRevPeriodMap.computeIfAbsent(srcBillId, k -> period);
            this.provIdMaxRevPeriodMap.put(srcBillId, Math.max(period, lastRevPeriod));
        }
    }

    private DynamicObject getCurPeriodDyc(long costAccountId) {
        DynamicObject cachePeriodDyc = this.costAcctIdCurPeriodDycMap.get(costAccountId);
        if (cachePeriodDyc == null) {
            cachePeriodDyc = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            this.costAcctIdCurPeriodDycMap.put(costAccountId, cachePeriodDyc);
        }
        return cachePeriodDyc;
    }
}

