/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.cal.common.util.ArrayUtils;
import kd.fi.cal.common.util.CommonUtils;

public class DealCalRangeFunction
extends MapFunction {
    private static final long serialVersionUID = 1276172570166864321L;
    private final Set<Long> emptyEntryRangeIds;
    private final String divStr;
    private final Set<String> calDims;
    private final List<String> calDimArr;
    private boolean bakDivDimField = false;
    private String calDimensionStrKey = "caldimensionstr";
    private String calRangeKey = "calrange";
    private Set<String> exclusion;
    private Set<String> realGroupCols;

    public DealCalRangeFunction(Set<Long> emptyEntryRangeIds, String divStr, String calDimStr, RowMeta sourceRowMeta) {
        this.emptyEntryRangeIds = emptyEntryRangeIds;
        this.divStr = divStr;
        this.calDimArr = !StringUtils.isEmpty((CharSequence)calDimStr) ? Arrays.asList(CommonUtils.trimComma((String)calDimStr).split(",")) : new ArrayList<String>();
        this.calDims = new HashSet<String>(this.calDimArr);
        this.sourceRowMeta = sourceRowMeta;
        this.exclusion = new HashSet<String>();
        this.realGroupCols = new HashSet<String>();
    }

    public Object[] map(Row row) {
        Object defaultValue;
        int i;
        String caldimension;
        List curList;
        String dividebasis;
        int fieldIndex;
        RowMeta resultRowMeta = this.getResultRowMeta();
        Object[] newRow = new Object[resultRowMeta.getFieldCount()];
        for (String fieldName : this.sourceRowMeta.getFieldNames()) {
            fieldIndex = resultRowMeta.getFieldIndex(fieldName);
            newRow[fieldIndex] = row.get(fieldName);
        }
        Long calRangeId = row.getLong(this.calRangeKey);
        String[] divFields = this.divStr.split(",");
        if (resultRowMeta.getFieldIndex("dividebasis", false) != -1 && !StringUtils.isEmpty((CharSequence)(dividebasis = (String)row.get(resultRowMeta.getFieldIndex("dividebasis"))))) {
            curList = Stream.of(dividebasis.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            this.realGroupCols.addAll(curList);
        }
        if (resultRowMeta.getFieldIndex("caldimension", false) != -1 && !StringUtils.isEmpty((CharSequence)(caldimension = (String)row.get(resultRowMeta.getFieldIndex("caldimension"))))) {
            curList = Stream.of(caldimension.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            this.realGroupCols.addAll(curList);
        }
        for (i = 0; i < divFields.length; ++i) {
            String div = divFields[i];
            fieldIndex = resultRowMeta.getFieldIndex(div);
            defaultValue = row.get(fieldIndex);
            if (!this.emptyEntryRangeIds.contains(calRangeId) && !this.exclusion.contains(div)) {
                defaultValue = this.getDeFaultValue(resultRowMeta, div);
            }
            if (this.isBakDivDimField()) {
                fieldIndex = this.sourceRowMeta.getFieldCount() + i;
            }
            newRow[fieldIndex] = defaultValue;
        }
        for (i = 0; i < this.calDimArr.size(); ++i) {
            String calDimField = this.calDimArr.get(i);
            fieldIndex = resultRowMeta.getFieldIndex(calDimField);
            defaultValue = row.get(fieldIndex);
            String curBillCalDimStr = row.getString(this.calDimensionStrKey);
            String string = curBillCalDimStr = StringUtils.isEmpty((CharSequence)curBillCalDimStr) ? "" : curBillCalDimStr;
            if (this.calDims.contains(calDimField) && !curBillCalDimStr.contains(calDimField) && !this.exclusion.contains(calDimField)) {
                defaultValue = this.getDeFaultValue(resultRowMeta, calDimField);
            }
            if (this.isBakDivDimField()) {
                fieldIndex = this.sourceRowMeta.getFieldCount() + divFields.length + i;
            }
            newRow[fieldIndex] = defaultValue;
        }
        long bakCalRangeId = this.emptyEntryRangeIds.contains(calRangeId) ? 0L : calRangeId;
        int calRangeDealIndex = resultRowMeta.getFieldIndex("calrangedeal", false);
        if (calRangeDealIndex >= 0) {
            newRow[calRangeDealIndex] = bakCalRangeId;
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.sourceRowMeta;
        if (this.isBakDivDimField()) {
            Object[] fields = sourceRowMeta.getFields();
            String[] divField = this.divStr.split(",");
            Field[] bakFields = new Field[divField.length];
            for (int i = 0; i < divField.length; ++i) {
                Field field = sourceRowMeta.getField(divField[i]);
                bakFields[i] = new Field(field.getName() + "bak", field.getDataType());
            }
            Field[] bakDimFields = new Field[this.calDimArr.size()];
            for (int i = 0; i < this.calDimArr.size(); ++i) {
                Field field = sourceRowMeta.getField(this.calDimArr.get(i));
                bakDimFields[i] = new Field(field.getName() + "bak", field.getDataType());
            }
            Field[] bakCalrangeFields = new Field[]{new Field("calrangedeal", (DataType)DataType.LongType)};
            return new RowMeta((Field[])ArrayUtils.concatAll((Object[])fields, (Object[][])new Field[][]{bakFields, bakDimFields, bakCalrangeFields}));
        }
        return sourceRowMeta;
    }

    public boolean isBakDivDimField() {
        return this.bakDivDimField;
    }

    public void setBakDivDimField(boolean bakDivDimField) {
        this.bakDivDimField = bakDivDimField;
    }

    private Object getDeFaultValue(RowMeta resultRowMeta, String field) {
        DataType dataType = resultRowMeta.getField(field).getDataType();
        Object defaultValue = null;
        if (dataType instanceof LongType) {
            defaultValue = 0L;
        } else if (dataType instanceof StringType) {
            defaultValue = "";
        } else if (dataType instanceof IntegerType) {
            defaultValue = 0;
        } else if (dataType instanceof BigDecimalType) {
            defaultValue = BigDecimal.ZERO;
        } else if (dataType instanceof BooleanType) {
            defaultValue = Boolean.TRUE;
        }
        return defaultValue;
    }

    public void setExclusion(Set<String> exclusion) {
        this.exclusion.addAll(exclusion);
    }

    public Set<String> getRealGroupCols() {
        return this.realGroupCols;
    }

    public void setCalDimensionStrKey(String calDimensionStrKey) {
        this.calDimensionStrKey = calDimensionStrKey;
    }

    public void setCalRangeKey(String calRangeKey) {
        this.calRangeKey = calRangeKey;
    }
}

