/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.util.StringUtils;

public class DealTranBillSrcTgtFunction
extends ReduceGroupFunction {
    public Iterator<Object[]> reduce(Iterator<Row> iter) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        RowMeta resultRowMeta = this.getResultRowMeta();
        int transTypeIndex = resultRowMeta.getFieldIndex("transtype");
        int inGroupIndex = resultRowMeta.getFieldIndex("ingroup");
        int inWarehouseIndex = resultRowMeta.getFieldIndex("inwarehouse");
        int inLocationIndex = resultRowMeta.getFieldIndex("inlocation");
        int inOwnerIndex = resultRowMeta.getFieldIndex("inowner");
        int bizBillEntryidIndex = resultRowMeta.getFieldIndex("bizbillentryid");
        int materialIndex = resultRowMeta.getFieldIndex("materialid");
        int calBillTypeIndex = resultRowMeta.getFieldIndex("calbilltype");
        int billNoIndex = resultRowMeta.getFieldIndex("billno");
        int outGroupIndex = resultRowMeta.getFieldIndex("outgroup");
        int outWarehouseIndex = resultRowMeta.getFieldIndex("outwarehouse");
        int outLocationIndex = resultRowMeta.getFieldIndex("outlocation");
        int outOwnerIndex = resultRowMeta.getFieldIndex("outowner");
        int outCostAcctIndex = resultRowMeta.getFieldIndex("outcostaccountnumber");
        HashMap<Long, Row> inBizBillEntryIdRowMap = new HashMap<Long, Row>(16);
        HashMap<Long, Row> outBizBillEntryIdSrcRowMap = new HashMap<Long, Row>(16);
        HashMap<Long, Row> outSrcBizBillEntryIdSrcRowMap = new HashMap<Long, Row>(16);
        while (iter.hasNext()) {
            Row srcRow = iter.next();
            String calBillType = srcRow.getString("calbilltype");
            boolean isInCalBill = "IN".equals(calBillType);
            Long bizBillEntryId = srcRow.getLong("bizbillentryid");
            Long srcBizBillEntryId = srcRow.getLong("srcbizbillentryid");
            if (isInCalBill) {
                inBizBillEntryIdRowMap.put(bizBillEntryId, srcRow);
                continue;
            }
            outBizBillEntryIdSrcRowMap.put(bizBillEntryId, srcRow);
            outSrcBizBillEntryIdSrcRowMap.put(srcBizBillEntryId, srcRow);
        }
        for (Map.Entry entry : inBizBillEntryIdRowMap.entrySet()) {
            String transType;
            Object[] newRow;
            Long inBizBillEntryId = (Long)entry.getKey();
            Row tgtInRow = (Row)entry.getValue();
            Row srcOutRow = (Row)outBizBillEntryIdSrcRowMap.get(inBizBillEntryId);
            if (srcOutRow == null) {
                Long srcBizBillEntryId = tgtInRow.getLong("srcbizbillentryid");
                srcOutRow = (Row)outSrcBizBillEntryIdSrcRowMap.get(srcBizBillEntryId);
            } else {
                newRow = new Object[resultRowMeta.getFieldCount()];
                newRow[transTypeIndex] = srcOutRow.getString("transtype");
                newRow[inGroupIndex] = srcOutRow.getLong("warehousegroup");
                newRow[inWarehouseIndex] = srcOutRow.getLong("warehouse");
                newRow[inLocationIndex] = srcOutRow.getLong("location");
                newRow[inOwnerIndex] = srcOutRow.getLong("owner");
                newRow[bizBillEntryidIndex] = srcOutRow.getLong("bizbillentryid");
                newRow[materialIndex] = srcOutRow.getLong("materialid");
                newRow[calBillTypeIndex] = srcOutRow.getString("calbilltype");
                newRow[billNoIndex] = srcOutRow.getString("billno");
                newRow[outGroupIndex] = tgtInRow.getLong("warehousegroup");
                newRow[outWarehouseIndex] = tgtInRow.getLong("warehouse");
                newRow[outLocationIndex] = tgtInRow.getLong("location");
                newRow[outOwnerIndex] = tgtInRow.getLong("owner");
                newRow[outCostAcctIndex] = tgtInRow.getLong("costaccountnumber");
                transType = (String)newRow[transTypeIndex];
                if (StringUtils.isNotEmpty((String)transType)) {
                    dataList.add(newRow);
                }
            }
            if (srcOutRow == null) continue;
            newRow = new Object[resultRowMeta.getFieldCount()];
            newRow[transTypeIndex] = tgtInRow.getString("transtype");
            newRow[inGroupIndex] = tgtInRow.getLong("warehousegroup");
            newRow[inWarehouseIndex] = tgtInRow.getLong("warehouse");
            newRow[inLocationIndex] = tgtInRow.getLong("location");
            newRow[inOwnerIndex] = tgtInRow.getLong("owner");
            newRow[bizBillEntryidIndex] = tgtInRow.getLong("bizbillentryid");
            newRow[materialIndex] = tgtInRow.getLong("materialid");
            newRow[calBillTypeIndex] = tgtInRow.getString("calbilltype");
            newRow[billNoIndex] = tgtInRow.getString("billno");
            newRow[outGroupIndex] = srcOutRow.getLong("warehousegroup");
            newRow[outWarehouseIndex] = srcOutRow.getLong("warehouse");
            newRow[outLocationIndex] = srcOutRow.getLong("location");
            newRow[outOwnerIndex] = srcOutRow.getLong("owner");
            newRow[outCostAcctIndex] = srcOutRow.getLong("costaccountnumber");
            transType = (String)newRow[transTypeIndex];
            if (!StringUtils.isNotEmpty((String)transType)) continue;
            dataList.add(newRow);
        }
        return dataList.iterator();
    }

    public RowMeta getResultRowMeta() {
        Field[] fields = new Field[]{new Field("transtype", (DataType)DataType.StringType), new Field("ingroup", (DataType)DataType.LongType), new Field("outgroup", (DataType)DataType.LongType), new Field("inwarehouse", (DataType)DataType.LongType), new Field("outwarehouse", (DataType)DataType.LongType), new Field("inlocation", (DataType)DataType.LongType), new Field("outlocation", (DataType)DataType.LongType), new Field("inowner", (DataType)DataType.LongType), new Field("outowner", (DataType)DataType.LongType), new Field("outcostaccountnumber", (DataType)DataType.LongType), new Field("bizbillentryid", (DataType)DataType.LongType), new Field("materialid", (DataType)DataType.LongType), new Field("calbilltype", (DataType)DataType.StringType), new Field("billno", (DataType)DataType.StringType)};
        return new RowMeta(fields);
    }
}

