/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.fallprice.AbstractFallPriceProvCal;
import kd.fi.cal.business.fallprice.DealCalRangeFunction;
import kd.fi.cal.business.fallprice.DealTranBillSrcTgtFunction;
import kd.fi.cal.business.fallprice.FallPriceExtractParam;
import kd.fi.cal.business.fallprice.FallPriceSettingParam;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.util.DateUtils;

public class FallPriceAgeProvCal
extends AbstractFallPriceProvCal {
    private Set<Long> notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType();
    private static final String[] TRANS_ENTITIES = new String[]{"im_transdirbill", "im_transoutbill", "im_transinbill"};

    public FallPriceAgeProvCal(FallPriceSettingParam fallPriceParam, FallPriceExtractParam fallPriceExtractParam) {
        super(fallPriceParam, fallPriceExtractParam);
    }

    @Override
    public DataSet getExtractDataSet() {
        DataSet settingDs = this.getSettingDs();
        String[] settingDsFields = settingDs.getRowMeta().getFieldNames();
        Set<String> settingBalGroupDims = this.getSetAndBalGroupDims(settingDsFields);
        DataSet balDs = this.getPeriodBalDs();
        Map<String, List<Map<String, Object>>> paramsMap = this.buildGetStdParams(balDs);
        balDs = this.getDomainBalDs(balDs);
        DataSet matBalDs = this.settingJoinBalDs(settingDs, settingBalGroupDims, balDs);
        DataSet curProvRevDs = this.getCurPeriodProvRecMatDs();
        matBalDs = this.setBalJoinCurProvRevDs(matBalDs, curProvRevDs);
        DataSet matBalAccDs = this.getAgeDs(matBalDs);
        String[] fieldNames = matBalDs.getRowMeta().getFieldNames();
        matBalAccDs = matBalAccDs.groupBy(fieldNames).sum("baseqty").sum("actualamount").sum("standardamount").finish();
        matBalAccDs = this.getStdMatCost(matBalAccDs, settingBalGroupDims, paramsMap);
        matBalAccDs = this.matBalAccJoinProvBillDs(matBalAccDs);
        return matBalAccDs;
    }

    private DataSet getDomainBalDs(DataSet balDs) {
        if (this.fallPriceParam.getMaxAge() <= 0) {
            return balDs;
        }
        Set<Long> emptyEntryRangeIds = this.getEmptyENtryRangeIds();
        DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)this.fallPriceExtractParam.getCostAccountId(), (String)"cal_bd_costaccount");
        String divStr = accountDyc.getString("dividebasis.dividebasis");
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        String[] divRangeDims = (String[])kd.fi.cal.common.util.ArrayUtils.concatAll((Object[])this.getDivRangeDims(divStr, calDimensionStr), (Object[][])new String[][]{{"material"}});
        DealCalRangeFunction srcBalCalRangeFun = new DealCalRangeFunction(emptyEntryRangeIds, divStr, calDimensionStr, balDs.getRowMeta());
        srcBalCalRangeFun.setBakDivDimField(true);
        balDs = balDs.map((MapFunction)srcBalCalRangeFun);
        DataSet periodBalDs = this.getBalDomainPriceDs(emptyEntryRangeIds, divStr, calDimensionStr, divRangeDims);
        JoinDataSet balJoinDomainDs = balDs.join(periodBalDs);
        this.joinOnDims(divRangeDims, balJoinDomainDs);
        Object[] balFields = balDs.getRowMeta().getFieldNames();
        balFields = (String[])ArrayUtils.removeElement((Object[])balFields, (Object)"periodendactualcost");
        int amtPrecision = this.fallPriceParam.getCurrencyAmtPrecision();
        balDs = balJoinDomainDs.select((String[])balFields, new String[]{"Round(domainactprice * periodendqty," + amtPrecision + ") as periodendactualcost"}).finish();
        return balDs;
    }

    @Override
    public String createProvBill(DataSet matBalAccDs) {
        Boolean provAll = (Boolean)ParamsHelper.getAppParam((long)((Long)this.fallPriceExtractParam.getCalOrgId()), (String)"provall");
        String provBillNo = "";
        DynamicObject provDyc = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_price_provbill"));
        String number = CodeRuleServiceHelper.getNumber((String)"cal_price_provbill", (DynamicObject)provDyc, null);
        if (number == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8dcc\u4ef7\u8ba1\u63d0\u5355\u7684\u7f16\u53f7\u89c4\u5219\u3002", (String)"FallPriceExtractor_4", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entryDycs = provDyc.getDynamicObjectCollection("entry");
        ArrayList<Object[]> entryIds = new ArrayList<Object[]>(16);
        int seq = 1;
        ArrayList<String> orders = new ArrayList<String>();
        orders.add("warehousegroup");
        String[] dimDists = (String[])kd.fi.cal.common.util.ArrayUtils.concatAll((Object[])this.fallPriceParam.getCurDims(), (Object[][])new String[][]{this.fallPriceParam.getProvDims()});
        for (String curDim : dimDists = new HashSet<String>(Arrays.asList(dimDists)).toArray(new String[0])) {
            if (StringUtils.isBlank((CharSequence)curDim)) continue;
            orders.add(curDim);
        }
        orders.add("balmaterial");
        orders.add("invageto");
        matBalAccDs = matBalAccDs.orderBy(orders.toArray(new String[0]));
        HashMap<String, BigDecimal> hasQtyRecord = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> hasStandardRecord = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> hasActualRecord = new HashMap<String, BigDecimal>();
        for (Row row : matBalAccDs) {
            boolean isQtyAmtZero;
            boolean isReqAmtHasAmtZero;
            String hasKey = this.getHasKeyByDims(orders, row);
            DynamicObject entryDyc = new DynamicObject(entryDycs.getDynamicObjectType());
            this.setFixEntryInfo(seq, row, entryDyc);
            BigDecimal endQty = row.getBigDecimal("periodendqty");
            if (endQty == null) {
                endQty = BigDecimal.ZERO;
            }
            BigDecimal ageQty = row.getBigDecimal("baseqty");
            BigDecimal actualAmount = row.getBigDecimal("actualamount") == null ? BigDecimal.ZERO : row.getBigDecimal("actualamount");
            BigDecimal standardAmount = row.getBigDecimal("standardamount") == null ? BigDecimal.ZERO : row.getBigDecimal("standardamount");
            BigDecimal ageAmount = actualAmount.add(standardAmount);
            if (ageQty == null) {
                ageQty = BigDecimal.ZERO;
                ageAmount = BigDecimal.ZERO;
            }
            BigDecimal periodActualCost = row.getBigDecimal("periodendactualcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodendactualcost");
            BigDecimal periodEndStandardCost = row.getBigDecimal("periodendstandardcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodendstandardcost");
            BigDecimal periodEndCost = periodActualCost.add(periodEndStandardCost);
            BigDecimal baseQty = BigDecimal.ZERO;
            BigDecimal endAmount = BigDecimal.ZERO;
            Integer invAgeFrom = row.getInteger("invagefrom");
            Integer invAgeTo = row.getInteger("invageto");
            hasQtyRecord.putIfAbsent(hasKey, endQty);
            hasActualRecord.putIfAbsent(hasKey, periodActualCost);
            hasStandardRecord.putIfAbsent(hasKey, periodEndStandardCost);
            if (invAgeTo == 999999 && invAgeFrom == 0) {
                baseQty = endQty;
                endAmount = periodEndCost;
            } else if (invAgeTo == 999999 && invAgeFrom != 0) {
                if (endQty.compareTo(ageQty) > 0) {
                    baseQty = endQty.subtract(ageQty);
                    if (periodEndCost.compareTo(ageAmount) > 0) {
                        endAmount = periodEndCost.subtract(ageAmount);
                    }
                }
            } else {
                BigDecimal hasQty = (BigDecimal)hasQtyRecord.get(hasKey);
                BigDecimal hasActual = (BigDecimal)hasActualRecord.get(hasKey);
                BigDecimal hasStandard = (BigDecimal)hasStandardRecord.get(hasKey);
                if (ageQty.compareTo(hasQty) <= 0) {
                    baseQty = ageQty;
                    hasQty = hasQty.subtract(ageQty);
                } else {
                    baseQty = hasQty;
                    hasQty = BigDecimal.ZERO;
                }
                hasQtyRecord.put(hasKey, hasQty);
                if (actualAmount.compareTo(hasActual) <= 0) {
                    hasActual = hasActual.subtract(actualAmount);
                } else {
                    actualAmount = hasActual;
                    hasActual = BigDecimal.ZERO;
                }
                hasActualRecord.put(hasKey, hasActual);
                if (standardAmount.compareTo(hasStandard) <= 0) {
                    hasStandard = hasStandard.subtract(standardAmount);
                } else {
                    standardAmount = hasStandard;
                    hasStandard = BigDecimal.ZERO;
                }
                hasStandardRecord.put(hasKey, hasStandard);
                endAmount = actualAmount.add(standardAmount);
            }
            boolean qtyLessEqualZero = baseQty.compareTo(BigDecimal.ZERO) <= 0;
            boolean endAmountLessEqualZero = endAmount.compareTo(BigDecimal.ZERO) <= 0;
            BigDecimal price = BigDecimal.ZERO;
            if (!qtyLessEqualZero && !endAmountLessEqualZero) {
                price = endAmount.divide(baseQty, 10, 4);
            }
            entryDyc.set("amount", (Object)endAmount);
            entryDyc.set("baseQty", (Object)baseQty);
            entryDyc.set("baseprice", (Object)price);
            this.calRealAmt(row, entryDyc);
            Long preEntryId = row.getLong("entryid");
            boolean exitPreEntry = preEntryId != null && !preEntryId.equals(0L);
            BigDecimal reqAmount = entryDyc.getBigDecimal("requireamount");
            BigDecimal hasAmount = entryDyc.getBigDecimal("hasamount");
            boolean bl = isReqAmtHasAmtZero = reqAmount.compareTo(BigDecimal.ZERO) == 0 && hasAmount.compareTo(BigDecimal.ZERO) == 0;
            if (!provAll.booleanValue() && isReqAmtHasAmtZero) continue;
            boolean bl2 = isQtyAmtZero = baseQty.compareTo(BigDecimal.ZERO) == 0 && endAmount.compareTo(BigDecimal.ZERO) == 0;
            if (isQtyAmtZero) continue;
            this.setZeroValue(provAll, entryDyc, baseQty, endAmount, reqAmount);
            if (exitPreEntry) {
                entryIds.add(new Object[]{this.fallPriceExtractParam.getCurrentPeriodNum(), preEntryId});
            }
            ++seq;
            entryDycs.add((Object)entryDyc);
        }
        if (entryDycs.size() > 0) {
            provBillNo = number;
            this.setBillHeadInfo(provDyc, provBillNo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{provDyc});
        }
        if (entryIds.size() > 0) {
            this.updateLastProvEndPeriod(entryIds);
        }
        return provBillNo;
    }

    private DataSet getAgeDs(DataSet matBalDs) {
        int maxAge = this.fallPriceParam.getMaxAge();
        if (maxAge <= 0) {
            matBalDs = matBalDs.addNullField("bookdate").addField("0", "baseqty").addField("0", "actualamount").addField("0", "standardamount");
            return matBalDs;
        }
        String[] joinDims = this.getSetAndProvDims();
        DataSet calBillDs = this.getCalBillDs(this.fallPriceParam);
        DataSet matBalZeroSet = matBalDs.copy();
        JoinDataSet matBalDsJoinAcctRecordDs = matBalDs.leftJoin(calBillDs);
        matBalDsJoinAcctRecordDs.on("accounttype", "accounttype");
        matBalDsJoinAcctRecordDs.on("balmaterial", "material");
        if ("warehousegroup".equals(this.fallPriceParam.getExtractWay())) {
            matBalDsJoinAcctRecordDs.on("warehousegroup", "warehousegroup");
        }
        HashSet<String> joinDimDists = new HashSet<String>(Arrays.asList(joinDims));
        this.joinOnDims(joinDimDists.toArray(new String[0]), matBalDsJoinAcctRecordDs);
        DataSet matBalAccDs = this.filterAgeDs(matBalDs, matBalDsJoinAcctRecordDs);
        matBalZeroSet = matBalZeroSet.addNullField("bookdate").addField("0", "baseqty").addField("0", "actualamount").addField("0", "standardamount");
        matBalAccDs = matBalAccDs.union(matBalZeroSet);
        return matBalAccDs;
    }

    private DataSet calAgeCostByDomainPrice(DataSet calBillDs, Set<Long> emptyEntryRangeIds, String divStr, String calDimStr, String[] divRangeDims) {
        if (this.fallPriceParam.getMaxAge() <= 0) {
            return calBillDs;
        }
        DataSet periodBalDs = this.getBalDomainPriceDs(emptyEntryRangeIds, divStr, calDimStr, divRangeDims);
        Object[] calBillFields = calBillDs.getRowMeta().getFieldNames();
        DealCalRangeFunction billCalRangeFun = new DealCalRangeFunction(emptyEntryRangeIds, divStr, calDimStr, calBillDs.getRowMeta());
        billCalRangeFun.setBakDivDimField(true);
        calBillDs = calBillDs.map((MapFunction)billCalRangeFun);
        JoinDataSet calBillJoinBalDs = calBillDs.join(periodBalDs);
        this.joinOnDims(divRangeDims, calBillJoinBalDs);
        calBillFields = (String[])ArrayUtils.removeElement((Object[])calBillFields, (Object)"actualamount");
        calBillFields = (String[])ArrayUtils.removeElement((Object[])calBillFields, (Object)"standardamount");
        int amtPrecision = this.fallPriceParam.getCurrencyAmtPrecision();
        calBillDs = calBillJoinBalDs.select((String[])calBillFields, new String[]{"Round(domainactprice * baseqty," + amtPrecision + ") as actualamount", "standardamount"}).finish();
        return calBillDs;
    }

    private DataSet getBalDomainPriceDs(Set<Long> emptyEntryRangeIds, String divStr, String calDimStr, String[] divRangeDims) {
        DataSet periodBalDs = this.getPeriodBalDs();
        DealCalRangeFunction balCalRangeFun = new DealCalRangeFunction(emptyEntryRangeIds, divStr, calDimStr, periodBalDs.getRowMeta());
        balCalRangeFun.setBakDivDimField(true);
        periodBalDs = periodBalDs.map((MapFunction)balCalRangeFun);
        periodBalDs = periodBalDs.groupBy(divRangeDims).sum("periodendqty", "domainendqty").sum("periodendstandardcost", "domainstdcost").sum("periodendactualcost", "domainactcost").finish();
        String[] domainPriceSel = new String[]{"case when domainendqty <> 0 then Round(domainactcost/domainendqty, 10)  else 0 end as domainactprice", "case when domainendqty <> 0 then Round(domainstdcost/domainendqty, 10)  else 0 end as domainstdprice"};
        periodBalDs = periodBalDs.select((String[])kd.fi.cal.common.util.ArrayUtils.concatAll((Object[])periodBalDs.getRowMeta().getFieldNames(), (Object[][])new String[][]{domainPriceSel}));
        return periodBalDs;
    }

    private Set<Long> getEmptyENtryRangeIds() {
        QFilter filter = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])filter.toArray());
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        return emptyEntryRangeIds;
    }

    protected DataSet getCalBillDs(FallPriceSettingParam fallPriceSettingParam) {
        int maxAge = fallPriceSettingParam.getMaxAge();
        List<QFilter> calRecordf = this.getCostRecordBillFilter(maxAge, this.curPeriodLastDay);
        List<QFilter> calAdjf = this.getCostAdjBillFilter(maxAge, this.curPeriodLastDay);
        String costRecordSelects = this.getCostRecordFields();
        String costAdjBillSelects = this.getCostAdjustFields(this.isContainDiffer);
        String costDiffSelects = this.getCostDiffFields();
        String noCalAgeBillFilterStr = this.getNoCalAgeBillFilterStr(fallPriceSettingParam);
        if (StringUtils.isNotEmpty((CharSequence)noCalAgeBillFilterStr)) {
            QFilter noCalAgeBillFilter = QFilter.of((String)noCalAgeBillFilterStr, (Object[])new Object[0]);
            calRecordf.add(noCalAgeBillFilter);
        }
        RowMeta rowMeta = ORM.create().createRowMeta("cal_costrecord", costRecordSelects);
        rowMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("actualamount").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("standardamount").setDataType((DataType)DataType.BigDecimalType);
        DataSet calRecordDs = this.queryDataSetSplitMatConc("cal_costrecord", costRecordSelects, calRecordf, "entry.material", rowMeta, "storageorgunit");
        RowMeta adjRowMeta = ORM.create().createRowMeta("cal_costadjustbill", costAdjBillSelects);
        adjRowMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("actualamount").setDataType((DataType)DataType.BigDecimalType);
        adjRowMeta.getField("standardamount").setDataType((DataType)DataType.BigDecimalType);
        RowMeta diffRowMeta = ORM.create().createRowMeta("cal_stdcostdiffbill", costDiffSelects);
        diffRowMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
        diffRowMeta.getField("actualamount").setDataType((DataType)DataType.BigDecimalType);
        diffRowMeta.getField("standardamount").setDataType((DataType)DataType.BigDecimalType);
        DataSet transdBillSet = this.getTransBillDataSetNew();
        String transFields = "transtype,ingroup,outgroup,inwarehouse,outwarehouse,inlocation,outlocation,inowner,outowner,outcostaccountnumber,billno";
        String[] finalFields = calRecordDs.getRowMeta().getFieldNames();
        ArrayList<String> newFields = new ArrayList<String>(Arrays.asList(finalFields));
        newFields.remove("calbilltype");
        finalFields = newFields.toArray(new String[0]);
        calRecordDs = calRecordDs.leftJoin(transdBillSet).on("bizbillentryid", "bizbillentryid").on("material", "materialid").on("calbilltype", "calbilltype").select(finalFields, transFields.split(",")).finish();
        boolean wareGroupFlag = "warehousegroup".equals(fallPriceSettingParam.getExtractWay());
        String[] selectDims = (String[])kd.fi.cal.common.util.ArrayUtils.concatAll((Object[])fallPriceSettingParam.getCurDims(), (Object[][])new String[][]{fallPriceSettingParam.getProvDims()});
        HashSet<String> dimDists = new HashSet<String>(Arrays.asList(selectDims));
        String selectDimsStr = Arrays.toString(dimDists.toArray(new String[0]));
        if (selectDimsStr.contains("location")) {
            String locationFilter = "(inlocation = null and outlocation <> null) or (inlocation <> null and outlocation = null) or (inlocation = null and outlocation = null and (inwarehouse = null or outwarehouse = null or (inwarehouse <> null and outwarehouse <> null and inwarehouse <> outwarehouse))) or (inlocation <> null and outlocation <> null and inlocation <> outlocation)";
            locationFilter = locationFilter + " or (inlocation = 0 and outlocation = 0 and (inwarehouse = null or outwarehouse = null or (inwarehouse <> null and outwarehouse <> null and inwarehouse <> outwarehouse))) ";
            calRecordDs = calRecordDs.filter(locationFilter);
        } else if (selectDimsStr.contains("warehouse")) {
            calRecordDs = calRecordDs.filter("inwarehouse = null or outwarehouse = null or (inwarehouse <> null and outwarehouse <> null and inwarehouse <> outwarehouse)");
        } else if (wareGroupFlag) {
            calRecordDs = calRecordDs.filter("ingroup = null or outgroup = null or (ingroup <> null and outgroup <> null and ingroup <> outgroup)");
        } else if (selectDimsStr.contains("storageorgunit")) {
            if (!this.isAddStorOrg) {
                calRecordDs = calRecordDs.filter("transtype <> 'A'");
            }
        } else if (selectDimsStr.contains("owner")) {
            calRecordDs = calRecordDs.filter("inowner = null or outowner = null or (inowner <> null and outowner <> null and inowner <> outowner)");
        }
        if (!selectDimsStr.contains("location")) {
            calRecordDs = calRecordDs.filter("billtype.id <> 757727698490869760");
        }
        if (selectDimsStr.contains("[]")) {
            calRecordDs = calRecordDs.filter("costaccountnumber = null or outcostaccountnumber = null or  (costaccountnumber <> outcostaccountnumber)");
        }
        calRecordDs = calRecordDs.select(finalFields).removeFields(new String[]{"bizbillentryid", "billtype.id", "bizbillid"});
        Set<Long> emptyEntryRangeIds = this.getEmptyENtryRangeIds();
        DynamicObject accountDyc = BusinessDataServiceHelper.loadSingleFromCache((Object)this.fallPriceExtractParam.getCostAccountId(), (String)"cal_bd_costaccount");
        String divStr = accountDyc.getString("dividebasis.dividebasis");
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        String[] divRangeDims = (String[])kd.fi.cal.common.util.ArrayUtils.concatAll((Object[])this.getDivRangeDims(divStr, calDimensionStr), (Object[][])new String[][]{{"material"}});
        DataSet unionDs = calRecordDs;
        String[] calBillSels = calRecordDs.getRowMeta().getFieldNames();
        DataSet initCalBillDs = this.getInitCalBillDs(maxAge);
        if (initCalBillDs != null) {
            initCalBillDs = this.doSameField(calBillSels, initCalBillDs);
            unionDs = unionDs.union(initCalBillDs);
        }
        unionDs = this.calAgeCostByDomainPrice(unionDs, emptyEntryRangeIds, divStr, calDimensionStr, divRangeDims);
        if (this.isContainDiffer) {
            DataSet adjDs = this.queryDataSetSplitMatConc("cal_costadjustbill", costAdjBillSelects, calAdjf, "entryentity.material", adjRowMeta, "entryentity.storageorgunit");
            adjDs = this.doSameField(calBillSels, adjDs);
            DataSet diffDs = this.queryDataSetSplitMatConc("cal_stdcostdiffbill", costDiffSelects, calAdjf, "entryentity.material", diffRowMeta, "entryentity.storageorgunit");
            diffDs = this.doSameField(calBillSels, diffDs);
            unionDs = unionDs.union(new DataSet[]{adjDs, diffDs});
        }
        return unionDs;
    }

    private DataSet doSameField(String[] baseBillSels, DataSet curCalBillDs) {
        Object[] intBillSels = curCalBillDs.getRowMeta().getFieldNames();
        boolean isFieldEqual = Arrays.equals(baseBillSels, intBillSels);
        if (!isFieldEqual) {
            curCalBillDs = curCalBillDs.select(baseBillSels);
        }
        return curCalBillDs;
    }

    private String[] getDivRangeDims(String divStr, String calDimensionStr) {
        int i;
        String[] divFields = divStr.split(",");
        Object[] bakDivFields = divStr.split(",");
        String[] calDims = calDimensionStr.split(",");
        String[] bakCalDims = calDimensionStr.split(",");
        for (i = 0; i < divFields.length; ++i) {
            bakDivFields[i] = divFields[i] + "bak";
        }
        for (i = 0; i < bakCalDims.length; ++i) {
            bakCalDims[i] = calDims[i] + "bak";
        }
        String[] divRangeDims = (String[])kd.fi.cal.common.util.ArrayUtils.concatAll((Object[])bakDivFields, (Object[][])new String[][]{{"calrange"}, bakCalDims});
        return divRangeDims;
    }

    private DataSet getInitCalBillDs(int maxAge) {
        Date startPeriodFirstDate;
        if (maxAge <= 0) {
            return null;
        }
        Date startDate = DateUtils.addDateTime((Date)this.curPeriodLastDay, (int)5, (int)(-maxAge));
        if (startDate.compareTo(startPeriodFirstDate = this.fallPriceExtractParam.getStartPeriodFirstDate()) > 0) {
            return null;
        }
        String initSelects = this.getInitSelFields();
        List<QFilter> initFilters = this.getInitFilters(maxAge);
        RowMeta rowMeta = ORM.create().createRowMeta("cal_initbill", initSelects);
        rowMeta.getField("baseqty").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("actualamount").setDataType((DataType)DataType.BigDecimalType);
        rowMeta.getField("standardamount").setDataType((DataType)DataType.BigDecimalType);
        DataSet initBillDs = this.queryDataSetSplitMatConc("cal_initbill", initSelects, initFilters, "entryentity.material", rowMeta, "entryentity.storageorgunit");
        return initBillDs;
    }

    private List<QFilter> getInitFilters(int maxAge) {
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>(16);
        if (maxAge <= 0) {
            billFilters.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            String ageField = this.fallPriceExtractParam.getEntityAgeFieldMap().get("cal_initbill");
            ageField = StringUtils.isEmpty((CharSequence)ageField) ? "entryentity.stockindate" : ageField;
            QFilter endDateFilter = new QFilter(ageField, "<=", (Object)this.curPeriodLastDay);
            Date startDate = DateUtils.addDateTime((Date)this.curPeriodLastDay, (int)5, (int)(-maxAge));
            QFilter startDateFilter = new QFilter(ageField, ">", (Object)startDate);
            QFilter acctf = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C);
            QFilter ownerTypeFilter = new QFilter("entryentity.ownertype", "=", (Object)"bos_org");
            billFilters.add(acctf);
            billFilters.add(endDateFilter);
            billFilters.add(startDateFilter);
            billFilters.add(billStatusFilter);
            billFilters.add(ownerTypeFilter);
        }
        return billFilters;
    }

    private String getInitSelFields() {
        StringBuilder select = new StringBuilder();
        BalanceDimFieldParser balDimParser = new BalanceDimFieldParser();
        String intSelects = balDimParser.getDetailDimFieldsAndBaseName("cal_initbill", "entryentity");
        if (!intSelects.contains("calorg")) {
            select.append("calorg,");
        }
        select.append(intSelects);
        String ageField = this.fallPriceExtractParam.getEntityAgeFieldMap().get("cal_initbill");
        ageField = StringUtils.isEmpty((CharSequence)ageField) ? "entryentity.stockindate" : ageField;
        select.append(String.format("entryentity.calrange calrange,entryentity.caldimension.caldimension as caldimensionstr,%s bookdate,entryentity.warehouse.group as warehousegroup,", ageField));
        select.append("entryentity.baseqty baseqty,");
        select.append("entryentity.accounttype as accounttype,");
        select.append("case when entryentity.accounttype <> 'D' then entryentity.amount ");
        select.append(" else 0 end as actualamount,");
        if (this.isContainDiffer) {
            select.append("case when entryentity.accounttype = 'D' then entryentity.amount + entryentity.costdiff");
            select.append(" else 0 end as standardamount");
        } else {
            select.append("case when entryentity.accounttype = 'D' then entryentity.amount ");
            select.append(" else 0 end as standardamount");
        }
        return select.toString();
    }

    private String getNoCalAgeBillFilterStr(FallPriceSettingParam fallPriceSettingParam) {
        String noCalAgeBills = fallPriceSettingParam.getNoCalAgeBills();
        StringBuilder filterStr = new StringBuilder();
        if (noCalAgeBills != null && !noCalAgeBills.isEmpty()) {
            String[] nostatisticalArray = noCalAgeBills.split(",");
            for (int i = 0; i < nostatisticalArray.length; ++i) {
                String tmp = nostatisticalArray[i];
                String[] tmps = tmp.split(":");
                if (tmps.length <= 0) continue;
                String billTypeId = tmps[0];
                if (filterStr.length() > 0) {
                    filterStr.append(" and ");
                }
                filterStr.append("( billtype.id <> ").append(billTypeId);
                if (tmps.length > 1) {
                    long biztypeId = Long.parseLong(tmps[1]);
                    filterStr.append(" or biztype <> ").append(biztypeId);
                    if (tmps.length > 2) {
                        long invschemeId = Long.parseLong(tmps[2]);
                        filterStr.append(" or invscheme <> ").append(invschemeId);
                    }
                }
                filterStr.append(')');
            }
        }
        return filterStr.toString();
    }

    private List<QFilter> getCostRecordBillFilter(int maxAge, Date currentSystemDate) {
        String ageField = this.fallPriceExtractParam.getEntityAgeFieldMap().get("cal_costrecord_subentity");
        ageField = StringUtils.isEmpty((CharSequence)ageField) ? "bookdate" : ageField;
        ArrayList<QFilter> billf = new ArrayList<QFilter>(16);
        if (maxAge <= 0) {
            billf.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            QFilter endDatef = new QFilter(ageField, "<=", (Object)currentSystemDate);
            Date startDate = DateUtils.addDateTime((Date)currentSystemDate, (int)5, (int)(-maxAge));
            QFilter startDatef = new QFilter(ageField, ">", (Object)startDate);
            QFilter notSplitf = new QFilter("issplitcreate", "=", (Object)false);
            QFilter recf = new QFilter("calbilltype", "=", (Object)"IN");
            recf.and("entry.baseqty", ">", (Object)BigDecimal.ZERO);
            QFilter sedf = new QFilter("calbilltype", "=", (Object)"OUT");
            sedf.and("entry.baseqty", "<", (Object)BigDecimal.ZERO);
            recf.or(sedf);
            QFilter acctf = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
            QFilter ownerTypef = new QFilter("entry.ownertype", "=", (Object)"bos_org");
            QFilter bizf = new QFilter("biztype", "not in", this.notUpdBalBizType);
            billf.add(acctf);
            billf.add(endDatef);
            billf.add(startDatef);
            billf.add(recf);
            billf.add(notSplitf);
            billf.add(ownerTypef);
            billf.add(bizf);
        }
        QFilter billStatusf = new QFilter("billstatus", "=", (Object)"C");
        billf.add(billStatusf);
        return billf;
    }

    private List<QFilter> getCostAdjBillFilter(int maxAge, Date currentSystemDate) {
        ArrayList<QFilter> billf = new ArrayList<QFilter>(16);
        if (maxAge <= 0) {
            billf.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        } else {
            QFilter endDatef = new QFilter("bookdate", "<=", (Object)currentSystemDate);
            Date startDate = DateUtils.addDateTime((Date)currentSystemDate, (int)5, (int)(-maxAge));
            QFilter startDatef = new QFilter("bookdate", ">", (Object)startDate);
            QFilter recf = new QFilter("biztype", "=", (Object)"A");
            QFilter acctf = new QFilter("costaccount", "=", this.fallPriceExtractParam.getCostAccountId());
            QFilter billStatusf = new QFilter("billstatus", "=", (Object)BillStatus.C);
            QFilter ownerTypef = new QFilter("entryentity.ownertype", "=", (Object)"bos_org");
            QFilter accountTypef = new QFilter("entryentity.accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
            QFilter updatecostf = new QFilter("isupdatecost", "=", (Object)"1");
            billf.add(acctf);
            billf.add(endDatef);
            billf.add(startDatef);
            billf.add(recf);
            billf.add(billStatusf);
            billf.add(ownerTypef);
            billf.add(accountTypef);
            billf.add(updatecostf);
        }
        return billf;
    }

    private String getCostRecordFields() {
        StringBuilder select = new StringBuilder();
        BalanceDimFieldParser balDimParser = new BalanceDimFieldParser();
        String costRecordSelects = balDimParser.getDetailDimFieldsAndBaseName("cal_costrecord", "entry");
        if (!costRecordSelects.contains("calorg")) {
            select.append("calorg,");
        }
        select.append(costRecordSelects);
        String ageField = this.fallPriceExtractParam.getEntityAgeFieldMap().get("cal_costrecord_subentity");
        ageField = StringUtils.isEmpty((CharSequence)ageField) ? "bookdate" : ageField;
        select.append(String.format("entry.calrange calrange,entry.caldimension.caldimension as caldimensionstr,%s as bookdate,entry.warehouse.group as warehousegroup,billtype.id,", ageField));
        select.append("case when calbilltype = 'IN' then entry.baseqty else 0 - entry.baseqty end as baseqty,");
        select.append("entry.accounttype as accounttype,");
        select.append("case when calbilltype = 'IN' and entry.accounttype <> 'D' then entry.actualcost ");
        select.append("when calbilltype = 'OUT' and entry.accounttype <> 'D' then 0 - entry.actualcost ");
        select.append(" else 0 end as actualamount,");
        select.append("case when calbilltype = 'IN' and entry.accounttype = 'D' then entry.standardcost ");
        select.append("when calbilltype = 'OUT' and entry.accounttype = 'D'  then 0 - entry.standardcost ");
        select.append(" else 0 end as standardamount,");
        select.append(" entry.bizbillentryid as bizbillentryid,bizbillid,calbilltype");
        return select.toString();
    }

    private String getCostAdjustFields(Boolean isContainDiffer) {
        StringBuilder select = new StringBuilder();
        BalanceDimFieldParser balDimParser = new BalanceDimFieldParser();
        String costAdjBillSelects = balDimParser.getDetailDimFieldsAndBaseName("cal_costadjustbill", "entryentity");
        if (!costAdjBillSelects.contains("calorg")) {
            select.append("calorg,");
        }
        select.append(costAdjBillSelects);
        select.append("entryentity.calrange calrange,entryentity.caldimension.caldimension as caldimensionstr,bookdate,entryentity.warehouse.group as warehousegroup,0 as baseqty,");
        select.append("entryentity.accounttype as accounttype,");
        select.append(" case when biztype = 'A' and difftype = 'B' and createtype <> 'C1' and entryentity.accounttype <> 'D' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and difftype = 'B' and createtype <>  'C1' and entryentity.accounttype <> 'D'  then 0 - entryentity.adjustamt else 0 end as actualamount, ");
        if (isContainDiffer.booleanValue()) {
            select.append("case when biztype = 'A' and difftype <> 'B' and createtype <> 'C1' and entryentity.accounttype = 'D' then entryentity.adjustamt ");
            select.append(" when biztype = 'A' and difftype = 'M' and entryentity.accounttype = 'D' and createtype = 'W' then entryentity.adjustamt ");
            select.append(" when biztype = 'B' and difftype <> 'B' and createtype <> 'C1' and entryentity.accounttype = 'D' then 0 - entryentity.adjustamt ");
            select.append(" when biztype = 'B' and difftype = 'M' and entryentity.accounttype = 'D' and createtype = 'W' then 0 - entryentity.adjustamt else 0 end as standardamount ");
        } else {
            select.append("case when biztype = 'A' and createtype = 'C1' and entryentity.accounttype = 'D' then 0 - entryentity.adjustamt ");
            select.append(" when biztype = 'B' and createtype = 'C1' and entryentity.accounttype = 'D' then entryentity.adjustamt else 0 end as standardamount ");
        }
        return select.toString();
    }

    private String getCostDiffFields() {
        StringBuilder select = new StringBuilder();
        BalanceDimFieldParser balDimParser = new BalanceDimFieldParser();
        String costAdjBillSelects = balDimParser.getDetailDimFieldsAndBaseName("cal_stdcostdiffbill", "entryentity");
        if (!costAdjBillSelects.contains("calorg")) {
            select.append("calorg,");
        }
        select.append(costAdjBillSelects);
        select.append("entryentity.calrange calrange,entryentity.caldimension.caldimension as caldimensionstr,bookdate,entryentity.warehouse.group as warehousegroup,0 as baseqty,");
        select.append("entryentity.accounttype as accounttype,");
        select.append("0 as actualamount,");
        select.append("case when biztype = 'A' and createtype <> 'C1' and entryentity.accounttype = 'D' then entryentity.adjustamt ");
        select.append(" when biztype = 'B' and createtype <> 'C1' and entryentity.accounttype = 'D' then 0 - entryentity.adjustamt else 0 end as standardamount");
        return select.toString();
    }

    private DataSet getTransBillDataSetNew() {
        String costRecordSelects = "transtype,entry.bizbillentryid bizbillentryid,entry.material materialid,entry.warehouse.group warehousegroup,entry.warehouse warehouse,entry.location location,entry.owner owner,costaccount costaccountnumber,bizentityobject,calbilltype,case when bizentityobject='im_transdirbill' then entry.bizbillentryid when bizentityobject='im_transinbill' then entry.srcbillentryid when bizentityobject='im_transoutbill' then entry.bizbillentryid else 0L end as srcbizbillentryid,billno";
        RowMeta rowMeta = ORM.create().createRowMeta("cal_costrecord", costRecordSelects);
        rowMeta.getField("srcbizbillentryid").setDataType((DataType)DataType.LongType);
        int maxAge = this.fallPriceParam.getMaxAge();
        List<QFilter> calRecordf = this.getCostRecordBillFilter(maxAge, this.curPeriodLastDay);
        calRecordf.add(new QFilter("bizentityobject", "in", (Object)TRANS_ENTITIES));
        Iterator<QFilter> iterator = calRecordf.iterator();
        while (iterator.hasNext()) {
            QFilter curFilter = iterator.next();
            if (!curFilter.getProperty().equals("calbilltype") && !curFilter.getProperty().equals("entry.baseqty")) continue;
            iterator.remove();
        }
        DataSet calRecordDs = this.queryDataSetSplitMatConc("cal_costrecord", costRecordSelects, calRecordf, "entry.material", rowMeta, "storageorgunit");
        calRecordDs = calRecordDs.groupBy(new String[]{"srcbizbillentryid"}).reduceGroup((ReduceGroupFunction)new DealTranBillSrcTgtFunction());
        return calRecordDs;
    }

    private DataSet filterAgeDs(DataSet matBalDs, JoinDataSet matBalDsJoinAcctRecordDs) {
        String ageFromTo = "(bookdate is null or invageto <> 999999 and date(year(bookdate),month(bookdate),day(bookdate)) >= date(year(DATEADD('Day',-invageto,%1$s)),month(DATEADD('Day',-invageto,%1$s)),day(DATEADD('Day',-invageto,%1$s)))  and date(year(bookdate),month(bookdate),day(bookdate)) <=  date(year(DATEADD('Day',-invagefrom,%1$s)),month(DATEADD('Day',-invagefrom,%1$s)),day(DATEADD('Day',-invagefrom,%1$s)))) ";
        String ageCurToFrom = " (bookdate is null or invagefrom <> 0 and invageto = 999999 and date(year(bookdate),month(bookdate),day(bookdate)) >=  date(year(DATEADD('Day',-invagefrom,%1$s)),month(DATEADD('Day',-invagefrom,%1$s)),day(DATEADD('Day',-invagefrom,%1$s))))";
        DataSet matBalAccDs = matBalDsJoinAcctRecordDs.select(matBalDs.getRowMeta().getFieldNames(), new String[]{"bookdate", "baseqty", "actualamount", "standardamount"}).finish().filter(String.format(ageFromTo + " or " + ageCurToFrom, this.getStrToDate(this.curPeriodLastDay)));
        return matBalAccDs;
    }

    private String getStrToDate(Date date) {
        return "to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "','yyyy-MM-dd')";
    }

    private String getHasKeyByDims(List<String> orders, Row row) {
        StringBuilder sb = new StringBuilder();
        char interval = ':';
        for (String dim : orders) {
            if ("invageto".equals(dim) || StringUtils.isBlank((CharSequence)dim)) continue;
            sb.append(row.getString(dim)).append(interval);
        }
        return sb.toString();
    }
}

