/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.cal.business.fallprice.AbstractFallPriceRevCal;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.model.FallPriceRevBill;

public class FallPriceAgeRevCal
extends AbstractFallPriceRevCal {
    public FallPriceAgeRevCal(ExtendedDataEntity[] revEentities) {
        super(revEentities);
    }

    @Override
    public ExtendedDataEntity[] calculate() {
        for (ExtendedDataEntity entity : this.curEntities) {
            DynamicObject revBillDyc = entity.getDataEntity();
            this.setBillHeadInfo(revBillDyc);
            this.setBillEntryInfo(revBillDyc);
        }
        return this.otherEntities.toArray(new ExtendedDataEntity[0]);
    }

    @Override
    public boolean isCurCal(ExtendedDataEntity entity) {
        DynamicObject revBillDyc = entity.getDataEntity();
        boolean enableShelfLife = revBillDyc.getBoolean("accsetting.enableshelflife");
        return !enableShelfLife;
    }

    @Override
    public DataSet getRevDs(DynamicObject rushBillDyc) {
        String provisionWay = rushBillDyc.getString("accsetting.provisionway");
        String setDimension = rushBillDyc.getString("accsetting.setdimension");
        String provDimension = rushBillDyc.getString("accsetting.provdimension");
        Set<String> setAndProvDims = FallPriceHelper.getDropdownList(setDimension);
        Set<String> provDims = FallPriceHelper.getDropdownList(provDimension);
        setAndProvDims.addAll(provDims);
        Set<Long> matIds = this.getMatIds(rushBillDyc);
        long sourceId = rushBillDyc.getLong("sourcebillid");
        DataSet prevBillDs = this.getProvBillDs(sourceId, setAndProvDims);
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        DataSet balDs = isNewBalance ? this.getNewBalanceDs(rushBillDyc, matIds) : this.getBalanceDs(rushBillDyc, setAndProvDims, matIds);
        HashSet<String> balGroupDims = new HashSet<String>(16);
        balGroupDims.addAll(setAndProvDims);
        balGroupDims.add("balmaterial");
        balGroupDims.add("balwaregroup");
        balDs = balDs.groupBy(balGroupDims.toArray(new String[0])).sum("periodissueqty").finish();
        JoinDataSet provJoinBalDs = prevBillDs.join(balDs);
        provJoinBalDs.on("material", "balmaterial");
        if (provisionWay.equals("C")) {
            provJoinBalDs.on("warehousegroup", "balwaregroup");
        }
        for (String setAndProvDim : setAndProvDims) {
            provJoinBalDs = provJoinBalDs.on(setAndProvDim, setAndProvDim);
        }
        ArrayList<String> balSelFields = new ArrayList<String>(16);
        balSelFields.add("periodissueqty");
        DataSet matBalDs = provJoinBalDs.select(prevBillDs.getRowMeta().getFieldNames(), balSelFields.toArray(new String[0])).finish();
        matBalDs = matBalDs.groupBy(prevBillDs.getRowMeta().getFieldNames()).sum("periodissueqty").finish();
        return matBalDs;
    }

    private void setBillEntryInfo(DynamicObject revBillDyc) {
        String key;
        BigDecimal curperiodoutqty = BigDecimal.ZERO;
        BigDecimal curperiodreverseqty = BigDecimal.ZERO;
        BigDecimal curPeriodProvAmount = BigDecimal.ZERO;
        long sourceEntryId = 0L;
        int amtprecision = revBillDyc.getInt("currency.amtprecision");
        Map<Long, FallPriceRevBill> fallPriceRevBillMap = this.getCurPeriodOutQtyMap(revBillDyc);
        DynamicObjectCollection entryEntity = revBillDyc.getDynamicObjectCollection("entry");
        FallPriceRevBill fallPriceRevBill = null;
        BigDecimal baseqty = null;
        BigDecimal rushbaseqty = null;
        BigDecimal subBaseQty = null;
        HashMap<String, Integer> minInvAgeToRecord = new HashMap<String, Integer>(entryEntity.size());
        HashMap<String, BigDecimal> hasOutQtyRecord = new HashMap<String, BigDecimal>(entryEntity.size());
        for (DynamicObject entryInfo : entryEntity) {
            key = this.getDimensionValKey(revBillDyc, entryInfo);
            int invAgeTo = entryInfo.getInt("invageto");
            minInvAgeToRecord.putIfAbsent(key, invAgeTo);
            sourceEntryId = entryInfo.getLong("sourceentryid");
            fallPriceRevBill = fallPriceRevBillMap.get(sourceEntryId);
            if (fallPriceRevBill == null) {
                fallPriceRevBill = new FallPriceRevBill();
            }
            curperiodoutqty = fallPriceRevBill.getPeriodIssueQty();
            hasOutQtyRecord.putIfAbsent(key, curperiodoutqty);
        }
        for (int i = entryEntity.size() - 1; i >= 0; --i) {
            BigDecimal hasOutQty;
            DynamicObject entryInfo;
            entryInfo = (DynamicObject)entryEntity.get(i);
            baseqty = entryInfo.getBigDecimal("baseqty");
            rushbaseqty = entryInfo.getBigDecimal("rushbaseqty");
            subBaseQty = baseqty.subtract(rushbaseqty);
            sourceEntryId = entryInfo.getLong("sourceentryid");
            fallPriceRevBill = fallPriceRevBillMap.get(sourceEntryId);
            if (fallPriceRevBill == null) {
                fallPriceRevBill = new FallPriceRevBill();
            }
            curperiodreverseqty = (curperiodreverseqty = this.getCurReverQtry(entryInfo, hasOutQty = (BigDecimal)hasOutQtyRecord.get(key = this.getDimensionValKey(revBillDyc, entryInfo)))).compareTo(subBaseQty) > 0 ? subBaseQty : curperiodreverseqty;
            entryInfo.set("curperiodrushqty", (Object)curperiodreverseqty);
            int invAgeTo = entryInfo.getInt("invageto");
            curperiodoutqty = curperiodreverseqty;
            if ((Integer)minInvAgeToRecord.get(key) == invAgeTo) {
                curperiodoutqty = hasOutQty;
            }
            hasOutQty = hasOutQty.subtract(curperiodoutqty);
            hasOutQtyRecord.put(key, hasOutQty);
            entryInfo.set("curperiodoutqty", (Object)curperiodoutqty);
            curPeriodProvAmount = this.getCurProAmount(entryInfo, curperiodoutqty, fallPriceRevBill, amtprecision);
            entryInfo.set("curperiodrushamount", (Object)curPeriodProvAmount);
        }
    }

    private BigDecimal getCurReverQtry(DynamicObject entryInfo, BigDecimal hasOutQty) {
        BigDecimal rushbaseqty;
        BigDecimal curperiodreverseqty = BigDecimal.ZERO;
        BigDecimal baseqty = entryInfo.getBigDecimal("baseqty");
        BigDecimal subQty = baseqty.subtract(rushbaseqty = entryInfo.getBigDecimal("rushbaseqty"));
        curperiodreverseqty = hasOutQty.compareTo(subQty) <= 0 ? hasOutQty : subQty;
        return curperiodreverseqty;
    }

    private BigDecimal getCurProAmount(DynamicObject entryInfo, BigDecimal curperiodoutqty, FallPriceRevBill fallPriceRevBill, int amtprecision) {
        BigDecimal curPeriodProvAmount = BigDecimal.ZERO;
        BigDecimal baseqty = entryInfo.getBigDecimal("baseqty");
        BigDecimal curRushBAseQty = entryInfo.getBigDecimal("curperiodrushqty");
        BigDecimal rushbaseqty = entryInfo.getBigDecimal("rushbaseqty");
        BigDecimal rushAmount = entryInfo.getBigDecimal("rushamount");
        BigDecimal unitRealizableAmount = entryInfo.getBigDecimal("unitrealizableamount");
        BigDecimal subQty = baseqty.subtract(rushbaseqty);
        curPeriodProvAmount = curperiodoutqty.compareTo(subQty) == 0 ? fallPriceRevBill.getRequireAmount().subtract(rushAmount) : curRushBAseQty.multiply(entryInfo.getBigDecimal("baseprice").subtract(unitRealizableAmount));
        if (curPeriodProvAmount != null) {
            curPeriodProvAmount = curPeriodProvAmount.setScale(amtprecision, 4);
        }
        return curPeriodProvAmount;
    }
}

