/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;

public class FallPriceExpiryDateHelper {
    private final Date endDate;
    private final Set<String> dimKeys;
    private final int currentPeriodNum;
    private Map<String, String> calDimInvDimMap = new HashMap<String, String>(16);
    private Boolean isNewPeriodBal;
    private static final String CALBAL = "2";
    private Set<Long> matIds;
    private Set<Long> invOrgIds;
    private boolean onlyCurPeriod = false;
    private Set<Integer> periodNums = new HashSet<Integer>(16);

    public FallPriceExpiryDateHelper(Date endDate, Set<String> dimKeys, int currentPeriodNum) {
        this.endDate = endDate;
        this.dimKeys = dimKeys;
        this.currentPeriodNum = currentPeriodNum;
        this.buildCalDimInvDimMap();
    }

    public DataSet getExpiryDateDs() {
        DataSet invBalDs = this.getInvBalDs();
        String strToDate = FallPriceExpiryDateHelper.getStrToDate(this.endDate);
        String dateDifExpStr = String.format("DATEDIF(%s,expirydate,D)", strToDate);
        invBalDs = invBalDs.addField(dateDifExpStr, "expirydateday");
        return invBalDs;
    }

    private DataSet getInvBalDs() {
        String entityName = this.isNewPeriodBal != false ? "im_cal_periodbalance" : "im_invbalance";
        String selectFields = this.getBalSelectField();
        if (this.matIds != null && this.matIds.isEmpty()) {
            RowMeta rowMeta = ORM.create().createRowMeta(entityName, selectFields);
            DataSet emptyDs = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
            return emptyDs;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        QFilter periodFilter = new QFilter("period", "<=", (Object)this.currentPeriodNum);
        periodFilter.and(new QFilter("endperiod", ">", (Object)this.currentPeriodNum));
        if (this.onlyCurPeriod) {
            periodFilter = new QFilter("period", "in", this.periodNums);
        } else {
            String baseQtyField = this.calDimInvDimMap.get("baseqty");
            filters.add(new QFilter(baseQtyField, "!=", (Object)BigDecimal.ZERO));
        }
        filters.add(periodFilter);
        if (!this.isNewPeriodBal.booleanValue()) {
            filters.add(new QFilter("balancetype", "=", (Object)CALBAL));
        }
        filters.add(new QFilter("expirydate", "is not null", null));
        String matField = this.calDimInvDimMap.get("material");
        String invOrgField = this.calDimInvDimMap.get("storageorgunit");
        if (this.invOrgIds != null && !this.invOrgIds.isEmpty()) {
            filters.add(new QFilter(invOrgField, "in", this.invOrgIds));
        }
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        if (this.matIds == null) {
            OrmInput billOI = new OrmInput(this.getClass().getName(), entityName, selectFields, filters.toArray(new QFilter[0]));
            billOIs.add(billOI);
        } else {
            Lists.partition(new ArrayList<Long>(this.matIds), (int)100000).forEach(list -> {
                ArrayList<QFilter> curFilters = new ArrayList<QFilter>(16);
                curFilters.add(new QFilter(matField, "in", list));
                curFilters.addAll(filters);
                OrmInput billOI = new OrmInput(this.getClass().getName(), entityName, selectFields, curFilters.toArray(new QFilter[0]));
                billOIs.add(billOI);
            });
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet invBalDs = algo.createDataSet((Input[])billOIs.toArray(new OrmInput[billOIs.size()]));
        return invBalDs;
    }

    private String getBalSelectField() {
        StringBuilder sb = new StringBuilder();
        for (String dimKey : this.dimKeys) {
            String invDimKey = this.calDimInvDimMap.get(dimKey);
            if (invDimKey == null) {
                invDimKey = dimKey;
            }
            sb.append(invDimKey).append(" as ").append(dimKey).append(",");
        }
        sb.append(this.calDimInvDimMap.get("material")).append(" as ").append("balmaterial").append(",");
        sb.append(this.calDimInvDimMap.get("warehouse")).append(".group as ").append("balwaregroup").append(",");
        String baseQtyField = this.calDimInvDimMap.get("baseqty");
        sb.append(baseQtyField).append(" as baseqty").append(",");
        String outBaseQtyField = this.calDimInvDimMap.get("periodissueqty");
        sb.append(outBaseQtyField).append(" as periodissueqty").append(",");
        sb.append("expirydate");
        String selectFields = sb.toString();
        return selectFields;
    }

    private void buildCalDimInvDimMap() {
        this.isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
        this.calDimInvDimMap.put("storageorgunit", "org");
        this.calDimInvDimMap.put("material", "material");
        this.calDimInvDimMap.put("baseunit", "baseunit");
        this.calDimInvDimMap.put("warehouse", "warehouse");
        this.calDimInvDimMap.put("location", "location");
        this.calDimInvDimMap.put("ownertype", "ownertype");
        this.calDimInvDimMap.put("owner", "owner");
        this.calDimInvDimMap.put("invtype", "invtype");
        this.calDimInvDimMap.put("invstatus", "invstatus");
        this.calDimInvDimMap.put("assist", "auxpty");
        this.calDimInvDimMap.put("eproject", "project");
        this.calDimInvDimMap.put("lot", "lotnumber");
        this.calDimInvDimMap.put("configuredcode", "configuredcode");
        if (this.isNewPeriodBal.booleanValue()) {
            this.calDimInvDimMap.put("baseqty", "baseqty_bal");
            this.calDimInvDimMap.put("periodissueqty", "baseqty_out");
        } else {
            this.calDimInvDimMap.put("baseqty", "endbaseqty");
            this.calDimInvDimMap.put("periodissueqty", "outbaseqty");
        }
    }

    public static String getStrToDate(Date date) {
        return "to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "','yyyy-MM-dd')";
    }

    public void setMatIds(Set<Long> matIds) {
        this.matIds = matIds;
    }

    public Set<Long> getMatIds() {
        return this.matIds;
    }

    public void setInvOrgIds(Set<Long> invOrgIds) {
        this.invOrgIds = invOrgIds;
    }

    public Set<Long> getInvOrgIds() {
        return this.invOrgIds;
    }

    public void setOnlyCurPeriod(boolean onlyCurPeriod) {
        this.onlyCurPeriod = onlyCurPeriod;
    }

    public boolean getOnlyCurPeriod() {
        return this.onlyCurPeriod;
    }

    public void setPeriodNums(Set<Integer> periodNums) {
        this.periodNums = periodNums;
    }

    public Set<Integer> getPeriodNums() {
        return this.periodNums;
    }
}

