/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.cal.business.fallprice.AbstractFallPriceRevCal;
import kd.fi.cal.business.fallprice.FallPriceExpiryDateHelper;
import kd.fi.cal.business.fallprice.FallPriceHelper;
import kd.fi.cal.common.model.FallPriceRevBill;

public class FallPriceExpiryDateRevCal
extends AbstractFallPriceRevCal {
    public FallPriceExpiryDateRevCal(ExtendedDataEntity[] revEentities) {
        super(revEentities);
    }

    @Override
    public ExtendedDataEntity[] calculate() {
        for (ExtendedDataEntity curEntity : this.curEntities) {
            DynamicObject revBillDyc = curEntity.getDataEntity();
            this.setBillHeadInfo(revBillDyc);
            this.setBillEntryInfo(revBillDyc);
        }
        return this.otherEntities.toArray(new ExtendedDataEntity[0]);
    }

    @Override
    public boolean isCurCal(ExtendedDataEntity entity) {
        DynamicObject revBillDyc = entity.getDataEntity();
        boolean enableShelfLife = revBillDyc.getBoolean("accsetting.enableshelflife");
        return enableShelfLife;
    }

    @Override
    public DataSet getRevDs(DynamicObject rushBillDyc) {
        String setDimension = rushBillDyc.getString("accsetting.setdimension");
        String provDimension = rushBillDyc.getString("accsetting.provdimension");
        Set<String> setAndProvDims = FallPriceHelper.getDropdownList(setDimension);
        Set<String> provDims = FallPriceHelper.getDropdownList(provDimension);
        setAndProvDims.addAll(provDims);
        Set<Long> matIds = this.getMatIds(rushBillDyc);
        long sourceId = rushBillDyc.getLong("sourcebillid");
        DataSet prevBillDs = this.getProvBillDs(sourceId, setAndProvDims);
        int periodNumber = rushBillDyc.getInt("period");
        DynamicObject provBillDyc = (DynamicObject)this.provIdEntityMap.get(sourceId);
        Date provBookDate = provBillDyc.getDate("bookdate");
        FallPriceExpiryDateHelper fallPriceExpiryDateHelper = new FallPriceExpiryDateHelper(provBookDate, setAndProvDims, periodNumber);
        fallPriceExpiryDateHelper.setMatIds(matIds);
        fallPriceExpiryDateHelper.setOnlyCurPeriod(true);
        Set<Integer> periodNums = this.getOutPeriodNums(rushBillDyc);
        fallPriceExpiryDateHelper.setPeriodNums(periodNums);
        DataSet balDs = fallPriceExpiryDateHelper.getExpiryDateDs();
        HashSet<String> balGroupDims = new HashSet<String>(16);
        balGroupDims.addAll(setAndProvDims);
        balGroupDims.add("balmaterial");
        balGroupDims.add("balwaregroup");
        balGroupDims.add("expirydateday");
        balDs = balDs.groupBy(balGroupDims.toArray(new String[0])).sum("periodissueqty").finish();
        JoinDataSet provJoinBalDs = prevBillDs.join(balDs);
        provJoinBalDs.on("material", "balmaterial");
        for (String setAndProvDim : setAndProvDims) {
            provJoinBalDs = provJoinBalDs.on(setAndProvDim, setAndProvDim);
        }
        ArrayList<String> balSelFields = new ArrayList<String>(16);
        balSelFields.add("periodissueqty");
        balSelFields.add("expirydateday");
        DataSet matBalDs = provJoinBalDs.select(prevBillDs.getRowMeta().getFieldNames(), balSelFields.toArray(new String[0])).finish();
        matBalDs = matBalDs.filter("expirydateday is null or (expirydatefrom <= expirydateday and expirydateday <= expirydateto)");
        matBalDs = matBalDs.groupBy(prevBillDs.getRowMeta().getFieldNames()).sum("periodissueqty").finish();
        return matBalDs;
    }

    private void setBillEntryInfo(DynamicObject revBillDyc) {
        int amtPrecision = revBillDyc.getInt("currency.amtprecision");
        Map<Long, FallPriceRevBill> fallPriceRevBillMap = this.getCurPeriodOutQtyMap(revBillDyc);
        DynamicObjectCollection entryEntity = revBillDyc.getDynamicObjectCollection("entry");
        for (DynamicObject entryInfo : entryEntity) {
            BigDecimal curPeriodRushAmt;
            long sourceEntryId = entryInfo.getLong("sourceentryid");
            FallPriceRevBill fallPriceRevBill = fallPriceRevBillMap.get(sourceEntryId);
            if (fallPriceRevBill == null) {
                fallPriceRevBill = new FallPriceRevBill();
            }
            BigDecimal periodIssueQty = fallPriceRevBill.getPeriodIssueQty();
            entryInfo.set("curperiodoutqty", (Object)periodIssueQty);
            BigDecimal provBillBaseQty = entryInfo.getBigDecimal("baseqty");
            BigDecimal provRushBaseQty = entryInfo.getBigDecimal("rushbaseqty");
            BigDecimal subBaseQty = provBillBaseQty.subtract(provRushBaseQty);
            BigDecimal curPeriodRushQty = subBaseQty.min(periodIssueQty);
            entryInfo.set("curperiodrushqty", (Object)curPeriodRushQty);
            if (BigDecimal.ZERO.equals(curPeriodRushQty)) continue;
            if (curPeriodRushQty.equals(subBaseQty)) {
                BigDecimal rushAmount = entryInfo.getBigDecimal("rushamount");
                curPeriodRushAmt = fallPriceRevBill.getRequireAmount().subtract(rushAmount);
            } else {
                BigDecimal basePrice = entryInfo.getBigDecimal("baseprice");
                BigDecimal unitRealAmt = entryInfo.getBigDecimal("unitrealizableamount");
                curPeriodRushAmt = curPeriodRushQty.multiply(basePrice.subtract(unitRealAmt)).setScale(amtPrecision, 4);
            }
            entryInfo.set("curperiodrushamount", (Object)curPeriodRushAmt);
        }
    }
}

