/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.fallprice.AbstractFallPriceProvCal;
import kd.fi.cal.business.fallprice.FallPriceExpiryDateHelper;
import kd.fi.cal.business.fallprice.FallPriceExtractParam;
import kd.fi.cal.business.fallprice.FallPriceSettingParam;
import kd.fi.cal.common.helper.ParamsHelper;

public class FallPriceExpiryProvCal
extends AbstractFallPriceProvCal {
    public FallPriceExpiryProvCal(FallPriceSettingParam fallPriceParam, FallPriceExtractParam fallPriceExtractParam) {
        super(fallPriceParam, fallPriceExtractParam);
    }

    @Override
    public DataSet getExtractDataSet() {
        DataSet settingDs = this.getSettingDs();
        String[] settingDsFields = settingDs.getRowMeta().getFieldNames();
        Set<String> settingBalGroupDims = this.getSetAndBalGroupDims(settingDsFields);
        DataSet balDs = this.getPeriodBalDs();
        Map<String, List<Map<String, Object>>> paramsMap = this.buildGetStdParams(balDs);
        DataSet matBalDs = this.settingJoinBalDs(settingDs, settingBalGroupDims, balDs);
        DataSet curProvRevDs = this.getCurPeriodProvRecMatDs();
        matBalDs = this.setBalJoinCurProvRevDs(matBalDs, curProvRevDs);
        DataSet matBalAccDs = this.getExpityDs(matBalDs);
        String[] fieldNames = matBalDs.getRowMeta().getFieldNames();
        matBalAccDs = matBalAccDs.groupBy(fieldNames).sum("baseqty").sum("actualamount").sum("standardamount").finish();
        matBalAccDs = this.getStdMatCost(matBalAccDs, settingBalGroupDims, paramsMap);
        matBalAccDs = this.matBalAccJoinProvBillDs(matBalAccDs);
        return matBalAccDs;
    }

    @Override
    public String createProvBill(DataSet matBalAccDs) {
        Boolean provAll = (Boolean)ParamsHelper.getAppParam((long)((Long)this.fallPriceExtractParam.getCalOrgId()), (String)"provall");
        String provBillNo = "";
        DynamicObject provDyc = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_price_provbill"));
        String number = CodeRuleServiceHelper.getNumber((String)"cal_price_provbill", (DynamicObject)provDyc, null);
        if (number == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8dcc\u4ef7\u8ba1\u63d0\u5355\u7684\u7f16\u53f7\u89c4\u5219\u3002", (String)"FallPriceExtractor_4", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entryDycs = provDyc.getDynamicObjectCollection("entry");
        ArrayList<Object[]> entryIds = new ArrayList<Object[]>(16);
        int seq = 1;
        for (Row row : matBalAccDs) {
            boolean isQtyAmtZero;
            boolean isReqAmtHasAmtZero;
            DynamicObject entryDyc = new DynamicObject(entryDycs.getDynamicObjectType());
            this.setFixEntryInfo(seq, row, entryDyc);
            BigDecimal endQty = row.getBigDecimal("periodendqty");
            if (endQty == null) {
                endQty = BigDecimal.ZERO;
            }
            BigDecimal periodActualCost = row.getBigDecimal("periodendactualcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodendactualcost");
            BigDecimal periodEndStandardCost = row.getBigDecimal("periodendstandardcost") == null ? BigDecimal.ZERO : row.getBigDecimal("periodendstandardcost");
            BigDecimal periodEndCost = periodActualCost.add(periodEndStandardCost);
            int amtPrecision = this.fallPriceParam.getCurrencyAmtPrecision();
            BigDecimal endPrice = BigDecimal.ZERO;
            if (endQty.compareTo(BigDecimal.ZERO) != 0 && periodEndCost.compareTo(BigDecimal.ZERO) != 0) {
                endPrice = periodEndCost.divide(endQty, 10, 4);
            }
            BigDecimal curBaseQty = row.getBigDecimal("baseQty");
            BigDecimal curAmount = endPrice.multiply(curBaseQty).setScale(amtPrecision, RoundingMode.HALF_UP);
            entryDyc.set("amount", (Object)curAmount);
            entryDyc.set("baseQty", (Object)curBaseQty);
            entryDyc.set("baseprice", (Object)endPrice);
            this.calRealAmt(row, entryDyc);
            Long preEntryId = row.getLong("entryid");
            boolean exitPreEntry = preEntryId != null && !preEntryId.equals(0L);
            BigDecimal reqAmount = entryDyc.getBigDecimal("requireamount");
            BigDecimal hasAmount = entryDyc.getBigDecimal("hasamount");
            boolean bl = isReqAmtHasAmtZero = reqAmount.compareTo(BigDecimal.ZERO) == 0 && hasAmount.compareTo(BigDecimal.ZERO) == 0;
            if (!provAll.booleanValue() && isReqAmtHasAmtZero) continue;
            boolean bl2 = isQtyAmtZero = curBaseQty.compareTo(BigDecimal.ZERO) == 0 && curAmount.compareTo(BigDecimal.ZERO) == 0;
            if (isQtyAmtZero) continue;
            this.setZeroValue(provAll, entryDyc, curBaseQty, curAmount, reqAmount);
            if (exitPreEntry) {
                entryIds.add(new Object[]{this.fallPriceExtractParam.getCurrentPeriodNum(), preEntryId});
            }
            ++seq;
            entryDycs.add((Object)entryDyc);
        }
        if (entryDycs.size() > 0) {
            provBillNo = number;
            this.setBillHeadInfo(provDyc, provBillNo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{provDyc});
        }
        if (entryIds.size() > 0) {
            this.updateLastProvEndPeriod(entryIds);
        }
        return provBillNo;
    }

    protected DataSet getExpityDs(DataSet matBalDs) {
        String[] joinDims = this.getSetAndProvDims();
        HashSet<String> joinDimDists = new HashSet<String>(Arrays.asList(joinDims));
        FallPriceExpiryDateHelper expiryDateHelper = new FallPriceExpiryDateHelper(this.curPeriodLastDay, joinDimDists, this.fallPriceExtractParam.getCurrentPeriodNum());
        expiryDateHelper.setMatIds(this.curSettingProvMatIdsCache);
        expiryDateHelper.setInvOrgIds(this.curProvInvOrgIds);
        DataSet expiryDateDs = expiryDateHelper.getExpiryDateDs();
        JoinDataSet matBalJoinExpiryDs = matBalDs.join(expiryDateDs);
        this.joinOnDims(joinDimDists.toArray(new String[0]), matBalJoinExpiryDs);
        matBalJoinExpiryDs.on("balmaterial", "balmaterial");
        if ("warehousegroup".equals(this.fallPriceParam.getExtractWay())) {
            matBalJoinExpiryDs.on("warehousegroup", "balwaregroup");
        }
        DataSet matBalAccDs = matBalJoinExpiryDs.select(matBalDs.getRowMeta().getFieldNames(), new String[]{"expirydateday", "baseqty", "0.0 as actualamount", "0.0 as standardamount"}).finish().filter("expirydateday is null or (expirydatefrom <= expirydateday and expirydateday <= expirydateto)");
        return matBalAccDs;
    }
}

