/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.fallprice.AbstractFallPriceProvCal;
import kd.fi.cal.business.fallprice.FallPriceAgeProvCal;
import kd.fi.cal.business.fallprice.FallPriceExpiryProvCal;
import kd.fi.cal.business.fallprice.FallPriceExtractParam;
import kd.fi.cal.business.fallprice.FallPriceSettingParam;
import kd.fi.cal.common.helper.CalDLockHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class FallPriceExtractor {
    private FallPriceExtractParam fallPriceExtractParam = new FallPriceExtractParam();
    private Set<Long> userSelMatIdsCache = null;

    public String extract() {
        StringBuilder execMsgSB = new StringBuilder();
        for (FallPriceSettingParam fallPriceParam : this.fallPriceExtractParam.getMatFallPriceParam()) {
            execMsgSB.append(this.doExtract(fallPriceParam));
        }
        for (FallPriceSettingParam fallPriceParam : this.fallPriceExtractParam.getMatGroupFallPriceParam()) {
            execMsgSB.append(this.doExtract(fallPriceParam));
        }
        for (FallPriceSettingParam fallPriceParam : this.fallPriceExtractParam.getWareGroupFallPriceParam()) {
            execMsgSB.append(this.doExtract(fallPriceParam));
        }
        return execMsgSB.toString();
    }

    public void extractAsync() {
        Boolean isSplitInvOrg = CalDbParamServiceHelper.getBoolean((String)"fallprice_split_invorg");
        if (isSplitInvOrg.booleanValue()) {
            this.dispatchSplitInvOrgTask();
        } else {
            this.dispatchTask("", this.fallPriceExtractParam);
        }
    }

    private void dispatchSplitInvOrgTask() {
        Set<Long> invOrgIdSet = this.fallPriceExtractParam.getSelInvOrgIds();
        if (this.fallPriceExtractParam.getSelInvOrgIds().isEmpty()) {
            DBRoute dbRoute = new DBRoute("cal");
            String sql = "select fstorageorgunitid from t_cal_bal where fcostaccountid = ? and fperiod <= ? and fendperiod > ? group by fstorageorgunitid";
            Object[] paramObjs = new Object[]{this.fallPriceExtractParam.getCostAccountId(), this.fallPriceExtractParam.getCurrentPeriodNum(), this.fallPriceExtractParam.getCurrentPeriodNum()};
            Iterator invOrgDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)sql, (Object[])paramObjs);
            Iterator iterator = invOrgDs.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                invOrgIdSet.add(row.getLong("fstorageorgunitid"));
            }
        }
        QFilter orgIdsFilter = new QFilter("id", "in", invOrgIdSet);
        HashMap<Long, Object> invOrgNumNameMap = new HashMap<Long, Object>(16);
        DataSet orgNumDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{orgIdsFilter}, null);
        for (Row row : orgNumDs) {
            Long invOrgId = row.getLong("id");
            String invOrgNum = row.getString("number");
            invOrgNumNameMap.put(invOrgId, invOrgNum);
        }
        int i = 1;
        int size = invOrgNumNameMap.size();
        String format = "-\u3010%s/%s\u3011-\u3010%s-%s\u3011";
        for (Map.Entry entry : invOrgNumNameMap.entrySet()) {
            Long invOrgId = (Long)entry.getKey();
            String invOrgNum = (String)entry.getValue();
            this.fallPriceExtractParam.setInvOrgId(invOrgId);
            this.fallPriceExtractParam.setInvOrgNum(invOrgNum);
            String batchStr = String.format(format, i, size, this.fallPriceExtractParam.getCostAccountNum(), invOrgNum);
            this.dispatchTask(batchStr, this.fallPriceExtractParam);
            ++i;
        }
        if (invOrgNumNameMap.isEmpty()) {
            this.fallPriceExtractParam.setInvOrgId(0L);
            this.fallPriceExtractParam.setInvOrgNum("0");
            String batchStr = String.format(format, 0, 0, this.fallPriceExtractParam.getCostAccountNum(), "0");
            this.dispatchTask(batchStr, this.fallPriceExtractParam);
        }
    }

    private void dispatchTask(String batchStr, FallPriceExtractParam fallPriceExtractParam) {
        HashMap<String, String> jobParams = new HashMap<String, String>(16);
        jobParams.put("param", SerializationUtils.serializeToBase64((Object)fallPriceExtractParam));
        JobInfo job = new JobInfo();
        String opName = String.format(ResManager.loadKDString((String)"\u63d0\u53d6\u8dcc\u4ef7\u51c6\u5907 \u64cd\u4f5c\u4eba:%1$s", (String)"FallPriceExtractor_0", (String)"fi-cal-business", (Object[])new Object[0]), RequestContext.get().getUserName());
        opName = opName + batchStr;
        job.setName(opName);
        job.setName(opName);
        job.setTaskDefineId("2TEE2R//S16Z");
        job.setJobType(JobType.REALTIME);
        job.setParams(jobParams);
        job.setAppId("cal");
        job.setRunByLang(Lang.get());
        job.setTaskClassname("kd.fi.cal.formplugin.fallprice.FallPriceExtractTask");
        job.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        JobClient.dispatch((JobInfo)job);
    }

    public String doExtract(FallPriceSettingParam fallPriceParam) {
        this.init();
        String execMsg = "";
        try (TXHandle tx = TX.required();){
            try {
                String dLockKey = String.format("fi/cal/extractfallprice/%s@%s", this.fallPriceExtractParam.getCostAccountId(), fallPriceParam.getSettingId());
                Boolean isSplitInvOrg = CalDbParamServiceHelper.getBoolean((String)"fallprice_split_invorg");
                if (isSplitInvOrg.booleanValue()) {
                    dLockKey = dLockKey + this.fallPriceExtractParam.getInvOrgId();
                }
                DLock dLock = DLock.createReentrant((String)dLockKey);
                CalDLockHelper.releaseLockAfterTxEnd(Collections.singletonList(dLock));
                try (TraceSpan span = Tracer.create((String)"FallPriceExtractor-doExtract", (String)"FallPriceExtractor-doExtract");){
                    boolean lockSuccess = dLock.tryLock();
                    if (lockSuccess) {
                        AbstractFallPriceProvCal provCal = fallPriceParam.getEnableShelfLife() != false ? new FallPriceExpiryProvCal(fallPriceParam, this.fallPriceExtractParam) : new FallPriceAgeProvCal(fallPriceParam, this.fallPriceExtractParam);
                        provCal.setUserSelMatIdsCache(this.userSelMatIdsCache);
                        DataSet extractDataSet = provCal.getExtractDataSet();
                        String provBillNo = provCal.createProvBill(extractDataSet);
                        execMsg = provBillNo.length() > 0 ? String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u7684\u8dcc\u4ef7\u51c6\u5907\u8bbe\u7f6e\u201c%2$s\u201d\u5df2\u751f\u6210\u8ba1\u63d0\u5355\u201c%3$s\u201d\u3002", (String)"FallPriceExtractor_1", (String)"fi-cal-business", (Object[])new Object[0]), this.fallPriceExtractParam.getCostAccountName(), fallPriceParam.getSeetingName(), provBillNo) : String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u7684\u8dcc\u4ef7\u51c6\u5907\u8bbe\u7f6e\u201c%2$s\u201d\u6ca1\u6709\u9700\u8981\u8ba1\u63d0\u7684\u7269\u6599\u3001\u5df2\u7ecf\u8ba1\u63d0\u6216\u51b2\u56de\u3002", (String)"FallPriceExtractor_2", (String)"fi-cal-business", (Object[])new Object[0]), this.fallPriceExtractParam.getCostAccountName(), fallPriceParam.getSeetingName());
                    } else {
                        execMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u4e0b\u7684\u8dcc\u4ef7\u51c6\u5907\u8bbe\u7f6e\u201c%2$s\u201d\u6b63\u5728\u8ba1\u63d0\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"FallPriceExtractor_3", (String)"fi-cal-business", (Object[])new Object[0]), this.fallPriceExtractParam.getCostAccountName(), fallPriceParam.getSeetingName());
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return execMsg;
    }

    private void init() {
        this.cacheUserSelMatIds();
    }

    private List<QFilter> getMatFromToFilter(String matField, String matNumField) {
        String materialToNum;
        ArrayList<QFilter> filter = new ArrayList<QFilter>(16);
        List<Long> materialFromIds = this.fallPriceExtractParam.getMaterialFromIds();
        if (materialFromIds != null && materialFromIds.size() > 0) {
            QFilter materialFromf = null;
            materialFromf = materialFromIds.size() == 1 ? new QFilter(matNumField, ">=", (Object)this.fallPriceExtractParam.getMaterialFromNum()) : new QFilter(matField, "in", materialFromIds);
            filter.add(materialFromf);
        }
        if (!StringUtils.isEmpty((CharSequence)(materialToNum = this.fallPriceExtractParam.getMaterialToNum()))) {
            QFilter materialTof = new QFilter(matNumField, "<=", (Object)materialToNum);
            filter.add(materialTof);
        }
        return filter;
    }

    private void cacheUserSelMatIds() {
        List<QFilter> matFromToFilter = this.getMatFromToFilter("id", "number");
        if (matFromToFilter.isEmpty()) {
            return;
        }
        try (DataSet baseDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id", (QFilter[])matFromToFilter.toArray(new QFilter[0]), null);){
            for (Row row : baseDataSet) {
                if (this.userSelMatIdsCache == null) {
                    this.userSelMatIdsCache = new HashSet<Long>(16);
                }
                this.userSelMatIdsCache.add(row.getLong("id"));
            }
        }
    }

    public FallPriceExtractParam getFallPriceExtractParam() {
        return this.fallPriceExtractParam;
    }

    public void setFallPriceExtractParam(FallPriceExtractParam fallPriceExtractParam) {
        this.fallPriceExtractParam = fallPriceExtractParam;
    }
}

