/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.fallprice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FallPriceHelper {
    public static String getDropdownListStr(String source) {
        if (source == null) {
            source = "";
        }
        String[] setDims = source.split(",");
        ArrayList<String> setDimList = new ArrayList<String>(16);
        for (String dim : setDims) {
            if ("x".equals(dim) || StringUtils.isBlank((CharSequence)dim) || setDimList.contains(dim)) continue;
            setDimList.add(dim);
        }
        source = StringUtils.join((Object[])setDimList.toArray(new String[0]), (String)",");
        if (source.startsWith(",")) {
            source = source.substring(1);
        }
        if (source.endsWith(",")) {
            source = source.substring(0, source.length() - 1);
        }
        return source;
    }

    public static Set<String> getDropdownList(String source) {
        HashSet<String> dims = new HashSet<String>(16);
        String dropdownListStr = FallPriceHelper.getDropdownListStr(source);
        String[] split = dropdownListStr.split(",");
        dims.addAll(Arrays.asList(split));
        dims.remove("");
        dims.remove(" ");
        return dims;
    }

    public static List<String> getSetDimStrs(DynamicObject accsettingInfo) {
        ArrayList<String> setDimStrs = new ArrayList<String>(16);
        String[] setDims = FallPriceHelper.getDropdownListStr(accsettingInfo.getString("setdimension")).split(",");
        setDimStrs.addAll(Arrays.asList(setDims));
        setDimStrs.remove("");
        setDimStrs.remove(" ");
        String provisionWay = accsettingInfo.getString("provisionway");
        if (provisionWay.equals("A")) {
            setDimStrs.add("material");
        }
        if (provisionWay.equals("B")) {
            setDimStrs.add("material");
            setDimStrs.add("materialgroup");
        }
        if (provisionWay.equals("C")) {
            setDimStrs.add("warehousegroup");
        }
        return setDimStrs;
    }

    public static List<String> getSetDimStrsWithoutGroup(DynamicObject accsettingInfo) {
        List<String> setDimStrs = FallPriceHelper.getSetDimStrs(accsettingInfo);
        setDimStrs.remove("warehousegroup");
        setDimStrs.remove("materialgroup");
        return setDimStrs;
    }

    public static Long getCurrencyByCalPolicy(Long calPolicyId) {
        Long currencyId = 0L;
        DynamicObject currencyDyc = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter("id", "=", (Object)calPolicyId).toArray());
        if (currencyDyc != null) {
            currencyId = currencyDyc.getLong("currency");
        }
        return currencyId;
    }

    public static void writeBackPreEndPeriod(DynamicObject[] dataEntities) {
        HashSet<Object> billIds = new HashSet<Object>(dataEntities.length);
        HashSet<Object> entryIds = new HashSet<Object>(16);
        for (DynamicObject billDyc : dataEntities) {
            billIds.add(billDyc.getPkValue());
            DynamicObjectCollection entryDycs = billDyc.getDynamicObjectCollection("entry");
            for (DynamicObject entryDyc : entryDycs) {
                entryIds.add(entryDyc.getPkValue());
            }
        }
        ArrayList<Object[]> preEntryUpdateIds = new ArrayList<Object[]>(16);
        QFilter idf = new QFilter("id", "in", billIds);
        try (DataSet entryDs = QueryServiceHelper.queryDataSet((String)FallPriceHelper.class.getName(), (String)"cal_price_provbill", (String)"entry.id entryid,entry.preentryid preentryid", (QFilter[])new QFilter[]{idf}, null);){
            for (Row row : entryDs) {
                Long preEntryId = row.getLong("preentryid");
                boolean preEntryIdNotNull = preEntryId != null && !preEntryId.equals(0L);
                if (!preEntryIdNotNull || entryIds.contains(row.get("entryid"))) continue;
                preEntryUpdateIds.add(new Object[]{preEntryId});
            }
        }
        if (preEntryUpdateIds.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"update t_cal_price_proventry set fendperiod = 999999 where fentryid = ?", preEntryUpdateIds);
        }
    }

    public static void writeBackPreEndPeriodDelEntry(DynamicObject[] dataEntities) {
        HashSet<Object> billIds = new HashSet<Object>(dataEntities.length);
        HashSet<Object> entryIds = new HashSet<Object>(16);
        HashSet<String> deleteEntryIds = new HashSet<String>(16);
        ArrayList<Object[]> seqUpateSqlParams = new ArrayList<Object[]>(16);
        for (DynamicObject billDyc : dataEntities) {
            Boolean notInitBill = !billDyc.getBoolean("isinitbill");
            billIds.add(billDyc.getPkValue());
            DynamicObjectCollection entryDycs = billDyc.getDynamicObjectCollection("entry");
            for (DynamicObject entryDyc : entryDycs) {
                boolean delete;
                BigDecimal repAmount = entryDyc.getBigDecimal("replenishamount");
                boolean bl = delete = notInitBill != false && repAmount != null && repAmount.compareTo(BigDecimal.ZERO) == 0;
                if (delete) {
                    deleteEntryIds.add(entryDyc.getPkValue().toString());
                    seqUpateSqlParams.add(new Object[]{billDyc.getPkValue(), entryDyc.getInt("seq")});
                    continue;
                }
                entryIds.add(entryDyc.getPkValue());
            }
        }
        ArrayList<Object[]> preEntryUpdateIds = new ArrayList<Object[]>(16);
        QFilter idf = new QFilter("id", "in", billIds);
        try (DataSet entryDs = QueryServiceHelper.queryDataSet((String)FallPriceHelper.class.getName(), (String)"cal_price_provbill", (String)"entry.id entryid,entry.preentryid preentryid", (QFilter[])new QFilter[]{idf}, null);){
            for (Row row : entryDs) {
                Long preEntryId = row.getLong("preentryid");
                boolean preEntryIdNotNull = preEntryId != null && !preEntryId.equals(0L);
                if (!preEntryIdNotNull || entryIds.contains(row.get("entryid"))) continue;
                preEntryUpdateIds.add(new Object[]{preEntryId});
            }
        }
        if (preEntryUpdateIds.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"update t_cal_price_proventry set fendperiod = 999999 where fentryid = ?", preEntryUpdateIds);
        }
        if (deleteEntryIds.size() > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete t_cal_price_proventry where fentryid in ( " + StringUtils.join((Object[])deleteEntryIds.toArray(new String[0]), (String)",") + ")"));
        }
        if (seqUpateSqlParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"update t_cal_price_proventry set fseq = fseq - 1 where fid = ? and fseq > ?", seqUpateSqlParams);
        }
    }

    public static String getMatGroupDLM() {
        MainEntityType matEntityType = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup");
        IDataEntityProperty property = matEntityType.findProperty("parent");
        String longNumberDLM = ((ParentBasedataProp)property).getLongNumberDLM();
        return longNumberDLM;
    }

    public static Map<String, String> getEntityAgeFieldMap() {
        HashMap<String, String> entityAgeFieldMap = new HashMap<String, String>(16);
        QFilter repF = new QFilter("repoentity", "=", (Object)"cal_stock_age_col_repo");
        QFilter entityF = new QFilter("srcentity", "in", (Object)new String[]{"cal_costrecord_subentity", "cal_initbill"});
        QFilter isPresetF = new QFilter("sysdata", "=", (Object)Boolean.TRUE);
        DataSet ageFieldDs = QueryServiceHelper.queryDataSet((String)FallPriceHelper.class.getName(), (String)"scmc_report_colmap", (String)"srcentity,mapinfo_tag", (QFilter[])new QFilter[]{repF, entityF, isPresetF}, null);
        for (Row row : ageFieldDs) {
            String entity = row.getString("srcentity");
            String mapInfo = row.getString("mapinfo_tag");
            if (StringUtils.isEmpty((CharSequence)mapInfo)) continue;
            JSONObject colInfo = JSONObject.parseObject((String)mapInfo);
            JSONArray repoCols = colInfo.getJSONArray("repocol");
            JSONArray fullSrcCols = colInfo.getJSONArray("fullsrccol");
            int len = repoCols.size();
            for (int i = 0; i < len; ++i) {
                String repoCal = repoCols.getString(i);
                String fullSrcCol = fullSrcCols.getString(i);
                if (!"bookdate".equals(repoCal)) continue;
                entityAgeFieldMap.put(entity, fullSrcCol);
            }
        }
        return entityAgeFieldMap;
    }
}

