/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.formula;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.servicehelper.DispatchServiceHelper;

public class CalBcmFormualParser {
    private String formulaNumber;
    private List<String> paramNameWithoutEntryList = new ArrayList<String>(16);
    private List<String> paramNameWithEntryList = new ArrayList<String>(16);

    public CalBcmFormualParser(String formulaNumber) {
        this.formulaNumber = formulaNumber;
        this.init();
    }

    public Map<String, String> explainWithoutEntryFormulaValue(String formulaStr) {
        return this.explainFormualValue(this.paramNameWithoutEntryList, formulaStr);
    }

    public Map<String, String> explainWithEntryFormulValue(String formulaStr) {
        return this.explainFormualValue(this.paramNameWithEntryList, formulaStr);
    }

    private Map<String, String> explainFormualValue(List<String> paramNameList, String formulaStr) {
        HashMap<String, String> fieldValueMap = new HashMap<String, String>(16);
        if (formulaStr == null) {
            return fieldValueMap;
        }
        formulaStr = formulaStr.replace("(", "").replace(")", "").substring(this.formulaNumber.length() + 1);
        String[] paramValues = formulaStr.split("\",\"");
        int minLength = Math.min(paramValues.length, paramNameList.size());
        for (int i = 0; i < minLength; ++i) {
            String fieldKey = paramNameList.get(i);
            String paramValue = paramValues[i].replace("\"", "");
            fieldValueMap.put(fieldKey, paramValue);
        }
        return fieldValueMap;
    }

    private void init() {
        String fromualConfig = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"Cal4BcmRptFormulaService", (String)"getFormulaDef", (Object[])new Object[0]);
        Map formualConfigMap = (Map)SerializationUtils.fromJsonString((String)fromualConfig, Map.class);
        List formulaList = (List)JSON.parseObject((String)((String)formualConfigMap.get("formula_def_list")), List.class, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject curFormulaConfig = new JSONObject();
        for (JSONObject item : formulaList) {
            String curFormulaNumber = (String)item.get((Object)"number");
            if (!curFormulaNumber.equalsIgnoreCase(this.formulaNumber)) continue;
            curFormulaConfig = item;
            break;
        }
        JSONArray params = (JSONArray)curFormulaConfig.get((Object)"param");
        for (int i = 0; i < params.size(); ++i) {
            JSONObject item = (JSONObject)params.get(i);
            String fieldKey = (String)item.get((Object)"number");
            this.paramNameWithEntryList.add(fieldKey);
            fieldKey = fieldKey.replace("entry.", "").replace("entryentity.", "");
            fieldKey = fieldKey.replace(".number", "");
            this.paramNameWithoutEntryList.add(fieldKey);
        }
    }

    public String getFormulaNumber() {
        return this.formulaNumber;
    }

    public void setFormulaNumber(String formulaNumber) {
        this.formulaNumber = formulaNumber;
    }

    public List<String> getParamNameWithoutEntryList() {
        return this.paramNameWithoutEntryList;
    }

    public List<String> getParamNameWithEntryList() {
        return this.paramNameWithEntryList;
    }
}

