/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.formula;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.fallprice.FallPriceHelper;

public class StandGroupBaseDataConverter {
    private String groupDetailEntity;
    private String groupEntity;
    private String baseKey;
    private static final String BASEGROUPSTANDARD = "JBFLBZ";
    private Collection<Long> baseIds = null;
    private List<QFilter> baseDataFilters = new ArrayList<QFilter>(16);

    public StandGroupBaseDataConverter(String groupDetailEntity, String baseKey) {
        this.groupDetailEntity = groupDetailEntity;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)groupDetailEntity);
        BasedataProp groupProp = (BasedataProp)entityType.findProperty("group");
        this.groupEntity = groupProp.getBaseEntityId();
        this.baseKey = baseKey;
    }

    public Set<Long> getGroupIdsByStandNum(String standNum) {
        if (StringUtils.isEmpty((String)standNum)) {
            standNum = BASEGROUPSTANDARD;
        }
        long standId = this.getStandId(standNum);
        return this.getGroupIdsByStandId(standId);
    }

    public Set<Long> getGroupIdsByStandId(Long standId) {
        QFilter baseFilter = new QFilter("standard", "=", (Object)standId);
        HashSet<Long> groupIds = new HashSet<Long>(16);
        try (DataSet groupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.groupDetailEntity, (String)"group", (QFilter[])new QFilter[]{baseFilter}, null);){
            for (Row row : groupDs) {
                groupIds.add(row.getLong("group"));
            }
        }
        return groupIds;
    }

    public Set<Long> getBaseDataIdsByStandGroupNum(String standNum, List<String> groupNums) {
        long standId = this.getStandId(standNum);
        Set<Long> groupIds = this.getGroupIdsByGroupNums(groupNums);
        return this.getBaseDataIdsByStandGroupId(standId, groupIds);
    }

    private Set<Long> getGroupIdsByGroupNums(List<String> groupNums) {
        HashSet<Long> groupIds = new HashSet<Long>(16);
        QFilter groupNumFilter = new QFilter("number", "in", groupNums);
        try (DataSet groupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.groupEntity, (String)"id", (QFilter[])new QFilter[]{groupNumFilter}, null, (int)-1);){
            for (Row row : groupDs) {
                groupIds.add(row.getLong("id"));
            }
        }
        return groupIds;
    }

    public Set<Long> getBaseDataIdsByStandGroupId(Long standId, Collection<Long> groupIds) {
        boolean isGroupIdsEmpty;
        boolean isStandIdEmpty = standId == null || standId.equals(0L);
        boolean bl = isGroupIdsEmpty = groupIds == null || groupIds.isEmpty();
        if (isStandIdEmpty && isGroupIdsEmpty) {
            return new HashSet<Long>(0);
        }
        DataSet baseDataSet = this.getBaseDataDs(standId, groupIds, this.baseKey);
        HashSet<Long> baseIds = new HashSet<Long>(16);
        for (Row row : baseDataSet) {
            baseIds.add(row.getLong(this.baseKey));
        }
        return baseIds;
    }

    public DataSet getBaseDataDs(Long standId, Collection<Long> groupIds, String selFields) {
        boolean isStandIdEmpty;
        boolean bl = isStandIdEmpty = standId == null || standId.equals(0L);
        if (isStandIdEmpty) {
            standId = this.getStandId(BASEGROUPSTANDARD);
        }
        QFilter standIdFilter = new QFilter("standard", "=", (Object)standId);
        String selectFields = selFields;
        ArrayList ormOIs = new ArrayList(16);
        QFilter groupFilter = new QFilter("id", "in", groupIds);
        DynamicObjectCollection groupDycs = QueryServiceHelper.query((String)this.groupEntity, (String)"id,number,longnumber", (QFilter[])groupFilter.toArray());
        QFilter baseIdsFilter = this.getBaseIdsFilter();
        ArrayList<String> matGroupLNums = new ArrayList<String>(16);
        for (DynamicObject groupDyc : groupDycs) {
            String goupLongNum = groupDyc.getString("longnumber");
            matGroupLNums.add(goupLongNum);
        }
        int batSize = matGroupLNums.size() / 10;
        if (batSize == 0) {
            batSize = matGroupLNums.size();
        }
        if (batSize < 1) {
            batSize = 1;
        }
        String longNumberDLM = FallPriceHelper.getMatGroupDLM();
        Lists.partition(matGroupLNums, (int)batSize).forEach(batch -> {
            QFilter curGroupFilter = null;
            for (String goupLongNum : batch) {
                QFilter filter = new QFilter("longnumber", "like", (Object)(goupLongNum + longNumberDLM + "%"));
                if (curGroupFilter == null) {
                    curGroupFilter = filter;
                    continue;
                }
                curGroupFilter.or(filter);
            }
            if (curGroupFilter != null) {
                ormOIs.add(new OrmInput(this.getClass().getName(), this.groupEntity, "id", new QFilter[]{curGroupFilter}));
            }
        });
        QFilter groupIdsFilter = null;
        HashSet<Long> allGroupIds = new HashSet<Long>(groupIds);
        if (!ormOIs.isEmpty()) {
            Algo algo = Algo.create((String)this.getClass().getName());
            try (DataSet groupDataSet = algo.createDataSet(ormOIs.toArray(new Input[0]));){
                for (Row row : groupDataSet) {
                    allGroupIds.add(row.getLong("id"));
                }
            }
            groupIdsFilter = new QFilter("group", "in", allGroupIds);
        }
        this.baseDataFilters.add(baseIdsFilter);
        this.baseDataFilters.add(standIdFilter);
        this.baseDataFilters.add(groupIdsFilter);
        DataSet baseDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.groupDetailEntity, (String)selectFields, (QFilter[])this.baseDataFilters.toArray(new QFilter[0]), null);
        return baseDataSet;
    }

    private long getStandId(String standNum) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.groupDetailEntity);
        BasedataProp standProp = (BasedataProp)entityType.findProperty("standard");
        String standEntity = standProp.getBaseEntityId();
        QFilter standNumFilter = new QFilter("number", "=", (Object)standNum);
        DynamicObject standDyc = QueryServiceHelper.queryOne((String)standEntity, (String)"id", (QFilter[])new QFilter[]{standNumFilter});
        long standId = standDyc.getLong("id");
        return standId;
    }

    public void setBaseIds(Collection<Long> baseIds) {
        this.baseIds = baseIds;
    }

    private QFilter getBaseIdsFilter() {
        QFilter baseIdsFilter = null;
        if (this.baseIds != null) {
            baseIdsFilter = new QFilter(this.baseKey, "in", this.baseIds);
        }
        return baseIdsFilter;
    }

    public List<QFilter> getBaseDataFilters() {
        return this.baseDataFilters;
    }

    public void setBaseDataFilters(List<QFilter> baseDataFilters) {
        this.baseDataFilters = baseDataFilters;
    }
}

