/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.business.helper.ExceCostDetailDataSetFunc;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.SumTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class ExceCostHelper {
    public static DataSet getCalBal_balanceDataSet(boolean costElementByCostAccount, QFilter qfilter, boolean isNewBalance) {
        DataSet dys_old = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.helper.ExceCostHelper", (String)"cal_balance", (String)"id,periodendqty, periodendactualcost", (QFilter[])new QFilter[]{qfilter}, null);
        DataSet dys_new = costElementByCostAccount ? ExceCostHelper.buildBalanceData(qfilter, true) : QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.helper.ExceCostHelper", (String)"cal_bal", (String)"id,baseqty_bal, actualcost_bal", (QFilter[])new QFilter[]{qfilter}, null);
        DataSet dys = isNewBalance ? dys_new : dys_old;
        return dys;
    }

    public static DataSet buildBalanceData(QFilter filters, boolean costElementByCostAccount) {
        String balName = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balName = "cal_bal";
        }
        String fields = ExceCostHelper.getBalanceFields(false, true, costElementByCostAccount);
        if (!isNewBalance) {
            StringBuilder sb = new StringBuilder();
            String[] f = fields.split(",");
            for (int i = 0; i < f.length; ++i) {
                if ("currency".equals(f[i])) continue;
                if (i != f.length - 1) {
                    sb.append(f[i]).append(",");
                    continue;
                }
                sb.append(f[i]);
            }
            fields = sb.toString();
        }
        if (costElementByCostAccount) {
            DataSet rows;
            String selectFields = fields + ",material.group.longnumber";
            Set<String> collect = Stream.of(selectFields.split(",")).filter(s -> !"costelement".equals(s)).filter(s -> !"costsubelement".equals(s)).filter(s -> !"actualcost_bal as periodendactualcost".equals(s)).filter(s -> !"baseqty_bal as periodendqty".equals(s)).filter(s -> !"id".equals(s)).collect(Collectors.toSet());
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            if (balCompress) {
                ArrayList<QFilter> ql = new ArrayList<QFilter>();
                ql.add(filters);
                HashSet<String> otherFields = new HashSet<String>();
                otherFields.add("material.group.longnumber");
                otherFields.add("caldimension");
                otherFields.add("calrange");
                otherFields.add("currency");
                rows = BalanceUncompressHelper.getBalancDataSetDetail(false, false, otherFields, ql).select(selectFields);
            } else {
                rows = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.helper.ExceCostHelper", (String)balName, (String)selectFields, (QFilter[])new QFilter[]{filters}, (String)"");
            }
            rows = rows.groupBy(collect.toArray(new String[0])).reduceGroup((ReduceGroupFunction)new ExceCostDetailDataSetFunc(rows.getRowMeta()));
            if (rows.getRowMeta().getFieldIndex("id") == -1) {
                rows = rows.addField("0L", "id");
            }
            collect.add("balanceids");
            collect.add("id");
            rows = rows.groupBy(collect.toArray(new String[0])).max("periodendqty").sum("periodendactualcost").finish();
            return rows;
        }
        return QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.helper.ExceCostHelper", (String)balName, (String)(fields + ",material.group.longnumber"), (QFilter[])new QFilter[]{filters}, (String)"");
    }

    public static Input buildBalanceDataX(QFilter filters, Long costaccountid) {
        boolean costElementByCostAccount = ExceCostHelper.getCostElementByCostAccount(costaccountid);
        String balName = "cal_balance";
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            balName = "cal_bal";
        }
        String fields = ExceCostHelper.getBalanceFields(false, true, costElementByCostAccount);
        if (!isNewBalance) {
            StringBuilder sb = new StringBuilder();
            String[] f = fields.split(",");
            for (int i = 0; i < f.length; ++i) {
                if ("currency".equals(f[i])) continue;
                if (i != f.length - 1) {
                    sb.append(f[i]).append(",");
                    continue;
                }
                sb.append(f[i]);
            }
            fields = sb.toString();
        }
        if (costElementByCostAccount) {
            DataSet rows;
            String selectFields = fields + ",material.group.longnumber";
            Set<String> collect = Stream.of(selectFields.split(",")).filter(s -> !"costelement".equals(s)).filter(s -> !"costsubelement".equals(s)).filter(s -> !"actualcost_bal as periodendactualcost".equals(s)).filter(s -> !"baseqty_bal as periodendqty".equals(s)).filter(s -> !"id".equals(s)).collect(Collectors.toSet());
            boolean balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
            if (balCompress) {
                ArrayList<QFilter> ql = new ArrayList<QFilter>();
                ql.add(filters);
                HashSet<String> otherFields = new HashSet<String>();
                otherFields.add("material.group.longnumber");
                otherFields.add("caldimension");
                otherFields.add("calrange");
                otherFields.add("currency");
                rows = BalanceUncompressHelper.getBalancDataSetDetail(false, false, otherFields, ql).select(selectFields);
            } else {
                rows = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.helper.ExceCostHelper", (String)balName, (String)selectFields, (QFilter[])new QFilter[]{filters}, (String)"");
            }
            rows = rows.groupBy(collect.toArray(new String[0])).reduceGroup((ReduceGroupFunction)new ExceCostDetailDataSetFunc(rows.getRowMeta()));
            if (rows.getRowMeta().getFieldIndex("id") == -1) {
                rows = rows.addField("0L", "id");
            }
            collect.add("balanceids");
            collect.add("id");
            rows = rows.groupBy(collect.toArray(new String[0])).max("periodendqty").sum("periodendactualcost").finish();
            return new DataSetInput(rows, rows.getRowMeta());
        }
        return new OrmInput("kd.fi.cal.business.helper.ExceCostHelper", balName, fields + ",material.group.longnumber", new QFilter[]{filters});
    }

    public static String getBalanceFields(boolean isVs, boolean isQueryDataSet, boolean costElementByCostAccount) {
        Set<Object> dimFields = new HashSet(16);
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        String balName = "cal_balance";
        if (isNewBalance) {
            balName = "cal_bal";
            if (costElementByCostAccount) {
                dimFields.addAll(CalBalanceModelHelper.getDimFieldList((boolean)true));
            } else {
                dimFields.addAll(CalBalanceModelHelper.getDimFieldList((boolean)false));
            }
        } else {
            BalanceDimFieldParser balanceDimFieldParser = new BalanceDimFieldParser();
            dimFields = balanceDimFieldParser.getDimFields();
        }
        dimFields.add("id");
        dimFields.add("calorg");
        dimFields.add("baseunit");
        dimFields.add("currency");
        String periodEndQtyField = "periodendqty";
        String periodEndActualCostField = "periodendactualcost";
        if (isNewBalance && !isVs) {
            if (isQueryDataSet) {
                periodEndQtyField = "baseqty_bal as periodendqty";
                periodEndActualCostField = "actualcost_bal as periodendactualcost";
            } else {
                periodEndQtyField = "baseqty_bal";
                periodEndActualCostField = "actualcost_bal";
            }
        }
        dimFields.add(periodEndQtyField);
        dimFields.add(periodEndActualCostField);
        MainEntityType balanceEntityType = MetadataServiceHelper.getDataEntityType((String)balName);
        Set exFields = CommonSettingHelper.getExFieldSet();
        exFields.retainAll(balanceEntityType.getAllFields().keySet());
        if (isVs) {
            Map allFields = MetadataServiceHelper.getDataEntityType((String)"cal_excebalancesumlist").getAllFields();
            HashSet<String> entryFields = new HashSet<String>(16);
            for (Map.Entry mapEntry : allFields.entrySet()) {
                String key = (String)mapEntry.getKey();
                IDataEntityProperty property = (IDataEntityProperty)mapEntry.getValue();
                if (!(property.getParent() instanceof EntryType)) continue;
                entryFields.add(key);
            }
            exFields.retainAll(entryFields);
        }
        dimFields.addAll(exFields);
        StringBuilder fields = new StringBuilder();
        for (String string : dimFields) {
            fields = fields.append(string).append(',');
        }
        return fields.toString().substring(0, fields.length() - 1);
    }

    public static Set<String> getBalDimFields(String sumType, boolean query) {
        Set<String> dimListList;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            String balFields = CalBalanceModelHelper.getDimFields((boolean)true);
            String[] split = balFields.split(",");
            dimListList = Stream.of(split).collect(Collectors.toSet());
            dimListList.add("baseunit");
        } else {
            BalanceDimFieldParser balanceDimFieldParser = new BalanceDimFieldParser();
            dimListList = balanceDimFieldParser.getDimFields();
            dimListList.add("baseunit");
        }
        if (query) {
            dimListList.add("mal_group_longnumber");
        }
        dimListList.add("calorg");
        if (sumType != null && SumTypeEnum.HUAFENYIJU.getValue().equals(sumType) && query) {
            dimListList.add("calrangeid");
            dimListList.add("caldimension");
        }
        return dimListList;
    }

    public static DataSet createCostAdjust_matched_BALEND(boolean costElementByCostAccount, Set<String> dims, QFilter[] qFilter, Long costAccountId, Long periodId, boolean query) {
        String tableName = costElementByCostAccount ? "cal_costadjust_subentity" : "cal_costadjustbill";
        if (query) {
            dims.remove("mal_group_longnumber");
            dims.add("material.group.longnumber");
        }
        dims.remove("costelement");
        dims.remove("costsubelement");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)tableName);
        String entryName = "entryentity";
        StringBuilder selects = new StringBuilder();
        for (String dim : dims) {
            IDataEntityProperty p;
            boolean variables = dim.indexOf(".") != -1;
            String field = dim;
            if (variables) {
                field = dim.split("\\.")[0];
            }
            if ("calrangeid".equals(field)) {
                field = "calrange";
            }
            if ((p = entityType.findProperty(field)) == null) continue;
            if (p.getParent() instanceof EntryType) {
                if (variables) {
                    if ("material".equals(field)) {
                        selects.append(entryName).append(".").append(dim).append(" as ").append("mal_group_longnumber").append(",");
                        continue;
                    }
                    selects.append(entryName).append(".").append(dim).append(" as ").append(dim).append(",");
                    continue;
                }
                if ("calrange".equals(field)) {
                    selects.append(entryName).append('.').append(field).append(" as ").append("calrangeid").append(",");
                    continue;
                }
                selects.append(entryName).append('.').append(field).append(" as ").append(field).append(',');
                continue;
            }
            if (variables) {
                selects.append(dim).append(" as ").append(dim).append(",");
                continue;
            }
            selects.append(field).append(" as ").append(field).append(',');
        }
        selects.append("id as costadjustbillid").append(",").append("billno as costadjustbillno").append(",").append("billstatus").append(",").append("calstatus").append(",").append("entryentity.adjustamt as margin");
        List<QFilter> collect = Arrays.stream(qFilter).collect(Collectors.toList());
        collect.add(new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue()));
        collect.add(new QFilter("costaccount", "=", (Object)costAccountId));
        if (periodId != null) {
            collect.add(new QFilter("period", "=", (Object)periodId));
        } else {
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            collect.add(new QFilter("period", "=", period.getPkValue()));
        }
        DataSet costAdjustBill = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.helper.ExceCostHelper", (String)tableName, (String)selects.toString(), (QFilter[])collect.toArray(new QFilter[0]), null);
        String flag = "case when billstatus = 'C' and calstatus = 'A' then 'C' when billstatus = 'B' and calstatus = 'C' then 'D' when billstatus = 'C' and calstatus = 'C' then 'E' else 'B' end as ";
        String costAdjustFields = Arrays.stream(costAdjustBill.getRowMeta().getFieldNames()).map(String::valueOf).collect(Collectors.joining(","));
        costAdjustFields = costAdjustFields + "," + flag + " exportflag," + flag + " exportflagbak";
        costAdjustBill = costAdjustBill.select(costAdjustFields);
        if (query) {
            dims.remove("material.group.longnumber");
            dims.add("mal_group_longnumber");
        }
        return costAdjustBill;
    }

    public static OrmInput createCostAdjustDataX_matched_BALEND(Long costAccountId, Set<String> dims, QFilter[] qFilter, Long periodId, boolean query, String sumType) {
        String tableName = ExceCostHelper.getCostElementByCostAccount(costAccountId) ? "cal_costadjust_subentity" : "cal_costadjustbill";
        if (query) {
            dims.remove("mal_group_longnumber");
            dims.add("material.group.longnumber");
        }
        dims.remove("costelement");
        dims.remove("costsubelement");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)tableName);
        String entryName = "entryentity";
        StringBuilder selects = new StringBuilder();
        for (String dim : dims) {
            IDataEntityProperty p;
            boolean variables = dim.indexOf(".") != -1;
            String field = dim;
            if (variables) {
                field = dim.split("\\.")[0];
            }
            if ("calrangeid".equals(field)) {
                field = "calrange";
            }
            if ((p = entityType.findProperty(field)) == null) continue;
            if (p.getParent() instanceof EntryType) {
                if (variables) {
                    if ("material".equals(field)) {
                        selects.append(entryName).append(".").append(dim).append(" as ").append("mal_group_longnumber").append(",");
                        continue;
                    }
                    selects.append(entryName).append(".").append(dim).append(" as ").append(dim).append(",");
                    continue;
                }
                if ("calrange".equals(field)) {
                    selects.append(entryName).append('.').append(field).append(" as ").append("calrangeid").append(",");
                    continue;
                }
                selects.append(entryName).append('.').append(field).append(" as ").append(field).append(',');
                continue;
            }
            if (variables) {
                selects.append(dim).append(" as ").append(dim).append(",");
                continue;
            }
            selects.append(field).append(" as ").append(field).append(',');
        }
        selects.append("id as costadjustbillid").append(",").append("billno as costadjustbillno").append(",").append("billstatus").append(",").append("calstatus").append(",").append("entryentity.adjustamt as margin");
        List<QFilter> collect = Arrays.stream(qFilter).collect(Collectors.toList());
        collect.add(new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.END_BAL_BILL.getValue()));
        collect.add(new QFilter("costaccount", "=", (Object)costAccountId));
        if (periodId != null) {
            collect.add(new QFilter("period", "=", (Object)periodId));
        } else {
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            collect.add(new QFilter("period", "=", period.getPkValue()));
        }
        OrmInput costAdjustBillInput = new OrmInput("kd.fi.cal.business.helper.ExceCostHelper", tableName, selects.toString(), collect.toArray(new QFilter[0]));
        if (query) {
            dims.remove("material.group.longnumber");
            dims.add("mal_group_longnumber");
        }
        return costAdjustBillInput;
    }

    public static boolean getCostElementByCostAccount(Long costAccountId) {
        boolean costElementByCostAccount = false;
        boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
        if (isNewBalance) {
            costElementByCostAccount = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
        }
        return costElementByCostAccount;
    }

    public static boolean newPlugin() {
        return CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.EXCECOST_EXPORT_NEW) != null && CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.EXCECOST_EXPORT_NEW) != false;
    }
}

