/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceUncompressHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.function.FilterRepairByAllocDimValsFunction;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalStdcostdiffbillHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.StandardCostHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;

public class RepairStandardCostHelper {
    private static final Log logger = LogFactory.getLog(RepairStandardCostHelper.class);
    private static final String[] ENTRY_FIELDS = new String[]{"material", "storageorgunit", "mversion", "assist", "lot", "warehouse", "location", "baseunit", "invtype", "invstatus", "ownertype", "owner", "project", "tracknumber", "configuredcode"};
    private boolean multifactoryaccountFlag = false;

    public RepairStandardCostHelper(Long calorgid) {
        this.multifactoryaccountFlag = ParamsHelper.getMultifactoryaccountByCalOrg((Long)calorgid);
    }

    public DataSet getBalanceDataSet(Long costaccountId, DynamicObject period, Set<Long> calrangeIds, Set<Long> materialIds, Set<Long> storageorgunitIds, Long calorgId, String calType, Set<String> allocDimKeyCols, String allDims) {
        Date enddate = period.getDate("enddate");
        Date begindate = period.getDate("begindate");
        DataSet costTypeDataSet = this.getCostTypeDataSet(costaccountId, enddate, calorgId);
        HashSet<Long> costTypeIds = new HashSet(16);
        costTypeIds = this.getCostTypeIds(costTypeDataSet, storageorgunitIds);
        Set<Object> effectMatIds = new HashSet(16);
        effectMatIds = this.getEffectMatIds(costTypeDataSet, storageorgunitIds, materialIds, begindate, enddate, costTypeIds, calType);
        if (effectMatIds == null || effectMatIds.isEmpty()) {
            return null;
        }
        int periodNumber = period.getInt("periodyear") * 100 + period.getInt("periodnumber");
        QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
        filter.and("endperiod", ">", (Object)periodNumber);
        filter.and("period", "<=", (Object)periodNumber);
        filter.and("accounttype", "=", (Object)AccountTypeEnum.STANDARDCOST.getValue());
        if (calrangeIds != null && calrangeIds.size() > 0) {
            filter.and("calrange", "in", calrangeIds);
        }
        if (effectMatIds != null && effectMatIds.size() > 0) {
            filter.and("material", "in", effectMatIds);
        }
        if (storageorgunitIds != null && storageorgunitIds.size() > 0) {
            filter.and("storageorgunit", "in", storageorgunitIds);
        }
        String balanceEntity = CalBalanceModelHelper.isNewBalance() ? "cal_bal" : "cal_balance";
        Set<String> balanceFields = this.getBalanceFields();
        if (CalBalanceModelHelper.isNewBalance()) {
            balanceFields.add("costelement");
            balanceFields.add("costsubelement");
            balanceFields.add("baseqty_bal as periodendqty");
            balanceFields.add("standardcost_bal as periodendstandardcost");
        }
        balanceFields.add("0 as unitstandardcost");
        String selectFields = String.join((CharSequence)",", balanceFields);
        DataSet balanceDS = null;
        if (CalBalanceModelHelper.isNewBalance()) {
            Set otherDims = CalBalanceModelHelper.getAllDimField();
            otherDims.add("id");
            otherDims.add("calorg");
            otherDims.add("caldimension");
            otherDims.add("baseunit");
            otherDims.add("costelement");
            otherDims.add("costsubelement");
            balanceDS = BalanceUncompressHelper.getBalancDataSetDetail(false, true, otherDims, Collections.singletonList(filter)).select(selectFields);
        } else {
            balanceDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)balanceEntity, (String)selectFields, (QFilter[])filter.toArray(), null);
        }
        DataSet copyDS = balanceDS.copy();
        HashSet<Long> balIds = new HashSet<Long>(16);
        for (Row row : copyDS) {
            balIds.add(row.getLong("id"));
        }
        QFilter calDimensionFilter = new QFilter("caldimension", "like", (Object)"%mversion%");
        DataSet calDimensionDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_caldimension", (String)"id as caldimid", (QFilter[])calDimensionFilter.toArray(), null);
        QFilter matFilter = new QFilter("id", "in", effectMatIds);
        matFilter.and("auxptyentry.isaffectprice", "=", (Object)true);
        DataSet matDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id as matid", (QFilter[])matFilter.toArray(), null);
        DataSet dataSet = balanceDS.join(calDimensionDS, JoinType.LEFT).on("caldimension", "caldimid").select(balanceDS.getRowMeta().getFieldNames(), new String[]{"caldimid"}).finish();
        if (!CalBalanceModelHelper.isNewBalance()) {
            QFilter detailFilter = new QFilter("balid", "in", balIds);
            DataSet detailDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)"balid,costelement,costsubelement,periodendqty,periodendstandardcost", (QFilter[])detailFilter.toArray(), null);
            DataSet balDetailDS = balanceDS.join(detailDS, JoinType.INNER).on("id", "balid").select(balanceFields.toArray(new String[0]), new String[]{"costsubelement", "costelement", "periodendqty", "periodendstandardcost"}).finish();
            dataSet = balDetailDS.join(calDimensionDS, JoinType.LEFT).on("caldimension", "caldimid").select(balDetailDS.getRowMeta().getFieldNames(), new String[]{"caldimid"}).finish();
        }
        Object diffalloccols = ParamsHelper.getAppParam((long)calorgId, (String)"diffalloccols");
        HashSet<String> diffalloccolSet = new HashSet<String>(4);
        diffalloccolSet.add("calorg");
        diffalloccolSet.add("material");
        if (diffalloccols != null && StringUtils.isNotEmpty((String)diffalloccols.toString())) {
            for (String diffalloccol : diffalloccols.toString().split(",")) {
                if (!StringUtils.isNotEmpty((String)diffalloccol)) continue;
                diffalloccolSet.add(diffalloccol);
            }
        }
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        DataSet dataSetCopy = dataSet.copy().groupBy(diffalloccolSet.toArray(new String[0])).sum("periodendqty", "zerolineqty").sum("periodendstandardcost", "zerolinecost").finish();
        dataSetCopy = dataSetCopy.where("zerolineqty=0 and zerolinecost=0");
        JoinDataSet joinDataSet = dataSet.join(dataSetCopy, JoinType.LEFT);
        for (String diffalloccol : diffalloccolSet) {
            joinDataSet.on(diffalloccol, diffalloccol);
        }
        dataSet = joinDataSet.select(dataSet.getRowMeta().getFieldNames(), new String[]{"zerolineqty"}).finish().where("zerolineqty is null");
        dataSet = dataSet.select(fieldNames);
        dataSet = dataSet.join(matDS, JoinType.LEFT).on("material", "matid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"matid"}).finish();
        dataSet = dataSet.addField("case when caldimid = null then cast(0 as Long) else mversion end", "mversiontmp").addField("case when matid = null then cast(0 as Long) else assist end", "assisttmp");
        if (!StringUtils.isEmpty((String)allDims)) {
            dataSet = dataSet.filter((FilterFunction)new FilterRepairByAllocDimValsFunction(dataSet.getRowMeta(), allocDimKeyCols, allDims));
        }
        return dataSet;
    }

    public DataSet getMatCostInfoDataSet(Long calorgId, Set<Long> materialIds, DynamicObject period, Long costaccountId, Set<Long> storageorgunitIds, String calType, DataSet balanceDataSet, String newFieldGStr) {
        Date enddate = period.getDate("enddate");
        Date begindate = period.getDate("begindate");
        DataSet costTypeDataSet = this.getCostTypeDataSet(costaccountId, enddate, calorgId);
        DataSet costTypeDataSetCopy = costTypeDataSet.copy();
        HashSet<Long> costTypeIds = new HashSet(16);
        costTypeIds = this.getCostTypeIds(costTypeDataSet, storageorgunitIds);
        Set<Object> effectMatIds = new HashSet(16);
        effectMatIds = this.getEffectMatIds(costTypeDataSetCopy, storageorgunitIds, materialIds, begindate, enddate, costTypeIds, calType);
        if (effectMatIds == null || effectMatIds.isEmpty()) {
            return null;
        }
        HashMap paramsMap = new HashMap(16);
        Set calDimensionSet = StandardCostHelper.getCalDimensionSet((String)CommonSettingHelper.getCalDimensionStr());
        DataSet balanceDataSetCopy = balanceDataSet.copy();
        for (Row row : balanceDataSet) {
            ArrayList params;
            if (effectMatIds == null || !effectMatIds.contains(row.getLong("material"))) continue;
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            Long calorg = row.getLong("calorg");
            Long costAccount = row.getLong("costaccount");
            Long storageorgunit = row.getLong("storageorgunit");
            String paramKey = calorg + "_" + costAccount;
            param.put("uniqueID", row.getLong("id"));
            param.put("invorg", storageorgunit);
            param.put("date", enddate);
            param.put("material", row.getLong("material"));
            if (calDimensionSet != null && calDimensionSet.size() > 0) {
                for (String calDimension : calDimensionSet) {
                    Object value = row.get(calDimension);
                    if (value != null) {
                        if (value instanceof DynamicObject) {
                            param.put(calDimension, ((DynamicObject)value).getPkValue());
                            continue;
                        }
                        param.put(calDimension, value);
                        continue;
                    }
                    param.put(calDimension, 0L);
                }
            }
            if (null == (params = (ArrayList)paramsMap.get(paramKey)) || params.size() == 0) {
                params = new ArrayList(16);
                params.add(param);
                paramsMap.put(paramKey, params);
                continue;
            }
            params.add(param);
        }
        DataSet matCostInfoDS = new StandardCostHelper().getStandardCost(paramsMap, false);
        DataSet elementDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_elementdetail", (String)"element,subelement", null, null);
        DataSet dataSet = matCostInfoDS.groupBy(new String[]{"material", "costtype", "element", "subelement", "entryid"}).finish().join(elementDS, JoinType.CROSS).select(new String[]{"material", "costtype", "entryid"}, new String[]{"element", "subelement"}).finish();
        dataSet = dataSet.groupBy(new String[]{"material", "costtype", "element", "subelement", "entryid"}).finish();
        dataSet = dataSet.join(matCostInfoDS.groupBy(new String[]{"material", "costtype", "element", "subelement", "entryid"}).max("standardprice").finish(), JoinType.INNER).on("material", "material").on("element", "element").on("subelement", "subelement").on("entryid", "entryid").select(new String[]{"material", "element", "subelement", "costtype", "entryid"}, new String[]{"standardprice"}).finish();
        dataSet = dataSet.select("entryid,material,costtype,element,subelement,case when standardprice = null then 0  else standardprice end as unitstandardcost");
        DataSet matCostInfoDataSet = dataSet.join(balanceDataSetCopy, JoinType.INNER).on("entryid", "id").select(new String[]{"unitstandardcost", "0 as periodendstandardcost", "0 as periodendqty", "element as costelement", "subelement as costsubelement", "entryid as id"}, newFieldGStr.split(",")).finish();
        return matCostInfoDataSet;
    }

    private DataSet getCostTypeDataSet(Long costaccountId, Date enddate, Long calorgId) {
        QFilter costtypeFilter = new QFilter("costaccount", "=", (Object)costaccountId);
        costtypeFilter.and("effectdate", "<=", (Object)enddate);
        costtypeFilter.and("invaliddate", ">", (Object)enddate);
        costtypeFilter.and("bizstatus", "=", (Object)"1");
        DataSet costTypeDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costtypeorg", (String)"costtype,calorg,storageorgunit", (QFilter[])costtypeFilter.toArray(), null);
        return costTypeDataSet;
    }

    private Set<Long> getCostTypeIds(DataSet costTypeDataSet, Set<Long> storageorgunitIds) {
        HashSet<Long> costTypeIds = new HashSet<Long>(16);
        for (Row row : costTypeDataSet) {
            if (this.multifactoryaccountFlag) {
                Long storageorgunitId = row.getLong("storageorgunit");
                if (storageorgunitId == null) continue;
                if (storageorgunitIds != null && storageorgunitIds.size() > 0) {
                    if (!storageorgunitIds.contains(storageorgunitId)) continue;
                    costTypeIds.add(row.getLong("costtype"));
                    continue;
                }
                costTypeIds.add(row.getLong("costtype"));
                continue;
            }
            costTypeIds.add(row.getLong("costtype"));
        }
        return costTypeIds;
    }

    private Set<Long> getEffectMatIds(DataSet costTypeDataSet, Set<Long> storageorgunitIds, Set<Long> materialIds, Date begindate, Date enddate, Set<Long> costTypeIds, String calType) {
        QFilter matFilter = new QFilter("costtype", "in", costTypeIds);
        matFilter.and("effectdate", "<=", (Object)enddate);
        if (!StringUtils.isBlank((String)calType)) {
            if ("A".equals(calType)) {
                String strDate = "2000-01-01 00:00:00";
                SimpleDateFormat lsdStrFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    begindate = lsdStrFormat.parse(strDate);
                }
                catch (ParseException e) {
                    throw new KDBizException(e.getMessage());
                }
                matFilter.and("effectdate", ">", (Object)begindate);
            } else {
                matFilter.and("effectdate", ">=", (Object)begindate);
            }
        } else {
            matFilter.and("effectdate", ">=", (Object)begindate);
        }
        if (materialIds != null && !materialIds.isEmpty()) {
            matFilter.and("material", "in", materialIds);
        }
        DataSet matCostInfomats = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_matcostinfo", (String)"material.id as matId", (QFilter[])matFilter.toArray(), null);
        HashSet<Long> effectMatIds = new HashSet<Long>(16);
        effectMatIds.add(1L);
        if (matCostInfomats.isEmpty()) {
            return null;
        }
        for (Row row : matCostInfomats) {
            effectMatIds.add(row.getLong("matId"));
        }
        return effectMatIds;
    }

    public void createDiffBill(DataSet balanceDS, DataSet allDataSet, Long calorgid, Object costAccountId, Date bizdate, String newFieldGStr) {
        balanceDS = balanceDS.groupBy(newFieldGStr.split(",")).max("periodendqty").finish();
        JoinDataSet joinAdjustSet = allDataSet.join(balanceDS, JoinType.INNER);
        joinAdjustSet = this.joinOnSelectDims(joinAdjustSet, newFieldGStr.split(","));
        StringBuilder allFieldSb = new StringBuilder();
        DynamicObject costaccountDy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy", (QFilter[])new QFilter("id", "=", costAccountId).toArray());
        Long calpolicyId = costaccountDy.getLong("calpolicy");
        DynamicObject calpolicyDy = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency,currency.amtprecision", (QFilter[])new QFilter("id", "=", (Object)calpolicyId).toArray());
        int amtprecision = 2;
        amtprecision = calpolicyDy.getInt("currency.amtprecision");
        for (String fieldStr : allDataSet.getRowMeta().getFieldNames()) {
            if ("periodendqty".equals(fieldStr)) continue;
            allFieldSb.append(fieldStr);
            allFieldSb.append(",");
        }
        String allFieldStr = allFieldSb.substring(0, allFieldSb.length() - 1);
        allDataSet = joinAdjustSet.select(allFieldStr.split(","), new String[]{"periodendqty"}).finish();
        allDataSet = allDataSet.select(String.join((CharSequence)",", allDataSet.getRowMeta().getFieldNames()) + ",case when unitstandardcost is null then periodendstandardcost else periodendstandardcost-round(periodendqty*unitstandardcost," + amtprecision + ") end as standardcostdiff").where("standardcostdiff<>0");
        IDGenerator idGenerator = new IDGenerator("t_cal_stdcostdiffentry");
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(16);
        DynamicObject curBill = null;
        HashMap<String, Long> balId2EntryIdMap = new HashMap<String, Long>(16);
        ArrayList<CostAdjustDetailParams> detailParamsList = new ArrayList<CostAdjustDetailParams>(16);
        Set<String> balanceFields = this.getBalanceFields();
        Long currency = calpolicyDy.getLong("currency");
        int entryMaxSize = this.getEntryMaxSize(calorgid, 100000);
        HashSet<String> exFields = new HashSet<String>(16);
        this.getExField(balanceFields, exFields);
        for (Row row : allDataSet) {
            DynamicObjectCollection entry;
            Long costElementId = row.getLong("costelement");
            Long costSubElementId = row.getLong("costsubelement");
            if (null == costElementId || null == costSubElementId || Long.parseLong(String.valueOf(costElementId)) == 0L || Long.parseLong(String.valueOf(costSubElementId)) == 0L) continue;
            StringBuilder keycol = new StringBuilder();
            for (String field : ENTRY_FIELDS) {
                keycol.append(row.get(field));
            }
            for (String exField : exFields) {
                keycol.append(row.get(exField));
            }
            String entryKey = keycol.toString();
            BigDecimal adjustamt = row.getBigDecimal("standardcostdiff").setScale(amtprecision, RoundingMode.HALF_UP);
            WriteLogHelper.writeInfoLog((Log)logger, (String)("RepairStandardCostHelper createDiffBill entryKey=" + entryKey), (Object[])new Object[0]);
            if (BigDecimal.ZERO.compareTo(adjustamt) == 0) continue;
            WriteLogHelper.writeInfoLog((Log)logger, (String)("RepairStandardCostHelper createDiffBill adjustamt=" + adjustamt), (Object[])new Object[0]);
            Long entryId = (Long)balId2EntryIdMap.get(entryKey);
            if (entryId != null) {
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setEntryid((Object)entryId);
                param.setCostElementId((Object)row.getLong("costelement"));
                param.setCostSubElementId((Object)row.getLong("costsubelement"));
                param.setAdjustAmt(adjustamt);
                CalStdcostdiffbillHelper.setParamSubDdiffAmt((String)"M", (BigDecimal)adjustamt, (CostAdjustDetailParams)param);
                detailParamsList.add(param);
                continue;
            }
            entryId = idGenerator.getId();
            balId2EntryIdMap.put(entryKey, entryId);
            if (curBill == null) {
                curBill = this.createBillHead(calorgid, costAccountId, currency, bizdate);
                bills.add(curBill);
            }
            if ((entry = curBill.getDynamicObjectCollection("entryentity")).size() >= entryMaxSize) {
                curBill = this.createBillHead(calorgid, costAccountId, currency, bizdate);
                bills.add(curBill);
                entry = curBill.getDynamicObjectCollection("entryentity");
            }
            this.createBillEntryRow(entry, entryId, row, exFields);
            CostAdjustDetailParams param = new CostAdjustDetailParams();
            param.setEntryid((Object)entryId);
            param.setCostElementId((Object)row.getLong("costelement"));
            param.setCostSubElementId((Object)row.getLong("costsubelement"));
            param.setAdjustAmt(adjustamt);
            CalStdcostdiffbillHelper.setParamSubDdiffAmt((String)"M", (BigDecimal)adjustamt, (CostAdjustDetailParams)param);
            detailParamsList.add(param);
        }
        if (bills.isEmpty()) {
            return;
        }
        this.auditDiffBill(bills, detailParamsList);
    }

    private void auditDiffBill(List<DynamicObject> bills, List<CostAdjustDetailParams> detailParamsList) {
        DynamicObject[] infos = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]));
        HashSet<Long> billIds = new HashSet<Long>(infos.length);
        for (DynamicObject info : infos) {
            billIds.add(info.getLong("id"));
        }
        OperateOption op = OperateOption.create();
        String params = SerializationUtils.toJsonString(detailParamsList);
        op.setVariableValue("CostAdjustDetailParms", params);
        op.setVariableValue("ishasright", "true");
        op.setVariableValue("ignoreValidation", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (Object[])billIds.toArray(), (OperateOption)op);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess() || !errors.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                errorMsg.append(operror.getMessage());
            }
            String msg = String.format(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u53d8\u66f4\u5dee\u5f02\u5355\u5ba1\u6838\u5931\u8d25\uff1a%1$s", (String)"RepairStandardCostHelper_0", (String)"fi-cal-common", (Object[])new Object[0]), errorMsg + result.getMessage());
            throw new KDBizException(msg);
        }
    }

    private DynamicObject createBillHead(Long calorgid, Object costAccountId, Long currency, Date bizdate) {
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        bill.set("calorg", (Object)calorgid);
        bill.set("costaccount", costAccountId);
        bill.set("createtype", (Object)"C1");
        bill.set("currency", (Object)currency);
        bill.set("bizdate", (Object)bizdate);
        bill.set("bookdate", (Object)bizdate);
        bill.set("biztype", (Object)Character.valueOf('A'));
        bill.set("billstatus", (Object)Character.valueOf('B'));
        String userId = RequestContext.get().getUserId();
        Date date = TimeServiceHelper.now();
        bill.set("creator", (Object)userId);
        bill.set("createtime", (Object)date);
        bill.set("modifier", (Object)userId);
        bill.set("modifytime", (Object)date);
        String billno = BillNoHelper.getBillNo((String)"cal_stdcostdiffbill", (DynamicObject)bill, (String)calorgid.toString());
        bill.set("billno", (Object)billno);
        bill.set("remark", (Object)ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u751f\u6210\u8865\u5355\u573a\u666f\u4e0b\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02", (String)"RepairStandardCostHelper_1", (String)"fi-cal-common", (Object[])new Object[0]));
        return bill;
    }

    private void createBillEntryRow(DynamicObjectCollection entry, Long entryId, Row row, Set<String> exFields) {
        int size = entry.size();
        DynamicObject entryRow = entry.addNew();
        for (String field : ENTRY_FIELDS) {
            entryRow.set(field, row.get(field));
        }
        entryRow.set("id", (Object)entryId);
        entryRow.set("seq", (Object)(size + 1));
        for (String exField : exFields) {
            entryRow.set(exField, row.get(exField));
        }
    }

    private int getEntryMaxSize(Long calorgId, int entryMaxSize) {
        AppParam appParam = new AppParam("/KIUHEXROK3D", calorgId);
        appParam.setViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        entryMaxSize = (Integer)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"maxnumberentries");
        return entryMaxSize;
    }

    private void getExField(Set<String> balanceFields, Set<String> exFields) {
        Set exAllFields = CommonSettingHelper.getExFieldSet();
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        for (String exField : exAllFields) {
            IDataEntityProperty costadjustField;
            if (!balanceFields.contains(exField) || (costadjustField = costAdjustEntityType.findProperty(exField)) == null || !(costadjustField.getParent() instanceof EntryType)) continue;
            exFields.add(exField);
        }
    }

    private Set<String> getBalanceFields() {
        Set balanceFields = CalBalanceModelHelper.getAllDimField();
        balanceFields.add("id");
        balanceFields.add("calorg");
        balanceFields.add("caldimension");
        balanceFields.add("baseunit");
        return balanceFields;
    }

    private JoinDataSet joinOnSelectDims(JoinDataSet joinDataSet, String[] joinDims) {
        for (String joinDim : joinDims) {
            joinDataSet = joinDataSet.on(joinDim, joinDim);
        }
        return joinDataSet;
    }
}

