/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.matchrule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.matchrule.MatchResult;

public class MatchRuleAlgorithm {
    private MainEntityType masterbilltype;
    private MainEntityType asstbilltype;
    private List<Field> masterfiledlist = new ArrayList<Field>();
    private List<Field> asstfiledlist = new ArrayList<Field>();
    private String masterentrykey;
    private String asstentrykey;

    public MatchRuleAlgorithm(Object matchruleid) {
        DynamicObject matchrule = BusinessDataServiceHelper.loadSingleFromCache((Object)matchruleid, (String)"cal_matchrule");
        if (matchrule == null) {
            matchrule = BusinessDataServiceHelper.loadSingle((Object)matchruleid, (String)"cal_matchrule");
        }
        this.initAlgorithm(matchrule);
    }

    public MatchRuleAlgorithm(Object matchruleid, String masterentrykey, String asstentrykey) {
        this.masterentrykey = masterentrykey;
        this.asstentrykey = asstentrykey;
        DynamicObject matchrule = BusinessDataServiceHelper.loadSingleFromCache((Object)matchruleid, (String)"cal_matchrule");
        if (matchrule == null) {
            matchrule = BusinessDataServiceHelper.loadSingle((Object)matchruleid, (String)"cal_matchrule");
        }
        this.initAlgorithm(matchrule);
    }

    private void initAlgorithm(DynamicObject matchrule) {
        DynamicObject writeofftype = matchrule.getDynamicObject("writeofftype");
        this.masterbilltype = EntityMetadataCache.getDataEntityType((String)writeofftype.getDynamicObject("masterbill").getString("number"));
        this.asstbilltype = EntityMetadataCache.getDataEntityType((String)writeofftype.getDynamicObject("asstbill").getString("number"));
        for (DynamicObject entry : matchrule.getDynamicObjectCollection("entryentity")) {
            Field masterfield = this.getWholeField(entry.getString("billfield"), this.masterbilltype);
            if (masterfield.isentryfield) {
                this.masterentrykey = masterfield.entrykey;
            }
            this.masterfiledlist.add(masterfield);
            Field asstfield = this.getWholeField(entry.getString("rbillfield"), this.asstbilltype);
            if (asstfield.isentryfield) {
                this.asstentrykey = asstfield.entrykey;
            }
            this.asstfiledlist.add(asstfield);
        }
    }

    private Field getWholeField(String fieldname, MainEntityType billtype) {
        String[] fields = fieldname.split("\\.");
        StringBuilder sb = new StringBuilder(fieldname);
        IDataEntityProperty property = billtype.findProperty(fields[0]);
        Field field = new Field();
        for (IDataEntityType entitytype = property.getParent(); entitytype != null && !entitytype.getName().equals(billtype.getName()); entitytype = entitytype.getParent()) {
            if (entitytype instanceof EntryType) {
                field.isentryfield = true;
                field.entrykey = entitytype.getName();
                field.name = sb.toString();
                return field;
            }
            sb.insert(0, entitytype.getName() + ".");
        }
        field.name = sb.toString();
        return field;
    }

    private MatchResult checkBillType(DynamicObject masterbill, DynamicObject asstbill) {
        String asstbilltypename;
        String masterbilltypename;
        MatchResult result = new MatchResult();
        String masterbillname = masterbill.getDataEntityType().getName();
        if (!masterbillname.equals(masterbilltypename = this.masterbilltype.getName())) {
            String msg = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u7c7b\u578b\u201c%1$s\u201d\u4e0e\u5339\u914d\u89c4\u5219\u7684\u4e3b\u65b9\u5355\u636e\u7c7b\u578b\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"MatchRuleAlgorithm_5", (String)"fi-cal-business", (Object[])new Object[0]), masterbillname, masterbilltypename);
            result.setErrormessage(msg);
            return result;
        }
        String asstbillname = asstbill.getDataEntityType().getName();
        if (!asstbillname.equals(asstbilltypename = this.asstbilltype.getName())) {
            String msg = String.format(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u7c7b\u578b\u201c%1$s\u201d\u4e0e\u5339\u914d\u89c4\u5219\u7684\u8f85\u65b9\u5355\u636e\u7c7b\u578b\u201c%2$s\u201d\u4e0d\u5339\u914d\u3002", (String)"MatchRuleAlgorithm_6", (String)"fi-cal-business", (Object[])new Object[0]), asstbillname, asstbilltypename);
            result.setErrormessage(msg);
            return result;
        }
        result.setIssucess(true);
        return result;
    }

    private List<DynamicObjectWrapper> getWrapperList(Collection<DynamicObject> billlist, List<Field> fieldlist, String entryentitykey) {
        ArrayList<DynamicObjectWrapper> wrapperlist = new ArrayList<DynamicObjectWrapper>();
        if (StringUtils.isEmpty((String)entryentitykey)) {
            for (DynamicObject bill : billlist) {
                wrapperlist.add(new DynamicObjectWrapper(bill, fieldlist, entryentitykey));
            }
        } else {
            for (DynamicObject bill : billlist) {
                for (DynamicObject entry : bill.getDynamicObjectCollection(entryentitykey)) {
                    wrapperlist.add(new DynamicObjectWrapper(entry, fieldlist, entryentitykey));
                }
            }
        }
        return wrapperlist;
    }

    private List<DynamicObjectWrapper> getWrapperList(DynamicObject bill, List<Field> fieldlist, String entryentitykey) {
        ArrayList<DynamicObjectWrapper> wrapperlist = new ArrayList<DynamicObjectWrapper>();
        if (StringUtils.isEmpty((String)entryentitykey)) {
            wrapperlist.add(new DynamicObjectWrapper(bill, fieldlist, entryentitykey));
        } else {
            for (DynamicObject entry : bill.getDynamicObjectCollection(entryentitykey)) {
                wrapperlist.add(new DynamicObjectWrapper(entry, fieldlist, entryentitykey));
            }
        }
        return wrapperlist;
    }

    public MatchResult matchRules(Collection<DynamicObject> masterbilllist, Collection<DynamicObject> asstbilllist) {
        MatchResult result = this.checkBillType(masterbilllist.iterator().next(), asstbilllist.iterator().next());
        if (!result.isIssucess()) {
            return result;
        }
        List<DynamicObjectWrapper> masterwrapperlist = this.getWrapperList(masterbilllist, this.masterfiledlist, this.masterentrykey);
        List<DynamicObjectWrapper> asstwrapperlist = this.getWrapperList(asstbilllist, this.asstfiledlist, this.asstentrykey);
        result.setMastertype(masterwrapperlist.get(0).obj.getDataEntityType());
        result.setAssttype(asstwrapperlist.get(0).obj.getDataEntityType());
        result.setResultmap(this.matchRulesByWrappers(masterwrapperlist, asstwrapperlist));
        return result;
    }

    public MatchResult matchRules(DynamicObject masterbill, Collection<DynamicObject> asstbilllist) {
        MatchResult result = this.checkBillType(masterbill, asstbilllist.iterator().next());
        if (!result.isIssucess()) {
            return result;
        }
        List<DynamicObjectWrapper> masterwrapperlist = this.getWrapperList(masterbill, this.masterfiledlist, this.masterentrykey);
        List<DynamicObjectWrapper> asstwrapperlist = this.getWrapperList(asstbilllist, this.asstfiledlist, this.asstentrykey);
        result.setMastertype(masterwrapperlist.get(0).obj.getDataEntityType());
        result.setAssttype(asstwrapperlist.get(0).obj.getDataEntityType());
        result.setResultmap(this.matchRulesByWrappers(masterwrapperlist, asstwrapperlist));
        return result;
    }

    private Map<DynamicObject, List<DynamicObject>> matchRulesByWrappers(List<DynamicObjectWrapper> masterwrapperlist, List<DynamicObjectWrapper> asstwrapperlist) {
        HashMap<DynamicObject, List<DynamicObject>> resultmap = new HashMap<DynamicObject, List<DynamicObject>>(masterwrapperlist.size());
        for (DynamicObjectWrapper master : masterwrapperlist) {
            Map masterfieldmap = master.fieldvaluemap;
            boolean fieldIsEmpty = false;
            if (masterfieldmap.size() != 0) {
                for (Map.Entry masterfieldEntry : masterfieldmap.entrySet()) {
                    if (!StringUtils.isEmpty((String)((String)masterfieldEntry.getValue()))) continue;
                    fieldIsEmpty = true;
                    break;
                }
            }
            if (fieldIsEmpty) {
                resultmap.put(master.getObj(), new ArrayList(1));
                continue;
            }
            ArrayList<DynamicObject> asstbilllist = new ArrayList<DynamicObject>(16);
            for (DynamicObjectWrapper asst : asstwrapperlist) {
                if (!master.equals(asst)) continue;
                asstbilllist.add(asst.getObj());
            }
            resultmap.put(master.getObj(), asstbilllist);
        }
        return resultmap;
    }

    private static class DynamicObjectWrapper {
        private DynamicObject obj;
        private Map<Field, String> fieldvaluemap = new LinkedHashMap<Field, String>(16);
        private String valuestr = null;

        public DynamicObject getObj() {
            return this.obj;
        }

        public final void setObj(DynamicObject obj) {
            this.obj = obj;
        }

        private DynamicObjectWrapper(DynamicObject obj, List<Field> fields, String entryentitykey) {
            this.setObj(obj);
            for (Field field : fields) {
                this.fieldvaluemap.put(field, this.getFieldValue(this.getDynamicObject(obj, field, entryentitykey), field));
            }
        }

        private DynamicObject getDynamicObject(DynamicObject obj, Field field, String entryentitykey) {
            DynamicObject o = null;
            o = StringUtils.isEmpty((String)entryentitykey) ? obj : (!field.isentryfield ? (DynamicObject)obj.getParent() : obj);
            return o;
        }

        private String getFieldValue(DynamicObject o, Field field) {
            String[] fieldkeys = field.name.split("\\.");
            Object value = null;
            for (String fieldkey : fieldkeys) {
                value = o.get(fieldkey);
                if (!(value instanceof DynamicObject)) {
                    if (value instanceof BigDecimal) {
                        BigDecimal b = (BigDecimal)value;
                        return b.stripTrailingZeros().toPlainString();
                    }
                    return value == null ? "" : value.toString();
                }
                o = (DynamicObject)value;
            }
            return o.getPkValue().toString();
        }

        public String toString() {
            if (this.valuestr == null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<Field, String> entry : this.fieldvaluemap.entrySet()) {
                    sb.append(entry.getValue());
                    sb.append('$');
                }
                this.valuestr = sb.toString();
            }
            return this.valuestr;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DynamicObjectWrapper)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private static class Field {
        private String name;
        private boolean isentryfield = false;
        private String entrykey;

        private Field() {
        }
    }
}

