/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.process.IBizProcessor;
import kd.fi.cal.business.service.CalProcessContext;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.CommonUtils;

public abstract class AbstractBizProcessor
implements IBizProcessor {
    private List<ErrorMsg> errors = new ArrayList<ErrorMsg>(16);
    protected CalProcessContext calProcessContext;

    public void addErrorMsg(DynamicObject obj, String msg) {
        ErrorMsg error = new ErrorMsg();
        error.setErrorMsg(msg);
        error.setObject(obj);
        error.setId(obj.getLong("id"));
        this.errors.add(error);
    }

    public void addErrorMsg(DynamicObject obj, String errType, String msg) {
        ErrorMsg error = new ErrorMsg(obj.getLong("id"), obj, errType, msg);
        this.errors.add(error);
    }

    public void addErrorMsg(long billId, SynBillErrInfo info) {
        ErrorMsg error = new ErrorMsg(billId, info.getErrorType(), info.getErrorMsg());
        this.errors.add(error);
    }

    public void addErrorMsg(long billId, String errType, String msg) {
        ErrorMsg error = new ErrorMsg();
        error.setErrorMsg(msg);
        error.setErrorType(errType);
        error.setId(billId);
        this.errors.add(error);
    }

    public void addErrorMsg(String msg) {
        ErrorMsg error = new ErrorMsg();
        error.setErrorMsg(msg);
        this.errors.add(error);
    }

    public List<ErrorMsg> getErrors() {
        return this.errors;
    }

    public void addErrors(List<ErrorMsg> list) {
        this.errors.addAll(list);
    }

    public void addLock(String key, DLock lock) {
        this.calProcessContext.getLockMap().put(key, lock);
    }

    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) throws Exception {
        for (DynamicObject bill : bizBills) {
            try {
                if (bill == null) continue;
                this.doProcessor(params, bill);
            }
            catch (KDBizException e) {
                String errType = "3";
                ComboProp successCbo = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cal_businesslog").getProperty("success");
                for (ValueMapItem item : successCbo.getComboItems()) {
                    if (!item.getValue().equals(e.getErrorCode().getCode())) continue;
                    errType = item.getValue();
                    break;
                }
                this.addErrorMsg(bill, errType, this.getErrorMsg((Exception)((Object)e)));
            }
            catch (Exception e) {
                this.addErrorMsg(bill, "4", this.getErrorMsg(e));
            }
        }
    }

    public void doProcessor(Map params, DynamicObject bill) {
    }

    public String getErrorMsg(Exception e) {
        Throwable cause = e.getCause();
        if (cause instanceof KDBizException) {
            e = (KDBizException)cause;
        }
        return CommonUtils.getLogMessage((Throwable)e, (int)0);
    }

    public void setCalProcessContext(CalProcessContext calProcessContext) {
        this.calProcessContext = calProcessContext;
    }

    public void txCommitReleaseLock(final SyncLockHelper syncLockHelper) {
        CommitListener commitListener = new CommitListener(){

            public void onEnded(boolean rollbacked) {
                try (TXHandle txHandle = TX.notSupported();){
                    syncLockHelper.close();
                }
            }
        };
        TX.addCommitListener((CommitListener)commitListener);
    }
}

