/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;

public class CheckCostestimateBillDeleteProcess
extends AbstractBizProcessor {
    @Override
    public void doProcessor(Map params, DynamicObject bizBill) {
        super.doProcessor(params, bizBill);
        Long sourceBillId = bizBill.getLong("id");
        String sourceBillType = bizBill.getDataEntityType().getName();
        String entryKey = (String)params.get("entrykey");
        Long targetBillId = this.getTargetBillID(sourceBillId, sourceBillType, entryKey);
        if (targetBillId == null) {
            return;
        }
        DynamicObject costBill = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)"cal_costestimatebill", (String)"id,billno,billstatus");
        if ("C".equals(costBill.getString("billstatus"))) {
            String msg = String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u5df2\u786e\u8ba4\u6682\u4f30\u7684\u8d39\u7528\u6682\u4f30\u5355\uff0c\u5355\u636e\u7f16\u53f7\uff1a%1$s", (String)"CheckCostestimateBillDeleteProcess_1", (String)"fi-cal-business", (Object[])new Object[0]), costBill.getString("billno"));
            throw new KDBizException(msg);
        }
    }

    private Long getTargetBillID(Long sourceBillId, String sourceBillType, String entryKey) {
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillType);
        DynamicObjectCollection sourceEntryCol = sourceBill.getDynamicObjectCollection(entryKey);
        if (sourceEntryCol == null || sourceEntryCol.isEmpty()) {
            return null;
        }
        HashSet<Long> sourceEntryIdSet = new HashSet<Long>();
        for (DynamicObject sourceEntry : sourceEntryCol) {
            sourceEntryIdSet.add(sourceEntry.getLong("id"));
        }
        List targetRows = BFTrackerServiceHelper.loadTargetRowIds((String)sourceBillType, (String)entryKey, (Long[])sourceEntryIdSet.toArray(new Long[sourceEntryIdSet.size()]));
        if (targetRows == null || targetRows.isEmpty()) {
            return null;
        }
        Long tableId = ConvertMetaServiceHelper.loadTableDefine((String)"cal_costestimatebill", (String)"expenseentity").getTableId();
        for (BFRow row : targetRows) {
            if (!row.getId().getTableId().equals(tableId)) continue;
            return row.getId().getBillId();
        }
        return null;
    }
}

