/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.builder.CostAccountCache;
import kd.fi.cal.business.builder.CostRecordBuilder;
import kd.fi.cal.business.builder.IBillNoGenerator;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.impl.CreateInitCalBillProcess;
import kd.fi.cal.business.process.inner.CalBillInfo;
import kd.fi.cal.business.process.inner.FieldMappingResult;
import kd.fi.cal.business.process.inner.FilterInfoChecker;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountTypeHelperNew;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBillRuleCheckHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostTypeHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.MulCalBillSyncRuleHelper;
import kd.fi.cal.common.helper.StandardCostHelper;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.DateUtils;

public class CheckStdCostProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(CheckStdCostProcess.class);
    private static final String ALGOKEY = "kd.fi.cal.business.process.impl.CheckStdCostProcess";
    private static final String CALRULEFIELDS = "id,number,calbill.id,calbill.number,fieldmap.calfield,fieldmap.sourcefield,fieldmap.isorgfield,fieldmap.orgtype,filter,filter_tag,fieldmap.isextendfield,errortip";
    private static final String COSTACCOUNTFIELDS = "id,name,number,calpolicy,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.currency.priceprecision,dividebasis,calpolicy.currency.number,calpolicy.currency.name,calpolicy.convertmode,calpolicy.exratetable,calpolicy.calbycostelement,calpolicy.supporttaxamt,calorg,calorg.name,calorg.number";
    private Map<Long, DynamicObjectCollection> costAccountMap = new HashMap<Long, DynamicObjectCollection>(32);
    private Set<Long> isCalInvSchemeIds = new HashSet<Long>(16);
    private Set<Long> isCalInvTypeIds = new HashSet<Long>(16);
    private Map<String, CalBillInfo> calbilltypemap;
    private MainEntityType bizbillentitytype;
    private String bizbillentityname;
    private String bizbillentrykey;
    private DynamicObject bizEntityObject;
    private Map<Long, Set<String>> exFieldMap = new HashMap<Long, Set<String>>(32);
    private Map<Long, SynBillErrInfo> errMap = new HashMap<Long, SynBillErrInfo>(32);
    private Collection<DynamicObject> rules = new HashSet<DynamicObject>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        block80: {
            block81: {
                block78: {
                    block79: {
                        CheckStdCostProcess.logger.info("CheckStdCostProcess deal start");
                        if (bizBills.length != 0 && !"im_initbill".equals(bizBills[0].getDataEntityType().getName())) break block78;
                        if (params /* !! */  == null) {
                            params /* !! */  = new HashMap<String, Boolean>(1);
                        }
                        params /* !! */ .put("isAuditCheck", Boolean.TRUE);
                        process = new CreateInitCalBillProcess();
                        process.doProcessor(params /* !! */ , bizBills);
                        this.getErrors().addAll(process.getErrors());
                        if (this.errMap.isEmpty()) break block79;
                        for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                            this.addErrorMsg(entry.getKey(), entry.getValue());
                        }
                    }
                    return;
                }
                idSet = new HashSet<Long>(bizBills.length);
                for (DynamicObject info : bizBills) {
                    idSet.add(info.getLong("id"));
                }
                infos = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)this.getCostReorcdField(false), (QFilter[])new QFilter("bizbillid", "in", idSet).toArray());
                auditdate = new Date();
                for (DynamicObject costrecord : infos) {
                    if (costrecord.getDate("auditdate") != null) continue;
                    costrecord.set("auditdate", (Object)auditdate);
                }
                if (infos != null && infos.length >= 1) ** GOTO lbl62
                this.init(bizBills[0]);
                checkHelper = new CalBillRuleCheckHelper(this.bizbillentityname, idSet);
                checkHelper.addSkipProperty("billstatus");
                noCheckPassIds = checkHelper.check();
                for (Long noCheckPassId : noCheckPassIds) {
                    idSet.remove(noCheckPassId);
                }
                if (!idSet.isEmpty()) break block80;
                if (this.errMap.isEmpty()) break block81;
                for (Object entry : this.errMap.entrySet()) {
                    this.addErrorMsg((Long)entry.getKey(), (SynBillErrInfo)entry.getValue());
                }
            }
            return;
        }
        try {
            bizBillList = new ArrayList<Object>(16);
            for (DynamicObject bizBill : bizBills) {
                if (!idSet.contains(bizBill.getLong("id"))) continue;
                bizBillList.add(bizBill);
            }
            bizBills = bizBillList.toArray(new DynamicObject[0]);
            calBillMap = this.createCalBill(bizBills);
            if (calBillMap.isEmpty()) {
                return;
            }
            infos = this.createCostRecord(calBillMap);
            if (infos == null || infos.length < 1) {
                return;
            }
lbl62:
            // 3 sources

            notUpdBalBizTypeIdSet = CommonSettingHelper.getNotUpdBalBizType();
            isCalInvSchemeIds = new HashSet<Long>(16);
            isCalInvTypeIds = new HashSet<Long>(16);
            CheckStdCostProcess.cacheInvSchemeAndInvTypeInfos(isCalInvSchemeIds, isCalInvTypeIds);
            cSize = infos.length;
            costAccountIds = new HashSet<Object>(cSize);
            for (DynamicObject info : infos) {
                costAccountIds.add(info.get("costaccount_id"));
            }
            q = new QFilter("id", "in", costAccountIds);
            costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,enablestandardcost,costtype,costtype.name,costtype.number", (QFilter[])q.toArray());
            cSize1 = costAccountIds == null ? 16 : costAccountIds.size();
            billCostTypeMap = new HashMap<K, V>(cSize1);
            enableStandCostMap = new HashMap<String, Boolean>(cSize1);
            for (DynamicObject costaccount : costAccounts) {
                id = costaccount.getString("id");
                costtype = costaccount.getString("costtype");
                enableStandCost = costaccount.getBoolean("enablestandardcost");
                if (id == null || costtype == null) continue;
                enableStandCostMap.put(id, enableStandCost);
            }
            rowMeta = new RowMeta(new Field[]{new Field("entryid", (DataType)DateType.LongType), new Field("bizbillid", (DataType)DateType.LongType), new Field("costtype", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType), new Field("auditdate", (DataType)DateType.TimestampType), new Field("bookdate", (DataType)DateType.TimestampType)});
            billMatCostDataSetBuilder = Algo.create((String)"kd.fi.cal.business.process.impl.CheckStdCostProcess.checkBillStdCost_createData").createDataSetBuilder(rowMeta);
            costTypeSet = new HashSet<E>(16);
            materialIdSet = new HashSet<Long>(16);
            billCostTypeMap = CostTypeHelper.getCostTypeByBillAndBookDate((DynamicObject[])infos, (String[])new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "bookdate"}, (int)0);
            paramsMap = new HashMap<String, ArrayList<HashMap<K, V>>>(16);
            calDimensionSet = StandardCostHelper.getCalDimensionSet((String)CommonSettingHelper.getCalDimensionStr());
            costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
            for (DynamicObject info : infos) {
                invscheme = info.get("invscheme") instanceof DynamicObject != false ? info.getLong("invscheme.id") : info.getLong("invscheme");
                bizType = info.get("biztype") instanceof DynamicObject != false ? info.getLong("biztype.id") : info.getLong("biztype");
                if (notUpdBalBizTypeIdSet.contains(bizType)) continue;
                bookdate = info.getDate("bookdate");
                auditdate = CheckStdCostProcess.getStandardCostDate(auditdate, bookdate);
                bizBillId = info.getLong("bizbillid");
                costAccountId = info.getString("costaccount_id");
                calorgId = info.getString("calorg_id");
                paramKey = (String)calorgId + "_" + costAccountId;
                storageorgunitId = info.getString("storageorgunit_id");
                enableStandCost = (Boolean)enableStandCostMap.get(costAccountId);
                costTypeId = (Long)billCostTypeMap.get(info.getLong("id"));
                coll = info.getDynamicObjectCollection("entry");
                for (DynamicObject entryInfo : coll) {
                    invtype = entryInfo.getLong("invtype_id");
                    if (!isCalInvSchemeIds.contains(invscheme) || !isCalInvTypeIds.contains(invtype)) continue;
                    accounttype = entryInfo.getString("accounttype");
                    if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype) && !enableStandCost.booleanValue()) continue;
                    param = new HashMap<String, Object>(16);
                    materialId = entryInfo.getLong("material_id");
                    noupdatecalfields = entryInfo.getString("noupdatecalfields");
                    materialIdSet.add(materialId);
                    entryid = entryInfo.getLong("id");
                    param.put("uniqueID", entryid);
                    param.put("invorg", storageorgunitId);
                    param.put("date", auditdate);
                    param.put("material", materialId);
                    if (calDimensionSet != null && calDimensionSet.size() > 0) {
                        for (Object calDimension : calDimensionSet) {
                            if (StringUtils.isNotEmpty((String)calDimension) && noupdatecalfields.contains((CharSequence)calDimension)) continue;
                            value = null;
                            srcProperty = costRecordEntityType.findProperty((String)calDimension);
                            if (srcProperty != null) {
                                value = srcProperty instanceof BasedataProp ? ((calDimensionDy = entryInfo.getDynamicObject((String)calDimension)) != null ? entryInfo.getDynamicObject((String)calDimension).getPkValue() : entryInfo.get((String)calDimension + "_id")) : entryInfo.get((String)calDimension);
                            }
                            param.put((String)calDimension, value);
                        }
                    }
                    if (null == (paramss = (ArrayList<HashMap<K, V>>)paramsMap.get(paramKey)) || paramss.size() == 0) {
                        paramss = new ArrayList<HashMap<K, V>>(16);
                        paramss.add(param);
                        paramsMap.put(paramKey, paramss);
                    } else {
                        paramss.add(param);
                    }
                    billMatCostDataSetBuilder.append(new Object[]{entryid, bizBillId, costTypeId, materialId, auditdate, bookdate});
                }
            }
            costTypeErrMap = new HashMap<K, V>(32);
            costTypeSet = CostTypeHelper.getCostTypeByOrgAndBookDate((DynamicObject[])infos, (String[])new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "accounttype", "bookdate"}, costTypeErrMap, (int)0);
            if (!costTypeErrMap.isEmpty()) {
                for (Map.Entry<K, V> costTypeErr : costTypeErrMap.entrySet()) {
                    this.errMap.put((Long)costTypeErr.getKey(), new SynBillErrInfo("3", ((SynBillErrInfo)costTypeErr.getValue()).getErrorMsg()));
                }
            }
            if (costTypeSet.isEmpty() || materialIdSet.isEmpty() || paramsMap.isEmpty()) {
                return;
            }
            costTypeInfosMap = CostTypeHelper.getCostTypeInfos(costTypeSet);
            queryMatCostInfoDataSet = new StandardCostHelper().getStandardCost(paramsMap, true);
            var26_50 = null;
            try {
                billMatCostDataSet = billMatCostDataSetBuilder.build();
                var28_54 = null;
                try {
                    dataSet = billMatCostDataSet.groupBy(new String[]{"entryid", "bizbillid", "costtype", "material", "auditdate"}).finish().join(queryMatCostInfoDataSet, JoinType.INNER).on("entryid", "entryid").select(new String[]{"entryid", "bizbillid", "costtype", "material", "auditdate"}, new String[]{"effectdate", "expdate"}).finish().where("effectdate <= auditdate and expdate > auditdate");
                    dataSet = billMatCostDataSet.join(dataSet, JoinType.LEFT).on("entryid", "entryid").select(new String[]{"entryid", "bizbillid", "costtype", "material"}, new String[]{"auditdate"}).finish();
                    dataSet = dataSet.where("auditdate = null and costtype is not null");
                    matIds = new HashSet<Long>(16);
                    noCostInfoBizBillIdCostTypeMatMaps = new HashMap<Long, HashMap<K, V>>(16);
                    for (Row row : dataSet) {
                        bizbillid = row.getLong("bizbillid");
                        costType = row.getLong("costtype");
                        matId = row.getLong("material");
                        noCostInfoCostTypeMatMaps = (HashMap<Serializable, HashSet<Long>>)noCostInfoBizBillIdCostTypeMatMaps.get(bizbillid);
                        if (noCostInfoCostTypeMatMaps == null) {
                            noCostInfoCostTypeMatMaps = new HashMap<Serializable, HashSet<Long>>(16);
                            noCostInfoBizBillIdCostTypeMatMaps.put(bizbillid, noCostInfoCostTypeMatMaps);
                        }
                        if ((noCostInfoMatIds = (HashSet<Long>)noCostInfoCostTypeMatMaps.get(costType)) == null) {
                            noCostInfoMatIds = new HashSet<Long>(16);
                            noCostInfoCostTypeMatMaps.put(costType, noCostInfoMatIds);
                        }
                        noCostInfoMatIds.add(matId);
                        matIds.add(matId);
                    }
                    if (matIds.isEmpty()) {
                        matIds = materialIdSet;
                    }
                    materialNumMap = new HashMap<Long, String>(16);
                    materialFilter = new QFilter("id", "in", matIds);
                    materialDS = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.process.impl.CheckStdCostProcess.checkBillStdCost_queryMaterial", (String)"bd_material", (String)"id,number", (QFilter[])materialFilter.toArray(), null);
                    costType = null;
                    try {
                        for (Row row : materialDS) {
                            matId = row.getLong("id");
                            number = row.getString("number");
                            materialNumMap.put(matId, number);
                        }
                    }
                    catch (Throwable var36_66) {
                        costType = var36_66;
                        throw var36_66;
                    }
                    finally {
                        if (materialDS != null) {
                            if (costType != null) {
                                try {
                                    materialDS.close();
                                }
                                catch (Throwable var36_65) {
                                    costType.addSuppressed(var36_65);
                                }
                            } else {
                                materialDS.close();
                            }
                        }
                    }
                    s = ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\uff0c\u6ca1\u6709\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"SyncBizBill4AuditServiceProcess_30", (String)"fi-cal-business", (Object[])new Object[0]);
                    materialNames = new HashSet<String>(16);
                    for (Map.Entry<K, V> bizBillMapEntry : noCostInfoBizBillIdCostTypeMatMaps.entrySet()) {
                        bizBillId = (Long)bizBillMapEntry.getKey();
                        noCostInfoCostTypeMatMaps = (Map)bizBillMapEntry.getValue();
                        msg = new StringBuilder();
                        for (Map.Entry mapEntry : noCostInfoCostTypeMatMaps.entrySet()) {
                            costtypeId = (Long)mapEntry.getKey();
                            matids = (Set)mapEntry.getValue();
                            if (costTypeInfosMap.get(costtypeId) == null) {
                                erroMsg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u540c\u6b65\u5230\u6838\u7b97\uff0c\u627e\u4e0d\u5230\u786e\u5b9a\u7684\u6210\u672c\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u5b58\u8d27\u6838\u7b97\u4f1a\u8ba1\u7ef4\u62a4\u6570\u636e\u3002", (String)"SyncBizBill4AuditServiceProcess_15", (String)"fi-cal-business", (Object[])new Object[0]);
                                this.errMap.put(bizBillId, new SynBillErrInfo("3", erroMsg));
                                continue;
                            }
                            costTypeName = ((DynamicObject)costTypeInfosMap.get(costtypeId)).getString("name");
                            costTypeNum = ((DynamicObject)costTypeInfosMap.get(costtypeId)).getString("number");
                            materialNames.clear();
                            for (Long matId : matids) {
                                materialNum = (String)materialNumMap.get(matId);
                                materialNames.add("\u3010" + materialNum + "\u3011");
                            }
                            if (materialNames.isEmpty()) continue;
                            errorMsg = String.format(s, new Object[]{String.join((CharSequence)",", materialNames), costTypeNum + " [" + costTypeName + "]"});
                            msg.append(errorMsg);
                        }
                        if (msg.length() <= 0) continue;
                        synBillErrInfo = this.errMap.get(bizBillId);
                        if (synBillErrInfo == null) {
                            synBillErrInfo = new SynBillErrInfo("3", msg.toString());
                        } else {
                            synBillErrInfo.setErrorMsg(synBillErrInfo.getErrorMsg() + msg);
                        }
                        this.errMap.put(bizBillId, synBillErrInfo);
                    }
                }
                catch (Throwable var29_57) {
                    var28_54 = var29_57;
                    throw var29_57;
                }
                finally {
                    if (billMatCostDataSet != null) {
                        if (var28_54 != null) {
                            try {
                                billMatCostDataSet.close();
                            }
                            catch (Throwable var29_56) {
                                var28_54.addSuppressed(var29_56);
                            }
                        } else {
                            billMatCostDataSet.close();
                        }
                    }
                }
            }
            catch (Throwable var27_53) {
                var26_50 = var27_53;
                throw var27_53;
            }
            finally {
                if (queryMatCostInfoDataSet != null) {
                    if (var26_50 != null) {
                        try {
                            queryMatCostInfoDataSet.close();
                        }
                        catch (Throwable var27_52) {
                            var26_50.addSuppressed(var27_52);
                        }
                    } else {
                        queryMatCostInfoDataSet.close();
                    }
                }
            }
        }
        catch (Throwable var57_87) {
            throw var57_87;
        }
        finally {
            if (!this.errMap.isEmpty()) {
                for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                    this.addErrorMsg(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private DynamicObject[] createCostRecord(Map<String, List<DynamicObject>> calBillMap) {
        Long currtime = System.currentTimeMillis();
        DynamicObjectCollection costAccounts = null;
        HashMap costRecordMap = new HashMap();
        HashSet<DynamicObject> costRecordAllSet = new HashSet<DynamicObject>(16);
        HashMap<Long, CostAccountCache> costAccountCache = new HashMap<Long, CostAccountCache>();
        HashMap<Long, DynamicObject> ownerMap = new HashMap<Long, DynamicObject>();
        IDGenerator cosRecIdGen = new IDGenerator("t_cal_calcostrecord");
        for (Map.Entry<String, List<DynamicObject>> entry : calBillMap.entrySet()) {
            boolean isSingle;
            HashSet costRecordSet = new HashSet(16);
            String key = entry.getKey();
            long billId = Long.parseLong(key.split(",")[0]);
            Long ownerId = Long.valueOf(key.split(",")[1]);
            costAccounts = this.getAllCostAccount(ownerId);
            if (costAccounts.isEmpty()) {
                DynamicObject owner = (DynamicObject)ownerMap.get(ownerId);
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org", (String)"id,number,name");
                }
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bd_supplier", (String)"id,number,name");
                }
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bd_customer", (String)"id,number,name");
                }
                if (owner != null) {
                    ownerMap.put(ownerId, owner);
                }
                String msg = String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u201c%1$s\u201d\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"SyncBizBill4AuditServiceProcess_27", (String)"fi-cal-business", (Object[])new Object[0]), owner == null ? "" : owner.getString("number") + "\uff08" + owner.getString("name") + "\uff09");
                this.errMap.put(billId, new SynBillErrInfo("3", msg));
                continue;
            }
            int size = costAccounts.size();
            DynamicObject calBill = null;
            if (size <= 0) continue;
            List<DynamicObject> calBillList = entry.getValue();
            int listSize = calBillList.size();
            boolean bl = isSingle = listSize == 1;
            if (listSize > 1) {
                Collections.sort(calBillList, new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        if ("cal_outcalbill".equals(o1.getDataEntityType().getName())) {
                            return -1;
                        }
                        if ("cal_incalbill".equals(o1.getDataEntityType().getName())) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            boolean isErr = false;
            currtime = System.currentTimeMillis();
            for (int i = 0; i < listSize; ++i) {
                calBill = calBillList.get(i);
                String calNo = calBill.getString("billNo");
                for (DynamicObject costAccount : costAccounts) {
                    CostRecordNoGenerator generator = new CostRecordNoGenerator(calNo, isSingle, i + 1);
                    Set<String> exFieldSet = this.exFieldMap.get(calBill.getLong("id"));
                    try {
                        CostRecordBuilder builder = new CostRecordBuilder(calBill, costAccount, exFieldSet, costAccountCache);
                        DynamicObject record = builder.createCostRecord(generator, costAccountCache);
                        record.set("id", (Object)cosRecIdGen.getId());
                        costRecordSet.add(record);
                    }
                    catch (KDBizException e) {
                        this.errMap.put(billId, new SynBillErrInfo("3", e.getMessage()));
                        isErr = true;
                        break;
                    }
                    catch (Exception e) {
                        this.errMap.put(billId, new SynBillErrInfo("4", e.getMessage()));
                        isErr = true;
                        break;
                    }
                }
                if (isErr) break;
            }
            currtime = System.currentTimeMillis();
            if (isErr) continue;
            HashSet set = (HashSet)costRecordMap.get(billId);
            if (set == null) {
                set = new HashSet(16);
                costRecordMap.put(billId, set);
            }
            set.addAll(costRecordSet);
        }
        logger.info("SyncBizBill4AuditServiceProcess-\u6210\u672c\u8d26\u7c3f:\u6784\u9020\u6210\u672c\u8bb0\u5f55\uff1a" + (currtime - System.currentTimeMillis()));
        Iterator<Object> iterator = this.errMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            costRecordMap.remove(l);
        }
        if (costRecordMap.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : costRecordMap.entrySet()) {
            for (DynamicObject info : (Set)entry.getValue()) {
                costRecordAllSet.add(info);
            }
        }
        this.cacheInvSchemeAndInvTypeInfos();
        logger.info("SyncBizBill4AuditServiceProcess-\u7f13\u5b58\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u7684\u5e93\u5b58\u4e8b\u52a1\u548c\u5e93\u5b58\u7c7b\u578b\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        DynamicObject[] infos = costRecordAllSet.toArray(new DynamicObject[costRecordAllSet.size()]);
        logger.info("SyncBizBill4AuditServiceProcess-\u5f00\u59cb\u5904\u7406\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5206\u5f55\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e0e\u6838\u7b97\u8303\u56f4\uff1a" + System.currentTimeMillis());
        new AccountTypeHelperNew(infos).handleCalRangeAccountType();
        logger.info("SyncBizBill4AuditServiceProcess-\u4e0d\u66f4\u65b0\u6838\u7b97\u4f59\u989d\u7684\u4e1a\u52a1\u7c7b\u578bid\u96c6\u5408\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        Iterator iterator2 = costRecordMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            long billId = (Long)entry.getKey();
            Set set = (Set)entry.getValue();
            boolean isErr = false;
            for (DynamicObject info : set) {
                Object costAccountId = info.get("costaccount_id");
                DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
                for (DynamicObject entryInfo : coll) {
                    if (entryInfo.get("calrange") != null && Long.parseLong(entryInfo.get("calrange").toString()) != 0L) continue;
                    DynamicObject costAccountInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount", (String)"id,number,name");
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u6838\u7b97\u8303\u56f4\u3002", (String)"SyncBizBill4AuditServiceProcess_28", (String)"fi-cal-business", (Object[])new Object[0]), costAccountInfo.getString("number") + "\uff08" + costAccountInfo.getString("name") + "\uff09");
                    this.errMap.put(billId, new SynBillErrInfo("3", msg));
                    isErr = true;
                    break;
                }
                if (!isErr) continue;
                break;
            }
            if (!isErr) continue;
            iterator2.remove();
        }
        if (costRecordMap.isEmpty()) {
            return null;
        }
        logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u5904\u7406\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5206\u5f55\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e0e\u6838\u7b97\u8303\u56f4\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        costRecordAllSet.clear();
        for (Map.Entry entry : costRecordMap.entrySet()) {
            for (DynamicObject info : (Set)entry.getValue()) {
                costRecordAllSet.add(info);
            }
        }
        infos = costRecordAllSet.toArray(new DynamicObject[costRecordAllSet.size()]);
        return infos;
    }

    private void cacheInvSchemeAndInvTypeInfos() {
        QFilter invSchemeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id", (QFilter[])invSchemeFilter.toArray());
        for (DynamicObject dynamicObject : invSchemes) {
            this.isCalInvSchemeIds.add(dynamicObject.getLong("id"));
        }
        QFilter invTypeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invTypes = QueryServiceHelper.query((String)"bd_invtype", (String)"id", (QFilter[])invTypeFilter.toArray());
        for (DynamicObject dynamicObject : invTypes) {
            this.isCalInvTypeIds.add(dynamicObject.getLong("id"));
        }
    }

    private Map<String, List<DynamicObject>> createCalBill(DynamicObject[] bizBills) {
        long currtime = System.currentTimeMillis();
        HashMap<String, List<DynamicObject>> costBillMap = new HashMap<String, List<DynamicObject>>(128);
        if (this.rules == null || this.rules.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5173\u7cfb\u3002", (String)"SyncBizBill4AuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
            for (DynamicObject info : bizBills) {
                this.errMap.put(info.getLong("id"), new SynBillErrInfo("5", msg));
            }
            return costBillMap;
        }
        HashSet<Long> idSet = new HashSet<Long>(bizBills.length);
        for (DynamicObject info : bizBills) {
            idSet.add(info.getLong("id"));
        }
        if (idSet.isEmpty()) {
            return costBillMap;
        }
        HashMap calBillMap = new HashMap(128);
        HashMap<Long, String> unValidIdMap = new HashMap<Long, String>(16);
        FilterInfoChecker checker = new FilterInfoChecker(this.bizbillentityname, idSet);
        checker.loadSyncBillsByID();
        if (idSet.isEmpty()) {
            return costBillMap;
        }
        HashSet<String> genCalEntityBizBillIdStrs = new HashSet<String>(16);
        HashSet<Long> mulRuleBillIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : this.rules) {
            String calBillNumber = dynamicObject.getDynamicObject("calbill").getString("number");
            CalBillInfo calBillInfo = this.getCalBillInfo(calBillNumber);
            String calBillEntryKey = calBillInfo.getEntrykey();
            FieldMappingResult fieldMappingResult = this.getFieldMapping(dynamicObject, calBillNumber);
            String ownerkey = fieldMappingResult.getOwnerField().getTotalkey();
            kd.fi.cal.business.process.inner.Field calorgField = fieldMappingResult.getCalOrgField();
            StringBuilder bizEntryKey = new StringBuilder();
            String[] entryOwners = ownerkey.split("\\.");
            entryOwners[entryOwners.length - 1] = "id";
            for (String name : entryOwners) {
                bizEntryKey.append(name).append('.');
            }
            String bizEntryKeyStr = bizEntryKey.toString().substring(0, bizEntryKey.length() - 1);
            String bizSelector = this.getBizBillSelector(fieldMappingResult.getBizFieldSet());
            if (!bizSelector.contains(bizEntryKeyStr)) {
                bizSelector = bizSelector + "," + bizEntryKeyStr;
            }
            String filter = dynamicObject.getString("filter_tag");
            filter = this.skipBillStatusFilter(filter);
            checker.setBizSelector(bizSelector);
            checker.setFilterStr(filter);
            Map<Long, String> checkErrorInfo = checker.doCheckErrorInfo();
            for (Map.Entry<Long, String> e : checkErrorInfo.entrySet()) {
                long id = e.getKey();
                String msg = e.getValue();
                String errorMsg = (String)unValidIdMap.get(id);
                errorMsg = errorMsg != null ? errorMsg + msg : msg;
                unValidIdMap.put(id, errorMsg);
            }
            Map<Long, DynamicObjectCollection> validEntryMaps = this.getValidEntrys(dynamicObject, idSet, bizSelector, bizEntryKeyStr);
            for (Map.Entry<Long, DynamicObjectCollection> entry : validEntryMaps.entrySet()) {
                long billId = entry.getKey();
                DynamicObjectCollection bizBillColl = entry.getValue();
                if (bizBillColl.isEmpty()) continue;
                boolean isAddBillIdSucess = genCalEntityBizBillIdStrs.add(calBillNumber + billId);
                if (!isAddBillIdSucess) {
                    mulRuleBillIds.add(billId);
                }
                HashSet<String> exFieldSet = new HashSet<String>();
                for (DynamicObject ruleEntry : dynamicObject.getDynamicObjectCollection("fieldmap")) {
                    boolean isExtendField = ruleEntry.getBoolean("isextendfield");
                    if (!isExtendField) continue;
                    String calFieldName = ruleEntry.getString("calfield");
                    exFieldSet.add(calFieldName);
                }
                HashMap<String, DynamicObject> ownerMapCalBill = (HashMap<String, DynamicObject>)calBillMap.get(calBillInfo);
                if (ownerMapCalBill == null) {
                    ownerMapCalBill = new HashMap<String, DynamicObject>(16);
                    calBillMap.put(calBillInfo, ownerMapCalBill);
                }
                Map<kd.fi.cal.business.process.inner.Field, kd.fi.cal.business.process.inner.Field> headMapping = fieldMappingResult.getHeadmap();
                Map<kd.fi.cal.business.process.inner.Field, kd.fi.cal.business.process.inner.Field> entryMapping = fieldMappingResult.getEntrymap();
                int billCollSize = bizBillColl.size();
                IDGenerator inIdGenerator = new IDGenerator("t_cal_incalbill", billCollSize);
                IDGenerator outIdGenerator = new IDGenerator("t_cal_outcalbill", billCollSize);
                for (DynamicObject billentry : bizBillColl) {
                    DynamicObject calBill;
                    Long ownerid = billentry.getLong(ownerkey);
                    boolean isPurRecBill = "im_purreceivebill".equals(this.bizbillentityname);
                    if (isPurRecBill && calorgField != null && StringUtils.isNotEmpty((String)calorgField.getTotalkey()) && billentry.getLong(calorgField.getTotalkey()) != 0L) {
                        ownerid = billentry.getLong(calorgField.getTotalkey());
                    }
                    if ((calBill = (DynamicObject)ownerMapCalBill.get(billId + "," + ownerid)) == null) {
                        long id = 0L;
                        calBill = BusinessDataServiceHelper.newDynamicObject((String)calBillNumber);
                        id = "cal_outcalbill".equals(calBillNumber) ? outIdGenerator.getId().longValue() : inIdGenerator.getId().longValue();
                        calBill.set("id", (Object)id);
                        for (Map.Entry<kd.fi.cal.business.process.inner.Field, kd.fi.cal.business.process.inner.Field> mapEntry : headMapping.entrySet()) {
                            calBill.set(mapEntry.getKey().getProperty(), billentry.get(mapEntry.getValue().getTotalkey()));
                        }
                        for (Map.Entry<kd.fi.cal.business.process.inner.Field, kd.fi.cal.business.process.inner.Field> mapEntry : headMapping.entrySet()) {
                            calBill.set(mapEntry.getKey().getProperty(), billentry.get(mapEntry.getValue().getTotalkey()));
                        }
                        calBill.set("bizbillid", billentry.get("id"));
                        calBill.set("bizentityobject", (Object)this.bizEntityObject);
                        calBill.set("billstatus", (Object)"B");
                        ownerMapCalBill.put(billId + "," + ownerid, calBill);
                    }
                    DynamicObjectCollection entryCol = calBill.getDynamicObjectCollection(calBillEntryKey);
                    DynamicObject costBillEntry = entryCol.addNew();
                    costBillEntry.set("seq", (Object)entryCol.size());
                    for (Map.Entry<kd.fi.cal.business.process.inner.Field, kd.fi.cal.business.process.inner.Field> entryMap : entryMapping.entrySet()) {
                        costBillEntry.set(entryMap.getKey().getProperty(), billentry.get(entryMap.getValue().getTotalkey()));
                    }
                    if (StringUtils.isEmpty((String)bizEntryKeyStr)) {
                        costBillEntry.set("bizbillentryid", billentry.get(this.bizbillentrykey + ".id"));
                    } else {
                        costBillEntry.set("bizbillentryid", billentry.get(bizEntryKeyStr));
                    }
                    this.exFieldMap.put(calBill.getLong("id"), exFieldSet);
                }
            }
        }
        for (Map.Entry entry : calBillMap.entrySet()) {
            Map map = (Map)entry.getValue();
            Map billIdErrMap = new MulCalBillSyncRuleHelper().removeMulRuleCalBill(mulRuleBillIds, map);
            for (Long l : billIdErrMap.keySet()) {
                unValidIdMap.remove(l);
            }
            this.errMap.putAll(billIdErrMap);
            for (Map.Entry entry2 : map.entrySet()) {
                String key = (String)entry2.getKey();
                long billId = Long.parseLong(key.split(",")[0]);
                unValidIdMap.remove(billId);
                ArrayList billList = (ArrayList)costBillMap.get(key);
                if (billList == null) {
                    billList = new ArrayList(16);
                    costBillMap.put(key, billList);
                }
                billList.add(entry2.getValue());
            }
        }
        logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u4fdd\u5b58\u6838\u7b97\u5355\uff1a" + System.currentTimeMillis());
        if (!unValidIdMap.isEmpty()) {
            for (Map.Entry entry : unValidIdMap.entrySet()) {
                this.errMap.put((Long)entry.getKey(), new SynBillErrInfo("5", (String)entry.getValue()));
                idSet.remove(entry.getKey());
            }
        }
        logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u521b\u5efa\u6838\u7b97\u5355createCalBill\uff1a" + (currtime - System.currentTimeMillis()));
        return costBillMap;
    }

    protected void init(DynamicObject bizBill) {
        Long currtime = System.currentTimeMillis();
        logger.info("SyncBizBill4AuditServiceProcess-\u8fdb\u5165\u63d2\u4ef6-" + bizBill.getString("billno") + ":" + System.currentTimeMillis());
        this.bizbillentityname = bizBill.getDataEntityType().getName();
        this.bizbillentitytype = EntityMetadataCache.getDataEntityType((String)this.bizbillentityname);
        this.rules = this.getCalBillRules();
        this.bizbillentrykey = this.getEntryKey(this.bizbillentityname);
        this.calbilltypemap = new HashMap<String, CalBillInfo>();
        this.bizEntityObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)this.bizbillentityname).toArray());
        logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u521d\u59cb\u5316\u65b9\u6cd5init\uff1a" + (currtime - System.currentTimeMillis()));
    }

    private CalBillInfo getCalBillInfo(String calBillNo) {
        CalBillInfo info = this.calbilltypemap.get(calBillNo);
        if (info == null) {
            info = new CalBillInfo(calBillNo);
            this.calbilltypemap.put(calBillNo, info);
        }
        return info;
    }

    private String getBizBillSelector(Collection<kd.fi.cal.business.process.inner.Field> bizFields) {
        StringBuilder bizSelectorsSb = new StringBuilder();
        for (kd.fi.cal.business.process.inner.Field bizField : bizFields) {
            bizSelectorsSb.append(bizField.getTotalkey()).append(',');
        }
        bizSelectorsSb.setLength(bizSelectorsSb.length() - 1);
        String fields = bizSelectorsSb.toString();
        if (!fields.contains(this.bizbillentrykey + ".id")) {
            fields = this.bizbillentrykey + ".id," + fields;
        }
        if (!"im_initbill".equals(this.bizbillentityname)) {
            fields = "id," + fields;
        }
        return fields;
    }

    private FieldMappingResult getFieldMapping(DynamicObject rule, String calBillNumber) {
        FieldMappingResult result = new FieldMappingResult();
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            String bizFieldName = ruleEntry.getString("sourcefield");
            if (StringUtils.isEmpty((String)bizFieldName)) continue;
            String calFieldName = ruleEntry.getString("calfield");
            CalBillInfo calBillInfo = this.getCalBillInfo(calBillNumber);
            IDataEntityProperty calEntity = calBillInfo.getType().findProperty(calFieldName);
            IDataEntityProperty bizEntity = this.bizbillentitytype.findProperty(bizFieldName.split("\\.")[0]);
            if (calEntity == null || bizEntity == null) continue;
            IDataEntityType parentyCalEntity = calEntity.getParent();
            IDataEntityType parentBizEntity = bizEntity.getParent();
            if (parentyCalEntity instanceof LinkEntryType || parentBizEntity instanceof LinkEntryType) continue;
            kd.fi.cal.business.process.inner.Field bizField = null;
            kd.fi.cal.business.process.inner.Field calField = parentyCalEntity instanceof EntryType ? new kd.fi.cal.business.process.inner.Field(calFieldName, true, calBillInfo.getEntrykey(), calEntity) : new kd.fi.cal.business.process.inner.Field(calFieldName, false, null, calEntity);
            bizField = parentBizEntity instanceof SubEntryType ? new kd.fi.cal.business.process.inner.Field(bizFieldName, true, this.bizbillentrykey + "." + parentBizEntity.getName(), bizEntity) : (parentBizEntity instanceof EntryType ? new kd.fi.cal.business.process.inner.Field(bizFieldName, true, this.bizbillentrykey, bizEntity) : new kd.fi.cal.business.process.inner.Field(bizFieldName, false, null, bizEntity));
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".owner")) {
                result.setOwnerField(bizField);
            }
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".companyorg")) {
                result.setCalOrgField(bizField);
            }
            result.addMapping(calField, bizField);
        }
        if (!result.hasOwnerField()) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u6620\u5c04\u89c4\u5219\u6ca1\u6709\u914d\u7f6e\u8d27\u4e3b\u5b57\u6bb5\u3002", (String)"SyncBizBill4AuditServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0]), calBillNumber);
            throw new KDBizException(msg);
        }
        return result;
    }

    protected Map<Long, DynamicObjectCollection> getValidEntrys(DynamicObject rule, Object bizBillID, String selectors, String bizEntryKey) {
        logger.info("SyncBizBill4AuditServiceProcess-\u5f00\u59cb\u8fc7\u6ee4\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\uff1a" + System.currentTimeMillis());
        String filter = rule.getString("filter_tag");
        QFilter[] qs = null;
        if (StringUtils.isNotEmpty((String)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(this.bizbillentitytype, filterCondition);
            filterBuilder.buildFilter();
            QFilter qf = new QFilter("id", "in", bizBillID);
            QFilter ruleFilter = filterBuilder.getQFilter();
            this.skipStatusFilter(ruleFilter);
            qs = qf.and(ruleFilter).toArray();
        } else {
            qs = new QFilter[]{new QFilter("id", "in", bizBillID)};
        }
        DynamicObjectCollection bizBillColl = QueryServiceHelper.query((String)this.bizbillentityname, (String)selectors, (QFilter[])qs);
        HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
        for (DynamicObject info : bizBillColl) {
            long id = info.getLong("id");
            DynamicObjectCollection coll = (DynamicObjectCollection)map.get(id);
            if (coll != null) {
                boolean isExist = false;
                for (DynamicObject dy : coll) {
                    long entryId = dy.getLong(bizEntryKey);
                    if (entryId != info.getLong(bizEntryKey)) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                coll.add((Object)info);
                continue;
            }
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            map.put(id, coll);
        }
        logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u8fc7\u6ee4\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\uff1a" + System.currentTimeMillis());
        return map;
    }

    private String getEntryKey(String entityname) {
        return SynBizBillHelper.getFirstEntryKeyByMatField((String)entityname, this.rules);
    }

    private Collection<DynamicObject> getCalBillRules() {
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)this.bizbillentityname);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)CALRULEFIELDS, (QFilter[])filter.toArray());
        HashSet<DynamicObject> billRuleSet = new HashSet<DynamicObject>(billRules.length);
        for (DynamicObject rull : billRules) {
            if (rull == null) continue;
            billRuleSet.add(rull);
        }
        return billRuleSet;
    }

    private DynamicObjectCollection getAllCostAccount(long ownerId) {
        DynamicObjectCollection accountcoll = this.costAccountMap.get(ownerId);
        if (accountcoll == null) {
            DynamicObjectCollection coll = AccountingSysHelper.getAccountingSysCollsByOwner((Long)ownerId, null);
            QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            for (DynamicObject info : coll) {
                long calSystemId = info.getLong("id");
                long calOrgId = info.getLong("calorgid");
                QFilter q1 = new QFilter("calsystem", "=", (Object)calSystemId);
                q1.and("calorg", "=", (Object)calOrgId);
                q.or(q1);
            }
            q.and("status", "=", (Object)"C");
            q.and("enable", "=", (Object)"1");
            new CalGroupAccountHelper().addNotGroupAcctFilterSelf(q);
            accountcoll = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)COSTACCOUNTFIELDS, (QFilter[])q.toArray());
            this.costAccountMap.put(ownerId, accountcoll);
        }
        return accountcoll;
    }

    @Override
    public void doProcessor(Map params, DynamicObject bill) {
        super.doProcessor(params, bill);
    }

    private static Set<Long> cacheMatVerEffectPriceIds(Set<Long> calDimensionIds) {
        HashSet<Long> matversionEffectPriceCalDimensionIds = new HashSet<Long>(16);
        QFilter calDimensionFilter = new QFilter("id", "in", calDimensionIds);
        calDimensionFilter.and("caldimension", "like", (Object)"%mversion%");
        try (DataSet calDimensionDS = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.process.impl.CheckStdCostProcess.cacheMatVersionEffectPriceCalDimensionIds", (String)"cal_bd_caldimension", (String)"id", (QFilter[])calDimensionFilter.toArray(), null);){
            for (Row row : calDimensionDS) {
                matversionEffectPriceCalDimensionIds.add(row.getLong("id"));
            }
        }
        return matversionEffectPriceCalDimensionIds;
    }

    private static Set<Long> cacheAsstEffectPriceMatIds(Set<Long> materialIds) {
        HashSet<Long> assistEffectPriceMaterialIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("id", "in", materialIds);
        qFilter.and("auxptyentry.isaffectprice", "=", (Object)true);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.process.impl.CheckStdCostProcess.cacheAssistEffectPriceMaterialIds", (String)"bd_material", (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row row : ds) {
                assistEffectPriceMaterialIds.add(row.getLong("id"));
            }
        }
        return assistEffectPriceMaterialIds;
    }

    private static void cacheInvSchemeAndInvTypeInfos(Set<Long> isCalInvSchemeIds, Set<Long> isCalInvTypeIds) {
        QFilter invSchemeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id", (QFilter[])invSchemeFilter.toArray());
        for (DynamicObject dynamicObject : invSchemes) {
            isCalInvSchemeIds.add(dynamicObject.getLong("id"));
        }
        QFilter invTypeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invTypes = QueryServiceHelper.query((String)"bd_invtype", (String)"id", (QFilter[])invTypeFilter.toArray());
        for (DynamicObject dynamicObject : invTypes) {
            isCalInvTypeIds.add(dynamicObject.getLong("id"));
        }
    }

    public static Date getStandardCostDate(Date auditdate, Date bookdate) {
        WriteLogHelper.writeInfoLog((Log)logger, (String)("CheckStdCostProcess-getStandardCostDate auditdate\uff1a" + auditdate), (Object[])new Object[0]);
        WriteLogHelper.writeInfoLog((Log)logger, (String)("CheckStdCostProcess-getStandardCostDate bookdate1\uff1a" + bookdate), (Object[])new Object[0]);
        if (null == auditdate || null == bookdate) {
            return auditdate;
        }
        if (DateUtils.isTheSameDay((Date)auditdate, (Date)bookdate)) {
            bookdate = DateUtils.getDayStartTime((Date)bookdate);
            int hour = DateUtils.getIntByDate((Date)auditdate, (int)11);
            int minute = DateUtils.getIntByDate((Date)auditdate, (int)12);
            int second = DateUtils.getIntByDate((Date)auditdate, (int)13);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(bookdate);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            bookdate = calendar.getTime();
        } else {
            bookdate = DateUtils.getDayEndTime((Date)bookdate);
        }
        WriteLogHelper.writeInfoLog((Log)logger, (String)("CheckStdCostProcess-getStandardCostDate bookdate2\uff1a" + bookdate), (Object[])new Object[0]);
        return bookdate;
    }

    private void skipStatusFilter(QFilter ruleFilter) {
        String billStatusField = "billstatus";
        if (ruleFilter != null) {
            if (billStatusField.equals(ruleFilter.getProperty())) {
                ruleFilter.__setProperty("1");
                ruleFilter.__setCP("=");
                ruleFilter.__setValue((Object)1);
            }
            List nests = ruleFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                QFilter curFilter = nest.getFilter();
                if (!billStatusField.equals(curFilter.getProperty())) continue;
                curFilter.__setProperty("1");
                curFilter.__setCP("=");
                curFilter.__setValue((Object)1);
            }
        }
    }

    protected String getCostReorcdField(boolean hasCostDetail) {
        String costRecordEntity = "cal_costrecord";
        if (hasCostDetail) {
            costRecordEntity = "cal_costrecord_subentity";
        }
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)costRecordEntity);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        fields.append("costaccount.calpolicy.convertmode,");
        fields.append("entry.seq,");
        fields.append("costaccount.calpolicy.exratetable,");
        fields.append("entry.subentryentity.id,entry.subentryentityest.id");
        return fields.toString();
    }

    private String skipBillStatusFilter(String filter) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        Iterator filterItr = filterCondition.getFilterRow().iterator();
        while (filterItr.hasNext()) {
            SimpleFilterRow row = (SimpleFilterRow)filterItr.next();
            if (!"billstatus".equals(row.getFieldName())) continue;
            filterItr.remove();
        }
        filter = SerializationUtils.toJsonString((Object)filterCondition);
        return filter;
    }

    private static class CostRecordNoGenerator
    implements IBillNoGenerator {
        private String calNo;
        private boolean isSingle;
        private int seq;

        CostRecordNoGenerator(String calNo, boolean isSingle, int seq) {
            this.calNo = calNo;
            this.isSingle = isSingle;
            this.seq = seq;
        }

        @Override
        public String getNumber() {
            String number = null;
            number = this.isSingle ? this.calNo : this.calNo + "-" + this.seq;
            return number;
        }
    }
}

