/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import org.apache.poi.util.StringUtil;

public class CheckVoucherProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(CheckVoucherProcess.class);

    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        logger.info("CheckVoucherProcess-\u8fdb\u5165\u5904\u7406\u5668");
        HashSet<Object> set = new HashSet<Object>(bizBills.length);
        for (DynamicObject info : bizBills) {
            set.add(info.getPkValue());
        }
        QFilter q = new QFilter("bizbillid", "in", set);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,billno,bizbillid", (QFilter[])new QFilter[]{q});
        HashMap<Long, Long> costIdInvIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, DynamicObject> costRecordMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> costrecordIdSets = new HashSet<Long>(16);
        if (coll != null && coll.size() > 0) {
            QFilter filter;
            DynamicObjectCollection daptrackers;
            HashMap<Long, HashSet<String>> map = new HashMap<Long, HashSet<String>>(16);
            for (DynamicObject info : coll) {
                Long costrecordId = info.getLong("id");
                costRecordMap.put(costrecordId, info);
                costrecordIdSets.add(costrecordId);
                costIdInvIdMap.put(costrecordId, info.getLong("bizbillid"));
            }
            if (costrecordIdSets != null && costrecordIdSets.size() > 0 && (daptrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{filter = new QFilter("sourcebillid", "in", costrecordIdSets)})) != null && daptrackers.size() > 0) {
                for (DynamicObject daptracker : daptrackers) {
                    Long sourcebillid = daptracker.getLong("sourcebillid");
                    DynamicObject costRecord = (DynamicObject)costRecordMap.get(sourcebillid);
                    if (costRecord == null) continue;
                    long bizBillId = costRecord.getLong("bizbillid");
                    String billNo = costRecord.getString("billno");
                    HashSet<String> billNos = (HashSet<String>)map.get(bizBillId);
                    if (billNos != null) {
                        billNos.add(billNo);
                        continue;
                    }
                    billNos = new HashSet<String>(16);
                    billNos.add(billNo);
                    map.put(bizBillId, billNos);
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                long bizBillId = (Long)entry.getKey();
                String billnos = StringUtil.join((Object[])((Set)entry.getValue()).toArray(), (String)",");
                String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff1a%1$s", (String)"CheckVoucherProcess_0", (String)"fi-cal-business", (Object[])new Object[0]), billnos);
                this.addErrorMsg(bizBillId, "3", msg);
            }
        }
        this.checkAdjBill(costIdInvIdMap);
    }

    private void checkAdjBill(Map<Long, Long> costIdInvIdMap) {
        if (costIdInvIdMap != null && costIdInvIdMap.size() > 0) {
            logger.info("CheckVoucherProcess-costIdInvIdMap\uff1a" + costIdInvIdMap.keySet());
            QFilter adjustFilter = new QFilter("entryentity.invbillid", "in", costIdInvIdMap.keySet());
            DynamicObjectCollection adjustColl = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"id,billno,isvoucher,createtype,difftype,entryentity.invbillid as invbillid", (QFilter[])new QFilter[]{adjustFilter});
            DynamicObjectCollection stdDiffcoll = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id,billno,isvoucher,createtype,entryentity.invbillid as invbillid,entryentity.groupdiffbillid as groupdiffbillid", (QFilter[])new QFilter[]{adjustFilter});
            HashMap<Long, Set<Long>> invBillAndGroupBillMap = new HashMap<Long, Set<Long>>(16);
            HashSet<Long> allGroupBillSet = new HashSet<Long>(16);
            for (DynamicObject stdDiffBill : stdDiffcoll) {
                Long groupDiffBillId = stdDiffBill.getLong("groupdiffbillid");
                Long invbillid = stdDiffBill.getLong("invbillid");
                if (Long.compare(groupDiffBillId, 0L) == 0) continue;
                HashSet<Long> groupBillSet = (HashSet<Long>)invBillAndGroupBillMap.get(invbillid);
                if (groupBillSet == null) {
                    groupBillSet = new HashSet<Long>(16);
                }
                groupBillSet.add(groupDiffBillId);
                invBillAndGroupBillMap.put(invbillid, groupBillSet);
                allGroupBillSet.add(groupDiffBillId);
            }
            String diffGroupBillMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684%1$s\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5408\u5e76\u5355\u201c%2$s\u201d,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CheckVoucherProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
            String stdDiffBillMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u201c%1$s\u201d\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CheckVoucherProcess_2", (String)"fi-cal-business", (Object[])new Object[0]);
            String adjustBillMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u201c%1$s\u201d\u7684\u6210\u672c\u8c03\u6574\u5355\u201c%2$s\u201d,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SyncBizBill4UnAuditServiceProcess_10", (String)"fi-cal-business", (Object[])new Object[0]);
            if (!allGroupBillSet.isEmpty()) {
                DynamicObjectCollection groupBillColl = QueryServiceHelper.query((String)"cal_costdiffgroupbill", (String)"id,billno,isvoucher,createtype", (QFilter[])new QFilter[]{new QFilter("id", "in", allGroupBillSet)});
                this.addNoVoucherMsgByColls(groupBillColl, costIdInvIdMap, invBillAndGroupBillMap, diffGroupBillMsg);
            }
            this.addNoVoucherMsgByColls(adjustColl, costIdInvIdMap, null, adjustBillMsg);
            this.addNoVoucherMsgByColls(stdDiffcoll, costIdInvIdMap, null, stdDiffBillMsg);
        }
    }

    private void addNoVoucherMsgByColls(DynamicObjectCollection coll, Map<Long, Long> costIdInvIdMap, Map<Long, Set<Long>> invBillAndGroupBillMap, String errorMsg) {
        QFilter costadjustfilter;
        DynamicObjectCollection costadjustdaptrackers;
        HashMap<Long, DynamicObject> costadjustbillMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> costadjustbillidSets = new HashSet<Long>(16);
        for (DynamicObject info : coll) {
            Long costadjustbillId = info.getLong("id");
            costadjustbillMap.put(costadjustbillId, info);
            costadjustbillidSets.add(costadjustbillId);
        }
        if (costadjustbillidSets != null && costadjustbillidSets.size() > 0 && (costadjustdaptrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{costadjustfilter = new QFilter("sourcebillid", "in", costadjustbillidSets)})) != null && costadjustdaptrackers.size() > 0) {
            for (DynamicObject costadjustdaptracker : costadjustdaptrackers) {
                Long sourcebillid = costadjustdaptracker.getLong("sourcebillid");
                DynamicObject row = (DynamicObject)costadjustbillMap.get(sourcebillid);
                if (row == null) continue;
                String createType = row.getString("createtype");
                String typeName = CostAdjustBilCreateTypeEnum.getEnumDesc((String)createType);
                String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u201c%1$s\u201d\u7684\u6210\u672c\u8c03\u6574\u5355\u201c%2$s\u201d,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SyncBizBill4UnAuditServiceProcess_10", (String)"fi-cal-business", (Object[])new Object[0]), typeName, row.getString("billno"));
                long invBillid = 0L;
                if (invBillAndGroupBillMap != null) {
                    for (Map.Entry<Long, Set<Long>> entry : invBillAndGroupBillMap.entrySet()) {
                        Set<Long> groupBillSet = entry.getValue();
                        if (!entry.getValue().contains(sourcebillid)) continue;
                        invBillid = entry.getKey();
                        break;
                    }
                } else {
                    invBillid = row.getLong("invbillid");
                }
                long invId = costIdInvIdMap.get(invBillid);
                this.addErrorMsg(invId, "3", msg);
            }
        }
    }
}

