/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.sharemodel.AutoCostEstimateHandler;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class CostEstimateBillCreateProcess
extends AbstractBizProcessor {
    @Override
    public void doProcessor(Map params, DynamicObject bizBill) {
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.NEW_FEESHARE).booleanValue()) {
            return;
        }
        Long sourceBillId = bizBill.getLong("id");
        String sourceBillType = bizBill.getDataEntityType().getName();
        String entryKey = (String)params.get("entrykey");
        String botpRuleId = (String)params.get("boptruleid");
        Long targetBillId = this.getTargetBillID(sourceBillId, sourceBillType, entryKey);
        if (targetBillId != null) {
            DynamicObject targetBill = QueryServiceHelper.queryOne((String)"cal_costestimatebill", (String)"id,billno", (QFilter[])new QFilter("id", "=", (Object)targetBillId).toArray());
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\u8fc7\u8d39\u7528\u6682\u4f30\u5355,\u5355\u636e\u7f16\u53f7\uff1a%1$s", (String)"CostEstimateBillCreateProcess_0", (String)"fi-cal-business", (Object[])new Object[0]), targetBill.getString("billno"));
            throw new KDBizException(msg);
        }
        PushArgs botp = new PushArgs();
        botp.setSourceEntityNumber(sourceBillType);
        botp.setTargetEntityNumber("cal_costestimatebill");
        ArrayList<ListSelectedRow> rowList = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue((Object)sourceBillId);
        row.setEntryEntityKey(entryKey);
        rowList.add(row);
        botp.setSelectedRows(rowList);
        botp.setRuleId(botpRuleId);
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)botp);
        if (!convertResult.isSuccess()) {
            String msg = String.format(ResManager.loadKDString((String)"botp\u63a8\u5355\u5931\u8d25\uff1a%1$s", (String)"CostEstimateBillCreateProcess_1", (String)"fi-cal-business", (Object[])new Object[0]), convertResult.getMessage());
            throw new KDBizException(msg);
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"cal_costestimatebill");
        List targetBills = convertResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] paramArrayOfObject, IDataEntityType paramIDataEntityType) {
                BusinessDataServiceHelper.loadRefence((Object[])paramArrayOfObject, (IDataEntityType)paramIDataEntityType);
            }
        }, mainType);
        for (DynamicObject targetBill : targetBills) {
            if (targetBill.getDynamicObjectCollection("expenseentity").isEmpty()) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7b26\u5408botp\u6761\u4ef6\u7684\u5206\u5f55%1$s", (String)"CostEstimateBillCreateProcess_2", (String)"fi-cal-business", (Object[])new Object[0]), convertResult.getMessage());
                throw new KDBizException(msg);
            }
            Object id = null;
            try (TXHandle tx = TX.requiresNew();){
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"cal_costestimatebill", (DynamicObject[])new DynamicObject[]{targetBill}, null);
                if (!opResult.isSuccess()) {
                    StringBuilder errorInfo = new StringBuilder();
                    for (IOperateInfo info : opResult.getAllErrorOrValidateInfo()) {
                        errorInfo.append(info.getMessage());
                    }
                    errorInfo.append(opResult.getMessage());
                    throw new KDBizException(errorInfo.toString());
                }
                id = opResult.getSuccessPkIds().get(0);
            }
            try {
                targetBill = BusinessDataServiceHelper.loadSingle(id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costestimatebill"));
                AutoCostEstimateHandler autoEstHandler = new AutoCostEstimateHandler(bizBill, targetBill);
                autoEstHandler.handle();
            }
            catch (Exception e) {
                try (TXHandle tx = TX.requiresNew();){
                    OperationServiceHelper.executeOperate((String)"delete", (String)"cal_costestimatebill", (Object[])new Object[]{id}, null);
                }
                if (e instanceof KDBizException) {
                    throw e;
                }
                throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    private Long getTargetBillID(Long sourceBillId, String sourceBillType, String entryKey) {
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillType);
        DynamicObjectCollection sourceEntryCol = sourceBill.getDynamicObjectCollection(entryKey);
        if (sourceEntryCol == null || sourceEntryCol.isEmpty()) {
            return null;
        }
        HashSet<Long> sourceEntryIdSet = new HashSet<Long>();
        for (DynamicObject sourceEntry : sourceEntryCol) {
            sourceEntryIdSet.add(sourceEntry.getLong("id"));
        }
        List targetRows = BFTrackerServiceHelper.loadTargetRowIds((String)sourceBillType, (String)entryKey, (Long[])sourceEntryIdSet.toArray(new Long[sourceEntryIdSet.size()]));
        if (targetRows == null || targetRows.isEmpty()) {
            return null;
        }
        Long tableId = ConvertMetaServiceHelper.loadTableDefine((String)"cal_costestimatebill", (String)"expenseentity").getTableId();
        for (BFRow row : targetRows) {
            if (!row.getId().getTableId().equals(tableId)) continue;
            return row.getId().getBillId();
        }
        return null;
    }
}

