/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;

public class CostEstimateBillDeleteProcess
extends AbstractBizProcessor {
    @Override
    public void doProcessor(Map params, DynamicObject bizBill) {
        String entryKey;
        String sourceBillType;
        Long sourceBillId = bizBill.getLong("id");
        Long targetBillId = this.getTargetBillID(sourceBillId, sourceBillType = bizBill.getDataEntityType().getName(), entryKey = (String)params.get("entrykey"));
        if (targetBillId == null) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)"cal_costestimatebill", (Object[])new Object[]{targetBillId}, (OperateOption)option);
        if (!opResult.isSuccess()) {
            StringBuilder errorInfo = new StringBuilder();
            for (IOperateInfo info : opResult.getAllErrorOrValidateInfo()) {
                errorInfo.append(info.getMessage());
            }
            throw new KDBizException(errorInfo.toString());
        }
    }

    private Long getTargetBillID(Long sourceBillId, String sourceBillType, String entryKey) {
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillType);
        DynamicObjectCollection sourceEntryCol = sourceBill.getDynamicObjectCollection(entryKey);
        if (sourceEntryCol == null || sourceEntryCol.isEmpty()) {
            return null;
        }
        HashSet<Long> sourceEntryIdSet = new HashSet<Long>();
        for (DynamicObject sourceEntry : sourceEntryCol) {
            sourceEntryIdSet.add(sourceEntry.getLong("id"));
        }
        List targetRows = BFTrackerServiceHelper.loadTargetRowIds((String)sourceBillType, (String)entryKey, (Long[])sourceEntryIdSet.toArray(new Long[sourceEntryIdSet.size()]));
        if (targetRows == null || targetRows.isEmpty()) {
            return null;
        }
        Long tableId = ConvertMetaServiceHelper.loadTableDefine((String)"cal_costestimatebill", (String)"expenseentity").getTableId();
        for (BFRow row : targetRows) {
            if (!row.getId().getTableId().equals(tableId)) continue;
            return row.getId().getBillId();
        }
        return null;
    }
}

