/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.business.calculate.billgroup.BillGroupRelationHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.plugin.IBizPlugin;

public class CreateBillGroupRecordProcess
extends AbstractBizProcessor {
    @Override
    public void doProcessor(Map params, DynamicObject[] invBills) {
        if (AcctGroupModelHelper.isBizGroupModel()) {
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>(invBills.length);
        for (DynamicObject info : invBills) {
            idSet.add(info.getLong("id"));
        }
        if (idSet.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("bizbillid", "in", idSet);
        new BillGroupRelationHelper().createRelations(filter);
    }

    public static IBizPlugin getProcessByName(String className) {
        try {
            Class<?> process = Class.forName(className);
            return (IBizPlugin)process.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new KDException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new KDException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new KDException(e.getMessage());
        }
    }

    public void test() {
        DynamicObject billinfo = BusinessDataServiceHelper.loadSingle((Object)"640995590100113408", (String)"cal_costadjustbill");
        this.doProcessor(null, billinfo);
    }
}

