/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.builder.CostAccountCache;
import kd.fi.cal.business.builder.CostRecordBuilder;
import kd.fi.cal.business.builder.IBillNoGenerator;
import kd.fi.cal.business.calculate.billgroup.BillGroupRelationHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.CalBillInfo;
import kd.fi.cal.business.process.inner.CostRecordCostHandle;
import kd.fi.cal.business.process.inner.Field;
import kd.fi.cal.business.process.inner.FieldMappingResult;
import kd.fi.cal.business.process.inner.FilterInfoChecker;
import kd.fi.cal.business.process.inner.QueueTypeHelper;
import kd.fi.cal.business.process.inner.SyncOpLegalChecker;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.AccountTypeHelperNew;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostPriceSourceTypeHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.MaterialCategoryHandle;
import kd.fi.cal.common.helper.MulCalBillSyncRuleHelper;
import kd.fi.cal.common.helper.StopSyncBizBillHelper;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.CommonUtils;

public class CreateCostRecordProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(CreateCostRecordProcess.class);
    private static final String CALRULEFIELDS = "id,number,calbill.id,calbill.number,fieldmap.calfield,fieldmap.sourcefield,fieldmap.isorgfield,fieldmap.orgtype,filter,filter_tag,fieldmap.isextendfield,errortip";
    private static final String COSTACCOUNTFIELDS = "id,name,number,calpolicy,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.currency.priceprecision,dividebasis,calpolicy.currency.number,calpolicy.currency.name,calpolicy.convertmode,calpolicy.exratetable,calpolicy.calbycostelement,calpolicy.supporttaxamt,calorg,calorg.name,calorg.number";
    private Map<Long, DynamicObjectCollection> costAccountMap = new HashMap<Long, DynamicObjectCollection>(32);
    private Set<Long> isCalInvSchemeIds = new HashSet<Long>(16);
    private Set<Long> isCalInvTypeIds = new HashSet<Long>(16);
    private Map<String, CalBillInfo> calbilltypemap;
    private MainEntityType bizbillentitytype;
    private String bizbillentityname;
    private String bizbillentrykey;
    private DynamicObject bizEntityObject;
    private Map<Long, Set<String>> exFieldMap = new HashMap<Long, Set<String>>(32);
    private Map<Long, SynBillErrInfo> errMap = new HashMap<Long, SynBillErrInfo>(32);
    private Set<Long> cantDelSet = new HashSet<Long>(16);
    private boolean isBizGroupModel = AcctGroupModelHelper.isBizGroupModel();
    private Collection<DynamicObject> rules = new HashSet<DynamicObject>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        block41: {
            Map<Long, Set<DynamicObject>> costRecordMap;
            block39: {
                block40: {
                    Map<String, List<DynamicObject>> calBillMap;
                    block37: {
                        block38: {
                            block35: {
                                block36: {
                                    block33: {
                                        block34: {
                                            if (bizBills != null && bizBills.length >= 1) break block33;
                                            if (this.errMap.isEmpty()) break block34;
                                            for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                                                this.addErrorMsg(entry.getKey(), entry.getValue());
                                            }
                                            Set<Long> idSet = this.errMap.keySet();
                                            idSet.removeAll(this.cantDelSet);
                                            if (!idSet.isEmpty()) {
                                                QFilter qFilter = new QFilter("bizbillid", "in", idSet);
                                                QFilter costRecordF = qFilter.copy();
                                                new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecordF);
                                                QFilter q2 = new QFilter("billstatus", "in", Arrays.asList("A", "B"));
                                                DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter[]{costRecordF, q2});
                                                logger.info("CreateCostRecordProcess-\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5220\u9664\uff1a");
                                                if (this.isBizGroupModel) {
                                                    DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])new QFilter[]{qFilter});
                                                } else {
                                                    DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])new QFilter[]{qFilter, q2});
                                                    DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])new QFilter[]{qFilter, q2});
                                                }
                                                logger.info("CreateCostRecordProcess-\u6838\u7b97\u5355\u5220\u9664\uff1a");
                                            }
                                        }
                                        return;
                                    }
                                    DynamicObject bizBill = bizBills[0];
                                    if (bizBill == null) {
                                        throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86\u3002", (String)"SyncBizBill4AuditServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]));
                                    }
                                    this.init(bizBill);
                                    if (!"im_initbill".equals(this.bizbillentityname)) break block35;
                                    if (this.errMap.isEmpty()) break block36;
                                    for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                                        this.addErrorMsg(entry.getKey(), entry.getValue());
                                    }
                                    Set<Long> set = this.errMap.keySet();
                                    set.removeAll(this.cantDelSet);
                                    if (!set.isEmpty()) {
                                        QFilter q1 = new QFilter("bizbillid", "in", set);
                                        QFilter costRecordF = q1.copy();
                                        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecordF);
                                        QFilter q2 = new QFilter("billstatus", "in", Arrays.asList("A", "B"));
                                        DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter[]{costRecordF, q2});
                                        logger.info("CreateCostRecordProcess-\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5220\u9664\uff1a");
                                        if (this.isBizGroupModel) {
                                            DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])new QFilter[]{q1});
                                        } else {
                                            DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])new QFilter[]{q1, q2});
                                            DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])new QFilter[]{q1, q2});
                                        }
                                        logger.info("CreateCostRecordProcess-\u6838\u7b97\u5355\u5220\u9664\uff1a");
                                    }
                                }
                                return;
                            }
                            SyncOpLegalChecker syncOpLegalChecker = new SyncOpLegalChecker(bizBills, ActionEnum.SUBMIT.getValue());
                            syncOpLegalChecker.doCheck();
                            this.errMap.putAll(syncOpLegalChecker.getErrMap());
                            this.cantDelSet.addAll(syncOpLegalChecker.getErrMap().keySet());
                            bizBills = syncOpLegalChecker.getSuccessOpBizBillDycs().values().toArray(new DynamicObject[0]);
                            this.reSycnCalRecord(syncOpLegalChecker.getSucessBizBillIdDBCostRecordMap(), syncOpLegalChecker.getSucessDbBizBillIdDycsMap().values());
                            calBillMap = this.createCalBill(bizBills);
                            if (!calBillMap.isEmpty()) break block37;
                            if (this.errMap.isEmpty()) break block38;
                            for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                                this.addErrorMsg(entry.getKey(), entry.getValue());
                            }
                            Set<Long> idSet = this.errMap.keySet();
                            idSet.removeAll(this.cantDelSet);
                            if (!idSet.isEmpty()) {
                                QFilter q1 = new QFilter("bizbillid", "in", idSet);
                                QFilter costRecordF = q1.copy();
                                new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecordF);
                                QFilter q2 = new QFilter("billstatus", "in", Arrays.asList("A", "B"));
                                DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter[]{costRecordF, q2});
                                logger.info("CreateCostRecordProcess-\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5220\u9664\uff1a");
                                if (this.isBizGroupModel) {
                                    DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])new QFilter[]{q1});
                                } else {
                                    DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])new QFilter[]{q1, q2});
                                    DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])new QFilter[]{q1, q2});
                                }
                                logger.info("CreateCostRecordProcess-\u6838\u7b97\u5355\u5220\u9664\uff1a");
                            }
                        }
                        return;
                    }
                    String type = String.valueOf(params.get("type"));
                    costRecordMap = this.createCostRecord(calBillMap, type);
                    if (!costRecordMap.isEmpty()) break block39;
                    if (this.errMap.isEmpty()) break block40;
                    for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                        this.addErrorMsg(entry.getKey(), entry.getValue());
                    }
                    Set<Long> idSet = this.errMap.keySet();
                    idSet.removeAll(this.cantDelSet);
                    if (!idSet.isEmpty()) {
                        QFilter q1 = new QFilter("bizbillid", "in", idSet);
                        QFilter costRecordF = q1.copy();
                        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecordF);
                        QFilter q2 = new QFilter("billstatus", "in", Arrays.asList("A", "B"));
                        DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter[]{costRecordF, q2});
                        logger.info("CreateCostRecordProcess-\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5220\u9664\uff1a");
                        if (this.isBizGroupModel) {
                            DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])new QFilter[]{q1});
                        } else {
                            DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])new QFilter[]{q1, q2});
                            DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])new QFilter[]{q1, q2});
                        }
                        logger.info("CreateCostRecordProcess-\u6838\u7b97\u5355\u5220\u9664\uff1a");
                    }
                }
                return;
            }
            try {
                Map stopSyncBizBillMap = new StopSyncBizBillHelper().doStopSync(costRecordMap);
                if (stopSyncBizBillMap != null && !stopSyncBizBillMap.isEmpty()) {
                    this.errMap.putAll(stopSyncBizBillMap);
                }
                this.setChargeOffInfo(costRecordMap);
                if (this.errMap.isEmpty()) break block41;
            }
            catch (Throwable throwable) {
                if (!this.errMap.isEmpty()) {
                    for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                        this.addErrorMsg(entry.getKey(), entry.getValue());
                    }
                    Set<Long> idSet = this.errMap.keySet();
                    idSet.removeAll(this.cantDelSet);
                    if (!idSet.isEmpty()) {
                        QFilter q1 = new QFilter("bizbillid", "in", idSet);
                        QFilter costRecordF = q1.copy();
                        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecordF);
                        QFilter q2 = new QFilter("billstatus", "in", Arrays.asList("A", "B"));
                        DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter[]{costRecordF, q2});
                        logger.info("CreateCostRecordProcess-\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5220\u9664\uff1a");
                        if (this.isBizGroupModel) {
                            DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])new QFilter[]{q1});
                        } else {
                            DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])new QFilter[]{q1, q2});
                            DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])new QFilter[]{q1, q2});
                        }
                        logger.info("CreateCostRecordProcess-\u6838\u7b97\u5355\u5220\u9664\uff1a");
                    }
                }
                throw throwable;
            }
            for (Map.Entry entry : this.errMap.entrySet()) {
                this.addErrorMsg((Long)entry.getKey(), (SynBillErrInfo)entry.getValue());
            }
            Set<Long> idSet = this.errMap.keySet();
            idSet.removeAll(this.cantDelSet);
            if (!idSet.isEmpty()) {
                QFilter qFilter = new QFilter("bizbillid", "in", idSet);
                QFilter costRecordF = qFilter.copy();
                new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecordF);
                QFilter q2 = new QFilter("billstatus", "in", Arrays.asList("A", "B"));
                DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter[]{costRecordF, q2});
                logger.info("CreateCostRecordProcess-\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5220\u9664\uff1a");
                if (this.isBizGroupModel) {
                    DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])new QFilter[]{qFilter});
                } else {
                    DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])new QFilter[]{qFilter, q2});
                    DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])new QFilter[]{qFilter, q2});
                }
                logger.info("CreateCostRecordProcess-\u6838\u7b97\u5355\u5220\u9664\uff1a");
            }
        }
    }

    private void reSycnCalRecord(Map<Long, DynamicObject> bizBillIdCostRecordMap, Collection<DynamicObject> dbBizBills) {
        if (bizBillIdCostRecordMap.size() == 0) {
            return;
        }
        HashSet<Long> reLoadIds = new HashSet<Long>(16);
        boolean containsLastupdatetimeField = EntityMetadataCache.getDataEntityType((String)this.bizbillentityname).getProperties().containsKey((Object)"lastupdatetime");
        for (DynamicObject bizInfo : dbBizBills) {
            long time;
            long bizTime;
            long id = bizInfo.getLong("id");
            DynamicObject costRecordDyc = bizBillIdCostRecordMap.get(id);
            if (costRecordDyc == null) continue;
            Date bizBillMdiTime = null;
            Date costMdiTime = null;
            if (containsLastupdatetimeField) {
                bizBillMdiTime = bizInfo.getDate("lastupdatetime");
                costMdiTime = costRecordDyc.getDate("lastupdatetime");
            }
            if ((bizTime = null == costMdiTime ? costRecordDyc.getDate("modifytime").getTime() : costMdiTime.getTime()) >= (time = null == bizBillMdiTime ? bizInfo.getDate("modifytime").getTime() : bizBillMdiTime.getTime()) || !"B".equals(costRecordDyc.getString("billstatus"))) continue;
            reLoadIds.add(id);
        }
        if (reLoadIds.size() == 0) {
            return;
        }
        this.deleteCostRecord(reLoadIds);
    }

    private void deleteCostRecord(Set<Long> reLoadIds) {
        this.removeAllRecord(reLoadIds);
    }

    private void removeAllRecord(Set<Long> reLoadIds) {
        QFilter qs = new QFilter("bizbillid", "in", reLoadIds);
        QFilter costRecordF = qs.copy();
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecordF);
        QFilter[] filter = qs.toArray();
        HashSet<Long> recordIds = new HashSet<Long>(8);
        HashSet<Long> entryIds = new HashSet<Long>(256);
        HashSet<Object> calBillIds = new HashSet<Object>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,billno,calbillid,isinitbill,entry.id,biztype", (QFilter[])costRecordF.toArray(), null);){
            for (Row row : dataSet) {
                recordIds.add(row.getLong("id"));
                entryIds.add(row.getLong("entry.id"));
                calBillIds.add(row.getLong("calbillid"));
            }
        }
        BillGroupRelationHelper billGroupRelationHelper = new BillGroupRelationHelper();
        billGroupRelationHelper.setFilterGroupAcct(true);
        billGroupRelationHelper.getAndRemoveRelations(calBillIds, false);
        DeleteServiceHelper.delete((String)"cal_costrecord", (QFilter[])new QFilter("id", "in", recordIds).toArray());
        ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, recordIds)});
        Object object = null;
        try {
            ctx.set();
            DeleteServiceHelper.delete((String)"cal_costrecord_detail", (QFilter[])new QFilter("entryid", "in", entryIds).toArray());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        if (this.isBizGroupModel) {
            DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])filter);
        } else {
            DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])filter);
            DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])filter);
        }
    }

    private void setChargeOffInfo(Map<Long, Set<DynamicObject>> costRecordMap) {
        MainEntityType bizBillEntity = MetadataServiceHelper.getDataEntityType((String)this.bizbillentityname);
        IDataEntityProperty extFieldProperty = bizBillEntity.findProperty("ischargeoff");
        if (extFieldProperty == null || "".equals(extFieldProperty.getAlias())) {
            return;
        }
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<DynamicObject>> entry : costRecordMap.entrySet()) {
            for (DynamicObject info : entry.getValue()) {
                bizBillIds.add(info.getLong("bizbillid"));
            }
        }
        if (bizBillIds.size() == 0) {
            return;
        }
        String updateInCalBillSql = "update t_cal_incalbill set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ?";
        String updateOutCalBillSql = "update t_cal_outcalbill set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ?";
        String updateCostRecordSql = "update t_cal_calcostrecord set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ? and fissplitcreate = '0'";
        HashSet<Long> chargeOffedIdSet = new HashSet<Long>(16);
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        QFilter chargeOffQ = new QFilter("id", "in", bizBillIds);
        chargeOffQ.and("ischargeoff", "=", (Object)"1");
        try (DataSet chargeOffInfos = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.bizbillentityname, (String)"billentry.srcbillid", (QFilter[])chargeOffQ.toArray(), null);){
            if (chargeOffInfos.isEmpty()) {
                return;
            }
            for (Row row : chargeOffInfos) {
                chargeOffedIdSet.add(row.getLong("billentry.srcbillid"));
            }
        }
        for (Long chargeOffedId : chargeOffedIdSet) {
            updateParams.add(new Object[]{"1", this.bizbillentityname, chargeOffedId});
        }
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateInCalBillSql, updateParams);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateOutCalBillSql, updateParams);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateCostRecordSql, updateParams);
        }
    }

    private Map<Long, Set<DynamicObject>> createCostRecord(Map<String, List<DynamicObject>> calBillMap, String type) {
        long beginTime = System.currentTimeMillis();
        Long currtime = System.currentTimeMillis();
        DynamicObjectCollection costAccounts = null;
        HashMap<Long, Set<DynamicObject>> costRecordMap = new HashMap<Long, Set<DynamicObject>>();
        HashSet<DynamicObject> costRecordAllSet = new HashSet<DynamicObject>(16);
        HashMap<Long, CostAccountCache> costAccountCache = new HashMap<Long, CostAccountCache>();
        HashMap<Long, DynamicObject> ownerMap = new HashMap<Long, DynamicObject>();
        IDGenerator cosRecIdGen = new IDGenerator("t_cal_calcostrecord");
        for (Map.Entry<String, List<DynamicObject>> entry : calBillMap.entrySet()) {
            boolean isSingle;
            HashSet costRecordSet = new HashSet(16);
            String key = entry.getKey();
            long billId = Long.parseLong(key.split(",")[0]);
            Long l = Long.valueOf(key.split(",")[1]);
            costAccounts = this.getAllCostAccount(l);
            if (costAccounts.isEmpty()) {
                DynamicObject owner = (DynamicObject)ownerMap.get(l);
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)l, (String)"bos_org", (String)"id,number,name");
                }
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)l, (String)"bd_supplier", (String)"id,number,name");
                }
                if (owner == null) {
                    owner = BusinessDataServiceHelper.loadSingleFromCache((Object)l, (String)"bd_customer", (String)"id,number,name");
                }
                if (owner != null) {
                    ownerMap.put(l, owner);
                }
                String msg = String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u201c%1$s\u201d\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"SyncBizBill4AuditServiceProcess_27", (String)"fi-cal-business", (Object[])new Object[0]), owner == null ? "" : owner.getString("number") + "\uff08" + owner.getString("name") + "\uff09");
                this.errMap.put(billId, new SynBillErrInfo("3", msg));
                continue;
            }
            int size = costAccounts.size();
            DynamicObject calBill = null;
            if (size <= 0) continue;
            List<DynamicObject> calBillList = entry.getValue();
            int listSize = calBillList.size();
            boolean bl = isSingle = listSize == 1;
            if (listSize > 1) {
                Collections.sort(calBillList, new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        if ("cal_outcalbill".equals(o1.getDataEntityType().getName())) {
                            return -1;
                        }
                        if ("cal_incalbill".equals(o1.getDataEntityType().getName())) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            boolean isErr = false;
            currtime = System.currentTimeMillis();
            for (int i = 0; i < listSize; ++i) {
                calBill = calBillList.get(i);
                String calNo = calBill.getString("billNo");
                for (DynamicObject costAccount : costAccounts) {
                    CostRecordNoGenerator generator = new CostRecordNoGenerator(calNo, isSingle, i + 1);
                    Set<String> exFieldSet = this.exFieldMap.get(calBill.getLong("id"));
                    try {
                        CostRecordBuilder builder = new CostRecordBuilder(calBill, costAccount, exFieldSet, costAccountCache);
                        DynamicObject record = builder.createCostRecord(generator, costAccountCache);
                        record.set("id", (Object)cosRecIdGen.getId());
                        costRecordSet.add(record);
                    }
                    catch (KDBizException e) {
                        logger.info("CreateCostRecordProcess-\u5f02\u5e38", (Object)e);
                        this.errMap.put(billId, new SynBillErrInfo("3", e.getMessage()));
                        isErr = true;
                        break;
                    }
                    catch (Exception e) {
                        logger.error("CreateCostRecordProcess-\u5f02\u5e38", (Throwable)e);
                        this.errMap.put(billId, new SynBillErrInfo("4", e.getMessage()));
                        isErr = true;
                        break;
                    }
                }
                if (isErr) break;
            }
            logger.info("CreateCostRecordProcess-\u6210\u672c\u8d26\u7c3f:\u6784\u9020\u6210\u672c\u8bb0\u5f55\uff1a" + (currtime - System.currentTimeMillis()));
            currtime = System.currentTimeMillis();
            if (isErr) continue;
            HashSet set = (HashSet)costRecordMap.get(billId);
            if (set == null) {
                set = new HashSet(16);
                costRecordMap.put(billId, set);
            }
            set.addAll(costRecordSet);
        }
        Iterator<Object> iterator = this.errMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            costRecordMap.remove(l);
        }
        if (costRecordMap.isEmpty()) {
            return costRecordMap;
        }
        for (Map.Entry entry : costRecordMap.entrySet()) {
            for (DynamicObject info : (Set)entry.getValue()) {
                costRecordAllSet.add(info);
            }
        }
        this.cacheInvSchemeAndInvTypeInfos();
        logger.info("CreateCostRecordProcess-\u7f13\u5b58\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u7684\u5e93\u5b58\u4e8b\u52a1\u548c\u5e93\u5b58\u7c7b\u578b\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        DynamicObject[] infos = costRecordAllSet.toArray(new DynamicObject[costRecordAllSet.size()]);
        logger.info("CreateCostRecordProcess-\u5904\u7406\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5206\u5f55\u7684\u5b58\u8d27\u7c7b\u522b\uff1a" + System.currentTimeMillis());
        MaterialCategoryHandle.handle4Bill((DynamicObject[])infos);
        boolean bl = CommonSettingHelper.getSettingObj().getBoolean("isvalstocktype");
        logger.info("CreateCostRecordProcess-\u5f00\u59cb\u5904\u7406\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5206\u5f55\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e0e\u6838\u7b97\u8303\u56f4\uff1a" + System.currentTimeMillis());
        new AccountTypeHelperNew(infos).handleCalRangeAccountType();
        logger.info("CreateCostRecordProcess-\u4e0d\u66f4\u65b0\u6838\u7b97\u4f59\u989d\u7684\u4e1a\u52a1\u7c7b\u578bid\u96c6\u5408\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        HashMap<Long, Object[]> orgIdNumNameMap = new HashMap<Long, Object[]>(16);
        HashMap<Long, Object[]> matIdMatNumMap = new HashMap<Long, Object[]>(16);
        this.cacheNoStockTypeMatOrgInfo(costRecordMap, bl, orgIdNumNameMap, matIdMatNumMap);
        Iterator it = costRecordMap.entrySet().iterator();
        while (it.hasNext()) {
            String errMsg;
            Map.Entry entry = it.next();
            long l = (Long)entry.getKey();
            Set set = (Set)entry.getValue();
            HashMap<Long, Set<Long>> orgNullStockTypeMats = new HashMap<Long, Set<Long>>(16);
            boolean isErr = false;
            for (DynamicObject info : set) {
                Object costAccountId = info.get("costaccount_id");
                Object calOrgId = info.get("calorg_id");
                DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
                for (DynamicObject entryInfo : coll) {
                    if (entryInfo.get("calrange") == null || Long.parseLong(entryInfo.get("calrange").toString()) == 0L) {
                        DynamicObject costAccountInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount", (String)"id,number,name");
                        String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u6838\u7b97\u8303\u56f4\u3002", (String)"SyncBizBill4AuditServiceProcess_28", (String)"fi-cal-business", (Object[])new Object[0]), costAccountInfo.getString("number") + "\uff08" + costAccountInfo.getString("name") + "\uff09");
                        this.errMap.put(l, new SynBillErrInfo("3", msg));
                        isErr = true;
                        break;
                    }
                    if (!bl || entryInfo.get("stocktype_id") != null && (Long)entryInfo.get("stocktype_id") != 0L) continue;
                    HashSet<Long> mats = (HashSet<Long>)orgNullStockTypeMats.get((Long)calOrgId);
                    if (mats == null) {
                        mats = new HashSet<Long>(16);
                    }
                    mats.add((Long)entryInfo.get("material_id"));
                    orgNullStockTypeMats.put((Long)calOrgId, mats);
                    if (mats.size() <= 5) continue;
                    break;
                }
                if (!isErr) continue;
                break;
            }
            if (isErr) {
                it.remove();
            }
            if (this.errMap.get(l) != null || orgNullStockTypeMats.isEmpty() || StringUtils.isEmpty((String)(errMsg = this.getNullStockTypeErrMsg(orgNullStockTypeMats, orgIdNumNameMap, matIdMatNumMap)))) continue;
            this.errMap.put(l, new SynBillErrInfo("3", errMsg));
            it.remove();
        }
        if (costRecordMap.isEmpty()) {
            return costRecordMap;
        }
        logger.info("CreateCostRecordProcess-\u7ed3\u675f\u5904\u7406\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5206\u5f55\u7684\u8ba1\u4ef7\u65b9\u6cd5\u4e0e\u6838\u7b97\u8303\u56f4\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        costRecordAllSet.clear();
        for (Map.Entry entry : costRecordMap.entrySet()) {
            for (DynamicObject info : (Set)entry.getValue()) {
                costRecordAllSet.add(info);
            }
        }
        infos = costRecordAllSet.toArray(new DynamicObject[costRecordAllSet.size()]);
        logger.info("CreateCostRecordProcess-\u4e0d\u66f4\u65b0\u6838\u7b97\u4f59\u989d\u7684\u4e1a\u52a1\u7c7b\u578bid\u96c6\u5408(\u4ea7\u54c1\u59d4\u5916)\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        if (infos.length < 1) {
            return costRecordMap;
        }
        CostElementHelper.addCostRecElements((DynamicObject[])infos);
        this.updateBeforeCostPriceSource(infos, type);
        CostRecordCostHandle costHandle = new CostRecordCostHandle(infos, type);
        costHandle.setBizBillEntityName(this.bizbillentityname);
        costHandle.setBizBillEntryKey(this.bizbillentrykey);
        costHandle.setSyncPrice(Boolean.TRUE);
        infos = costHandle.handle();
        Map<Long, SynBillErrInfo> map = costHandle.getNoCostTypeErrMap();
        this.errMap.putAll(map);
        this.calProcessContext.putCustomerParams("ifromsubmit", "true");
        this.errMap.putAll(costHandle.getErrMap());
        SaveServiceHelper.save((DynamicObject[])infos);
        logger.info("CreateCostRecordProcess-\u63d2\u5165\u6210\u672c\u7ed3\u8f6c\u660e\u7ec6\u8868\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        logger.info("CreateCostRecordProcess-\u6784\u9020\u8d26\u7c3f\u662f\u5426\u5206\u9879\u7ed3\u8f6c\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        logger.info("CreateCostRecordProcess-\u8bbe\u7f6e\u5b50\u8981\u7d20\uff1a" + (currtime - System.currentTimeMillis()));
        logger.info("CreateCostRecordProcess-\u4fdd\u5b58\u6838\u7b97\u8bb0\u5f55\uff1a" + (currtime - System.currentTimeMillis()));
        currtime = System.currentTimeMillis();
        QueueTypeHelper.assignQueueType4CostRecord(infos);
        logger.info("CreateCostRecordProcess-\u8d4b\u503c\u6210\u672c\u8bb0\u5f55\u5e8f\u5217\u7c7b\u578b\uff1a" + (currtime - System.currentTimeMillis()));
        logger.info("CreateCostRecordProcess-\u7ed3\u675f\u521b\u5efa\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff1a" + (beginTime - System.currentTimeMillis()));
        return costRecordMap;
    }

    private void updateBeforeCostPriceSource(DynamicObject[] infos, String type) {
        for (DynamicObject costRecord : infos) {
            DynamicObjectCollection entrys = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal unitactualcost;
                String costpricesource = entry.getString("costpricesource");
                boolean isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)type, (String)costpricesource);
                if (isUpdateFromExpCalcute || (unitactualcost = entry.getBigDecimal("unitactualcost")) == null || unitactualcost.compareTo(BigDecimal.ZERO) == 0) continue;
                entry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                entry.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
            }
        }
    }

    private void cacheInvSchemeAndInvTypeInfos() {
        QFilter invSchemeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id", (QFilter[])invSchemeFilter.toArray());
        for (DynamicObject dynamicObject : invSchemes) {
            this.isCalInvSchemeIds.add(dynamicObject.getLong("id"));
        }
        QFilter invTypeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invTypes = QueryServiceHelper.query((String)"bd_invtype", (String)"id", (QFilter[])invTypeFilter.toArray());
        for (DynamicObject dynamicObject : invTypes) {
            this.isCalInvTypeIds.add(dynamicObject.getLong("id"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<DynamicObject>> createCalBill(DynamicObject[] bizBills) {
        long currtime = System.currentTimeMillis();
        HashMap<String, List<DynamicObject>> costBillMap = new HashMap<String, List<DynamicObject>>(128);
        if (this.rules == null || this.rules.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5173\u7cfb\u3002", (String)"SyncBizBill4AuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
            for (DynamicObject info : bizBills) {
                this.errMap.put(info.getLong("id"), new SynBillErrInfo("5", msg));
            }
            return costBillMap;
        }
        HashSet<Long> bizbillids = new HashSet<Long>(bizBills.length);
        for (DynamicObject info : bizBills) {
            bizbillids.add(info.getLong("id"));
        }
        if (bizbillids.isEmpty()) {
            return costBillMap;
        }
        HashMap calBillMap = new HashMap(4);
        HashMap<Long, String> unValidIdMap = new HashMap<Long, String>(16);
        FilterInfoChecker checker = new FilterInfoChecker(this.bizbillentityname, bizbillids);
        checker.loadSyncBillsByID();
        if (bizbillids.isEmpty()) {
            return costBillMap;
        }
        HashSet<String> genCalEntityBizBillIdStrs = new HashSet<String>(16);
        HashSet<Long> mulRuleBillIds = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : this.rules) {
            String calBillEntity = dynamicObject.getDynamicObject("calbill").getString("number");
            CalBillInfo calBillInfo = this.getCalBillInfo(calBillEntity);
            String queryEntity = calBillEntity;
            QFilter queryFilter = new QFilter("bizbillid", "in", bizbillids);
            if (this.isBizGroupModel) {
                queryEntity = "cal_costrecord";
                if ("cal_incalbill".equals(calBillEntity)) {
                    queryFilter.and("calbilltype", "=", (Object)"IN");
                } else {
                    queryFilter.and("calbilltype", "=", (Object)"OUT");
                }
                new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(queryFilter);
            }
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)queryEntity, (String)"id,bizbillid", (QFilter[])queryFilter.toArray());
            HashSet<Long> existCalIdSet = new HashSet<Long>(16);
            for (DynamicObject[] info : dynamicObjectCollection) {
                existCalIdSet.add(info.getLong("bizbillid"));
            }
            if (!existCalIdSet.isEmpty()) {
                ArrayList<DynamicObject> retryBizBillDycs = new ArrayList<DynamicObject>(16);
                for (DynamicObject bizBill : bizBills) {
                    if (!existCalIdSet.contains(bizBill.getLong("id"))) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u751f\u6210\u5931\u8d25\uff0c\u6838\u7b97\u5355\u5df2\u7ecf\u751f\u6210\u3002", (String)"SyncBizBill4AuditServiceProcess_29", (String)"fi-cal-business", (Object[])new Object[0]), calBillInfo.getType().getDisplayName());
                    this.errMap.put(bizBill.getLong("id"), new SynBillErrInfo("5", msg));
                    this.cantDelSet.add(bizBill.getLong("id"));
                    bizbillids.remove(bizBill.getLong("id"));
                    retryBizBillDycs.add(bizBill);
                }
                this.addQueue(retryBizBillDycs);
            }
            if (bizbillids.isEmpty()) {
                return costBillMap;
            }
            String calBillEntryKey = calBillInfo.getEntrykey();
            FieldMappingResult mappingResult = this.getFieldMapping(dynamicObject, calBillEntity);
            String ownerkey = mappingResult.getOwnerField().getTotalkey();
            Field calorgField = mappingResult.getCalOrgField();
            StringBuilder bizEntryKey = new StringBuilder();
            String[] entryOwners = ownerkey.split("\\.");
            entryOwners[entryOwners.length - 1] = "id";
            for (String name : entryOwners) {
                bizEntryKey.append(name).append('.');
            }
            String bizEntryKeyStr = bizEntryKey.toString().substring(0, bizEntryKey.length() - 1);
            String bizSelector = this.getBizBillSelector(mappingResult.getBizFieldSet());
            if (!bizSelector.contains(bizEntryKeyStr)) {
                bizSelector = bizSelector + "," + bizEntryKeyStr;
            }
            String filter = dynamicObject.getString("filter_tag");
            checker.setBizSelector(bizSelector);
            checker.setFilterStr(filter);
            Map<Long, String> checkErrorInfo = checker.doCheckErrorInfo();
            for (Map.Entry<Long, String> e : checkErrorInfo.entrySet()) {
                long id = e.getKey();
                String msg = e.getValue();
                String errorMsg = (String)unValidIdMap.get(id);
                errorMsg = errorMsg != null ? errorMsg + msg : msg;
                unValidIdMap.put(id, errorMsg);
            }
            Map<Long, DynamicObjectCollection> validEntryMaps = this.getValidEntrys(dynamicObject, bizbillids, bizSelector, bizEntryKeyStr);
            for (Map.Entry<Long, DynamicObjectCollection> entry : validEntryMaps.entrySet()) {
                long bizBillId = entry.getKey();
                DynamicObjectCollection bizBillColl = entry.getValue();
                if (bizBillColl.isEmpty()) continue;
                boolean isAddBillIdSucess = genCalEntityBizBillIdStrs.add(calBillEntity + bizBillId);
                if (!isAddBillIdSucess) {
                    mulRuleBillIds.add(bizBillId);
                }
                HashSet<String> exFieldSet = new HashSet<String>();
                for (DynamicObject ruleEntry : dynamicObject.getDynamicObjectCollection("fieldmap")) {
                    boolean isExtendField = ruleEntry.getBoolean("isextendfield");
                    if (!isExtendField) continue;
                    String calFieldName = ruleEntry.getString("calfield");
                    exFieldSet.add(calFieldName);
                }
                HashMap<String, DynamicObject> bizbillidOwnerMapCalBill = (HashMap<String, DynamicObject>)calBillMap.get(calBillInfo);
                if (bizbillidOwnerMapCalBill == null) {
                    bizbillidOwnerMapCalBill = new HashMap<String, DynamicObject>(16);
                    calBillMap.put(calBillInfo, bizbillidOwnerMapCalBill);
                }
                Map<Field, Field> headMapping = mappingResult.getHeadmap();
                Map<Field, Field> entryMapping = mappingResult.getEntrymap();
                int billCollSize = bizBillColl.size();
                IDGenerator inIdGenerator = new IDGenerator("t_cal_incalbill", billCollSize);
                IDGenerator outIdGenerator = new IDGenerator("t_cal_outcalbill", billCollSize);
                for (DynamicObject billentry : bizBillColl) {
                    String bizBillId2OwneridKey;
                    DynamicObject calBill;
                    Long ownerid = billentry.getLong(ownerkey);
                    boolean isPurRecBill = "im_purreceivebill".equals(this.bizbillentityname);
                    if (isPurRecBill && calorgField != null && StringUtils.isNotEmpty((String)calorgField.getTotalkey()) && billentry.getLong(calorgField.getTotalkey()) != 0L) {
                        ownerid = billentry.getLong(calorgField.getTotalkey());
                    }
                    if ((calBill = (DynamicObject)bizbillidOwnerMapCalBill.get(bizBillId2OwneridKey = bizBillId + "," + ownerid)) == null) {
                        long id = 0L;
                        calBill = BusinessDataServiceHelper.newDynamicObject((String)calBillEntity);
                        id = "cal_outcalbill".equals(calBillEntity) ? outIdGenerator.getId().longValue() : inIdGenerator.getId().longValue();
                        calBill.set("id", (Object)id);
                        for (Map.Entry<Field, Field> mapEntry : headMapping.entrySet()) {
                            calBill.set(mapEntry.getKey().getProperty(), billentry.get(mapEntry.getValue().getTotalkey()));
                        }
                        for (Map.Entry<Field, Field> mapEntry : headMapping.entrySet()) {
                            calBill.set(mapEntry.getKey().getProperty(), billentry.get(mapEntry.getValue().getTotalkey()));
                        }
                        calBill.set("bizbillid", billentry.get("id"));
                        calBill.set("bizentityobject", (Object)this.bizEntityObject);
                        calBill.set("billstatus", (Object)"B");
                        bizbillidOwnerMapCalBill.put(bizBillId2OwneridKey, calBill);
                    }
                    DynamicObjectCollection entryCol = calBill.getDynamicObjectCollection(calBillEntryKey);
                    DynamicObject costBillEntry = entryCol.addNew();
                    costBillEntry.set("seq", (Object)entryCol.size());
                    for (Map.Entry<Field, Field> entryMap : entryMapping.entrySet()) {
                        costBillEntry.set(entryMap.getKey().getProperty(), billentry.get(entryMap.getValue().getTotalkey()));
                    }
                    if (StringUtils.isEmpty((String)bizEntryKeyStr)) {
                        costBillEntry.set("bizbillentryid", billentry.get(this.bizbillentrykey + ".id"));
                    } else {
                        costBillEntry.set("bizbillentryid", billentry.get(bizEntryKeyStr));
                    }
                    this.exFieldMap.put(calBill.getLong("id"), exFieldSet);
                }
            }
        }
        logger.info("CreateCostRecordProcess-\u5f00\u59cb\u4fdd\u5b58\u6838\u7b97\u5355\uff1a" + System.currentTimeMillis());
        for (Map.Entry entry : calBillMap.entrySet()) {
            void var17_35;
            CalBillInfo calInfo = (CalBillInfo)entry.getKey();
            Map map = (Map)entry.getValue();
            Map billIdErrMap = new MulCalBillSyncRuleHelper().removeMulRuleCalBill(mulRuleBillIds, map);
            for (Long l : billIdErrMap.keySet()) {
                unValidIdMap.remove(l);
            }
            this.errMap.putAll(billIdErrMap);
            for (Map.Entry entry2 : map.entrySet()) {
                String key = (String)entry2.getKey();
                long billId = Long.parseLong(key.split(",")[0]);
                unValidIdMap.remove(billId);
                ArrayList billList = (ArrayList)costBillMap.get(key);
                if (billList == null) {
                    billList = new ArrayList(16);
                    costBillMap.put(key, billList);
                }
                billList.add(entry2.getValue());
            }
            Collection billcol = ((Map)calBillMap.get(calInfo)).values();
            DynamicObject[] dynamicObjectArray = billcol.toArray(new DynamicObject[0]);
            if (this.isBizGroupModel) {
                DynamicObject[] dynamicObjectArray2 = this.getCalBillPKArr(dynamicObjectArray, calInfo);
            }
            if (((void)var17_35).length > 0) {
                try {
                    SaveServiceHelper.save((DynamicObject[])var17_35);
                }
                catch (Exception e) {
                    String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    logger.info("kd.fi.cal.business.process.impl.CreateCostRecordProcess-\u4fdd\u5b58\u6838\u7b97\u5355\u5f02\u5e38" + exceptionStackTraceMessage);
                    if (exceptionStackTraceMessage.contains("SQLIntegrityConstraintViolationException") || exceptionStackTraceMessage.contains("duplicate key")) {
                        String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u751f\u6210\u5931\u8d25\uff0c\u6838\u7b97\u5355\u5df2\u7ecf\u751f\u6210\u3002", (String)"SyncBizBill4AuditServiceProcess_29", (String)"fi-cal-business", (Object[])new Object[0]), calInfo.getType().getDisplayName());
                        throw new KDBizException(msg);
                    }
                    throw e;
                }
            }
            logger.info("CreateCostRecordProcess-\u7ed3\u675f\u4fdd\u5b58\u6838\u7b97\u5355\uff1a" + System.currentTimeMillis());
        }
        if (!unValidIdMap.isEmpty()) {
            for (Map.Entry entry : unValidIdMap.entrySet()) {
                this.errMap.put((Long)entry.getKey(), new SynBillErrInfo("5", (String)entry.getValue()));
                bizbillids.remove(entry.getKey());
            }
        }
        logger.info("CreateCostRecordProcess-\u7ed3\u675f\u521b\u5efa\u6838\u7b97\u5355createCalBill\uff1a" + (currtime - System.currentTimeMillis()));
        return costBillMap;
    }

    private DynamicObject[] getCalBillPKArr(DynamicObject[] billarr, CalBillInfo calInfo) {
        String calbilltype = "IN";
        if ("cal_outcalbill".equals(calInfo.getType().getName())) {
            calbilltype = "OUT";
        }
        IDGenerator idGenerator = new IDGenerator("t_cal_calbill_pk");
        HashSet<DynamicObject> calBillPKs = new HashSet<DynamicObject>(16);
        for (DynamicObject calbill : billarr) {
            Long calbillid = calbill.getLong("id");
            String billno = calbill.getString("billno");
            Long bizbillid = calbill.getLong("bizbillid");
            DynamicObjectCollection entry = calbill.getDynamicObjectCollection(calInfo.getEntrykey());
            for (DynamicObject entryRow : entry) {
                Long bizbillentryid = entryRow.getLong("bizbillentryid");
                Long calentryid = idGenerator.getId();
                entryRow.set("id", (Object)calentryid);
                DynamicObject calbillpk = BusinessDataServiceHelper.newDynamicObject((String)"cal_calbill_pk");
                calbillpk.set("id", (Object)calentryid);
                calbillpk.set("bizbillid", (Object)bizbillid);
                calbillpk.set("bizbillentryid", (Object)bizbillentryid);
                calbillpk.set("billno", (Object)billno);
                calbillpk.set("calbilltype", (Object)calbilltype);
                calbillpk.set("calbillid", (Object)calbillid);
                calbillpk.set("createtime", (Object)TimeServiceHelper.now());
                calBillPKs.add(calbillpk);
            }
        }
        return calBillPKs.toArray(new DynamicObject[0]);
    }

    protected void init(DynamicObject bizBill) {
        Long currtime = System.currentTimeMillis();
        logger.info("CreateCostRecordProcess-\u8fdb\u5165\u63d2\u4ef6-" + bizBill.getString("billno") + ":" + System.currentTimeMillis());
        this.bizbillentityname = bizBill.getDataEntityType().getName();
        this.bizbillentitytype = EntityMetadataCache.getDataEntityType((String)this.bizbillentityname);
        this.rules = this.getCalBillRules();
        this.bizbillentrykey = this.getEntryKey(this.bizbillentityname);
        this.calbilltypemap = new HashMap<String, CalBillInfo>();
        this.bizEntityObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)this.bizbillentityname).toArray());
        logger.info("CreateCostRecordProcess-\u7ed3\u675f\u521d\u59cb\u5316\u65b9\u6cd5init\uff1a" + (currtime - System.currentTimeMillis()));
    }

    private CalBillInfo getCalBillInfo(String calBillNo) {
        CalBillInfo info = this.calbilltypemap.get(calBillNo);
        if (info == null) {
            info = new CalBillInfo(calBillNo);
            this.calbilltypemap.put(calBillNo, info);
        }
        return info;
    }

    private String getBizBillSelector(Collection<Field> bizFields) {
        StringBuilder bizSelectorsSb = new StringBuilder();
        for (Field bizField : bizFields) {
            bizSelectorsSb.append(bizField.getTotalkey()).append(',');
        }
        bizSelectorsSb.setLength(bizSelectorsSb.length() - 1);
        String fields = bizSelectorsSb.toString();
        if (!fields.contains(this.bizbillentrykey + ".id")) {
            fields = this.bizbillentrykey + ".id," + fields;
        }
        if (!"im_initbill".equals(this.bizbillentityname)) {
            fields = "id," + fields;
        }
        return fields;
    }

    private FieldMappingResult getFieldMapping(DynamicObject rule, String calBillNumber) {
        FieldMappingResult result = new FieldMappingResult();
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            String bizFieldName = ruleEntry.getString("sourcefield");
            if (StringUtils.isEmpty((String)bizFieldName)) continue;
            String calFieldName = ruleEntry.getString("calfield");
            CalBillInfo calBillInfo = this.getCalBillInfo(calBillNumber);
            IDataEntityProperty calEntity = calBillInfo.getType().findProperty(calFieldName);
            IDataEntityProperty bizEntity = this.bizbillentitytype.findProperty(bizFieldName.split("\\.")[0]);
            if (calEntity == null || bizEntity == null) continue;
            IDataEntityType parentyCalEntity = calEntity.getParent();
            IDataEntityType parentBizEntity = bizEntity.getParent();
            if (parentyCalEntity instanceof LinkEntryType || parentBizEntity instanceof LinkEntryType) continue;
            Field bizField = null;
            Field calField = parentyCalEntity instanceof EntryType ? new Field(calFieldName, true, calBillInfo.getEntrykey(), calEntity) : new Field(calFieldName, false, null, calEntity);
            bizField = parentBizEntity instanceof SubEntryType ? new Field(bizFieldName, true, this.bizbillentrykey + "." + parentBizEntity.getName(), bizEntity) : (parentBizEntity instanceof EntryType ? new Field(bizFieldName, true, this.bizbillentrykey, bizEntity) : new Field(bizFieldName, false, null, bizEntity));
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".owner")) {
                result.setOwnerField(bizField);
            }
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".companyorg")) {
                result.setCalOrgField(bizField);
            }
            result.addMapping(calField, bizField);
        }
        if (!result.hasOwnerField()) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u6620\u5c04\u89c4\u5219\u6ca1\u6709\u914d\u7f6e\u8d27\u4e3b\u5b57\u6bb5\u3002", (String)"SyncBizBill4AuditServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0]), calBillNumber);
            throw new KDBizException(msg);
        }
        return result;
    }

    protected Map<Long, DynamicObjectCollection> getValidEntrys(DynamicObject rule, Object bizBillID, String selectors, String bizEntryKey) {
        logger.info("CreateCostRecordProcess-\u5f00\u59cb\u8fc7\u6ee4\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\uff1a" + System.currentTimeMillis());
        String filter = rule.getString("filter_tag");
        QFilter[] qs = null;
        if (StringUtils.isNotEmpty((String)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(this.bizbillentitytype, filterCondition);
            filterBuilder.buildFilter();
            QFilter qf = new QFilter("id", "in", bizBillID);
            qs = qf.and(filterBuilder.getQFilter()).toArray();
        } else {
            qs = new QFilter[]{new QFilter("id", "in", bizBillID)};
        }
        DynamicObjectCollection bizBillColl = QueryServiceHelper.query((String)this.bizbillentityname, (String)selectors, (QFilter[])qs);
        HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
        HashSet<Long> hasEntryIds = new HashSet<Long>(16);
        for (DynamicObject info : bizBillColl) {
            long id = info.getLong("id");
            DynamicObjectCollection coll = (DynamicObjectCollection)map.get(id);
            if (coll != null) {
                boolean isExist = false;
                if (!hasEntryIds.add(info.getLong(bizEntryKey))) {
                    isExist = true;
                }
                if (isExist) continue;
                coll.add((Object)info);
                continue;
            }
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            map.put(id, coll);
            hasEntryIds.add(info.getLong(bizEntryKey));
        }
        logger.info("CreateCostRecordProcess-\u7ed3\u675f\u8fc7\u6ee4\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\uff1a" + System.currentTimeMillis());
        return map;
    }

    private String getEntryKey(String entityname) {
        return SynBizBillHelper.getFirstEntryKeyByMatField((String)entityname, this.rules);
    }

    private Collection<DynamicObject> getCalBillRules() {
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)this.bizbillentityname);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)CALRULEFIELDS, (QFilter[])filter.toArray());
        HashSet<DynamicObject> billRuleSet = new HashSet<DynamicObject>(billRules.length);
        for (DynamicObject rull : billRules) {
            if (rull == null) continue;
            billRuleSet.add(rull);
        }
        return billRuleSet;
    }

    private DynamicObjectCollection getAllCostAccount(long ownerId) {
        DynamicObjectCollection accountcoll = this.costAccountMap.get(ownerId);
        if (accountcoll == null) {
            DynamicObjectCollection coll = AccountingSysHelper.getAccountingSysCollsByOwner((Long)ownerId, null);
            QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            for (DynamicObject info : coll) {
                long calSystemId = info.getLong("id");
                long calOrgId = info.getLong("calorgid");
                QFilter q1 = new QFilter("calsystem", "=", (Object)calSystemId);
                q1.and("calorg", "=", (Object)calOrgId);
                q.or(q1);
            }
            q.and("status", "=", (Object)"C");
            q.and("enable", "=", (Object)"1");
            new CalGroupAccountHelper().addNotGroupAcctFilterSelf(q);
            accountcoll = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)COSTACCOUNTFIELDS, (QFilter[])q.toArray());
            this.costAccountMap.put(ownerId, accountcoll);
        }
        return accountcoll;
    }

    @Override
    public void doProcessor(Map params, DynamicObject bill) {
        super.doProcessor(params, bill);
    }

    private void addQueue(List<DynamicObject> bizBills) {
        if (bizBills == null || bizBills.isEmpty()) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("retry", "1");
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{ActionEnum.SUBMIT.getValue(), param, bizBills.toArray(new DynamicObject[0])});
    }

    private String getNullStockTypeErrMsg(Map<Long, Set<Long>> orgNullStockTypeMats, Map<Long, Object[]> orgIdNumNameMap, Map<Long, Object[]> matIdMatNumMap) {
        int i = 1;
        StringBuilder errorBuilder = new StringBuilder();
        for (Map.Entry<Long, Set<Long>> entry : orgNullStockTypeMats.entrySet()) {
            Long calOrgId = entry.getKey();
            if (i > 5) break;
            String calOrgNum = (String)orgIdNumNameMap.get(calOrgId)[0];
            String calOrgName = (String)orgIdNumNameMap.get(calOrgId)[1];
            Set<Long> matIds = entry.getValue();
            int j = 1;
            StringBuilder matBuilder = new StringBuilder();
            for (Long matId : matIds) {
                if (j > 5) break;
                matBuilder.append("\u3010");
                matBuilder.append(matIdMatNumMap.get(matId)[0]);
                matBuilder.append("\u3011");
                matBuilder.append(",");
                ++j;
            }
            String matStr = CommonUtils.trimComma((String)matBuilder.toString());
            if (matIds.size() > 5) {
                matStr = matStr + "...";
            }
            String msg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u6838\u7b97\u7ec4\u7ec7\u201c %2$s\uff08%3$s\uff09\u201d\u4e0b\u672a\u627e\u5230\u53ef\u7528\u7684\u5b58\u8d27\u7c7b\u522b\uff0c\u8bf7\u5148\u7ef4\u62a4\u5b58\u8d27\u7c7b\u522b\u518d\u91cd\u65b0\u6267\u884c", (String)"SyncBizBill4AuditServiceProcess_33", (String)"fi-cal-business", (Object[])new Object[0]), CommonUtils.trimComma((String)matStr), calOrgNum, calOrgName);
            errorBuilder.append(msg);
            errorBuilder.append(";");
            ++i;
        }
        String errorMsgStr = CommonUtils.trimBySign((String)errorBuilder.toString(), (String)";");
        if (orgNullStockTypeMats.size() > 5) {
            errorMsgStr = errorMsgStr + "...";
        }
        return errorMsgStr;
    }

    private void cacheNoStockTypeMatOrgInfo(Map<Long, Set<DynamicObject>> costRecordMap, boolean isValStockType, Map<Long, Object[]> orgIdNumNameMap, Map<Long, Object[]> matIdMatNumMap) {
        if (!isValStockType) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> matIds = new HashSet<Long>(16);
        for (Set<DynamicObject> costRecDycs : costRecordMap.values()) {
            for (DynamicObject costRecDyc : costRecDycs) {
                Long calOrgId = costRecDyc.getLong("calorg_id");
                DynamicObjectCollection coll = costRecDyc.getDynamicObjectCollection("entry");
                for (DynamicObject entryInfo : coll) {
                    if (entryInfo.get("stocktype_id") != null && (Long)entryInfo.get("stocktype_id") != 0L) continue;
                    orgIds.add(calOrgId);
                    matIds.add((Long)entryInfo.get("material_id"));
                }
            }
        }
        DataSet matDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id,number", (QFilter[])new QFilter("id", "in", matIds).toArray(), null);
        DataSet orgDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter("id", "in", orgIds).toArray(), null);
        for (Row row : matDs) {
            matIdMatNumMap.put(row.getLong("id"), new Object[]{row.getString("number")});
        }
        for (Row row : orgDs) {
            orgIdNumNameMap.put(row.getLong("id"), new Object[]{row.getString("number"), row.getString("name")});
        }
    }

    private static class CostRecordNoGenerator
    implements IBillNoGenerator {
        private String calNo;
        private boolean isSingle;
        private int seq;

        CostRecordNoGenerator(String calNo, boolean isSingle, int seq) {
            this.calNo = calNo;
            this.isSingle = isSingle;
            this.seq = seq;
        }

        @Override
        public String getNumber() {
            String number = null;
            number = this.isSingle ? this.calNo : this.calNo + "-" + this.seq;
            return number;
        }
    }
}

