/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.common.util.DynamicObjectUtils;

public class CreateDischargeVoucherProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(CreateDischargeVoucherProcess.class);

    @Override
    public void doProcessor(Map params, DynamicObject[] bills) {
        Object row22;
        Object curPeriodId = params.get("curPeriod");
        Object prePeriodId = params.get("prePeriod");
        Object costAccountId = params.get("costAccount");
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingle(curPeriodId, (String)"bd_period");
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccountId)});
        QFilter q = new QFilter("periodid", "=", prePeriodId);
        q.and("vouchertype", "=", (Object)"B");
        q.and("dischargetype", "=", (Object)"B");
        q.and("costaccount", "=", costAccountId);
        HashSet<Long> tempVoucherIdSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"costrecordid,voucherid", (QFilter[])new QFilter[]{q}, null);){
            for (Object row22 : dataSet) {
                long voucherId = row22.getLong("voucherid");
                tempVoucherIdSet.add(voucherId);
            }
        }
        QFilter q1 = new QFilter("costrecordid", "in", tempVoucherIdSet);
        q1.and("vouchertype", "=", (Object)"C");
        q1.and("createmode", "=", (Object)1);
        q1.and("dischargetype", "=", (Object)"B");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"costrecordid", (QFilter[])new QFilter[]{q1}, null);
        Object object = null;
        try {
            for (Row row3 : dataSet) {
                long voucherId = row3.getLong("costrecordid");
                tempVoucherIdSet.remove(voucherId);
            }
        }
        catch (Throwable row22) {
            object = row22;
            throw row22;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row22) {
                        ((Throwable)object).addSuppressed(row22);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        q.and("voucherid", "in", tempVoucherIdSet);
        HashMap<Long, ArrayList<Long>> tempVoucherMap = new HashMap<Long, ArrayList<Long>>();
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"voucherid,costrecordid", (QFilter[])new QFilter[]{q}, null);
        row22 = null;
        try {
            for (Row row4 : dataSet2) {
                long voucherId = row4.getLong("voucherid");
                long costrecordId = row4.getLong("costrecordid");
                ArrayList<Long> costRecordIdList = (ArrayList<Long>)tempVoucherMap.get(voucherId);
                if (costRecordIdList != null) {
                    costRecordIdList.add(costrecordId);
                    continue;
                }
                costRecordIdList = new ArrayList<Long>();
                costRecordIdList.add(costrecordId);
                tempVoucherMap.put(voucherId, costRecordIdList);
            }
        }
        catch (Throwable row3) {
            row22 = row3;
            throw row3;
        }
        finally {
            if (dataSet2 != null) {
                if (row22 != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable row3) {
                        ((Throwable)row22).addSuppressed(row3);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        MainEntityType voucherEntityType = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        DynamicObject[] vouchers = BusinessDataServiceHelper.load((Object[])tempVoucherMap.keySet().toArray(), (DynamicObjectType)voucherEntityType);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_usergroup_user");
        HashMap<Long, String> logSubVouIdMsgMap = new HashMap<Long, String>(16);
        HashMap<Long, Object> logAuditVouIdMsgMap = new HashMap<Long, Object>(16);
        for (DynamicObject tempVoucher : vouchers) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u671f\u95f4\u201c%2$s\u201d\u7ed3\u8d26\uff0c\u6682\u4f30\u51ed\u8bc1\u201c%3$s\u201d\u751f\u6210\u51b2\u56de\u51ed\u8bc1\u5931\u8d25\u3002", (String)"CreateDischargeVoucherProcess_10", (String)"fi-cal-business", (Object[])new Object[0]), costAccount.getString("number"), curPeriod.getString("number"), tempVoucher.getString("billno"));
            try {
                Object errMsg;
                List errors;
                OperationResult result;
                DynamicObject dischargeVoucher = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
                List costRecordIdList = (List)tempVoucherMap.get(tempVoucher.getLong("id"));
                DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,vouchertype,calorg,costaccount,dischargetype,vouchertype,issplit,istempvoucher,isdischargevoucher,dischargevouchernum,dischargevoucherid,writeoffstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)costRecordIdList)});
                DynamicObjectUtils.copy((DynamicObject)tempVoucher, (DynamicObject)dischargeVoucher);
                dischargeVoucher.set("bookeddate", (Object)curPeriod.getDate("begindate"));
                dischargeVoucher.set("period", (Object)curPeriod);
                dischargeVoucher.set("poster", null);
                dischargeVoucher.set("ispost", (Object)false);
                dischargeVoucher.set("billstatus", (Object)"A");
                dischargeVoucher.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
                dischargeVoucher.set("creator", (Object)user);
                dischargeVoucher.set("auditor", null);
                dischargeVoucher.set("auditdate", null);
                dischargeVoucher.set("modifier", null);
                dischargeVoucher.set("modifytime", null);
                dischargeVoucher.set("cashier", null);
                dischargeVoucher.set("ischeck", (Object)"a");
                dischargeVoucher.set("canceller", null);
                String msg = String.format(ResManager.loadKDString((String)"\u6682\u4f30\u51ed\u8bc1\u201c%1$s\u201d\u751f\u6210\u51b2\u56de\u51ed\u8bc1\u3002", (String)"CreateDischargeVoucherProcess_11", (String)"fi-cal-business", (Object[])new Object[0]), tempVoucher.getString("billno"));
                dischargeVoucher.set("description", (Object)msg);
                dischargeVoucher.set("billno", null);
                DynamicObjectCollection entrys = dischargeVoucher.getDynamicObjectCollection("entries");
                for (DynamicObject entryInfo : entrys) {
                    entryInfo.set("quantity", (Object)entryInfo.getBigDecimal("quantity").negate());
                    entryInfo.set("oriamount", (Object)entryInfo.getBigDecimal("oriamount").negate());
                    entryInfo.set("debitori", (Object)entryInfo.getBigDecimal("debitori").negate());
                    entryInfo.set("creditori", (Object)entryInfo.getBigDecimal("creditori").negate());
                    entryInfo.set("debitlocal", (Object)entryInfo.getBigDecimal("debitlocal").negate());
                    entryInfo.set("creditlocal", (Object)entryInfo.getBigDecimal("creditlocal").negate());
                    String edescription = entryInfo.getString("edescription");
                    if (StringUtils.isEmpty((String)edescription)) continue;
                    edescription = String.format(ResManager.loadKDString((String)"%1$s-\u51b2\u56de", (String)"CreateDischargeVoucherProcess_13", (String)"fi-cal-business", (Object[])new Object[0]), edescription);
                    entryInfo.set("edescription", (Object)edescription);
                }
                try (TXHandle h = TX.requiresNew();){
                    Object operror;
                    OperationResult result2 = OperationServiceHelper.executeOperate((String)"save", (String)"gl_voucher", (DynamicObject[])new DynamicObject[]{dischargeVoucher});
                    List errors2 = result2.getAllErrorOrValidateInfo();
                    if (!errors2.isEmpty()) {
                        for (IOperateInfo error : errors2) {
                            operror = (OperateInfo)error;
                            String string = String.format(ResManager.loadKDString((String)"%1$s\uff08\u51ed\u8bc1\u65b0\u589e\u4fdd\u5b58\u5931\u8d25\uff09%2$s", (String)"CreateDischargeVoucherProcess_6", (String)"fi-cal-business", (Object[])new Object[0]), errorMsg, operror.getMessage());
                            this.addErrorMsg(string);
                        }
                        continue;
                    }
                    List idList = result2.getSuccessPkIds();
                    dischargeVoucher = BusinessDataServiceHelper.loadSingle(idList.get(0), (String)"gl_voucher");
                    this.addDapTracks(costRecords, dischargeVoucher);
                    TXHandle h1 = TX.requiresNew();
                    operror = null;
                    try {
                        this.addCalVouchers(tempVoucher, dischargeVoucher, costAccountId);
                        for (DynamicObject costRecordInfo : costRecords) {
                            boolean isSplit = costRecordInfo.getBoolean("issplit");
                            if (!isSplit || "B".equals(costRecordInfo.getString("writeoffstatus"))) {
                                costRecordInfo.set("istempvoucher", (Object)false);
                            }
                            costRecordInfo.set("isdischargevoucher", (Object)true);
                            costRecordInfo.set("dischargevouchernum", (Object)dischargeVoucher.getString("billno"));
                            costRecordInfo.set("dischargevoucherid", (Object)dischargeVoucher.getLong("id"));
                        }
                        SaveServiceHelper.save((DynamicObject[])costRecords);
                    }
                    catch (Throwable throwable) {
                        operror = throwable;
                        throw throwable;
                    }
                    finally {
                        if (h1 != null) {
                            if (operror != null) {
                                try {
                                    h1.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)operror).addSuppressed(throwable);
                                }
                            } else {
                                h1.close();
                            }
                        }
                    }
                }
                h = TX.requiresNew();
                var29_49 = null;
                try {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("skipbillnovalidatorAbstractCodeRule", "false");
                    result = OperationServiceHelper.executeOperate((String)"submit", (String)"gl_voucher", (DynamicObject[])new DynamicObject[]{dischargeVoucher}, (OperateOption)option);
                    errors = result.getAllErrorOrValidateInfo();
                    StringBuilder voucherSubmitErr = new StringBuilder();
                    if (!errors.isEmpty()) {
                        for (IOperateInfo iOperateInfo : errors) {
                            OperateInfo operror = (OperateInfo)iOperateInfo;
                            voucherSubmitErr.append(operror.getMessage()).append(",");
                        }
                        continue;
                    }
                    if (voucherSubmitErr.length() > 0) {
                        errMsg = voucherSubmitErr.deleteCharAt(voucherSubmitErr.length() - 1).toString();
                        logSubVouIdMsgMap.put(tempVoucher.getLong("id"), (String)errMsg);
                    }
                }
                catch (Throwable option) {
                    var29_49 = option;
                    throw option;
                }
                finally {
                    if (h != null) {
                        if (var29_49 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable operror) {
                                var29_49.addSuppressed(operror);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
                h = TX.requiresNew();
                var29_49 = null;
                try {
                    String msg2;
                    String msg1;
                    dischargeVoucher = BusinessDataServiceHelper.loadSingle((Object)dischargeVoucher.getLong("id"), (String)"gl_voucher");
                    String vdescription = dischargeVoucher.getString("vdescription");
                    vdescription = StringUtils.isEmpty((String)vdescription) ? (msg1 = String.format(ResManager.loadKDString((String)"\u51b2\u56de-%1$s", (String)"CreateDischargeVoucherProcess_9", (String)"fi-cal-business", (Object[])new Object[0]), tempVoucher.getString("billno"))) : (msg2 = String.format(ResManager.loadKDString((String)"-\u51b2\u56de-%1$s", (String)"CreateDischargeVoucherProcess_12", (String)"fi-cal-business", (Object[])new Object[0]), tempVoucher.getString("billno")));
                    dischargeVoucher.set("vdescription", (Object)vdescription);
                    result = OperationServiceHelper.executeOperate((String)"audit", (String)"gl_voucher", (DynamicObject[])new DynamicObject[]{dischargeVoucher});
                    errors = result.getAllErrorOrValidateInfo();
                    StringBuilder voucherAuditErr = new StringBuilder();
                    if (!errors.isEmpty()) {
                        for (IOperateInfo iOperateInfo : errors) {
                            OperateInfo operror = (OperateInfo)iOperateInfo;
                            voucherAuditErr.append(operror.getMessage()).append(",");
                        }
                    }
                    if (voucherAuditErr.length() <= 0) continue;
                    errMsg = voucherAuditErr.deleteCharAt(voucherAuditErr.length() - 1).toString();
                    logAuditVouIdMsgMap.put(tempVoucher.getLong("id"), errMsg);
                }
                catch (Throwable throwable) {
                    var29_49 = throwable;
                    throw throwable;
                }
                finally {
                    if (h != null) {
                        if (var29_49 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var29_49.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.addErrorMsg(errorMsg + this.getErrorMsg(e));
            }
        }
        logger.error("\u51ed\u8bc1\u63d0\u4ea4\u5931\u8d25\uff1a==>{}", logSubVouIdMsgMap);
        logger.error("\u51ed\u8bc1\u5ba1\u6838\u5931\u8d25\uff1a==>{}", logAuditVouIdMsgMap);
    }

    private void addCalVouchers(DynamicObject tempVoucher, DynamicObject dischargeVoucher, Object costAccountId) {
        DynamicObject calVoucher = BusinessDataServiceHelper.newDynamicObject((String)"cal_voucher");
        DynamicObject period = dischargeVoucher.getDynamicObject("period");
        calVoucher.set("periodid", (Object)period);
        calVoucher.set("costrecordid", (Object)tempVoucher.getLong("id"));
        calVoucher.set("voucherid", dischargeVoucher.getPkValue());
        calVoucher.set("createtime", dischargeVoucher.get("createtime"));
        calVoucher.set("vouchertype", (Object)"C");
        calVoucher.set("dischargetype", (Object)"B");
        calVoucher.set("createmode", (Object)1);
        calVoucher.set("vouchersource", (Object)"B");
        calVoucher.set("costaccount_id", costAccountId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calVoucher});
    }

    private void addDapTracks(DynamicObject[] costRecords, DynamicObject voucher) {
        if (costRecords == null || costRecords.length == 0) {
            return;
        }
        ArrayList<DynamicObject> trackersToSave = new ArrayList<DynamicObject>(costRecords.length);
        for (DynamicObject costRecordInfo : costRecords) {
            DynamicObject daptracker = BusinessDataServiceHelper.newDynamicObject((String)"ai_daptracker");
            daptracker.set("billtype", (Object)"cal_costrecord_subentity");
            daptracker.set("sourcebillid", (Object)costRecordInfo.getLong("id"));
            daptracker.set("createdate", (Object)new Date());
            daptracker.set("voucherid", voucher.getPkValue());
            daptracker.set("org", voucher.get("org"));
            daptracker.set("booktype", voucher.get("booktype"));
            trackersToSave.add(daptracker);
        }
        SaveServiceHelper.save((IDataEntityType)((DynamicObject)trackersToSave.get(0)).getDataEntityType(), (Object[])trackersToSave.toArray());
    }
}

