/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.CalBillInfo;
import kd.fi.cal.business.process.inner.Field;
import kd.fi.cal.business.process.inner.FieldMappingResult;
import kd.fi.cal.business.process.inner.FilterInfoChecker;
import kd.fi.cal.common.constant.BillTypeConstants;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.MulCalBillSyncRuleHelper;
import kd.fi.cal.common.helper.StopSyncBizBillHelper;
import kd.fi.cal.common.helper.SynBizBillHelper;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.DynamicObjectUtils;

public class CreateInitCalBillProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(CreateInitCalBillProcess.class);
    private static final String CALRULEFIELDS = "id,number,calbill.id,calbill.number,fieldmap.calfield,fieldmap.sourcefield,fieldmap.isorgfield,fieldmap.orgtype,filter,filter_tag,fieldmap.isextendfield,errortip";
    private static final String COSTACCOUNTFIELDS = "id,name,number,calpolicy,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.currency.priceprecision,dividebasis,calpolicy.currency.number,calpolicy.currency.name,calpolicy.convertmode,calpolicy.exratetable,calpolicy.calbycostelement,calpolicy.supporttaxamt,calorg,calorg.name,calorg.number";
    private Map<Long, DynamicObjectCollection> costAccountMap = new HashMap<Long, DynamicObjectCollection>(32);
    private Map<String, CalBillInfo> calbilltypemap;
    private MainEntityType bizbillentitytype;
    private String bizbillentityname;
    private String bizbillentrykey;
    private DynamicObject bizEntityObject;
    private Map<Long, Set<String>> exFieldMap = new HashMap<Long, Set<String>>(32);
    private Map<Long, SynBillErrInfo> errMap = new HashMap<Long, SynBillErrInfo>(32);
    private boolean isAuditCheck = false;
    private Collection<DynamicObject> rules = new HashSet<DynamicObject>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return;
        }
        this.bizbillentityname = bizBills[0].getDataEntityType().getName();
        if (!"im_initbill".equals(this.bizbillentityname)) {
            return;
        }
        if (params != null && params.containsKey("isAuditCheck")) {
            this.isAuditCheck = (Boolean)params.get("isAuditCheck");
        }
        try {
            DynamicObject bizBill = bizBills[0];
            if (bizBill == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86\u3002", (String)"SyncBizBill4AuditServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            this.init(bizBill);
            if ("im_initbill".equals(this.bizbillentityname)) {
                this.createInitCalBill(bizBills);
                return;
            }
        }
        finally {
            if (!this.errMap.isEmpty()) {
                for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                    this.addErrorMsg(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private void createInitCalBill(DynamicObject[] bizBills) {
        if (this.rules.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5173\u7cfb\u3002", (String)"SyncBizBill4AuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
            for (DynamicObject info : bizBills) {
                this.errMap.put(info.getLong("id"), new SynBillErrInfo("5", msg));
            }
            return;
        }
        int bizSize = bizBills.length;
        HashSet<Long> idSet = new HashSet<Long>(bizSize);
        for (DynamicObject info : bizBills) {
            idSet.add(info.getLong("id"));
        }
        if (idSet.isEmpty()) {
            return;
        }
        HashMap<String, DynamicObject> ownerMapCalBill = new HashMap<String, DynamicObject>(bizSize);
        HashMap<Long, DynamicObject> costAcc2StartPeriod = new HashMap<Long, DynamicObject>(16);
        HashMap ownerMap = new HashMap(16);
        HashMap AccEndInitMap = new HashMap(16);
        HashMap<Long, Set<Long>> billOwnerMap = new HashMap<Long, Set<Long>>(bizSize);
        HashMap<Long, Integer> billcountsMap = new HashMap<Long, Integer>(bizSize);
        HashMap costAcc2Std = new HashMap(16);
        HashSet<String> existInitBill = new HashSet<String>(bizSize);
        HashMap<Long, Long> calBillExratetableMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> billCurrencyMap = new HashMap<Long, Long>(bizSize);
        int genIniBillNum = 0;
        String errortip = null;
        HashMap<Long, String> unValidIdMap = new HashMap<Long, String>(16);
        FilterInfoChecker checker = new FilterInfoChecker(this.bizbillentityname, idSet);
        checker.loadSyncBillsByID();
        HashSet<String> genCalEntityBizBillIdStrs = new HashSet<String>(16);
        HashSet<Long> mulRuleBillIds = new HashSet<Long>(16);
        for (DynamicObject rule : this.rules) {
            if (StringUtils.isEmpty(errortip)) {
                errortip = rule.getString("errortip");
            }
            String calBillNumber = rule.getDynamicObject("calbill").getString("number");
            DynamicObjectCollection coll = QueryServiceHelper.query((String)calBillNumber, (String)"id,bizbillid,costaccount", (QFilter[])new QFilter("bizbillid", "in", idSet).toArray());
            this.genExistBillSet(billcountsMap, existInitBill, coll);
            FieldMappingResult fieldMappingResult = this.getFieldMapping(rule, calBillNumber);
            String ownerkey = fieldMappingResult.getOwnerField().getTotalkey();
            StringBuilder bizEntryKey = new StringBuilder();
            String[] entryOwners = ownerkey.split("\\.");
            entryOwners[entryOwners.length - 1] = "id";
            for (String name : entryOwners) {
                bizEntryKey.append(name).append('.');
            }
            String bizEntryKeyStr = bizEntryKey.toString().substring(0, bizEntryKey.length() - 1);
            String bizSelector = this.getBizBillSelector(fieldMappingResult.getBizFieldSet());
            if (!bizSelector.contains(bizEntryKeyStr)) {
                bizSelector = bizSelector + "," + bizEntryKeyStr;
            }
            String filter = rule.getString("filter_tag");
            checker.setBizSelector(bizSelector);
            checker.setFilterStr(filter);
            Map<Long, String> checkErrorInfos = checker.doCheckErrorInfo();
            if (this.isAuditCheck) {
                this.removeIgnoreBillIds(checkErrorInfos);
            }
            unValidIdMap.putAll(checkErrorInfos);
            idSet.removeAll(checkErrorInfos.keySet());
            Map<Long, DynamicObjectCollection> validEntryMaps = this.getValidEntrys(rule, idSet, bizSelector, bizEntryKeyStr);
            this.getbillOwnerMap(billOwnerMap, ownerkey, validEntryMaps);
            for (Map.Entry<Long, DynamicObjectCollection> entry : validEntryMaps.entrySet()) {
                DynamicObject billentry;
                long ownerId;
                DynamicObjectCollection costAccColl;
                long billId = entry.getKey();
                DynamicObjectCollection bizBillColl = entry.getValue();
                if (bizBillColl.isEmpty()) continue;
                boolean isAddBillIdSucess = genCalEntityBizBillIdStrs.add(calBillNumber + billId);
                if (!isAddBillIdSucess) {
                    mulRuleBillIds.add(billId);
                }
                Set<String> exFieldSet = this.dealExFieldSet(rule);
                Map<Field, Field> headMapping = fieldMappingResult.getHeadmap();
                Map<Field, Field> entryMapping = fieldMappingResult.getEntrymap();
                HashSet<Long> ownerIds = new HashSet<Long>(16);
                Iterator iterator = bizBillColl.iterator();
                while (iterator.hasNext() && SynBizBillHelper.verifyCostAccount((DynamicObjectCollection)(costAccColl = this.getAllCostAccount(ownerId = (billentry = (DynamicObject)iterator.next()).getLong(ownerkey))), (long)ownerId, (long)billId, ownerMap, AccEndInitMap, idSet, this.errMap, costAcc2StartPeriod, (DynamicObject)billentry)) {
                    ownerIds.add(ownerId);
                    DynamicObject calBill = (DynamicObject)ownerMapCalBill.get(billId + "," + ownerId);
                    if (calBill == null) {
                        calBill = this.setCalBillHead(ownerMapCalBill, calBillNumber, billId, headMapping, billentry, ownerId);
                        billCurrencyMap.put(calBill.getLong("bizbillid"), billentry.getLong("currency"));
                    }
                    this.setEntry(bizEntryKeyStr, exFieldSet, entryMapping, billentry, calBill);
                }
                for (Long ownerId2 : ownerIds) {
                    genIniBillNum += this.costAccountMap.get(ownerId2).size();
                }
            }
            genIniBillNum = this.verifyExistBill(idSet, ownerMapCalBill, billOwnerMap, billcountsMap, genIniBillNum);
        }
        if (genIniBillNum < 0) {
            genIniBillNum = 0;
        }
        IDGenerator initIdGenerator = new IDGenerator("t_cal_initbill");
        ArrayList<DynamicObject> initCalBills = new ArrayList<DynamicObject>(genIniBillNum);
        Map billIdErrMap = new MulCalBillSyncRuleHelper().removeMulRuleCalBill(mulRuleBillIds, ownerMapCalBill);
        this.errMap.putAll(billIdErrMap);
        for (Map.Entry entry : ownerMapCalBill.entrySet()) {
            String idKey = (String)entry.getKey();
            long billId = Long.parseLong(idKey.split(",")[0]);
            long ownerId = Long.parseLong(idKey.split(",")[1]);
            DynamicObjectCollection costAccounts = this.costAccountMap.get(ownerId);
            for (DynamicObject costAcc : costAccounts) {
                if (existInitBill.contains(billId + "," + costAcc.getLong("id"))) continue;
                initCalBills.add(this.newInitCalBill((DynamicObject)entry.getValue(), costAcc, initIdGenerator, costAcc2StartPeriod, calBillExratetableMap));
            }
        }
        HashSet<DynamicObject> saveBillSet = new HashSet<DynamicObject>(initCalBills.size());
        if (!initCalBills.isEmpty()) {
            DynamicObject[] dynamicObjectArray = initCalBills.toArray(new DynamicObject[0]);
            new AccountType4CostAdjustHelper(dynamicObjectArray).handleCalRangeAccType4InitBill(this.errMap);
            logger.info("SyncBizBill4AuditServiceProcess-\u5f00\u59cb\u4fdd\u5b58\u6838\u7b97\u5355\uff1a" + System.currentTimeMillis());
            SynBizBillHelper.handleInitBillStdCost((DynamicObject[])dynamicObjectArray, costAcc2Std, this.errMap, billCurrencyMap, calBillExratetableMap);
            StopSyncBizBillHelper stopSyncBizBillHelper = new StopSyncBizBillHelper();
            Map stopBizBillMap = stopSyncBizBillHelper.getStopSynMap4InitCal(dynamicObjectArray, true);
            if (!stopBizBillMap.isEmpty()) {
                this.errMap.putAll(stopBizBillMap);
            }
            for (DynamicObject bill : dynamicObjectArray) {
                if (this.errMap.containsKey(bill.getLong("bizbillid"))) continue;
                saveBillSet.add(bill);
            }
            if (!saveBillSet.isEmpty() && !this.isAuditCheck) {
                SaveServiceHelper.save((DynamicObject[])saveBillSet.toArray(new DynamicObject[0]));
            }
            logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u4fdd\u5b58\u6838\u7b97\u5355\uff1a" + System.currentTimeMillis());
        }
        this.submitAndAuditInitCalBills(saveBillSet);
        if (!unValidIdMap.isEmpty()) {
            for (Map.Entry entry : unValidIdMap.entrySet()) {
                this.errMap.put((Long)entry.getKey(), new SynBillErrInfo("5", (String)entry.getValue()));
                idSet.remove(entry.getKey());
            }
        }
    }

    private int verifyExistBill(Set<Long> idSet, Map<String, DynamicObject> ownerMapCalBill, Map<Long, Set<Long>> billOwnerMap, Map<Long, Integer> billcountsMap, int genIniBillNum) {
        for (Map.Entry<Long, Set<Long>> billOwnerEntry : billOwnerMap.entrySet()) {
            long billId = billOwnerEntry.getKey();
            if (billcountsMap.get(billId) == null) continue;
            Set<Long> ownerSet = billOwnerEntry.getValue();
            int genBills = 0;
            for (Long ownerId : ownerSet) {
                if (this.costAccountMap.get(ownerId) == null) continue;
                genBills += this.costAccountMap.get(ownerId).size();
            }
            if (genBills != billcountsMap.get(billId)) continue;
            String msg = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u4ecd\u5b58\u5728\u540c\u6b65\u751f\u6210\u7684\u521d\u59cb\u6838\u7b97\u5355\u3002", (String)"CreateInitCalBillProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
            this.errMap.put(billId, new SynBillErrInfo("5", msg));
            idSet.remove(billId);
            genIniBillNum -= genBills;
            Iterator<Map.Entry<String, DynamicObject>> iter = ownerMapCalBill.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, DynamicObject> entry = iter.next();
                if (!entry.getKey().contains(String.valueOf(billId))) continue;
                iter.remove();
            }
            for (String key : ownerMapCalBill.keySet()) {
                if (!key.contains(String.valueOf(billId))) continue;
                ownerMapCalBill.remove(key);
            }
        }
        return genIniBillNum;
    }

    private void genExistBillSet(Map<Long, Integer> billcountsMap, Set<String> existInitBill, DynamicObjectCollection coll) {
        for (DynamicObject info : coll) {
            long bizBillId = info.getLong("bizbillid");
            Integer counts = billcountsMap.get(bizBillId);
            if (counts == null) {
                billcountsMap.put(bizBillId, 1);
            } else {
                counts = counts + 1;
                billcountsMap.put(bizBillId, counts);
            }
            existInitBill.add(bizBillId + "," + info.getLong("costaccount"));
        }
    }

    private void setEntry(String bizEntryKeyStr, Set<String> exFieldSet, Map<Field, Field> entryMapping, DynamicObject billentry, DynamicObject calBill) {
        DynamicObjectCollection entryCol = calBill.getDynamicObjectCollection("entryentity");
        DynamicObject calBillEntry = entryCol.addNew();
        calBillEntry.set("seq", (Object)entryCol.size());
        for (Map.Entry<Field, Field> entryMap : entryMapping.entrySet()) {
            calBillEntry.set(entryMap.getKey().getProperty(), billentry.get(entryMap.getValue().getTotalkey()));
        }
        if (StringUtils.isEmpty((String)bizEntryKeyStr)) {
            calBillEntry.set("bizbillentryid", billentry.get(this.bizbillentrykey + ".id"));
        } else {
            calBillEntry.set("bizbillentryid", billentry.get(bizEntryKeyStr));
        }
        calBillEntry.set("srcbizentityobject", (Object)this.bizbillentityname);
        this.exFieldMap.put(calBill.getLong("id"), exFieldSet);
    }

    private DynamicObject setCalBillHead(Map<String, DynamicObject> ownerMapCalBill, String calBillNumber, long billId, Map<Field, Field> headMapping, DynamicObject billentry, long ownerId) {
        DynamicObject calBill = BusinessDataServiceHelper.newDynamicObject((String)calBillNumber);
        for (Map.Entry<Field, Field> mapEntry : headMapping.entrySet()) {
            calBill.set(mapEntry.getKey().getTotalkey(), billentry.get(mapEntry.getValue().getTotalkey()));
        }
        calBill.set("bizbillid", billentry.get("id"));
        calBill.set("bizentityobject", (Object)this.bizEntityObject);
        calBill.set("billtype", (Object)BillTypeConstants.INITCAL_BILL);
        calBill.set("billstatus", (Object)"A");
        calBill.set("billno", billentry.get("billno"));
        ownerMapCalBill.put(billId + "," + ownerId, calBill);
        return calBill;
    }

    private Set<String> dealExFieldSet(DynamicObject rule) {
        HashSet<String> exFieldSet = new HashSet<String>(8);
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            boolean isExtendField = ruleEntry.getBoolean("isextendfield");
            if (!isExtendField) continue;
            String calFieldName = ruleEntry.getString("calfield");
            exFieldSet.add(calFieldName);
        }
        return exFieldSet;
    }

    private void getbillOwnerMap(Map<Long, Set<Long>> billOwnerMap, String ownerkey, Map<Long, DynamicObjectCollection> validEntryMaps) {
        for (Map.Entry<Long, DynamicObjectCollection> entry : validEntryMaps.entrySet()) {
            long billId = entry.getKey();
            Set ownerSet = billOwnerMap.computeIfAbsent(billId, k -> new HashSet(8));
            DynamicObjectCollection bizBillColl = entry.getValue();
            if (bizBillColl.isEmpty()) continue;
            for (DynamicObject billentry : bizBillColl) {
                ownerSet.add(billentry.getLong(ownerkey));
            }
        }
    }

    private DynamicObject newInitCalBill(DynamicObject calInitBill, DynamicObject costAccount, IDGenerator initIdGenerator, Map<Long, DynamicObject> costAcc2StartPeriod, Map<Long, Long> calBillExratetableMap) {
        Long costAccountId = costAccount.getLong("id");
        DynamicObject newInitBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_initbill");
        DynamicObjectUtils.copy((DynamicObject)calInitBill, (DynamicObject)newInitBill);
        Long id = initIdGenerator.getId();
        newInitBill.set("id", (Object)id);
        newInitBill.set("costaccount_id", (Object)costAccountId);
        newInitBill.set("calorg", (Object)costAccount.getLong("calorg"));
        newInitBill.set("calorg_id", (Object)costAccount.getLong("calorg"));
        newInitBill.set("period", (Object)costAcc2StartPeriod.get(costAccountId));
        newInitBill.set("localcurrency", costAccount.get("calpolicy.currency"));
        newInitBill.set("billstatus", (Object)"A");
        calBillExratetableMap.put(id, costAccount.getLong("calpolicy.exratetable"));
        IDGenerator eIdGenerator = new IDGenerator("t_cal_initbillentry");
        DynamicObjectCollection entrys = newInitBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            entry.set("id", (Object)eIdGenerator.getId());
        }
        return newInitBill;
    }

    protected void init(DynamicObject bizBill) {
        Long currtime = System.currentTimeMillis();
        logger.info("SyncBizBill4AuditServiceProcess-\u8fdb\u5165\u63d2\u4ef6-" + bizBill.getString("billno") + ":" + System.currentTimeMillis());
        this.bizbillentityname = bizBill.getDataEntityType().getName();
        this.bizbillentitytype = EntityMetadataCache.getDataEntityType((String)this.bizbillentityname);
        this.rules = this.getCalBillRules();
        this.bizbillentrykey = this.getEntryKey(this.bizbillentityname);
        this.calbilltypemap = new HashMap<String, CalBillInfo>();
        this.bizEntityObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id,number,name", (QFilter[])new QFilter("number", "=", (Object)this.bizbillentityname).toArray());
        logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u521d\u59cb\u5316\u65b9\u6cd5init\uff1a" + (currtime - System.currentTimeMillis()));
    }

    private CalBillInfo getCalBillInfo(String calBillNo) {
        CalBillInfo info = this.calbilltypemap.get(calBillNo);
        if (info == null) {
            info = new CalBillInfo(calBillNo);
            this.calbilltypemap.put(calBillNo, info);
        }
        return info;
    }

    private String getBizBillSelector(Collection<Field> bizFields) {
        StringBuilder bizSelectorsSb = new StringBuilder();
        for (Field bizField : bizFields) {
            bizSelectorsSb.append(bizField.getTotalkey()).append(',');
        }
        bizSelectorsSb.setLength(bizSelectorsSb.length() - 1);
        String fields = bizSelectorsSb.toString();
        if (!fields.contains(this.bizbillentrykey + ".id")) {
            fields = this.bizbillentrykey + ".id," + fields;
        }
        if (!"im_initbill".equals(this.bizbillentityname)) {
            fields = "id," + fields;
        }
        return fields;
    }

    private FieldMappingResult getFieldMapping(DynamicObject rule, String calBillNumber) {
        FieldMappingResult result = new FieldMappingResult();
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            String bizFieldName = ruleEntry.getString("sourcefield");
            if (StringUtils.isEmpty((String)bizFieldName)) continue;
            String calFieldName = ruleEntry.getString("calfield");
            CalBillInfo calBillInfo = this.getCalBillInfo(calBillNumber);
            IDataEntityProperty calEntity = calBillInfo.getType().findProperty(calFieldName);
            IDataEntityProperty bizEntity = this.bizbillentitytype.findProperty(bizFieldName.split("\\.")[0]);
            if (calEntity == null || bizEntity == null) continue;
            IDataEntityType parentyCalEntity = calEntity.getParent();
            IDataEntityType parentBizEntity = bizEntity.getParent();
            if (parentyCalEntity instanceof LinkEntryType || parentBizEntity instanceof LinkEntryType) continue;
            Field bizField = null;
            Field calField = parentyCalEntity instanceof EntryType ? new Field(calFieldName, true, calBillInfo.getEntrykey(), calEntity) : new Field(calFieldName, false, null, calEntity);
            bizField = parentBizEntity instanceof SubEntryType ? new Field(bizFieldName, true, this.bizbillentrykey + "." + parentBizEntity.getName(), bizEntity) : (parentBizEntity instanceof EntryType ? new Field(bizFieldName, true, this.bizbillentrykey, bizEntity) : new Field(bizFieldName, false, null, bizEntity));
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".owner")) {
                result.setOwnerField(bizField);
            }
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".companyorg")) {
                result.setCalOrgField(bizField);
            }
            result.addMapping(calField, bizField);
        }
        if (!result.hasOwnerField()) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u6620\u5c04\u89c4\u5219\u6ca1\u6709\u914d\u7f6e\u8d27\u4e3b\u5b57\u6bb5\u3002", (String)"SyncBizBill4AuditServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0]), calBillNumber);
            throw new KDBizException(msg);
        }
        return result;
    }

    protected Map<Long, DynamicObjectCollection> getValidEntrys(DynamicObject rule, Object bizBillID, String selectors, String bizEntryKey) {
        logger.info("SyncBizBill4AuditServiceProcess-\u5f00\u59cb\u8fc7\u6ee4\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\uff1a" + System.currentTimeMillis());
        String filter = rule.getString("filter_tag");
        QFilter[] qs = null;
        if (StringUtils.isNotEmpty((String)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            if (this.isAuditCheck) {
                for (SimpleFilterRow filterRow : filterCondition.getFilterRow()) {
                    if (!"billstatus".equals(filterRow.getFieldName())) continue;
                    filterRow.setCompareType("17");
                    FilterValue value = new FilterValue();
                    value.setId("dsfjoeiwf");
                    value.setValue((Object)"B");
                    filterRow.getValue().add(value);
                }
            }
            FilterBuilder filterBuilder = new FilterBuilder(this.bizbillentitytype, filterCondition);
            filterBuilder.buildFilter();
            QFilter qf = new QFilter("id", "in", bizBillID);
            qs = qf.and(filterBuilder.getQFilter()).toArray();
        } else {
            qs = new QFilter[]{new QFilter("id", "in", bizBillID)};
        }
        DynamicObjectCollection bizBillColl = QueryServiceHelper.query((String)this.bizbillentityname, (String)selectors, (QFilter[])qs);
        HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
        HashSet<Long> hasEntryIds = new HashSet<Long>(16);
        for (DynamicObject info : bizBillColl) {
            long id = info.getLong("id");
            DynamicObjectCollection coll = (DynamicObjectCollection)map.get(id);
            if (coll != null) {
                boolean isExist = false;
                if (!hasEntryIds.add(info.getLong(bizEntryKey))) {
                    isExist = true;
                }
                if (isExist) continue;
                coll.add((Object)info);
                continue;
            }
            coll = new DynamicObjectCollection();
            coll.add((Object)info);
            map.put(id, coll);
            hasEntryIds.add(info.getLong(bizEntryKey));
        }
        logger.info("SyncBizBill4AuditServiceProcess-\u7ed3\u675f\u8fc7\u6ee4\u7b26\u5408\u6761\u4ef6\u7684\u5206\u5f55\uff1a" + System.currentTimeMillis());
        return map;
    }

    private String getEntryKey(String entityname) {
        return SynBizBillHelper.getFirstEntryKeyByMatField((String)entityname, this.rules);
    }

    private Collection<DynamicObject> getCalBillRules() {
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)this.bizbillentityname);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)CALRULEFIELDS, (QFilter[])filter.toArray());
        HashSet<DynamicObject> billRuleSet = new HashSet<DynamicObject>(billRules.length);
        for (DynamicObject rull : billRules) {
            if (rull == null) continue;
            billRuleSet.add(rull);
        }
        return billRuleSet;
    }

    private DynamicObjectCollection getAllCostAccount(long ownerId) {
        DynamicObjectCollection accountcoll = this.costAccountMap.get(ownerId);
        if (accountcoll == null) {
            DynamicObjectCollection coll = AccountingSysHelper.getAccountingSysCollsByOwner((Long)ownerId, null);
            QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            for (DynamicObject info : coll) {
                long calSystemId = info.getLong("id");
                long calOrgId = info.getLong("calorgid");
                QFilter q1 = new QFilter("calsystem", "=", (Object)calSystemId);
                q1.and("calorg", "=", (Object)calOrgId);
                q.or(q1);
            }
            q.and("status", "=", (Object)"C");
            q.and("enable", "=", (Object)"1");
            new CalGroupAccountHelper().addNotGroupAcctFilterSelf(q);
            accountcoll = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)COSTACCOUNTFIELDS, (QFilter[])q.toArray());
            this.costAccountMap.put(ownerId, accountcoll);
        }
        return accountcoll;
    }

    private void removeIgnoreBillIds(Map<Long, String> checkErrorInfos) {
        if (checkErrorInfos == null || checkErrorInfos.isEmpty()) {
            return;
        }
        String ignoreContent = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"CreateInitCalBillProcess_2", (String)"fi-cal-business", (Object[])new Object[0]);
        HashSet<Long> ignoreBillIds = new HashSet<Long>(16);
        for (Map.Entry<Long, String> checkErrorInfo : checkErrorInfos.entrySet()) {
            if (!checkErrorInfo.getValue().contains(ignoreContent)) continue;
            ignoreBillIds.add(checkErrorInfo.getKey());
        }
        for (Long id : ignoreBillIds) {
            checkErrorInfos.remove(id);
        }
    }

    private void submitAndAuditInitCalBills(Set<DynamicObject> initCalBillDycs) {
        Boolean isCalInitBillAutoAudit = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CALINITBILL_AUTO_AUDIT);
        if (!isCalInitBillAutoAudit.booleanValue() || initCalBillDycs.size() < 1) {
            return;
        }
        HashSet<Long> calInitBillIds = new HashSet<Long>(16);
        for (DynamicObject calInitBillDyc : initCalBillDycs) {
            calInitBillIds.add(calInitBillDyc.getLong("id"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        option.setVariableValue("notcheckmatinvinfo", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"cal_initbill", (Object[])calInitBillIds.toArray(new Object[0]), (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u521d\u59cb\u6838\u7b97\u5355\u63d0\u4ea4\u5931\u8d25\uff1a", (String)"CreateInitCalBillProcess_3", (String)"fi-cal-business", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            msg.append(result.getMessage()).append('\n');
            throw new KDBizException(msg.toString());
        }
        result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_initbill", (Object[])calInitBillIds.toArray(new Object[0]), (OperateOption)option);
        errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u521d\u59cb\u6838\u7b97\u5355\u5ba1\u6838\u5931\u8d25\uff1a", (String)"CreateInitCalBillProcess_4", (String)"fi-cal-business", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            msg.append(result.getMessage()).append('\n');
            throw new KDBizException(msg.toString());
        }
    }
}

