/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.DeleteCalBillHelper;
import kd.fi.cal.business.process.inner.SyncOpLegalChecker;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.CommonUtils;

public class DeleteCostRecordServiceProcess
extends AbstractBizProcessor {
    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return;
        }
        SyncOpLegalChecker opCheck = new SyncOpLegalChecker(bizBills, ActionEnum.UN_SUBMIT.getValue());
        opCheck.setParams(params);
        opCheck.doCheck();
        for (Map.Entry<Long, SynBillErrInfo> entry : opCheck.getErrMap().entrySet()) {
            this.addErrorMsg(entry.getKey(), entry.getValue());
        }
        bizBills = opCheck.getSuccessOpBizBillDycs().values().toArray(new DynamicObject[0]);
        if (bizBills.length < 1) {
            return;
        }
        new DeleteCalBillHelper().deleteCalBills(bizBills);
        this.setChargeOffInfo(bizBills);
    }

    private void setChargeOffInfo(DynamicObject[] bizBills) {
        String bizbillentityname = bizBills[0].getDataEntityType().getName();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)bizbillentityname);
        if (!entityType.getProperties().containsKey((Object)"ischargeoff")) {
            return;
        }
        String updateInCalBillSql = "update t_cal_incalbill set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ?";
        String updateOutCalBillSql = "update t_cal_outcalbill set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ?";
        String updateCostRecordSql = "update t_cal_calcostrecord set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ?";
        HashSet<Long> chargeOffedIdSet = new HashSet<Long>(16);
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (DynamicObject item : bizBills) {
            bizBillIds.add((Long)item.getPkValue());
        }
        QFilter chargeOffQ = new QFilter("id", "in", bizBillIds);
        chargeOffQ.and("ischargeoff", "=", (Object)"1");
        try (DataSet chargeOffInfos = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)bizbillentityname, (String)"billentry.srcbillid", (QFilter[])chargeOffQ.toArray(), null);){
            if (chargeOffInfos.isEmpty()) {
                return;
            }
            for (Row row : chargeOffInfos) {
                chargeOffedIdSet.add(row.getLong("billentry.srcbillid"));
            }
        }
        for (Long chargeOffedId : chargeOffedIdSet) {
            updateParams.add(new Object[]{0L, bizbillentityname, chargeOffedId});
        }
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateInCalBillSql, updateParams);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateOutCalBillSql, updateParams);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateCostRecordSql, updateParams);
        }
    }
}

