/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;

public class DeleteDischargeVoucherProcess
extends AbstractBizProcessor {
    /*
     * Loose catch block
     */
    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        DynamicObject[] vouchers;
        Object curPeriodId = params.get("curPeriod");
        Object costAccountId = params.get("costAccount");
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingle(curPeriodId, (String)"bd_period");
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", costAccountId)});
        QFilter q = new QFilter("periodid", "=", curPeriodId);
        q.and("vouchertype", "=", (Object)"C");
        q.and("createmode", "=", (Object)1);
        q.and("dischargetype", "=", (Object)"B");
        q.and("vouchersource", "=", (Object)"B");
        q.and("costaccount", "=", costAccountId);
        HashMap<Long, Long> tempVoucherIdMap = new HashMap<Long, Long>();
        HashSet<Long> dischargeVoucherIdSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"costrecordid,voucherid", (QFilter[])new QFilter[]{q}, null);){
            for (Row row : dataSet) {
                long tempVoucherId = row.getLong("costrecordid");
                long dischargeVoucherId = row.getLong("voucherid");
                tempVoucherIdMap.put(dischargeVoucherId, tempVoucherId);
                dischargeVoucherIdSet.add(dischargeVoucherId);
            }
        }
        if (dischargeVoucherIdSet.isEmpty()) {
            return;
        }
        MainEntityType voucherEntityType = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        for (DynamicObject dischargeVoucher : vouchers = BusinessDataServiceHelper.load((Object[])dischargeVoucherIdSet.toArray(), (DynamicObjectType)voucherEntityType)) {
            Throwable throwable;
            TXHandle h;
            String msg;
            block58: {
                block59: {
                    block56: {
                        block57: {
                            block54: {
                                block55: {
                                    OperationResult result;
                                    List errors;
                                    msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u671f\u95f4\u201c%2$s\u201d\u53cd\u7ed3\u8d26\uff0c\u51b2\u56de\u51ed\u8bc1\u201c%3$s\u201d\u5220\u9664\u5931\u8d25\u3002", (String)"DeleteDischargeVoucherProcess_6", (String)"fi-cal-business", (Object[])new Object[0]), costAccount.getString("number"), curPeriod.getString("number"), dischargeVoucher.getString("billno"));
                                    h = TX.requiresNew();
                                    throwable = null;
                                    String billStatus = dischargeVoucher.getString("billstatus");
                                    if (!"C".equals(billStatus) || (errors = (result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"gl_voucher", (DynamicObject[])new DynamicObject[]{dischargeVoucher})).getAllErrorOrValidateInfo()).isEmpty()) break block54;
                                    for (IOperateInfo error : errors) {
                                        OperateInfo operror = (OperateInfo)error;
                                        String msg1 = String.format(ResManager.loadKDString((String)"%1$s\uff08\u51ed\u8bc1\u53cd\u5ba1\u6838\u5931\u8d25\uff09%2$s", (String)"DeleteDischargeVoucherProcess_4", (String)"fi-cal-business", (Object[])new Object[0]), msg, operror.getMessage());
                                        this.addErrorMsg(msg1);
                                    }
                                    if (h == null) continue;
                                    if (throwable == null) break block55;
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    continue;
                                }
                                h.close();
                                continue;
                            }
                            OperateOption op = OperateOption.create();
                            op.setVariableValue("mechanism", "true");
                            op.setVariableValue("ignoreDapValidator", "true");
                            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])new Object[]{dischargeVoucher.getLong("id")}, (OperateOption)op);
                            List errors = result.getAllErrorOrValidateInfo();
                            if (errors.isEmpty()) break block56;
                            for (IOperateInfo error : errors) {
                                OperateInfo operror = (OperateInfo)error;
                                String msg2 = String.format(ResManager.loadKDString((String)"%1$s\uff08\u51ed\u8bc1\u5220\u9664\u5931\u8d25\uff09%2$s", (String)"DeleteDischargeVoucherProcess_5", (String)"fi-cal-business", (Object[])new Object[0]), msg, operror.getMessage());
                                this.addErrorMsg(msg2);
                            }
                            if (h == null) continue;
                            if (throwable == null) break block57;
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h.close();
                        continue;
                    }
                    try {
                        this.deleteDapTracks(dischargeVoucher);
                    }
                    catch (Exception e) {
                        h.markRollback();
                        this.addErrorMsg(msg + this.getErrorMsg(e));
                        if (h == null) continue;
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        h.close();
                        continue;
                    }
                    if (h == null) break block58;
                    if (throwable == null) break block59;
                    try {
                        h.close();
                    }
                    catch (Throwable e) {
                        throwable.addSuppressed(e);
                    }
                    break block58;
                }
                h.close();
                break block58;
                catch (Throwable e) {
                    try {
                        throwable = e;
                        throw e;
                    }
                    catch (Throwable throwable5) {
                        if (h != null) {
                            if (throwable != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                h.close();
                            }
                        }
                        throw throwable5;
                    }
                }
            }
            h = TX.requiresNew();
            throwable = null;
            try {
                try {
                    this.deleteCalVoucher(dischargeVoucher);
                    this.handleCostRecord((Long)tempVoucherIdMap.get(dischargeVoucher.getLong("id")));
                }
                catch (Exception e) {
                    h.markRollback();
                    this.addErrorMsg(msg + this.getErrorMsg(e));
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
    }

    private void deleteCalVoucher(DynamicObject voucher) {
        QFilter q = new QFilter("voucherid", "=", (Object)voucher.getLong("id"));
        DeleteServiceHelper.delete((String)"cal_voucher", (QFilter[])new QFilter[]{q});
    }

    private void handleCostRecord(long tempVoucherId) {
        DynamicObject[] costRecords;
        QFilter q = new QFilter("voucherid", "=", (Object)tempVoucherId);
        HashSet<Long> costRecordIdSet = new HashSet<Long>();
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"costrecordid,voucherid", (QFilter[])new QFilter[]{q}, null);){
            for (Row row : dataSet) {
                costRecordIdSet.add(row.getLong("costrecordid"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        if (costRecordIdSet.isEmpty()) {
            return;
        }
        for (DynamicObject costRecord : costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"id,isvoucher,issplit,istempvoucher,isdischargevoucher,dischargevouchernum,dischargevoucherid", (QFilter[])new QFilter[]{new QFilter("id", "in", costRecordIdSet)})) {
            boolean isSplit = costRecord.getBoolean("issplit");
            if (!isSplit) {
                costRecord.set("istempvoucher", (Object)true);
                costRecord.set("isvoucher", (Object)true);
            }
            costRecord.set("isdischargevoucher", (Object)false);
            costRecord.set("dischargevouchernum", null);
            costRecord.set("dischargevoucherid", null);
        }
        SaveServiceHelper.save((DynamicObject[])costRecords);
    }

    private void deleteDapTracks(DynamicObject voucher) {
        QFilter q = new QFilter("voucherid", "=", (Object)voucher.getLong("id"));
        DeleteServiceHelper.delete((String)"ai_daptracker", (QFilter[])new QFilter[]{q});
    }
}

