/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;

public class EstimateAdjustInPurValidator {
    private Set<String> purchaseBills = CommonSettingHelper.getBizEntityNumbers((String)"purbiztype");

    public DataSet filterQueryData(DataSet costRecords, int yearPeriod) {
        if (costRecords == null || costRecords.copy().isEmpty()) {
            return costRecords;
        }
        ArrayList<Long> legalCostRecordIds = new ArrayList<Long>(16);
        ArrayList<Long> otherCostRecordIds = new ArrayList<Long>(16);
        for (Row costRecord : costRecords.copy()) {
            String calbilltype = costRecord.getString("calbilltype");
            String bizObject = costRecord.getString("bizentityobject");
            Long calOrgId = costRecord.getLong("calorg.id");
            if (this.purchaseBills.contains(bizObject) && "IN".equals(calbilltype)) {
                if (this.getEstimateSetting(calOrgId).booleanValue()) continue;
                legalCostRecordIds.add(costRecord.getLong("id"));
                continue;
            }
            otherCostRecordIds.add(costRecord.getLong("id"));
        }
        DataSet omInPurchaseCostRecord = null;
        DataSet otherCostRecord = null;
        if (!legalCostRecordIds.isEmpty()) {
            omInPurchaseCostRecord = costRecords.copy().filter(new QFilter("id", "in", legalCostRecordIds).toString());
        }
        if (!otherCostRecordIds.isEmpty()) {
            otherCostRecord = costRecords.copy().filter(new QFilter("id", "in", otherCostRecordIds).toString());
        }
        if (legalCostRecordIds.isEmpty() && otherCostRecordIds.isEmpty()) {
            RowMeta rowMeta = costRecords.getRowMeta();
            return Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
        }
        HashSet<Long> costRecordIds = new HashSet<Long>(16);
        if (omInPurchaseCostRecord != null) {
            for (Row costRecord : omInPurchaseCostRecord.copy()) {
                long costRecordId = costRecord.getLong("id");
                costRecordIds.add(costRecordId);
            }
        }
        ArrayList<Long> illegalCostRecordIds = new ArrayList<Long>(16);
        if (omInPurchaseCostRecord != null && !omInPurchaseCostRecord.copy().isEmpty()) {
            QFilter bizObjectFilter = new QFilter("entryentity.invbizentityobject", "=", (Object)"cal_costrecord");
            QFilter idFilter = new QFilter("entryentity.invbillid", "in", costRecordIds);
            QFilter createTypeFilter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue());
            String costAdjustSelect = "id,checkstrikeaccount,createtype,bookdate,entryentity.id,entryentity.invbillid,entryentity.invbillentryid,entryentity.invbizentityobject";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costadjust_subentity", (String)costAdjustSelect, (QFilter[])new QFilter[]{bizObjectFilter, idFilter, createTypeFilter}, null);
            for (Row costAdjust : dataSet) {
                Date bookdate = costAdjust.getDate("bookdate");
                long costRecordId = costAdjust.getLong("entryentity.invbillid");
                int curPeriod = DateUtils.getMonth((Date)bookdate);
                int curYear = DateUtils.getYear((Date)bookdate);
                if (yearPeriod > curYear * 100 + curPeriod) continue;
                illegalCostRecordIds.add(costRecordId);
            }
        }
        if (omInPurchaseCostRecord != null) {
            costRecords = omInPurchaseCostRecord;
        }
        if (omInPurchaseCostRecord != null && !illegalCostRecordIds.isEmpty()) {
            costRecords = omInPurchaseCostRecord = omInPurchaseCostRecord.copy().filter(new QFilter("id", "not in", illegalCostRecordIds).toString());
        }
        if (otherCostRecord != null) {
            costRecords = omInPurchaseCostRecord != null ? omInPurchaseCostRecord.union(otherCostRecord) : otherCostRecord;
        }
        return costRecords;
    }

    private Boolean getEstimateSetting(Long calOrgId) {
        AppParam appParam = new AppParam("/KIUHEXROK3D", "10", calOrgId, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"ap_estimation") == null ? Boolean.FALSE : (Boolean)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"ap_estimation");
    }
}

