/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBillRuleCheckHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalStdcostdiffbillHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;

public class EstimateAdjustProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(EstimateAdjustProcess.class);
    private Set<String> omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
    private static final String QUERY_HEAD = "head";
    private static final String QUERY_ENTRY = "entry";
    private static final String COMMON_GROUP_ACCOUNTTYPE = "#@#";

    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) throws Exception {
        super.doProcessor(params, bizBills);
        logger.info("EstimateAdjustProcess-\u5f00\u59cb\u63d2\u4ef6\uff1a" + System.currentTimeMillis());
        if (bizBills.length == 0 || !"ap_busbill".equals(bizBills[0].getDataEntityType().getName())) {
            return;
        }
        List<DynamicObject> bizBillList = this.queryBizBIll(bizBills);
        logger.info("EstimateAdjustProcess-\u521d\u59cb\uff1a\u5355\u636e\u6761\u6570 " + bizBillList.size());
        AdjustEstimateInfo adjustEstimateInfo = new AdjustEstimateInfo();
        EstimateInfo estimateInfo = new EstimateInfo();
        ArrayList<DynamicObject> adjustEstimateBills = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> estimateBills = new ArrayList<DynamicObject>(16);
        HashMap<Long, DynamicObject> bizBillMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject bizBill : bizBillList) {
            boolean isadjust = bizBill.getBoolean("isadjust");
            if (isadjust) {
                adjustEstimateBills.add(bizBill);
            } else {
                estimateBills.add(bizBill);
            }
            long id = bizBill.getLong("id");
            bizBillMap.put(id, bizBill);
        }
        List<DynamicObject> adjustEstimateCostRecords = this.getAdjustEstimateCostRecord(adjustEstimateBills, adjustEstimateInfo);
        List<DynamicObject> estimateCostRecords = this.getEstimateCostRecord(estimateBills, estimateInfo);
        Set<Long> adjustEstimateCostAccountId = this.getCostRecordInfo(adjustEstimateCostRecords, adjustEstimateInfo.adjustEstimatePurchaseIdAndCostRecord, adjustEstimateInfo.adjustEstimatePurchaseEntryIdAndCostRecordEntry);
        Set<Long> estimateCostAccountId = this.getCostRecordInfo(estimateCostRecords, estimateInfo.estimatePurchaseIdAndCostRecord, estimateInfo.estimatePurchaseEntryIdAndCostRecordEntry);
        logger.info("EstimateAdjustProcess-\u67e5\u8be2\u5bf9\u5e94\u6210\u672c\u8bb0\u5f55\uff0c\u51b2\u56de\u5355\uff1a" + (adjustEstimateBills.isEmpty() ? "" : (bizBillMap.get(((DynamicObject)adjustEstimateBills.get(0)).getLong("id")) == null ? "" : ((DynamicObject)bizBillMap.get(((DynamicObject)adjustEstimateBills.get(0)).getLong("id"))).getString("billno")) + " | " + adjustEstimateCostAccountId.size()));
        logger.info("EstimateAdjustProcess-\u67e5\u8be2\u5bf9\u5e94\u6210\u672c\u8bb0\u5f55\uff0c\u91cd\u4f30\u5355\uff1a" + (estimateBills.isEmpty() ? "" : (bizBillMap.get(((DynamicObject)estimateBills.get(0)).getLong("id")) == null ? "" : ((DynamicObject)bizBillMap.get(((DynamicObject)estimateBills.get(0)).getLong("id"))).getString("billno")) + " | " + estimateBills.size()));
        HashSet<Long> allCostAccountIds = new HashSet<Long>(16);
        allCostAccountIds.addAll(adjustEstimateCostAccountId);
        allCostAccountIds.addAll(estimateCostAccountId);
        Map<Long, DynamicObject> costAccountMap = this.getCostAccount(allCostAccountIds);
        List<DynamicObject> legalBizBills = this.validateData(bizBillMap, adjustEstimateCostAccountId, estimateCostAccountId, adjustEstimateInfo, estimateInfo);
        logger.info("EstimateAdjustProcess-\u6821\u9a8c\u7ed3\u679c\uff1a\u5355\u636e\u6761\u6570 " + legalBizBills.size());
        HashMap<String, DynamicObject> newCalAdjustBillMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> newCalStdcostdiffBillMap = new HashMap<String, DynamicObject>(16);
        HashSet<Long> wfMarked_costAdjust = new HashSet<Long>(16);
        HashSet<Long> succBizEntryIds = new HashSet<Long>(16);
        for (DynamicObject bizBill : legalBizBills) {
            boolean isadjust = bizBill.getBoolean("isadjust");
            Long apId = bizBill.getLong("id");
            DynamicObjectCollection bizBillEntrys = bizBill.getDynamicObjectCollection(QUERY_ENTRY);
            for (DynamicObject bizBillEntry : bizBillEntrys) {
                DynamicObject costRecord;
                Set<DynamicObject> costRecordEntryList;
                Set<Long> purchaseEntryIds;
                long entryId = bizBillEntry.getLong("id");
                BigDecimal bizQty = bizBillEntry.getBigDecimal("e_baseunitqty");
                BigDecimal[] standbyPrice = new BigDecimal[3];
                BigDecimal bizPrice = bizBillEntry.getBigDecimal("e_localamt").divide(bizQty, 10, RoundingMode.HALF_UP);
                BigDecimal taxAmtPrice = bizBillEntry.getBigDecimal("e_pricetaxtotalbase").divide(bizQty, 10, RoundingMode.HALF_UP);
                BigDecimal intercostamtPrice = bizBillEntry.getBigDecimal("intercostamt") == null ? BigDecimal.ZERO : bizBillEntry.getBigDecimal("intercostamt").divide(bizQty, 10, RoundingMode.HALF_UP);
                standbyPrice[0] = bizPrice;
                standbyPrice[1] = taxAmtPrice;
                standbyPrice[2] = intercostamtPrice;
                if (isadjust) {
                    if (this.isLastAdjustEstimate(bizBillEntry, adjustEstimateInfo)) {
                        purchaseEntryIds = adjustEstimateInfo.adjustEstimateEntryIdAndPurchaseEntryId.get(entryId);
                        for (Long purchaseEntryId : purchaseEntryIds) {
                            costRecordEntryList = adjustEstimateInfo.adjustEstimatePurchaseEntryIdAndCostRecordEntry.get(purchaseEntryId);
                            if (costRecordEntryList == null || costRecordEntryList.isEmpty()) continue;
                            for (DynamicObject costRecordEntry : costRecordEntryList) {
                                BigDecimal adjustamt;
                                costRecord = (DynamicObject)costRecordEntry.getParent();
                                String createType = CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue();
                                List<DynamicObject> estimateCostAdjusts = this.getAdjustEstimateCostAdjust(adjustEstimateInfo, entryId, costRecord, Boolean.FALSE, createType);
                                List<DynamicObject> adjustEstimateCostAdjusts = this.getAdjustEstimateCostAdjust(adjustEstimateInfo, entryId, costRecord, Boolean.TRUE, createType);
                                BigDecimal estimateSum = BigDecimal.ZERO;
                                BigDecimal adjustEstimateSum = BigDecimal.ZERO;
                                for (DynamicObject estimateCostAdjust : estimateCostAdjusts) {
                                    adjustamt = estimateCostAdjust.getBigDecimal("entryentity.adjustamt") == null ? BigDecimal.ZERO : estimateCostAdjust.getBigDecimal("entryentity.adjustamt");
                                    estimateSum = estimateSum.add(adjustamt);
                                }
                                for (DynamicObject adjustEstimateCostAdjust : adjustEstimateCostAdjusts) {
                                    adjustamt = adjustEstimateCostAdjust.getBigDecimal("entryentity.adjustamt") == null ? BigDecimal.ZERO : adjustEstimateCostAdjust.getBigDecimal("entryentity.adjustamt");
                                    adjustEstimateSum = adjustEstimateSum.add(adjustamt);
                                }
                                BigDecimal adjustamt2 = estimateSum.add(adjustEstimateSum).multiply(new BigDecimal("-1"));
                                if (adjustamt2.compareTo(BigDecimal.ZERO) != 0) {
                                    long costRecordId = costRecord.getLong("id");
                                    String accountType = costRecordEntry.getString("accounttype");
                                    if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                                        accountType = COMMON_GROUP_ACCOUNTTYPE;
                                    }
                                    String key = costRecordId + "#" + accountType + "#" + apId;
                                    DynamicObject costAdjustHead = null;
                                    costAdjustHead = AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) ? (DynamicObject)newCalStdcostdiffBillMap.get(key) : (DynamicObject)newCalAdjustBillMap.get(key);
                                    if (costAdjustHead == null) {
                                        if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                                            costAdjustHead = this.createCostAdjustHead(costRecord, bizBill, accountType, Boolean.FALSE, Boolean.TRUE);
                                            newCalStdcostdiffBillMap.put(key, costAdjustHead);
                                        } else {
                                            costAdjustHead = this.createCostAdjustHead(costRecord, bizBill, accountType, Boolean.FALSE, Boolean.FALSE);
                                            newCalAdjustBillMap.put(key, costAdjustHead);
                                        }
                                    }
                                    DynamicObject newEntry = this.addCostAdjustBillEntry(costRecord, costRecordEntry, bizBill, bizBillEntry, adjustEstimateInfo, costAdjustHead);
                                    newEntry.set("adjustamt", (Object)adjustamt2);
                                }
                                succBizEntryIds.add(entryId);
                            }
                        }
                        continue;
                    }
                    purchaseEntryIds = adjustEstimateInfo.adjustEstimateEntryIdAndPurchaseEntryId.get(entryId = this.getTargetId(adjustEstimateInfo.wfAdjustEstimateEntryId_AdjustEstimateEntryId, entryId).longValue());
                    if (purchaseEntryIds == null || purchaseEntryIds.isEmpty()) continue;
                    for (Long purchaseEntryId : purchaseEntryIds) {
                        costRecordEntryList = adjustEstimateInfo.adjustEstimatePurchaseEntryIdAndCostRecordEntry.get(purchaseEntryId);
                        if (costRecordEntryList == null || costRecordEntryList.isEmpty()) continue;
                        for (DynamicObject costRecordEntry : costRecordEntryList) {
                            costRecord = (DynamicObject)costRecordEntry.getParent();
                            this.createCostAdjust(costAccountMap, newCalAdjustBillMap, newCalStdcostdiffBillMap, wfMarked_costAdjust, bizBill, bizBillEntry, standbyPrice, bizQty, Boolean.TRUE, costRecord, costRecordEntry, adjustEstimateInfo);
                            succBizEntryIds.add(entryId);
                        }
                    }
                    continue;
                }
                purchaseEntryIds = estimateInfo.estimateBillEntryIdAndPurchaseEntryId.get(entryId);
                if (purchaseEntryIds == null || purchaseEntryIds.isEmpty()) continue;
                for (Long purchaseEntryId : purchaseEntryIds) {
                    costRecordEntryList = estimateInfo.estimatePurchaseEntryIdAndCostRecordEntry.get(purchaseEntryId);
                    if (costRecordEntryList == null || costRecordEntryList.isEmpty()) continue;
                    for (DynamicObject costRecordEntry : costRecordEntryList) {
                        costRecord = (DynamicObject)costRecordEntry.getParent();
                        this.createCostAdjust(costAccountMap, newCalAdjustBillMap, newCalStdcostdiffBillMap, null, bizBill, bizBillEntry, standbyPrice, bizQty, Boolean.FALSE, costRecord, costRecordEntry, null);
                        succBizEntryIds.add(entryId);
                    }
                }
            }
        }
        this.updateCostAdjustWfMark(wfMarked_costAdjust);
        this.invokeCostAdjustSaveAndAudit(newCalAdjustBillMap);
        logger.info("EstimateAdjustProcess-\u8c03\u6574\u5355\u751f\u6210\u6761\u6570\uff1a" + newCalAdjustBillMap.size());
        this.invokeStdcostdiffBillSaveAndAudit(newCalStdcostdiffBillMap);
        logger.info("EstimateAdjustProcess-\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u751f\u6210\u6761\u6570\uff1a" + newCalStdcostdiffBillMap.size());
        this.updateAPBillFinish(succBizEntryIds);
        logger.info("EstimateAdjustProcess-\u5e94\u4ed8\u5355\u56de\u5199\u91cd\u4f30\u6807\u8bc6\u6761\u6570\uff1a" + succBizEntryIds.size());
        logger.info("EstimateAdjustProcess-\u7ed3\u675f\u63d2\u4ef6\uff1a" + System.currentTimeMillis());
    }

    private void updateCostAdjustWfMark(Set<Long> wfMarked_costAdjust) {
        if (wfMarked_costAdjust != null && !wfMarked_costAdjust.isEmpty()) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Long bizId : wfMarked_costAdjust) {
                params.add(new Object[]{bizId});
            }
            try (TXHandle h = TX.requiresNew();){
                String sql = "update t_cal_costadjustbill set fischargeoffed = '1' where fid = ? ";
                DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, params);
            }
        }
    }

    private void createCostAdjust(Map<Long, DynamicObject> costAccountMap, Map<String, DynamicObject> newCalAdjustBillMap, Map<String, DynamicObject> newCalStdcostdiffBillMap, Set<Long> wfMarked_costAdjust, DynamicObject bizBill, DynamicObject bizBillEntry, BigDecimal[] standbyPrice, BigDecimal bizQty, boolean isAdjust, DynamicObject costRecord, DynamicObject costRecordEntry, AdjustEstimateInfo adjustEstimateInfo) {
        Map<Long, Boolean> adjustEstimateIdAndIsWf;
        Long costaccountId;
        DynamicObject costAccountDynamic;
        boolean supporttaxamt;
        String bizEntityObject = costRecord.getString("bizentityobject.number");
        BigDecimal purchasePrice = this.omInBills.contains(bizEntityObject) ? costRecordEntry.getBigDecimal("unitprocesscost") : costRecordEntry.getBigDecimal("unitmaterialcost");
        DynamicObject basecurrency = bizBill.getDynamicObject("basecurrency");
        int amtprecision = basecurrency.getInt("amtprecision");
        long apId = bizBill.getLong("id");
        BigDecimal bizPrice = standbyPrice[0];
        BigDecimal taxAmtPrice = standbyPrice[1];
        BigDecimal intercostamtPrice = standbyPrice[2];
        BigDecimal decidePrice = BigDecimal.ZERO.compareTo(intercostamtPrice) != 0 ? intercostamtPrice : ((supporttaxamt = (costAccountDynamic = costAccountMap.get(costaccountId = Long.valueOf(costRecord.getDynamicObject("costaccount").getLong("id")))).getBoolean("calpolicy.supporttaxamt")) ? taxAmtPrice : bizPrice);
        BigDecimal bizAmt = bizQty.multiply(decidePrice);
        if (!this.sameCurrency(costRecord, bizBill)) {
            bizAmt = this.convertAmount(costRecord, bizBill, costAccountMap, bizAmt);
        }
        BigDecimal diffAmt = bizAmt.abs().subtract(purchasePrice.multiply(bizQty).abs()).setScale(amtprecision, RoundingMode.HALF_UP);
        BigDecimal costRecordQty = costRecordEntry.getBigDecimal("baseqty");
        int signum = costRecordQty.signum();
        diffAmt = diffAmt.multiply(new BigDecimal(String.valueOf(signum)));
        boolean isWf = false;
        if (adjustEstimateInfo != null && (adjustEstimateIdAndIsWf = adjustEstimateInfo.adjustEstimateIdAndIsWf) != null && !adjustEstimateIdAndIsWf.isEmpty()) {
            isWf = adjustEstimateIdAndIsWf.get(apId);
        }
        if (isWf) {
            Set<Long> entryIds;
            Map<Long, Long> wfAdjustEstimateId_adjustEstimateId = adjustEstimateInfo.wfAdjustEstimateId_AdjustEstimateId;
            Long adjustEstimateId = wfAdjustEstimateId_adjustEstimateId.get(apId);
            Map<Long, Set<Long>> adjustEstimateIdAndEntryId = adjustEstimateInfo.adjustEstimateIdAndEntryId;
            if (adjustEstimateIdAndEntryId != null && !adjustEstimateIdAndEntryId.isEmpty() && (entryIds = adjustEstimateIdAndEntryId.get(adjustEstimateId)) != null && !entryIds.isEmpty()) {
                for (Long entryId : entryIds) {
                    Set<Long> costAdjustIds;
                    Map<Long, Set<Long>> srcEntryId_costAdjustId = adjustEstimateInfo.srcEntryId_costAdjustId;
                    if (srcEntryId_costAdjustId == null || srcEntryId_costAdjustId.isEmpty() || (costAdjustIds = srcEntryId_costAdjustId.get(entryId)) == null || costAdjustIds.isEmpty()) continue;
                    wfMarked_costAdjust.addAll(costAdjustIds);
                }
            }
        }
        if (isAdjust && !isWf && diffAmt.compareTo(BigDecimal.ZERO) != 0) {
            diffAmt = diffAmt.multiply(new BigDecimal("-1"));
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0) {
            long costRecordId = costRecord.getLong("id");
            String accountType = costRecordEntry.getString("accounttype");
            if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                accountType = COMMON_GROUP_ACCOUNTTYPE;
            }
            String key = costRecordId + "#" + accountType + "#" + apId;
            DynamicObject costAdjustHead = null;
            costAdjustHead = AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) ? newCalStdcostdiffBillMap.get(key) : newCalAdjustBillMap.get(key);
            if (costAdjustHead == null) {
                if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                    costAdjustHead = this.createCostAdjustHead(costRecord, bizBill, accountType, isWf, true);
                    newCalStdcostdiffBillMap.put(key, costAdjustHead);
                } else {
                    costAdjustHead = this.createCostAdjustHead(costRecord, bizBill, accountType, isWf, false);
                    newCalAdjustBillMap.put(key, costAdjustHead);
                }
            }
            DynamicObject newEntry = isAdjust ? this.addCostAdjustBillEntry(costRecord, costRecordEntry, bizBill, bizBillEntry, adjustEstimateInfo, costAdjustHead) : this.addCostAdjustBillEntry(costRecord, costRecordEntry, bizBill, bizBillEntry, null, costAdjustHead);
            newEntry.set("adjustamt", (Object)diffAmt);
        }
    }

    protected String getCostReorcdField(boolean hasCostDetail) {
        String costRecordEntity = "cal_costrecord";
        if (hasCostDetail) {
            costRecordEntity = "cal_costrecord_subentity";
        }
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)costRecordEntity);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        HashSet curSet = new HashSet(selectorsSet);
        curSet.add("id");
        curSet.add("entry.id");
        curSet.add("bizentityobject.number");
        curSet.add("costaccount");
        curSet.add("entry.bizbillentryid");
        curSet.add("entry.srcbillid");
        curSet.add("entry.noupdatecalfields");
        curSet.add("entry.stocktype");
        for (String o : curSet) {
            fields.append(o).append(',');
        }
        fields.append("costaccount.calpolicy.convertmode,");
        fields.append("entry.seq,");
        fields.append("costaccount.calpolicy.exratetable,");
        fields.append("entry.subentryentity.id,entry.subentryentityest.id");
        return fields.toString();
    }

    private List<DynamicObject> getAdjustEstimateCostAdjust(AdjustEstimateInfo adjustEstimateInfo, Long adjustEstimateEntryId, DynamicObject costRecord, boolean isadjust, String createType) {
        Map<Long, Set<Long>> bizEntryIdAndCostAccountId = adjustEstimateInfo.estimateIdEntryIdAndCostAccountId;
        Map<Long, Set<Long>> costAccountIdAndCostAdjustEntry = adjustEstimateInfo.costAccountIdAndCostAdjustEntry;
        Map<Long, DynamicObject> costAdjustEntryIdAndDynamic = adjustEstimateInfo.costAdjustEntryIdAndDynamic;
        Map<Long, Set<Long>> adjustEstimateEntryIdAndEstimateEntryId = adjustEstimateInfo.adjustEstimateEntryIdAndEstimateEntryId;
        ArrayList<DynamicObject> legalCostAdjust = new ArrayList<DynamicObject>(16);
        Set<Long> estimateEntryIds = adjustEstimateEntryIdAndEstimateEntryId.get(adjustEstimateEntryId);
        Long costRecordCostAccount = costRecord.getDynamicObject("costaccount").getLong("id");
        for (Long estimateEntryId : estimateEntryIds) {
            Set<Long> costAccountIds = bizEntryIdAndCostAccountId.get(estimateEntryId);
            if (costAccountIds == null || costAccountIds.isEmpty()) continue;
            for (Long costAccountId : costAccountIds) {
                Set<Long> costAdjustEntryIds;
                if (!this.sameLongValue(costRecordCostAccount, costAccountId) || (costAdjustEntryIds = costAccountIdAndCostAdjustEntry.get(costAccountId)) == null || costAdjustEntryIds.isEmpty()) continue;
                for (Long costAdjustEntryId : costAdjustEntryIds) {
                    DynamicObject costAdjustEntry = costAdjustEntryIdAndDynamic.get(costAdjustEntryId);
                    boolean checkstrikeaccount = costAdjustEntry.getBoolean("checkstrikeaccount");
                    String createtype = costAdjustEntry.getString("createtype");
                    long costAdjustEstimateEntryId = costAdjustEntry.getLong("entryentity.costestimatebillentryid");
                    if (!createType.equals(createtype) || checkstrikeaccount != isadjust || !this.sameLongValue(costAdjustEstimateEntryId, estimateEntryId)) continue;
                    legalCostAdjust.add(costAdjustEntry);
                }
            }
        }
        return legalCostAdjust;
    }

    private boolean sameLongValue(Long costAccount1, Long costAccount2) {
        return costAccount1 != null && costAccount1 != 0L && costAccount2 != null && costAccount2 != 0L && costAccount1.equals(costAccount2);
    }

    private Map<Long, DynamicObject> getCostAccount(Set<Long> costAccountIds) {
        HashMap<Long, DynamicObject> costAccountMap = new HashMap<Long, DynamicObject>(16);
        String costAccountField = "id,name,number,calpolicy,calpolicy.currency,calpolicy.currency.amtprecision,calpolicy.currency.priceprecision,dividebasis,calpolicy.currency.number,calpolicy.currency.name,calpolicy.convertmode,calpolicy.exratetable,calpolicy.calbycostelement,calpolicy.supporttaxamt,calorg,calorg.name,calorg.number";
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)costAccountField, (QFilter[])new QFilter[]{new QFilter("id", "in", costAccountIds)}, null);
        for (DynamicObject costAccount : costAccounts) {
            costAccountMap.put(costAccount.getLong("id"), costAccount);
        }
        return costAccountMap;
    }

    private BigDecimal convertAmount(DynamicObject costRecord, DynamicObject estimateBill, Map<Long, DynamicObject> costAccountMap, BigDecimal amount) {
        BigDecimal exchangeRate;
        long billLocalCurrencyId = estimateBill.getDynamicObject("basecurrency").getLong("id");
        long localCurrencyId = costRecord.getDynamicObject("localcurrency").getLong("id");
        Date date = estimateBill.getDate("bookdate");
        Long exratetable = estimateBill.getDynamicObject("exratetable").getLong("id");
        String convertMode = "1";
        String convertMode4TargetUSD = null;
        String convertMode4sourceUSD = null;
        BigDecimal exchangeRate4TargetUSD = null;
        BigDecimal exchangeRate4sourceUSD = null;
        DynamicObject costAccount = costAccountMap.get(costRecord.getDynamicObject("costaccount").getLong("id"));
        String errorhead = String.format(ResManager.loadKDString((String)"\u5728\u6210\u672c\u8d26\u7c3f\u3010%1$s\uff09\u3011\u4e0b\u751f\u6210\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5931\u8d25\uff1a", (String)"CostRecordBuilder_16", (String)"fi-cal-business", (Object[])new Object[0]), costAccount.getString("number") + "\uff08" + costAccount.getString("name"));
        int amtPrecision = 10;
        if (costAccount != null) {
            amtPrecision = costAccount.getInt("calpolicy.currency.amtprecision");
        }
        if (billLocalCurrencyId == 0L) {
            exchangeRate = BigDecimal.ONE;
        } else {
            boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)billLocalCurrencyId, (Long)localCurrencyId, (Date)date);
            if (isIndirect) {
                convertMode = "2";
            }
            exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)billLocalCurrencyId, (Long)localCurrencyId, (Long)exratetable, (Date)date, (boolean)isIndirect);
        }
        if (exchangeRate == null) {
            if (billLocalCurrencyId == 6L || localCurrencyId == 6L) {
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)billLocalCurrencyId, (String)"bd_currency");
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5355\u636e\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u518d\u91cd\u65b0\u6267\u884c\u3002", (String)"CostRecordBuilder_18", (String)"fi-cal-business", (Object[])new Object[0]), errorhead, currency.getString("name"), costAccount.getString("calpolicy.currency.name"));
                throw new KDBizException(msg);
            }
            boolean isIndirect4TargetUSD = BaseDataServiceHelper.getRateConversionConfig((Long)billLocalCurrencyId, (Long)6L, (Date)date);
            convertMode4TargetUSD = "1";
            if (isIndirect4TargetUSD) {
                convertMode4TargetUSD = "2";
            }
            exchangeRate4TargetUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)billLocalCurrencyId, (Long)6L, (Long)Long.valueOf(exratetable.toString()), (Date)date, (boolean)isIndirect4TargetUSD);
            boolean isIndirect4sourceUSD = BaseDataServiceHelper.getRateConversionConfig((Long)6L, (Long)localCurrencyId, (Date)date);
            convertMode4sourceUSD = "1";
            if (isIndirect4sourceUSD) {
                convertMode4sourceUSD = "2";
            }
            exchangeRate4sourceUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)6L, (Long)localCurrencyId, (Long)Long.valueOf(exratetable.toString()), (Date)date, (boolean)isIndirect4sourceUSD);
            if (exchangeRate4TargetUSD == null) {
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)billLocalCurrencyId, (String)"bd_currency");
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5355\u636e\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u5355\u636e\u672c\u4f4d\u5e01\u201c%4$s\u201d\u4e0e\u201c\u7f8e\u5143\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u518d\u91cd\u65b0\u6267\u884c\u3002", (String)"CostRecordBuilder_19", (String)"fi-cal-business", (Object[])new Object[0]), errorhead, currency.getString("name"), costAccount.getString("calpolicy.currency.name"), currency.getString("name"));
                throw new KDBizException(msg);
            }
            if (exchangeRate4sourceUSD == null) {
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)billLocalCurrencyId, (String)"bd_currency");
                String msg2 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5355\u636e\u672c\u4f4d\u5e01\u201c%2$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u201c\u7f8e\u5143\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%4$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u518d\u91cd\u65b0\u6267\u884c\u3002", (String)"CostRecordBuilder_20", (String)"fi-cal-business", (Object[])new Object[0]), errorhead, currency.getString("name"), costAccount.getString("calpolicy.currency.name"), costAccount.getString("calpolicy.currency.name"));
                throw new KDBizException(msg2);
            }
        }
        BigDecimal newAmount = amount;
        if (!this.sameCurrency(costRecord, estimateBill)) {
            newAmount = exchangeRate != null ? this.getTargetAmount(exchangeRate, convertMode, amount, amtPrecision) : this.getTargetAmount(exchangeRate4sourceUSD, convertMode4sourceUSD, this.getTargetAmount(exchangeRate4TargetUSD, convertMode4TargetUSD, amount, amtPrecision), amtPrecision);
        }
        return newAmount;
    }

    private BigDecimal getTargetAmount(BigDecimal exchangeRate, String convertMode, BigDecimal sourceAmount, int amtPrecision) {
        BigDecimal targetAmount = BigDecimal.ZERO;
        if (sourceAmount == null || sourceAmount.compareTo(BigDecimal.ZERO) == 0) {
            return targetAmount;
        }
        if (exchangeRate != null) {
            targetAmount = "1".equals(convertMode) ? sourceAmount.multiply(exchangeRate).setScale(amtPrecision, 4) : sourceAmount.divide(exchangeRate, amtPrecision, 4);
        }
        return targetAmount;
    }

    private void invokeStdcostdiffBillSaveAndAudit(Map<String, DynamicObject> newCalStdcostdiffBillMap) {
        if (newCalStdcostdiffBillMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> costAdjustList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, DynamicObject> mapEntry : newCalStdcostdiffBillMap.entrySet()) {
            costAdjustList.add(mapEntry.getValue());
        }
        String auditorId = ((DynamicObject)costAdjustList.get(0)).getString("auditor_id");
        SaveServiceHelper.save((DynamicObject[])costAdjustList.toArray(new DynamicObject[costAdjustList.size()]));
        HashSet<Long> set = new HashSet<Long>(costAdjustList.size());
        for (DynamicObject info : costAdjustList) {
            set.add(info.getLong("id"));
        }
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"));
        List<CostAdjustDetailParams> paramsList = this.buildCostAdjustDetail(costAdjusts);
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        if (!StringUtils.isEmpty((CharSequence)auditorId) && !"0".equals(auditorId)) {
            option.setVariableValue("auditor_id", auditorId);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (DynamicObject[])costAdjusts, (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff0c\u7cfb\u7edf\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurWriteOffServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]));
            if (!errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
            }
            msg.append(result.getMessage()).append('\n');
            throw new KDBizException(msg.toString());
        }
    }

    private void invokeCostAdjustSaveAndAudit(Map<String, DynamicObject> newCalAdjustBillMap) {
        if (newCalAdjustBillMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> costAdjustList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<String, DynamicObject> mapEntry : newCalAdjustBillMap.entrySet()) {
            costAdjustList.add(mapEntry.getValue());
        }
        String auditorId = ((DynamicObject)costAdjustList.get(0)).getString("auditor_id");
        SaveServiceHelper.save((DynamicObject[])costAdjustList.toArray(new DynamicObject[costAdjustList.size()]));
        HashSet<Long> set = new HashSet<Long>(costAdjustList.size());
        for (DynamicObject info : costAdjustList) {
            set.add(info.getLong("id"));
        }
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_costadjust_subentity"));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        if (!StringUtils.isEmpty((CharSequence)auditorId) && !"0".equals(auditorId)) {
            option.setVariableValue("auditor_id", auditorId);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjusts, (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff0c\u7cfb\u7edf\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurWriteOffServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]));
            if (!errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
            }
            msg.append(result.getMessage()).append('\n');
            throw new KDBizException(msg.toString());
        }
        PrevCostAdjustProcessHelper prevCostAdjustProcessHelper = new PrevCostAdjustProcessHelper();
        prevCostAdjustProcessHelper.dealOutAdjustSet(set);
    }

    private List<DynamicObject> validateData(Map<Long, DynamicObject> bizBillMap, Set<Long> adjustEstimateCostAccountId, Set<Long> estimateCostAccountId, AdjustEstimateInfo adjustEstimateInfo, EstimateInfo estimateInfo) {
        Map adjustCurrentPeriods = PeriodHelper.getCurrentPeriods(adjustEstimateCostAccountId);
        Map adjustStartPeriods = PeriodHelper.getStartPeriods(adjustEstimateCostAccountId);
        Map currentPeriods = PeriodHelper.getCurrentPeriods(estimateCostAccountId);
        Map startPeriods = PeriodHelper.getStartPeriods(estimateCostAccountId);
        ArrayList<DynamicObject> successBill = new ArrayList<DynamicObject>(16);
        if (!adjustEstimateInfo.adjustEstimateIdAndPurchaseId.isEmpty()) {
            List<DynamicObject> succAdjustEstimateBill = this.getLegalEstimateBill(bizBillMap, adjustEstimateInfo.adjustEstimateIdAndEstimateId, adjustCurrentPeriods, adjustStartPeriods, adjustEstimateInfo);
            successBill.addAll(succAdjustEstimateBill);
        }
        if (!estimateInfo.estimateBillIdAndPurchaseId.isEmpty()) {
            List<DynamicObject> succEstimateBill = this.getLegalEstimateBill(bizBillMap, null, currentPeriods, startPeriods, estimateInfo);
            successBill.addAll(succEstimateBill);
        }
        return successBill;
    }

    private List<DynamicObject> getLegalEstimateBill(Map<Long, DynamicObject> bizBillMap, Map<Long, Set<Long>> adjustEstimateIdAndEstimateId, Map<Long, DynamicObject> adjustCurrentPeriods, Map<Long, DynamicObject> adjustStartPeriods, Object info) {
        Map<Long, Set<Long>> srcEntryId_costAdjustId;
        Map<Long, Long> adjustEstimateId_wfAdjustEstimateId;
        Map<Long, DynamicObject> costAdjustEntryIdAndDynamic;
        Map<Long, Set<Long>> costAccountIdAndCostAdjustEntry;
        Map<Long, Set<Long>> estimateIdEntryIdAndCostAccountId;
        Map<Long, Set<Long>> estimateIdAndEntryId;
        Map<Long, Set<Long>> adjustEstimateIdAndEntryId;
        Map<Long, String> purchaseIdAndBillNo;
        Map<Long, List<DynamicObject>> purchaseIdAndCostRecord;
        Map<Long, Set<Long>> bizIdAndPurchaseId;
        if (adjustEstimateIdAndEstimateId != null && !adjustEstimateIdAndEstimateId.isEmpty()) {
            AdjustEstimateInfo adjustInfo = (AdjustEstimateInfo)info;
            bizIdAndPurchaseId = adjustInfo.adjustEstimateIdAndPurchaseId;
            purchaseIdAndCostRecord = adjustInfo.adjustEstimatePurchaseIdAndCostRecord;
            purchaseIdAndBillNo = adjustInfo.purchaseIdAndNumber;
            adjustEstimateIdAndEntryId = adjustInfo.adjustEstimateIdAndEntryId;
            estimateIdAndEntryId = adjustInfo.estimateIdAndEntryId;
            estimateIdEntryIdAndCostAccountId = adjustInfo.estimateIdEntryIdAndCostAccountId;
            costAccountIdAndCostAdjustEntry = adjustInfo.costAccountIdAndCostAdjustEntry;
            costAdjustEntryIdAndDynamic = adjustInfo.costAdjustEntryIdAndDynamic;
            adjustEstimateId_wfAdjustEstimateId = adjustInfo.adjustEstimateId_wfAdjustEstimateId;
            srcEntryId_costAdjustId = adjustInfo.srcEntryId_costAdjustId;
        } else {
            EstimateInfo estimateInfo = (EstimateInfo)info;
            bizIdAndPurchaseId = estimateInfo.estimateBillIdAndPurchaseId;
            purchaseIdAndCostRecord = estimateInfo.estimatePurchaseIdAndCostRecord;
            purchaseIdAndBillNo = estimateInfo.purchaseIdAndNumber;
            estimateIdAndEntryId = estimateInfo.estimateIdAndEntryId;
            adjustEstimateIdAndEntryId = new HashMap<Long, Set<Long>>(1);
            estimateIdEntryIdAndCostAccountId = null;
            costAccountIdAndCostAdjustEntry = null;
            costAdjustEntryIdAndDynamic = null;
            adjustEstimateId_wfAdjustEstimateId = null;
            srcEntryId_costAdjustId = null;
        }
        HashSet<Object> failAndWriteIsAllocateIds = new HashSet<Object>(16);
        HashSet<Long> failAndWriteIsAllocateEntryIds = new HashSet<Long>(16);
        HashSet<Object> failBizIds = new HashSet<Object>(16);
        HashSet<Long> failPurchaseIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> bizEntry : bizIdAndPurchaseId.entrySet()) {
            Long bizId = bizEntry.getKey();
            Set<Long> set = bizEntry.getValue();
            Long isWfBizId = this.getTargetId(adjustEstimateId_wfAdjustEstimateId, bizId);
            DynamicObject bizBill = bizBillMap.get(isWfBizId);
            Date bookdate = bizBill.getDate("bookdate");
            for (Long l : set) {
                List<DynamicObject> recordRecordList = purchaseIdAndCostRecord.get(l);
                if (recordRecordList == null || recordRecordList.isEmpty()) continue;
                for (DynamicObject costRecord : recordRecordList) {
                    Date startPeriod;
                    Long costAccountId = costRecord.getDynamicObject("costaccount") == null ? 0L : costRecord.getDynamicObject("costaccount").getLong("id");
                    Date currentPeriod = adjustCurrentPeriods.get(costAccountId) == null ? null : adjustCurrentPeriods.get(costAccountId).getDate("begindate");
                    Date date = startPeriod = adjustStartPeriods.get(costAccountId) == null ? null : adjustStartPeriods.get(costAccountId).getDate("begindate");
                    if (startPeriod == null || bookdate.before(startPeriod)) {
                        failAndWriteIsAllocateIds.add(bizId);
                        DynamicObjectCollection bizBillEntrys = bizBill.getDynamicObjectCollection(QUERY_ENTRY);
                        for (DynamicObject bizBillEntry : bizBillEntrys) {
                            failAndWriteIsAllocateEntryIds.add(bizBillEntry.getLong("id"));
                        }
                        this.addErrorMsg(bizId, "5", ResManager.loadKDString((String)"\u201c\u8bb0\u8d26\u65e5\u671f\u201d\u5c0f\u4e8e\u8d26\u7c3f\u7684\u201c\u542f\u7528\u671f\u95f4\u201d\uff0c\u751f\u6210\u5931\u8d25\u3002", (String)"CostEstimateBillAdjustProcess_3", (String)"fi-cal-business", (Object[])new Object[0]));
                    }
                    if (currentPeriod != null && !bookdate.before(currentPeriod)) continue;
                    failBizIds.add(bizId);
                    this.addErrorMsg(bizId, "5", ResManager.loadKDString((String)"\u201c\u8bb0\u8d26\u65e5\u671f\u201d\u5c0f\u4e8e\u8d26\u7c3f\u7684\u5f53\u671f\u671f\u95f4\uff0c\u751f\u6210\u5931\u8d25\u3002", (String)"CostEstimateBillAdjustProcess_1", (String)"fi-cal-business", (Object[])new Object[0]));
                }
            }
            if (!failAndWriteIsAllocateIds.isEmpty()) {
                for (Long l : failAndWriteIsAllocateIds) {
                    set.removeAll((Collection)bizIdAndPurchaseId.get(l));
                }
            }
            if (!failBizIds.isEmpty()) {
                for (Long l : failBizIds) {
                    set.removeAll((Collection)bizIdAndPurchaseId.get(l));
                }
            }
            CalBillRuleCheckHelper calBillRuleCheckHelper = new CalBillRuleCheckHelper("im_purinbill", set);
            calBillRuleCheckHelper.addSkipProperty("billstatus");
            Set set2 = calBillRuleCheckHelper.check();
            if (set2 == null || set2.isEmpty()) continue;
            for (Long curFailPurchaseId : set2) {
                failPurchaseIds.add(curFailPurchaseId);
            }
        }
        HashSet<Long> failSettingEstimateIds = new HashSet<Long>(16);
        HashSet<Long> failSettingEstimateEntryIds = new HashSet<Long>(16);
        if (!failPurchaseIds.isEmpty()) {
            for (Map.Entry entry : bizIdAndPurchaseId.entrySet()) {
                Long adjustEstimateId = (Long)entry.getKey();
                Iterator<Long> purchaseIds = (Set)entry.getValue();
                purchaseIds.removeAll(failPurchaseIds);
                if (purchaseIds.isEmpty()) {
                    failSettingEstimateIds.add(adjustEstimateId);
                    this.addErrorMsg(adjustEstimateId, "5", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4e0d\u6ee1\u8db3\u6838\u7b97\u5355\u914d\u7f6e\u7684\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"SyncBizBill4AuditServiceProcess_4", (String)"fi-cal-business", (Object[])new Object[0]));
                }
                DynamicObject bizBill = bizBillMap.get(adjustEstimateId);
                DynamicObjectCollection bizBillEntrys = bizBill.getDynamicObjectCollection(QUERY_ENTRY);
                for (Object bizBillEntry : bizBillEntrys) {
                    failSettingEstimateEntryIds.add(bizBillEntry.getLong("id"));
                }
            }
        }
        if (!failSettingEstimateIds.isEmpty()) {
            bizBillMap.keySet().removeAll(failSettingEstimateIds);
        }
        HashSet<Long> srcIds = new HashSet<Long>(16);
        HashSet<Long> hashSet = new HashSet<Long>(16);
        if (adjustEstimateIdAndEstimateId != null && !adjustEstimateIdAndEstimateId.isEmpty()) {
            Set<Long> adjustEstimateIds = bizIdAndPurchaseId.keySet();
            srcIds.addAll(adjustEstimateIds);
            for (Long adjustEstimateId : adjustEstimateIds) {
                Set<Long> set;
                Set<Long> adjustEstimateEntryIds = adjustEstimateIdAndEntryId.get(adjustEstimateId);
                if (adjustEstimateEntryIds != null && !adjustEstimateEntryIds.isEmpty()) {
                    hashSet.addAll(adjustEstimateEntryIds);
                }
                if ((set = adjustEstimateIdAndEstimateId.get(adjustEstimateId)) == null || set.isEmpty()) continue;
                srcIds.addAll(set);
                for (Long estimateId : set) {
                    Set<Long> estimateEntryIds = estimateIdAndEntryId.get(estimateId);
                    if (estimateEntryIds == null || estimateEntryIds.isEmpty()) continue;
                    hashSet.addAll(estimateEntryIds);
                }
            }
        } else {
            Set<Long> estimateIds = bizIdAndPurchaseId.keySet();
            srcIds.addAll(estimateIds);
            for (Long estimateId : estimateIds) {
                Set<Long> estimateEntryIds = estimateIdAndEntryId.get(estimateId);
                if (estimateEntryIds == null || estimateEntryIds.isEmpty()) continue;
                hashSet.addAll(estimateEntryIds);
            }
        }
        HashMap<Long, DynamicObject> srcIdAndCostAdjustMap = new HashMap<Long, DynamicObject>(16);
        QFilter srcFilter = new QFilter("entryentity.costestimatebillid", "in", srcIds);
        QFilter srcEntryFilter = new QFilter("entryentity.costestimatebillentryid", "in", hashSet);
        QFilter createTypeFilter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue());
        String string = "id,entryentity.id,costaccount,createtype,checkstrikeaccount,entryentity.srcbillid,entryentity.srcbillentryid,entryentity.costestimatebillid,entryentity.costestimatebillentryid,entryentity.adjustamt";
        DynamicObjectCollection costAdjusts = QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)string, (QFilter[])new QFilter[]{srcFilter, srcEntryFilter, createTypeFilter});
        DynamicObjectCollection stdcostdiffbills = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)string, (QFilter[])new QFilter[]{srcFilter, srcEntryFilter, createTypeFilter});
        if (costAdjusts != null && stdcostdiffbills != null) {
            costAdjusts.addAll(stdcostdiffbills);
        }
        if (costAdjusts != null && !costAdjusts.isEmpty()) {
            for (DynamicObject costAdjust : costAdjusts) {
                long id = costAdjust.getLong("id");
                long apId = costAdjust.getLong("entryentity.srcbillid");
                long apEntryId = costAdjust.getLong("entryentity.srcbillentryid");
                long srcbillentryid = costAdjust.getLong("entryentity.costestimatebillentryid");
                long costAccountId = costAdjust.getLong("costaccount");
                long costAdjustEntryId = costAdjust.getLong("entryentity.id");
                srcIdAndCostAdjustMap.put(apId, costAdjust);
                this.putMap(estimateIdEntryIdAndCostAccountId, srcbillentryid, costAccountId);
                this.putMap(costAccountIdAndCostAdjustEntry, costAccountId, costAdjustEntryId);
                this.putMap(srcEntryId_costAdjustId, apEntryId, id);
                if (costAdjustEntryIdAndDynamic == null) continue;
                costAdjustEntryIdAndDynamic.put(costAdjustEntryId, costAdjust);
            }
        }
        if (bizIdAndPurchaseId != null && !bizIdAndPurchaseId.isEmpty()) {
            for (Long bizId : bizIdAndPurchaseId.keySet()) {
                DynamicObject costAdjust = (DynamicObject)srcIdAndCostAdjustMap.get(bizId = this.getTargetId(adjustEstimateId_wfAdjustEstimateId, bizId));
                if (costAdjust == null) continue;
                failBizIds.add(bizId);
                String content = this.createErrMsg(bizBillMap, bizId);
                this.addErrorMsg(bizId, "5", content);
            }
        }
        if (!failAndWriteIsAllocateIds.isEmpty()) {
            if (!failAndWriteIsAllocateEntryIds.isEmpty()) {
                this.updateAPBillFinish(failAndWriteIsAllocateEntryIds);
            }
            bizBillMap.keySet().removeAll(failAndWriteIsAllocateIds);
        }
        if (!failBizIds.isEmpty()) {
            bizBillMap.keySet().removeAll(failBizIds);
        }
        if (!failSettingEstimateIds.isEmpty() && !failSettingEstimateEntryIds.isEmpty()) {
            this.updateAPBillFinish(failSettingEstimateEntryIds);
        }
        HashSet<DynamicObject> successBizBill = new HashSet<DynamicObject>(16);
        for (Map.Entry<Long, Set<Long>> entry : bizIdAndPurchaseId.entrySet()) {
            Long apBillId = entry.getKey();
            Set<Long> purchaseIds = entry.getValue();
            apBillId = this.getTargetId(adjustEstimateId_wfAdjustEstimateId, apBillId);
            DynamicObject adjustEstimateBill = bizBillMap.get(apBillId);
            for (Long purchaseId : purchaseIds) {
                List<DynamicObject> costRecord = purchaseIdAndCostRecord.get(purchaseId);
                if (costRecord == null || costRecord.isEmpty()) {
                    String purchaseBillNo = purchaseIdAndBillNo.get(purchaseId) == null ? "" : purchaseIdAndBillNo.get(purchaseId);
                    String content = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\uff0c\u8bf7\u67e5\u770b\u6838\u7b97\u4e1a\u52a1\u5904\u7406\u65e5\u5fd7\u6216\u7a0d\u540e\u91cd\u65b0\u6267\u884c\uff1a%1$s", (String)"AbstractWriteOffServiceProcess_3", (String)"fi-cal-business", (Object[])new Object[0]);
                    String msg = String.format(content, purchaseBillNo);
                    this.addErrorMsg(apBillId, "3", msg);
                    continue;
                }
                if (adjustEstimateBill == null) continue;
                successBizBill.add(adjustEstimateBill);
            }
        }
        return new ArrayList<DynamicObject>(successBizBill);
    }

    private Long getTargetId(Map<Long, Long> src_target_map, Long srcId) {
        if (src_target_map != null && src_target_map.containsKey(srcId)) {
            srcId = src_target_map.get(srcId);
        }
        return srcId;
    }

    private String createErrMsg(Map<Long, DynamicObject> bizBillMap, long adjustEstimateId) {
        DynamicObject bizBill = bizBillMap.get(adjustEstimateId);
        String billNo = "";
        if (bizBill != null) {
            billNo = bizBill.getString("billno");
        }
        String msg = ResManager.loadKDString((String)"%1$s\u91cd\u4f30\u5355\u5df2\u751f\u6210\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u3002\u8bf7\u68c0\u67e5\u6570\u636e", (String)"CostEstimateBillAdjustProcess_2", (String)"fi-cal-business", (Object[])new Object[0]);
        return String.format(msg, billNo);
    }

    private void updateAPBillFinish(Set<Long> bizBillIds) {
        if (bizBillIds == null || bizBillIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Long bizId : bizBillIds) {
            params.add(new Object[]{bizId});
        }
        try (TXHandle h = TX.requiresNew();){
            String sql = "update t_ap_busbillentry set fisallocate = '1' where fentryid = ? ";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)sql, params);
        }
    }

    private List<DynamicObject> queryBizBIll(DynamicObject[] bizBills) {
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject bizBill : bizBills) {
            ids.add(bizBill.getLong("id"));
        }
        String queryField = "id,entry.id,entry.e_localamt,entry.e_pricetaxtotalbase,entry.intercostamt,entry.e_unitprice,entry.e_baseunitqty,entry.e_srcbillid,entry.e_srcentryid,entry.seq,entry.e_unwoffqty,basecurrency,isadjust,hadrevaluation,isrevaluation,bookdate,exratetable,exratedate,entry.isallocate,org,billno,auditor,creator,billtype,writeoffbusiness";
        DynamicObject[] bizBillData = BusinessDataServiceHelper.load((String)"ap_busbill", (String)queryField, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
        return new ArrayList<DynamicObject>(Arrays.asList(bizBillData));
    }

    private Set<Long> getCostRecordInfo(List<DynamicObject> costRecords, Map<Long, List<DynamicObject>> purchaseIdAndCostRecord, Map<Long, Set<DynamicObject>> purchaseEntryIdAndCostRecord) {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        if (costRecords != null && !costRecords.isEmpty()) {
            for (DynamicObject costRecord : costRecords) {
                long costAccountId = costRecord.getDynamicObject("costaccount").getLong("id");
                costAccountIds.add(costAccountId);
                long purchaseId = costRecord.getLong("bizbillid");
                List<DynamicObject> costRecordList = purchaseIdAndCostRecord.get(purchaseId);
                if (costRecordList == null) {
                    costRecordList = new ArrayList<DynamicObject>(16);
                    costRecordList.add(costRecord);
                    purchaseIdAndCostRecord.put(purchaseId, costRecordList);
                } else {
                    costRecordList.add(costRecord);
                }
                DynamicObjectCollection entrys = costRecord.getDynamicObjectCollection(QUERY_ENTRY);
                for (DynamicObject entry : entrys) {
                    long purchaseEntryId = entry.getLong("bizbillentryid");
                    Set<DynamicObject> entryCostRecordList = purchaseEntryIdAndCostRecord.get(purchaseEntryId);
                    if (entryCostRecordList == null) {
                        entryCostRecordList = new HashSet<DynamicObject>(16);
                        entryCostRecordList.add(entry);
                        purchaseEntryIdAndCostRecord.put(purchaseEntryId, entryCostRecordList);
                        continue;
                    }
                    entryCostRecordList.add(entry);
                }
            }
        }
        return costAccountIds;
    }

    private List<DynamicObject> getEstimateCostRecord(List<DynamicObject> estimateBills, EstimateInfo estimateInfo) {
        this.createBizPurchaseMap(estimateBills, estimateInfo);
        this.getEstimatePurchaseBillNo(estimateInfo);
        return this.queryCostRecord(estimateBills);
    }

    private List<DynamicObject> getAdjustEstimateCostRecord(List<DynamicObject> bizBills, AdjustEstimateInfo adjustEstimateInfo) {
        List<DynamicObject> estimateBillList = this.queryAPBill(bizBills, adjustEstimateInfo);
        this.createAdjustBizPurchaseMap(estimateBillList, adjustEstimateInfo);
        this.createAdjustEstimateAndPurchase(adjustEstimateInfo, QUERY_HEAD);
        this.createAdjustEstimateAndPurchase(adjustEstimateInfo, QUERY_ENTRY);
        this.createEstimateAndLastAdjustEstimateEntryId(bizBills, adjustEstimateInfo);
        this.getAdjustEstimatePurchaseBillNo(adjustEstimateInfo);
        return this.queryAdjustBillCostRecord(estimateBillList);
    }

    private void getEstimatePurchaseBillNo(EstimateInfo estimateInfo) {
        HashSet<Long> allPurchaseIds = new HashSet<Long>(16);
        Map<Long, Set<Long>> adjustEstimateIdAndPurchaseId = estimateInfo.estimateBillIdAndPurchaseId;
        if (adjustEstimateIdAndPurchaseId != null && !adjustEstimateIdAndPurchaseId.isEmpty()) {
            Collection<Set<Long>> purchaseIds = adjustEstimateIdAndPurchaseId.values();
            for (Set<Long> purchaseId : purchaseIds) {
                allPurchaseIds.addAll(purchaseId);
            }
        }
        Map<Long, String> purchaseIdAndNumber = estimateInfo.purchaseIdAndNumber;
        DynamicObjectCollection purchaseBills = QueryServiceHelper.query((String)"im_purinbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", allPurchaseIds)}, null);
        for (DynamicObject purchaseBill : purchaseBills) {
            long purchaseId = purchaseBill.getLong("id");
            String billno = purchaseBill.getString("billno");
            purchaseIdAndNumber.put(purchaseId, billno);
        }
    }

    private void getAdjustEstimatePurchaseBillNo(AdjustEstimateInfo adjustEstimateInfo) {
        HashSet<Long> allPurchaseIds = new HashSet<Long>(16);
        Map<Long, Set<Long>> adjustEstimateIdAndPurchaseId = adjustEstimateInfo.adjustEstimateIdAndPurchaseId;
        if (adjustEstimateIdAndPurchaseId != null && !adjustEstimateIdAndPurchaseId.isEmpty()) {
            Collection<Set<Long>> purchaseIds = adjustEstimateIdAndPurchaseId.values();
            for (Set<Long> purchaseId : purchaseIds) {
                allPurchaseIds.addAll(purchaseId);
            }
        }
        Map<Long, String> purchaseIdAndNumber = adjustEstimateInfo.purchaseIdAndNumber;
        DynamicObjectCollection purchaseBills = QueryServiceHelper.query((String)"im_purinbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", allPurchaseIds)}, null);
        for (DynamicObject purchaseBill : purchaseBills) {
            long purchaseId = purchaseBill.getLong("id");
            String billno = purchaseBill.getString("billno");
            purchaseIdAndNumber.put(purchaseId, billno);
        }
    }

    private void createAdjustEstimateAndPurchase(AdjustEstimateInfo adjustEstimateInfo, String mode) {
        Map<Long, Set<Long>> adjustEstimateAndPurchase;
        Map<Long, Set<Long>> billAndPurchase;
        Map<Long, Set<Long>> adjustBillAndBill;
        if (QUERY_ENTRY.equals(mode)) {
            adjustBillAndBill = adjustEstimateInfo.adjustEstimateIdAndEstimateId;
            billAndPurchase = adjustEstimateInfo.estimateIdAndPurchaseId;
            adjustEstimateAndPurchase = adjustEstimateInfo.adjustEstimateIdAndPurchaseId;
        } else {
            adjustBillAndBill = adjustEstimateInfo.adjustEstimateEntryIdAndEstimateEntryId;
            billAndPurchase = adjustEstimateInfo.estimateEntryIdAndPurchaseEntryId;
            adjustEstimateAndPurchase = adjustEstimateInfo.adjustEstimateEntryIdAndPurchaseEntryId;
        }
        if (adjustBillAndBill == null || adjustBillAndBill.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> entry : adjustBillAndBill.entrySet()) {
            Set<Long> curPurchaseIds;
            Long id = entry.getKey();
            Set<Long> srcIds = entry.getValue();
            Set<Long> purchaseIds = adjustEstimateAndPurchase.get(id);
            if (purchaseIds == null) {
                purchaseIds = new HashSet<Long>(16);
                for (Long srcId : srcIds) {
                    curPurchaseIds = billAndPurchase.get(srcId);
                    if (curPurchaseIds == null || curPurchaseIds.isEmpty()) continue;
                    purchaseIds.addAll(curPurchaseIds);
                }
                adjustEstimateAndPurchase.put(id, purchaseIds);
                continue;
            }
            for (Long srcId : srcIds) {
                curPurchaseIds = billAndPurchase.get(srcId);
                if (curPurchaseIds == null || curPurchaseIds.isEmpty()) continue;
                purchaseIds.addAll(curPurchaseIds);
            }
        }
    }

    private void createEstimateAndLastAdjustEstimateEntryId(List<DynamicObject> bizBills, AdjustEstimateInfo adjustEstimateInfo) {
        if (bizBills == null || bizBills.isEmpty()) {
            return;
        }
        Map<Long, Long> estimateEntryIdAndLastAdjustEstimateEntryId = adjustEstimateInfo.estimateEntryIdAndMaxAdjustEstimateEntryId;
        HashSet<Long> srcIds = new HashSet<Long>(16);
        for (DynamicObject bizBill : bizBills) {
            long id = bizBill.getLong("id");
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection(QUERY_ENTRY);
            for (DynamicObject entry : entrys) {
                long srcId = entry.getLong("e_srcbillid");
                srcIds.add(srcId);
            }
        }
        QFilter idFilter = new QFilter("entry.e_srcbillid", "in", srcIds);
        QFilter isAdjustFilter = new QFilter("isadjust", "=", (Object)Character.valueOf('1'));
        DataSet adjustEstimateBills = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ap_busbill", (String)"id,entry.id,entry.e_srcbillid", (QFilter[])new QFilter[]{idFilter, isAdjustFilter}, null).groupBy(new String[]{"entry.e_srcbillid", "entry.id"}).max("entry.id").finish();
        for (Row adjustEstimateBill : adjustEstimateBills) {
            Long estimateId = adjustEstimateBill.getLong("entry.e_srcbillid");
            Long adjustEstimateBillEntryId = adjustEstimateBill.getLong("entry.id");
            estimateEntryIdAndLastAdjustEstimateEntryId.put(estimateId, adjustEstimateBillEntryId);
        }
    }

    private void createAdjustBizPurchaseMap(List<DynamicObject> estimateBillList, AdjustEstimateInfo adjustEstimateInfo) {
        if (estimateBillList == null || estimateBillList.isEmpty()) {
            return;
        }
        Map<Long, Set<Long>> billIdAndPurchaseId = adjustEstimateInfo.estimateIdAndPurchaseId;
        Map<Long, Set<Long>> billEntryIdAndPurchaseEntryId = adjustEstimateInfo.estimateEntryIdAndPurchaseEntryId;
        for (DynamicObject estimateBill : estimateBillList) {
            long id = estimateBill.getLong("id");
            long entryId = estimateBill.getLong("entry.id");
            long srcId = estimateBill.getLong("entry.e_srcbillid");
            long srcEntryId = estimateBill.getLong("entry.e_srcentryid");
            this.putMap(billIdAndPurchaseId, id, srcId);
            this.putMap(billEntryIdAndPurchaseEntryId, entryId, srcEntryId);
        }
    }

    private void createBizPurchaseMap(List<DynamicObject> estimateBillList, EstimateInfo estimateInfo) {
        Map<Long, Set<Long>> billIdAndPurchaseId = estimateInfo.estimateBillIdAndPurchaseId;
        Map<Long, Set<Long>> billEntryIdAndPurchaseEntryId = estimateInfo.estimateBillEntryIdAndPurchaseEntryId;
        Map<Long, Set<Long>> estimateIdAndEntryId = estimateInfo.estimateIdAndEntryId;
        if (estimateBillList == null || estimateBillList.isEmpty()) {
            return;
        }
        for (DynamicObject estimateBill : estimateBillList) {
            long id = estimateBill.getLong("id");
            DynamicObjectCollection entrys = estimateBill.getDynamicObjectCollection(QUERY_ENTRY);
            for (DynamicObject entry : entrys) {
                long entryId = entry.getLong("id");
                long srcId = entry.getLong("e_srcbillid");
                long srcEntryId = entry.getLong("e_srcentryid");
                this.putMap(billIdAndPurchaseId, id, srcId);
                this.putMap(billEntryIdAndPurchaseEntryId, entryId, srcEntryId);
                this.putMap(estimateIdAndEntryId, id, entryId);
            }
        }
    }

    private List<DynamicObject> queryAdjustBillCostRecord(List<DynamicObject> estimateBillList) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> bizBillEntryIds = new HashSet<Long>(16);
        if (estimateBillList != null && !estimateBillList.isEmpty()) {
            for (DynamicObject estimateBill : estimateBillList) {
                long srcId = estimateBill.getLong("entry.e_srcbillid");
                long srcEntryId = estimateBill.getLong("entry.e_srcentryid");
                bizBillIds.add(srcId);
                bizBillEntryIds.add(srcEntryId);
            }
        }
        String fields = this.getCostReorcdField(false);
        QFilter splitCreateFilter = new QFilter("issplitcreate", "=", (Object)Character.valueOf('0'));
        QFilter idFilter = new QFilter("bizbillid", "in", bizBillIds);
        QFilter entryIdFilter = new QFilter("entry.bizbillentryid", "in", bizBillEntryIds);
        QFilter stateFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter costaccountFilter = new QFilter("costaccount.accountcosttype", "!=", (Object)"B");
        QFilter[] qFilters = new QFilter[]{splitCreateFilter, idFilter, entryIdFilter, stateFilter, costaccountFilter};
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)fields, (QFilter[])qFilters);
        costRecords = this.tryGetCostRecord(fields, qFilters, costRecords);
        return new ArrayList<DynamicObject>(Arrays.asList(costRecords));
    }

    private DynamicObject[] tryGetCostRecord(String fields, QFilter[] qFilters, DynamicObject[] costRecords) {
        Integer retryTime = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.ESTIMATE_QUERY_RETRYTIME);
        for (int i = 0; i < 3 && (costRecords == null || costRecords.length == 0); ++i) {
            try {
                Thread.sleep(retryTime.intValue());
            }
            catch (InterruptedException e) {
                logger.info("EstimateAdjustProcess tryGetCostRecord", (Object)e);
            }
            costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)fields, (QFilter[])qFilters);
        }
        return costRecords;
    }

    private List<DynamicObject> queryCostRecord(List<DynamicObject> estimateBillList) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> bizBillEntryIds = new HashSet<Long>(16);
        if (estimateBillList != null && !estimateBillList.isEmpty()) {
            for (DynamicObject estimateBill : estimateBillList) {
                DynamicObjectCollection entrys = estimateBill.getDynamicObjectCollection(QUERY_ENTRY);
                for (DynamicObject entry : entrys) {
                    long srcId = entry.getLong("e_srcbillid");
                    long srcEntryId = entry.getLong("e_srcentryid");
                    bizBillIds.add(srcId);
                    bizBillEntryIds.add(srcEntryId);
                }
            }
        }
        String fields = this.getCostReorcdField(false);
        QFilter splitCreateFilter = new QFilter("issplitcreate", "=", (Object)Character.valueOf('0'));
        QFilter idFilter = new QFilter("bizbillid", "in", bizBillIds);
        QFilter entryIdFilter = new QFilter("entry.bizbillentryid", "in", bizBillEntryIds);
        QFilter stateFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter costaccountFilter = new QFilter("costaccount.accountcosttype", "!=", (Object)"B");
        QFilter[] qFilters = new QFilter[]{splitCreateFilter, idFilter, entryIdFilter, stateFilter, costaccountFilter};
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)fields, (QFilter[])qFilters);
        costRecords = this.tryGetCostRecord(fields, qFilters, costRecords);
        return new ArrayList<DynamicObject>(Arrays.asList(costRecords));
    }

    private List<DynamicObject> queryAPBill(List<DynamicObject> bizBills, AdjustEstimateInfo adjustEstimateInfo) {
        if (bizBills == null || bizBills.isEmpty()) {
            return null;
        }
        Map<Long, Set<Long>> adjustBillIdAndBillId = adjustEstimateInfo.adjustEstimateIdAndEstimateId;
        Map<Long, Set<Long>> adjustBillEntryIdAndBillEntryId = adjustEstimateInfo.adjustEstimateEntryIdAndEstimateEntryId;
        Map<Long, DynamicObject> adjustEstimateEntryIdAndEstimateEntryBill = adjustEstimateInfo.adjustEstimateEntryIdAndEstimateEntryBill;
        Map<Long, Set<Long>> adjustEstimateIdAndEntryId = adjustEstimateInfo.adjustEstimateIdAndEntryId;
        Map<Long, Set<Long>> estimateIdAndEntryId = adjustEstimateInfo.estimateIdAndEntryId;
        Map<Long, Long> wfAdjustEstimateId_adjustEstimateId = adjustEstimateInfo.wfAdjustEstimateId_AdjustEstimateId;
        Map<Long, Long> adjustEstimateId_wfAdjustEstimateId = adjustEstimateInfo.adjustEstimateId_wfAdjustEstimateId;
        Map<Long, Long> wfAdjustEstimateEntryId_adjustEstimateEntryId = adjustEstimateInfo.wfAdjustEstimateEntryId_AdjustEstimateEntryId;
        Map<Long, Boolean> adjustEstimateIdAndIsWf = adjustEstimateInfo.adjustEstimateIdAndIsWf;
        HashMap<Long, Long> estimateEntryIdAndAdjustEstimateEntryId = new HashMap<Long, Long>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> bizBillEntryIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> writeOffBizBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject bizBill : bizBills) {
            long id = bizBill.getLong("id");
            boolean writeoffbusiness = bizBill.getBoolean("writeoffbusiness");
            adjustEstimateIdAndIsWf.put(id, writeoffbusiness);
            if (writeoffbusiness) {
                writeOffBizBills.add(bizBill);
                continue;
            }
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection(QUERY_ENTRY);
            for (Object entry : entrys) {
                long entryId = entry.getLong("id");
                long srcId = entry.getLong("e_srcbillid");
                long srcEntryId = entry.getLong("e_srcentryid");
                bizBillIds.add(srcId);
                bizBillEntryIds.add(srcEntryId);
                this.putMap(adjustBillIdAndBillId, id, srcId);
                this.putMap(adjustBillEntryIdAndBillEntryId, entryId, srcEntryId);
                this.putMap(adjustEstimateIdAndEntryId, id, entryId);
                this.putMap(estimateIdAndEntryId, srcId, srcEntryId);
                estimateEntryIdAndAdjustEstimateEntryId.put(srcEntryId, entryId);
            }
        }
        QFilter idFilter = new QFilter("id", "in", bizBillIds);
        QFilter entryIdFilter = new QFilter("entry.id", "in", bizBillEntryIds);
        QFilter isAdjustFilter = new QFilter("isadjust", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection estimateBills = QueryServiceHelper.query((String)this.getClass().getName(), (String)"ap_busbill", (String)"id,entry.id,entry.e_srcbillid,entry.e_srcentryid,entry.e_unwoffqty,entry.e_taxunitprice,entry.e_quantity", (QFilter[])new QFilter[]{idFilter, entryIdFilter, isAdjustFilter}, null);
        if (estimateBills != null && !estimateBills.isEmpty()) {
            for (DynamicObject estimateBill : estimateBills) {
                long estimateEntryId = estimateBill.getLong("entry.id");
                if (!bizBillEntryIds.contains(estimateEntryId)) continue;
                Long adjustEstimateEntryId = (Long)estimateEntryIdAndAdjustEstimateEntryId.get(estimateEntryId);
                adjustEstimateEntryIdAndEstimateEntryBill.put(adjustEstimateEntryId, estimateBill);
            }
        }
        HashSet<Long> wfSrcIds = new HashSet<Long>(16);
        HashSet<Long> wfSrcEntryIds = new HashSet<Long>(16);
        if (!writeOffBizBills.isEmpty()) {
            DynamicObject[] bizBillLists;
            HashSet<Long> srcIds = new HashSet<Long>(16);
            for (DynamicObject writeOffBizBill : writeOffBizBills) {
                long writeOffBizId = writeOffBizBill.getLong("id");
                DynamicObjectCollection entrys = writeOffBizBill.getDynamicObjectCollection(QUERY_ENTRY);
                for (DynamicObject entry : entrys) {
                    long srcId = entry.getLong("e_srcbillid");
                    long srcEntryId = entry.getLong("e_srcentryid");
                    srcIds.add(srcId);
                    wfAdjustEstimateId_adjustEstimateId.put(writeOffBizId, srcId);
                    adjustEstimateId_wfAdjustEstimateId.put(srcId, writeOffBizId);
                    long writeOffBizEntryId = entry.getLong("id");
                    wfAdjustEstimateEntryId_adjustEstimateEntryId.put(writeOffBizEntryId, srcEntryId);
                }
            }
            String queryField = "id,entry.id,entry.e_localamt,entry.e_pricetaxtotalbase,entry.intercostamt,entry.e_unitprice,entry.e_baseunitqty,entry.e_srcbillid,entry.e_srcentryid,entry.seq,entry.e_unwoffqty,basecurrency,isadjust,hadrevaluation,isrevaluation,bookdate,exratetable,exratedate,entry.isallocate,org,billno,auditor,creator,billtype";
            for (DynamicObject bizBill : bizBillLists = BusinessDataServiceHelper.load((String)"ap_busbill", (String)queryField, (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)}, null)) {
                long id = bizBill.getLong("id");
                DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection(QUERY_ENTRY);
                for (DynamicObject entry : entrys) {
                    long entryId = entry.getLong("id");
                    long srcId = entry.getLong("e_srcbillid");
                    long srcEntryId = entry.getLong("e_srcentryid");
                    wfSrcIds.add(srcId);
                    wfSrcEntryIds.add(srcEntryId);
                    this.putMap(adjustBillIdAndBillId, id, srcId);
                    this.putMap(adjustBillEntryIdAndBillEntryId, entryId, srcEntryId);
                    this.putMap(adjustEstimateIdAndEntryId, id, entryId);
                    this.putMap(estimateIdAndEntryId, srcId, srcEntryId);
                    estimateEntryIdAndAdjustEstimateEntryId.put(srcEntryId, entryId);
                }
            }
        }
        QFilter writeAdjustEstimateIdFilter = new QFilter("id", "in", wfSrcIds);
        QFilter writeAdjustEstimateEntryIdFilter = new QFilter("entry.id", "in", wfSrcEntryIds);
        QFilter writeAdjustEstimateIsAdjustFilter = new QFilter("isadjust", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection writeOffEstimateBills = QueryServiceHelper.query((String)this.getClass().getName(), (String)"ap_busbill", (String)"id,entry.id,entry.e_srcbillid,entry.e_srcentryid,entry.e_unwoffqty,entry.e_taxunitprice,entry.e_quantity", (QFilter[])new QFilter[]{writeAdjustEstimateIdFilter, writeAdjustEstimateEntryIdFilter, writeAdjustEstimateIsAdjustFilter}, null);
        if (writeOffEstimateBills != null && !writeOffEstimateBills.isEmpty()) {
            for (DynamicObject estimateBill : writeOffEstimateBills) {
                long estimateEntryId = estimateBill.getLong("entry.id");
                if (!wfSrcEntryIds.contains(estimateEntryId)) continue;
                Long adjustEstimateEntryId = (Long)estimateEntryIdAndAdjustEstimateEntryId.get(estimateEntryId);
                adjustEstimateEntryIdAndEstimateEntryBill.put(adjustEstimateEntryId, estimateBill);
            }
        }
        ArrayList<DynamicObject> r = new ArrayList<DynamicObject>(16);
        if (estimateBills != null && !estimateBills.isEmpty()) {
            r.addAll((Collection<DynamicObject>)estimateBills);
        }
        if (writeOffEstimateBills != null && !writeOffEstimateBills.isEmpty()) {
            r.addAll((Collection<DynamicObject>)writeOffEstimateBills);
        }
        return r;
    }

    private void putMap(Map<Long, Set<Long>> estimateIdAndEntryId, long srcId, long srcEntryId) {
        if (estimateIdAndEntryId == null) {
            return;
        }
        Set<Long> estimateEntryIds = estimateIdAndEntryId.get(srcId);
        if (estimateEntryIds == null) {
            estimateEntryIds = new HashSet<Long>(16);
            estimateEntryIds.add(srcEntryId);
            estimateIdAndEntryId.put(srcId, estimateEntryIds);
        } else {
            estimateEntryIds.add(srcEntryId);
        }
    }

    private boolean isLastAdjustEstimate(DynamicObject bizBillEntry, AdjustEstimateInfo adjustEstimateInfo) {
        Long lastAdjustEstimateEntryId;
        BigDecimal unwoffqty;
        Map<Long, DynamicObject> adjustEstimateEntryIdAndEstimateBill = adjustEstimateInfo.adjustEstimateEntryIdAndEstimateEntryBill;
        Map<Long, Long> estimateIdAndLastEntryId = adjustEstimateInfo.estimateEntryIdAndMaxAdjustEstimateEntryId;
        Map<Long, Long> wfAdjustEstimateEntryId_AdjustEstimateEntryId = adjustEstimateInfo.wfAdjustEstimateEntryId_AdjustEstimateEntryId;
        long adjustApEntryId = bizBillEntry.getLong("id");
        if (wfAdjustEstimateEntryId_AdjustEstimateEntryId != null && wfAdjustEstimateEntryId_AdjustEstimateEntryId.containsKey(bizBillEntry.getLong("id"))) {
            unwoffqty = null;
            lastAdjustEstimateEntryId = null;
        } else {
            DynamicObject estimateBill = adjustEstimateEntryIdAndEstimateBill.get(adjustApEntryId);
            unwoffqty = estimateBill.getBigDecimal("entry.e_unwoffqty");
            Long estimateId = bizBillEntry.getLong("e_srcbillid");
            lastAdjustEstimateEntryId = estimateIdAndLastEntryId.get(estimateId);
        }
        return unwoffqty != null && unwoffqty.compareTo(BigDecimal.ZERO) == 0 && this.sameLongValue(lastAdjustEstimateEntryId, bizBillEntry.getLong("id"));
    }

    private boolean sameCurrency(DynamicObject costRecord, DynamicObject bizBill) {
        long billLocalCurrencyId = bizBill.getDynamicObject("basecurrency").getLong("id");
        long localCurrencyId = costRecord.getDynamicObject("localcurrency").getLong("id");
        return localCurrencyId == billLocalCurrencyId;
    }

    private DynamicObject createCostAdjustHead(DynamicObject costRecordInfo, DynamicObject estimateBill, String accountType, boolean isWf, boolean isDiffbill) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjustbill");
        if (isDiffbill) {
            costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        }
        costAdjustBill.set("cstype", (Object)"bd_supplier");
        costAdjustBill.set("custsupplier", costRecordInfo.get("supplier"));
        costAdjustBill.set("currency", costRecordInfo.get("localcurrency"));
        costAdjustBill.set("bizdate", (Object)estimateBill.getDate("bookdate"));
        costAdjustBill.set("bookdate", (Object)estimateBill.getDate("bookdate"));
        costAdjustBill.set("biztype", (Object)"A");
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.PUR_ADJUSTESTIMATE.getValue());
        costAdjustBill.set("costaccount", (Object)costRecordInfo.getDynamicObject("costaccount"));
        Object accountID = costRecordInfo.getDynamicObject("costaccount").get("masterid");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingle((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        costAdjustBill.set("calorg", costAccont.get("calorg"));
        costAdjustBill.set("billtype", costRecordInfo.get("billtype"));
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("createtime", (Object)date);
        costAdjustBill.set("creator_id", (Object)estimateBill.getDynamicObject("creator").getLong("id"));
        costAdjustBill.set("auditor_id", (Object)estimateBill.getDynamicObject("auditor").getLong("id"));
        costAdjustBill.set("adminorg", (Object)costRecordInfo.getDynamicObject("adminorg"));
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjustBill, (String)costAccont.getString("calorg_id"));
        if (isDiffbill) {
            number = BillNoHelper.getBillNo((String)"cal_stdcostdiffbill", (DynamicObject)costAdjustBill, (String)costAccont.getString("calorg_id"));
        }
        costAdjustBill.set("billno", (Object)number);
        costAdjustBill.set("checkstrikeaccount", (Object)estimateBill.getBoolean("isadjust"));
        if (!isDiffbill) {
            String difftype = !AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) ? CostAdjustBillDiffTypeEnum.ACT_COST.getValue() : CostAdjustBillDiffTypeEnum.ORDER_DIFF.getValue();
            costAdjustBill.set("difftype", (Object)difftype);
        }
        if (isWf) {
            costAdjustBill.set("ischargeoff", (Object)"1");
        }
        return costAdjustBill;
    }

    private DynamicObject addCostAdjustBillEntry(DynamicObject costRecordInfo, DynamicObject costRecordEntry, DynamicObject estimateBillHead, DynamicObject estimateBillEntry, AdjustEstimateInfo adjustEstimateInfo, DynamicObject costAdjustBillHead) {
        Map<Long, Set<Long>> adjustEstimateEntryIdAndEstimateEntryId;
        Map<Long, Set<Long>> adjustEstimateIdAndEstimateId;
        if (adjustEstimateInfo != null) {
            adjustEstimateIdAndEstimateId = adjustEstimateInfo.adjustEstimateIdAndEstimateId;
            adjustEstimateEntryIdAndEstimateEntryId = adjustEstimateInfo.adjustEstimateEntryIdAndEstimateEntryId;
        } else {
            adjustEstimateIdAndEstimateId = new HashMap<Long, Set<Long>>(1);
            adjustEstimateEntryIdAndEstimateEntryId = new HashMap<Long, Set<Long>>(1);
        }
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        String lot = costRecordEntry.getString("lot");
        long warehsBillID = costRecordEntry.getLong("warehouse_id");
        long locationID = costRecordEntry.getLong("location_id");
        long ownerID = costRecordEntry.getLong("owner_id");
        long assistId = costRecordEntry.getLong("assist_id");
        DynamicObject entry = costAdjustBillHead.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costRecordInfo.get("storageorgunit"));
        entry.set("material", costRecordEntry.get("material"));
        entry.set("lot", (Object)lot);
        costAdjustBillHead.set("biztype", (Object)"A");
        entry.set("warehouse", (Object)warehsBillID);
        entry.set("location", (Object)locationID);
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", (Object)ownerID);
        entry.set("ecostcenter", (Object)costRecordEntry.getLong("ecostcenter_id"));
        entry.set("assist", (Object)assistId);
        entry.set("invbilltype", costRecordInfo.get("billtype"));
        entry.set("invbillnum", (Object)costRecordInfo.getString("billno"));
        entry.set("inventryseq", costRecordEntry.get("seq"));
        entry.set("invbillid", costRecordInfo.get("id"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("invbillentryid", costRecordEntry.get("id"));
        entry.set("srcbilltype", (Object)(estimateBillHead.getDynamicObject("billtype") == null ? 0L : estimateBillHead.getDynamicObject("billtype").getLong("id")));
        entry.set("srcbillnum", (Object)estimateBillHead.getString("billno"));
        entry.set("srcentryseq", (Object)estimateBillEntry.getInt("seq"));
        entry.set("srcbillid", (Object)estimateBillHead.getLong("id"));
        entry.set("srcbillentryid", (Object)estimateBillEntry.getLong("id"));
        entry.set("srcbizentityobject", (Object)"ap_busbill");
        entry.set("baseunit", costRecordEntry.get("baseunit"));
        entry.set("project", costRecordEntry.get("project"));
        entry.set("invtype", costRecordEntry.get("invtype"));
        entry.set("invstatus", costRecordEntry.get("invstatus"));
        entry.set("mversion", costRecordEntry.get("mversion"));
        entry.set("tracknumber", costRecordEntry.get("tracknumber"));
        entry.set("configuredcode", costRecordEntry.get("configuredcode"));
        boolean isadjust = estimateBillHead.getBoolean("isadjust");
        long bizId = estimateBillHead.getLong("id");
        long bizEntryId = estimateBillEntry.getLong("id");
        if (isadjust) {
            ArrayList estimateIds = null;
            if (adjustEstimateIdAndEstimateId.get(bizId) != null) {
                estimateIds = new ArrayList(adjustEstimateIdAndEstimateId.get(bizId));
            }
            if (estimateIds != null && !estimateIds.isEmpty()) {
                bizId = (Long)estimateIds.get(0);
            }
            ArrayList estimateEntryIds = null;
            if (adjustEstimateEntryIdAndEstimateEntryId.get(bizEntryId) != null) {
                estimateEntryIds = new ArrayList(adjustEstimateEntryIdAndEstimateEntryId.get(bizEntryId));
            }
            if (estimateEntryIds != null && !estimateEntryIds.isEmpty()) {
                bizEntryId = (Long)estimateEntryIds.get(0);
            }
        }
        entry.set("costestimatebillid", (Object)bizId);
        entry.set("costestimatebillentryid", (Object)bizEntryId);
        entry.set("noupdatecalfields", costRecordEntry.get("noupdatecalfields"));
        entry.set("stocktype", costRecordEntry.get("stocktype"));
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        CommonSettingHelper.setExFieldValue((Set)exFieldSet, (MainEntityType)costAdjustEntityType, (MainEntityType)costRecordEntityType, (DynamicObject)entry, (DynamicObject)costRecordEntry);
        return entry;
    }

    private List<CostAdjustDetailParams> buildCostAdjustDetail(DynamicObject[] newDiffBills) {
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        for (DynamicObject newDiffBill : newDiffBills) {
            DynamicObjectCollection newDiffBillEntry = newDiffBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject outentry : newDiffBillEntry) {
                long entryId = outentry.getLong("id");
                BigDecimal adjustamt = outentry.getBigDecimal("adjustamt");
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setEntryid((Object)entryId);
                param.setCostElementId((Object)773126985240072192L);
                param.setCostSubElementId((Object)773175233367685120L);
                param.setAdjustAmt(adjustamt);
                CalStdcostdiffbillHelper.setParamSubDdiffAmt((String)"G", (BigDecimal)adjustamt, (CostAdjustDetailParams)param);
                paramsList.add(param);
            }
        }
        return paramsList;
    }

    @Override
    public void doProcessor(Map params, DynamicObject bill) {
        super.doProcessor(params, bill);
    }

    private static class EstimateInfo {
        Map<Long, Set<Long>> estimateBillIdAndPurchaseId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> estimateBillEntryIdAndPurchaseEntryId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> estimateIdAndEntryId = new HashMap<Long, Set<Long>>(16);
        Map<Long, List<DynamicObject>> estimatePurchaseIdAndCostRecord = new HashMap<Long, List<DynamicObject>>(16);
        Map<Long, Set<DynamicObject>> estimatePurchaseEntryIdAndCostRecordEntry = new HashMap<Long, Set<DynamicObject>>(16);
        Map<Long, String> purchaseIdAndNumber = new HashMap<Long, String>(16);

        private EstimateInfo() {
        }
    }

    private static class AdjustEstimateInfo {
        Map<Long, Set<Long>> adjustEstimateIdAndPurchaseId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> adjustEstimateEntryIdAndPurchaseEntryId = new HashMap<Long, Set<Long>>(16);
        Map<Long, List<DynamicObject>> adjustEstimatePurchaseIdAndCostRecord = new HashMap<Long, List<DynamicObject>>(16);
        Map<Long, Set<DynamicObject>> adjustEstimatePurchaseEntryIdAndCostRecordEntry = new HashMap<Long, Set<DynamicObject>>(16);
        Map<Long, DynamicObject> adjustEstimateEntryIdAndEstimateEntryBill = new HashMap<Long, DynamicObject>(16);
        Map<Long, String> purchaseIdAndNumber = new HashMap<Long, String>(16);
        Map<Long, Long> wfAdjustEstimateId_AdjustEstimateId = new HashMap<Long, Long>(16);
        Map<Long, Long> adjustEstimateId_wfAdjustEstimateId = new HashMap<Long, Long>(16);
        Map<Long, Long> wfAdjustEstimateEntryId_AdjustEstimateEntryId = new HashMap<Long, Long>(16);
        Map<Long, Boolean> adjustEstimateIdAndIsWf = new HashMap<Long, Boolean>(16);
        Map<Long, Set<Long>> srcEntryId_costAdjustId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> adjustEstimateIdAndEstimateId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> adjustEstimateEntryIdAndEstimateEntryId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> adjustEstimateIdAndEntryId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> estimateIdAndPurchaseId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> estimateEntryIdAndPurchaseEntryId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> estimateIdAndEntryId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> estimateIdEntryIdAndCostAccountId = new HashMap<Long, Set<Long>>(16);
        Map<Long, Set<Long>> costAccountIdAndCostAdjustEntry = new HashMap<Long, Set<Long>>(16);
        Map<Long, DynamicObject> costAdjustEntryIdAndDynamic = new HashMap<Long, DynamicObject>(16);
        Map<Long, Long> estimateEntryIdAndMaxAdjustEstimateEntryId = new HashMap<Long, Long>(16);

        private AdjustEstimateInfo() {
        }
    }
}

