/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.process.impl.AbstractWriteOffServiceProcess;
import kd.fi.cal.business.process.inner.CostRecordAuditInvoker;
import kd.fi.cal.business.process.inner.OverWfAutoUnWfHelper;
import kd.fi.cal.business.process.inner.PrevCostAdjustProcessHelper;
import kd.fi.cal.chargeoff.CalChargeOffHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.ExchangeRateHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.CommonUtils;
import kd.mpscmm.msbd.algorithm.business.helper.AlgorithmHelper;

public class PurWriteOffServiceProcess
extends AbstractWriteOffServiceProcess {
    private static final Log logger = LogFactory.getLog(PurWriteOffServiceProcess.class);
    private Map<Object, DynamicObject> apBillMap = new HashMap<Object, DynamicObject>(16);
    private Map<Long, DynamicObject> invBillEntryMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, DynamicObject> ancestorBillEntryMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, Boolean> entryWriteBackMap = new HashMap<Long, Boolean>(16);
    private Map<Long, Boolean> pur_have_swapplParamMap = new HashMap<Long, Boolean>(16);
    private Map<Long, Boolean> calbycostelementParamMap = new HashMap<Long, Boolean>(16);
    private Map<Long, Boolean> costAccountSupportTaxAmtMap = new HashMap<Long, Boolean>(16);
    private Set<Long> notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType();
    private Set<Long> notUpdCostRecordIds = new HashSet<Long>(16);
    private Set<String> omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
    private boolean isOutSource = false;
    private Set<Long> prevInAdjustIds = new HashSet<Long>(16);
    private boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
    private Set<Long> costAdjustIds = new HashSet<Long>(16);
    private Set<Long> diffCostAdjustIds = new HashSet<Long>(16);
    private boolean isCalByUnitPrice = false;
    private String redVerifyRelation = "";

    public PurWriteOffServiceProcess() {
        this.calBillType = "IN";
    }

    @Override
    public void doProcessor(Map params, DynamicObject[] writeOffInfos) {
        Object object;
        TXHandle h;
        HashMap<Long, DynamicObject[]> purCostRecordMap;
        Map<Long, DynamicObject> groupMap;
        HashSet<Long> purIds;
        boolean omInRelation;
        boolean purInRelation;
        DynamicObject[] reLoadInfos;
        long time;
        boolean isSuccess;
        block34: {
            block35: {
                block36: {
                    if (writeOffInfos == null || writeOffInfos.length < 1) {
                        logger.info("\u91c7\u8d2d\u6838\u9500\u5931\u8d25\uff1a\u4f20\u9012\u53c2\u6570\u4e3a\u7a7a");
                        return;
                    }
                    this.writeOffInfos = writeOffInfos;
                    this.actionName = ActionEnum.PUR_WRITEOFF.getValue();
                    IAppCache cache = AppCache.get((String)"cal");
                    String unwriteoff_ids = (String)cache.get(this.lock_key, String.class);
                    if (unwriteoff_ids != null) {
                        for (DynamicObject info : writeOffInfos) {
                            boolean isUnWriteOff = unwriteoff_ids.contains(String.valueOf(info.getLong("id")));
                            if (!isUnWriteOff) continue;
                            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u8be5\u6838\u9500\u8bb0\u5f55\u6b63\u5728\u53cd\u6838\u9500\u6216\u8005\u5df2\u7ecf\u53cd\u6838\u9500\u7ed3\u675f\u3002", (String)"PurWriteOffServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
                        }
                    }
                    isSuccess = true;
                    this.checkBillAudit();
                    time = System.currentTimeMillis();
                    logger.info("\u91c7\u8d2d\u6838\u9500\u5f00\u59cb\uff1a" + time);
                    reLoadInfos = this.reLoadWriteRecord(writeOffInfos);
                    purInRelation = false;
                    omInRelation = false;
                    purIds = new HashSet<Long>();
                    groupMap = this.buildGroupRecord(reLoadInfos, purIds);
                    purCostRecordMap = new HashMap<Long, DynamicObject[]>(16);
                    h = TX.requiresNew();
                    object = null;
                    if (!purIds.isEmpty()) break block34;
                    if (h == null) break block35;
                    if (object == null) break block36;
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block35;
                }
                h.close();
            }
            return;
        }
        try {
            try {
                boolean omInRedRelation;
                DynamicObject wrireOff = reLoadInfos[0];
                String string = wrireOff.getString("billtype");
                this.isOutSource = this.omInBills.contains(string);
                String verifyrelation = wrireOff.getString("verifyrelation");
                purInRelation = "appurin".equals(verifyrelation) || "appurreturn".equals(verifyrelation) || "1363765058710014976".equals(verifyrelation);
                boolean purRedRelation = "purself".equals(verifyrelation) || "apfinself".equals(verifyrelation) || "purwrittenoff".equals(verifyrelation) || "purreturnwrittenoff".equals(verifyrelation) || "1363768884041091072".equals(verifyrelation);
                omInRelation = "apomin".equals(verifyrelation) || "apominreturn".equals(verifyrelation);
                boolean bl = omInRedRelation = "ominself".equals(verifyrelation) || "apfinself".equals(verifyrelation);
                if (purInRelation || omInRelation) {
                    this.cacheApBill(reLoadInfos);
                    this.cacheInvAndAncestorBill(reLoadInfos, true);
                    for (Long purID : purIds) {
                        DynamicObject[] costRecords = this.getAllCostRecordByBizBillID(purID, groupMap.keySet());
                        purCostRecordMap.put(purID, costRecords);
                        this.purWriteOff(groupMap, purIds, costRecords);
                    }
                    this.dealPrevCostAdjust();
                } else if (purRedRelation || omInRedRelation) {
                    this.cacheInvAndAncestorBill(reLoadInfos, true);
                    HashMap<String, Date> dateMap = new HashMap<String, Date>(16);
                    HashMap<Long, Long> billIdMap = new HashMap<Long, Long>(16);
                    for (Long purID : purIds) {
                        this.purBlueWriteOff(purID, groupMap, dateMap);
                    }
                    purIds.clear();
                    groupMap.clear();
                    this.cacheInvAndAncestorBill(reLoadInfos, false);
                    groupMap = this.buildRedGroupRecord(reLoadInfos, purIds, billIdMap);
                    for (Long purID : purIds) {
                        this.purRedWriteOff(purID, groupMap, dateMap, billIdMap);
                    }
                }
                this.setWriteOffEndPeriod();
                new CostRecordAuditInvoker().invoke(this.auditVoucherCostRecordIds);
                Collection<DynamicObject> wfRecordDycs = groupMap.values();
                new CalChargeOffHelper().autoInvokeCharge(wfRecordDycs, "ap_verifyrecord");
            }
            catch (KDBizException e) {
                h.markRollback();
                isSuccess = false;
                for (DynamicObject info : reLoadInfos) {
                    this.addErrorMsg(info, "3", this.getErrorMsg((Exception)((Object)e)));
                }
            }
            catch (Exception e) {
                h.markRollback();
                isSuccess = false;
                for (DynamicObject info : reLoadInfos) {
                    this.addErrorMsg(info, "4", this.getErrorMsg(e));
                }
            }
            catch (Throwable e) {
                logger.info("PurWriteOffServiceProcess-doProcessor-Throwable", (Object)e);
                h.markRollback();
                isSuccess = false;
                for (DynamicObject info : reLoadInfos) {
                    this.addErrorMsg(info, "4", this.getErrorMsg(new Exception(e)));
                }
            }
        }
        catch (Throwable e) {
            object = e;
            throw e;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (h != null) {
                if (object != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)object).addSuppressed(e);
                    }
                } else {
                    h.close();
                }
            }
        }
        if (isSuccess && (purInRelation || omInRelation)) {
            HashSet<Long> vendorPurIdSet = new HashSet<Long>(16);
            block23: for (Long purID : purIds) {
                DynamicObject[] dynamicObjectArray = (DynamicObject[])purCostRecordMap.get(purID);
                if (dynamicObjectArray == null || dynamicObjectArray.length <= 0) continue;
                for (DynamicObject costrecord : dynamicObjectArray) {
                    String dischargetype = costrecord.getString("dischargetype");
                    if (!DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargetype) && !DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargetype)) continue;
                    vendorPurIdSet.add(purID);
                    continue block23;
                }
            }
            this.purWriteOffVendor(writeOffInfos, vendorPurIdSet);
        }
        logger.info("\u91c7\u8d2d\u6838\u9500\u8017\u65f6\uff1a" + (System.currentTimeMillis() - time));
    }

    private void dealPrevCostAdjust() {
        PrevCostAdjustProcessHelper prevCostAdjustProcessHelper = new PrevCostAdjustProcessHelper();
        prevCostAdjustProcessHelper.dealOutAdjustSet(this.prevInAdjustIds);
    }

    private void cacheApBill(DynamicObject[] writeOffInfos) {
        DynamicObject[] apInfos;
        HashSet<Long> apIdSet = new HashSet<Long>();
        for (DynamicObject writeOffInfo : writeOffInfos) {
            for (DynamicObject writeOffEntry : writeOffInfo.getDynamicObjectCollection("entry")) {
                apIdSet.add(writeOffEntry.getLong("e_billid"));
            }
        }
        QFilter q = new QFilter("id", "in", apIdSet);
        for (DynamicObject apInfo : apInfos = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,istaxdeduction,exratetable,exratedate,creator,auditor", (QFilter[])q.toArray())) {
            this.apBillMap.put(apInfo.getLong("id"), apInfo);
        }
    }

    private void cacheInvAndAncestorBill(DynamicObject[] writeOffInfos, boolean isMainBill) {
        DynamicObject[] recordInfos;
        DynamicObject[] invInfos;
        HashSet<Long> invIdSet = new HashSet<Long>(16);
        HashSet<Long> invEntryIdSet = new HashSet<Long>(16);
        String billEntity = "";
        if (isMainBill) {
            billEntity = writeOffInfos[0].getString("billtype");
            for (DynamicObject writeOffInfo : writeOffInfos) {
                invIdSet.add(writeOffInfo.getLong("billid"));
                invEntryIdSet.add(writeOffInfo.getLong("billentryid"));
            }
        } else {
            billEntity = ((DynamicObject)writeOffInfos[0].getDynamicObjectCollection("entry").get(0)).getString("e_billtype");
            for (DynamicObject writeOffInfo : writeOffInfos) {
                DynamicObjectCollection writeEntryColl = writeOffInfo.getDynamicObjectCollection("entry");
                for (DynamicObject writeOffEntry : writeEntryColl) {
                    invIdSet.add(writeOffEntry.getLong("e_billid"));
                    invEntryIdSet.add(writeOffEntry.getLong("e_billentryid"));
                }
            }
        }
        this.invBillEntryMap.clear();
        MainEntityType invEntityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
        for (DynamicObject invInfo : invInfos = BusinessDataServiceHelper.load((Object[])invIdSet.toArray(), (DynamicObjectType)invEntityType)) {
            for (DynamicObject entry : invInfo.getDynamicObjectCollection("billentry")) {
                Long entryID = entry.getLong("id");
                if (!invEntryIdSet.contains(entryID)) continue;
                this.invBillEntryMap.put(entry.getLong("id"), entry);
            }
        }
        this.ancestorBillEntryMap.clear();
        QFilter recordQ = new QFilter("bizbillid", "in", invIdSet);
        recordQ.and("entry.bizbillentryid", "in", invEntryIdSet);
        recordQ.and("issplitcreate", "=", (Object)Boolean.FALSE);
        for (DynamicObject recordInfo : recordInfos = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"entry.id,entry.materialcost,entry.processcost", (QFilter[])recordQ.toArray())) {
            for (DynamicObject entry : recordInfo.getDynamicObjectCollection("entry")) {
                this.ancestorBillEntryMap.put(entry.getLong("id"), entry);
            }
        }
    }

    private void purRedWriteOff(Long purID, Map<Long, DynamicObject> groupMap, Map<String, Date> dateMap, Map<Long, Long> billIdMap) {
        DynamicObject[] costRecords = this.getAllCostRecordByBizBillID(purID, groupMap.keySet());
        this.cacheCostAccountSupportTaxAmt(costRecords);
        for (DynamicObject costRecordInfo : costRecords) {
            this.splitCostRecord(costRecordInfo, groupMap, false, true, dateMap, billIdMap);
            this.saveCostRecordInfo(costRecordInfo);
        }
    }

    private void cacheCostAccountSupportTaxAmt(DynamicObject[] costRecords) {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        for (DynamicObject costRecord : costRecords) {
            costAccountIds.add(costRecord.getDynamicObject("costaccount").getLong("id"));
        }
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy.supporttaxamt", (QFilter[])new QFilter("id", "in", costAccountIds).toArray());
        for (DynamicObject dynamicObject : costAccounts) {
            this.costAccountSupportTaxAmtMap.put(dynamicObject.getLong("id"), dynamicObject.getBoolean("calpolicy.supporttaxamt"));
        }
    }

    private void purBlueWriteOff(Long purID, Map<Long, DynamicObject> groupMap, Map<String, Date> dateMap) {
        DynamicObject[] costRecords = this.getAllCostRecordByBizBillID(purID, groupMap.keySet());
        this.cacheCostAccountSupportTaxAmt(costRecords);
        for (DynamicObject costRecordInfo : costRecords) {
            DynamicObject costRecordAInfo = this.splitCostRecord(costRecordInfo, groupMap, false, false, null, null);
            dateMap.put(purID + "_" + costRecordAInfo.getDynamicObject("costaccount").getLong("id"), costRecordAInfo.getDate("writeoffdate"));
            this.saveCostRecordInfo(costRecordInfo);
        }
    }

    private DynamicObject[] reLoadWriteRecord(DynamicObject[] writeOffInfos) {
        int cSize = writeOffInfos.length;
        ArrayList<Object> ids = new ArrayList<Object>(cSize);
        for (DynamicObject writeOffInfo : writeOffInfos) {
            ids.add(writeOffInfo.getPkValue());
        }
        QFilter filter = new QFilter("id", "in", ids);
        String fields = this.getWriteOffFields();
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"ap_verifyrecord", (String)fields, (QFilter[])new QFilter[]{filter});
        for (int i = 0; i < 3 && (infos == null || infos.length == 0); ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.info("PurWriteOffServiceProcess reLoadWriteRecord", (Object)e);
            }
            infos = BusinessDataServiceHelper.load((String)"ap_verifyrecord", (String)fields, (QFilter[])new QFilter[]{filter});
        }
        logger.info(writeOffInfos[0].getString("billno") + "\u91cd\u53d6\u6838\u9500\u8bb0\u5f55\u7ed3\u679c\uff1a" + (infos == null || infos.length == 0 ? ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"SalOutWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0]) : infos[0].get("billno") + "," + infos[0].get("id")));
        if (infos == null || infos.length == 0) {
            this.addQueue();
            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"SalOutWriteOffServiceProcess_0", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
        }
        if (writeOffInfos[0].getString("billno").startsWith("test_delay")) {
            logger.info("\u6838\u9500\u6d4b\u8bd5,\u4e09\u5206\u949f\u5ef6\u65f6\u4e2d");
            try {
                Thread.sleep(180000L);
            }
            catch (InterruptedException e) {
                logger.info("PurWriteOffServiceProcess reLoadWriteRecord", (Object)e);
            }
        }
        HashSet<Long> bizbillids = new HashSet<Long>(16);
        for (DynamicObject info : infos) {
            bizbillids.add(info.getLong("billid"));
        }
        QFilter q = new QFilter("entry.writeoffid", "in", ids);
        q.and("bizbillid", "in", bizbillids);
        if (QueryServiceHelper.exists((String)"cal_costrecord", (QFilter[])q.toArray())) {
            throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u5df2\u62c6\u5355\u3002", (String)"PurWriteOffServiceProcess_4", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
        }
        return infos;
    }

    private String getWriteOffFields() {
        StringBuilder selector = new StringBuilder();
        selector.append("id,verifyseq,billtype,billid,billno,billentryid,basecurrency,verifyqty,verifybaseqty,verifyintercostamt,");
        selector.append("billdate,verifyrelation,asstacttype,asstact,currency,entry.e_verifyqty,");
        selector.append("entry.id,entry.e_billtype,entry.e_verifyamount,entry.e_verifybaseqty,entry.material.id,");
        selector.append("entry.e_asstacttype,entry.e_asstact,entry.e_currency,entry.e_billdate,entry.e_billno,entry.e_billentryid,");
        selector.append("entry.e_billid,entry.e_swappl,entry.e_basecurrency,entry.e_localverifyamt,entry.e_localverifytaxamt,entry.e_verifytaxamount,entry.e_verifyintercostamt,entry.e_hadwrittenoff,entry.e_iswrittenoff,entry.e_writtenoffremark");
        return selector.toString();
    }

    private Map<Long, DynamicObject> buildGroupRecord(DynamicObject[] writeOffInfos, Set<Long> purIds) {
        HashMap<Long, DynamicObject> groupMap = new HashMap<Long, DynamicObject>(writeOffInfos.length);
        for (DynamicObject writeOffInfo : writeOffInfos) {
            Long purID = writeOffInfo.getLong("billid");
            Long purEntryID = writeOffInfo.getLong("billentryid");
            groupMap.put(purEntryID, writeOffInfo);
            purIds.add(purID);
        }
        return groupMap;
    }

    private Map<Long, DynamicObject> buildRedGroupRecord(DynamicObject[] writeOffInfos, Set<Long> purIds, Map<Long, Long> billIdMap) {
        this.redVerifyRelation = writeOffInfos[0].getString("verifyrelation");
        HashMap<Long, DynamicObject> groupMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject writeOffInfo : writeOffInfos) {
            DynamicObjectCollection writeEntryColl = writeOffInfo.getDynamicObjectCollection("entry");
            for (DynamicObject writeOffEntry : writeEntryColl) {
                Long purID = writeOffEntry.getLong("e_billid");
                Long purEntryID = writeOffEntry.getLong("e_billentryid");
                groupMap.put(purEntryID, writeOffEntry);
                billIdMap.put(purID, writeOffInfo.getLong("billid"));
                purIds.add(purID);
            }
        }
        return groupMap;
    }

    private void purWriteOff(Map<Long, DynamicObject> groupMap, Set<Long> purIds, DynamicObject[] costRecords) {
        this.cacheCostAccountSupportTaxAmt(costRecords);
        HashMap<Long, DynamicObject> inCalBillMap = new HashMap<Long, DynamicObject>(16);
        this.getInCalBillMap(purIds, inCalBillMap);
        int size = costRecords.length;
        HashSet<Long> entryIdSet = new HashSet<Long>();
        HashSet<Long> idSet = new HashSet<Long>();
        HashSet<Long> ancestorIds = new HashSet<Long>();
        for (int i = 0; i < size; ++i) {
            DynamicObjectCollection recordInfoAEntrys;
            DynamicObject costRecordInfoA;
            DynamicObject costRecordInfo = costRecords[i];
            Long calOrgId = costRecordInfo.getDynamicObject("calorg").getLong("id");
            String writeBackMessage = (String)ParamsHelper.getAppParam((long)calOrgId, (String)"issameperiodwriteback");
            if (writeBackMessage == null) {
                writeBackMessage = "A";
            }
            boolean writeBack = false;
            if ("A".equals(writeBackMessage)) {
                writeBack = this.isWriteBackCostRecord(costRecordInfo, groupMap);
            }
            if (writeBack) {
                costRecordInfoA = this.dealCostRecordByEntry(costRecordInfo, groupMap);
            } else {
                costRecordInfoA = this.splitCostRecord(costRecordInfo, groupMap, writeBack, false, null, null);
                this.createCostAdjustBill(costRecordInfoA, groupMap);
            }
            this.standardCreateCostAdustBill(costRecordInfoA, groupMap, inCalBillMap, costRecordInfoA);
            this.saveCostRecordInfo(costRecordInfo);
            if (writeBack) {
                for (DynamicObject entry : costRecordInfo.getDynamicObjectCollection("entry")) {
                    entryIdSet.add(entry.getLong("id"));
                }
                idSet.add(costRecordInfo.getLong("id"));
            }
            if ((recordInfoAEntrys = costRecordInfoA.getDynamicObjectCollection("entry")).size() <= 0) continue;
            ancestorIds.add(((DynamicObject)recordInfoAEntrys.get(0)).getLong("ancestorbillid"));
        }
        this.auditCostAdjust(this.costAdjustIds, false);
        this.auditCostAdjust(this.diffCostAdjustIds, true);
        if (ancestorIds.size() > 0) {
            DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("update t_cal_calcostrecord set fissubbillinvoiceverify = '1' where fid in (" + StringUtils.join((Object[])ancestorIds.toArray(), (char)',') + ") and fissubbillinvoiceverify = '0'"));
        }
        if (this.isNewBalance) {
            if (!idSet.isEmpty()) {
                new BalanceOpInvoker().invokeCostRecordUpdateBalOp(idSet, BalanceSourceEnum.WRITE_OFF);
            }
        } else if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DAILY_BAL).booleanValue() && entryIdSet.size() > 0) {
            new BalanceCalculator().updateBalance4Others(entryIdSet.toArray(), BalanceSourceEnum.WRITE_OFF, idSet);
        }
    }

    private void auditCostAdjust(Set<Long> costAdjustBillIds, boolean isDiff) {
        String entityNumber;
        String string = entityNumber = isDiff ? "cal_stdcostdiffbill" : "cal_costadjust_subentity";
        if (costAdjustBillIds.isEmpty()) {
            return;
        }
        DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])costAdjustBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        String auditorId = costAdjusts[0].getDynamicObject("auditor").getString("id");
        List<CostAdjustDetailParams> paramsList = this.buildCostAdjustDetail(costAdjusts, isDiff);
        OperateOption option = OperateOption.create();
        String params = SerializationUtils.toJsonString(paramsList);
        option.setVariableValue("CostAdjustDetailParms", params);
        option.setVariableValue("ishasright", "true");
        if (!StringUtils.isEmpty((CharSequence)auditorId) && !"0".equals(auditorId)) {
            option.setVariableValue("auditor_id", auditorId);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)entityNumber, (DynamicObject[])costAdjusts, (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff0c\u7cfb\u7edf\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurWriteOffServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]));
            if (!errors.isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
            }
            msg.append(result.getMessage()).append('\n');
            throw new KDBizException(msg.toString());
        }
    }

    private void getInCalBillMap(Set<Long> purIds, Map<Long, DynamicObject> inCalBillMap) {
        DynamicObjectCollection inCalBills = QueryServiceHelper.query((String)"cal_incalbill", (String)"bizbillid,localcurrency,localcurrency.id,entry.bizbillentryid,entry.amount,entry.baseqty,entry.localamount,entry.localtaxamount,exratetable.id,exratedate", (QFilter[])new QFilter("bizbillid", "in", purIds).toArray());
        for (DynamicObject inCalBill : inCalBills) {
            long bizBillEntryId = inCalBill.getLong("entry.bizbillentryid");
            inCalBillMap.put(bizBillEntryId, inCalBill);
        }
    }

    private void standardCreateCostAdustBill(DynamicObject costRecordInfo, Map<Long, DynamicObject> groupMap, Map<Long, DynamicObject> inCalBillMap, DynamicObject costRecordInfoA) {
        boolean enableStandardCostOrMeria = this.enableStandardCostOrMeria(costRecordInfo);
        HashMap<String, DynamicObject> costAdjustMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection entrys = costRecordInfo.getDynamicObjectCollection("entry");
        boolean noUpdFlag = this.notUpdBalBizType.contains(costRecordInfo.getDynamicObject("biztype").getPkValue());
        if (noUpdFlag) {
            this.notUpdCostRecordIds.add(costRecordInfo.getLong("id"));
        }
        for (DynamicObject recordEntry : entrys) {
            String accountType = recordEntry.getString("accounttype");
            if (!enableStandardCostOrMeria && !AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
            this.createStandardCostAdjustBill(costRecordInfo, recordEntry, groupMap, costAdjustMap, inCalBillMap, costRecordInfoA);
        }
        if (costAdjustMap.isEmpty()) {
            return;
        }
        ArrayList costAdjustList = new ArrayList(costAdjustMap.size());
        for (Map.Entry mapEntry : costAdjustMap.entrySet()) {
            costAdjustList.add(mapEntry.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])costAdjustList.toArray(new DynamicObject[costAdjustList.size()]));
        for (DynamicObject info : costAdjustList) {
            this.diffCostAdjustIds.add(info.getLong("id"));
        }
    }

    private boolean enableStandardCostOrMeria(DynamicObject costRecordInfo) {
        return costRecordInfo.getDynamicObject("costaccount").getBoolean("enablestandardcost");
    }

    private void createStandardCostAdjustBill(DynamicObject costRecordInfo, DynamicObject recordEntry, Map<Long, DynamicObject> groupMap, Map<String, DynamicObject> costAdjustMap, Map<Long, DynamicObject> inCalBillMap, DynamicObject costRecordInfoA) {
        Long purEntryID = recordEntry.getLong("bizbillentryid");
        DynamicObject writeOffInfo = groupMap.get(purEntryID);
        if (writeOffInfo == null) {
            return;
        }
        DynamicObjectCollection writeOffEntrys = writeOffInfo.getDynamicObjectCollection("entry");
        BigDecimal apAmount = this.getApAmount(costRecordInfoA, writeOffInfo);
        BigDecimal materialCost = recordEntry.getBigDecimal("materialcost");
        if (this.isOutSource) {
            materialCost = recordEntry.getBigDecimal("processcost");
        }
        BigDecimal preDiffAmt = BigDecimal.ZERO;
        int i = 0;
        for (DynamicObject writeOffEntry : writeOffEntrys) {
            boolean isLastEntry = i == writeOffEntrys.size() - 1;
            String key = this.buildKey(writeOffEntry);
            DynamicObject costAdjustBill = costAdjustMap.get(key);
            if (costAdjustBill == null) {
                Date bizDate = this.getWriteOffDate(costRecordInfoA, groupMap);
                costAdjustBill = this.createStandardCostAdjustHead(costRecordInfo, writeOffInfo, writeOffEntry, bizDate);
            }
            if (!isLastEntry) {
                preDiffAmt = preDiffAmt.add(this.addStandardCostAdjustBillEntry(costRecordInfo, recordEntry, costAdjustBill, writeOffEntry, groupMap, inCalBillMap, null));
            } else {
                BigDecimal diffAmt = apAmount.subtract(materialCost).subtract(preDiffAmt);
                this.addStandardCostAdjustBillEntry(costRecordInfo, recordEntry, costAdjustBill, writeOffEntry, groupMap, inCalBillMap, diffAmt);
            }
            ++i;
            if (costAdjustBill.getDynamicObjectCollection("entryentity").size() == 0) continue;
            costAdjustMap.put(key, costAdjustBill);
        }
    }

    private BigDecimal addStandardCostAdjustBillEntry(DynamicObject costRecordInfo, DynamicObject recordEntry, DynamicObject costAdjustBill, DynamicObject writeOffEntry, Map<Long, DynamicObject> groupMap, Map<Long, DynamicObject> inCalBillMap, BigDecimal diffAmt) {
        BigDecimal adjustAmt = BigDecimal.ZERO;
        adjustAmt = diffAmt != null ? diffAmt : this.getStandardVertifyAmt(writeOffEntry, costRecordInfo, inCalBillMap, recordEntry);
        if (adjustAmt.compareTo(BigDecimal.ZERO) == 0) {
            return adjustAmt;
        }
        Long purEntryID = recordEntry.getLong("bizbillentryid");
        DynamicObject writeOffInfo = groupMap.get(purEntryID);
        if (writeOffInfo == null) {
            return adjustAmt;
        }
        String lot = recordEntry.getString("lot");
        long warehsBillID = recordEntry.getLong("warehouse_id");
        long locationID = recordEntry.getLong("location_id");
        long ownerID = recordEntry.getLong("owner_id");
        long assistId = recordEntry.getLong("assist_id");
        long srcBillType = 0L;
        int srcEntitySeq = 0;
        long srcBillId = 0L;
        long srcEntryId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".createCostAdjustBill1"), (String)"ap_finapbill", (String)"id,billtypeid,detailentry.id,detailentry.seq", (QFilter[])new QFilter[]{new QFilter("detailentry.id", "=", (Object)writeOffEntry.getLong("e_billentryid"))}, null);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                srcBillType = row.getLong("billtypeid");
                srcEntitySeq = row.getInteger("detailentry.seq");
                srcBillId = row.getLong("id");
                srcEntryId = row.getLong("detailentry.id");
            }
        }
        DynamicObject entry = costAdjustBill.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costRecordInfo.get("storageorgunit"));
        entry.set("material", recordEntry.get("material"));
        entry.set("lot", (Object)lot);
        costAdjustBill.set("biztype", (Object)"A");
        entry.set("adjustamt", (Object)adjustAmt);
        entry.set("diff_h", (Object)adjustAmt);
        entry.set("warehouse", (Object)warehsBillID);
        entry.set("location", (Object)locationID);
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", (Object)ownerID);
        entry.set("ecostcenter", (Object)recordEntry.getLong("ecostcenter_id"));
        entry.set("assist", (Object)assistId);
        entry.set("invbilltype", costRecordInfo.get("billtype"));
        entry.set("invbillnum", (Object)costRecordInfo.getString("billno"));
        entry.set("inventryseq", recordEntry.get("seq"));
        entry.set("invbillid", costRecordInfo.get("id"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("invbillentryid", recordEntry.get("id"));
        entry.set("srcbilltype", (Object)srcBillType);
        entry.set("srcbillnum", (Object)writeOffEntry.getString("e_billno"));
        entry.set("srcentryseq", (Object)srcEntitySeq);
        entry.set("srcbillid", (Object)srcBillId);
        entry.set("srcbillentryid", (Object)srcEntryId);
        entry.set("srcbizentityobject", (Object)"ap_finapbill");
        entry.set("baseunit", recordEntry.get("baseunit"));
        entry.set("project", recordEntry.get("project"));
        entry.set("invtype", recordEntry.get("invtype"));
        entry.set("invstatus", recordEntry.get("invstatus"));
        entry.set("mversion", recordEntry.get("mversion"));
        entry.set("tracknumber", recordEntry.get("tracknumber"));
        entry.set("configuredcode", recordEntry.get("configuredcode"));
        entry.set("noupdatecalfields", recordEntry.get("noupdatecalfields"));
        entry.set("stocktype", recordEntry.get("stocktype"));
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        CommonSettingHelper.setExFieldValue((Set)exFieldSet, (MainEntityType)MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill"), (MainEntityType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord"), (DynamicObject)entry, (DynamicObject)recordEntry);
        return adjustAmt;
    }

    private BigDecimal getStandardVertifyAmt(DynamicObject writeOffEntry, DynamicObject costRecordInfo, Map<Long, DynamicObject> inCalBillMap, DynamicObject recordEntry) {
        BigDecimal exchangeRate4sourceUSD;
        BigDecimal exchangeRate4TargetUSD;
        Map rateMap;
        BigDecimal exchangeRate;
        ExchangeRateHelper exchangeRateHelper;
        BigDecimal adjustAmt = BigDecimal.ZERO;
        DynamicObject localcurrency = costRecordInfo.getDynamicObject("localcurrency");
        int amtPrecision = localcurrency.getInt("amtprecision");
        DynamicObject costAccount = costRecordInfo.getDynamicObject("costaccount");
        boolean supportTaxAmt = this.costAccountSupportTaxAmtMap.get(costRecordInfo.getDynamicObject("costaccount").getLong("id"));
        Long apBillId = writeOffEntry.getLong("e_billid");
        DynamicObject apBillInfo = this.apBillMap.get(apBillId);
        boolean isTaxDeduction = apBillInfo.getBoolean("istaxdeduction");
        BigDecimal apLocalAmount = null;
        BigDecimal interCostAmt = writeOffEntry.getBigDecimal("e_verifyintercostamt");
        apLocalAmount = interCostAmt != null && interCostAmt.compareTo(BigDecimal.ZERO) != 0 ? interCostAmt : (supportTaxAmt ? writeOffEntry.getBigDecimal("e_localverifytaxamt") : (isTaxDeduction ? writeOffEntry.getBigDecimal("e_localverifyamt") : writeOffEntry.getBigDecimal("e_localverifytaxamt")));
        DynamicObject calOrg = costRecordInfo.getDynamicObject("calorg");
        boolean pur_have_swappl = false;
        if (this.pur_have_swapplParamMap.containsKey(calOrg.getLong("id"))) {
            pur_have_swappl = this.pur_have_swapplParamMap.get(calOrg.getLong("id"));
        } else {
            pur_have_swappl = (Boolean)ParamsHelper.getAppParam((long)calOrg.getLong("id"), (String)"pur_have_swappl");
            this.pur_have_swapplParamMap.put(calOrg.getLong("id"), pur_have_swappl);
        }
        BigDecimal swappl = writeOffEntry.getBigDecimal("e_swappl");
        if (!pur_have_swappl) {
            apLocalAmount = apLocalAmount.subtract(swappl);
        }
        BigDecimal verifyBaseQty = writeOffEntry.getBigDecimal("e_verifybaseqty");
        DynamicObject apLocalCurrency = writeOffEntry.getDynamicObject("e_basecurrency");
        DynamicObject exrateTable = apBillInfo.getDynamicObject("exratetable");
        Date exrateDate = apBillInfo.getDate("exratedate");
        Date apBizDate = writeOffEntry.getDate("e_billdate");
        Long purEntryID = recordEntry.getLong("bizbillentryid");
        DynamicObject inCalBill = inCalBillMap.get(purEntryID);
        BigDecimal incalbillAmount = null;
        incalbillAmount = supportTaxAmt ? inCalBill.getBigDecimal("entry.localtaxamount") : (isTaxDeduction ? inCalBill.getBigDecimal("entry.localamount") : inCalBill.getBigDecimal("entry.localtaxamount"));
        BigDecimal baseQty = inCalBill.getBigDecimal("entry.baseqty");
        long localcurrencyId = inCalBill.getLong("localcurrency.id");
        DynamicObject calBillLocalCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)localcurrencyId, (String)"bd_currency");
        long calBillExrateTable = inCalBill.getLong("exratetable.id");
        Date calBillExrateDate = inCalBill.getDate("exratedate");
        if (apLocalCurrency.getLong("id") != localcurrency.getLong("id")) {
            exchangeRateHelper = new ExchangeRateHelper(apLocalCurrency, localcurrency, costAccount, exrateDate == null ? apBizDate : exrateDate, exrateTable.getLong("id"));
            exchangeRate = exchangeRateHelper.getExchangeRate();
            if (exchangeRate != null) {
                apLocalAmount = exchangeRateHelper.getTargetAmount(exchangeRate, apLocalAmount, amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate"));
            } else {
                rateMap = exchangeRateHelper.getExchangeRate4TargetUSD();
                exchangeRate4TargetUSD = (BigDecimal)rateMap.get("exchangeRate4TargetUSD");
                exchangeRate4sourceUSD = (BigDecimal)rateMap.get("exchangeRate4sourceUSD");
                apLocalAmount = exchangeRateHelper.getTargetAmount(exchangeRate4sourceUSD, exchangeRateHelper.getTargetAmount(exchangeRate4TargetUSD, apLocalAmount, amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate4TargetUSD")), amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate4sourceUSD"));
            }
        }
        if (calBillLocalCurrency.getLong("id") != localcurrency.getLong("id")) {
            exchangeRateHelper = new ExchangeRateHelper(calBillLocalCurrency, localcurrency, costAccount, calBillExrateDate == null ? apBizDate : calBillExrateDate, calBillExrateTable);
            exchangeRate = exchangeRateHelper.getExchangeRate();
            if (exchangeRate != null) {
                incalbillAmount = exchangeRateHelper.getTargetAmount(exchangeRate, incalbillAmount, amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate"));
            } else {
                rateMap = exchangeRateHelper.getExchangeRate4TargetUSD();
                exchangeRate4TargetUSD = (BigDecimal)rateMap.get("exchangeRate4TargetUSD");
                exchangeRate4sourceUSD = (BigDecimal)rateMap.get("exchangeRate4sourceUSD");
                incalbillAmount = exchangeRateHelper.getTargetAmount(exchangeRate4sourceUSD, exchangeRateHelper.getTargetAmount(exchangeRate4TargetUSD, incalbillAmount, amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate4TargetUSD")), amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate4sourceUSD"));
            }
        }
        apLocalAmount = apLocalAmount.divide(verifyBaseQty, 10, 4);
        incalbillAmount = incalbillAmount.divide(baseQty, 10, 4);
        adjustAmt = apLocalAmount.subtract(incalbillAmount).multiply(verifyBaseQty);
        adjustAmt = adjustAmt.setScale(amtPrecision, 4);
        return adjustAmt;
    }

    private DynamicObject createStandardCostAdjustHead(DynamicObject costRecordInfo, DynamicObject writeOffInfo, DynamicObject writeOffEntry, Date bizDate) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        costAdjustBill.set("cstype", writeOffEntry.get("e_asstacttype"));
        costAdjustBill.set("custsupplier", writeOffEntry.get("e_asstact"));
        costAdjustBill.set("currency", costRecordInfo.get("localcurrency"));
        costAdjustBill.set("bizdate", (Object)bizDate);
        costAdjustBill.set("bookdate", (Object)bizDate);
        costAdjustBill.set("biztype", (Object)"A");
        costAdjustBill.set("billstatus", (Object)"B");
        if (this.isOutSource) {
            costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue());
        } else {
            costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue());
        }
        costAdjustBill.set("costaccount", (Object)costRecordInfo.getDynamicObject("costaccount"));
        Object accountID = costRecordInfo.getDynamicObject("costaccount").get("masterid");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingle((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        costAdjustBill.set("calorg", costAccont.get("calorg"));
        costAdjustBill.set("billtype", costRecordInfo.get("billtype"));
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("createtime", (Object)date);
        DynamicObjectCollection entrys = writeOffInfo.getDynamicObjectCollection("entry");
        Long apBillId = ((DynamicObject)entrys.get(0)).getLong("e_billid");
        DynamicObject apBillInfo = this.apBillMap.get(apBillId);
        Long userId = (Long)apBillInfo.getDynamicObject("creator").getPkValue();
        costAdjustBill.set("creator_id", (Object)userId);
        Long auditorId = (Long)apBillInfo.getDynamicObject("auditor").getPkValue();
        costAdjustBill.set("auditor_id", (Object)auditorId);
        costAdjustBill.set("adminorg", (Object)costRecordInfo.getDynamicObject("adminorg"));
        String number = BillNoHelper.getBillNo((String)"cal_stdcostdiffbill", (DynamicObject)costAdjustBill, (String)costAccont.getString("calorg_id"));
        costAdjustBill.set("billno", (Object)number);
        return costAdjustBill;
    }

    private void createCostAdjustBill(DynamicObject costRecordInfo, Map<Long, DynamicObject> groupMap) {
        HashMap<String, DynamicObject> costAdjustMap = new HashMap<String, DynamicObject>(16);
        DynamicObjectCollection entrys = costRecordInfo.getDynamicObjectCollection("entry");
        String accountType = null;
        for (DynamicObject recordEntry : entrys) {
            accountType = recordEntry.getString("accounttype");
            if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
            this.createCostAdjustBill(costRecordInfo, recordEntry, groupMap, costAdjustMap);
        }
        if (costAdjustMap.isEmpty()) {
            return;
        }
        ArrayList costAdjustList = new ArrayList(costAdjustMap.size());
        for (Map.Entry mapEntry : costAdjustMap.entrySet()) {
            costAdjustList.add(mapEntry.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])costAdjustList.toArray(new DynamicObject[costAdjustList.size()]));
        for (DynamicObject info : costAdjustList) {
            this.costAdjustIds.add(info.getLong("id"));
            this.prevInAdjustIds.add(info.getLong("id"));
        }
    }

    private List<CostAdjustDetailParams> buildCostAdjustDetail(DynamicObject[] costAdjusts, boolean flag) {
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        Long[] defaultElementIds = CostElementHelper.getDefaultMaterialElements();
        Map materiaCostTypeMap = CostElementHelper.getMaterialCostElement((DynamicObject[])costAdjusts);
        for (DynamicObject dynamic : costAdjusts) {
            boolean isCostRecordDetail = false;
            if (this.calbycostelementParamMap.containsKey(dynamic.getLong("costaccount_id"))) {
                isCostRecordDetail = this.calbycostelementParamMap.get(dynamic.getLong("costaccount_id"));
            } else {
                isCostRecordDetail = ParamsHelper.getCostElementByCostAccount((long)dynamic.getLong("costaccount_id"));
                this.calbycostelementParamMap.put(dynamic.getLong("costaccount_id"), isCostRecordDetail);
            }
            DynamicObjectCollection costadjustEntry = dynamic.getDynamicObjectCollection("entryentity");
            long costTypeid = this.getCostTypeId(dynamic);
            for (DynamicObject entry : costadjustEntry) {
                long entryId = entry.getLong("id");
                long materialId = entry.getLong("material.id");
                Long[] elementIds = defaultElementIds;
                if (isCostRecordDetail) {
                    Long[] middleElementIds = (Long[])materiaCostTypeMap.get(costTypeid + "|" + materialId);
                    if (middleElementIds != null) {
                        elementIds = middleElementIds;
                    }
                    if (this.isOutSource) {
                        elementIds = CostElementHelper.getOutSourceProcessElements();
                    }
                }
                CostAdjustDetailParams param = new CostAdjustDetailParams();
                param.setAdjustAmt(entry.getBigDecimal("adjustamt"));
                param.setEntryid((Object)entryId);
                if (flag) {
                    param.setDdiff_h(entry.getBigDecimal("adjustamt"));
                }
                param.setCostElementId((Object)elementIds[1]);
                param.setCostSubElementId((Object)elementIds[0]);
                long invbillid = entry.getLong("invbillid");
                if (flag && this.notUpdCostRecordIds.contains(invbillid)) {
                    Long[] outSourceProcessElements = CostElementHelper.getOutSourceProcessElements();
                    param.setCostElementId((Object)outSourceProcessElements[1]);
                    param.setCostSubElementId((Object)outSourceProcessElements[0]);
                }
                paramsList.add(param);
            }
        }
        return paramsList;
    }

    private boolean isWriteBackCostRecord(DynamicObject costRecordInfo, Map<Long, DynamicObject> groupMap) {
        boolean hasVoucher = costRecordInfo.getBoolean("isvoucher");
        boolean isInitBill = costRecordInfo.getBoolean("isinitbill");
        Long costAccountID = costRecordInfo.getLong("costaccount.id");
        String costAcctNum = costRecordInfo.getString("costaccount.number");
        DynamicObject currentPeriod = (DynamicObject)this.accountPeriod.get(costAccountID);
        if (currentPeriod == null) {
            currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountID);
            this.accountPeriod.put(costAccountID, currentPeriod);
        }
        boolean isGTCurrentPeriod = false;
        DynamicObject bizPeriod = BusinessDataServiceHelper.loadSingle((Object)costRecordInfo.getDynamicObject("period").getLong("id"), (String)"bd_period", (String)"id,begindate,enddate");
        if (currentPeriod == null) {
            String acctPeriodMsg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"AbstractWriteOffServiceProcess_4", (String)"fi-cal-business", (Object[])new Object[0]);
            acctPeriodMsg = String.format(acctPeriodMsg, costAcctNum);
            throw new KDBizException(acctPeriodMsg);
        }
        int comparers = PeriodHelper.compare2period((DynamicObject)bizPeriod, (DynamicObject)currentPeriod);
        if (comparers == 0 || comparers == 1) {
            isGTCurrentPeriod = true;
        }
        boolean isSplitCreate = costRecordInfo.getBoolean("issplitcreate");
        boolean isSamePeriod = true;
        Long recordPeriodId = costRecordInfo.getDynamicObject("period").getLong("id");
        DynamicObject recordPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)recordPeriodId).toArray());
        Date startDate = recordPeriod.getDate("begindate");
        Date endDate = recordPeriod.getDate("enddate");
        DynamicObjectCollection recordEntrys = costRecordInfo.getDynamicObjectCollection("entry");
        block0: for (DynamicObject entry : recordEntrys) {
            Long purEntryID = entry.getLong("bizbillentryid");
            DynamicObject writeOffInfo = groupMap.get(purEntryID);
            if (writeOffInfo == null) continue;
            DynamicObjectCollection apInfos = writeOffInfo.getDynamicObjectCollection("entry");
            for (DynamicObject apInfo : apInfos) {
                Date apdate = apInfo.getDate("e_billdate");
                if (apdate.compareTo(startDate) >= 0 && apdate.before(endDate)) continue;
                isSamePeriod = false;
                continue block0;
            }
        }
        return !hasVoucher && isGTCurrentPeriod && !isSplitCreate && !isInitBill && isSamePeriod;
    }

    private DynamicObject dealCostRecordByEntry(DynamicObject costRecordInfo, Map<Long, DynamicObject> groupMap) {
        DynamicObject costRecordInfoA = null;
        DynamicObjectCollection recordEntrys = costRecordInfo.getDynamicObjectCollection("entry");
        DynamicObjectCollection writeBackEntrys = new DynamicObjectCollection();
        DynamicObjectCollection unWriteBackEntrys = new DynamicObjectCollection();
        DynamicObjectCollection afterWriteBackEntrys = new DynamicObjectCollection();
        DynamicObjectCollection createCostAdjustBillEntrys = new DynamicObjectCollection();
        HashSet<Long> createCostAdjustBillEntryIds = new HashSet<Long>();
        for (DynamicObject entry : recordEntrys) {
            String accountType = entry.getString("accounttype");
            if (AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(accountType) || AccountTypeEnum.FIN_FOUT.getValue().equals(accountType) || AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                this.entryWriteBackMap.put(entry.getLong("bizbillentryid"), false);
                createCostAdjustBillEntryIds.add(entry.getLong("ancestorentryid"));
                unWriteBackEntrys.add((Object)entry);
                continue;
            }
            writeBackEntrys.add((Object)entry);
        }
        if (writeBackEntrys.size() > 0) {
            costRecordInfo.set("entry", (Object)writeBackEntrys);
            this.dealParentRecord(costRecordInfo, groupMap);
            DynamicObjectCollection entrys = costRecordInfo.getDynamicObjectCollection("entry");
            afterWriteBackEntrys.addAll((Collection)entrys);
            if (unWriteBackEntrys.size() > 0) {
                afterWriteBackEntrys.addAll((Collection)unWriteBackEntrys);
            }
            costRecordInfo.set("entry", (Object)afterWriteBackEntrys);
        }
        costRecordInfoA = this.splitCostRecord(costRecordInfo, groupMap, true, false, null, null);
        DynamicObjectCollection recordAEntrys = costRecordInfoA.getDynamicObjectCollection("entry");
        if (createCostAdjustBillEntryIds.size() > 0) {
            for (DynamicObject entry : recordAEntrys) {
                if (!createCostAdjustBillEntryIds.contains(entry.getLong("ancestorentryid"))) continue;
                createCostAdjustBillEntrys.add((Object)entry);
            }
            if (createCostAdjustBillEntrys.size() > 0) {
                costRecordInfoA.set("entry", (Object)createCostAdjustBillEntrys);
                this.createCostAdjustBill(costRecordInfoA, groupMap);
            }
            costRecordInfoA.set("entry", (Object)recordAEntrys);
        }
        logger.info("dealCostRecordByEntry/costRecordInfoA=" + costRecordInfoA);
        return costRecordInfoA;
    }

    private void dealParentRecord(DynamicObject costRecordInfo, Map<Long, DynamicObject> groupMap) {
        DynamicObjectCollection recordEntrys = costRecordInfo.getDynamicObjectCollection("entry");
        HashMap<Long, Object[]> costRecordDetailMap = new HashMap<Long, Object[]>(16);
        Long[] costTypeIds = new Long[]{this.getCostTypeId(costRecordInfo)};
        HashSet<Long> materialIdSet = new HashSet<Long>();
        for (DynamicObject entry : recordEntrys) {
            materialIdSet.add(entry.getLong("material.id"));
        }
        Map cosTypeMaterialMap = CostElementHelper.getCostElementsByMaterial((long)costRecordInfo.getDynamicObject("calorg").getLong("id"), (Long[])costTypeIds, (Long[])materialIdSet.toArray(new Long[0]));
        boolean isCostDetail = false;
        if (this.calbycostelementParamMap.containsKey(costRecordInfo.getDynamicObject("costaccount").getLong("id"))) {
            isCostDetail = this.calbycostelementParamMap.get(costRecordInfo.getDynamicObject("costaccount").getLong("id"));
        } else {
            isCostDetail = ParamsHelper.getCostElementByCostAccount((long)costRecordInfo.getDynamicObject("costaccount").getLong("id"));
            this.calbycostelementParamMap.put(costRecordInfo.getDynamicObject("costaccount").getLong("id"), isCostDetail);
        }
        long defalutElementId = CostElementHelper.getDefalutMaterialId();
        for (DynamicObject entry : recordEntrys) {
            BigDecimal purQty;
            Long purEntryID = entry.getLong("bizbillentryid");
            DynamicObject writeOffRecord = groupMap.get(purEntryID);
            if (writeOffRecord == null) continue;
            BigDecimal baseqty = entry.getBigDecimal("baseqty");
            if (baseqty.compareTo(purQty = writeOffRecord.getBigDecimal("verifybaseqty")) == 0) {
                this.fullWriteOff(costRecordInfo, entry, writeOffRecord, costRecordDetailMap, cosTypeMaterialMap, isCostDetail, defalutElementId);
                continue;
            }
            this.partWriteOff(costRecordInfo, entry, writeOffRecord, costRecordDetailMap, cosTypeMaterialMap, isCostDetail, defalutElementId);
        }
        this.dealCostRecordDetail(costRecordDetailMap, costRecordInfo.getLong("id"));
    }

    private void dealCostRecordDetail(Map<Long, Object[]> costRecordDetailMap, long id) {
        if (costRecordDetailMap.isEmpty()) {
            return;
        }
        Set<Long> entryIds = costRecordDetailMap.keySet();
        ArrayList<Object[]> objects = new ArrayList<Object[]>(costRecordDetailMap.values());
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.eq, (Object)id)});){
            ctx.set();
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getCostRecordDetailSql(), objects);
            PurWriteOffServiceProcess.caculateDetailUnitActual(entryIds);
            CostElementHelper.calCostpricesourceRecordCost((Long[])entryIds.toArray(new Long[0]), (String)"PurWriteOff");
        }
    }

    public static void caculateDetailUnitActual(Set<Long> entryIdSet) {
        DynamicObject[] costDetailArray;
        for (DynamicObject costDetail : costDetailArray = BusinessDataServiceHelper.load((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,costsubelement.id,baseqty,standardcost,unitstandardcost,currency.priceprecision", (QFilter[])new QFilter("entryid", "in", entryIdSet).toArray())) {
            BigDecimal actualcost = costDetail.getBigDecimal("actualcost");
            BigDecimal baseqty = costDetail.getBigDecimal("baseqty");
            if (baseqty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal unitActualcost = actualcost.divide(baseqty, 10, 4);
            costDetail.set("unitactualcost", (Object)unitActualcost);
        }
        SaveServiceHelper.save((DynamicObject[])costDetailArray);
    }

    private String getCostRecordDetailSql() {
        return "update t_cal_costrecord_detail set factualcost = factualcost + ?   where fentryid = ? and fcostsubelementid = ?";
    }

    private void fullWriteOff(DynamicObject costRecordInfo, DynamicObject recordEntry, DynamicObject writeOffRecord, Map<Long, Object[]> costRecordDetailMap, Map<String, Long[]> cosTypeMaterialMap, Boolean isCostDetail, Long defalutElementId) {
        BigDecimal apWriteOffAmt = this.getApAmount(costRecordInfo, writeOffRecord);
        int pricePrecision = 10;
        BigDecimal baseQty = recordEntry.getBigDecimal("baseqty");
        if (this.isOutSource) {
            BigDecimal processCost = apWriteOffAmt;
            BigDecimal oldProcessCost = recordEntry.getBigDecimal("processcost");
            recordEntry.set("processcost", (Object)processCost);
            BigDecimal unitProcessCost = apWriteOffAmt.divide(baseQty, pricePrecision, 4);
            recordEntry.set("unitprocesscost", (Object)unitProcessCost);
            long entryId = recordEntry.getLong("id");
            processCost = processCost.subtract(oldProcessCost);
            long elementId = defalutElementId;
            if (isCostDetail.booleanValue()) {
                Long[] elementIds = CostElementHelper.getOutSourceProcessElements();
                elementId = elementIds[0];
            }
            costRecordDetailMap.put(entryId, new Object[]{processCost, entryId, elementId});
        } else {
            BigDecimal materialCost = apWriteOffAmt;
            BigDecimal oldMaterialCost = recordEntry.getBigDecimal("materialcost");
            recordEntry.set("materialcost", (Object)materialCost);
            BigDecimal unitPurchaseCost = apWriteOffAmt.divide(baseQty, pricePrecision, 4);
            recordEntry.set("unitmaterialcost", (Object)unitPurchaseCost);
            long entryId = recordEntry.getLong("id");
            long costTypeId = this.getCostTypeId(costRecordInfo);
            long materialId = recordEntry.getLong("material.id");
            materialCost = materialCost.subtract(oldMaterialCost);
            long elementId = defalutElementId;
            Long[] elementIds = cosTypeMaterialMap.get(costTypeId + "|" + materialId);
            if (isCostDetail.booleanValue() && elementIds != null) {
                elementId = elementIds[0];
            }
            costRecordDetailMap.put(entryId, new Object[]{materialCost, entryId, elementId});
        }
    }

    private void partWriteOff(DynamicObject costRecordInfo, DynamicObject recordEntry, DynamicObject writeOffRecord, Map<Long, Object[]> costRecordDetailMap, Map<String, Long[]> cosTypeMaterialMap, Boolean isCostDetail, Long defalutElementId) {
        BigDecimal apWriteOffAmt = this.getApAmount(costRecordInfo, writeOffRecord);
        BigDecimal purQty = writeOffRecord.getBigDecimal("verifybaseqty");
        DynamicObject localcurrency = costRecordInfo.getDynamicObject("localcurrency");
        int amtPrecision = localcurrency.getInt("amtprecision");
        int pricePrecision = 10;
        BigDecimal baseQty = recordEntry.getBigDecimal("baseqty");
        if (this.isOutSource) {
            BigDecimal unitProcessCost = apWriteOffAmt.divide(purQty, pricePrecision, 4);
            recordEntry.set("unitprocesscost", (Object)unitProcessCost);
            BigDecimal processCost = unitProcessCost.multiply(baseQty).setScale(amtPrecision, 4);
            BigDecimal oldProcessCost = recordEntry.getBigDecimal("processcost");
            recordEntry.set("processcost", (Object)processCost);
            long entryId = recordEntry.getLong("id");
            processCost = processCost.subtract(oldProcessCost);
            long elementId = defalutElementId;
            if (isCostDetail.booleanValue()) {
                Long[] elementIds = CostElementHelper.getOutSourceProcessElements();
                elementId = elementIds[0];
            }
            costRecordDetailMap.put(entryId, new Object[]{processCost, entryId, elementId});
        } else {
            BigDecimal unitMaterialCost = apWriteOffAmt.divide(purQty, pricePrecision, 4);
            recordEntry.set("unitmaterialcost", (Object)unitMaterialCost);
            BigDecimal materialCost = unitMaterialCost.multiply(baseQty).setScale(amtPrecision, 4);
            BigDecimal oldMaterialCost = recordEntry.getBigDecimal("materialcost");
            recordEntry.set("materialcost", (Object)materialCost);
            long entryId = recordEntry.getLong("id");
            long costTypeId = this.getCostTypeId(costRecordInfo);
            long materialId = recordEntry.getLong("material.id");
            materialCost = materialCost.subtract(oldMaterialCost);
            long elementId = defalutElementId;
            Long[] elementIds = cosTypeMaterialMap.get(costTypeId + "|" + materialId);
            if (isCostDetail.booleanValue() && elementIds != null) {
                elementId = elementIds[0];
            }
            costRecordDetailMap.put(entryId, new Object[]{materialCost, entryId, elementId});
        }
    }

    private void createCostAdjustBill(DynamicObject costRecordInfo, DynamicObject costRecordEntry, Map<Long, DynamicObject> groupMap, Map<String, DynamicObject> costAdjustMap) {
        Long purEntryID = costRecordEntry.getLong("bizbillentryid");
        DynamicObject writeOffInfo = groupMap.get(purEntryID);
        if (writeOffInfo == null) {
            return;
        }
        BigDecimal unitMaterialCost = costRecordEntry.getBigDecimal("unitmaterialcost");
        BigDecimal materialCost = costRecordEntry.getBigDecimal("materialcost");
        BigDecimal unitProcesscostCost = costRecordEntry.getBigDecimal("unitprocesscost");
        BigDecimal processcostCost = costRecordEntry.getBigDecimal("processcost");
        DynamicObjectCollection writeOffEntrys = writeOffInfo.getDynamicObjectCollection("entry");
        BigDecimal assitWfBaseQtyAll = BigDecimal.ZERO;
        BigDecimal mainWfBaseQty = costRecordEntry.getBigDecimal("baseqty");
        for (DynamicObject wfEntryDyc : writeOffEntrys) {
            assitWfBaseQtyAll = assitWfBaseQtyAll.add(wfEntryDyc.getBigDecimal("e_verifybaseqty"));
        }
        boolean qtyEqualWfAll = mainWfBaseQty.equals(assitWfBaseQtyAll);
        BigDecimal preToTalDiffAmt = BigDecimal.ZERO;
        BigDecimal preToTalAssitWfQty = BigDecimal.ZERO;
        for (int i = 0; i < writeOffEntrys.size(); ++i) {
            DynamicObject writeOffEntry = (DynamicObject)writeOffEntrys.get(i);
            String key = this.buildKey(writeOffEntry);
            DynamicObject costAdjustBill = costAdjustMap.get(key);
            if (costAdjustBill == null) {
                costAdjustBill = this.createCostAdjustHead(costRecordInfo, writeOffInfo, writeOffEntry);
            }
            BigDecimal diffAmt = BigDecimal.ZERO;
            BigDecimal entryApAmt = this.getApAmountByWfEntryDyc(costRecordInfo, writeOffEntry);
            DynamicObject currencyDyc = costRecordInfo.getDynamicObject("localcurrency");
            int amtPrecision = currencyDyc.getInt("amtprecision");
            if (this.isOutSource) {
                materialCost = processcostCost;
                unitMaterialCost = unitProcesscostCost;
            }
            if (writeOffEntrys.size() == 1) {
                diffAmt = entryApAmt.subtract(materialCost);
            } else if (i != writeOffEntrys.size() - 1) {
                BigDecimal assitWfBaseQty = writeOffEntry.getBigDecimal("e_verifybaseqty");
                diffAmt = entryApAmt.subtract(assitWfBaseQty.multiply(unitMaterialCost).setScale(amtPrecision, 4));
                preToTalDiffAmt = preToTalDiffAmt.add(diffAmt);
                preToTalAssitWfQty = preToTalAssitWfQty.add(assitWfBaseQty);
            } else {
                BigDecimal apTotalAmount = this.getApAmount(costRecordInfo, writeOffInfo);
                diffAmt = qtyEqualWfAll ? apTotalAmount.subtract(materialCost).subtract(preToTalDiffAmt) : entryApAmt.subtract(mainWfBaseQty.subtract(preToTalAssitWfQty).multiply(unitMaterialCost).setScale(amtPrecision, 4));
            }
            diffAmt = diffAmt.setScale(amtPrecision, 4);
            StringBuilder logInfo = new StringBuilder();
            logInfo.append("materialCost=").append(materialCost.toPlainString()).append(",");
            logInfo.append("apAmt=").append(entryApAmt.toPlainString()).append(",");
            logInfo.append("diffAmt=").append(diffAmt.toPlainString());
            WriteLogHelper.writeInfoLog((Log)logger, (String)logInfo.toString(), (Object[])new Object[0]);
            if (diffAmt.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject newAdjBillEntryDyc = this.addCostAdjustBillEntry(costRecordInfo, costRecordEntry, costAdjustBill, writeOffEntry, groupMap);
                if (newAdjBillEntryDyc == null) continue;
                newAdjBillEntryDyc.set("adjustamt", (Object)diffAmt);
            }
            if (costAdjustBill.getDynamicObjectCollection("entryentity").size() == 0) continue;
            costAdjustMap.put(key, costAdjustBill);
        }
    }

    private String buildKey(DynamicObject writeOffEntry) {
        String asstacttype = writeOffEntry.getString("e_asstacttype");
        DynamicObject asstact = writeOffEntry.getDynamicObject("e_asstact");
        return asstacttype + asstact.getLong("id");
    }

    private DynamicObject createCostAdjustHead(DynamicObject costRecordInfo, DynamicObject writeOffInfo, DynamicObject writeOffEntry) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjustbill");
        costAdjustBill.set("cstype", writeOffEntry.get("e_asstacttype"));
        costAdjustBill.set("custsupplier", writeOffEntry.get("e_asstact"));
        costAdjustBill.set("currency", costRecordInfo.get("localcurrency"));
        costAdjustBill.set("bizdate", (Object)costRecordInfo.getDate("writeoffdate"));
        costAdjustBill.set("bookdate", (Object)costRecordInfo.getDate("writeoffdate"));
        costAdjustBill.set("biztype", (Object)"A");
        costAdjustBill.set("billstatus", (Object)"B");
        if (this.isOutSource) {
            costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.OM_WRITEOFF.getValue());
        } else {
            costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.PUR_WIRTEOFF.getValue());
        }
        costAdjustBill.set("costaccount", (Object)costRecordInfo.getDynamicObject("costaccount"));
        Object accountID = costRecordInfo.getDynamicObject("costaccount").get("masterid");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingle((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        costAdjustBill.set("calorg", costAccont.get("calorg"));
        costAdjustBill.set("billtype", costRecordInfo.get("billtype"));
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("createtime", (Object)date);
        DynamicObjectCollection entrys = writeOffInfo.getDynamicObjectCollection("entry");
        Long apBillId = ((DynamicObject)entrys.get(0)).getLong("e_billid");
        DynamicObject apBillInfo = this.apBillMap.get(apBillId);
        Long userId = (Long)apBillInfo.getDynamicObject("creator").getPkValue();
        costAdjustBill.set("creator_id", (Object)userId);
        Long auditorId = (Long)apBillInfo.getDynamicObject("auditor").getPkValue();
        costAdjustBill.set("auditor_id", (Object)auditorId);
        costAdjustBill.set("adminorg", (Object)costRecordInfo.getDynamicObject("adminorg"));
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjustBill, (String)costAccont.getString("calorg_id"));
        costAdjustBill.set("billno", (Object)number);
        return costAdjustBill;
    }

    private DynamicObject addCostAdjustBillEntry(DynamicObject costRecordInfo, DynamicObject costRecordEntry, DynamicObject costAdjustBillHead, DynamicObject writeOffEntry, Map<Long, DynamicObject> groupMap) {
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        Long purEntryID = costRecordEntry.getLong("bizbillentryid");
        DynamicObject writeOffInfo = groupMap.get(purEntryID);
        if (writeOffInfo == null) {
            return null;
        }
        String lot = costRecordEntry.getString("lot");
        long warehsBillID = costRecordEntry.getLong("warehouse_id");
        long locationID = costRecordEntry.getLong("location_id");
        long ownerID = costRecordEntry.getLong("owner_id");
        long assistId = costRecordEntry.getLong("assist_id");
        long srcBillType = 0L;
        int srcEntitySeq = 0;
        long srcBillId = 0L;
        long srcEntryId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".createCostAdjustBill1"), (String)"ap_finapbill", (String)"id,billtypeid,detailentry.id,detailentry.seq", (QFilter[])new QFilter[]{new QFilter("detailentry.id", "=", (Object)writeOffEntry.getLong("e_billentryid"))}, null);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                srcBillType = row.getLong("billtypeid");
                srcEntitySeq = row.getInteger("detailentry.seq");
                srcBillId = row.getLong("id");
                srcEntryId = row.getLong("detailentry.id");
            }
        }
        DynamicObject entry = costAdjustBillHead.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costRecordInfo.get("storageorgunit"));
        entry.set("material", costRecordEntry.get("material"));
        entry.set("lot", (Object)lot);
        costAdjustBillHead.set("biztype", (Object)"A");
        entry.set("warehouse", (Object)warehsBillID);
        entry.set("location", (Object)locationID);
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", (Object)ownerID);
        entry.set("ecostcenter", (Object)costRecordEntry.getLong("ecostcenter_id"));
        entry.set("assist", (Object)assistId);
        entry.set("invbilltype", costRecordInfo.get("billtype"));
        entry.set("invbillnum", (Object)costRecordInfo.getString("billno"));
        entry.set("inventryseq", costRecordEntry.get("seq"));
        entry.set("invbillid", costRecordInfo.get("id"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("invbillentryid", costRecordEntry.get("id"));
        entry.set("srcbilltype", (Object)srcBillType);
        entry.set("srcbillnum", (Object)writeOffEntry.getString("e_billno"));
        entry.set("srcentryseq", (Object)srcEntitySeq);
        entry.set("srcbillid", (Object)srcBillId);
        entry.set("srcbillentryid", (Object)srcEntryId);
        entry.set("srcbizentityobject", (Object)"ap_finapbill");
        entry.set("baseunit", costRecordEntry.get("baseunit"));
        entry.set("project", costRecordEntry.get("project"));
        entry.set("invtype", costRecordEntry.get("invtype"));
        entry.set("invstatus", costRecordEntry.get("invstatus"));
        entry.set("mversion", costRecordEntry.get("mversion"));
        entry.set("tracknumber", costRecordEntry.get("tracknumber"));
        entry.set("configuredcode", costRecordEntry.get("configuredcode"));
        entry.set("noupdatecalfields", costRecordEntry.get("noupdatecalfields"));
        entry.set("stocktype", costRecordEntry.get("stocktype"));
        Set exFieldSet = CommonSettingHelper.getExFieldSet();
        CommonSettingHelper.setExFieldValue((Set)exFieldSet, (MainEntityType)costAdjustEntityType, (MainEntityType)costRecordEntityType, (DynamicObject)entry, (DynamicObject)costRecordEntry);
        return entry;
    }

    @Override
    protected void setABillVoucherFlag(DynamicObject newCostRecordA) {
        if (newCostRecordA == null) {
            return;
        }
        String dischargeType = newCostRecordA.getString("dischargetype");
        Long bizBillId = newCostRecordA.getLong("bizbillid");
        long costAccountId = newCostRecordA.getDynamicObject("costaccount").getLong("id");
        Long writeOffPeriodId = (Long)newCostRecordA.get("writeoffperiod_id");
        Boolean isTempVoucher = false;
        if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType)) {
            QFilter q = new QFilter("bizbillid", "=", (Object)bizBillId);
            q.and("issplitcreate", "=", (Object)Boolean.FALSE);
            q.and("costaccount", "=", (Object)costAccountId);
            DynamicObject srcInfo = QueryServiceHelper.queryOne((String)"cal_costrecord", (String)"id,istempvoucher", (QFilter[])q.toArray());
            if (srcInfo != null && srcInfo.getBoolean("istempvoucher")) {
                isTempVoucher = true;
            } else {
                q = new QFilter("bizbillid", "=", (Object)bizBillId);
                q.and("issplitcreate", "=", (Object)Boolean.TRUE);
                q.and("costaccount", "=", (Object)costAccountId);
                q.and("writeoffstatus", "=", (Object)"B");
                q.and("writeoffperiod", "<", (Object)writeOffPeriodId);
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,istempvoucher", (QFilter[])q.toArray(), (String)"writeoffperiod desc", (int)1);
                if (!coll.isEmpty() && ((DynamicObject)coll.get(0)).getBoolean("istempvoucher")) {
                    isTempVoucher = true;
                }
            }
        }
        newCostRecordA.set("istempvoucher", (Object)isTempVoucher);
        newCostRecordA.set("isfivoucher", (Object)false);
        newCostRecordA.set("isdischargevoucher", (Object)false);
        newCostRecordA.set("iscostcarryover", (Object)false);
        newCostRecordA.set("isfeevoucher", (Object)false);
        newCostRecordA.set("fivouchernum", null);
        newCostRecordA.set("tempvouchernum", null);
        newCostRecordA.set("dischargevouchernum", null);
        newCostRecordA.set("carryovervouchernum", null);
        newCostRecordA.set("feevouchernum", null);
        newCostRecordA.set("fivoucherid", null);
        newCostRecordA.set("tempvoucherid", null);
        newCostRecordA.set("dischargevoucherid", null);
        newCostRecordA.set("carryovervoucherid", null);
        newCostRecordA.set("feevoucherid", null);
    }

    @Override
    protected void setBBillVoucherFlag(DynamicObject newCostRecordB, boolean istempVoucher) {
        if (newCostRecordB == null) {
            return;
        }
        newCostRecordB.set("isfivoucher", (Object)false);
        newCostRecordB.set("istempvoucher", (Object)istempVoucher);
        newCostRecordB.set("isdischargevoucher", (Object)false);
        newCostRecordB.set("iscostcarryover", (Object)false);
        newCostRecordB.set("isfeevoucher", (Object)false);
        newCostRecordB.set("fivouchernum", null);
        newCostRecordB.set("tempvouchernum", null);
        newCostRecordB.set("dischargevouchernum", null);
        newCostRecordB.set("carryovervouchernum", null);
        newCostRecordB.set("feevouchernum", null);
        newCostRecordB.set("fivoucherid", null);
        newCostRecordB.set("tempvoucherid", null);
        newCostRecordB.set("dischargevoucherid", null);
        newCostRecordB.set("carryovervoucherid", null);
        newCostRecordB.set("feevoucherid", null);
    }

    private BigDecimal getApAmount(DynamicObject costRecordInfo, DynamicObject writeOffInfo) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        DynamicObjectCollection entrys = writeOffInfo.getDynamicObjectCollection("entry");
        DynamicObject localcurrency = costRecordInfo.getDynamicObject("localcurrency");
        int amtPrecision = localcurrency.getInt("amtprecision");
        for (DynamicObject entry : entrys) {
            BigDecimal amount = this.getApAmountByWfEntryDyc(costRecordInfo, entry);
            totalAmt = totalAmt.add(amount);
        }
        totalAmt = totalAmt.setScale(amtPrecision, 4);
        return totalAmt;
    }

    private BigDecimal getInvAmount(DynamicObject costRecordInfo, DynamicObject entry, DynamicObject writeOffInfo, boolean purInRelation) {
        boolean isSameCurrency;
        BigDecimal invAmout = BigDecimal.ZERO;
        DynamicObject localcurrency = costRecordInfo.getDynamicObject("localcurrency");
        boolean supportTaxAmt = this.costAccountSupportTaxAmtMap.get(costRecordInfo.getDynamicObject("costaccount").getLong("id"));
        Long invBillCurrencyId = writeOffInfo.getLong("basecurrency_id");
        boolean bl = isSameCurrency = Long.compare(invBillCurrencyId, localcurrency.getLong("id")) == 0;
        if (isSameCurrency) {
            DynamicObject invBillEntry = this.invBillEntryMap.get(entry.getLong("bizbillentryid"));
            DynamicObject ancestorBillEntry = this.ancestorBillEntryMap.get(entry.getLong("ancestorentryid"));
            if (invBillEntry == null || ancestorBillEntry == null) {
                WriteLogHelper.writeInfoLog((Log)logger, (String)"PurWriteOffServiceProcess-getInvAmount-invBillEntry-empty", (Object[])new Object[0]);
                logger.info("\u4e3b\u8f85\u65b9\u5355\u636e\u83b7\u53d6\u4e3a\u7a7a");
                this.isCalByUnitPrice = true;
                return BigDecimal.ZERO;
            }
            BigDecimal invBillSrcIntercost = invBillEntry.getBigDecimal("intercostamt");
            boolean isZeroInterCost = invBillSrcIntercost.compareTo(BigDecimal.ZERO) == 0;
            BigDecimal ancestorBillAmt = BigDecimal.ZERO;
            ancestorBillAmt = purInRelation ? ancestorBillEntry.getBigDecimal("materialcost") : ancestorBillEntry.getBigDecimal("processcost");
            if (isZeroInterCost) {
                boolean isSameCost;
                BigDecimal invBillAmt = BigDecimal.ZERO;
                invBillAmt = supportTaxAmt ? invBillEntry.getBigDecimal("curamountandtax") : invBillEntry.getBigDecimal("curamount");
                boolean bl2 = isSameCost = invBillAmt.compareTo(ancestorBillAmt) == 0;
                if (isSameCost) {
                    if (invBillEntry != null) {
                        Map<String, Object> resultMap;
                        DynamicObject wfRecHeadDyc = writeOffInfo;
                        if (writeOffInfo.getParent() != null) {
                            wfRecHeadDyc = (DynamicObject)wfRecHeadDyc.getParent();
                        }
                        if ((resultMap = this.getInvCalServiceResult(wfRecHeadDyc.getString("billtype"), invBillEntry, "qty", wfRecHeadDyc.getBigDecimal("verifyqty"))) != null) {
                            invAmout = supportTaxAmt ? (BigDecimal)resultMap.get("curamountandtax") : (BigDecimal)resultMap.get("curamount");
                        }
                    }
                } else {
                    this.isCalByUnitPrice = true;
                }
            } else {
                boolean isSameCost;
                boolean bl3 = isSameCost = invBillSrcIntercost.compareTo(ancestorBillAmt) == 0;
                if (isSameCost) {
                    Map<String, Object> resultMap;
                    DynamicObject wfRecHeadDyc = writeOffInfo;
                    if (writeOffInfo.getParent() != null) {
                        wfRecHeadDyc = (DynamicObject)wfRecHeadDyc.getParent();
                    }
                    if ((resultMap = this.getInvCalServiceResult(wfRecHeadDyc.getString("billtype"), invBillEntry, "qty", wfRecHeadDyc.getBigDecimal("verifyqty"))) != null) {
                        invAmout = (BigDecimal)resultMap.get("intercostamt");
                    }
                } else {
                    this.isCalByUnitPrice = true;
                }
            }
        } else {
            this.isCalByUnitPrice = true;
        }
        return invAmout;
    }

    private BigDecimal getRedBlueAmount(DynamicObject costRecordInfo, DynamicObject entry, DynamicObject writeOffInfo, boolean purRedRelation) {
        this.isCalByUnitPrice = false;
        BigDecimal invAmout = BigDecimal.ZERO;
        DynamicObject invBillEntry = this.invBillEntryMap.get(entry.getLong("bizbillentryid"));
        DynamicObject ancestorBillEntry = this.ancestorBillEntryMap.get(entry.getLong("ancestorentryid"));
        if (invBillEntry == null || ancestorBillEntry == null) {
            WriteLogHelper.writeInfoLog((Log)logger, (String)"PurWriteOffServiceProcess-getRedBlueAmount-invBillEntry-empty", (Object[])new Object[0]);
            this.isCalByUnitPrice = true;
            return invAmout;
        }
        BigDecimal invBillSrcIntercost = invBillEntry.getBigDecimal("intercostamt");
        if (invBillSrcIntercost.compareTo(BigDecimal.ZERO) == 0) {
            WriteLogHelper.writeInfoLog((Log)logger, (String)"PurWriteOffServiceProcess-getRedBlueAmount-invBillSrcIntercost-empty", (Object[])new Object[0]);
            this.isCalByUnitPrice = true;
            return invAmout;
        }
        BigDecimal ancestorBillAmt = BigDecimal.ZERO;
        ancestorBillAmt = purRedRelation ? ancestorBillEntry.getBigDecimal("materialcost") : ancestorBillEntry.getBigDecimal("processcost");
        if (invBillSrcIntercost.compareTo(ancestorBillAmt) == 0) {
            String billType;
            Map<String, Object> resultMap;
            DynamicObject wfRecHeadDyc = writeOffInfo;
            BigDecimal sign = BigDecimal.ONE;
            if (writeOffInfo.getParent() != null) {
                wfRecHeadDyc = (DynamicObject)wfRecHeadDyc.getParent();
                sign = sign.negate();
            }
            if ((resultMap = this.getInvCalServiceResult(billType = wfRecHeadDyc.getString("billtype"), invBillEntry, "qty", wfRecHeadDyc.getBigDecimal("verifyqty").multiply(sign))) != null) {
                invAmout = (BigDecimal)resultMap.get("intercostamt");
            }
        } else {
            this.isCalByUnitPrice = true;
        }
        return invAmout;
    }

    private String getDischargetype(DynamicObject calCostRecord) {
        return calCostRecord.getString("dischargetype");
    }

    @Override
    protected void dealRecordA(DynamicObject newRecordA, Map<Long, DynamicObject> groupMap, boolean writeBack, boolean isRedBill) {
        String writeofftype = "B";
        boolean purInRelation = false;
        boolean purRedRelation = false;
        if (isRedBill) {
            writeofftype = "A";
            purRedRelation = "purself".equals(this.redVerifyRelation) || "apfinself".equals(this.redVerifyRelation) || "purwrittenoff".equals(this.redVerifyRelation) || "purreturnwrittenoff".equals(this.redVerifyRelation) || "1363768884041091072".equals(this.redVerifyRelation);
        } else {
            boolean omInRedRelation;
            Map.Entry<Long, DynamicObject> mapEntry = groupMap.entrySet().iterator().next();
            DynamicObject wrireOff = mapEntry.getValue();
            String verifyrelation = wrireOff.getString("verifyrelation");
            purInRelation = "appurin".equals(verifyrelation) || "appurreturn".equals(verifyrelation) || "1363765058710014976".equals(verifyrelation);
            purRedRelation = "purself".equals(verifyrelation) || "apfinself".equals(verifyrelation) || "purwrittenoff".equals(verifyrelation) || "purreturnwrittenoff".equals(verifyrelation) || "1363768884041091072".equals(verifyrelation);
            boolean omInRelation = "apomin".equals(verifyrelation) || "apominreturn".equals(verifyrelation);
            boolean bl = omInRedRelation = "ominself".equals(verifyrelation) || "apfinself".equals(verifyrelation);
            if (purInRelation || omInRelation) {
                writeofftype = "B";
            } else if (purRedRelation || omInRedRelation) {
                writeofftype = "A";
            }
        }
        newRecordA.set("writeofftype", (Object)writeofftype);
        DynamicObjectCollection entrys = newRecordA.getDynamicObjectCollection("entry");
        DynamicObject localcurrency = newRecordA.getDynamicObject("localcurrency");
        int amtPrecision = localcurrency.getInt("amtprecision");
        boolean isUseActualCost = this.isUseActualCost(newRecordA);
        for (int i = entrys.size() - 1; i >= 0; --i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long purEntryID = entry.getLong("bizbillentryid");
            DynamicObject writeOffInfo = groupMap.get(purEntryID);
            String baseQtyField = "verifybaseqty";
            if (isRedBill) {
                baseQtyField = "e_verifybaseqty";
            }
            if (writeOffInfo == null) {
                entrys.remove(i);
                continue;
            }
            BigDecimal writeOffqty = writeOffInfo.getBigDecimal(baseQtyField);
            BigDecimal baseqty = entry.getBigDecimal("baseqty");
            entry.set("baseqty", (Object)writeOffqty);
            if (writeOffqty.compareTo(baseqty) != 0) {
                BigDecimal invAmt;
                BigDecimal unitMaterialcost = entry.getBigDecimal("unitmaterialcost");
                if (isUseActualCost) {
                    unitMaterialcost = entry.getBigDecimal("unitactualcost");
                }
                BigDecimal materialCost = BigDecimal.ZERO;
                BigDecimal processCost = BigDecimal.ZERO;
                BigDecimal unitProcessCost = entry.getBigDecimal("unitprocesscost");
                BigDecimal unitStandardcost = entry.getBigDecimal("unitstandardcost");
                BigDecimal standarcCost = writeOffqty.multiply(unitStandardcost);
                entry.set("standardcost", (Object)standarcCost);
                if ("B".equals(writeofftype)) {
                    if (writeBack && !Boolean.FALSE.equals(this.entryWriteBackMap.get(entry.getLong("bizbillentryid")))) {
                        BigDecimal apAmount;
                        materialCost = apAmount = this.getApAmount(newRecordA, writeOffInfo);
                        processCost = apAmount;
                    } else {
                        invAmt = this.getInvAmount(newRecordA, entry, writeOffInfo, purInRelation);
                        if (this.isCalByUnitPrice) {
                            materialCost = unitMaterialcost.multiply(writeOffqty).setScale(amtPrecision, 4);
                            processCost = unitProcessCost.multiply(writeOffqty).setScale(amtPrecision, 4);
                        } else {
                            materialCost = processCost = invAmt;
                        }
                    }
                } else if ("A".equals(writeofftype)) {
                    invAmt = this.getRedBlueAmount(newRecordA, entry, writeOffInfo, purRedRelation);
                    if (this.isCalByUnitPrice) {
                        materialCost = unitMaterialcost.multiply(writeOffqty).setScale(amtPrecision, 4);
                        processCost = unitProcessCost.multiply(writeOffqty).setScale(amtPrecision, 4);
                    } else {
                        materialCost = processCost = invAmt;
                    }
                }
                entry.set("materialcost", (Object)materialCost);
                entry.set("processcost", (Object)processCost);
                WriteLogHelper.writeInfoLog((Log)logger, (String)(purEntryID + ",writeoffqty = " + writeOffqty + ",baseqty = " + baseqty + ",unitmaterialcost = " + unitMaterialcost + ",materialCost = " + materialCost + ",unitprocesscost = " + unitProcessCost + ",processCost = " + processCost), (Object[])new Object[0]);
                BigDecimal localTax = entry.getBigDecimal("localtax");
                localTax = writeOffqty.divide(baseqty, 8, 4).multiply(localTax).setScale(amtPrecision, 4);
                entry.set("localtax", (Object)localTax);
                entry.set("actualcost", (Object)materialCost);
                entry.set("unitactualcost", (Object)unitMaterialcost);
                entry.set("unitmaterialcost", (Object)unitMaterialcost);
                if (this.isOutSource) {
                    entry.set("actualcost", (Object)processCost);
                    entry.set("unitactualcost", (Object)unitProcessCost);
                }
            } else if (this.isOutSource) {
                entry.set("actualcost", (Object)entry.getBigDecimal("processcost"));
                entry.set("unitactualcost", (Object)entry.getBigDecimal("unitprocesscost"));
            } else if (isUseActualCost) {
                entry.set("actualcost", (Object)entry.getBigDecimal("actualcost"));
                entry.set("unitactualcost", (Object)entry.getBigDecimal("unitactualcost"));
                entry.set("materialcost", (Object)entry.getBigDecimal("actualcost"));
                entry.set("unitmaterialcost", (Object)entry.getBigDecimal("unitactualcost"));
            } else {
                entry.set("actualcost", (Object)entry.getBigDecimal("materialcost"));
                entry.set("unitactualcost", (Object)entry.getBigDecimal("unitmaterialcost"));
            }
            this.setOtherCostZero(entry);
            entry.set("costpricesource", (Object)" ");
            entry.set("designatedcost", (Object)"0");
            if (isRedBill) {
                entry.set("writeoffid", (Object)((DynamicObject)writeOffInfo.getParent()).getLong("id"));
                continue;
            }
            entry.set("writeoffid", (Object)writeOffInfo.getLong("id"));
        }
    }

    private void setOtherCostZero(DynamicObject entry) {
        entry.set("fee", (Object)BigDecimal.ZERO);
        entry.set("unitfee", (Object)BigDecimal.ZERO);
        entry.set("unitmanufacturecost", (Object)BigDecimal.ZERO);
        entry.set("manufacturecost", (Object)BigDecimal.ZERO);
        entry.set("unitresource", (Object)BigDecimal.ZERO);
        entry.set("resource", (Object)BigDecimal.ZERO);
        if (this.isOutSource) {
            entry.set("unitmaterialcost", (Object)BigDecimal.ZERO);
            entry.set("materialcost", (Object)BigDecimal.ZERO);
        } else {
            entry.set("unitprocesscost", (Object)BigDecimal.ZERO);
            entry.set("processcost", (Object)BigDecimal.ZERO);
        }
    }

    @Override
    protected void dealRecordB(DynamicObject newRecordA, DynamicObject newRecordB, Map<Long, DynamicObject> groupMap, boolean isRedBill) {
        DynamicObjectCollection entrys = newRecordB.getDynamicObjectCollection("entry");
        DynamicObjectCollection entryAs = newRecordA.getDynamicObjectCollection("entry");
        boolean isUseActualCost = this.isUseActualCost(newRecordA);
        for (int i = entrys.size() - 1; i >= 0; --i) {
            BigDecimal writeOqty;
            BigDecimal oldBaseQty;
            BigDecimal newQty;
            DynamicObject writeOffInfo;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            long purEntryID = entry.getLong("bizbillentryid");
            DynamicObject entryA = null;
            for (DynamicObject entryInfo : entryAs) {
                long purEntryIDA = entryInfo.getLong("bizbillentryid");
                if (purEntryID != purEntryIDA) continue;
                entryA = entryInfo;
                break;
            }
            if ((writeOffInfo = groupMap.get(purEntryID)) == null) continue;
            String baseQtyField = "verifybaseqty";
            if (isRedBill) {
                baseQtyField = "e_verifybaseqty";
            }
            if (BigDecimal.ZERO.compareTo(newQty = (oldBaseQty = entry.getBigDecimal("baseqty")).subtract(writeOqty = writeOffInfo.getBigDecimal(baseQtyField))) == 0) {
                entrys.remove(i);
                continue;
            }
            if (oldBaseQty.abs().compareTo(writeOqty.abs()) < 0) {
                new OverWfAutoUnWfHelper().autoUnWf(this.writeOffInfos);
                throw new KDBizException(new ErrorCode("5", ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u591a\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u6838\u9500\u8bb0\u5f55\u3002", (String)"AbstractWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0])), new Object[0]);
            }
            entry.set("baseqty", (Object)newQty);
            BigDecimal materialCostB = entry.getBigDecimal("materialcost").subtract(entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("materialcost"));
            if (isUseActualCost) {
                materialCostB = entry.getBigDecimal("actualcost").subtract(entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("materialcost"));
            }
            BigDecimal processCostB = entry.getBigDecimal("processcost").subtract(entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("processcost"));
            BigDecimal standardCostB = entry.getBigDecimal("standardcost").subtract(entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("standardcost"));
            entry.set("materialcost", (Object)materialCostB);
            entry.set("processcost", (Object)processCostB);
            entry.set("standardcost", (Object)standardCostB);
            entry.set("actualcost", (Object)materialCostB);
            if (isUseActualCost) {
                entry.set("unitactualcost", (Object)entry.getBigDecimal("unitactualcost"));
                entry.set("unitmaterialcost", (Object)entry.getBigDecimal("unitactualcost"));
            } else {
                entry.set("unitactualcost", (Object)entry.getBigDecimal("unitmaterialcost"));
            }
            if (this.isOutSource) {
                entry.set("actualcost", (Object)processCostB);
                entry.set("unitactualcost", (Object)entry.getBigDecimal("unitprocesscost"));
            }
            this.setOtherCostZero(entry);
            entry.set("costpricesource", (Object)" ");
            entry.set("designatedcost", (Object)"0");
            BigDecimal localTaxB = entry.getBigDecimal("localtax").subtract(entryA == null ? BigDecimal.ZERO : entryA.getBigDecimal("localtax"));
            entry.set("localtax", (Object)localTaxB);
        }
    }

    private BigDecimal getApAmountByWfEntryDyc(DynamicObject costRecordDyc, DynamicObject wfRecordEntryDyc) {
        DynamicObject calOrg = costRecordDyc.getDynamicObject("calorg");
        DynamicObject localcurrency = costRecordDyc.getDynamicObject("localcurrency");
        int amtPrecision = localcurrency.getInt("amtprecision");
        boolean supportTaxAmt = this.costAccountSupportTaxAmtMap.get(costRecordDyc.getDynamicObject("costaccount").getLong("id"));
        boolean pur_have_swappl = false;
        if (this.pur_have_swapplParamMap.containsKey(calOrg.getLong("id"))) {
            pur_have_swappl = this.pur_have_swapplParamMap.get(calOrg.getLong("id"));
        } else {
            pur_have_swappl = (Boolean)ParamsHelper.getAppParam((long)calOrg.getLong("id"), (String)"pur_have_swappl");
            this.pur_have_swapplParamMap.put(calOrg.getLong("id"), pur_have_swappl);
        }
        DynamicObject apLocalCurrency = wfRecordEntryDyc.getDynamicObject("e_basecurrency");
        if (apLocalCurrency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u5bf9\u5e94\u7684\u5e94\u4ed8\u5355\u672c\u4f4d\u5e01\u4e3a\u7a7a\u3002", (String)"PurWriteOffServiceProcess_2", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        DynamicObject apCurrency = wfRecordEntryDyc.getDynamicObject("e_currency");
        if (apCurrency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u5bf9\u5e94\u7684\u5e94\u4ed8\u5355\u5e01\u79cd\u4e3a\u7a7a\u3002", (String)"PurWriteOffServiceProcess_3", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        Long apBillId = wfRecordEntryDyc.getLong("e_billid");
        DynamicObject apBillInfo = this.apBillMap.get(apBillId);
        boolean isTaxDeduction = apBillInfo.getBoolean("istaxdeduction");
        DynamicObject exrateTable = apBillInfo.getDynamicObject("exratetable");
        Date exrateDate = apBillInfo.getDate("exratedate");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal apLocalAmount = null;
        BigDecimal apAmount = null;
        BigDecimal interCostAmt = wfRecordEntryDyc.getBigDecimal("e_verifyintercostamt");
        if (interCostAmt != null && interCostAmt.compareTo(BigDecimal.ZERO) != 0) {
            apLocalAmount = apAmount = interCostAmt;
        } else if (supportTaxAmt) {
            apLocalAmount = wfRecordEntryDyc.getBigDecimal("e_localverifytaxamt");
            apAmount = wfRecordEntryDyc.getBigDecimal("e_verifytaxamount");
        } else if (isTaxDeduction) {
            apLocalAmount = wfRecordEntryDyc.getBigDecimal("e_localverifyamt");
            apAmount = wfRecordEntryDyc.getBigDecimal("e_verifyamount");
        } else {
            apLocalAmount = wfRecordEntryDyc.getBigDecimal("e_localverifytaxamt");
            apAmount = wfRecordEntryDyc.getBigDecimal("e_verifytaxamount");
        }
        BigDecimal swappl = wfRecordEntryDyc.getBigDecimal("e_swappl");
        if (!pur_have_swappl) {
            apLocalAmount = apLocalAmount.subtract(swappl);
        }
        Date apBizDate = wfRecordEntryDyc.getDate("e_billdate");
        DynamicObject costAccount = costRecordDyc.getDynamicObject("costaccount");
        if (apLocalCurrency.getLong("id") == localcurrency.getLong("id")) {
            amount = apLocalAmount;
        } else {
            BigDecimal exchangeRate;
            ExchangeRateHelper exchangeRateHelper = new ExchangeRateHelper(apCurrency, localcurrency, costAccount, exrateDate == null ? apBizDate : exrateDate, exrateTable.getLong("id"));
            if (!pur_have_swappl) {
                exchangeRateHelper = new ExchangeRateHelper(apLocalCurrency, localcurrency, costAccount, exrateDate == null ? apBizDate : exrateDate, exrateTable.getLong("id"));
                apAmount = apLocalAmount;
            }
            if ((exchangeRate = exchangeRateHelper.getExchangeRate()) != null) {
                amount = exchangeRateHelper.getTargetAmount(exchangeRate, apAmount, amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate"));
            } else {
                Map rateMap = exchangeRateHelper.getExchangeRate4TargetUSD();
                BigDecimal exchangeRate4TargetUSD = (BigDecimal)rateMap.get("exchangeRate4TargetUSD");
                BigDecimal exchangeRate4sourceUSD = (BigDecimal)rateMap.get("exchangeRate4sourceUSD");
                amount = exchangeRateHelper.getTargetAmount(exchangeRate4sourceUSD, exchangeRateHelper.getTargetAmount(exchangeRate4TargetUSD, apAmount, amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate4TargetUSD")), amtPrecision, (String)exchangeRateHelper.getConvertModeMap().get("exchangeRate4sourceUSD"));
            }
        }
        return amount;
    }

    private void purWriteOffVendor(DynamicObject[] writeOffInfos, Set<Long> vendorPurIdSet) {
        HashSet<Long> sourcebillIdSet = new HashSet<Long>(16);
        for (DynamicObject writeOffInfo : writeOffInfos) {
            Long l = writeOffInfo.getLong("billid");
            if (!vendorPurIdSet.contains(l)) continue;
            for (DynamicObject writeOffEntry : writeOffInfo.getDynamicObjectCollection("entry")) {
                sourcebillIdSet.add(writeOffEntry.getLong("e_billid"));
            }
        }
        if (sourcebillIdSet.size() > 0) {
            QFilter filter = new QFilter("sourcebillid", "in", sourcebillIdSet);
            DynamicObject[] daptrackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{filter});
            HashMap<Long, HashSet<Long>> voucherSourcebillIdMap = new HashMap<Long, HashSet<Long>>(16);
            for (DynamicObject daptracker : daptrackers) {
                Long voucherid = daptracker.getLong("voucherid");
                Long sourcebillid = daptracker.getLong("sourcebillid");
                HashSet<Long> sourcebillIds = (HashSet<Long>)voucherSourcebillIdMap.get(voucherid);
                if (null == sourcebillIds) {
                    sourcebillIds = new HashSet<Long>(16);
                    sourcebillIds.add(sourcebillid);
                    voucherSourcebillIdMap.put(voucherid, sourcebillIds);
                    continue;
                }
                sourcebillIds.add(sourcebillid);
            }
            if (voucherSourcebillIdMap.size() > 0) {
                for (Map.Entry entry : voucherSourcebillIdMap.entrySet()) {
                    logger.info("\u51ed\u8bc1id\uff1a" + entry.getKey() + "\u5f00\u59cb\u8c03\u7528\u5fae\u670d\u52a1VoucherWriteBackService.fiApWriteBack,\u64cd\u4f5c\u503c\u4e3a" + entry.getValue());
                    try {
                        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"VoucherWriteBackService", (String)"fiApWriteBack", (Object[])new Object[]{"1", entry.getValue(), entry.getKey(), null});
                    }
                    catch (Throwable ex) {
                        logger.error("\u51ed\u8bc1id\uff1a" + entry.getKey() + "\u8c03\u7528\u5fae\u670d\u52a1VoucherWriteBackService.costRecordWriteBack\u5f02\u5e38", ex);
                        throw ex;
                    }
                }
            }
        }
    }

    public boolean isUseActualCost(DynamicObject newRecordA) {
        return false;
    }

    private Map<String, Object> getInvCalServiceResult(String billEntityNum, DynamicObject entry, String changeProp, BigDecimal changeQty) {
        entry.set(changeProp, (Object)changeQty);
        return AlgorithmHelper.entryCalculate((String)billEntityNum, (DynamicObject)entry, (String)changeProp);
    }
}

