/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.service.CalProcessHandle;
import kd.fi.cal.business.service.CalProcessReExcuteHandle;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class ReSyncBillProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(ReSyncBillProcess.class);
    private final List<DynamicObject> unAuditBizBillDycs = new ArrayList<DynamicObject>(16);
    private final List<DynamicObject> auditBizBillDycs = new ArrayList<DynamicObject>(16);
    private boolean recordDetailLog = false;
    private Map<String, List<DynamicObject>> opBillDycMap = new HashMap<String, List<DynamicObject>>(16);
    private Map<Long, DynamicObject> billIdDycMap = new HashMap<Long, DynamicObject>(16);

    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) throws Exception {
        if (bizBills == null || bizBills.length < 1) {
            return;
        }
        Long currtime = System.currentTimeMillis();
        logger.info("ReSyncBillProcess-\u5f00\u59cb\u91cd\u65b0\u540c\u6b65\uff1a" + currtime);
        if (params != null && params.get("recorddetaillog") != null && params.get("recorddetaillog").equals("TRUE")) {
            this.recordDetailLog = true;
        }
        this.reSync(bizBills);
        logger.info("ReSyncBillProcess-\u7ed3\u675f\u91cd\u65b0\u540c\u6b65\uff1a" + (currtime - System.currentTimeMillis()));
    }

    public void reSync(DynamicObject[] bizBillDycs) throws Exception {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (DynamicObject item : bizBillDycs) {
            bizBillIds.add((Long)item.getPkValue());
            this.billIdDycMap.put((Long)item.getPkValue(), item);
        }
        logger.info("ReSyncBillProcess-\u91cd\u65b0\u540c\u6b65\u5355\u636eids\uff1a" + bizBillIds);
        this.beforeCheck(bizBillIds);
        if (bizBillDycs.length < 1) {
            return;
        }
        this.prepareData(bizBillIds, bizBillDycs);
        List<ErrorMsg> revErrorMsgs = this.doReverse(this.unAuditBizBillDycs.toArray(new DynamicObject[0]));
        this.removeErrorBillDycs(revErrorMsgs, this.auditBizBillDycs);
        if (AcctGroupModelHelper.isBizGroupModel()) {
            this.createBizGroupRecord(this.auditBizBillDycs);
        }
        List<ErrorMsg> reSyncErrorMsgs = this.doSync(this.auditBizBillDycs.toArray(new DynamicObject[0]));
        try {
            if (this.auditBizBillDycs != null && this.auditBizBillDycs.size() > 0) {
                HashSet<Long> billIds = new HashSet<Long>(16);
                for (DynamicObject auditBizBillDyc : this.auditBizBillDycs) {
                    long omInBillId = auditBizBillDyc.getLong("id");
                    billIds.add(omInBillId);
                }
                String entityName = this.auditBizBillDycs.get(0).getDataEntityType().getName();
                new CalProcessReExcuteHandle().autoMatWriteOff(entityName, billIds);
            }
        }
        catch (Throwable e) {
            logger.error("\u81ea\u52a8\u8865\u507f\u6750\u6599\u6838\u9500", e);
        }
    }

    private void createBizGroupRecord(List<DynamicObject> auditBizBillDycs) {
        HashMap<String, Set<Long>> formId2BizbillidMap = new HashMap<String, Set<Long>>(4);
        for (DynamicObject auditBizBillDyc : auditBizBillDycs) {
            String formid = auditBizBillDyc.getDataEntityType().getName();
            Set bizbillids = formId2BizbillidMap.computeIfAbsent(formid, k -> new HashSet(4));
            bizbillids.add(auditBizBillDyc.getLong("id"));
        }
        try {
            BizGroupRecordHelper.createBizGroupRecord(formId2BizbillidMap);
        }
        catch (Throwable e) {
            logger.error("\u81ea\u52a8\u8865\u507f\u751f\u6210\u4e1a\u52a1\u6210\u7ec4\u5173\u7cfb\u8bb0\u5f55", e);
        }
    }

    private void beforeCheck(Set<Long> bizBillIds) {
        HashMap<String, String> paras = new HashMap<String, String>(16);
        paras.put("nocheckacct", "TRUE");
        Map checkBillIdMsgMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"ReSyncService", (String)"check", (Object[])new Object[]{"", bizBillIds, paras});
        ArrayList<ErrorMsg> beforeCheckMsgs = new ArrayList<ErrorMsg>(16);
        for (Map.Entry checkBillIdMsgEntry : checkBillIdMsgMap.entrySet()) {
            Long billId = (Long)checkBillIdMsgEntry.getKey();
            ErrorMsg error = new ErrorMsg();
            error.setErrorMsg((String)checkBillIdMsgEntry.getValue());
            error.setObject(this.billIdDycMap.get(billId));
            error.setId(billId);
            error.setErrorType("3");
            beforeCheckMsgs.add(error);
        }
        this.addErrors(ActionEnum.UN_AUDIT.getValue(), beforeCheckMsgs);
    }

    private void prepareData(Collection<Long> bizBillIds, DynamicObject[] bizBillDycs) {
        QFilter bizBillIdF = new QFilter("bizbillid", "in", bizBillIds);
        QFilter isSpritCreateF = new QFilter("issplitcreate", "=", (Object)Boolean.FALSE);
        HashSet<Long> unAuditBizBillIds = new HashSet<Long>(16);
        try (DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"billstatus,bizbillid", (QFilter[])new QFilter[]{bizBillIdF, isSpritCreateF}, null);){
            for (Row row : costRecordDs) {
                String billStatus = row.getString("billstatus");
                long bizBillId = row.getLong("bizbillid");
                if ("B".equals(billStatus)) {
                    unAuditBizBillIds.add(bizBillId);
                    continue;
                }
                if (!"C".equals(billStatus)) continue;
                unAuditBizBillIds.add(bizBillId);
            }
        }
        for (DynamicObject item : bizBillDycs) {
            if (unAuditBizBillIds.contains(item.getLong("id"))) {
                this.unAuditBizBillDycs.add(item);
                List billDycs = this.opBillDycMap.computeIfAbsent(ActionEnum.UN_AUDIT.getValue(), k -> new ArrayList(16));
                billDycs.add(item);
            }
            if (!"C".equals(item.getString("billstatus"))) continue;
            this.auditBizBillDycs.add(item);
            List audiBillDycs = this.opBillDycMap.computeIfAbsent(ActionEnum.AUDIT.getValue(), k -> new ArrayList(16));
            audiBillDycs.add(item);
        }
    }

    private void removeErrorBillDycs(List<ErrorMsg> errorMsgs, List<DynamicObject> bizBillDycs) {
        HashSet<Long> errorBizBillIds = new HashSet<Long>(16);
        for (ErrorMsg item : errorMsgs) {
            errorBizBillIds.add(item.getId());
        }
        Iterator<DynamicObject> submitBizBillsItr = bizBillDycs.iterator();
        while (submitBizBillsItr.hasNext()) {
            DynamicObject bizBillDyc = submitBizBillsItr.next();
            if (!errorBizBillIds.contains(bizBillDyc.getLong("id"))) continue;
            submitBizBillsItr.remove();
        }
    }

    private List<ErrorMsg> doReverse(DynamicObject[] unAuditBizBillDycs) {
        ArrayList<ErrorMsg> errorList = new ArrayList<ErrorMsg>(16);
        try (TXHandle tx = TX.requiresNew();){
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("noretry", "TRUE");
            params.put("nolock", "TRUE");
            params.put("legalCheck", "false");
            CalProcessHandle calProcessHandle = new CalProcessHandle(ActionEnum.UN_AUDIT.getValue(), params, unAuditBizBillDycs);
            calProcessHandle.handle();
            Map<Long, ErrorMsg> errorBillIdMsgMap = calProcessHandle.getErrorBillIdMsgMap();
            errorList.addAll(errorBillIdMsgMap.values());
            this.addErrors(ActionEnum.UN_AUDIT.getValue(), errorList);
        }
        return errorList;
    }

    private List<ErrorMsg> doSync(DynamicObject[] auditBizBillDycs) throws Exception {
        ArrayList<ErrorMsg> errorList = new ArrayList<ErrorMsg>(16);
        try (TXHandle tx = TX.requiresNew();){
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("noretry", "TRUE");
            params.put("nolock", "TRUE");
            CalProcessHandle calProcessHandle = new CalProcessHandle(ActionEnum.AUDIT.getValue(), params, auditBizBillDycs);
            calProcessHandle.handle();
            Map<Long, ErrorMsg> errorBillIdMsgMap = calProcessHandle.getErrorBillIdMsgMap();
            errorList.addAll(errorBillIdMsgMap.values());
            this.addErrors(ActionEnum.AUDIT.getValue(), errorList);
        }
        return errorList;
    }

    public void addErrors(String opKey, List<ErrorMsg> msgs) {
        StringBuilder sb = new StringBuilder();
        String billNoField = null;
        boolean isAllLogWarn = true;
        boolean isSysError = false;
        for (ErrorMsg item : msgs) {
            DynamicObject billDyc;
            if (!"5".equals(item.getErrorType())) {
                isAllLogWarn = false;
            }
            if ("4".equals(item.getErrorType())) {
                isSysError = true;
            }
            if ((billDyc = this.billIdDycMap.get(item.getId())) != null) {
                if (billNoField == null && billDyc.getDataEntityType().getProperties().containsKey((Object)"billno")) {
                    billNoField = "billno";
                }
                if (billNoField != null) {
                    sb.append(billDyc.getString(billNoField));
                    sb.append("\uff1a");
                }
            }
            sb.append(item.getErrorMsg());
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue()) {
                isAllLogWarn = true;
            }
            if (isAllLogWarn) {
                throw new KDBizException(new ErrorCode("5", sb.toString()), new Object[0]);
            }
            if (isSysError) {
                throw new KDBizException(new ErrorCode("4", sb.toString()), new Object[0]);
            }
            throw new KDBizException(sb.toString());
        }
        this.addErrors(msgs);
    }

    public Map<String, List<DynamicObject>> getOpBillDycMap() {
        return this.opBillDycMap;
    }
}

