/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.business.process.impl.AbstractWriteOffServiceProcess;
import kd.fi.cal.business.service.SyncLockHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.WhiteListHelper;
import kd.fi.cal.common.util.CommonUtils;

public class SalOutUnWriteOffServiceProcess
extends AbstractWriteOffServiceProcess {
    private static final Log logger = LogFactory.getLog(SalOutUnWriteOffServiceProcess.class);

    public SalOutUnWriteOffServiceProcess() {
        this.calBillType = "OUT";
    }

    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return;
        }
        SyncLockHelper syncLockHelper = new SyncLockHelper(ActionEnum.SALE_UN_WRITEOFF.getValue(), bizBills);
        try (TraceSpan span = Tracer.create((String)"SalOutUnWriteOffServiceProcess-doProcessor", (String)"SalOutUnWriteOffServiceProcess-doProcessor");){
            this.txCommitReleaseLock(syncLockHelper);
            syncLockHelper.setSyncParams(params);
            syncLockHelper.setNoRetry(true);
            List<ErrorMsg> mutErrors = syncLockHelper.lock();
            StringBuilder sb = new StringBuilder();
            HashSet<String> errMsgs = new HashSet<String>(16);
            for (ErrorMsg err : mutErrors) {
                errMsgs.add(err.getErrorMsg());
            }
            for (String errMsg : errMsgs) {
                sb.append(errMsg);
            }
            if (sb.length() > 0) {
                throw new KDBizException(sb.toString());
            }
            logger.info("\u9500\u552e\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\u5f00\u59cb\u3002\u3002\u3002" + System.currentTimeMillis());
            if (bizBills[0].getString("billno").startsWith("test_delay")) {
                logger.info("\u53cd\u6838\u9500\u6d4b\u8bd5,\u4e09\u5206\u949f\u5ef6\u65f6\u4e2d");
                try {
                    Thread.sleep(180000L);
                }
                catch (InterruptedException e) {
                    logger.info("SalOutUnWriteOffServiceProcess doProcessor", (Object)e);
                }
            }
            int cSize = bizBills.length;
            HashSet<Long> writeOffIDSet = new HashSet<Long>(cSize);
            HashSet<Long> bizbillIds = new HashSet<Long>(16);
            for (DynamicObject info : bizBills) {
                writeOffIDSet.add(info.getLong("id"));
                bizbillIds.add(info.getLong("billid"));
                DynamicObjectCollection writeEntryColl = info.getDynamicObjectCollection("entry");
                for (DynamicObject writeOffEntry : writeEntryColl) {
                    bizbillIds.add(writeOffEntry.getLong("e_billid"));
                }
            }
            DynamicObject[] costRecords = this.checkMoreReocrd(writeOffIDSet, bizbillIds);
            if (costRecords.length == 0) {
                return;
            }
            ArrayList<Long> childIds = new ArrayList<Long>(16);
            ArrayList<Long> childEntryIds = new ArrayList<Long>(1024);
            this.checkUnWriteOff(costRecords, childIds, childEntryIds, bizbillIds);
            try {
                HashSet<Long> noWriteChildEntryIds = new HashSet<Long>(childEntryIds);
                Set<Long> ancestorIds = this.getAllAncestorBillId(childIds);
                logger.info("\u9500\u552e\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\uff1a\u6210\u672c\u8bb0\u5f55\u5b50\u5355id:" + childIds.get(0));
                this.writeBackRecordB(childIds, noWriteChildEntryIds, bizbillIds);
                this.addNewRecordB(costRecords, noWriteChildEntryIds);
                if (!noWriteChildEntryIds.isEmpty()) {
                    this.writeBackRecordB(childIds, noWriteChildEntryIds, bizbillIds);
                }
                this.deletChildBills(childIds, childEntryIds);
                this.deleteRecordB(ancestorIds, bizbillIds);
                this.setFatherRecordUnWriteoff(ancestorIds, bizbillIds);
                this.clearWriteOffEndPeriod(ancestorIds, bizbillIds);
                this.writeBackAncestorBillVerifyField(ancestorIds, bizbillIds);
                this.writeBackIsVoucherUncheck(ancestorIds, bizbillIds);
                this.deleteIepBusinesstask(childIds);
            }
            catch (Exception e) {
                logger.info("\u9500\u552e\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\u62a5\u9519:", (Object)e);
                throw e;
            }
            logger.info("\u9500\u552e\u53cd\u6838\u9500\u8c03\u7528\u6838\u7b97\u63a5\u53e3\u7ed3\u675f\u3002\u3002\u3002" + System.currentTimeMillis());
        }
        catch (Throwable e) {
            syncLockHelper.close();
            this.addErrorMsg(bizBills[0], this.getErrorMsg(new Exception(e)));
        }
    }

    private void writeBackRecordB(ArrayList<Long> childIds, Set<Long> noWriteChildEntryIds, Set<Long> bizbillIds) {
        HashMap<Long, String> updateIdsMap = new HashMap<Long, String>();
        QFilter qa = new QFilter("id", "in", childIds);
        HashSet<Long> ancestorIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.ancestorbillid", (QFilter[])qa.toArray(), null);){
            for (Row row : dataSet) {
                ancestorIds.add(row.getLong("entry.ancestorbillid"));
            }
        }
        QFilter qb = new QFilter("entry.ancestorbillid", "in", ancestorIds);
        qb.and("writeoffstatus", "=", (Object)"B");
        qb.and("bizbillid", "in", bizbillIds);
        HashMap<Long, HashMap<String, BigDecimal>> bMap = new HashMap<Long, HashMap<String, BigDecimal>>();
        HashSet<Long> aIDs = new HashSet<Long>(16);
        String updateSql = "update t_cal_calcostrecordentry set fbaseqty = fbaseqty + ?,fmaterialcost = fmaterialcost + ?,fprocesscost = fprocesscost + ?,fstandardcost = fstandardcost + ?,ffee = ffee + ?,flocaltax = flocaltax + ?,factualcost = factualcost + ? where fentryid = ?";
        String updateSql_a = "update t_cal_calcostrecordentry set fmanufacturecost = fmanufacturecost + ?,fresource = fresource + ? where fentryid = ?";
        HashMap<Long, HashSet<Long>> abIdMap = new HashMap<Long, HashSet<Long>>();
        try (DataSet dataSetA = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,entry.id,entry.baseqty,entry.materialcost,entry.processcost,entry.standardcost,entry.fee,entry.manufacturecost,entry.resource,entry.localtax,entry.actualcost,entry.ancestorentryid,writeoffperiod", (QFilter[])qa.toArray(), null);){
            Throwable throwable = null;
            try (DataSet dataSetB = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,billno,entry.id,entry.ancestorentryid,writeoffperiod", (QFilter[])qb.toArray(), null);){
                DataSet joinSet = dataSetB.join(dataSetA).on("entry.ancestorentryid", "entry.ancestorentryid").select(new String[]{"id as bid", "billno", "entry.id as bentryid", "writeoffperiod as bwriteoffperiod"}, new String[]{"id as aid", "entry.id as aentryid", "entry.baseqty as abaseqty", "entry.materialcost as amaterialcost", "entry.processcost as aprocesscost", "entry.standardcost as astandardcost", "entry.fee as afee", "entry.manufacturecost as amanufacturecost", "entry.resource as aresource", "entry.localtax as alocaltax", "entry.actualcost as aactualcost", "writeoffperiod as awriteoffperiod"}).finish();
                Object object = null;
                try {
                    for (Row row : joinSet) {
                        Long aWriteoffperiod = row.getLong("awriteoffperiod");
                        Long bWriteoffperiod = row.getLong("bwriteoffperiod");
                        if (aWriteoffperiod > bWriteoffperiod || !noWriteChildEntryIds.contains(row.getLong("aentryid"))) continue;
                        aIDs.add(row.getLong("aentryid"));
                        updateIdsMap.put(row.getLong("bid"), row.getString("billno"));
                        Long bEntryId = row.getLong("bentryid");
                        Long aEntryId = row.getLong("aentryid");
                        HashSet<Long> aidSet = (HashSet<Long>)abIdMap.get(bEntryId);
                        if (aidSet == null) {
                            aidSet = new HashSet<Long>();
                            abIdMap.put(bEntryId, aidSet);
                        }
                        aidSet.add(aEntryId);
                        HashMap<String, BigDecimal> aMap = (HashMap<String, BigDecimal>)bMap.get(bEntryId);
                        if (aMap == null) {
                            aMap = new HashMap<String, BigDecimal>(16);
                            aMap.put("baseqty", row.getBigDecimal("abaseqty"));
                            aMap.put("materialcost", row.getBigDecimal("amaterialcost"));
                            aMap.put("processcost", row.getBigDecimal("aprocesscost"));
                            aMap.put("standardcost", row.getBigDecimal("astandardcost"));
                            aMap.put("fee", row.getBigDecimal("afee"));
                            aMap.put("manufacturecost", row.getBigDecimal("amanufacturecost"));
                            aMap.put("resource", row.getBigDecimal("aresource"));
                            aMap.put("localtax", row.getBigDecimal("alocaltax"));
                            aMap.put("actualcost", row.getBigDecimal("aactualcost"));
                            bMap.put(bEntryId, aMap);
                            continue;
                        }
                        aMap.put("baseqty", ((BigDecimal)aMap.get("baseqty")).add(row.getBigDecimal("abaseqty")));
                        aMap.put("materialcost", ((BigDecimal)aMap.get("materialcost")).add(row.getBigDecimal("amaterialcost")));
                        aMap.put("processcost", ((BigDecimal)aMap.get("processcost")).add(row.getBigDecimal("aprocesscost")));
                        aMap.put("standardcost", ((BigDecimal)aMap.get("standardcost")).add(row.getBigDecimal("astandardcost")));
                        aMap.put("fee", ((BigDecimal)aMap.get("fee")).add(row.getBigDecimal("afee")));
                        aMap.put("manufacturecost", ((BigDecimal)aMap.get("manufacturecost")).add(row.getBigDecimal("amanufacturecost")));
                        aMap.put("resource", ((BigDecimal)aMap.get("resource")).add(row.getBigDecimal("aresource")));
                        aMap.put("localtax", ((BigDecimal)aMap.get("localtax")).add(row.getBigDecimal("alocaltax")));
                        aMap.put("actualcost", ((BigDecimal)aMap.get("actualcost")).add(row.getBigDecimal("aactualcost")));
                    }
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    if (joinSet != null) {
                        if (object != null) {
                            try {
                                joinSet.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                        } else {
                            joinSet.close();
                        }
                    }
                }
            }
            catch (Throwable joinSet) {
                Throwable throwable4 = joinSet;
                throw joinSet;
            }
        }
        noWriteChildEntryIds.removeAll(aIDs);
        if (!updateIdsMap.isEmpty()) {
            this.checkVoucher(updateIdsMap);
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(bMap.size());
        ArrayList<Object[]> paramList_a = new ArrayList<Object[]>(bMap.size());
        for (Map.Entry entry : bMap.entrySet()) {
            Map aMap = (Map)entry.getValue();
            paramList.add(new Object[]{aMap.get("baseqty"), aMap.get("materialcost"), aMap.get("processcost"), aMap.get("standardcost"), aMap.get("fee"), aMap.get("localtax"), aMap.get("actualcost"), entry.getKey()});
            paramList_a.add(new Object[]{aMap.get("manufacturecost"), aMap.get("resource"), entry.getKey()});
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql, paramList);
        }
        if (!paramList_a.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql_a, paramList_a);
        }
        if (abIdMap.isEmpty()) {
            return;
        }
        HashSet aidSet = new HashSet();
        for (Set set : abIdMap.values()) {
            aidSet.addAll(set);
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,baseqty,standardcost,unitstandardcost", (QFilter[])new QFilter("entryid", "in", aidSet).toArray());
        HashMap<Long, HashSet<DynamicObject>> aInfoMap = new HashMap<Long, HashSet<DynamicObject>>();
        for (DynamicObject info : dynamicObjectCollection) {
            Long aEntryId = info.getLong("entryid");
            HashSet<DynamicObject> set = (HashSet<DynamicObject>)aInfoMap.get(aEntryId);
            if (set == null) {
                set = new HashSet<DynamicObject>();
                aInfoMap.put(aEntryId, set);
            }
            set.add(info);
        }
        String detailSql = "update t_cal_costrecord_detail set fbaseqty = fbaseqty + ?,factualcost = factualcost + ?,fstandardcost = fstandardcost + ? where fentryid = ? and fcostsubelementid = ?";
        ArrayList<Object[]> detailParamList = new ArrayList<Object[]>();
        for (Map.Entry entry : abIdMap.entrySet()) {
            Long bEntryId = (Long)entry.getKey();
            Set aEntryIds = (Set)entry.getValue();
            for (Long aEntryId : aEntryIds) {
                Set aInfoSet = (Set)aInfoMap.get(aEntryId);
                if (aInfoSet == null) continue;
                for (DynamicObject info : aInfoSet) {
                    detailParamList.add(new Object[]{info.getBigDecimal("baseqty"), info.getBigDecimal("actualcost"), info.getBigDecimal("standardcost"), bEntryId, info.getLong("costsubelement")});
                }
            }
        }
        if (!detailParamList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)detailSql, detailParamList);
        }
    }

    private void deleteIepBusinesstask(ArrayList<Long> recordIds) {
        WhiteListHelper.deleteWhiteList((String)"cal_costrecord_subentity", recordIds);
    }

    private void deletChildBills(ArrayList<Long> ids, ArrayList<Long> childEntryIds) {
        if (ids.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("id", "in", ids);
        QFilter costRecordDetailFilter = new QFilter("entryid", "in", childEntryIds);
        DeleteServiceHelper.delete((String)"cal_costrecord", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"cal_costrecord_detail", (QFilter[])new QFilter[]{costRecordDetailFilter});
    }

    private DynamicObject[] checkMoreReocrd(Set<Long> writeOffIDSet, Set<Long> bizbillIds) {
        int cSize = writeOffIDSet.size();
        HashSet<Long> costRecordAidSet = new HashSet<Long>(cSize);
        if (this.hasMoreRecord(writeOffIDSet, costRecordAidSet, bizbillIds) && costRecordAidSet.isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter q = new QFilter("id", "in", costRecordAidSet);
        String field = this.getCostReorcdField(true);
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)field, (QFilter[])q.toArray());
        return costRecords;
    }

    private boolean hasMoreRecord(Set<Long> writeOffIDSet, Set<Long> costRecordAidSet, Set<Long> bizbillIds) {
        HashSet<Long> copySet = new HashSet<Long>(writeOffIDSet);
        HashSet<Long> runningSet = new HashSet<Long>();
        QFilter q = new QFilter("bizbillid", "in", writeOffIDSet);
        q.and("success", "=", (Object)Character.valueOf('2'));
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)(this.getClass() + "hasMoreRecord"), (String)"cal_businesslog", (String)"success,bizbillid", (QFilter[])q.toArray(), null);){
            for (Row row : rs) {
                runningSet.add(row.getLong("bizbillid"));
            }
        }
        q = new QFilter("entry.writeoffid", "in", writeOffIDSet);
        q.and("bizbillid", "in", bizbillIds);
        rs = QueryServiceHelper.queryDataSet((String)(this.getClass() + "hasMoreRecord"), (String)"cal_costrecord", (String)"id,billno,costaccount,entry.id,entry.fatherentryid,entry.writeoffid", (QFilter[])q.toArray(), null);
        var8_8 = null;
        try {
            while (rs.hasNext()) {
                Row row = rs.next();
                costRecordAidSet.add(row.getLong("id"));
                copySet.remove(row.getLong("entry.writeoffid"));
            }
        }
        catch (Throwable row) {
            var8_8 = row;
            throw row;
        }
        finally {
            if (rs != null) {
                if (var8_8 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable row) {
                        var8_8.addSuppressed(row);
                    }
                } else {
                    rs.close();
                }
            }
        }
        if (!copySet.isEmpty()) {
            boolean isRedBlueWrite;
            HashSet<Long> hasRedBillWriteOffSet;
            HashSet<Long> hasBillWriteOffSet;
            block94: {
                hasBillWriteOffSet = new HashSet<Long>(128);
                hasRedBillWriteOffSet = new HashSet<Long>(128);
                QFilter q1 = new QFilter("id", "in", writeOffIDSet);
                isRedBlueWrite = false;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ar_verifyrecord", (String)"id,billid,verifyrelation,entry.e_billid", (QFilter[])q1.toArray(), null);){
                    Throwable throwable;
                    DataSet joinSet;
                    HashSet<Long> billIdSet = new HashSet<Long>(writeOffIDSet.size());
                    HashSet<Long> redBillIdSet = new HashSet<Long>(writeOffIDSet.size());
                    for (Row row : dataSet.copy()) {
                        billIdSet.add(row.getLong("billid"));
                        String verifyRelation = row.getString("verifyrelation");
                        if (!"salself".equals(verifyRelation) && !"arfinself".equals(verifyRelation)) continue;
                        isRedBlueWrite = true;
                        redBillIdSet.add(row.getLong("entry.e_billid"));
                    }
                    QFilter q2 = new QFilter("bizbillid", "in", billIdSet);
                    try (DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid", (QFilter[])q2.toArray(), null);){
                        joinSet = dataSet.copy().join(dataSet1).on("billid", "bizbillid").select(new String[]{"id as writeoffid"}, new String[]{"id as billid"}).finish();
                        throwable = null;
                        try {
                            for (Row row : joinSet) {
                                hasBillWriteOffSet.add(row.getLong("writeoffid"));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (joinSet != null) {
                                if (throwable != null) {
                                    try {
                                        joinSet.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    joinSet.close();
                                }
                            }
                        }
                    }
                    if (!isRedBlueWrite) break block94;
                    q2 = new QFilter("bizbillid", "in", redBillIdSet);
                    dataSet1 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizbillid", (QFilter[])q2.toArray(), null);
                    var17_29 = null;
                    try {
                        joinSet = dataSet.join(dataSet1).on("entry.e_billid", "bizbillid").select(new String[]{"id as writeoffid"}, new String[]{"id as billid"}).finish();
                        throwable = null;
                        try {
                            for (Row row : joinSet) {
                                hasRedBillWriteOffSet.add(row.getLong("writeoffid"));
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (joinSet != null) {
                                if (throwable != null) {
                                    try {
                                        joinSet.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    joinSet.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        var17_29 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (dataSet1 != null) {
                            if (var17_29 != null) {
                                try {
                                    dataSet1.close();
                                }
                                catch (Throwable throwable7) {
                                    var17_29.addSuppressed(throwable7);
                                }
                            } else {
                                dataSet1.close();
                            }
                        }
                    }
                }
            }
            Iterator iterator = copySet.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (!runningSet.contains(id) || !(isRedBlueWrite ? hasBillWriteOffSet.contains(id) && hasRedBillWriteOffSet.contains(id) : hasBillWriteOffSet.contains(id))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u540e\u7684\u5b58\u8d27\u6838\u7b97\u670d\u52a1\u672a\u6267\u884c\u5b8c\u6210\u6216\u8005\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u8fdb\u5165\u201c\u5b58\u8d27\u6838\u7b97>\u6838\u7b97\u5355\u636e>\u670d\u52a1\u6267\u884c\u65e5\u5fd7\u201d\u786e\u8ba4\uff0c\u5982\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurUnWriteOffServiceProcess_7", (String)"fi-cal-business", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Override
    protected String getCostRecordEntity() {
        return "cal_costrecord_subentity";
    }
}

