/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.adjbill.OrderDiffAdjBillCreateHelper;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.billgroup.CostDomainGroupHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.CostRecordAuditInvoker;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.WhiteListHelper;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DBUtil;
import kd.fi.cal.common.util.DateUtils;

public class SyncBizBill4AfterAuditNewServiceProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(SyncBizBill4AfterAuditNewServiceProcess.class);

    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        Serializable bizbillid;
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u5f00\u59cb\u63d2\u4ef6\uff1a" + System.currentTimeMillis());
        if (bizBills.length == 0 || "im_initbill".equals(bizBills[0].getDataEntityType().getName())) {
            return;
        }
        Set bufferPoolBizBills = (Set)this.calProcessContext.getCustomerParams("bufferPoolBizBills");
        HashSet<Long> balSet = new HashSet<Long>(bizBills.length);
        HashSet<Long> balIdSet = new HashSet<Long>(bizBills.length);
        HashSet<Long> costRecordSet = new HashSet<Long>(bizBills.length);
        HashSet<Long> idSet = new HashSet<Long>(bizBills.length);
        for (DynamicObject info : bizBills) {
            if (info == null || bufferPoolBizBills != null && bufferPoolBizBills.contains(info.getLong("id"))) continue;
            long id = info.getLong("id");
            idSet.add(id);
        }
        if (idSet.isEmpty()) {
            return;
        }
        QFilter qf = new QFilter("bizbillid", "in", idSet);
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(qf);
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u5f00\u59cb\u83b7\u53d6\u4e0d\u66f4\u65b0\u6838\u7b97\u4f59\u989d\u7684\u4e1a\u52a1\u7c7b\u578bid\u96c6\u5408\uff1a" + System.currentTimeMillis());
        Set bizTypeIdSet = CommonSettingHelper.getNotUpdBalBizType();
        HashSet<Long> calBillIds = new HashSet<Long>(16);
        HashMap<Long, Long> costRecIdBizBillIdMap = new HashMap<Long, Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,isinitbill,entry.id,biztype,bizbillid,calbillid", (QFilter[])qf.toArray(), null);){
            for (Row row : dataSet) {
                long id = row.getLong("id");
                calBillIds.add(row.getLong("calbillid"));
                bizbillid = row.getLong("bizbillid");
                costRecordSet.add(id);
                long entryId = row.getLong("entry.id");
                boolean isInitBill = row.getBoolean("isinitbill");
                if (!isInitBill && !bizTypeIdSet.contains(row.getLong("biztype"))) {
                    balSet.add(entryId);
                    balIdSet.add(id);
                }
                costRecIdBizBillIdMap.put(id, (Long)bizbillid);
            }
        }
        DynamicObject[] infos = BusinessDataServiceHelper.load((Object[])costRecordSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord"));
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u5f00\u59cb\u751f\u6210\u8ba2\u5355\u4ef7\u5dee\u6210\u672c\u8c03\u6574\u5355\uff1a" + System.currentTimeMillis());
        HashMap<Long, String> tgCalentryIdGroupIdMap = new HashMap(16);
        tgCalentryIdGroupIdMap = (Map)this.calProcessContext.getCustomerParams("tgCalentryIdGroupIdMap");
        logger.info("SyncBizBill4AfterAuditNewServiceProcess doProcessor tgCalentryIdGroupIdMap=" + tgCalentryIdGroupIdMap);
        HashMap<String, String> groupIdSrcBillValueStrMap = new HashMap(16);
        groupIdSrcBillValueStrMap = (Map)this.calProcessContext.getCustomerParams("groupIdSrcBillValueStrMap");
        logger.info("SyncBizBill4AfterAuditNewServiceProcess doProcessor groupIdSrcBillValueStrMap=" + groupIdSrcBillValueStrMap);
        OrderDiffAdjBillCreateHelper adjBillHelper = new OrderDiffAdjBillCreateHelper(true, infos);
        Set<Long> needUpdateQueuetypeEntryids = adjBillHelper.createCostAdjustBill(tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap);
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u7ed3\u675f\u751f\u6210\u8ba2\u5355\u4ef7\u5dee\u6210\u672c\u8c03\u6574\u5355\uff1a" + System.currentTimeMillis());
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u5f00\u59cb\u751f\u6210\u667a\u80fd\u6838\u7b97\u5355\uff1a" + System.currentTimeMillis());
        this.createIepBusinesstask(costRecordSet);
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u7ed3\u675f\u751f\u6210\u667a\u80fd\u6838\u7b97\u5355\uff1a" + System.currentTimeMillis());
        this.updateCalBillStatus(idSet);
        this.updateBillStatus(costRecordSet);
        this.updateBillQueuetype(needUpdateQueuetypeEntryids);
        TraceSpan span = Tracer.create((String)"SyncBizBill4AfterAuditNewServiceProcess.updateCalBal", (String)"updateCalBal");
        bizbillid = null;
        try {
            if (!balSet.isEmpty()) {
                boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
                if (isNewBalance) {
                    Set<Long> groupBizBillIds = this.getGroupBizBillIds(bizBills, idSet);
                    Set<Long> groupCostRecIds = this.getCostRecIdsByBizBillIds(groupBizBillIds);
                    balIdSet.addAll(groupCostRecIds);
                    this.updateNewBalance(balIdSet, params);
                } else if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DAILY_BAL).booleanValue()) {
                    this.updateBalance(balSet, balIdSet);
                }
            }
        }
        catch (Throwable throwable) {
            bizbillid = throwable;
            throw throwable;
        }
        finally {
            if (span != null) {
                if (bizbillid != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)bizbillid).addSuppressed(throwable);
                    }
                } else {
                    span.close();
                }
            }
        }
        if (AcctGroupModelHelper.isBizGroupModel()) {
            CostDomainGroupHelper costDomainGroupHelper = new CostDomainGroupHelper();
            costDomainGroupHelper.setFilterGroupAcct(true);
            costDomainGroupHelper.insertAndUpdateCostDomainGroupByBizBill(Collections.singletonMap(bizBills[0].getDataEntityType().getName(), idSet));
        } else if (AcctGroupModelHelper.isNewGroupModel()) {
            new CostDomainGroupHelper().insertAndUpdateCostDomainGroup(calBillIds, null);
        } else {
            this.handleGroupUpdateTime(idSet);
        }
        String entityNmae = bizBills[0].getDataEntityType().getName();
        if (!"im_mdc_ominbill".equals(entityNmae) && !"im_ospurinbill".equals(entityNmae)) {
            CostRecordAuditInvoker costRecordAuditInvoker = new CostRecordAuditInvoker();
            costRecordAuditInvoker.setCostRecIdBizBillIdMap(costRecIdBizBillIdMap);
            costRecordAuditInvoker.invoke(balIdSet);
        }
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u7ed3\u675f\u66f4\u65b0\u4f59\u989d\u8868updateBalance\uff1a" + System.currentTimeMillis());
        logger.info("SyncBizBill4AfterAuditServiceProcess-\u9000\u51fa\u63d2\u4ef6\uff1a" + System.currentTimeMillis());
    }

    private void handleGroupUpdateTime(Set<Long> allBizBillId) {
        if (allBizBillId.isEmpty()) {
            return;
        }
        HashSet<Long> fids = new HashSet<Long>(4);
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)("select fid from t_cal_grouprecordentry where fbizbillid in " + DBUtil.getInStringFromSet2(allBizBillId)));){
            for (Row row : dataSet) {
                fids.add(row.getLong("fid"));
            }
        }
        if (fids.isEmpty()) {
            return;
        }
        String sql = "update t_cal_groupbillrecord set fupdatetime = ? where fid in " + DBUtil.getInStringFromSet2(fids);
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, (Object[])new Object[]{TimeServiceHelper.now()});
    }

    private void updateNewBalance(Set<Long> balIdSet, Map params) {
        if (params != null && params.get("type") != null && params.get("billStatus") != null && BalanceSourceEnum.DEAL_ABNORMAL_COST.getValue().equals(params.get("type").toString())) {
            BalanceOpInvoker balanceOpInvoker = new BalanceOpInvoker();
            balanceOpInvoker.setBillStatus(params.get("billStatus").toString());
            balanceOpInvoker.invokeCostRecordUpdateBalOp(balIdSet, BalanceSourceEnum.DEAL_ABNORMAL_COST);
        } else {
            new BalanceOpInvoker().invokeCostRecordUpdateBalOp(balIdSet, BalanceSourceEnum.COSTRECORD_CREATE);
        }
    }

    private void addQueue(Map<Long, DynamicObject> failBillMap) {
        if (failBillMap.size() == 0) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("retry", "1");
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{"AUDIT", param, failBillMap.values().toArray(new DynamicObject[0])});
        throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SyncBizBill4AfterAuditServiceProcess_1", (String)"fi-cal-business", (Object[])new Object[0]));
    }

    private void updateBillStatus(Set costRecordIds) {
        if (costRecordIds.size() < 1) {
            return;
        }
        String ids = DBUtil.getInStringFromSet2((Set)costRecordIds);
        String updateSql = "update t_cal_calcostrecord set fbillstatus = 'C',fcalstatus='A',fcostupdatetime = {ts'" + DateUtils.getNowTimeStr() + "'} where fid in " + ids;
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql);
        String updateEntryStatusSql = "update t_cal_calcostrecordentry set fentrystatus = 'C' where fid in " + ids;
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateEntryStatusSql);
    }

    private void updateCalBillStatus(Set<Long> bizBillIds) {
        if (bizBillIds.size() < 1) {
            return;
        }
        String ids = DBUtil.getInStringFromSet2(bizBillIds);
        String inCalBillUpdateSql = "update t_cal_incalbill set fbillstatus = 'C' where fbizbillid in " + ids;
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)inCalBillUpdateSql);
        String outCalBillUpdateSql = "update t_cal_outcalbill set fbillstatus = 'C' where fbizbillid in " + ids;
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)outCalBillUpdateSql);
    }

    private void updateBalance(Set<Long> balSet, Set<Long> ids) {
        String acctId = CacheKeyUtil.getAcctId();
        String lockKey = "fi-cal-billsynclock_updatebal" + acctId;
        DLock dlock = DLock.createReentrant((String)lockKey, (String)"fi-cal-billsynclock_updatebal");
        this.addLock(lockKey, dlock);
        try {
            dlock.lock();
            new BalanceCalculator().updateBalance4CostRecord(balSet, ids);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u4f59\u989d\u62a5\u9519\uff1a%1$s", (String)"SyncBizBill4AuditServiceProcess_8", (String)"fi-cal-business", (Object[])new Object[0]), this.getErrorMsg(e));
            throw new KDBizException(msg);
        }
    }

    private void createIepBusinesstask(Set<Long> costRecordSet) {
        WhiteListHelper.writeWhiteList((String)"cal_costrecord_subentity", new ArrayList<Long>(costRecordSet));
    }

    private void updateBillQueuetype(Set<Long> needUpdateQueuetypeEntryids) {
        logger.info("SyncBizBill4AfterAuditNewServiceProcess updateBillQueuetype needUpdateQueuetypeEntryids =" + needUpdateQueuetypeEntryids);
        if (null == needUpdateQueuetypeEntryids || needUpdateQueuetypeEntryids.size() < 1) {
            return;
        }
        String entryids = DBUtil.getInStringFromSet2(needUpdateQueuetypeEntryids);
        String updateEntryStatusSql = "update t_cal_calcostrecordentry set fqueuetype = '0',fsignnum=-1 where fentryid in " + entryids;
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateEntryStatusSql);
    }

    private Set<Long> getCostRecIdsByBizBillIds(Set<Long> groupBizBillIds) {
        HashSet<Long> costRecIds = new HashSet<Long>(16);
        QFilter bizBillIdF = new QFilter("bizbillid", "in", groupBizBillIds);
        bizBillIdF.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.SPECIAL_ACCT.getValue(), AccountTypeEnum.ADD_AVERAGE.getValue()});
        DataSet cosRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])bizBillIdF.toArray(), null);
        for (Row row : cosRecDs) {
            Long costRecId = row.getLong("id");
            costRecIds.add(costRecId);
        }
        return costRecIds;
    }

    private Set<Long> getGroupBizBillIds(DynamicObject[] bizBills, Set<Long> bizBillIds) {
        HashSet<Long> groupBizBillIds = new HashSet<Long>(16);
        if (AcctGroupModelHelper.isBizGroupModel()) {
            HashMap<String, Set<Long>> form2BizbillIdMap = new HashMap<String, Set<Long>>(16);
            String bizEntity = bizBills[0].getDataEntityType().getName();
            for (DynamicObject bizBill : bizBills) {
                Set tmpBizBillIds = form2BizbillIdMap.computeIfAbsent(bizEntity, k -> new HashSet(16));
                tmpBizBillIds.add(bizBill.getLong("id"));
            }
            DataSet billGroupDs = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(form2BizbillIdMap);
            for (Row row : billGroupDs) {
                String groupType = row.getString("type");
                if ("1".equals(groupType)) continue;
                groupBizBillIds.add(row.getLong("bizbillid"));
            }
        } else {
            String groupRecKey = AcctGroupModelHelper.isNewGroupModel() ? "cal_account_grouprecord" : "cal_groupbillrecord";
            QFilter billF = new QFilter("entryentity.bizbillid", "in", bizBillIds);
            DataSet billGroupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)groupRecKey, (String)"id as groupid,entryentity.bizbillid as gbizbillid", (QFilter[])new QFilter[]{billF}, null);
            HashSet<Long> groupIds = new HashSet<Long>(16);
            for (Row row : billGroupDs) {
                groupIds.add(row.getLong("groupid"));
            }
            QFilter groupIdF = new QFilter("id", "in", groupIds);
            DataSet allBillGroupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)groupRecKey, (String)"id as groupid,entryentity.bizbillid as gbizbillid,entryentity.type as type", (QFilter[])new QFilter[]{groupIdF}, null);
            for (Row row : allBillGroupDs) {
                String groupType = row.getString("type");
                if ("1".equals(groupType)) continue;
                groupBizBillIds.add(row.getLong("gbizbillid"));
            }
        }
        return groupBizBillIds;
    }
}

