/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.impl.CreateInitCalBillProcess;
import kd.fi.cal.business.process.inner.CostRecordCostHandle;
import kd.fi.cal.business.process.inner.PeriodChecker;
import kd.fi.cal.business.process.inner.SyncOpLegalChecker;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostPriceSourceTypeHelper;
import kd.fi.cal.common.helper.CostTypeHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.ScmParamsHelper;
import kd.fi.cal.common.helper.StandardCostHelper;
import kd.fi.cal.common.helper.StopSyncBizBillHelper;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DBUtil;
import kd.fi.cal.common.util.DateUtils;

public class SyncBizBill4AuditNewServiceProcess
extends AbstractBizProcessor {
    private static final Log logger = LogFactory.getLog(SyncBizBill4AuditNewServiceProcess.class);
    private Map<Long, SynBillErrInfo> errMap = new HashMap<Long, SynBillErrInfo>(32);
    private String bizbillentityname;
    private Set<String> purOutSourceBills = CommonSettingHelper.getBizEntityNumbers((String)"purbiztype");
    private Map<Long, Boolean> enableStandCostMap = new HashMap<Long, Boolean>(16);
    private Set<Long> notUpdBalBizTypeIdSet = new HashSet<Long>(16);
    private Set<Long> isCalInvSchemeIds = new HashSet<Long>(16);
    private Set<Long> isCalInvTypeIds = new HashSet<Long>(16);
    private String bizbillentrykey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        HashMap<Long, Set<DynamicObject>> hashMap;
        DynamicObject[] costRecordDycs;
        Long currtime;
        block37: {
            block38: {
                HashSet<Long> allBizBillId;
                block35: {
                    block36: {
                        block33: {
                            block34: {
                                block31: {
                                    block32: {
                                        if (bizBills != null && bizBills.length >= 1) break block31;
                                        if (this.errMap.isEmpty()) break block32;
                                        for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                                            this.addErrorMsg(entry.getKey(), entry.getValue());
                                        }
                                    }
                                    return;
                                }
                                currtime = System.currentTimeMillis();
                                DynamicObject bizBill = bizBills[0];
                                logger.debug("SyncBizBill4AuditNewServiceProcess-\u8fdb\u5165\u63d2\u4ef6-" + bizBill.getString("billno") + ":" + System.currentTimeMillis());
                                this.init(bizBill);
                                CreateInitCalBillProcess createInitCalBillProcess = new CreateInitCalBillProcess();
                                createInitCalBillProcess.doProcessor(params, bizBills);
                                this.getErrors().addAll(createInitCalBillProcess.getErrors());
                                if (bizBills.length != 0 && !"im_initbill".equals(bizBills[0].getDataEntityType().getName())) break block33;
                                if (this.errMap.isEmpty()) break block34;
                                for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                                    this.addErrorMsg(entry.getKey(), entry.getValue());
                                }
                            }
                            return;
                        }
                        Set omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
                        this.purOutSourceBills.addAll(omInBills);
                        allBizBillId = new HashSet<Long>(16);
                        for (DynamicObject item : bizBills) {
                            allBizBillId.add(item.getLong("id"));
                        }
                        currtime = System.currentTimeMillis();
                        this.setOperateInfo(allBizBillId);
                        if (!allBizBillId.isEmpty()) break block35;
                        if (this.errMap.isEmpty()) break block36;
                        for (Map.Entry entry : this.errMap.entrySet()) {
                            this.addErrorMsg((Long)entry.getKey(), (SynBillErrInfo)entry.getValue());
                        }
                    }
                    return;
                }
                costRecordDycs = this.loadCostRecordDycs(allBizBillId);
                hashMap = new HashMap<Long, Set<DynamicObject>>(16);
                for (DynamicObject item : costRecordDycs) {
                    Long l = item.getLong("bizbillid");
                    Set set = hashMap.computeIfAbsent(l, k -> new HashSet(16));
                    set.add(item);
                }
                currtime = System.currentTimeMillis();
                Map stopSyncBizBillMap = new StopSyncBizBillHelper().doStopSync(hashMap);
                if (stopSyncBizBillMap != null && !stopSyncBizBillMap.isEmpty()) {
                    this.errMap.putAll(stopSyncBizBillMap);
                }
                costRecordDycs = this.removeErrorCostRecord(hashMap);
                bizBills = this.removeErrorBizBillDyc(bizBills);
                SyncOpLegalChecker opCheck = new SyncOpLegalChecker(bizBills, ActionEnum.AUDIT.getValue());
                opCheck.doCheck();
                this.errMap.putAll(opCheck.getErrMap());
                costRecordDycs = this.removeErrorCostRecord(hashMap);
                PeriodChecker periodChecker = new PeriodChecker(costRecordDycs);
                periodChecker.doCheck();
                this.errMap.putAll(periodChecker.getErrMap());
                costRecordDycs = this.removeErrorCostRecord(hashMap);
                if (costRecordDycs.length >= 1) break block37;
                if (this.errMap.isEmpty()) break block38;
                for (Map.Entry entry : this.errMap.entrySet()) {
                    this.addErrorMsg((Long)entry.getKey(), (SynBillErrInfo)entry.getValue());
                }
            }
            return;
        }
        try {
            bizBills = this.removeErrorBizBillDyc(bizBills);
            this.setCostRecordEntryAuditDate(costRecordDycs);
            Set notUpdbizTypeIds = CommonSettingHelper.getNotUpdBalBizType();
            this.cacheAcctEnableStandCostMap(costRecordDycs);
            currtime = System.currentTimeMillis();
            this.cacheInvSchemeAndInvTypeInfos();
            currtime = System.currentTimeMillis();
            Throwable throwable = null;
            try (TraceSpan traceSpan = Tracer.create((String)"SyncBizBill4AuditNewServiceProcess.checkCadMatcostInfo", (String)"checkCadMatcostInfo");){
                this.checkCadMatcostInfo(costRecordDycs);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            costRecordDycs = this.removeErrorCostRecord(hashMap);
            currtime = System.currentTimeMillis();
            if (costRecordDycs.length < 1) {
                return;
            }
            currtime = System.currentTimeMillis();
            String string = String.valueOf(params.get("type"));
            costRecordDycs = this.costRecordCostHandle(bizBills, costRecordDycs, hashMap, string);
            this.updateAfterCostPriceSource(costRecordDycs, string);
            this.checkAmountZero(costRecordDycs, notUpdbizTypeIds);
            costRecordDycs = this.removeErrorCostRecord(hashMap);
            if (costRecordDycs.length < 1) {
                return;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!this.errMap.isEmpty()) {
                for (Map.Entry<Long, SynBillErrInfo> entry : this.errMap.entrySet()) {
                    this.addErrorMsg(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private DynamicObject[] costRecordCostHandle(DynamicObject[] bizBills, DynamicObject[] costRecordDycs, Map<Long, Set<DynamicObject>> costRecordMap, String auditType) {
        if (this.calProcessContext.getCustomerParams("ifromsubmit") == null) {
            CostElementHelper.addCostRecElements((DynamicObject[])costRecordDycs);
            CostRecordCostHandle costHandle = new CostRecordCostHandle(costRecordDycs, auditType);
            costHandle.setBizBillEntityName(this.bizbillentityname);
            costHandle.setBizBillEntryKey(this.bizbillentrykey);
            costHandle.setSyncPrice(Boolean.TRUE);
            costRecordDycs = costHandle.handle();
            costRecordMap.clear();
            for (DynamicObject costRecordDyc : costRecordDycs) {
                Long bizBillId = costRecordDyc.getLong("bizbillid");
                Set recordDycs = costRecordMap.computeIfAbsent(bizBillId, k -> new HashSet(16));
                recordDycs.add(costRecordDyc);
            }
            this.errMap.putAll(costHandle.getErrMap());
            costRecordDycs = this.removeErrorCostRecord(costRecordMap);
            bizBills = this.removeErrorBizBillDyc(bizBills);
        }
        return costRecordDycs;
    }

    protected void init(DynamicObject bizBill) {
        Long currtime = System.currentTimeMillis();
        logger.info("SyncBizBill4AuditNewServiceProcess-\u8fdb\u5165\u63d2\u4ef6-" + bizBill.getString("billno") + ":" + System.currentTimeMillis());
        this.bizbillentityname = bizBill.getDataEntityType().getName();
        this.bizbillentrykey = this.getEntryKey(this.bizbillentityname);
        this.notUpdBalBizTypeIdSet = CommonSettingHelper.getNotUpdBalBizType();
        logger.info("SyncBizBill4AuditNewServiceProcess-\u7ed3\u675f\u521d\u59cb\u5316\u65b9\u6cd5init\uff1a" + (currtime - System.currentTimeMillis()));
    }

    private void checkAmountZero(DynamicObject[] recordDycs, Set<Long> bizTypeIdSet) {
        if (!this.purOutSourceBills.contains(this.bizbillentityname)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u542f\u7528\u4e86\u6807\u51c6\u6210\u672c\u6216\u8005\u8ba1\u4ef7\u65b9\u6cd5\u662f\u6807\u51c6\u6210\u672c\u65f6\u975e\u8d60\u54c1\u884c\u91d1\u989d\u4e3a0\u3002", (String)"SyncBizBill4AuditServiceProcess_19", (String)"fi-cal-business", (Object[])new Object[0]);
        block0: for (DynamicObject recordDyc : recordDycs) {
            boolean notUpdBal = bizTypeIdSet.contains(recordDyc.getLong("biztype_id"));
            DynamicObjectCollection recordEntryDycs = recordDyc.getDynamicObjectCollection("entry");
            Long costAccountId = recordDyc.getLong("costaccount_id");
            for (DynamicObject recordEntryDyc : recordEntryDycs) {
                String accountType = recordEntryDyc.getString("accounttype");
                BigDecimal actualCost = recordEntryDyc.getBigDecimal("actualcost");
                BigDecimal unitActualCost = recordEntryDyc.getBigDecimal("unitactualcost");
                boolean stdAcct = AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) || this.enableStandCostMap.get(costAccountId) != false;
                boolean isFree = recordEntryDyc.getBoolean("ispresent");
                boolean moveOrFIFO = AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(accountType) || AccountTypeEnum.FIN_FOUT.getValue().equals(accountType);
                boolean actIsZero = actualCost.compareTo(BigDecimal.ZERO) == 0 && unitActualCost.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject invscheme = recordDyc.getDynamicObject("invscheme");
                boolean zerocost = invscheme.getBoolean("zerocost");
                HashSet<Long> zeroInOutBizTypeIds = new HashSet<Long>();
                DynamicObject settingObj = CommonSettingHelper.getSettingObj();
                DynamicObjectCollection bizTypes = settingObj.getDynamicObjectCollection("zeroinoutbiztype");
                for (DynamicObject bizType : bizTypes) {
                    zeroInOutBizTypeIds.add(bizType.getDynamicObject("fbasedataid").getLong("id"));
                }
                long biztype = recordDyc.getDynamicObject("biztype").getLong("id");
                String biztypenumber = recordDyc.getDynamicObject("bizentityobject").getString("number");
                if (!stdAcct || isFree || !actIsZero || zerocost || moveOrFIFO || notUpdBal || "im_purinbill".equals(biztypenumber) && "im_ospurinbill".equals(biztypenumber) || !zeroInOutBizTypeIds.isEmpty() && zeroInOutBizTypeIds.contains(biztype)) continue;
                this.errMap.put(recordDyc.getLong("bizbillid"), new SynBillErrInfo("3", msg));
                continue block0;
            }
        }
    }

    private void cacheAcctEnableStandCostMap(DynamicObject[] recordDycs) {
        HashSet<Object> costAccountIds = new HashSet<Object>(16);
        for (DynamicObject info : recordDycs) {
            costAccountIds.add(info.get("costaccount_id"));
        }
        QFilter acctf = new QFilter("id", "in", costAccountIds);
        DynamicObjectCollection costAccountDycs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,enablestandardcost,costtype,costtype.name", (QFilter[])acctf.toArray());
        for (DynamicObject costAccountDyc : costAccountDycs) {
            Long id = costAccountDyc.getLong("id");
            Boolean enableStandCost = costAccountDyc.getBoolean("enablestandardcost");
            this.enableStandCostMap.put(id, enableStandCost);
        }
    }

    private void checkCadMatcostInfo(DynamicObject[] infos) {
        if (infos == null) {
            return;
        }
        int cSize = infos.length;
        HashSet<Object> costAccountIds = new HashSet<Object>(cSize);
        for (DynamicObject info : infos) {
            costAccountIds.add(info.get("costaccount_id"));
        }
        QFilter q = new QFilter("id", "in", costAccountIds);
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,enablestandardcost,costtype,costtype.name,costtype.number", (QFilter[])q.toArray());
        int cSize1 = costAccountIds == null ? 16 : costAccountIds.size();
        Map billCostTypeMap = new HashMap(cSize1);
        HashMap<String, Boolean> enableStandCostMap = new HashMap<String, Boolean>(cSize1);
        for (DynamicObject costaccount : costAccounts) {
            String id = costaccount.getString("id");
            String costtype = costaccount.getString("costtype");
            Boolean enableStandCost = costaccount.getBoolean("enablestandardcost");
            if (id == null || costtype == null) continue;
            enableStandCostMap.put(id, enableStandCost);
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("entryid", (DataType)DateType.LongType), new Field("bizbillid", (DataType)DateType.LongType), new Field("costtype", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType), new Field("auditdate", (DataType)DateType.TimestampType), new Field("bookdate", (DataType)DateType.TimestampType)});
        DataSetBuilder billMatCostDataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        Set costTypeSet = new HashSet(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        billCostTypeMap = CostTypeHelper.getCostTypeByBillAndBookDate((DynamicObject[])infos, (String[])new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "bookdate"}, (int)0);
        HashMap paramsMap = new HashMap(16);
        Set calDimensionSet = StandardCostHelper.getCalDimensionSet((String)CommonSettingHelper.getCalDimensionStr());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
        for (DynamicObject info : infos) {
            Long invscheme = info.getLong("invscheme_id");
            Long bizType = info.getLong("biztype_id");
            if (this.notUpdBalBizTypeIdSet.contains(bizType)) continue;
            Long bizBillId = info.getLong("bizbillid");
            String costAccountId = info.getString("costaccount_id");
            String calorgId = info.getString("calorg_id");
            String storageorgunitId = info.getString("storageorgunit_id");
            String paramKey = (String)calorgId + "_" + costAccountId;
            Date auditdate = info.getDate("auditdate");
            Date date = info.getDate("bookdate");
            auditdate = SyncBizBill4AuditNewServiceProcess.getStandardCostDate(auditdate, date);
            Boolean enableStandCost = (Boolean)enableStandCostMap.get(costAccountId);
            Long costTypeId = (Long)billCostTypeMap.get(info.getLong("id"));
            DynamicObjectCollection coll = info.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : coll) {
                ArrayList params;
                Long invtype = entryInfo.getLong("invtype_id");
                if (!this.isCalInvSchemeIds.contains(invscheme) || !this.isCalInvTypeIds.contains(invtype)) continue;
                String accounttype = entryInfo.getString("accounttype");
                if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accounttype) && !enableStandCost.booleanValue()) continue;
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                Long materialId = entryInfo.getLong("material_id");
                materialIdSet.add(materialId);
                Long entryid = entryInfo.getLong("id");
                param.put("uniqueID", entryid);
                param.put("invorg", storageorgunitId);
                param.put("date", auditdate);
                param.put("material", materialId);
                String noupdatecalfields = entryInfo.getString("noupdatecalfields");
                if (calDimensionSet != null && calDimensionSet.size() > 0) {
                    for (String calDimension : calDimensionSet) {
                        if (StringUtils.isNotEmpty((String)noupdatecalfields) && noupdatecalfields.contains(calDimension)) continue;
                        Object value = entryInfo.get(calDimension);
                        IDataEntityProperty property = dataEntityType.findProperty(calDimension);
                        if (null == property) continue;
                        if (property instanceof BasedataProp) {
                            value = this.getBaseId(entryInfo, calDimension);
                        }
                        if (value != null) {
                            if (value instanceof DynamicObject) {
                                param.put(calDimension, ((DynamicObject)value).getPkValue());
                                continue;
                            }
                            param.put(calDimension, value);
                            continue;
                        }
                        param.put(calDimension, 0L);
                    }
                }
                if (null == (params = (ArrayList)paramsMap.get(paramKey)) || params.size() == 0) {
                    params = new ArrayList(16);
                    params.add(param);
                    paramsMap.put(paramKey, params);
                } else {
                    params.add(param);
                }
                billMatCostDataSetBuilder.append(new Object[]{entryid, bizBillId, costTypeId, materialId, auditdate, date});
            }
        }
        costTypeSet = CostTypeHelper.getCostTypeByOrgAndBookDate((DynamicObject[])infos, (String[])new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "accounttype", "bookdate"}, this.errMap, (int)0);
        if (costTypeSet.isEmpty() || materialIdSet.isEmpty() || paramsMap.isEmpty()) {
            return;
        }
        Map costTypeInfosMap = CostTypeHelper.getCostTypeInfos(costTypeSet);
        try (DataSet queryMatCostInfoDataSet = new StandardCostHelper().getStandardCost(paramsMap, true);
             DataSet billMatCostDataSet = billMatCostDataSetBuilder.build();){
            DataSet dataSet = billMatCostDataSet.groupBy(new String[]{"entryid", "bizbillid", "costtype", "material", "auditdate"}).finish().join(queryMatCostInfoDataSet, JoinType.INNER).on("entryid", "entryid").select(new String[]{"entryid", "bizbillid", "costtype", "material", "auditdate"}, new String[]{"effectdate", "expdate"}).finish().where("effectdate <= auditdate and expdate > auditdate");
            dataSet = billMatCostDataSet.join(dataSet, JoinType.LEFT).on("entryid", "entryid").select(new String[]{"entryid", "bizbillid", "costtype", "material"}, new String[]{"auditdate"}).finish();
            dataSet = dataSet.where("auditdate = null and costtype is not null");
            HashSet<Long> matIds = new HashSet<Long>(16);
            HashMap noCostInfoBizBillIdCostTypeMatMaps = new HashMap(16);
            for (Row row : dataSet) {
                HashSet<Long> noCostInfoMatIds;
                Long bizbillid = row.getLong("bizbillid");
                Long costType = row.getLong("costtype");
                Long l = row.getLong("material");
                HashMap<Long, HashSet<Long>> noCostInfoCostTypeMatMaps = (HashMap<Long, HashSet<Long>>)noCostInfoBizBillIdCostTypeMatMaps.get(bizbillid);
                if (noCostInfoCostTypeMatMaps == null) {
                    noCostInfoCostTypeMatMaps = new HashMap<Long, HashSet<Long>>(16);
                    noCostInfoBizBillIdCostTypeMatMaps.put(bizbillid, noCostInfoCostTypeMatMaps);
                }
                if ((noCostInfoMatIds = (HashSet<Long>)noCostInfoCostTypeMatMaps.get(costType)) == null) {
                    noCostInfoMatIds = new HashSet<Long>(16);
                    noCostInfoCostTypeMatMaps.put(costType, noCostInfoMatIds);
                }
                noCostInfoMatIds.add(l);
                matIds.add(l);
            }
            if (matIds.isEmpty()) {
                return;
            }
            HashMap<Long, String> materialNumMap = new HashMap<Long, String>(16);
            QFilter materialFilter = new QFilter("id", "in", matIds);
            DataSet materialDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id,number", (QFilter[])materialFilter.toArray(), null);
            Object object = null;
            try {
                for (Row row : materialDS) {
                    Long matId = row.getLong("id");
                    String number = row.getString("number");
                    materialNumMap.put(matId, number);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (materialDS != null) {
                    if (object != null) {
                        try {
                            materialDS.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        materialDS.close();
                    }
                }
            }
            HashSet<String> materialNames = new HashSet<String>(16);
            for (Map.Entry entry : noCostInfoBizBillIdCostTypeMatMaps.entrySet()) {
                Long bizBillId = (Long)entry.getKey();
                Map noCostInfoCostTypeMatMaps = (Map)entry.getValue();
                StringBuilder msg = new StringBuilder();
                for (Map.Entry mapEntry : noCostInfoCostTypeMatMaps.entrySet()) {
                    Long costtypeId = (Long)mapEntry.getKey();
                    Set materialIds = (Set)mapEntry.getValue();
                    if (costTypeInfosMap.get(costtypeId) == null) continue;
                    String costTypeName = ((DynamicObject)costTypeInfosMap.get(costtypeId)).getString("name");
                    String costTypeNum = ((DynamicObject)costTypeInfosMap.get(costtypeId)).getString("number");
                    costTypeNum = costTypeNum == null ? "" : costTypeNum;
                    costTypeName = costTypeName == null ? "" : costTypeName;
                    materialNames.clear();
                    for (Long matId : materialIds) {
                        String materialNum = (String)materialNumMap.get(matId);
                        materialNames.add("\u3010" + materialNum + "\u3011");
                    }
                    if (materialNames.isEmpty()) continue;
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\uff0c\u6ca1\u6709\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"SyncBizBill4AuditServiceProcess_30", (String)"fi-cal-business", (Object[])new Object[0]), String.join((CharSequence)",", materialNames), costTypeNum + " [" + costTypeName + "]");
                    msg.append(errorMsg);
                }
                if (msg.length() <= 0) continue;
                this.errMap.put(bizBillId, new SynBillErrInfo("3", msg.toString()));
            }
        }
    }

    private void cacheInvSchemeAndInvTypeInfos() {
        QFilter invSchemeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id", (QFilter[])invSchemeFilter.toArray());
        for (DynamicObject dynamicObject : invSchemes) {
            this.isCalInvSchemeIds.add(dynamicObject.getLong("id"));
        }
        QFilter invTypeFilter = new QFilter("isforwardamount", "=", (Object)true);
        DynamicObjectCollection invTypes = QueryServiceHelper.query((String)"bd_invtype", (String)"id", (QFilter[])invTypeFilter.toArray());
        for (DynamicObject dynamicObject : invTypes) {
            this.isCalInvTypeIds.add(dynamicObject.getLong("id"));
        }
    }

    private String getEntryKey(String entityname) {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entityname);
        for (Map.Entry entryItem : bizEntityType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entryItem.getValue();
            if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType || entityType instanceof SubEntryType) continue;
            return entityType.getName();
        }
        return null;
    }

    private void setOperateInfo(Set<Long> bizBillIds) {
        if (bizBillIds.size() == 0) {
            return;
        }
        String updateInCalBillSql = "update t_cal_incalbill set fauditorid = ?,fauditdate = ? where fbizentityobjectid = ? and fbizbillid = ?";
        String updateOutCalBillSql = "update t_cal_outcalbill set fauditorid = ?,fauditdate = ? where fbizentityobjectid = ? and fbizbillid = ?";
        String updateCostRecordSql = "update t_cal_calcostrecord set fauditorid = ?,fauditdate = ? where fbizentityobjectid = ? and fbizbillid = ?";
        updateCostRecordSql = new CalGroupAccountHelper().addNotGroupAcctFilter4CostRecordSql(updateCostRecordSql, bizBillIds);
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        HashMap<Long, Date> bizBillIdNewBookDateMap = new HashMap<Long, Date>(16);
        boolean containsBookdateField = EntityMetadataCache.getDataEntityType((String)this.bizbillentityname).getProperties().containsKey((Object)"bookdate");
        String selectFields = containsBookdateField ? "id,modifier,modifytime,auditor,auditdate,bookdate,biztime" : "id,modifier,modifytime,auditor,auditdate,biztime";
        String unAuditMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8be5\u4efb\u52a1\u53d6\u6d88\u3002", (String)"SyncBizBill4AuditServiceProcess_25", (String)"fi-cal-business", (Object[])new Object[0]);
        Date maxBookDate = null;
        Date minBookDate = null;
        boolean isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005");
        try (DataSet billAuditDateDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.bizbillentityname, (String)selectFields, (QFilter[])new QFilter("id", "in", bizBillIds).toArray(), null);){
            if (containsBookdateField) {
                for (Row row : billAuditDateDs) {
                    Date auditdate = row.getDate("auditdate");
                    if (auditdate == null) {
                        if (isBizFinInt) {
                            auditdate = TimeServiceHelper.now();
                        } else {
                            this.errMap.put(row.getLong("id"), new SynBillErrInfo("5", unAuditMsg));
                            bizBillIds.remove(row.getLong("id"));
                            continue;
                        }
                    }
                    bizBillIdNewBookDateMap.put(row.getLong("id"), row.getDate("bookdate"));
                    Date temp = row.getDate("bookdate");
                    if (null == maxBookDate) {
                        maxBookDate = temp;
                    } else if (temp.compareTo(maxBookDate) > 0) {
                        maxBookDate = temp;
                    }
                    if (null == minBookDate) {
                        minBookDate = temp;
                    } else if (temp.compareTo(minBookDate) < 0) {
                        minBookDate = temp;
                    }
                    updateParams.add(new Object[]{row.get("auditor"), new Timestamp(auditdate.getTime()), this.bizbillentityname, row.get("id")});
                }
            } else {
                for (Row row : billAuditDateDs) {
                    Date auditdate = row.getDate("auditdate");
                    updateParams.add(new Object[]{row.get("auditor"), new Timestamp(auditdate.getTime()), this.bizbillentityname, row.get("id")});
                }
            }
        }
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateInCalBillSql, updateParams);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateOutCalBillSql, updateParams);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateCostRecordSql, updateParams);
        }
        this.resetCostRecordPeriod(bizBillIds, maxBookDate, minBookDate);
        if (!AcctGroupModelHelper.isNewGroupModel()) {
            this.resetBillGroup(bizBillIdNewBookDateMap);
            this.handleGroupUpdateTime(bizBillIds);
        }
    }

    private void resetBillGroup(Map<Long, Date> bizBillIdNewBookDateMap) {
        if (bizBillIdNewBookDateMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> billGroupBookDateParams = new ArrayList<Object[]>(16);
        String updateBillGroupSql = "update t_cal_grouprecordentry set fbookdate = ? where fbizbillid = ?";
        for (Map.Entry<Long, Date> item : bizBillIdNewBookDateMap.entrySet()) {
            billGroupBookDateParams.add(new Object[]{item.getValue(), item.getKey()});
        }
        if (billGroupBookDateParams.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateBillGroupSql, billGroupBookDateParams);
        }
    }

    private void handleGroupUpdateTime(Set<Long> allBizBillId) {
        if (allBizBillId.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update t_cal_groupbillrecord set fupdatetime = ? where fid in ( select fid from t_cal_grouprecordentry where fbizbillid in ");
        sql.append(DBUtil.getInStringFromSet2(allBizBillId));
        sql.append(")");
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql.toString(), (Object[])new Object[]{TimeServiceHelper.now()});
    }

    private DynamicObject[] removeErrorCostRecord(Map<Long, Set<DynamicObject>> costRecordMap) {
        for (Long errorBillId : this.errMap.keySet()) {
            costRecordMap.remove(errorBillId);
        }
        HashSet<DynamicObject> newCostRecordDycs = new HashSet<DynamicObject>(16);
        for (Set<DynamicObject> item : costRecordMap.values()) {
            newCostRecordDycs.addAll(item);
        }
        return newCostRecordDycs.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] removeErrorBizBillDyc(DynamicObject[] bizBills) {
        ArrayList<DynamicObject> newBizDycs = new ArrayList<DynamicObject>(16);
        for (DynamicObject billDyc : bizBills) {
            if (this.errMap.containsKey(billDyc.getLong("id"))) continue;
            newBizDycs.add(billDyc);
        }
        return newBizDycs.toArray(new DynamicObject[0]);
    }

    private void setCostRecordEntryAuditDate(DynamicObject[] costRecordDycs) {
        String updateCostRecordEntrySql = "update t_cal_calcostrecordentry set faudittime = ? where fid = ?";
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (DynamicObject item : costRecordDycs) {
            updateParams.add(new Object[]{item.get("auditdate"), item.get("id")});
        }
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateCostRecordEntrySql, updateParams);
        }
    }

    private DynamicObject[] loadCostRecordDycs(Set<Long> allBizBillId) {
        HashSet<Long> costRecordIds = new HashSet<Long>(16);
        QFilter qf = new QFilter("bizbillid", "in", allBizBillId);
        qf.and(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(qf);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id", (QFilter[])qf.toArray(), null);){
            for (Row row : dataSet) {
                long id = row.getLong("id");
                costRecordIds.add(id);
            }
        }
        String entity = "cal_costrecord";
        if (this.calProcessContext.getCustomerParams("ifromsubmit") == null) {
            entity = "cal_costrecord_subentity";
        }
        return BusinessDataServiceHelper.load((Object[])costRecordIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entity));
    }

    private void resetCostRecordPeriod(Set<Long> bizBillIds, Date maxBookDate, Date minBookDate) {
        ArrayList<Object[]> updateCostRecordParams = new ArrayList<Object[]>(16);
        String updateCostRecordPeriodSql = "update t_cal_calcostrecord set fperiodid = ?,fwriteoffperiodid = ?,fwriteoffdate = ? where fid = ?";
        QFilter costRecordQF = new QFilter("bizbillid", "in", bizBillIds);
        costRecordQF.and(new QFilter("bizentityobject", "=", (Object)this.bizbillentityname));
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecordQF);
        boolean resetBookDate = false;
        try (DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id, costaccount, bookdate, bizdate, costaccount.calpolicy.periodtype as costperiodtype, isinitbill", (QFilter[])costRecordQF.toArray(), null);){
            HashSet<Long> periodTypeIdSet = new HashSet<Long>(16);
            for (Row costRecord : costRecordDs.copy()) {
                if (costRecord.getDate("bizdate").compareTo(costRecord.getDate("bookdate")) == 0) continue;
                resetBookDate = true;
                periodTypeIdSet.add(costRecord.getLong("costperiodtype"));
            }
            if (!resetBookDate) {
                return;
            }
            QFilter periodQF = new QFilter("periodtype", "in", periodTypeIdSet);
            periodQF.and("begindate", "<=", (Object)maxBookDate);
            periodQF.and("enddate", ">=", (Object)minBookDate);
            periodQF.and(new QFilter("isadjustperiod", "=", (Object)false));
            try (DataSet periodDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)"id, periodtype, begindate, enddate", (QFilter[])periodQF.toArray(), null);){
                DataSet dataSet = costRecordDs.join(periodDs).on("costperiodtype", "periodtype").select(new String[]{"id as costrecordid", "bookdate", "isinitbill", "costaccount"}, new String[]{"id as periodid", "begindate", "enddate"}).finish().filter("bookdate >= begindate and bookdate <= enddate");
                for (Row row : dataSet) {
                    if (row.getBoolean("isinitbill").booleanValue()) {
                        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)row.getLong("costaccount"));
                        if (null == currentPeriod) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u8bbe\u7f6e\u5f53\u524d\u671f\u95f4\uff0c\u53ef\u80fd\u8fd8\u672a\u542f\u7528\u3002", (String)"CostRecordBuilder_5", (String)"fi-cal-business", (Object[])new Object[0]));
                        }
                        Date enddate = currentPeriod.getDate("enddate");
                        Date bookdate = row.getDate("bookdate");
                        if (bookdate.compareTo(enddate) <= 0) {
                            long currentPeriodId = currentPeriod.getLong("id");
                            Timestamp begindate = new Timestamp(currentPeriod.getDate("begindate").getTime());
                            updateCostRecordParams.add(new Object[]{currentPeriodId, currentPeriodId, begindate, row.get("costrecordid")});
                            continue;
                        }
                        updateCostRecordParams.add(new Object[]{row.get("periodid"), row.get("periodid"), row.get("bookdate"), row.get("costrecordid")});
                        continue;
                    }
                    updateCostRecordParams.add(new Object[]{row.get("periodid"), row.get("periodid"), row.get("bookdate"), row.get("costrecordid")});
                }
            }
        }
        if (updateCostRecordParams.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateCostRecordPeriodSql, updateCostRecordParams);
        }
    }

    public static Date getStandardCostDate(Date auditdate, Date bookdate) {
        if (null == auditdate || null == bookdate) {
            return auditdate;
        }
        if (DateUtils.isTheSameDay((Date)auditdate, (Date)bookdate)) {
            bookdate = DateUtils.getDayStartTime((Date)bookdate);
            int hour = DateUtils.getIntByDate((Date)auditdate, (int)11);
            int minute = DateUtils.getIntByDate((Date)auditdate, (int)12);
            int second = DateUtils.getIntByDate((Date)auditdate, (int)13);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(bookdate);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            bookdate = calendar.getTime();
        } else {
            bookdate = DateUtils.getDayEndTime((Date)bookdate);
        }
        return bookdate;
    }

    private void updateAfterCostPriceSource(DynamicObject[] infos, String type) {
        HashSet<Long> zeroInOutBizTypeIds = new HashSet<Long>();
        DynamicObject settingObj = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection bizTypes = settingObj.getDynamicObjectCollection("zeroinoutbiztype");
        for (DynamicObject bizType : bizTypes) {
            zeroInOutBizTypeIds.add(bizType.getDynamicObject("fbasedataid").getLong("id"));
        }
        for (DynamicObject costRecord : infos) {
            DynamicObject bizentityobject = costRecord.getDynamicObject("bizentityobject");
            DynamicObjectCollection entrys = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                boolean ispresent;
                String costpricesource;
                boolean isUpdateFromExpCalcute;
                String accountType = entry.getString("accounttype");
                DynamicObject invscheme = costRecord.getDynamicObject("invscheme");
                boolean zerocost = invscheme.getBoolean("zerocost");
                if (zerocost && (AccountTypeEnum.ADD_AVERAGE.getValue().equals(accountType) || AccountTypeEnum.FIN_FOUT_PERIOD.getValue().equals(accountType))) {
                    entry.set("iscalculated", (Object)true);
                }
                if (isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)type, (String)(costpricesource = entry.getString("costpricesource")))) continue;
                BigDecimal unitactualcost = entry.getBigDecimal("unitactualcost");
                if (unitactualcost != null && unitactualcost.compareTo(BigDecimal.ZERO) != 0) {
                    if (AccountTypeEnum.ADD_AVERAGE.getValue().equals(accountType) || AccountTypeEnum.SPECIAL_ACCT.getValue().equals(accountType) || AccountTypeEnum.FIN_FOUT_PERIOD.getValue().equals(accountType) || AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                        if (!StringUtils.isEmpty((String)costpricesource)) continue;
                        entry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                        entry.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
                        continue;
                    }
                    entry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                    entry.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
                    continue;
                }
                String bizEntityObject = bizentityobject.getString("id");
                if (("im_purinbill".equals(bizEntityObject) || "im_mdc_omcmplinbill".equals(bizEntityObject) || "im_mdc_ominbill".equals(bizEntityObject) || "im_ospurinbill".equals(bizEntityObject) || "im_otherinbill".equals(bizEntityObject)) && (ispresent = entry.getBoolean("ispresent"))) {
                    entry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                    entry.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
                }
                if (zerocost) {
                    entry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                    entry.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
                }
                DynamicObject biztypeDy = costRecord.getDynamicObject("biztype");
                long biztype = 0L;
                if (biztypeDy != null) {
                    biztype = biztypeDy.getLong("id");
                }
                if (zeroInOutBizTypeIds == null || !zeroInOutBizTypeIds.contains(biztype)) continue;
                if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                    if (!"im_purinbill".equals(bizEntityObject) && !"im_ospurinbill".equals(bizEntityObject)) continue;
                    entry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                    entry.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
                    continue;
                }
                if (!AccountTypeEnum.MOVE_ADD_AVERAGE.getValue().equals(accountType) && !AccountTypeEnum.FIN_FOUT.getValue().equals(accountType)) continue;
                entry.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
                entry.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
            }
        }
        if (infos.length > 0) {
            SaveServiceHelper.save((DynamicObject[])infos);
        }
    }

    private Long getBaseId(DynamicObject info, String baseIdKey) {
        Long baseId = info.getLong(baseIdKey + "_id");
        Object baseIdObj = info.get(baseIdKey);
        if (baseIdObj instanceof Long && !baseIdObj.equals(0L)) {
            baseId = (Long)baseIdObj;
        }
        return baseId;
    }
}

