/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.billgroup.BillGroupRelationHelper;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordHelper;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.PeriodChecker;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.StopSyncBizBillHelper;
import kd.fi.cal.common.helper.WhiteListHelper;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.CommonUtils;

public class SyncBizBill4UnAuditServiceProcess
extends AbstractBizProcessor {
    @Override
    public void doProcessor(Map params, DynamicObject bizBill) {
        if (bizBill == null) {
            return;
        }
        Set bufferPoolBizBills = (Set)this.calProcessContext.getCustomerParams("bufferPoolBizBills");
        if (bufferPoolBizBills != null && !bufferPoolBizBills.isEmpty()) {
            return;
        }
        this.deleteCalBills(bizBill);
    }

    public void deleteCalBills(DynamicObject bizBill) {
        if ("im_initbill".equals(bizBill.getDataEntityType().getName())) {
            this.removeInitcalBills(bizBill);
        } else {
            this.removeAllRecord(bizBill);
        }
    }

    private void removeInitcalBills(DynamicObject bizBill) {
        SynBillErrInfo errInfo;
        StopSyncBizBillHelper stopSyncBizBillHelper = new StopSyncBizBillHelper();
        long bizBillId = bizBill.getLong("id");
        QFilter bizBillIdF = new QFilter("bizbillid", "=", (Object)bizBillId);
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(bizBillIdF);
        DynamicObject[] bizBillDyn = BusinessDataServiceHelper.load((String)"cal_initbill", (String)"calorg, bizbillid, bizdate, storageorgunit, accounttype, warehouse, material,bookdate", (QFilter[])new QFilter[]{bizBillIdF});
        Map stopSyncBizBillMap = stopSyncBizBillHelper.getStopSynMap4InitCal(bizBillDyn, false);
        if (stopSyncBizBillMap != null && (errInfo = (SynBillErrInfo)stopSyncBizBillMap.get(bizBillId)) != null && StringUtils.isNotEmpty((String)errInfo.getErrorMsg())) {
            throw new KDBizException(new ErrorCode("4", errInfo.getErrorMsg()), new Object[0]);
        }
        QFilter qs = new QFilter("bizbillid", "=", bizBill.getPkValue());
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(qs);
        DeleteServiceHelper.delete((String)"cal_initbill", (QFilter[])qs.toArray());
    }

    private void removeAllRecord(DynamicObject bizBill) {
        Set bizTypeIdSet = CommonSettingHelper.getNotUpdBalBizType();
        QFilter bizBillIdf = new QFilter("bizbillid", "=", bizBill.getPkValue());
        QFilter costRecBizBillF = bizBillIdf.copy();
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(costRecBizBillF);
        HashSet<Long> recordIds = new HashSet<Long>(8);
        HashSet<Long> entryIds = new HashSet<Long>(256);
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        HashSet<Object> calBillIds = new HashSet<Object>(16);
        String bizObject = null;
        boolean isinitbill = false;
        boolean isUpdBal = true;
        boolean isChargeBill = false;
        HashSet<Long> ids = new HashSet<Long>(16);
        HashMap<Long, Integer> costRecordIdPeriodMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Long> costRecordIdAcctIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> costRecordIdBizBillIdMap = new HashMap<Long, Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,billno,calbillid,isinitbill,ischargeoff,entry.id,entry.srcbillid,biztype,bizentityobject,period.periodyear,period.periodnumber,costaccount,bizbillid", (QFilter[])costRecBizBillF.toArray(), null);){
            for (Object row : dataSet) {
                ids.add(row.getLong("id"));
                if (row.getBoolean("isinitbill").booleanValue()) {
                    isinitbill = true;
                }
                if (row.getBoolean("ischargeoff").booleanValue()) {
                    isChargeBill = true;
                }
                if (bizTypeIdSet.contains(row.getLong("biztype"))) {
                    isUpdBal = false;
                }
                recordIds.add(row.getLong("id"));
                entryIds.add(row.getLong("entry.id"));
                srcBillIds.add(row.getLong("entry.srcbillid"));
                calBillIds.add(row.getLong("calbillid"));
                if (bizObject == null) {
                    bizObject = row.getString("bizentityobject");
                }
                costRecordIdPeriodMap.put(row.getLong("id"), row.getInteger("period.periodyear") * 100 + row.getInteger("period.periodnumber"));
                costRecordIdAcctIdMap.put(row.getLong("id"), row.getLong("costaccount"));
                costRecordIdBizBillIdMap.put(row.getLong("id"), row.getLong("bizbillid"));
            }
        }
        PeriodChecker periodChecker = new PeriodChecker();
        String beforePeriodMsg = ResManager.loadKDString((String)"\u5f80\u671f\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PeriodChecker_1", (String)"fi-cal-business", (Object[])new Object[0]);
        periodChecker.setBeforePeriodMsg(beforePeriodMsg);
        periodChecker.check(costRecordIdPeriodMap, costRecordIdAcctIdMap, costRecordIdBizBillIdMap);
        Map<Long, SynBillErrInfo> errMap = periodChecker.getErrMap();
        if (errMap != null && errMap.size() > 0) {
            for (Map.Entry entry : errMap.entrySet()) {
                this.addErrorMsg((Long)entry.getKey(), (SynBillErrInfo)entry.getValue());
            }
            return;
        }
        this.dealGroupedOrAmtDiffAdjustBill(recordIds);
        this.dealDiffAdjustBill(recordIds);
        if (this.calProcessContext.getCustomerParams("nocalbill") == null && !recordIds.isEmpty() && !isinitbill && isUpdBal) {
            boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
            if (isNewBalance) {
                new BalanceOpInvoker().invokeCostRecordUpdateBalReverseOp(recordIds, BalanceSourceEnum.COSTRECORD_DELETE);
            } else if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.DAILY_BAL).booleanValue()) {
                String string = CacheKeyUtil.getAcctId();
                String lockKey = "fi-cal-billsynclock_updatebal" + string;
                DLock dlock = DLock.createReentrant((String)lockKey, (String)"fi-cal-billsynclock_updatebal");
                if (!this.calProcessContext.getLockMap().containsKey(lockKey)) {
                    this.addLock(lockKey, dlock);
                    dlock.lock();
                }
                new BalanceCalculator().updateBalance4CostRecordDel(entryIds, ids);
            }
        }
        try {
            BillGroupRelationHelper billGroupRelationHelper = new BillGroupRelationHelper();
            billGroupRelationHelper.setDelete(true);
            billGroupRelationHelper.setFilterGroupAcct(true);
            billGroupRelationHelper.getAndRemoveRelations(calBillIds, true);
            if (AcctGroupModelHelper.isBizGroupModel()) {
                BizGroupRecordHelper bizGroupRecordHelper = new BizGroupRecordHelper();
                bizGroupRecordHelper.setFilterGroupAcct(true);
                HashSet<Long> bizbillids = new HashSet<Long>(4);
                bizbillids.add(bizBill.getLong("id"));
                bizGroupRecordHelper.deleteBizGroupRecordUpdateCostDomin(Collections.singletonMap(bizObject, bizbillids), false);
            }
        }
        catch (KDBizException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode != null && "refresActGroupRunning".equals(errorCode.getCode())) {
                this.calProcessContext.addRetryBillDyc(bizBill);
            }
            throw e;
        }
        if (isChargeBill) {
            this.setChargeOffInfo(srcBillIds, bizObject);
        }
        DeleteServiceHelper.delete((String)"cal_costrecord_subentity", (QFilter[])new QFilter("id", "in", recordIds).toArray());
        this.deleteIepBusinesstask(recordIds);
        if (AcctGroupModelHelper.isBizGroupModel()) {
            DeleteServiceHelper.delete((String)"cal_calbill_pk", (QFilter[])bizBillIdf.toArray());
        } else {
            DeleteServiceHelper.delete((String)"cal_incalbill", (QFilter[])bizBillIdf.toArray());
            DeleteServiceHelper.delete((String)"cal_outcalbill", (QFilter[])bizBillIdf.toArray());
        }
    }

    private void deleteIepBusinesstask(Set<Long> recordIds) {
        WhiteListHelper.deleteWhiteList((String)"cal_costrecord_subentity", new ArrayList<Long>(recordIds));
    }

    protected void dealGroupedOrAmtDiffAdjustBill(Set<Long> recordIds) {
        QFilter adjustFilter = new QFilter("entryentity.invbillid", "in", recordIds);
        QFilter typeFilter = new QFilter("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.CAL_OUT_GROUP.getValue());
        adjustFilter.and(typeFilter);
        DynamicObject[] costAdjustCol = BusinessDataServiceHelper.load((String)"cal_costadjust_subentity", (String)"id,billno,isvoucher,createtype,difftype", (QFilter[])adjustFilter.toArray());
        Set<Long> adjustBillIds = new HashSet<Long>(8);
        for (DynamicObject adjustBill : costAdjustCol) {
            adjustBillIds.add(adjustBill.getLong("id"));
            if (!adjustBill.getBoolean("isvoucher")) continue;
            String typeName = CostAdjustBilCreateTypeEnum.CAL_OUT_GROUP.getDesc();
            String createtype = adjustBill.getString("difftype");
            if (CostAdjustBillDiffTypeEnum.ORDER_DIFF.getValue().equals(createtype)) {
                typeName = CostAdjustBillDiffTypeEnum.ORDER_DIFF.getDesc();
            } else if (CostAdjustBillDiffTypeEnum.FEE_DIFF.getValue().equals(createtype)) {
                typeName = CostAdjustBillDiffTypeEnum.FEE_DIFF.getDesc();
            } else if (CostAdjustBillDiffTypeEnum.OTHER_DIFF.getValue().equals(createtype)) {
                typeName = CostAdjustBillDiffTypeEnum.OTHER_DIFF.getDesc();
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u201c%1$s\u201d\u7684\u6210\u672c\u8c03\u6574\u5355\u201c%2$s\u201d,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SyncBizBill4UnAuditServiceProcess_10", (String)"fi-cal-business", (Object[])new Object[0]), typeName, adjustBill.getString("billno"));
            throw new KDBizException(msg);
        }
        if (!(adjustBillIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill("cal_costadjust_subentity", adjustBillIds)).isEmpty()) {
            Object msgString;
            OperateOption option = OperateOption.create();
            option.setVariableValue("unwriteoff", "1");
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignoreValidation", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_costadjust_subentity", (Object[])adjustBillIds.toArray(new Object[adjustBillIds.size()]), (OperateOption)option);
            if (!result.isSuccess()) {
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(result.getMessage());
                for (IOperateInfo error : result.getAllErrorOrValidateInfo()) {
                    OperateInfo operror = (OperateInfo)error;
                    errorMsg.append(operror.getMessage());
                }
                msgString = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u672c\u8c03\u6574\u5355\u5931\u8d25\uff1a%1$s", (String)"SyncBizBill4UnAuditServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0]), errorMsg.toString());
                throw new KDBizException((String)msgString);
            }
            if ((adjustBillIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill("cal_costadjust_subentity", adjustBillIds)).isEmpty()) {
                return;
            }
            OperationServiceHelper.executeOperate((String)"delete", (String)"cal_costadjust_subentity", (Object[])adjustBillIds.toArray(new Object[adjustBillIds.size()]), (OperateOption)option);
            if (!result.isSuccess()) {
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(result.getMessage());
                for (IOperateInfo error : result.getAllErrorOrValidateInfo()) {
                    OperateInfo operror = (OperateInfo)error;
                    errorMsg.append(operror.getMessage());
                }
                msgString = String.format(ResManager.loadKDString((String)"\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u5931\u8d25\uff1a%1$s", (String)"SyncBizBill4UnAuditServiceProcess_6", (String)"fi-cal-business", (Object[])new Object[0]), errorMsg.toString());
                throw new KDBizException((String)msgString);
            }
        }
    }

    protected void dealDiffAdjustBill(Set<Long> recordIds) {
        QFilter adjustFilter = new QFilter("entryentity.invbillid", "in", recordIds);
        QFilter typeFilter = new QFilter("createtype", "<>", (Object)CostAdjustBilCreateTypeEnum.DIFF_SHARE.getValue());
        adjustFilter.and(typeFilter);
        DynamicObject[] costAdjustCol = BusinessDataServiceHelper.load((String)"cal_stdcostdiffbill", (String)"id,billno,isvoucher", (QFilter[])adjustFilter.toArray());
        Set<Long> adjustBillIds = new HashSet<Long>(8);
        for (DynamicObject adjustBill : costAdjustCol) {
            adjustBillIds.add(adjustBill.getLong("id"));
            if (!adjustBill.getBoolean("isvoucher")) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u201c%1$s\u201d\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SyncBizBill4UnAuditServiceProcess_12", (String)"fi-cal-business", (Object[])new Object[0]), adjustBill.getString("billno"));
            throw new KDBizException(msg);
        }
        if (!(adjustBillIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill("cal_stdcostdiffbill", adjustBillIds)).isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("unwriteoff", "1");
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("billSyncUnAudit", "true");
            option.setVariableValue("ignoreValidation", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])adjustBillIds.toArray(new Object[adjustBillIds.size()]), (OperateOption)option);
            if (!result.isSuccess()) {
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(result.getMessage());
                for (IOperateInfo error : result.getAllErrorOrValidateInfo()) {
                    OperateInfo operror = (OperateInfo)error;
                    errorMsg.append(operror.getMessage());
                }
                String msgString = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u672c\u8c03\u6574\u5355\u5931\u8d25\uff1a%1$s", (String)"SyncBizBill4UnAuditServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0]), errorMsg.toString());
                throw new KDBizException(msgString);
            }
            if ((adjustBillIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill("cal_stdcostdiffbill", adjustBillIds)).isEmpty()) {
                return;
            }
            OperationResult result1 = OperationServiceHelper.executeOperate((String)"delete", (String)"cal_stdcostdiffbill", (Object[])adjustBillIds.toArray(new Object[adjustBillIds.size()]), (OperateOption)option);
            if (!result1.isSuccess()) {
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(result.getMessage());
                for (IOperateInfo error : result.getAllErrorOrValidateInfo()) {
                    OperateInfo operror = (OperateInfo)error;
                    errorMsg.append(operror.getMessage());
                }
                String msgString = String.format(ResManager.loadKDString((String)"\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u5931\u8d25\uff1a%1$s", (String)"SyncBizBill4UnAuditServiceProcess_6", (String)"fi-cal-business", (Object[])new Object[0]), errorMsg.toString());
                throw new KDBizException(msgString);
            }
        }
    }

    private void setChargeOffInfo(Set<Long> srcBillIdSet, String bizObject) {
        Long srcBillId = srcBillIdSet.iterator().next();
        String updateInCalBillSql = "update t_cal_incalbill set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ?";
        String updateOutCalBillSql = "update t_cal_outcalbill set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ?";
        String updateCostRecordSql = "update t_cal_calcostrecord set fischargeoffed = ? where fbizentityobjectid = ? and fbizbillid = ?";
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        updateParams.add(new Object[]{"0", bizObject, srcBillId});
        if (updateParams.size() > 0) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateInCalBillSql, updateParams);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateOutCalBillSql, updateParams);
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateCostRecordSql, updateParams);
        }
    }
}

