/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.adjbill.AdjBillDeleteHelper;
import kd.fi.cal.business.adjbill.OrderDiffAdjBillCreateHelper;
import kd.fi.cal.business.balance.BalanceCalculator;
import kd.fi.cal.business.balance.BalanceOpInvoker;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.business.calculate.billgroup.BillGroupWfRelationHelper;
import kd.fi.cal.business.calculate.billgroup.WFGroupCostCalculator;
import kd.fi.cal.business.calculate.out.CalMoveInvoker;
import kd.fi.cal.business.calculate.out.IntimeBufferPoolHandle;
import kd.fi.cal.business.process.AbstractBizProcessor;
import kd.fi.cal.business.process.inner.CostRecordAuditInvoker;
import kd.fi.cal.business.process.inner.SyncOpLegalChecker;
import kd.fi.cal.business.process.inner.WfDiffHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalBillRuleCheckHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SyncSimpleDycHelper;
import kd.fi.cal.common.model.SynBillErrInfo;

public class WriteOffRecordSyncProcess
extends AbstractBizProcessor {
    private Boolean isNewGroupModel = AcctGroupModelHelper.isNewGroupModel();
    private String calEntryIdKey = this.isNewGroupModel != false ? "calentryid" : "billentryid";
    private static final Log logger = LogFactory.getLog(WriteOffRecordSyncProcess.class);
    private Set<String> omInBills = new HashSet<String>(16);

    @Override
    public void doProcessor(Map params, DynamicObject[] bizBills) {
        BillGroupWfRelationHelper helper = new BillGroupWfRelationHelper();
        WFGroupCostCalculator calculator = new WFGroupCostCalculator();
        ArrayList<DynamicObject> allCostRecordDycs = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> newBizBillDycs = new ArrayList<DynamicObject>(16);
        boolean isAllBillAudit = true;
        String errorMsg = "";
        this.omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        int retryTimes = 5;
        for (int i = 0; i < retryTimes; ++i) {
            allCostRecordDycs.clear();
            newBizBillDycs.clear();
            isAllBillAudit = true;
            errorMsg = "";
            for (DynamicObject bizBill : bizBills) {
                DynamicObject[] currentCostRecordDycs;
                HashMap<String, Set<Long>> entityBillIdsMap = new HashMap<String, Set<Long>>(16);
                HashSet<Long> billIdSet = new HashSet<Long>(bizBills.length);
                HashSet<Long> billEntryIdSet = new HashSet<Long>(bizBills.length);
                DynamicObjectCollection recordEntrys = bizBill.getDynamicObjectCollection("entry");
                for (DynamicObject recordEntry : recordEntrys) {
                    billIdSet.add(recordEntry.getLong("billid"));
                    billEntryIdSet.add(recordEntry.getLong("billentryid"));
                    Set entityBillIds = entityBillIdsMap.computeIfAbsent(recordEntry.getString("billtype_id"), k -> new HashSet(16));
                    entityBillIds.add(recordEntry.getLong("billid"));
                }
                QFilter billFilter = new QFilter("bizbillid", "in", billIdSet);
                HashSet existBizBillIds = new HashSet();
                DynamicObject[] dynamicObjectArray = null;
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"bizbillid", (QFilter[])billFilter.toArray(), null);){
                    for (Row row : ds) {
                        existBizBillIds.add(row.getLong("bizbillid"));
                    }
                }
                catch (Throwable object) {
                    dynamicObjectArray = object;
                    throw object;
                }
                this.removeNotSyncBillIds(entityBillIdsMap, billIdSet);
                this.opLegalCheck(entityBillIdsMap);
                if (billIdSet.size() > existBizBillIds.size()) {
                    errorMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"WriteOffRecordSyncProcess_0", (String)"fi-cal-business", (Object[])new Object[0]);
                    isAllBillAudit = false;
                    break;
                }
                for (DynamicObject costRecordDyc : currentCostRecordDycs = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,costaccount,billstatus,bizbillid", (QFilter[])new QFilter("bizbillid", "in", billIdSet).toArray())) {
                    if ("C".equals(costRecordDyc.getString("billstatus"))) continue;
                    errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"WriteOffRecordSyncProcess_1", (String)"fi-cal-business", (Object[])new Object[0]);
                    isAllBillAudit = false;
                    break;
                }
                allCostRecordDycs.addAll(Arrays.asList(currentCostRecordDycs));
                newBizBillDycs.add(bizBill);
            }
            if (isAllBillAudit) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.info("WriteOffRecordSyncProcess doProcessor : ", (Object)e);
            }
        }
        if (!isAllBillAudit) {
            this.addQueue(bizBills);
            throw new KDBizException(errorMsg);
        }
        DynamicObject[] costRecordCol = allCostRecordDycs.toArray(new DynamicObject[0]);
        bizBills = newBizBillDycs.toArray(new DynamicObject[0]);
        HashMap<Long, Long> costAccountPeriodMap = new HashMap<Long, Long>();
        HashSet<Long> costRecordIdSet = new HashSet<Long>(costRecordCol.length);
        for (DynamicObject costRecord : costRecordCol) {
            costRecordIdSet.add(costRecord.getLong("id"));
            costAccountPeriodMap.computeIfAbsent(costRecord.getLong("costaccount_id"), k -> PeriodHelper.getCurrentPeriod((Long)k).getLong("id"));
        }
        HashMap<Long, DynamicObject> groupRecordMap = new HashMap<Long, DynamicObject>(16);
        HashMap<String, BigDecimal> totalAddedGroupCost = new HashMap<String, BigDecimal>(16);
        for (DynamicObject bizBill : bizBills) {
            DynamicObject groupRecord = helper.createRelations(bizBill);
            if (groupRecord == null) continue;
            groupRecordMap.put(groupRecord.getLong("id"), groupRecord);
            for (DynamicObject[] costAccountId : costAccountPeriodMap.keySet()) {
                Map<String, BigDecimal> addedCost = calculator.calculateCost(groupRecord, bizBill.getLong("id"), (Long)costAccountId);
                for (Map.Entry<String, BigDecimal> addedCostEntry : addedCost.entrySet()) {
                    String key = addedCostEntry.getKey();
                    BigDecimal totalAddCost = (BigDecimal)totalAddedGroupCost.get(key);
                    totalAddCost = totalAddCost == null ? addedCostEntry.getValue() : totalAddCost.add(addedCostEntry.getValue());
                    totalAddedGroupCost.put(key, totalAddCost);
                }
            }
        }
        costRecordCol = BusinessDataServiceHelper.load((Object[])costRecordIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity"));
        HashMap<String, DynamicObject> calculatedCostRecordEntry = new HashMap<String, DynamicObject>();
        HashMap<Long, DynamicObject> notCalculatedCostRecordEntry = new HashMap<Long, DynamicObject>();
        HashSet<Long> allTgtBillCostRecordIds = new HashSet<Long>(16);
        HashSet<Long> allTgtBillCostRecordEntryIds = new HashSet<Long>(16);
        costRecordIdSet.clear();
        HashSet<Long> costAcctIds = new HashSet<Long>(16);
        Set<Long> curWfRecInEIds = this.getInEIdOutEIdsMap(bizBills);
        for (DynamicObject costRecord : costRecordCol) {
            for (DynamicObject costRecordEntry : costRecord.getDynamicObjectCollection("entry")) {
                long costAccountId;
                boolean isHasBillGroup = false;
                for (DynamicObject groupRecord : groupRecordMap.values()) {
                    for (DynamicObject groupRecordEntry : groupRecord.getDynamicObjectCollection("entryentity")) {
                        if (groupRecordEntry.getLong(this.calEntryIdKey) != costRecordEntry.getLong("calentryid") || !"1".equals(groupRecordEntry.getString("type"))) continue;
                        isHasBillGroup = true;
                        if (this.isCalculated(costAccountPeriodMap, costRecord, costRecordEntry)) {
                            calculatedCostRecordEntry.put(costRecord.getDynamicObject("costaccount").getLong("id") + "|" + costRecordEntry.getLong("calentryid"), costRecordEntry);
                        } else {
                            costRecordIdSet.add(costRecord.getLong("id"));
                            notCalculatedCostRecordEntry.put(costRecordEntry.getLong("id"), costRecordEntry);
                            costAccountId = costRecord.getDynamicObject("costaccount").getLong("id");
                            costAcctIds.add(costAccountId);
                        }
                        allTgtBillCostRecordIds.add(costRecord.getLong("id"));
                        allTgtBillCostRecordEntryIds.add(costRecordEntry.getLong("id"));
                    }
                }
                String bizEntity = costRecord.getString("bizentityobject.number");
                long bizBillEId = costRecordEntry.getLong("bizbillentryid");
                boolean isOutEIdNotSynCal = curWfRecInEIds.contains(bizBillEId);
                if (isHasBillGroup || !isOutEIdNotSynCal || !this.omInBills.contains(bizEntity)) continue;
                if (this.isCalculated(costAccountPeriodMap, costRecord, costRecordEntry)) {
                    calculatedCostRecordEntry.put(costRecord.getDynamicObject("costaccount").getLong("id") + "|" + costRecordEntry.getLong("calentryid"), costRecordEntry);
                } else {
                    costRecordIdSet.add(costRecord.getLong("id"));
                    notCalculatedCostRecordEntry.put(costRecordEntry.getLong("id"), costRecordEntry);
                    costAccountId = costRecord.getDynamicObject("costaccount").getLong("id");
                    costAcctIds.add(costAccountId);
                }
                allTgtBillCostRecordIds.add(costRecord.getLong("id"));
                allTgtBillCostRecordEntryIds.add(costRecordEntry.getLong("id"));
            }
        }
        this.dealAmtDiffAdjustBill(allTgtBillCostRecordIds, allTgtBillCostRecordEntryIds);
        this.dealCalculated(calculatedCostRecordEntry, totalAddedGroupCost);
        this.dealCalculatedStdDiff(calculatedCostRecordEntry, totalAddedGroupCost);
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.ENTRY_SPLIT_INTIME_CAL).booleanValue() && !notCalculatedCostRecordEntry.isEmpty()) {
            DynamicObjectCollection coll = this.getBufferPoolColl(costRecordIdSet, notCalculatedCostRecordEntry.keySet());
            IntimeBufferPoolHandle handle = new IntimeBufferPoolHandle(coll, "cal_costrecord_subentity", ActionEnum.MATERIALWRITEOFF.getValue(), false);
            handle.insertIntoPool();
        } else {
            this.dealNotCalculated(notCalculatedCostRecordEntry, costRecordIdSet, totalAddedGroupCost, costAcctIds);
            costRecordCol = BusinessDataServiceHelper.load((Object[])allTgtBillCostRecordIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity"));
            OrderDiffAdjBillCreateHelper adjBillHelper = new OrderDiffAdjBillCreateHelper(false, costRecordCol);
            adjBillHelper.createCostAdjustBill(null, null);
            if (!allTgtBillCostRecordIds.isEmpty()) {
                boolean isNewBalance = CalBalanceModelHelper.isNewBalance();
                if (isNewBalance) {
                    this.updateNewBalance(allTgtBillCostRecordIds);
                } else {
                    this.updateBalance(allTgtBillCostRecordEntryIds, allTgtBillCostRecordIds);
                }
            }
            new CostRecordAuditInvoker().invoke(allTgtBillCostRecordIds);
        }
    }

    private boolean isCalculated(Map<Long, Long> costAccountPeriodMap, DynamicObject costRecord, DynamicObject costRecordEntry) {
        return costRecordEntry.getBoolean("iscalculated") || costRecord.getBoolean("isvoucher") || costRecord.getBoolean("issplit") || costRecord.getLong("period_id") < costAccountPeriodMap.get(costRecord.getLong("costaccount_id"));
    }

    private void dealAmtDiffAdjustBill(Set<Long> allTgtBillCostRecordIds, Set<Long> allTgtBillCostRecordEntryIds) {
        QFilter q = new QFilter("entryentity.invbillid", "in", allTgtBillCostRecordIds);
        q.and("entryentity.invbillentryid", "in", allTgtBillCostRecordEntryIds);
        q.and("createtype", "in", (Object)new String[]{CostAdjustBilCreateTypeEnum.CAL_OUT_GROUP.getValue(), CostAdjustBilCreateTypeEnum.BILL_SYNC.getValue()});
        q.and("billsrctype", "<>", (Object)"D");
        new AdjBillDeleteHelper().delete(q);
    }

    private void opLegalCheck(Map<String, Set<Long>> entityBillIdsMap) {
        for (Map.Entry<String, Set<Long>> entityBillIdsEntry : entityBillIdsMap.entrySet()) {
            if (!this.omInBills.contains(entityBillIdsEntry.getKey())) continue;
            DynamicObject[] omInBillDycs = new SyncSimpleDycHelper().getSimpleBillDycs(entityBillIdsEntry.getKey(), (Collection)entityBillIdsEntry.getValue());
            SyncOpLegalChecker opCheck = new SyncOpLegalChecker(omInBillDycs, ActionEnum.MATERIALWRITEOFF.getValue());
            opCheck.doCheck();
            Map<Long, SynBillErrInfo> billErrInfoMap = opCheck.getErrMap();
            if (billErrInfoMap.size() <= 0) continue;
            throw new KDBizException(billErrInfoMap.values().iterator().next().getErrorMsg());
        }
    }

    private DynamicObjectCollection getBufferPoolColl(Set<Long> costRecordIdSet, Set<Long> notCalculatedEntryIds) {
        QFilter qs = new QFilter("id", "in", costRecordIdSet);
        qs.and(new QFilter("entry.id", "in", notCalculatedEntryIds));
        qs.and("isinitbill", "=", (Object)Boolean.FALSE);
        qs.and("issplitcreate", "=", (Object)Boolean.FALSE);
        qs.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.MOVE_ADD_AVERAGE.getValue(), AccountTypeEnum.FIN_FOUT.getValue(), AccountTypeEnum.STANDARDCOST.getValue()});
        qs.and("invscheme.isforwardamount", "=", (Object)Boolean.TRUE);
        qs.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
        qs.and("biztype", "not in", (Object)CommonSettingHelper.getNotUpdBalBizType());
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"id,bizbillid,calbilltype,auditdate,costaccount,entry.material as material,entry.accounttype as accounttype,entry.id as entryid,entry.bizbillentryid as bizbillentryid,bookdate,entry.queuetype as queuetype", (QFilter[])new QFilter[]{qs});
        return coll;
    }

    private void removeNotSyncBillIds(Map<String, Set<Long>> entityBillIdsMap, Set<Long> billIdSet) {
        for (Map.Entry<String, Set<Long>> entityBillIdsEntry : entityBillIdsMap.entrySet()) {
            CalBillRuleCheckHelper calBillRuleCheckHelper = new CalBillRuleCheckHelper(entityBillIdsEntry.getKey(), entityBillIdsEntry.getValue());
            calBillRuleCheckHelper.addSkipProperty("billstatus");
            Set failBillIds = calBillRuleCheckHelper.check();
            billIdSet.removeAll(failBillIds);
        }
    }

    private void dealCalculated(Map<String, DynamicObject> calculatedCostRecordEntry, Map<String, BigDecimal> totalGroupCost) {
        HashMap<String, DynamicObject> costAdjustHeadMap = new HashMap<String, DynamicObject>(16);
        HashMap<Long, DynamicObject> costAdjustEntryMap = new HashMap<Long, DynamicObject>();
        for (Map.Entry<String, BigDecimal> groupCostEntry : totalGroupCost.entrySet()) {
            DynamicObject costRecordEntry;
            BigDecimal adjustCost;
            String[] keys = groupCostEntry.getKey().split("\\|");
            DynamicObject[] groupKey = keys[2];
            BigDecimal groupCost = groupCostEntry.getValue();
            long elementId = 0L;
            boolean isCalByElement = false;
            try {
                elementId = Long.parseLong((String)groupKey);
                isCalByElement = true;
            }
            catch (NumberFormatException e) {
                isCalByElement = false;
            }
            if ((adjustCost = groupCost).compareTo(BigDecimal.ZERO) == 0 || (costRecordEntry = calculatedCostRecordEntry.get(keys[0] + "|" + keys[1])) == null) continue;
            DynamicObject costRecord = (DynamicObject)costRecordEntry.getParent();
            Long costRecordId = costRecord.getLong("id");
            String accountType = costRecordEntry.getString("accounttype");
            if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
            String adjKey = costRecordId + accountType;
            DynamicObject costAdjustHead = costAdjustHeadMap.computeIfAbsent(adjKey, k -> this.createCostAdjust(costRecord, accountType));
            DynamicObject costAdjustEntry = costAdjustEntryMap.computeIfAbsent(costRecordEntry.getLong("id"), k -> this.createCostAdjustEntry(costAdjustHead, costRecord, costRecordEntry));
            DynamicObject subEntry = null;
            Long materialId = costRecordEntry.getLong("material_id");
            Long currency = costRecord.getLong("localcurrency_id");
            DynamicObjectCollection subEntryCol = costAdjustEntry.getDynamicObjectCollection("subentryentity");
            if (isCalByElement) {
                subEntry = subEntryCol.addNew();
                boolean hasEntry = false;
                for (DynamicObject subCostRecordEntry : costRecordEntry.getDynamicObjectCollection("subentrycostelement")) {
                    if (subCostRecordEntry.getLong("costsubelement_id") != elementId) continue;
                    hasEntry = true;
                    adjustCost = groupCost.subtract(subCostRecordEntry.getBigDecimal("sub_actualcost"));
                    subEntry.set("costelement", (Object)subCostRecordEntry.getLong("costelement_id"));
                    break;
                }
                subEntry.set("costsubelement", (Object)elementId);
                if (!hasEntry) {
                    subEntry.set("costelement", (Object)CostElementHelper.getCostElementBySub((Long)elementId));
                }
                subEntry.set("sub_adjustamt", (Object)adjustCost);
                subEntry.set("sub_material", (Object)materialId);
                subEntry.set("sub_currency", (Object)currency);
            } else {
                adjustCost = groupCost.subtract(costRecordEntry.getBigDecimal((String)groupKey));
                if (subEntryCol.isEmpty()) {
                    subEntry = subEntryCol.addNew();
                    subEntry.set("sub_material", (Object)materialId);
                    subEntry.set("sub_currency", (Object)currency);
                    Long[] elementIds = CostElementHelper.getDefaultMaterialElements();
                    subEntry.set("costsubelement", (Object)elementIds[0]);
                    subEntry.set("costelement", (Object)elementIds[1]);
                } else {
                    subEntry = (DynamicObject)subEntryCol.get(0);
                }
                subEntry.set("sub_adjustamt", (Object)subEntry.getBigDecimal("sub_adjustamt").add(adjustCost));
            }
            costAdjustEntry.set("adjustamt", (Object)costAdjustEntry.getBigDecimal("adjustamt").add(adjustCost));
        }
        new WfDiffHelper().removeZeroAmtEntryBill(costAdjustHeadMap);
        if (!costAdjustHeadMap.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            DynamicObject[] costAdjDycs = costAdjustHeadMap.values().toArray(new DynamicObject[costAdjustHeadMap.size()]);
            costAdjDycs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])costAdjDycs);
            HashSet<Object> ids = new HashSet<Object>(costAdjDycs.length);
            for (DynamicObject costAdjDyc : costAdjDycs) {
                ids.add(costAdjDyc.getPkValue());
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (Object[])ids.toArray(new Object[0]), (OperateOption)option);
            List errors = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u6838\u7b97\u5931\u8d25\uff1a", (String)"CostAdjustDeleteFunction_2", (String)"fi-cal-business", (Object[])new Object[0]));
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                msg.append(result.getMessage()).append('\n');
                throw new KDBizException(msg.toString());
            }
        }
    }

    private DynamicObject createCostAdjustEntry(DynamicObject costAdjustBillHead, DynamicObject costRecordInfo, DynamicObject costRecordEntry) {
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        DynamicObject entry = costAdjustBillHead.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costRecordInfo.get("storageorgunit_id"));
        entry.set("material", costRecordEntry.get("material_id"));
        entry.set("lot", costRecordEntry.get("lot"));
        entry.set("warehouse", costRecordEntry.get("warehouse_id"));
        entry.set("location", costRecordEntry.get("location_id"));
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", costRecordEntry.get("owner_id"));
        entry.set("ecostcenter", costRecordEntry.get("ecostcenter_id"));
        entry.set("assist", costRecordEntry.get("assist_id"));
        entry.set("invbilltype", costRecordInfo.get("billtype_id"));
        entry.set("invbizdate", costRecordInfo.get("bookdate"));
        entry.set("invbillnum", (Object)costRecordInfo.getString("billno"));
        entry.set("inventryseq", costRecordEntry.get("seq"));
        entry.set("invbillid", costRecordInfo.get("id"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("invbillentryid", costRecordEntry.get("id"));
        entry.set("baseunit", costRecordEntry.get("baseunit_id"));
        entry.set("project", costRecordEntry.get("project_id"));
        entry.set("invtype", costRecordEntry.get("invtype_id"));
        entry.set("invstatus", costRecordEntry.get("invstatus_id"));
        entry.set("mversion", costRecordEntry.get("mversion_id"));
        entry.set("tracknumber", costRecordEntry.get("tracknumber"));
        entry.set("configuredcode", costRecordEntry.get("configuredcode"));
        entry.set("noupdatecalfields", costRecordEntry.get("noupdatecalfields"));
        entry.set("stocktype", costRecordEntry.get("stocktype"));
        CommonSettingHelper.setExFieldValue((MainEntityType)costAdjustEntityType, (MainEntityType)costRecordEntityType, (DynamicObject)entry, (DynamicObject)costRecordEntry);
        return entry;
    }

    private DynamicObject createCostAdjust(DynamicObject info, String accountType) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_subentity");
        String calbilltype = info.getString("calbilltype");
        if ("IN".equals(calbilltype)) {
            costAdjustBill.set("cstype", (Object)"bd_supplier");
            costAdjustBill.set("custsupplier", info.get("supplier_id"));
        } else {
            costAdjustBill.set("cstype", (Object)"bd_customer");
            costAdjustBill.set("custsupplier", info.get("customer_id"));
        }
        costAdjustBill.set("currency", info.get("localcurrency_id"));
        costAdjustBill.set("bizdate", (Object)info.getDate("bizdate"));
        costAdjustBill.set("bookdate", (Object)info.getDate("bookdate"));
        if ("IN".equals(info.getString("calbilltype"))) {
            costAdjustBill.set("biztype", (Object)"A");
        } else {
            costAdjustBill.set("biztype", (Object)"B");
        }
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("createtype", (Object)"F");
        costAdjustBill.set("difftype", (Object)"B");
        if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
            costAdjustBill.set("createtype", (Object)"X");
            costAdjustBill.set("difftype", (Object)"G");
        }
        costAdjustBill.set("costaccount", (Object)info.getLong("costaccount_id"));
        Object accountID = info.get("costaccount_id");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingleFromCache((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        costAdjustBill.set("calorg", costAccont.get("calorg"));
        costAdjustBill.set("billtype", info.get("billtype_id"));
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("createtime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        costAdjustBill.set("creator_id", (Object)userId);
        costAdjustBill.set("adminorg", info.get("adminorg_id"));
        String number = BillNoHelper.getBillNo((String)"cal_costadjust_subentity", (DynamicObject)costAdjustBill, (String)costAccont.get("calorg_id").toString());
        costAdjustBill.set("billno", (Object)number);
        return costAdjustBill;
    }

    private void dealNotCalculated(Map<Long, DynamicObject> notCalculatedCostRecordEntry, Set<Long> costRecordIdSet, Map<String, BigDecimal> totalGroupCost, Set<Long> costAcctIds) {
        new CalMoveInvoker().doCalMoveAndFifoByMatWf(notCalculatedCostRecordEntry, costRecordIdSet, totalGroupCost, costAcctIds);
    }

    private DynamicObject getGroupRecord(BillGroupWfRelationHelper helper, DynamicObject bizBill) {
        return helper.createRelations(bizBill);
    }

    private void addQueue(DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("retry", "1");
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{ActionEnum.MATERIALWRITEOFF.getValue(), param, bizBills});
    }

    private void updateBalance(Set<Long> entryIds, Set<Long> ids) {
        String acctId = CacheKeyUtil.getAcctId();
        String lockKey = "fi-cal-billsynclock_updatebal" + acctId;
        DLock dlock = DLock.createReentrant((String)lockKey, (String)"fi-cal-billsynclock_updatebal");
        this.addLock(lockKey, dlock);
        try {
            dlock.lock();
            new BalanceCalculator().updateBalance4Others(entryIds.toArray(), BalanceSourceEnum.WRITE_OFF, ids);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u4f59\u989d\u62a5\u9519\uff1a%1$s", (String)"SyncBizBill4AuditServiceProcess_8", (String)"fi-cal-business", (Object[])new Object[0]), this.getErrorMsg(e));
            throw new KDBizException(msg);
        }
    }

    private void updateNewBalance(Set<Long> balIdSet) {
        new BalanceOpInvoker().invokeCostRecordUpdateBalOp(balIdSet, BalanceSourceEnum.WRITE_OFF);
    }

    private void dealCalculatedStdDiff(Map<String, DynamicObject> calculatedCostRecordEntry, Map<String, BigDecimal> totalAddedGroupCost) {
        new WfDiffHelper().dealCalculatedStdDiff(calculatedCostRecordEntry, totalAddedGroupCost);
    }

    private Set<Long> getInEIdOutEIdsMap(DynamicObject[] bizBills) {
        HashSet<Long> omInBillEIds = new HashSet<Long>(16);
        for (DynamicObject bizBill : bizBills) {
            DynamicObjectCollection recordEntrys = bizBill.getDynamicObjectCollection("entry");
            for (DynamicObject recordEntry : recordEntrys) {
                String billType = recordEntry.getString("billtype_id");
                if (!this.omInBills.contains(billType)) continue;
                long billEId = recordEntry.getLong("billentryid");
                omInBillEIds.add(billEId);
            }
        }
        return omInBillEIds;
    }

    private DataSet getWfDs(QFilter billIdF) {
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        OrmInput omPurBillInput = new OrmInput(this.getClass().getName(), "im_oswfrecord", "id,entry.billid billid,entry.billentryid billentryid,entry.billtype billtype", billIdF.toArray());
        OrmInput omSimpleBillInput = new OrmInput(this.getClass().getName(), "im_mdc_omwrfrecord", "id,entry.billid billid,entry.billentryid billentryid,entry.billtype billtype", billIdF.toArray());
        inputs.add(omPurBillInput);
        inputs.add(omSimpleBillInput);
        DataSet srcDataSet = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        return srcDataSet;
    }
}

