/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountTypeExplainHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalLockKeyHelper {
    private final Map<String, Set<String>> bizEntityBizBillIdDimsMap = new HashMap<String, Set<String>>(16);
    private final Boolean calMoveLockMat = CalDbParamServiceHelper.getBoolean((String)"cal_move_lock_mat");

    public List<String> getCostRecordBillLockKeyList(Collection<Long> costRecordIds) {
        if (costRecordIds.isEmpty()) {
            return new ArrayList<String>(0);
        }
        QFilter filter = new QFilter("id", "in", costRecordIds);
        filter.and("entry.accounttype", "in", (Object)this.getNeedLockAccType());
        String entity = "cal_costrecord";
        Map<Long, Set<String>> rangeIdDivValsMap = this.getRangeIdDivValsMap(filter, entity);
        List<String> lockKeyList = this.getLockKeyList(rangeIdDivValsMap);
        this.sort(lockKeyList);
        return lockKeyList;
    }

    public List<String> getCostRecBillLockKeyListByBizBill(Collection<Long> bizBillIds) {
        if (bizBillIds.isEmpty()) {
            return new ArrayList<String>(0);
        }
        QFilter filter = new QFilter("bizbillid", "in", bizBillIds);
        filter.and("entry.accounttype", "in", (Object)this.getNeedLockAccType());
        String entity = "cal_costrecord";
        Map<Long, Set<String>> rangeIdDivValsMap = this.getRangeIdDivValsMap(filter, entity);
        List<String> lockKeyList = this.getLockKeyList(rangeIdDivValsMap);
        this.sort(lockKeyList);
        return lockKeyList;
    }

    public void getCostRecBillLockKeyListByBizBill(Map<String, Set<Long>> entityBizBillIdsMap) {
        HashMap allEntryFieldValueMap = new HashMap(16);
        for (Map.Entry<String, Set<Long>> entry : entityBizBillIdsMap.entrySet()) {
            String entity = entry.getKey();
            Set<Long> bizBillIds = entry.getValue();
            AccountTypeExplainHelper accountTypeExplainHelper = new AccountTypeExplainHelper(entity);
            accountTypeExplainHelper.setBillIds(bizBillIds);
            accountTypeExplainHelper.setExplainFromDb(true);
            accountTypeExplainHelper.setAccountIdSplit(true);
            Map entryFieldValueMap = accountTypeExplainHelper.explain();
            for (Map.Entry fieldValueMap : entryFieldValueMap.entrySet()) {
                String accountType = (String)((Map)fieldValueMap.getValue()).get("accounttype");
                if (!accountType.equals(AccountTypeEnum.MOVE_ADD_AVERAGE.getValue()) && !accountType.equals(AccountTypeEnum.FIN_FOUT.getValue())) continue;
                allEntryFieldValueMap.put(fieldValueMap.getKey(), fieldValueMap.getValue());
            }
        }
        HashSet<Long> calRangeIds = new HashSet<Long>(16);
        for (Map entry : allEntryFieldValueMap.values()) {
            Long calRangeId = (Long)entry.get("calrange");
            calRangeIds.add(calRangeId);
        }
        Map map = BusinessDataServiceHelper.loadFromCache((Object[])calRangeIds.toArray(), (String)"cal_bd_calrange");
        HashMap<Long, String> calRangeIdDivMap = new HashMap<Long, String>(16);
        for (DynamicObject calRangeDyc : map.values()) {
            DynamicObject divDyc = calRangeDyc.getDynamicObject("dividebasis");
            calRangeIdDivMap.put(calRangeDyc.getLong("id"), divDyc.getString("dividebasis"));
        }
        Set<Long> emptyEntryRangeIds = this.getEmptyEntryRangeIds(calRangeIds);
        HashMap<Long, Set<String>> rangeIdDivValsMap = new HashMap<Long, Set<String>>(16);
        for (Map entry : allEntryFieldValueMap.values()) {
            Long calRangeId = (Long)entry.get("calrange");
            String divideBasis = (String)calRangeIdDivMap.get(calRangeId);
            String[] accDivStrs = divideBasis.split(",");
            String divVal = this.getDivVal(null, accDivStrs, entry);
            Set divVals = rangeIdDivValsMap.computeIfAbsent(calRangeId, k -> new HashSet(16));
            String bizEntity = (String)entry.get("bizentityobject");
            Long bizBillid = (Long)entry.get("bizbillid");
            String bizEnittyBizBillId = bizEntity + bizBillid;
            Set dims = this.bizEntityBizBillIdDimsMap.computeIfAbsent(bizEnittyBizBillId, k -> new HashSet(16));
            String dimValue = this.getDimValue(emptyEntryRangeIds, null, divVal, entry);
            dims.add(dimValue);
            divVals.add(dimValue);
        }
        List<String> lockKeyList = this.getLockKeyList(rangeIdDivValsMap);
        this.sort(lockKeyList);
    }

    public List<String> getCostAdjustBillLockKeyList(Collection<Long> costAdjustBillIds) {
        if (costAdjustBillIds.isEmpty()) {
            return new ArrayList<String>(0);
        }
        QFilter filter = new QFilter("id", "in", costAdjustBillIds);
        filter.and("entryentity.accounttype", "in", (Object)this.getNeedLockAccType());
        String entity = "cal_costadjustbill";
        Map<Long, Set<String>> rangeIdDivValsMap = this.getRangeIdDivValsMap(filter, entity);
        List<String> lockKeyList = this.getLockKeyList(rangeIdDivValsMap);
        this.sort(lockKeyList);
        return lockKeyList;
    }

    public List<String> getCalInitBillLockKeyList(Collection<Long> calInitBillIds) {
        if (calInitBillIds.isEmpty()) {
            return new ArrayList<String>(0);
        }
        QFilter filter = new QFilter("id", "in", calInitBillIds);
        filter.and("entryentity.accounttype", "in", (Object)this.getNeedLockAccType());
        String entity = "cal_initbill";
        Map<Long, Set<String>> rangeIdDivValsMap = this.getRangeIdDivValsMap(filter, entity);
        List<String> lockKeyList = this.getLockKeyList(rangeIdDivValsMap);
        this.sort(lockKeyList);
        return lockKeyList;
    }

    private void sort(List<String> lockKeyList) {
        Collections.sort(lockKeyList);
    }

    private Map<Long, Set<String>> getRangeIdDivValsMap(QFilter filter, String entity) {
        String selectFields = this.getSelFields(entity);
        HashMap<Long, Set<String>> rangeIdDivValsMap = new HashMap<Long, Set<String>>(16);
        HashSet<Long> rangeIds = new HashSet<Long>(16);
        try (AlgoContext context = Algo.newContext();){
            DataSet costRecBillDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)selectFields, (QFilter[])filter.toArray(), null);
            for (Row row : costRecBillDs.copy()) {
                rangeIds.add(row.getLong("calrange"));
            }
            Set<Long> emptyEntryRangeIds = this.getEmptyEntryRangeIds(rangeIds);
            for (Row row : costRecBillDs) {
                String divideBasis = row.getString("dividebasis");
                String[] accDivStrs = divideBasis.split(",");
                String divVal = this.getDivVal(row, accDivStrs, null);
                Set divVals = rangeIdDivValsMap.computeIfAbsent(row.getLong("calrange"), k -> new HashSet(16));
                String bizEntity = row.getString("bizentity");
                Long bizBillid = row.getLong("bizbillid");
                String bizEnittyBizBillId = bizEntity + bizBillid;
                Set dims = this.bizEntityBizBillIdDimsMap.computeIfAbsent(bizEnittyBizBillId, k -> new HashSet(16));
                String dimValue = this.getDimValue(emptyEntryRangeIds, row, divVal, null);
                dims.add(dimValue);
                divVals.add(dimValue);
            }
        }
        return rangeIdDivValsMap;
    }

    private String getDimValue(Set<Long> emptyEntryRangeIds, Row row, String divVal, Map<String, Object> allEntryFieldValueMap) {
        Long rangeId;
        String matId = "";
        if (this.calMoveLockMat.booleanValue()) {
            matId = "_" + this.getFeildValue(row, allEntryFieldValueMap, "material");
        }
        String dimValue = emptyEntryRangeIds.contains(rangeId = (Long)this.getFeildValue(row, allEntryFieldValueMap, "calrange")) ? rangeId + "_" + divVal + matId : rangeId + "_" + matId;
        return dimValue;
    }

    private Object getFeildValue(Row row, Map<String, Object> allEntryFieldValueMap, String field) {
        Object value = row != null ? row.get(field) : allEntryFieldValueMap.get(field);
        return value;
    }

    private List<String> getLockKeyList(Map<Long, Set<String>> rangeIdDivValsMap) {
        ArrayList<String> lockKeyList = new ArrayList<String>(16);
        for (Set<String> set : rangeIdDivValsMap.values()) {
            lockKeyList.addAll(set);
        }
        for (Map.Entry entry : this.bizEntityBizBillIdDimsMap.entrySet()) {
            ((Set)entry.getValue()).retainAll(lockKeyList);
        }
        return lockKeyList;
    }

    private Set<Long> getEmptyEntryRangeIds(Set<Long> rangeIds) {
        QFilter rangeIdFilter = new QFilter("id", "in", rangeIds);
        Map calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (QFilter[])rangeIdFilter.toArray());
        HashSet<Long> emptyEntryRangeIds = new HashSet<Long>(16);
        for (DynamicObject rangDyc : calRangeMap.values()) {
            DynamicObjectCollection entryDycs = rangDyc.getDynamicObjectCollection("entry");
            if (!entryDycs.isEmpty()) continue;
            emptyEntryRangeIds.add(rangDyc.getLong("id"));
        }
        return emptyEntryRangeIds;
    }

    private String getSelFields(String entity) {
        String divideStr = CommonSettingHelper.getDivideBasisStr();
        String[] fields = divideStr.split(",");
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            String fieldPath = CommonUtils.getFieldPath((String)entity, (String)field);
            sb.append(fieldPath).append(" as ").append(field).append(',');
        }
        String calRangeField = CommonUtils.getFieldPath((String)entity, (String)"calrange");
        sb.append(calRangeField).append(" as calrange,");
        sb.append("costaccount.dividebasis.dividebasis as dividebasis");
        if ("cal_costrecord".equals(entity) || "cal_costrecord_subentity".equals(entity)) {
            sb.append(",bizbillid,bizentityobject as bizentity");
        } else {
            sb.append(String.format(",id as bizbillid, '%s' as bizentity", entity));
        }
        String matField = CommonUtils.getFieldPath((String)entity, (String)"material");
        sb.append(",").append(matField).append(" as material");
        String selectFields = sb.toString();
        return selectFields;
    }

    private String getDivVal(Row row, String[] accDivStrs, Map<String, Object> entry) {
        StringBuilder divSb = new StringBuilder();
        for (String accDivStr : accDivStrs) {
            Object divValue = row != null ? row.get(accDivStr) : entry.get(accDivStr);
            divSb.append(divValue == null ? "0" : divValue.toString());
            divSb.append('_');
        }
        String divVal = divSb.toString();
        return divVal;
    }

    private String[] getNeedLockAccType() {
        return new String[]{AccountTypeEnum.MOVE_ADD_AVERAGE.getValue(), AccountTypeEnum.FIN_FOUT.getValue()};
    }

    public Map<String, Set<String>> getBizEntityBizBillIdDimsMap() {
        return this.bizEntityBizBillIdDimsMap;
    }
}

