/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.process.inner.CalLockKeyHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class CalMoveDlock {
    private static Log log = LogFactory.getLog(CalMoveDlock.class);
    private Map<String, DLock> hasKeyLockMap = new HashMap<String, DLock>(16);
    private HashMap<String, DLock> curKeyLockMap = new HashMap(16);
    private Boolean lockRangeDiv = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_LOCK_RANGE_DIV);
    private Boolean calMoveNotLock = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_MOVE_NOT_LOCK);

    public Map<String, DLock> addLockBatchByCostRecord(Set<Long> bizBillIds) {
        List<String> lockKeys = new CalLockKeyHelper().getCostRecBillLockKeyListByBizBill(bizBillIds);
        this.addLockBatch(lockKeys);
        return this.curKeyLockMap;
    }

    public Map<String, DLock> addLockBatchByCostRecordId(Set<Long> costRecIds) {
        List<String> lockKeys = new CalLockKeyHelper().getCostRecordBillLockKeyList(costRecIds);
        this.addLockBatch(lockKeys);
        return this.curKeyLockMap;
    }

    public Map<String, DLock> addLockBatchByCostAdjust(Set<Long> costAdjustBillIds) {
        if (!this.lockRangeDiv.booleanValue()) {
            return this.curKeyLockMap;
        }
        List<String> lockKeys = new CalLockKeyHelper().getCostAdjustBillLockKeyList(costAdjustBillIds);
        if (lockKeys.size() < 1) {
            return this.curKeyLockMap;
        }
        this.addLockBatch(lockKeys);
        return this.curKeyLockMap;
    }

    public Map<String, DLock> addLockBatchByInitCalBill(Set<Long> calInitBillIds) {
        if (!this.lockRangeDiv.booleanValue()) {
            return this.curKeyLockMap;
        }
        List<String> lockKeys = new CalLockKeyHelper().getCalInitBillLockKeyList(calInitBillIds);
        if (lockKeys.size() < 1) {
            return this.curKeyLockMap;
        }
        this.addLockBatch(lockKeys);
        return this.curKeyLockMap;
    }

    private DLock getDlock(String curLockKey, String desc) {
        DLock curDlock = null;
        int lockRetryTimes = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.LOCK_RETRY_TIMES);
        if (lockRetryTimes <= 0) {
            curDlock = DLock.createReentrant((String)curLockKey, (String)desc);
            curDlock.lock();
        }
        for (int i = 0; i < lockRetryTimes; ++i) {
            try {
                curDlock = DLock.createReentrant((String)curLockKey, (String)desc);
                curDlock.lock();
                break;
            }
            catch (Throwable e) {
                if (i >= lockRetryTimes - 1) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    WriteLogHelper.writeErrorLog((Log)log, (String)"CalMoveDlock-getDlock", (Throwable)interruptedException);
                }
                continue;
            }
        }
        return curDlock;
    }

    private void releaseAllLock() {
        for (DLock curLock : this.curKeyLockMap.values()) {
            curLock.close();
        }
    }

    private void addLockBatch(List<String> lockKeys) {
        if (this.calMoveNotLock.booleanValue()) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)"CalMoveDlock", (String)"addLockBatch");){
            String acctId = CacheKeyUtil.getAcctId();
            if (this.lockRangeDiv.booleanValue()) {
                for (String lockKey : lockKeys) {
                    String curLockKey = "fi-cal-billsynclock_calmove" + acctId + "_" + lockKey;
                    if (this.getHasKeyLockMap().containsKey(curLockKey)) continue;
                    DLock curDLock = this.getDlock(curLockKey, "fi-cal-billsynclock_calmove");
                    this.curKeyLockMap.put(curLockKey, curDLock);
                }
            } else {
                String curLockKey = "fi-cal-billsynclock_calmove" + acctId;
                if (!this.getHasKeyLockMap().containsKey(curLockKey)) {
                    DLock curDLock = this.getDlock(curLockKey, "fi-cal-billsynclock_calmove");
                    this.curKeyLockMap.put(curLockKey, curDLock);
                }
            }
        }
        catch (Throwable e) {
            this.releaseAllLock();
            throw e;
        }
    }

    public void setHasKeyLockMap(Map<String, DLock> hasKeyLockMap) {
        this.hasKeyLockMap = hasKeyLockMap;
    }

    public Map<String, DLock> getHasKeyLockMap() {
        return this.hasKeyLockMap;
    }

    public void releaseLockAfterTxEnd(final List<DLock> locks) {
        CommitListener commitListener = new CommitListener(){

            public void onEnded(boolean rollbacked) {
                for (DLock lock : locks) {
                    lock.close();
                }
            }
        };
        TX.addCommitListener((CommitListener)commitListener);
    }
}

