/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.process.ErrorMsg;
import kd.fi.cal.common.helper.ScmParamsHelper;

public class CostRecordAuditInvoker {
    private static final Log logger = LogFactory.getLog(CostRecordAuditInvoker.class);
    private List<ErrorMsg> errorMsgs = new ArrayList<ErrorMsg>(16);
    private Map<Long, Long> costRecIdBizBillIdMap = new HashMap<Long, Long>(16);
    private Map<Long, ErrorMsg> bizBillMsgMap = new HashMap<Long, ErrorMsg>(16);

    public void invoke(final Collection<Long> costRecordIds) {
        if (costRecordIds.size() < 1) {
            return;
        }
        CommitListener commitListener = new CommitListener(){

            public void onEnded(boolean rollbacked) {
                try (TXHandle txHandle = TX.notSupported();){
                    try (TraceSpan span = Tracer.create((String)"CostRecordAuditInvoker", (String)"invokeGenVoucher");){
                        CostRecordAuditInvoker.this.invokeGenVoucher(costRecordIds);
                    }
                    CostRecordAuditInvoker.this.invokeAudit(costRecordIds);
                }
            }
        };
        TX.addCommitListener((CommitListener)commitListener);
    }

    private void invokeAudit(Collection<Long> costRecordIds) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"auditvoucher", (String)"cal_costrecord_subentity", (Object[])costRecordIds.toArray(new Object[0]), (OperateOption)option);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            msg.append(ResManager.loadKDString((String)"\u6210\u672c\u8bb0\u5f55\u5ba1\u6838\u5931\u8d25\uff1a", (String)"CostRecordAuditInvoker_0", (String)"fi-cal-business", (Object[])new Object[0]));
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            msg.append(result.getMessage()).append('\n');
            throw new KDBizException(msg.toString());
        }
    }

    private void invokeGenVoucher(Collection<Long> costRecordIds) {
        boolean isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005");
        if (!isBizFinInt) {
            return;
        }
        long startTime = TimeServiceHelper.now().getTime();
        logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u5224\u65ad\u662f\u5426\u9700\u8981\u751f\u6210\u51ed\u8bc1-\u5f00\u59cb");
        Set<Long> needGenVouRecIds = this.getNeedGenVouRecIds(costRecordIds);
        if (needGenVouRecIds.isEmpty()) {
            return;
        }
        logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u5224\u65ad\u662f\u5426\u9700\u8981\u751f\u6210\u51ed\u8bc1-\u7ed3\u675f-" + (TimeServiceHelper.now().getTime() - startTime));
        String voucherShowMsg = ResManager.loadKDString((String)"\u6210\u672c\u8bb0\u5f55\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff1a", (String)"CostRecordAuditInvoker_1", (String)"fi-cal-business", (Object[])new Object[0]);
        String genVoucher = "generatevoucher";
        String errorMsgsParamStr = "errorMsgs";
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        try {
            logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u751f\u6210\u51ed\u8bc1-\u5f00\u59cb");
            startTime = TimeServiceHelper.now().getTime();
            OperationResult voucherResult = OperationServiceHelper.executeOperate((String)genVoucher, (String)"cal_costrecord_subentity", (Object[])needGenVouRecIds.toArray(new Object[0]), (OperateOption)option);
            logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u751f\u6210\u51ed\u8bc1-\u7ed3\u675f-" + (TimeServiceHelper.now().getTime() - startTime));
            List errors = voucherResult.getAllErrorOrValidateInfo();
            if (!voucherResult.isSuccess()) {
                String message = voucherResult.getMessage();
                String string = message = message == null ? "" : message;
                if (StringUtils.isNotEmpty((String)message)) {
                    for (Long bizBillId : this.costRecIdBizBillIdMap.values()) {
                        this.addErrorMsg(voucherShowMsg, message, bizBillId);
                    }
                }
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    Long bizBillId = this.costRecIdBizBillIdMap.get((Long)operror.getPkValue());
                    ErrorMsg errorMsg = this.addErrorMsg(voucherShowMsg, message, bizBillId);
                    if (errorMsg.getErrorMsg().contains(operror.getMessage())) continue;
                    errorMsg.setErrorMsg(errorMsg.getErrorMsg() + operror.getMessage() + "\n");
                }
            }
            ThreadCache.put((Object)errorMsgsParamStr, this.errorMsgs);
        }
        catch (Throwable e) {
            String exMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e));
            for (Long bizBillId : this.costRecIdBizBillIdMap.values()) {
                this.addErrorMsg(voucherShowMsg, exMsg, bizBillId);
            }
            ThreadCache.put((Object)errorMsgsParamStr, this.errorMsgs);
            logger.error("\u4e1a\u8d22\u4e00\u4f53\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff1a", e);
        }
    }

    private Set<Long> getNeedGenVouRecIds(Collection<Long> costRecordIds) {
        QFilter useFilter = new QFilter("use", "=", (Object)"bizfinint");
        String[] entitys = new String[]{"cal_costrecord", "cal_costrecord_subentity"};
        QFilter entityFilter = new QFilter("entity", "in", (Object)entitys);
        DataSet filterDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_filter_config", (String)"filter_tag", (QFilter[])new QFilter[]{useFilter, entityFilter}, null);
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        QFilter recIdFilter = new QFilter("id", "in", costRecordIds);
        for (Row row : filterDs) {
            String filterTag = row.getString("filter_tag");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"cal_costrecord_subentity"), filterCondition);
            filterBuilder.buildFilter();
            QFilter filter = filterBuilder.getQFilter();
            OrmInput ormInput = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", "id", new QFilter[]{recIdFilter, filter});
            billOIs.add(ormInput);
        }
        if (billOIs.isEmpty()) {
            return new HashSet<Long>(costRecordIds);
        }
        HashSet<Long> needGenVouRecIds = new HashSet<Long>(16);
        Lists.partition(billOIs, (int)10).forEach(list -> {
            DataSet recIdDs = Algo.create((String)this.getClass().getName()).createDataSet(list.toArray(new Input[list.size()]));
            for (Row row : recIdDs) {
                needGenVouRecIds.add(row.getLong("id"));
            }
        });
        return needGenVouRecIds;
    }

    private ErrorMsg addErrorMsg(String voucherShowMsg, String message, Long bizBillId) {
        ErrorMsg errorMsg = this.bizBillMsgMap.get(bizBillId);
        if (errorMsg == null) {
            errorMsg = new ErrorMsg(bizBillId, "3", voucherShowMsg + message + "\n");
            this.errorMsgs.add(errorMsg);
            this.bizBillMsgMap.put(bizBillId, errorMsg);
        }
        return errorMsg;
    }

    public void setCostRecIdBizBillIdMap(Map<Long, Long> costRecIdBizBillIdMap) {
        this.costRecIdBizBillIdMap = costRecIdBizBillIdMap;
    }

    public Map<Long, Long> getCostRecIdBizBillIdMap() {
        return this.costRecIdBizBillIdMap;
    }
}

