/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.costprice.CostPrice4SyncBillHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostPriceSourceTypeHelper;
import kd.fi.cal.common.helper.CostTypeHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.StandardCostHelper;
import kd.fi.cal.common.model.CostPriceResultInfo;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.DateUtils;

public class CostRecordCostHandle {
    private static final Log logger = LogFactory.getLog(CostRecordCostHandle.class);
    private DynamicObject[] recordDycs;
    private Set<Long> notUpdBalBizTypeIdSet = new HashSet<Long>(16);
    private Set<Long> isCalInvSchemeIds = new HashSet<Long>(16);
    private Set<Long> isCalInvTypeIds = new HashSet<Long>(16);
    private Map<Long, Boolean> calOrgIdIsGetStdCostMap = new HashMap<Long, Boolean>(16);
    private Map<Long, Boolean> enableStandCostMap = new HashMap<Long, Boolean>(16);
    private Map<Long, BigDecimal> entryMatEleStdAmtMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, Set<Long>> entryMatSubElesMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, Set<Long>> entryNotMatSubElesMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, String> subElesTypeMap = new HashMap<Long, String>(16);
    private Map<Long, Long> bill2CosttypeMap = new HashMap<Long, Long>(16);
    private static String[] costtypeFields = new String[]{"bookdate", "costaccount", "calorg", "storageorgunit", "accounttype"};
    private Set<String> purOutSourceBills = CommonSettingHelper.getBizEntityNumbers((String)"purbiztype");
    private Map<Long, SynBillErrInfo> errMap = new HashMap<Long, SynBillErrInfo>(32);
    private Map<String, Long[]> materialCostElementMap = new HashMap<String, Long[]>(16);
    private final Map<String, DynamicObject> entryDetailMap = new HashMap<String, DynamicObject>(16);
    private final Map<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, List<DynamicObject>> detailMap;
    private final Map<Long, SynBillErrInfo> noCostTypeErrMap = new HashMap<Long, SynBillErrInfo>(16);
    private String bizBillEntityName;
    private String bizBillEntryKey;
    private boolean syncPrice = false;
    private String auditType;
    private final Map<Long, String> entrybizEntityObjectMap = new HashMap<Long, String>(16);
    private final Map<Long, String> entryBizCostPriceSourceMap = new HashMap<Long, String>(16);

    public CostRecordCostHandle(DynamicObject[] recordDycs, String auditType) {
        Long currtime = System.currentTimeMillis();
        this.recordDycs = recordDycs;
        this.notUpdBalBizTypeIdSet = CommonSettingHelper.getNotUpdBalBizType();
        logger.info("CostRecordCostHandle-\u7ed3\u675f\u521d\u59cb\u5316\u65b9\u6cd5init\uff1a" + (currtime - System.currentTimeMillis()));
        this.cacheInvSchemeAndInvTypeInfos();
        this.cacheAcctEnableStandCostMap(recordDycs);
        this.bill2CosttypeMap = CostTypeHelper.getCostTypeByBill((DynamicObject[])recordDycs, (String[])costtypeFields);
        Set omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
        this.purOutSourceBills.addAll(omInBills);
        this.materialCostElementMap = CostElementHelper.getMaterialCostElement((DynamicObject[])recordDycs);
        this.cacheSubElesType();
        this.auditType = auditType;
    }

    public DynamicObject[] handle() {
        try (TraceSpan span = Tracer.create((String)"CostRecordCostHandle.handle", (String)"CostRecordCostHandle.handle");){
            Map<Long, Set<DynamicObject>> costRecordMap = this.getCostRecDycMap();
            HashMap<Long, String> entryCostPriceSourceMap = new HashMap<Long, String>(16);
            Map<Long, Boolean> calByCostElementMap = this.getCalByCostEleMap();
            this.handleStandardCost(this.recordDycs, calByCostElementMap);
            this.handleActualCost(this.recordDycs, calByCostElementMap);
            boolean enableSyncPrice = this.handleCostPriceScheme(costRecordMap, entryCostPriceSourceMap, calByCostElementMap);
            this.recordDycs = this.reLoadCostRecFromDb(enableSyncPrice, entryCostPriceSourceMap);
            this.handleActualCostZero(this.recordDycs, calByCostElementMap);
            CostElementHelper.calCostRecordAllCost((DynamicObject[])this.recordDycs, calByCostElementMap, this.subElesTypeMap);
        }
        return this.recordDycs;
    }

    private Map<Long, Boolean> getCalByCostEleMap() {
        HashMap<Long, Boolean> calByCostElementMap = new HashMap<Long, Boolean>(this.recordDycs.length);
        for (DynamicObject info : this.recordDycs) {
            long costAccountId = info.getLong("costaccount_id");
            if (calByCostElementMap.containsKey(costAccountId)) continue;
            Boolean calByCostElement = ParamsHelper.getCostElementByCostAccount((long)costAccountId);
            calByCostElementMap.put(costAccountId, calByCostElement);
        }
        return calByCostElementMap;
    }

    public void handleStandardCost(DynamicObject[] infos, Map<Long, Boolean> calByCostElementMap) {
        int cSize = infos.length;
        HashSet<Long> calOrgSet = new HashSet<Long>(cSize);
        HashSet<Long> storageOrgSet = new HashSet<Long>(cSize);
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        for (DynamicObject info : infos) {
            calOrgSet.add(info.getLong("calorg_id"));
            storageOrgSet.add(info.getLong("storageorgunit_id"));
            Date date = info.getDate("auditdate");
            if (date != null) continue;
            info.set("auditdate", (Object)now);
        }
        Map calOrgCostTypeMap = ParamsHelper.getCostTypeByOrg(calOrgSet);
        Map storageOrgCostTypeMap = ParamsHelper.getCostTypeByOrg(storageOrgSet);
        HashSet<DynamicObject> calByCostElementInfos = new HashSet<DynamicObject>(cSize);
        HashSet<DynamicObject> unCalByCostElementInfos = new HashSet<DynamicObject>(cSize);
        for (DynamicObject info : infos) {
            long costAccountId = info.getLong("costaccount_id");
            boolean calByCostElement = calByCostElementMap.get(costAccountId);
            if (calByCostElement) {
                calByCostElementInfos.add(info);
                continue;
            }
            unCalByCostElementInfos.add(info);
        }
        try (TraceSpan traceSpan = Tracer.create((String)"SyncBizBill4AuditNewServiceProcess.handleStandardCost", (String)"handleStandardCost");){
            if (!calByCostElementInfos.isEmpty()) {
                this.handleStandardCost(calByCostElementInfos.toArray(new DynamicObject[0]), calOrgCostTypeMap, true, storageOrgCostTypeMap, this.materialCostElementMap);
            }
            if (!unCalByCostElementInfos.isEmpty()) {
                this.handleStandardCost(unCalByCostElementInfos.toArray(new DynamicObject[0]), calOrgCostTypeMap, false, storageOrgCostTypeMap, this.materialCostElementMap);
            }
        }
    }

    public void handleActualCost(DynamicObject[] infos, Map<Long, Boolean> calByCostElementMap) {
        ArrayList<Object[]> actualParamList = new ArrayList<Object[]>(1024);
        ArrayList<Object[]> matStd2ActParamList = new ArrayList<Object[]>(1024);
        HashSet<Long> matStd2ActIdSet = new HashSet<Long>(16);
        Long[] materialDefualtElements = CostElementHelper.getDefaultMaterialElements();
        Map<String, Long[]> subElementTypeMap = this.getDefaultSubElementTypeMap();
        Set notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType();
        boolean allSubActualZero = true;
        for (DynamicObject info : infos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long entryId = entry.getLong("id");
                Set<Long> matSubEles = this.entryMatSubElesMap.get(entryId);
                if (matSubEles == null) continue;
                for (Long matSubEle : matSubEles) {
                    BigDecimal sub_unitactualcost;
                    DynamicObject detailDyc = this.entryDetailMap.get(entryId + "," + matSubEle);
                    if (detailDyc == null || (sub_unitactualcost = detailDyc.getBigDecimal("sub_unitactualcost")) == null || BigDecimal.ZERO.compareTo(sub_unitactualcost) == 0) continue;
                    allSubActualZero = false;
                }
            }
        }
        for (DynamicObject info : infos) {
            long costAccountId = info.getLong("costaccount_id");
            boolean calByCostElement = calByCostElementMap.get(costAccountId);
            boolean notUpdBal = notUpdBalBizType.contains(info.getLong("biztype_id"));
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            Long costTypeId = this.bill2CosttypeMap.get(info.getLong("id"));
            costTypeId = costTypeId == null ? Long.valueOf(0L) : costTypeId;
            for (DynamicObject entry : entrys) {
                Set<Long> matSubEles;
                boolean feeNotZero;
                boolean isDisAssInBill;
                BigDecimal actualCost = entry.getBigDecimal("materialcost");
                BigDecimal unitActualCost = entry.getBigDecimal("unitmaterialcost");
                long entryId = entry.getLong("id");
                long materialId = entry.getLong("material_id");
                Long[] subEleEle = this.materialCostElementMap.get(costTypeId + "|" + materialId);
                subEleEle = subEleEle == null ? materialDefualtElements : subEleEle;
                Long materialCostSubElement = subEleEle[0];
                Long materialCostElement = subEleEle[1];
                if (!calByCostElement) {
                    materialCostSubElement = materialDefualtElements[0];
                    materialCostElement = materialDefualtElements[1];
                    actualCost = entry.getBigDecimal("actualcost");
                    unitActualCost = entry.getBigDecimal("unitactualcost");
                    actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, materialCostElement, materialCostSubElement});
                } else {
                    this.syncSubEleActCost(actualParamList, subElementTypeMap, entry, entryId);
                    if (notUpdBal) {
                        Long[] outSourceProcessElements = CostElementHelper.getOutSourceProcessElements();
                        actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, outSourceProcessElements[1], outSourceProcessElements[0]});
                    } else {
                        actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, materialCostElement, materialCostSubElement});
                    }
                }
                String accountType = entry.getString("accounttype");
                boolean stdAcct = AccountTypeEnum.STANDARDCOST.getValue().equals(accountType);
                if (!stdAcct || notUpdBal) continue;
                String calBillType = info.getString("calbilltype");
                boolean inCalBill = calBillType.equals("IN");
                String entityNum = info.getString("bizentityobject.number");
                boolean isAssInBill = "im_assembbill".equals(entityNum) && inCalBill;
                boolean bl = isDisAssInBill = "im_disassemblebill".equals(entityNum) && inCalBill;
                if (inCalBill && !isAssInBill && !isDisAssInBill) {
                    boolean isUpdateFlag = this.matZeroStd2Act(matStd2ActParamList, entityNum, actualCost, entryId);
                    if (!isUpdateFlag) continue;
                    matStd2ActIdSet.add(entryId);
                    continue;
                }
                String costpricesource = this.entryBizCostPriceSourceMap.get(entryId);
                String bizEntityObject = this.entrybizEntityObjectMap.get(entryId);
                if (this.syncPrice && !allSubActualZero || CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)costpricesource)) continue;
                Set<Long> notMatSubEles = this.entryNotMatSubElesMap.get(entryId);
                boolean bl2 = feeNotZero = entry.getBigDecimal("fee").compareTo(BigDecimal.ZERO) != 0;
                if (notMatSubEles != null) {
                    for (Long notMatSubEle : notMatSubEles) {
                        String subEleType = this.subElesTypeMap.get(notMatSubEle);
                        if ("002".equals(subEleType) && feeNotZero && inCalBill) continue;
                        matStd2ActParamList.add(new Object[]{entryId, notMatSubEle});
                        matStd2ActIdSet.add(entryId);
                    }
                }
                if ((matSubEles = this.entryMatSubElesMap.get(entryId)) != null) {
                    for (Long matSubEle : matSubEles) {
                        matStd2ActParamList.add(new Object[]{entryId, matSubEle});
                        matStd2ActIdSet.add(entryId);
                    }
                }
                actualParamList.remove(actualParamList.size() - 1);
            }
        }
        for (Object[] param : actualParamList) {
            Object unitActCost = param[0];
            Object actCost = param[1];
            Object entryId = param[2];
            Object subEle = param[4];
            DynamicObject detailDyc = this.entryDetailMap.get(entryId + "," + subEle);
            detailDyc.set("sub_unitactualcost", unitActCost);
            detailDyc.set("sub_actualcost", actCost);
            DynamicObject entryDy = this.entryMap.get(entryId);
            if (entryDy == null) continue;
            String costpricesource = entryDy.getString("costpricesource");
            String accountType = entryDy.getString("accounttype");
            BigDecimal unitactualcost = entryDy.getBigDecimal("unitactualcost");
            boolean isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)this.auditType, (String)costpricesource);
            if (isUpdateFromExpCalcute || !StringUtils.isEmpty((String)costpricesource) && costpricesource.contains(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue()) || !AccountTypeEnum.ADD_AVERAGE.getValue().equals(accountType) && !AccountTypeEnum.FIN_FOUT_PERIOD.getValue().equals(accountType) && !AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) || unitactualcost == null || unitactualcost.compareTo(BigDecimal.ZERO) == 0 || matStd2ActIdSet.contains(entryId)) continue;
            entryDy.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getValue()));
            entryDy.set("designatedcost", (Object)CostPriceSourceTypeEnum.DOCUMENT_SPECIFICATION.getDesignated());
        }
        for (Object[] param : matStd2ActParamList) {
            Object entryId = param[0];
            Object subEle = param[1];
            String costpricesource = this.entryBizCostPriceSourceMap.get(entryId);
            String bizEntityObject = this.entrybizEntityObjectMap.get(entryId);
            if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)costpricesource)) continue;
            DynamicObject detailDyc = this.entryDetailMap.get(entryId + "," + subEle);
            detailDyc.set("sub_unitactualcost", detailDyc.get("sub_unitstandardcost"));
            detailDyc.set("sub_actualcost", detailDyc.get("sub_standardcost"));
        }
    }

    public void handleSubEntryActualCost(DynamicObject[] infos, Map<Long, Boolean> calByCostElementMap) {
        ArrayList<Object[]> actualParamList = new ArrayList<Object[]>(1024);
        Long[] materialDefualtElements = CostElementHelper.getDefaultMaterialElements();
        Map<String, Long[]> subElementTypeMap = this.getDefaultSubElementTypeMap();
        Set notUpdBalBizType = CommonSettingHelper.getNotUpdBalBizType();
        for (DynamicObject info : infos) {
            long costAccountId = info.getLong("costaccount_id");
            boolean calByCostElement = calByCostElementMap.get(costAccountId);
            boolean notUpdBal = notUpdBalBizType.contains(info.getLong("biztype_id"));
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            Long costTypeId = this.bill2CosttypeMap.get(info.getLong("id"));
            costTypeId = costTypeId == null ? Long.valueOf(0L) : costTypeId;
            for (DynamicObject entry : entrys) {
                BigDecimal actualCost = entry.getBigDecimal("materialcost");
                BigDecimal unitActualCost = entry.getBigDecimal("unitmaterialcost");
                long entryId = entry.getLong("id");
                long materialId = entry.getLong("material_id");
                Long[] subEleEle = this.materialCostElementMap.get(costTypeId + "|" + materialId);
                subEleEle = subEleEle == null ? materialDefualtElements : subEleEle;
                Long materialCostSubElement = subEleEle[0];
                Long materialCostElement = subEleEle[1];
                if (!calByCostElement) {
                    materialCostSubElement = materialDefualtElements[0];
                    materialCostElement = materialDefualtElements[1];
                    actualCost = entry.getBigDecimal("actualcost");
                    unitActualCost = entry.getBigDecimal("unitactualcost");
                    actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, materialCostElement, materialCostSubElement});
                    continue;
                }
                this.syncSubEleActCost(actualParamList, subElementTypeMap, entry, entryId);
                if (notUpdBal) {
                    Long[] outSourceProcessElements = CostElementHelper.getOutSourceProcessElements();
                    actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, outSourceProcessElements[1], outSourceProcessElements[0]});
                    continue;
                }
                actualParamList.add(new Object[]{unitActualCost, actualCost, entryId, materialCostElement, materialCostSubElement});
            }
        }
        this.cacheDetailDyc();
        for (Object[] param : actualParamList) {
            Object unitActCost = param[0];
            Object actCost = param[1];
            Object entryId = param[2];
            Object subEle = param[4];
            DynamicObject detailDyc = this.entryDetailMap.get(entryId + "," + subEle);
            detailDyc.set("sub_unitactualcost", unitActCost);
            detailDyc.set("sub_actualcost", actCost);
        }
    }

    public void handleActualCostZero(DynamicObject[] infos, Map<Long, Boolean> calByCostElementMap) {
        HashSet<Long> invschemeIds = new HashSet<Long>(16);
        for (DynamicObject info : infos) {
            Long invscheme = this.getBaseId(info, "invscheme");
            invschemeIds.add(invscheme);
        }
        HashMap<Long, Boolean> invschemeMap = new HashMap<Long, Boolean>();
        DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_invscheme", (String)"id,zerocost", (QFilter[])new QFilter[]{new QFilter("id", "in", invschemeIds)}, null);
        for (Row row : rows) {
            invschemeMap.put(row.getLong("id"), row.getBoolean("zerocost"));
        }
        for (DynamicObject info : infos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            Long invscheme = this.getBaseId(info, "invscheme");
            boolean zerocost = (Boolean)invschemeMap.get(invscheme);
            String queuetype = info.getString("calbilltype");
            for (DynamicObject entry : entrys) {
                boolean ispresent = entry.getBoolean("ispresent");
                if (!zerocost && (!"IN".equals(queuetype) || !ispresent)) continue;
                entry.set("actualcost", (Object)BigDecimal.ZERO);
                entry.set("unitactualcost", (Object)BigDecimal.ZERO);
                entry.set("unitmaterialcost", (Object)BigDecimal.ZERO);
                entry.set("materialcost", (Object)BigDecimal.ZERO);
                entry.set("unitfee", (Object)BigDecimal.ZERO);
                entry.set("fee", (Object)BigDecimal.ZERO);
                entry.set("unitprocesscost", (Object)BigDecimal.ZERO);
                entry.set("processcost", (Object)BigDecimal.ZERO);
                entry.set("unitmanufacturecost", (Object)BigDecimal.ZERO);
                entry.set("manufacturecost", (Object)BigDecimal.ZERO);
                entry.set("unitresource", (Object)BigDecimal.ZERO);
                entry.set("resource", (Object)BigDecimal.ZERO);
                DynamicObjectCollection detailDycs = entry.getDynamicObjectCollection("subentrycostelement");
                for (DynamicObject detailDyc : detailDycs) {
                    detailDyc.set("sub_unitactualcost", (Object)BigDecimal.ZERO);
                    detailDyc.set("sub_actualcost", (Object)BigDecimal.ZERO);
                }
            }
        }
    }

    private void handleStandardCost(DynamicObject[] infos, Map<String, Set<DynamicObject>> calOrgCostTypeMap, boolean calByCostElement, Map<String, Set<DynamicObject>> storageOrgCostTypeMap, Map<String, Long[]> materialCostElementMap) {
        HashMap<Long, DynamicObject> costTypeAccountMap;
        Map billCostTypeMap;
        HashMap<Long, Long> entryMatCostIdMap;
        HashMap<String, Object[]> entryStandardCostMap;
        block75: {
            Object billDs;
            entryStandardCostMap = new HashMap<String, Object[]>(1024);
            entryMatCostIdMap = new HashMap<Long, Long>(1024);
            if (infos == null) {
                return;
            }
            this.cacheDetailDyc();
            Set costTypeSet = CostTypeHelper.getCostTypeByOrgAndBookDate((DynamicObject[])infos, (String[])new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "accounttype", "bookdate"}, this.noCostTypeErrMap, (int)0);
            if (costTypeSet.isEmpty()) {
                return;
            }
            billCostTypeMap = CostTypeHelper.getCostTypeByBillAndBookDate((DynamicObject[])infos, (String[])new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "bookdate"}, (int)0);
            RowMeta rowMeta = new RowMeta(new Field[]{new Field("entryid", (DataType)DateType.LongType), new Field("costtype", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType), new Field("auditdate", (DataType)DateType.TimestampType), new Field("bookdate", (DataType)DateType.TimestampType)});
            DataSetBuilder billMatCostDataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
            costTypeAccountMap = new HashMap<Long, DynamicObject>(16);
            HashMap paramsMap = new HashMap(16);
            Set calDimensionSet = StandardCostHelper.getCalDimensionSet((String)CommonSettingHelper.getCalDimensionStr());
            for (DynamicObject dynamicObject : infos) {
                Object calOrgCostType2;
                Set<DynamicObject> calOrgCostTypeSet;
                Long l = this.getBaseId(dynamicObject, "invscheme");
                Long bizType = this.getBaseId(dynamicObject, "biztype");
                if (!this.notUpdBalBizTypeIdSet.contains(bizType) && !this.isCalInvSchemeIds.contains(l)) continue;
                Date auditdate = dynamicObject.getDate("auditdate");
                Date bookdate = dynamicObject.getDate("bookdate");
                bookdate = CostRecordCostHandle.getStandardCostDate(auditdate, bookdate);
                Long calOrgId = dynamicObject.getLong("calorg_id");
                Boolean isGetStdCost = this.getSysParamsIsGetStdCost(calOrgId);
                Long costAccountId = dynamicObject.getLong("costaccount_id");
                Long storageorgunitId = dynamicObject.getLong("storageorgunit_id");
                String paramKey = calOrgId + "_" + costAccountId;
                Boolean enableStdCost = this.enableStandCostMap.get(costAccountId);
                String storageOrgKey = dynamicObject.getString("costaccount_id") + "@" + dynamicObject.getLong("storageorgunit_id");
                String calOrgKey = dynamicObject.getString("costaccount_id") + "@" + dynamicObject.getLong("calorg_id");
                Object costTypeInfo = null;
                Set<DynamicObject> storageOrgCostTypeSet = storageOrgCostTypeMap.get(storageOrgKey);
                if (storageOrgCostTypeSet != null && !storageOrgCostTypeSet.isEmpty()) {
                    for (DynamicObject dynamicObject2 : storageOrgCostTypeSet) {
                        if (!dynamicObject2.getDate("effectdate").before(bookdate) || !dynamicObject2.getDate("invaliddate").after(bookdate)) continue;
                        costTypeInfo = dynamicObject2;
                        break;
                    }
                }
                if (costTypeInfo == null && (calOrgCostTypeSet = calOrgCostTypeMap.get(calOrgKey)) != null && !calOrgCostTypeSet.isEmpty()) {
                    for (Object calOrgCostType2 : calOrgCostTypeSet) {
                        if (!calOrgCostType2.getDate("effectdate").before(bookdate) || !calOrgCostType2.getDate("invaliddate").after(bookdate)) continue;
                        costTypeInfo = calOrgCostType2;
                        break;
                    }
                }
                if (costTypeInfo == null) continue;
                costTypeAccountMap.put(dynamicObject.getLong("costaccount_id"), (DynamicObject)costTypeInfo);
                Long costTypeId = costTypeInfo.getLong("costtype.id");
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entry");
                calOrgCostType2 = dynamicObjectCollection.iterator();
                while (calOrgCostType2.hasNext()) {
                    ArrayList params;
                    DynamicObject entry = (DynamicObject)calOrgCostType2.next();
                    Long invtype = entry.getLong("invtype_id");
                    if (!this.notUpdBalBizTypeIdSet.contains(bizType) && !this.isCalInvTypeIds.contains(invtype)) continue;
                    String accountType = entry.getString("accounttype");
                    if (!enableStdCost.booleanValue() && !AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) && !isGetStdCost.booleanValue()) continue;
                    HashMap<String, Object> param = new HashMap<String, Object>(16);
                    Long entryId = entry.getLong("id");
                    Long materialId = entry.getLong("material_id");
                    String noupdatecalfields = entry.getString("noupdatecalfields");
                    param.put("uniqueID", entryId);
                    param.put("invorg", storageorgunitId);
                    param.put("date", bookdate);
                    param.put("material", materialId);
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
                    if (calDimensionSet != null && calDimensionSet.size() > 0) {
                        for (String calDimension : calDimensionSet) {
                            if (StringUtils.isNotEmpty((String)noupdatecalfields) && noupdatecalfields.contains(calDimension)) continue;
                            Object value = entry.get(calDimension);
                            IDataEntityProperty property = dataEntityType.findProperty(calDimension);
                            if (null == property) continue;
                            if (property instanceof BasedataProp) {
                                value = this.getBaseId(entry, calDimension);
                            }
                            if (value != null) {
                                if (value instanceof DynamicObject) {
                                    param.put(calDimension, ((DynamicObject)value).getPkValue());
                                    continue;
                                }
                                param.put(calDimension, value);
                                continue;
                            }
                            param.put(calDimension, 0L);
                        }
                    }
                    if (null == (params = (ArrayList)paramsMap.get(paramKey)) || params.size() == 0) {
                        params = new ArrayList(16);
                        params.add(param);
                        paramsMap.put(paramKey, params);
                    } else {
                        params.add(param);
                    }
                    billMatCostDataSetBuilder.append(new Object[]{entryId, costTypeId, materialId, auditdate, bookdate});
                }
            }
            if (calByCostElement) {
                try (DataSet dataSet = new StandardCostHelper().getStandardCost(paramsMap, false);){
                    billDs = billMatCostDataSetBuilder.build();
                    Throwable throwable = null;
                    try {
                        DataSet dataSet2 = billDs.join(dataSet, JoinType.INNER).on("entryid", "entryid").select(new String[]{"entryid", "material", "auditdate", "bookdate"}, new String[]{"effectdate", "expdate", "element", "subelement", "standardprice", "id"}).finish().where("effectdate <= bookdate and expdate > bookdate");
                        for (Object row : dataSet2) {
                            long costElementId = row.getLong("element");
                            long costSubElementId = row.getLong("subelement");
                            BigDecimal unitStandardcost = row.getBigDecimal("standardprice");
                            Long entryId = row.getLong("entryid");
                            String entryMatSubKey = entryId + "|" + costElementId + "|" + costSubElementId;
                            entryStandardCostMap.put(entryMatSubKey, new Object[]{unitStandardcost});
                            Long matCostId = row.getLong("id");
                            entryMatCostIdMap.put(entryId, matCostId);
                        }
                        break block75;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (billDs != null) {
                            if (throwable != null) {
                                try {
                                    billDs.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                billDs.close();
                            }
                        }
                    }
                }
            }
            Long[] defaultMaterialElements = CostElementHelper.getDefaultMaterialElements();
            DataSet dataSet = new StandardCostHelper().getStandardCost(paramsMap, false);
            billDs = null;
            try {
                Throwable throwable = null;
                try (DataSet dataSet3 = billMatCostDataSetBuilder.build();){
                    DataSet matCostDs3 = dataSet3.join(dataSet, JoinType.INNER).on("entryid", "entryid").select(new String[]{"entryid", "costtype", "material", "auditdate", "bookdate"}, new String[]{"effectdate", "expdate", "standardprice", "id"}).finish().where("effectdate <= bookdate and expdate > bookdate");
                    matCostDs3 = matCostDs3.groupBy(new String[]{"entryid", "costtype", "material", "id"}).sum("standardprice").finish();
                    for (Row row : matCostDs3) {
                        long costSubElementId = defaultMaterialElements[0];
                        long costElementId = defaultMaterialElements[1];
                        BigDecimal unitStandardcost = row.getBigDecimal("standardprice");
                        if (unitStandardcost == null) {
                            unitStandardcost = BigDecimal.ZERO;
                        }
                        Long entryId = row.getLong("entryid");
                        String entryMatSubKey = entryId + "|" + costElementId + "|" + costSubElementId;
                        entryStandardCostMap.put(entryMatSubKey, new Object[]{unitStandardcost});
                        Long matCostId = row.getLong("id");
                        entryMatCostIdMap.put(entryId, matCostId);
                    }
                }
                catch (Throwable matCostDs3) {
                    Throwable throwable4 = matCostDs3;
                    throw matCostDs3;
                }
            }
            catch (Throwable throwable) {
                billDs = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (billDs != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)billDs).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1024);
        Set notUpdBalBizTypes = CommonSettingHelper.getNotUpdBalBizType();
        HashSet<Long> allStdCostZeroMatIds = new HashSet<Long>(16);
        for (DynamicObject info : infos) {
            Long invscheme = this.getBaseId(info, "invscheme");
            Long bizType = this.getBaseId(info, "biztype");
            if (!this.notUpdBalBizTypeIdSet.contains(bizType) && !this.isCalInvSchemeIds.contains(invscheme)) continue;
            Long calOrgId = info.getLong("calorg_id");
            Boolean isGetStdCost = this.getSysParamsIsGetStdCost(calOrgId);
            Long costAccountId = info.getLong("costaccount_id");
            Boolean enableStdCost = this.enableStandCostMap.get(costAccountId);
            Date auditdate = info.getDate("auditdate");
            Date bookdate = info.getDate("bookdate");
            bookdate = CostRecordCostHandle.getStandardCostDate(auditdate, bookdate);
            boolean notUpdBalance = notUpdBalBizTypes.contains(info.getLong("biztype_id"));
            HashMap<Long, Map<Long, Set<Long>>> bizBillIdCostTypeMatIdsMap = new HashMap<Long, Map<Long, Set<Long>>>(16);
            HashSet<Long> costTypeIds = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : info.getDynamicObjectCollection("entry")) {
                Long invtype = dynamicObject.getLong("invtype_id");
                if (!this.notUpdBalBizTypeIdSet.contains(bizType) && !this.isCalInvTypeIds.contains(invtype)) continue;
                String accountType = dynamicObject.getString("accounttype");
                if (!enableStdCost.booleanValue() && !AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) && !isGetStdCost.booleanValue()) continue;
                int amtPrecision = costTypeAccountMap.get(costAccountId) == null ? 6 : ((DynamicObject)costTypeAccountMap.get(costAccountId)).getInt("costtype.currency.amtprecision");
                long costTypeId = (Long)billCostTypeMap.get(info.getLong("id"));
                costTypeIds.add(costTypeId);
                long entryId = dynamicObject.getLong("id");
                List<DynamicObject> detailList = this.detailMap.get(entryId);
                if (detailList == null) continue;
                boolean stdAmtHasNotZero = false;
                for (DynamicObject detail : detailList) {
                    long costElementId = detail.getLong("costelement_id");
                    long costSubElementId = detail.getLong("costsubelement_id");
                    String subEleType = this.subElesTypeMap.get(costSubElementId);
                    BigDecimal standardcost = BigDecimal.ZERO;
                    BigDecimal[] unitStdCost = new BigDecimal[]{BigDecimal.ZERO};
                    if (notUpdBalance) {
                        if (!"005".equals(subEleType)) continue;
                        standardcost = this.getStdCost(entryStandardCostMap, paramList, amtPrecision, costTypeId, bookdate, dynamicObject, costElementId, costSubElementId, unitStdCost);
                        this.handleEntryStd(entryId, detail, costSubElementId, subEleType, standardcost, true);
                    } else {
                        standardcost = this.getStdCost(entryStandardCostMap, paramList, amtPrecision, costTypeId, bookdate, dynamicObject, costElementId, costSubElementId, unitStdCost);
                        this.handleEntryStd(entryId, detail, costSubElementId, subEleType, standardcost, false);
                    }
                    if (unitStdCost[0].compareTo(BigDecimal.ZERO) == 0) continue;
                    stdAmtHasNotZero = true;
                }
                if (stdAmtHasNotZero || notUpdBalance) continue;
                long matId = dynamicObject.getLong("material_id");
                allStdCostZeroMatIds.add(matId);
                Long bizBillId = info.getLong("bizbillid");
                bizBillIdCostTypeMatIdsMap.putIfAbsent(bizBillId, new HashMap(16));
                Map costTypeMatIdsMap = (Map)bizBillIdCostTypeMatIdsMap.get(bizBillId);
                costTypeMatIdsMap.putIfAbsent(costTypeId, new HashSet(16));
                ((Set)costTypeMatIdsMap.get(costTypeId)).add(matId);
            }
            this.checkAllStdCostZero(allStdCostZeroMatIds, bizBillIdCostTypeMatIdsMap, costTypeIds);
        }
        for (Object[] objectArray : paramList) {
            Object unitStdCost = objectArray[0];
            Object stdCost = objectArray[1];
            Object entryId = objectArray[2];
            Object subEle = objectArray[4];
            DynamicObject detailDyc = this.entryDetailMap.get(entryId + "," + subEle);
            detailDyc.set("sub_unitstandardcost", unitStdCost);
            detailDyc.set("sub_standardcost", stdCost);
        }
        if (!entryMatCostIdMap.isEmpty()) {
            for (Map.Entry entry : entryMatCostIdMap.entrySet()) {
                Long entryid = (Long)entry.getKey();
                Long matCostId = (Long)entry.getValue();
                DynamicObject entryDy = this.entryMap.get(entryid);
                if (entryDy == null) continue;
                entryDy.set("matcostid", (Object)matCostId);
                String costpricesource = entryDy.getString("costpricesource");
                costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource);
                String bizEntityObject = this.entrybizEntityObjectMap.get(entryid);
                if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)costpricesource) || !StringUtils.isEmpty((String)costpricesource) && costpricesource.contains(CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue())) continue;
                entryDy.set("costpricesource", (Object)CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.STAND_COST_SPECIFICATION.getValue()));
                entryDy.set("designatedcost", (Object)CostPriceSourceTypeEnum.STAND_COST_SPECIFICATION.getDesignated());
            }
        }
    }

    private Long getBaseId(DynamicObject info, String baseIdKey) {
        Long baseId = info.getLong(baseIdKey + "_id");
        Object baseIdObj = info.get(baseIdKey);
        if (baseIdObj instanceof Long && !baseIdObj.equals(0L)) {
            baseId = (Long)baseIdObj;
        }
        return baseId;
    }

    private void cacheDetailDyc() {
        DynamicObjectCollection detailColl = new DynamicObjectCollection();
        for (DynamicObject recDyc : this.recordDycs) {
            DynamicObjectCollection entryDycs = recDyc.getDynamicObjectCollection("entry");
            for (DynamicObject entryDyc : entryDycs) {
                Long entryId = entryDyc.getLong("id");
                this.entryMap.put(entryId, entryDyc);
                DynamicObjectCollection subEntryDycs = entryDyc.getDynamicObjectCollection("subentrycostelement");
                detailColl.addAll((Collection)subEntryDycs);
            }
        }
        int cSize = detailColl.size();
        this.detailMap = new HashMap<Long, List<DynamicObject>>(cSize);
        for (DynamicObject detail : detailColl) {
            long entryId = (Long)((DynamicObject)detail.getParent()).getPkValue();
            if (this.detailMap.containsKey(entryId)) {
                this.detailMap.get(entryId).add(detail);
            } else {
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
                list.add(detail);
                this.detailMap.put(entryId, list);
            }
            this.entryDetailMap.put(entryId + "," + detail.getLong("costsubelement_id"), detail);
        }
    }

    private void checkAllStdCostZero(Set<Long> allStdCostZeroMatIds, Map<Long, Map<Long, Set<Long>>> bizBillIdCostTypeMatIdsMap, Set<Long> costTypeIds) {
        QFilter materialFilter = new QFilter("id", "in", allStdCostZeroMatIds);
        HashMap<Long, String> materialNumMap = new HashMap<Long, String>(16);
        try (DataSet materialDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_material", (String)"id,number", (QFilter[])materialFilter.toArray(), null);){
            for (Row row : materialDS) {
                Long matId = row.getLong("id");
                String string = row.getString("number");
                materialNumMap.put(matId, string);
            }
        }
        HashMap<Long, String> costTypeNameMap = new HashMap<Long, String>(16);
        HashMap<Long, String> costTypeNumMap = new HashMap<Long, String>(16);
        for (Map.Entry<Long, Map<Long, Set<Long>>> bizBillMapEntry : bizBillIdCostTypeMatIdsMap.entrySet()) {
            Map<Long, Set<Long>> costTypeMatIdsMap = bizBillMapEntry.getValue();
            for (Map.Entry<Long, Set<Long>> entry : costTypeMatIdsMap.entrySet()) {
                Long costtypeId = entry.getKey();
                costTypeIds.add(costtypeId);
            }
        }
        QFilter costTypef = new QFilter("id", "in", costTypeIds);
        DataSet costTypeDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_costtype", (String)"id,name,number", (QFilter[])costTypef.toArray(), null);
        Object object = null;
        try {
            for (Row row : costTypeDs) {
                Long costType = row.getLong("id");
                String name = row.getString("name");
                String number = row.getString("number");
                costTypeNameMap.put(costType, name);
                costTypeNumMap.put(costType, number);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (costTypeDs != null) {
                if (object != null) {
                    try {
                        costTypeDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    costTypeDs.close();
                }
            }
        }
        HashSet<String> materialNames = new HashSet<String>(16);
        for (Map.Entry entry : bizBillIdCostTypeMatIdsMap.entrySet()) {
            Long l = (Long)entry.getKey();
            Map costTypeMatIdsMap = (Map)entry.getValue();
            StringBuilder msg = new StringBuilder();
            for (Map.Entry mapEntry : costTypeMatIdsMap.entrySet()) {
                String errorMsg;
                Long costtypeId = (Long)mapEntry.getKey();
                Set materialIds = (Set)mapEntry.getValue();
                String costTypeName = (String)costTypeNameMap.get(costtypeId);
                String costTypeNum = (String)costTypeNumMap.get(costtypeId);
                costTypeNum = costTypeNum == null ? "" : costTypeNum;
                costTypeName = costTypeName == null ? "" : costTypeName;
                materialNames.clear();
                for (Long matId : materialIds) {
                    String materialNum = (String)materialNumMap.get(matId);
                    materialNames.add("\u3010" + materialNum + "\u3011");
                }
                if (materialNames.isEmpty()) continue;
                if (null == costtypeId || costtypeId == 0L) {
                    errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u7684\u5355\u636e\u5bf9\u5e94\u7684\u6210\u672c\u8d26\u7c3f\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u201c\u5b58\u8d27\u6838\u7b97>\u57fa\u7840\u914d\u7f6e>\u6838\u7b97\u914d\u7f6e>\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\u201d\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"SyncBizBill4AuditServiceProcess_32", (String)"fi-cal-business", (Object[])new Object[0]), String.join((CharSequence)",", materialNames));
                    msg.append(errorMsg);
                    continue;
                }
                errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u4e0e\u6210\u672c\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\uff0c\u5bf9\u5e94\u5b50\u8981\u7d20\u7684\u6807\u51c6\u6210\u672c\u90fd\u4e3a0\u3002", (String)"SyncBizBill4AuditServiceProcess_31", (String)"fi-cal-business", (Object[])new Object[0]), String.join((CharSequence)",", materialNames), costTypeNum + " [" + costTypeName + "]");
                msg.append(errorMsg);
            }
            this.errMap.putIfAbsent(l, new SynBillErrInfo("3", msg.toString()));
        }
    }

    private void cacheInvSchemeAndInvTypeInfos() {
        DynamicObject[] invTypeDycs;
        DynamicObject[] invSchemeDycs;
        QFilter invSchemeFilter = new QFilter("isforwardamount", "=", (Object)true);
        for (DynamicObject dynamicObject : invSchemeDycs = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"im_invscheme"), (QFilter[])invSchemeFilter.toArray()).values().toArray(new DynamicObject[0])) {
            this.isCalInvSchemeIds.add(dynamicObject.getLong("id"));
        }
        QFilter invTypeFilter = new QFilter("isforwardamount", "=", (Object)true);
        for (DynamicObject dynamicObject : invTypeDycs = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_invtype"), (QFilter[])invTypeFilter.toArray()).values().toArray(new DynamicObject[0])) {
            this.isCalInvTypeIds.add(dynamicObject.getLong("id"));
        }
    }

    public static Date getStandardCostDate(Date auditdate, Date bookdate) {
        if (null == auditdate || null == bookdate) {
            return auditdate;
        }
        if (DateUtils.isTheSameDay((Date)auditdate, (Date)bookdate)) {
            bookdate = DateUtils.getDayStartTime((Date)bookdate);
            int hour = DateUtils.getIntByDate((Date)auditdate, (int)11);
            int minute = DateUtils.getIntByDate((Date)auditdate, (int)12);
            int second = DateUtils.getIntByDate((Date)auditdate, (int)13);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(bookdate);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            bookdate = calendar.getTime();
        } else {
            bookdate = DateUtils.getDayEndTime((Date)bookdate);
        }
        return bookdate;
    }

    private Boolean getSysParamsIsGetStdCost(Long calOrgId) {
        Boolean result = this.calOrgIdIsGetStdCostMap.get(calOrgId);
        if (result == null) {
            result = (Boolean)ParamsHelper.getAppParam((long)calOrgId, (String)"isgetstdcost");
            this.calOrgIdIsGetStdCostMap.put(calOrgId, result);
        }
        return result;
    }

    private void cacheAcctEnableStandCostMap(DynamicObject[] recordDycs) {
        DynamicObject[] costAccountDycs;
        HashSet<Object> costAccountIds = new HashSet<Object>(16);
        for (DynamicObject info : recordDycs) {
            costAccountIds.add(info.get("costaccount_id"));
            String bizentityobject = info.getString("bizentityobject_id");
            DynamicObjectCollection entryDycs = info.getDynamicObjectCollection("entry");
            for (DynamicObject entryDyc : entryDycs) {
                Long entryId = entryDyc.getLong("id");
                String costpricesource = entryDyc.getString("costpricesource");
                costpricesource = CostPriceSourceTypeEnum.getLastByCostPriceSource((String)costpricesource);
                this.entrybizEntityObjectMap.put(entryId, bizentityobject);
                this.entryBizCostPriceSourceMap.put(entryId, costpricesource);
            }
        }
        QFilter acctf = new QFilter("id", "in", costAccountIds);
        for (DynamicObject costAccountDyc : costAccountDycs = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cal_bd_costaccount"), (QFilter[])acctf.toArray()).values().toArray(new DynamicObject[0])) {
            Long id = costAccountDyc.getLong("id");
            Boolean enableStandCost = costAccountDyc.getBoolean("enablestandardcost");
            this.enableStandCostMap.put(id, enableStandCost);
        }
    }

    private BigDecimal getStdCost(Map<String, Object[]> entryStandardCostMap, List<Object[]> paramList, int amtPrecision, long costTypeId, Date bookdate, DynamicObject entry, long costElementId, long costSubElementId, BigDecimal[] unitStdCost) {
        BigDecimal standardcost = BigDecimal.ZERO;
        BigDecimal unitStandardCost = BigDecimal.ZERO;
        long entryId = entry.getLong("id");
        String entryMatSubKey = entryId + "|" + costElementId + "|" + costSubElementId;
        if (entryStandardCostMap.containsKey(entryMatSubKey)) {
            unitStandardCost = (BigDecimal)entryStandardCostMap.get(entryMatSubKey)[0];
            if (unitStandardCost == null) {
                unitStandardCost = BigDecimal.ZERO;
            }
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            standardcost = unitStandardCost.multiply(baseQty).setScale(amtPrecision, 4);
            unitStdCost[0] = unitStandardCost;
        }
        paramList.add(new Object[]{unitStandardCost, standardcost, entryId, costElementId, costSubElementId});
        return standardcost;
    }

    private void handleEntryStd(long entryId, DynamicObject detail, long costSubElementId, String subEleType, BigDecimal standardcost, boolean notUpdBalance) {
        String gatherSubEle = "001";
        if (notUpdBalance) {
            gatherSubEle = "005";
        }
        if (gatherSubEle.equals(subEleType)) {
            BigDecimal matEleAmount = this.entryMatEleStdAmtMap.get(entryId);
            if (matEleAmount != null) {
                this.entryMatEleStdAmtMap.put(entryId, matEleAmount.add(standardcost));
            } else {
                this.entryMatEleStdAmtMap.put(entryId, standardcost);
            }
            this.entryMatSubElesMap.putIfAbsent(entryId, new HashSet(16));
            this.entryMatSubElesMap.get(entryId).add(costSubElementId);
        } else if (!notUpdBalance) {
            this.entryNotMatSubElesMap.putIfAbsent(entryId, new HashSet(16));
            this.entryNotMatSubElesMap.get(entryId).add(costSubElementId);
        }
    }

    private Map<String, Long[]> getDefaultSubElementTypeMap() {
        HashMap<String, Long[]> subElementTypeMap = new HashMap<String, Long[]>(16);
        QFilter defaultf = new QFilter("defaultvalue", "=", (Object)Boolean.TRUE);
        QFilter subTypef = new QFilter("type", "in", (Object)new String[]{"002", "005"});
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cad_subelement", (String)"id,type", (QFilter[])new QFilter[]{defaultf, subTypef, q}, null);
        DataSet detailDs = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"element,subelement", null, null);
        try (DataSet subElementTypeDs = subElementDs.join(detailDs).on("id", "subelement").select(new String[]{"id", "type"}, new String[]{"element"}).finish();){
            for (Row row : subElementTypeDs) {
                subElementTypeMap.put(row.getString("type"), new Long[]{row.getLong("id"), row.getLong("element")});
            }
        }
        return subElementTypeMap;
    }

    private void syncSubEleActCost(List<Object[]> actualParamList, Map<String, Long[]> subElementTypeMap, DynamicObject entry, long entryId) {
        Object[] processSubElement;
        Long[] feeSubElement;
        BigDecimal feeCost = entry.getBigDecimal("fee");
        BigDecimal feeUnitActualCost = entry.getBigDecimal("unitfee");
        if (feeCost.compareTo(BigDecimal.ZERO) != 0 && (feeSubElement = subElementTypeMap.get("002")) != null) {
            actualParamList.add(new Object[]{feeUnitActualCost, feeCost, entryId, feeSubElement[1], feeSubElement[0]});
        }
        BigDecimal processCost = entry.getBigDecimal("processcost");
        BigDecimal processUnitActualCost = entry.getBigDecimal("unitprocesscost");
        if (processUnitActualCost.compareTo(BigDecimal.ZERO) != 0 && (processSubElement = (Object[])subElementTypeMap.get("005")) != null) {
            actualParamList.add(new Object[]{processUnitActualCost, processCost, entryId, processSubElement[1], processSubElement[0]});
        }
    }

    private boolean matZeroStd2Act(List<Object[]> matStd2ActParamList, String entityNum, BigDecimal actualCost, long entryId) {
        boolean setStd2Act;
        boolean isUpdateFlag = false;
        if (this.purOutSourceBills.contains(entityNum)) {
            return false;
        }
        BigDecimal matEleAmt = this.entryMatEleStdAmtMap.get(entryId);
        boolean matStdEqualAct = matEleAmt != null && actualCost.compareTo(matEleAmt) == 0;
        Set<Long> notMatSubEles = this.entryNotMatSubElesMap.get(entryId);
        boolean actAmtZero = actualCost.compareTo(BigDecimal.ZERO) == 0;
        boolean bl = setStd2Act = matStdEqualAct || actAmtZero;
        if (setStd2Act && notMatSubEles != null) {
            for (Long notMatSubEle : notMatSubEles) {
                matStd2ActParamList.add(new Object[]{entryId, notMatSubEle});
                isUpdateFlag = true;
            }
        }
        Set<Long> matSubEles = this.entryMatSubElesMap.get(entryId);
        if (actAmtZero && matSubEles != null) {
            for (Long matSubEle : matSubEles) {
                matStd2ActParamList.add(new Object[]{entryId, matSubEle});
                isUpdateFlag = true;
            }
        }
        return isUpdateFlag;
    }

    public void setErrMap(Map<Long, SynBillErrInfo> errMap) {
        this.errMap = errMap;
    }

    public Map<Long, SynBillErrInfo> getErrMap() {
        return this.errMap;
    }

    private void cacheSubElesType() {
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        Map subEleDycs = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_subelement"), (QFilter[])new QFilter[]{q});
        for (DynamicObject subEleDyc : subEleDycs.values()) {
            this.subElesTypeMap.put((Long)subEleDyc.getPkValue(), subEleDyc.getString("type"));
        }
    }

    public Map<Long, SynBillErrInfo> getNoCostTypeErrMap() {
        return this.noCostTypeErrMap;
    }

    private boolean handleCostPriceScheme(Map<Long, Set<DynamicObject>> costRecordMap, Map<Long, String> entryCostPriceSourceMap, Map<Long, Boolean> calByCostElementMap) {
        DynamicObject[] dynamicObjects;
        boolean isSubmitSave = false;
        if (costRecordMap == null || costRecordMap.isEmpty()) {
            return isSubmitSave;
        }
        Date maxBookDate = null;
        HashSet<Long> calOrgIds = new HashSet<Long>(16);
        HashSet<Long> allCalOrgIds = new HashSet<Long>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashMap<Long, BigDecimal> entryBaseQtyMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, Integer> entryAmtPrecision = new HashMap<Long, Integer>(16);
        HashMap<Long, String> entryIdCostPriceSorceStrMap = new HashMap<Long, String>(16);
        for (Map.Entry<Long, Set<DynamicObject>> mapEntry : costRecordMap.entrySet()) {
            Long bizBillId = mapEntry.getKey();
            Set<DynamicObject> infos = mapEntry.getValue();
            for (DynamicObject info : infos) {
                long orgId = info.getLong("calorg_id");
                Date bookDate = info.getDate("bookdate");
                if (maxBookDate == null || bookDate.after(maxBookDate)) {
                    maxBookDate = bookDate;
                }
                if (allCalOrgIds.add(orgId)) {
                    boolean isGetPrice = (Boolean)ParamsHelper.getAppParam((long)orgId, (String)"isgetprice");
                    if (isGetPrice) {
                        calOrgIds.add(orgId);
                        bizBillIds.add(bizBillId);
                    }
                } else if (calOrgIds.contains(orgId)) {
                    bizBillIds.add(bizBillId);
                }
                int amtPrecision = info.getInt("localcurrency.amtprecision");
                for (DynamicObject entryrow : info.getDynamicObjectCollection("entry")) {
                    entryBaseQtyMap.put(entryrow.getLong("id"), entryrow.getBigDecimal("baseqty"));
                    entryAmtPrecision.put(entryrow.getLong("id"), amtPrecision);
                    entryIdCostPriceSorceStrMap.put(entryrow.getLong("id"), entryrow.getString("costpricesource"));
                }
            }
        }
        if (calOrgIds.isEmpty()) {
            return isSubmitSave;
        }
        if (this.syncPrice && (dynamicObjects = costRecordMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()).toArray(new DynamicObject[0])).length > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            isSubmitSave = true;
        }
        CostPrice4SyncBillHelper helper = new CostPrice4SyncBillHelper(this.bizBillEntityName, this.bizBillEntryKey, bizBillIds, calOrgIds, maxBookDate);
        List<CostPriceResultInfo> resultInfosTemp = helper.getCostPrice();
        ArrayList<CostPriceResultInfo> resultInfos = new ArrayList<CostPriceResultInfo>(16);
        if (resultInfosTemp != null && resultInfosTemp.size() > 0) {
            for (CostPriceResultInfo resultInfo : resultInfosTemp) {
                Long entryId = resultInfo.getEntryId();
                String costpricesource = this.entryBizCostPriceSourceMap.get(entryId);
                String bizEntityObject = this.entrybizEntityObjectMap.get(entryId);
                if (CostPriceSourceTypeHelper.checkDisassemAdjustCostprice((String)bizEntityObject, (String)costpricesource)) continue;
                resultInfos.add(resultInfo);
            }
        }
        helper.updateCostRecordCost(bizBillIds, entryBaseQtyMap, entryAmtPrecision, resultInfos);
        if (resultInfos != null && resultInfos.size() > 0) {
            for (CostPriceResultInfo costPriceResultInfo : resultInfos) {
                Long entryId;
                String costpricesource;
                boolean isUpdateFromExpCalcute;
                boolean isSuccess = costPriceResultInfo.isSuccess();
                if (!isSuccess || (isUpdateFromExpCalcute = CostPriceSourceTypeHelper.isUpdateFromExpCalcute((String)this.auditType, (String)(costpricesource = (String)entryIdCostPriceSorceStrMap.get(entryId = costPriceResultInfo.getEntryId()))))) continue;
                entryCostPriceSourceMap.put(entryId, CostPriceSourceTypeEnum.getCostPriceSourceValue((String)CostPriceSourceTypeEnum.GET_COST_SPECIFICATION.getValue()));
            }
        }
        return isSubmitSave;
    }

    public void setBizBillEntityName(String bizBillEntityName) {
        this.bizBillEntityName = bizBillEntityName;
    }

    public void setBizBillEntryKey(String bizBillEntryKey) {
        this.bizBillEntryKey = bizBillEntryKey;
    }

    private Map<Long, Set<DynamicObject>> getCostRecDycMap() {
        HashMap<Long, Set<DynamicObject>> costRecordMap = new HashMap<Long, Set<DynamicObject>>(16);
        for (DynamicObject item : this.recordDycs) {
            Long bizBillId = item.getLong("bizbillid");
            Set recordDycs = costRecordMap.computeIfAbsent(bizBillId, k -> new HashSet(16));
            recordDycs.add(item);
        }
        return costRecordMap;
    }

    public void setSyncPrice(boolean syncPrice) {
        this.syncPrice = syncPrice;
    }

    private DynamicObject[] reLoadCostRecFromDb(boolean enableSyncPrice, Map<Long, String> entryCostPriceSourceMap) {
        if (enableSyncPrice) {
            ArrayList<Long> costRecIds = new ArrayList<Long>(16);
            for (DynamicObject costRecDyc : this.recordDycs) {
                long costRecId = costRecDyc.getLong("id");
                costRecIds.add(costRecId);
            }
            for (DynamicObject recDyc : this.recordDycs = BusinessDataServiceHelper.load((Object[])costRecIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cal_costrecord_subentity"))) {
                DynamicObjectCollection entryDycs = recDyc.getDynamicObjectCollection("entry");
                for (DynamicObject entryDyc : entryDycs) {
                    Long entryId = entryDyc.getLong("id");
                    String costpricesource = entryCostPriceSourceMap.get(entryId);
                    if (!StringUtils.isNotEmpty((String)costpricesource)) continue;
                    entryDyc.set("costpricesource", (Object)costpricesource);
                    CostPriceSourceTypeEnum costPriceSourceTypeEnum = CostPriceSourceTypeEnum.getEnumByValue((String)costpricesource);
                    if (costPriceSourceTypeEnum == null) continue;
                    entryDyc.set("designatedcost", (Object)costPriceSourceTypeEnum.getDesignated());
                }
            }
        }
        return this.recordDycs;
    }
}

