/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.process.inner;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.cal.common.model.CostAccount;
import kd.fi.cal.common.util.CommonUtils;

public class DealDivideAndDimValueMapFunction
extends MapFunction {
    private static final long serialVersionUID = 1276172570166864321L;
    private final Set<Long> emptyEntryRangeIds;
    Map<Long, Long> accountAndEmptyRangeMap = new HashMap<Long, Long>(16);
    Map<Long, String> rangeAndDivideStr = new HashMap<Long, String>(16);
    Map<Long, String> rangeAndDimenSionStr = new HashMap<Long, String>(16);
    Map<Long, CostAccount> costAccountMap = new HashMap<Long, CostAccount>(16);

    public DealDivideAndDimValueMapFunction(Map<Long, CostAccount> costAccountMap, Set<Long> emptyEntryRangeIds, Map<Long, Long> accountAndEmptyRangeMap, Map<Long, String> rangeAndDivideStr, Map<Long, String> rangeAndDimenSionStr, RowMeta sourceRowMeta) {
        this.costAccountMap = costAccountMap;
        this.emptyEntryRangeIds = emptyEntryRangeIds;
        this.accountAndEmptyRangeMap = accountAndEmptyRangeMap;
        this.rangeAndDivideStr = rangeAndDivideStr;
        this.rangeAndDimenSionStr = rangeAndDimenSionStr;
        this.sourceRowMeta = sourceRowMeta;
    }

    public Object[] map(Row row) {
        RowMeta resultRowMeta = this.getResultRowMeta();
        Object[] newRow = new Object[resultRowMeta.getFieldCount()];
        for (String fieldName : this.sourceRowMeta.getFieldNames()) {
            int fieldIndex = resultRowMeta.getFieldIndex(fieldName);
            newRow[fieldIndex] = row.get(fieldName);
        }
        Long costaccountId = row.getLong("costaccount");
        Long calRangeId = row.getLong("calrange");
        if (calRangeId == null || calRangeId.compareTo(0L) == 0) {
            calRangeId = this.accountAndEmptyRangeMap.get(costaccountId);
            newRow[resultRowMeta.getFieldIndex((String)"calrange")] = calRangeId;
        }
        if (calRangeId == null) {
            calRangeId = 0L;
        }
        String divideStr = this.rangeAndDivideStr.get(calRangeId);
        String calDimStr = this.rangeAndDimenSionStr.get(calRangeId);
        String divideValueKey = "";
        String calDimValueKey = "";
        if (divideStr != null && !"".equals(divideStr)) {
            String[] divFields = divideStr.split(",");
            if (!this.emptyEntryRangeIds.contains(calRangeId)) {
                for (int i = 0; i < divFields.length; ++i) {
                    Object defaultValue;
                    String div = divFields[i];
                    int fieldIndex = resultRowMeta.getFieldIndex(div);
                    newRow[fieldIndex] = defaultValue = this.getDeFaultValue(resultRowMeta, div);
                }
            } else {
                divideValueKey = this.getDivAndDimKeyStr(divFields, row);
            }
        }
        if (calDimStr != null && !"".equals(calDimStr)) {
            String[] calDims = calDimStr.split(",");
            calDimValueKey = this.getDivAndDimKeyStr(calDims, row);
        }
        HashSet<String> fieldNamesSet = new HashSet<String>(16);
        for (String fieldName : this.sourceRowMeta.getFieldNames()) {
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            fieldNamesSet.add(fieldName);
        }
        String matCalDimValue = this.getMatCalDimValue(costaccountId, calRangeId, row, fieldNamesSet);
        if (!StringUtils.isEmpty((CharSequence)matCalDimValue)) {
            calDimValueKey = matCalDimValue;
        }
        newRow[resultRowMeta.getFieldIndex((String)"dividevalue")] = divideValueKey;
        newRow[resultRowMeta.getFieldIndex((String)"caldimvalue")] = calDimValueKey;
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.sourceRowMeta;
        return sourceRowMeta;
    }

    private Object getDeFaultValue(RowMeta resultRowMeta, String field) {
        DataType dataType = resultRowMeta.getField(field).getDataType();
        Object defaultValue = null;
        if (dataType instanceof LongType) {
            defaultValue = 0L;
        } else if (dataType instanceof StringType) {
            defaultValue = "";
        } else if (dataType instanceof IntegerType) {
            defaultValue = 0;
        } else if (dataType instanceof BigDecimalType) {
            defaultValue = BigDecimal.ZERO;
        } else if (dataType instanceof BooleanType) {
            defaultValue = Boolean.TRUE;
        }
        return defaultValue;
    }

    private String getDivAndDimKeyStr(String[] fields, Row row) {
        StringBuilder valueKeyBuild = new StringBuilder();
        valueKeyBuild.append("");
        for (int i = 0; i < fields.length; ++i) {
            String valueStr;
            String div = fields[i];
            Object value = row.get(div);
            if (value == null || StringUtils.isEmpty((CharSequence)(valueStr = String.valueOf(value)))) continue;
            valueKeyBuild.append(valueStr);
            valueKeyBuild.append(",");
        }
        return CommonUtils.trimComma((String)valueKeyBuild.toString());
    }

    private String getMatCalDimValue(Long costaccountId, Long calRangeId, Row row, Set<String> fieldNamesSet) {
        StringBuilder caldimensionSb = new StringBuilder();
        caldimensionSb.append("");
        CostAccount costAccount = this.costAccountMap.get(costaccountId);
        if (costAccount == null) {
            return null;
        }
        Long material = row.getLong("material");
        String malGrouplongNumber = row.getString("materialgrouplnum");
        String spCaldimension = costAccount.getSpCaldimension(calRangeId.toString(), material.toString(), malGrouplongNumber);
        if (spCaldimension == null) {
            return null;
        }
        String caldimensionStr = null;
        String[] spArr = spCaldimension.split("@");
        caldimensionStr = spArr[1];
        if (!StringUtils.isEmpty((CharSequence)caldimensionStr)) {
            String[] caldimensions;
            for (String caldimension : caldimensions = caldimensionStr.split(",")) {
                int fieldIndex;
                Object value;
                String valueStr;
                if (!fieldNamesSet.contains(caldimension) || StringUtils.isEmpty((CharSequence)(valueStr = String.valueOf(value = row.get(fieldIndex = this.sourceRowMeta.getFieldIndex(caldimension)))))) continue;
                caldimensionSb.append(valueStr);
                caldimensionSb.append(",");
            }
        }
        return CommonUtils.trimComma((String)caldimensionSb.toString());
    }
}

